#pragma once

#include "td/tl/TlObject.h"

#include "td/utils/buffer.h"

#include <cstdint>
#include <utility>
#include <vector>

namespace td {
class TlStorerCalcLength;
class TlStorerUnsafe;
class TlStorerToString;
class TlBufferParser;

namespace telegram_api {

using int32 = std::int32_t;
using int53 = std::int64_t;
using int64 = std::int64_t;

using string = std::string;

using bytes = BufferSlice;

template <class Type>
using array = std::vector<Type>;

using BaseObject = ::td::TlObject;

template <class Type>
using object_ptr = ::td::tl_object_ptr<Type>;

template <class Type, class... Args>
object_ptr<Type> make_object(Args &&... args) {
  return object_ptr<Type>(new Type(std::forward<Args>(args)...));
}

template <class ToType, class FromType>
object_ptr<ToType> move_object_as(FromType &&from) {
  return object_ptr<ToType>(static_cast<ToType *>(from.release()));
}

std::string to_string(const BaseObject &value);

template <class T>
std::string to_string(const object_ptr<T> &value) {
  if (value == nullptr) {
    return "null";
  }

  return to_string(*value);
}

template <class T>
std::string to_string(const std::vector<object_ptr<T>> &values) {
  std::string result = "{\n";
  for (const auto &value : values) {
    if (value == nullptr) {
      result += "null\n";
    } else {
      result += to_string(*value);
    }
  }
  result += "}\n";
  return result;
}

class Object: public TlObject {
 public:

  static object_ptr<Object> fetch(TlBufferParser &p);
};

class Function: public TlObject {
 public:
};

class IpPort;

class accessPointRule final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_prefix_rules_;
  int32 dc_id_;
  array<object_ptr<IpPort>> ips_;

  static const std::int32_t ID = 1182381663;

  static object_ptr<accessPointRule> fetch(TlBufferParser &p);

  explicit accessPointRule(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class accountDaysTTL final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 days_;

  explicit accountDaysTTL(int32 days_);

  static const std::int32_t ID = -1194283041;

  static object_ptr<accountDaysTTL> fetch(TlBufferParser &p);

  explicit accountDaysTTL(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AttachMenuPeerType;

class attachMenuBotIcon;

class attachMenuBot final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool inactive_;
  bool has_settings_;
  bool request_write_access_;
  bool show_in_attach_menu_;
  bool show_in_side_menu_;
  bool side_menu_disclaimer_needed_;
  int64 bot_id_;
  string short_name_;
  array<object_ptr<AttachMenuPeerType>> peer_types_;
  array<object_ptr<attachMenuBotIcon>> icons_;

  attachMenuBot();

  static const std::int32_t ID = -653423106;

  static object_ptr<attachMenuBot> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class attachMenuBotIconColor;

class attachMenuBotIcon final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string name_;
  object_ptr<Document> icon_;
  array<object_ptr<attachMenuBotIconColor>> colors_;

  attachMenuBotIcon();

  static const std::int32_t ID = -1297663893;

  static object_ptr<attachMenuBotIcon> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class attachMenuBotIconColor final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  int32 color_;

  static const std::int32_t ID = 1165423600;

  static object_ptr<attachMenuBotIconColor> fetch(TlBufferParser &p);

  explicit attachMenuBotIconColor(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class attachMenuBot;

class AttachMenuBots: public Object {
 public:

  static object_ptr<AttachMenuBots> fetch(TlBufferParser &p);
};

class attachMenuBotsNotModified final : public AttachMenuBots {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -237467044;

  static object_ptr<AttachMenuBots> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class attachMenuBots final : public AttachMenuBots {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<attachMenuBot>> bots_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 1011024320;

  static object_ptr<AttachMenuBots> fetch(TlBufferParser &p);

  explicit attachMenuBots(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class attachMenuBot;

class attachMenuBotsBot final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<attachMenuBot> bot_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1816172929;

  static object_ptr<attachMenuBotsBot> fetch(TlBufferParser &p);

  explicit attachMenuBotsBot(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AttachMenuPeerType: public Object {
 public:

  static object_ptr<AttachMenuPeerType> fetch(TlBufferParser &p);
};

class attachMenuPeerTypeSameBotPM final : public AttachMenuPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2104224014;

  static object_ptr<AttachMenuPeerType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class attachMenuPeerTypeBotPM final : public AttachMenuPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1020528102;

  static object_ptr<AttachMenuPeerType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class attachMenuPeerTypePM final : public AttachMenuPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -247016673;

  static object_ptr<AttachMenuPeerType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class attachMenuPeerTypeChat final : public AttachMenuPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 84480319;

  static object_ptr<AttachMenuPeerType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class attachMenuPeerTypeBroadcast final : public AttachMenuPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2080104188;

  static object_ptr<AttachMenuPeerType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorization final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool current_;
  bool official_app_;
  bool password_pending_;
  bool encrypted_requests_disabled_;
  bool call_requests_disabled_;
  bool unconfirmed_;
  int64 hash_;
  string device_model_;
  string platform_;
  string system_version_;
  int32 api_id_;
  string app_name_;
  string app_version_;
  int32 date_created_;
  int32 date_active_;
  string ip_;
  string country_;
  string region_;

  authorization();

  static const std::int32_t ID = -1392388579;

  static object_ptr<authorization> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autoDownloadSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool disabled_;
  bool video_preload_large_;
  bool audio_preload_next_;
  bool phonecalls_less_data_;
  bool stories_preload_;
  int32 photo_size_max_;
  int64 video_size_max_;
  int64 file_size_max_;
  int32 video_upload_maxbitrate_;
  int32 small_queue_active_operations_max_;
  int32 large_queue_active_operations_max_;
  enum Flags : std::int32_t { DISABLED_MASK = 1, VIDEO_PRELOAD_LARGE_MASK = 2, AUDIO_PRELOAD_NEXT_MASK = 4, PHONECALLS_LESS_DATA_MASK = 8, STORIES_PRELOAD_MASK = 16 };

  autoDownloadSettings();

  autoDownloadSettings(int32 flags_, bool disabled_, bool video_preload_large_, bool audio_preload_next_, bool phonecalls_less_data_, bool stories_preload_, int32 photo_size_max_, int64 video_size_max_, int64 file_size_max_, int32 video_upload_maxbitrate_, int32 small_queue_active_operations_max_, int32 large_queue_active_operations_max_);

  static const std::int32_t ID = -1163561432;

  static object_ptr<autoDownloadSettings> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class autoSaveSettings;

class autoSaveException final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  object_ptr<autoSaveSettings> settings_;

  static const std::int32_t ID = -2124403385;

  static object_ptr<autoSaveException> fetch(TlBufferParser &p);

  explicit autoSaveException(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autoSaveSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool photos_;
  bool videos_;
  int64 video_max_size_;
  enum Flags : std::int32_t { PHOTOS_MASK = 1, VIDEOS_MASK = 2, VIDEO_MAX_SIZE_MASK = 4 };

  autoSaveSettings();

  autoSaveSettings(int32 flags_, bool photos_, bool videos_, int64 video_max_size_);

  static const std::int32_t ID = -934791986;

  static object_ptr<autoSaveSettings> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class availableEffect final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool premium_required_;
  int64 id_;
  string emoticon_;
  int64 static_icon_id_;
  int64 effect_sticker_id_;
  int64 effect_animation_id_;
  enum Flags : std::int32_t { STATIC_ICON_ID_MASK = 1, EFFECT_ANIMATION_ID_MASK = 2 };

  availableEffect();

  static const std::int32_t ID = -1815879042;

  static object_ptr<availableEffect> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class availableReaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool inactive_;
  bool premium_;
  string reaction_;
  string title_;
  object_ptr<Document> static_icon_;
  object_ptr<Document> appear_animation_;
  object_ptr<Document> select_animation_;
  object_ptr<Document> activate_animation_;
  object_ptr<Document> effect_animation_;
  object_ptr<Document> around_animation_;
  object_ptr<Document> center_icon_;

  availableReaction();

  static const std::int32_t ID = -1065882623;

  static object_ptr<availableReaction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class bankCardOpenUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string name_;

  static const std::int32_t ID = -177732982;

  static object_ptr<bankCardOpenUrl> fetch(TlBufferParser &p);

  explicit bankCardOpenUrl(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BaseTheme: public Object {
 public:

  static object_ptr<BaseTheme> fetch(TlBufferParser &p);
};

class baseThemeClassic final : public BaseTheme {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1012849566;

  static object_ptr<BaseTheme> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class baseThemeDay final : public BaseTheme {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -69724536;

  static object_ptr<BaseTheme> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class baseThemeNight final : public BaseTheme {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1212997976;

  static object_ptr<BaseTheme> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class baseThemeTinted final : public BaseTheme {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1834973166;

  static object_ptr<BaseTheme> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class baseThemeArctic final : public BaseTheme {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1527845466;

  static object_ptr<BaseTheme> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class birthday final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 day_;
  int32 month_;
  int32 year_;
  enum Flags : std::int32_t { YEAR_MASK = 1 };

  birthday();

  birthday(int32 flags_, int32 day_, int32 month_, int32 year_);

  static const std::int32_t ID = 1821253126;

  static object_ptr<birthday> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class boost final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool gift_;
  bool giveaway_;
  bool unclaimed_;
  string id_;
  int64 user_id_;
  int32 giveaway_msg_id_;
  int32 date_;
  int32 expires_;
  string used_gift_slug_;
  int32 multiplier_;
  int64 stars_;
  enum Flags : std::int32_t { USER_ID_MASK = 1, GIVEAWAY_MSG_ID_MASK = 4, USED_GIFT_SLUG_MASK = 16, MULTIPLIER_MASK = 32, STARS_MASK = 64 };

  boost();

  static const std::int32_t ID = 1262359766;

  static object_ptr<boost> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class Photo;

class BotApp: public Object {
 public:

  static object_ptr<BotApp> fetch(TlBufferParser &p);
};

class botAppNotModified final : public BotApp {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1571189943;

  static object_ptr<BotApp> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botApp final : public BotApp {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 id_;
  int64 access_hash_;
  string short_name_;
  string title_;
  string description_;
  object_ptr<Photo> photo_;
  object_ptr<Document> document_;
  int64 hash_;

  botApp();

  static const std::int32_t ID = -1778593322;

  static object_ptr<BotApp> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botAppSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bytes placeholder_path_;
  int32 background_color_;
  int32 background_dark_color_;
  int32 header_color_;
  int32 header_dark_color_;
  enum Flags : std::int32_t { PLACEHOLDER_PATH_MASK = 1, BACKGROUND_COLOR_MASK = 2, BACKGROUND_DARK_COLOR_MASK = 4, HEADER_COLOR_MASK = 8, HEADER_DARK_COLOR_MASK = 16 };

  botAppSettings();

  static const std::int32_t ID = -912582320;

  static object_ptr<botAppSettings> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botBusinessConnection final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool can_reply_;
  bool disabled_;
  string connection_id_;
  int64 user_id_;
  int32 dc_id_;
  int32 date_;

  botBusinessConnection();

  static const std::int32_t ID = -1989921868;

  static object_ptr<botBusinessConnection> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommand final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string command_;
  string description_;

  botCommand(string const &command_, string const &description_);

  static const std::int32_t ID = -1032140601;

  static object_ptr<botCommand> fetch(TlBufferParser &p);

  explicit botCommand(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class InputUser;

class BotCommandScope: public Object {
 public:
};

class botCommandScopeDefault final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 795652779;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopeUsers final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1011811544;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopeChats final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1877059713;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopeChatAdmins final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1180016534;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopePeer final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit botCommandScopePeer(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = -610432643;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopePeerAdmins final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit botCommandScopePeerAdmins(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = 1071145937;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopePeerUser final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  object_ptr<InputUser> user_id_;

  botCommandScopePeerUser(object_ptr<InputPeer> &&peer_, object_ptr<InputUser> &&user_id_);

  static const std::int32_t ID = 169026035;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotMenuButton;

class Document;

class Photo;

class botAppSettings;

class botCommand;

class botVerifierSettings;

class botInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool has_preview_medias_;
  int64 user_id_;
  string description_;
  object_ptr<Photo> description_photo_;
  object_ptr<Document> description_document_;
  array<object_ptr<botCommand>> commands_;
  object_ptr<BotMenuButton> menu_button_;
  string privacy_policy_url_;
  object_ptr<botAppSettings> app_settings_;
  object_ptr<botVerifierSettings> verifier_settings_;
  enum Flags : std::int32_t { USER_ID_MASK = 1, DESCRIPTION_MASK = 2, PRIVACY_POLICY_URL_MASK = 128 };

  botInfo();

  static const std::int32_t ID = 1300890265;

  static object_ptr<botInfo> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GeoPoint;

class MessageEntity;

class ReplyMarkup;

class WebDocument;

class BotInlineMessage: public Object {
 public:

  static object_ptr<BotInlineMessage> fetch(TlBufferParser &p);
};

class botInlineMessageMediaAuto final : public BotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool invert_media_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  object_ptr<ReplyMarkup> reply_markup_;

  botInlineMessageMediaAuto();

  static const std::int32_t ID = 1984755728;

  static object_ptr<BotInlineMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botInlineMessageText final : public BotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool no_webpage_;
  bool invert_media_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  object_ptr<ReplyMarkup> reply_markup_;

  botInlineMessageText();

  static const std::int32_t ID = -1937807902;

  static object_ptr<BotInlineMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botInlineMessageMediaGeo final : public BotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<GeoPoint> geo_;
  int32 heading_;
  int32 period_;
  int32 proximity_notification_radius_;
  object_ptr<ReplyMarkup> reply_markup_;
  enum Flags : std::int32_t { HEADING_MASK = 1, PERIOD_MASK = 2, PROXIMITY_NOTIFICATION_RADIUS_MASK = 8 };

  botInlineMessageMediaGeo();

  static const std::int32_t ID = 85477117;

  static object_ptr<BotInlineMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botInlineMessageMediaVenue final : public BotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<GeoPoint> geo_;
  string title_;
  string address_;
  string provider_;
  string venue_id_;
  string venue_type_;
  object_ptr<ReplyMarkup> reply_markup_;

  botInlineMessageMediaVenue();

  static const std::int32_t ID = -1970903652;

  static object_ptr<BotInlineMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botInlineMessageMediaContact final : public BotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string phone_number_;
  string first_name_;
  string last_name_;
  string vcard_;
  object_ptr<ReplyMarkup> reply_markup_;

  botInlineMessageMediaContact();

  static const std::int32_t ID = 416402882;

  static object_ptr<BotInlineMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botInlineMessageMediaInvoice final : public BotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool shipping_address_requested_;
  bool test_;
  string title_;
  string description_;
  object_ptr<WebDocument> photo_;
  string currency_;
  int64 total_amount_;
  object_ptr<ReplyMarkup> reply_markup_;

  botInlineMessageMediaInvoice();

  static const std::int32_t ID = 894081801;

  static object_ptr<BotInlineMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botInlineMessageMediaWebPage final : public BotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool invert_media_;
  bool force_large_media_;
  bool force_small_media_;
  bool manual_;
  bool safe_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  string url_;
  object_ptr<ReplyMarkup> reply_markup_;

  botInlineMessageMediaWebPage();

  static const std::int32_t ID = -2137335386;

  static object_ptr<BotInlineMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotInlineMessage;

class Document;

class Photo;

class WebDocument;

class BotInlineResult: public Object {
 public:

  static object_ptr<BotInlineResult> fetch(TlBufferParser &p);
};

class botInlineResult final : public BotInlineResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string id_;
  string type_;
  string title_;
  string description_;
  string url_;
  object_ptr<WebDocument> thumb_;
  object_ptr<WebDocument> content_;
  object_ptr<BotInlineMessage> send_message_;
  enum Flags : std::int32_t { TITLE_MASK = 2, DESCRIPTION_MASK = 4, URL_MASK = 8 };

  botInlineResult();

  static const std::int32_t ID = 295067450;

  static object_ptr<BotInlineResult> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botInlineMediaResult final : public BotInlineResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string id_;
  string type_;
  object_ptr<Photo> photo_;
  object_ptr<Document> document_;
  string title_;
  string description_;
  object_ptr<BotInlineMessage> send_message_;
  enum Flags : std::int32_t { TITLE_MASK = 4, DESCRIPTION_MASK = 8 };

  botInlineMediaResult();

  static const std::int32_t ID = 400266251;

  static object_ptr<BotInlineResult> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotMenuButton: public Object {
 public:

  static object_ptr<BotMenuButton> fetch(TlBufferParser &p);
};

class botMenuButtonDefault final : public BotMenuButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1966318984;

  static object_ptr<BotMenuButton> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botMenuButtonCommands final : public BotMenuButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1113113093;

  static object_ptr<BotMenuButton> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botMenuButton final : public BotMenuButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  string url_;

  botMenuButton(string const &text_, string const &url_);

  static const std::int32_t ID = -944407322;

  static object_ptr<BotMenuButton> fetch(TlBufferParser &p);

  explicit botMenuButton(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageMedia;

class botPreviewMedia final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 date_;
  object_ptr<MessageMedia> media_;

  static const std::int32_t ID = 602479523;

  static object_ptr<botPreviewMedia> fetch(TlBufferParser &p);

  explicit botPreviewMedia(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botVerification final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 bot_id_;
  int64 icon_;
  string description_;

  static const std::int32_t ID = -113453988;

  static object_ptr<botVerification> fetch(TlBufferParser &p);

  explicit botVerification(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botVerifierSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool can_modify_custom_description_;
  int64 icon_;
  string company_;
  string custom_description_;
  enum Flags : std::int32_t { CUSTOM_DESCRIPTION_MASK = 1 };

  botVerifierSettings();

  static const std::int32_t ID = -1328716265;

  static object_ptr<botVerifierSettings> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class broadcastRevenueBalances final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool withdrawal_enabled_;
  int64 current_balance_;
  int64 available_balance_;
  int64 overall_revenue_;

  broadcastRevenueBalances();

  static const std::int32_t ID = -1006669337;

  static object_ptr<broadcastRevenueBalances> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BroadcastRevenueTransaction: public Object {
 public:

  static object_ptr<BroadcastRevenueTransaction> fetch(TlBufferParser &p);
};

class broadcastRevenueTransactionProceeds final : public BroadcastRevenueTransaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 amount_;
  int32 from_date_;
  int32 to_date_;

  static const std::int32_t ID = 1434332356;

  static object_ptr<BroadcastRevenueTransaction> fetch(TlBufferParser &p);

  explicit broadcastRevenueTransactionProceeds(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class broadcastRevenueTransactionWithdrawal final : public BroadcastRevenueTransaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pending_;
  bool failed_;
  int64 amount_;
  int32 date_;
  string provider_;
  int32 transaction_date_;
  string transaction_url_;
  enum Flags : std::int32_t { TRANSACTION_DATE_MASK = 2, TRANSACTION_URL_MASK = 2 };

  broadcastRevenueTransactionWithdrawal();

  static const std::int32_t ID = 1515784568;

  static object_ptr<BroadcastRevenueTransaction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class broadcastRevenueTransactionRefund final : public BroadcastRevenueTransaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 amount_;
  int32 date_;
  string provider_;

  static const std::int32_t ID = 1121127726;

  static object_ptr<BroadcastRevenueTransaction> fetch(TlBufferParser &p);

  explicit broadcastRevenueTransactionRefund(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BusinessAwayMessageSchedule;

class businessRecipients;

class businessAwayMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool offline_only_;
  int32 shortcut_id_;
  object_ptr<BusinessAwayMessageSchedule> schedule_;
  object_ptr<businessRecipients> recipients_;

  businessAwayMessage();

  static const std::int32_t ID = -283809188;

  static object_ptr<businessAwayMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BusinessAwayMessageSchedule: public Object {
 public:

  static object_ptr<BusinessAwayMessageSchedule> fetch(TlBufferParser &p);
};

class businessAwayMessageScheduleAlways final : public BusinessAwayMessageSchedule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -910564679;

  static object_ptr<BusinessAwayMessageSchedule> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessAwayMessageScheduleOutsideWorkHours final : public BusinessAwayMessageSchedule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1007487743;

  static object_ptr<BusinessAwayMessageSchedule> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessAwayMessageScheduleCustom final : public BusinessAwayMessageSchedule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 start_date_;
  int32 end_date_;

  businessAwayMessageScheduleCustom(int32 start_date_, int32 end_date_);

  static const std::int32_t ID = -867328308;

  static object_ptr<BusinessAwayMessageSchedule> fetch(TlBufferParser &p);

  explicit businessAwayMessageScheduleCustom(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessBotRecipients final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool existing_chats_;
  bool new_chats_;
  bool contacts_;
  bool non_contacts_;
  bool exclude_selected_;
  array<int64> users_;
  array<int64> exclude_users_;

  businessBotRecipients();

  static const std::int32_t ID = -1198722189;

  static object_ptr<businessBotRecipients> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageEntity;

class businessChatLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string link_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  string title_;
  int32 views_;
  enum Flags : std::int32_t { TITLE_MASK = 2 };

  businessChatLink();

  static const std::int32_t ID = -1263638929;

  static object_ptr<businessChatLink> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessRecipients;

class businessGreetingMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  object_ptr<businessRecipients> recipients_;
  int32 no_activity_days_;

  static const std::int32_t ID = -451302485;

  static object_ptr<businessGreetingMessage> fetch(TlBufferParser &p);

  explicit businessGreetingMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class businessIntro final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string title_;
  string description_;
  object_ptr<Document> sticker_;

  businessIntro();

  static const std::int32_t ID = 1510606445;

  static object_ptr<businessIntro> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GeoPoint;

class businessLocation final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<GeoPoint> geo_point_;
  string address_;

  businessLocation();

  static const std::int32_t ID = -1403249929;

  static object_ptr<businessLocation> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessRecipients final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool existing_chats_;
  bool new_chats_;
  bool contacts_;
  bool non_contacts_;
  bool exclude_selected_;
  array<int64> users_;

  businessRecipients();

  static const std::int32_t ID = 554733559;

  static object_ptr<businessRecipients> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessWeeklyOpen final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 start_minute_;
  int32 end_minute_;

  businessWeeklyOpen(int32 start_minute_, int32 end_minute_);

  static const std::int32_t ID = 302717625;

  static object_ptr<businessWeeklyOpen> fetch(TlBufferParser &p);

  explicit businessWeeklyOpen(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessWeeklyOpen;

class businessWorkHours final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool open_now_;
  string timezone_id_;
  array<object_ptr<businessWeeklyOpen>> weekly_open_;
  enum Flags : std::int32_t { OPEN_NOW_MASK = 1 };

  businessWorkHours();

  businessWorkHours(int32 flags_, bool open_now_, string const &timezone_id_, array<object_ptr<businessWeeklyOpen>> &&weekly_open_);

  static const std::int32_t ID = -1936543592;

  static object_ptr<businessWorkHours> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class cdnPublicKey;

class cdnConfig final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<cdnPublicKey>> public_keys_;

  static const std::int32_t ID = 1462101002;

  static object_ptr<cdnConfig> fetch(TlBufferParser &p);

  explicit cdnConfig(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class cdnPublicKey final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 dc_id_;
  string public_key_;

  static const std::int32_t ID = -914167110;

  static object_ptr<cdnPublicKey> fetch(TlBufferParser &p);

  explicit cdnPublicKey(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChannelAdminLogEventAction;

class channelAdminLogEvent final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 date_;
  int64 user_id_;
  object_ptr<ChannelAdminLogEventAction> action_;

  static const std::int32_t ID = 531458253;

  static object_ptr<channelAdminLogEvent> fetch(TlBufferParser &p);

  explicit channelAdminLogEvent(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChannelLocation;

class ChannelParticipant;

class ChatReactions;

class EmojiStatus;

class ExportedChatInvite;

class ForumTopic;

class InputStickerSet;

class Message;

class Photo;

class WallPaper;

class chatBannedRights;

class groupCallParticipant;

class inputGroupCall;

class peerColor;

class ChannelAdminLogEventAction: public Object {
 public:

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);
};

class channelAdminLogEventActionChangeTitle final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string prev_value_;
  string new_value_;

  static const std::int32_t ID = -421545947;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeTitle(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeAbout final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string prev_value_;
  string new_value_;

  static const std::int32_t ID = 1427671598;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeAbout(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeUsername final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string prev_value_;
  string new_value_;

  static const std::int32_t ID = 1783299128;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeUsername(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangePhoto final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Photo> prev_photo_;
  object_ptr<Photo> new_photo_;

  static const std::int32_t ID = 1129042607;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangePhoto(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionToggleInvites final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool new_value_;

  static const std::int32_t ID = 460916654;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionToggleInvites(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionToggleSignatures final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool new_value_;

  static const std::int32_t ID = 648939889;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionToggleSignatures(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionUpdatePinned final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;

  static const std::int32_t ID = -370660328;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionUpdatePinned(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionEditMessage final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> prev_message_;
  object_ptr<Message> new_message_;

  static const std::int32_t ID = 1889215493;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionEditMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionDeleteMessage final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;

  static const std::int32_t ID = 1121994683;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionDeleteMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantJoin final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 405815507;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantLeave final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -124291086;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantInvite final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChannelParticipant> participant_;

  static const std::int32_t ID = -484690728;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionParticipantInvite(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantToggleBan final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChannelParticipant> prev_participant_;
  object_ptr<ChannelParticipant> new_participant_;

  static const std::int32_t ID = -422036098;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionParticipantToggleBan(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantToggleAdmin final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChannelParticipant> prev_participant_;
  object_ptr<ChannelParticipant> new_participant_;

  static const std::int32_t ID = -714643696;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionParticipantToggleAdmin(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeStickerSet final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputStickerSet> prev_stickerset_;
  object_ptr<InputStickerSet> new_stickerset_;

  static const std::int32_t ID = -1312568665;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeStickerSet(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionTogglePreHistoryHidden final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool new_value_;

  static const std::int32_t ID = 1599903217;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionTogglePreHistoryHidden(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionDefaultBannedRights final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatBannedRights> prev_banned_rights_;
  object_ptr<chatBannedRights> new_banned_rights_;

  static const std::int32_t ID = 771095562;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionDefaultBannedRights(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionStopPoll final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;

  static const std::int32_t ID = -1895328189;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionStopPoll(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeLinkedChat final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 prev_value_;
  int64 new_value_;

  static const std::int32_t ID = 84703944;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeLinkedChat(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeLocation final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChannelLocation> prev_value_;
  object_ptr<ChannelLocation> new_value_;

  static const std::int32_t ID = 241923758;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeLocation(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionToggleSlowMode final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 prev_value_;
  int32 new_value_;

  static const std::int32_t ID = 1401984889;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionToggleSlowMode(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionStartGroupCall final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputGroupCall> call_;

  static const std::int32_t ID = 589338437;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionStartGroupCall(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionDiscardGroupCall final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputGroupCall> call_;

  static const std::int32_t ID = -610299584;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionDiscardGroupCall(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantMute final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<groupCallParticipant> participant_;

  static const std::int32_t ID = -115071790;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionParticipantMute(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantUnmute final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<groupCallParticipant> participant_;

  static const std::int32_t ID = -431740480;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionParticipantUnmute(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionToggleGroupCallSetting final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool join_muted_;

  static const std::int32_t ID = 1456906823;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionToggleGroupCallSetting(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantJoinByInvite final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool via_chatlist_;
  object_ptr<ExportedChatInvite> invite_;

  channelAdminLogEventActionParticipantJoinByInvite();

  static const std::int32_t ID = -23084712;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionExportedInviteDelete final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ExportedChatInvite> invite_;

  static const std::int32_t ID = 1515256996;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionExportedInviteDelete(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionExportedInviteRevoke final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ExportedChatInvite> invite_;

  static const std::int32_t ID = 1091179342;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionExportedInviteRevoke(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionExportedInviteEdit final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ExportedChatInvite> prev_invite_;
  object_ptr<ExportedChatInvite> new_invite_;

  static const std::int32_t ID = -384910503;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionExportedInviteEdit(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantVolume final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<groupCallParticipant> participant_;

  static const std::int32_t ID = 1048537159;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionParticipantVolume(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeHistoryTTL final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 prev_value_;
  int32 new_value_;

  static const std::int32_t ID = 1855199800;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeHistoryTTL(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantJoinByRequest final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ExportedChatInvite> invite_;
  int64 approved_by_;

  static const std::int32_t ID = -1347021750;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionParticipantJoinByRequest(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionToggleNoForwards final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool new_value_;

  static const std::int32_t ID = -886388890;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionToggleNoForwards(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionSendMessage final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;

  static const std::int32_t ID = 663693416;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionSendMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeAvailableReactions final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChatReactions> prev_value_;
  object_ptr<ChatReactions> new_value_;

  static const std::int32_t ID = -1102180616;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeAvailableReactions(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeUsernames final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> prev_value_;
  array<string> new_value_;

  static const std::int32_t ID = -263212119;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeUsernames(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionToggleForum final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool new_value_;

  static const std::int32_t ID = 46949251;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionToggleForum(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionCreateTopic final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ForumTopic> topic_;

  static const std::int32_t ID = 1483767080;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionCreateTopic(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionEditTopic final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ForumTopic> prev_topic_;
  object_ptr<ForumTopic> new_topic_;

  static const std::int32_t ID = -261103096;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionEditTopic(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionDeleteTopic final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ForumTopic> topic_;

  static const std::int32_t ID = -1374254839;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionDeleteTopic(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionPinTopic final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<ForumTopic> prev_topic_;
  object_ptr<ForumTopic> new_topic_;

  channelAdminLogEventActionPinTopic();

  static const std::int32_t ID = 1569535291;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionToggleAntiSpam final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool new_value_;

  static const std::int32_t ID = 1693675004;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionToggleAntiSpam(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangePeerColor final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<peerColor> prev_value_;
  object_ptr<peerColor> new_value_;

  static const std::int32_t ID = 1469507456;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangePeerColor(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeProfilePeerColor final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<peerColor> prev_value_;
  object_ptr<peerColor> new_value_;

  static const std::int32_t ID = 1581742885;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeProfilePeerColor(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeWallpaper final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<WallPaper> prev_value_;
  object_ptr<WallPaper> new_value_;

  static const std::int32_t ID = 834362706;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeWallpaper(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeEmojiStatus final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<EmojiStatus> prev_value_;
  object_ptr<EmojiStatus> new_value_;

  static const std::int32_t ID = 1051328177;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeEmojiStatus(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionChangeEmojiStickerSet final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputStickerSet> prev_stickerset_;
  object_ptr<InputStickerSet> new_stickerset_;

  static const std::int32_t ID = 1188577451;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionChangeEmojiStickerSet(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionToggleSignatureProfiles final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool new_value_;

  static const std::int32_t ID = 1621597305;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionToggleSignatureProfiles(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventActionParticipantSubExtend final : public ChannelAdminLogEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChannelParticipant> prev_participant_;
  object_ptr<ChannelParticipant> new_participant_;

  static const std::int32_t ID = 1684286899;

  static object_ptr<ChannelAdminLogEventAction> fetch(TlBufferParser &p);

  explicit channelAdminLogEventActionParticipantSubExtend(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelAdminLogEventsFilter final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool join_;
  bool leave_;
  bool invite_;
  bool ban_;
  bool unban_;
  bool kick_;
  bool unkick_;
  bool promote_;
  bool demote_;
  bool info_;
  bool settings_;
  bool pinned_;
  bool edit_;
  bool delete_;
  bool group_call_;
  bool invites_;
  bool send_;
  bool forums_;
  bool sub_extend_;
  enum Flags : std::int32_t { JOIN_MASK = 1, LEAVE_MASK = 2, INVITE_MASK = 4, BAN_MASK = 8, UNBAN_MASK = 16, KICK_MASK = 32, UNKICK_MASK = 64, PROMOTE_MASK = 128, DEMOTE_MASK = 256, INFO_MASK = 512, SETTINGS_MASK = 1024, PINNED_MASK = 2048, EDIT_MASK = 4096, DELETE_MASK = 8192, GROUP_CALL_MASK = 16384, INVITES_MASK = 32768, SEND_MASK = 65536, FORUMS_MASK = 131072, SUB_EXTEND_MASK = 262144 };

  channelAdminLogEventsFilter(int32 flags_, bool join_, bool leave_, bool invite_, bool ban_, bool unban_, bool kick_, bool unkick_, bool promote_, bool demote_, bool info_, bool settings_, bool pinned_, bool edit_, bool delete_, bool group_call_, bool invites_, bool send_, bool forums_, bool sub_extend_);

  static const std::int32_t ID = -368018716;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GeoPoint;

class ChannelLocation: public Object {
 public:

  static object_ptr<ChannelLocation> fetch(TlBufferParser &p);
};

class channelLocationEmpty final : public ChannelLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1078612597;

  static object_ptr<ChannelLocation> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelLocation final : public ChannelLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<GeoPoint> geo_point_;
  string address_;

  static const std::int32_t ID = 547062491;

  static object_ptr<ChannelLocation> fetch(TlBufferParser &p);

  explicit channelLocation(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageRange;

class ChannelMessagesFilter: public Object {
 public:
};

class channelMessagesFilterEmpty final : public ChannelMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1798033689;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelMessagesFilter final : public ChannelMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool exclude_new_messages_;
  array<object_ptr<messageRange>> ranges_;
  enum Flags : std::int32_t { EXCLUDE_NEW_MESSAGES_MASK = 2 };

  channelMessagesFilter(int32 flags_, bool exclude_new_messages_, array<object_ptr<messageRange>> &&ranges_);

  static const std::int32_t ID = -847783593;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class chatAdminRights;

class chatBannedRights;

class ChannelParticipant: public Object {
 public:

  static object_ptr<ChannelParticipant> fetch(TlBufferParser &p);
};

class channelParticipant final : public ChannelParticipant {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 user_id_;
  int32 date_;
  int32 subscription_until_date_;
  enum Flags : std::int32_t { SUBSCRIPTION_UNTIL_DATE_MASK = 1 };

  channelParticipant();

  static const std::int32_t ID = -885426663;

  static object_ptr<ChannelParticipant> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantSelf final : public ChannelParticipant {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool via_request_;
  int64 user_id_;
  int64 inviter_id_;
  int32 date_;
  int32 subscription_until_date_;
  enum Flags : std::int32_t { SUBSCRIPTION_UNTIL_DATE_MASK = 2 };

  channelParticipantSelf();

  static const std::int32_t ID = 1331723247;

  static object_ptr<ChannelParticipant> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantCreator final : public ChannelParticipant {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 user_id_;
  object_ptr<chatAdminRights> admin_rights_;
  string rank_;
  enum Flags : std::int32_t { RANK_MASK = 1 };

  channelParticipantCreator();

  static const std::int32_t ID = 803602899;

  static object_ptr<ChannelParticipant> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantAdmin final : public ChannelParticipant {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool can_edit_;
  bool self_;
  int64 user_id_;
  int64 inviter_id_;
  int64 promoted_by_;
  int32 date_;
  object_ptr<chatAdminRights> admin_rights_;
  string rank_;
  enum Flags : std::int32_t { INVITER_ID_MASK = 2, RANK_MASK = 4 };

  channelParticipantAdmin();

  static const std::int32_t ID = 885242707;

  static object_ptr<ChannelParticipant> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantBanned final : public ChannelParticipant {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool left_;
  object_ptr<Peer> peer_;
  int64 kicked_by_;
  int32 date_;
  object_ptr<chatBannedRights> banned_rights_;

  channelParticipantBanned();

  static const std::int32_t ID = 1844969806;

  static object_ptr<ChannelParticipant> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantLeft final : public ChannelParticipant {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;

  static const std::int32_t ID = 453242886;

  static object_ptr<ChannelParticipant> fetch(TlBufferParser &p);

  explicit channelParticipantLeft(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChannelParticipantsFilter: public Object {
 public:
};

class channelParticipantsRecent final : public ChannelParticipantsFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -566281095;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantsAdmins final : public ChannelParticipantsFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1268741783;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantsKicked final : public ChannelParticipantsFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string q_;

  explicit channelParticipantsKicked(string const &q_);

  static const std::int32_t ID = -1548400251;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantsBots final : public ChannelParticipantsFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1328445861;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantsBanned final : public ChannelParticipantsFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string q_;

  explicit channelParticipantsBanned(string const &q_);

  static const std::int32_t ID = 338142689;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantsSearch final : public ChannelParticipantsFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string q_;

  explicit channelParticipantsSearch(string const &q_);

  static const std::int32_t ID = 106343499;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantsContacts final : public ChannelParticipantsFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string q_;

  explicit channelParticipantsContacts(string const &q_);

  static const std::int32_t ID = -1150621555;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelParticipantsMentions final : public ChannelParticipantsFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string q_;
  int32 top_msg_id_;
  enum Flags : std::int32_t { Q_MASK = 1, TOP_MSG_ID_MASK = 2 };

  channelParticipantsMentions(int32 flags_, string const &q_, int32 top_msg_id_);

  static const std::int32_t ID = -531931925;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatPhoto;

class EmojiStatus;

class InputChannel;

class chatAdminRights;

class chatBannedRights;

class peerColor;

class restrictionReason;

class username;

class Chat: public Object {
 public:

  static object_ptr<Chat> fetch(TlBufferParser &p);
};

class chatEmpty final : public Chat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;

  static const std::int32_t ID = 693512293;

  static object_ptr<Chat> fetch(TlBufferParser &p);

  explicit chatEmpty(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chat final : public Chat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool creator_;
  bool left_;
  bool deactivated_;
  bool call_active_;
  bool call_not_empty_;
  bool noforwards_;
  int64 id_;
  string title_;
  object_ptr<ChatPhoto> photo_;
  int32 participants_count_;
  int32 date_;
  int32 version_;
  object_ptr<InputChannel> migrated_to_;
  object_ptr<chatAdminRights> admin_rights_;
  object_ptr<chatBannedRights> default_banned_rights_;

  chat();

  static const std::int32_t ID = 1103884886;

  static object_ptr<Chat> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatForbidden final : public Chat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  string title_;

  static const std::int32_t ID = 1704108455;

  static object_ptr<Chat> fetch(TlBufferParser &p);

  explicit chatForbidden(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channel final : public Chat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool creator_;
  bool left_;
  bool broadcast_;
  bool verified_;
  bool megagroup_;
  bool restricted_;
  bool signatures_;
  bool min_;
  bool scam_;
  bool has_link_;
  bool has_geo_;
  bool slowmode_enabled_;
  bool call_active_;
  bool call_not_empty_;
  bool fake_;
  bool gigagroup_;
  bool noforwards_;
  bool join_to_send_;
  bool join_request_;
  bool forum_;
  int32 flags2_;
  bool stories_hidden_;
  bool stories_hidden_min_;
  bool stories_unavailable_;
  bool signature_profiles_;
  int64 id_;
  int64 access_hash_;
  string title_;
  string username_;
  object_ptr<ChatPhoto> photo_;
  int32 date_;
  array<object_ptr<restrictionReason>> restriction_reason_;
  object_ptr<chatAdminRights> admin_rights_;
  object_ptr<chatBannedRights> banned_rights_;
  object_ptr<chatBannedRights> default_banned_rights_;
  int32 participants_count_;
  array<object_ptr<username>> usernames_;
  int32 stories_max_id_;
  object_ptr<peerColor> color_;
  object_ptr<peerColor> profile_color_;
  object_ptr<EmojiStatus> emoji_status_;
  int32 level_;
  int32 subscription_until_date_;
  int64 bot_verification_icon_;
  enum Flags : std::int32_t { ACCESS_HASH_MASK = 8192, USERNAME_MASK = 64, PARTICIPANTS_COUNT_MASK = 131072, STORIES_MAX_ID_MASK = 16, LEVEL_MASK = 1024, SUBSCRIPTION_UNTIL_DATE_MASK = 2048, BOT_VERIFICATION_ICON_MASK = 8192 };

  channel();

  static const std::int32_t ID = -536241993;

  static object_ptr<Chat> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelForbidden final : public Chat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool broadcast_;
  bool megagroup_;
  int64 id_;
  int64 access_hash_;
  string title_;
  int32 until_date_;
  enum Flags : std::int32_t { UNTIL_DATE_MASK = 65536 };

  channelForbidden();

  channelForbidden(int32 flags_, bool broadcast_, bool megagroup_, int64 id_, int64 access_hash_, string const &title_, int32 until_date_);

  static const std::int32_t ID = 399807445;

  static object_ptr<Chat> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatAdminRights final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool change_info_;
  bool post_messages_;
  bool edit_messages_;
  bool delete_messages_;
  bool ban_users_;
  bool invite_users_;
  bool pin_messages_;
  bool add_admins_;
  bool anonymous_;
  bool manage_call_;
  bool other_;
  bool manage_topics_;
  bool post_stories_;
  bool edit_stories_;
  bool delete_stories_;
  enum Flags : std::int32_t { CHANGE_INFO_MASK = 1, POST_MESSAGES_MASK = 2, EDIT_MESSAGES_MASK = 4, DELETE_MESSAGES_MASK = 8, BAN_USERS_MASK = 16, INVITE_USERS_MASK = 32, PIN_MESSAGES_MASK = 128, ADD_ADMINS_MASK = 512, ANONYMOUS_MASK = 1024, MANAGE_CALL_MASK = 2048, OTHER_MASK = 4096, MANAGE_TOPICS_MASK = 8192, POST_STORIES_MASK = 16384, EDIT_STORIES_MASK = 32768, DELETE_STORIES_MASK = 65536 };

  chatAdminRights();

  chatAdminRights(int32 flags_, bool change_info_, bool post_messages_, bool edit_messages_, bool delete_messages_, bool ban_users_, bool invite_users_, bool pin_messages_, bool add_admins_, bool anonymous_, bool manage_call_, bool other_, bool manage_topics_, bool post_stories_, bool edit_stories_, bool delete_stories_);

  static const std::int32_t ID = 1605510357;

  static object_ptr<chatAdminRights> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatAdminWithInvites final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 admin_id_;
  int32 invites_count_;
  int32 revoked_invites_count_;

  static const std::int32_t ID = -219353309;

  static object_ptr<chatAdminWithInvites> fetch(TlBufferParser &p);

  explicit chatAdminWithInvites(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBannedRights final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool view_messages_;
  bool send_messages_;
  bool send_media_;
  bool send_stickers_;
  bool send_gifs_;
  bool send_games_;
  bool send_inline_;
  bool embed_links_;
  bool send_polls_;
  bool change_info_;
  bool invite_users_;
  bool pin_messages_;
  bool manage_topics_;
  bool send_photos_;
  bool send_videos_;
  bool send_roundvideos_;
  bool send_audios_;
  bool send_voices_;
  bool send_docs_;
  bool send_plain_;
  int32 until_date_;
  enum Flags : std::int32_t { VIEW_MESSAGES_MASK = 1, SEND_MESSAGES_MASK = 2, SEND_MEDIA_MASK = 4, SEND_STICKERS_MASK = 8, SEND_GIFS_MASK = 16, SEND_GAMES_MASK = 32, SEND_INLINE_MASK = 64, EMBED_LINKS_MASK = 128, SEND_POLLS_MASK = 256, CHANGE_INFO_MASK = 1024, INVITE_USERS_MASK = 32768, PIN_MESSAGES_MASK = 131072, MANAGE_TOPICS_MASK = 262144, SEND_PHOTOS_MASK = 524288, SEND_VIDEOS_MASK = 1048576, SEND_ROUNDVIDEOS_MASK = 2097152, SEND_AUDIOS_MASK = 4194304, SEND_VOICES_MASK = 8388608, SEND_DOCS_MASK = 16777216, SEND_PLAIN_MASK = 33554432 };

  chatBannedRights();

  chatBannedRights(int32 flags_, bool view_messages_, bool send_messages_, bool send_media_, bool send_stickers_, bool send_gifs_, bool send_games_, bool send_inline_, bool embed_links_, bool send_polls_, bool change_info_, bool invite_users_, bool pin_messages_, bool manage_topics_, bool send_photos_, bool send_videos_, bool send_roundvideos_, bool send_audios_, bool send_voices_, bool send_docs_, bool send_plain_, int32 until_date_);

  static const std::int32_t ID = -1626209256;

  static object_ptr<chatBannedRights> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChannelLocation;

class ChatParticipants;

class ChatReactions;

class ExportedChatInvite;

class Peer;

class Photo;

class WallPaper;

class botInfo;

class botVerification;

class inputGroupCall;

class peerNotifySettings;

class peerStories;

class stickerSet;

class ChatFull: public Object {
 public:

  static object_ptr<ChatFull> fetch(TlBufferParser &p);
};

class chatFull final : public ChatFull {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool can_set_username_;
  bool has_scheduled_;
  bool translations_disabled_;
  int64 id_;
  string about_;
  object_ptr<ChatParticipants> participants_;
  object_ptr<Photo> chat_photo_;
  object_ptr<peerNotifySettings> notify_settings_;
  object_ptr<ExportedChatInvite> exported_invite_;
  array<object_ptr<botInfo>> bot_info_;
  int32 pinned_msg_id_;
  int32 folder_id_;
  object_ptr<inputGroupCall> call_;
  int32 ttl_period_;
  object_ptr<Peer> groupcall_default_join_as_;
  string theme_emoticon_;
  int32 requests_pending_;
  array<int64> recent_requesters_;
  object_ptr<ChatReactions> available_reactions_;
  int32 reactions_limit_;
  enum Flags : std::int32_t { PINNED_MSG_ID_MASK = 64, FOLDER_ID_MASK = 2048, TTL_PERIOD_MASK = 16384, THEME_EMOTICON_MASK = 65536, REQUESTS_PENDING_MASK = 131072, REACTIONS_LIMIT_MASK = 1048576 };

  chatFull();

  static const std::int32_t ID = 640893467;

  static object_ptr<ChatFull> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channelFull final : public ChatFull {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool can_view_participants_;
  bool can_set_username_;
  bool can_set_stickers_;
  bool hidden_prehistory_;
  bool can_set_location_;
  bool has_scheduled_;
  bool can_view_stats_;
  bool blocked_;
  int32 flags2_;
  bool can_delete_channel_;
  bool antispam_;
  bool participants_hidden_;
  bool translations_disabled_;
  bool stories_pinned_available_;
  bool view_forum_as_messages_;
  bool restricted_sponsored_;
  bool can_view_revenue_;
  bool paid_media_allowed_;
  bool can_view_stars_revenue_;
  bool paid_reactions_available_;
  bool stargifts_available_;
  int64 id_;
  string about_;
  int32 participants_count_;
  int32 admins_count_;
  int32 kicked_count_;
  int32 banned_count_;
  int32 online_count_;
  int32 read_inbox_max_id_;
  int32 read_outbox_max_id_;
  int32 unread_count_;
  object_ptr<Photo> chat_photo_;
  object_ptr<peerNotifySettings> notify_settings_;
  object_ptr<ExportedChatInvite> exported_invite_;
  array<object_ptr<botInfo>> bot_info_;
  int64 migrated_from_chat_id_;
  int32 migrated_from_max_id_;
  int32 pinned_msg_id_;
  object_ptr<stickerSet> stickerset_;
  int32 available_min_id_;
  int32 folder_id_;
  int64 linked_chat_id_;
  object_ptr<ChannelLocation> location_;
  int32 slowmode_seconds_;
  int32 slowmode_next_send_date_;
  int32 stats_dc_;
  int32 pts_;
  object_ptr<inputGroupCall> call_;
  int32 ttl_period_;
  array<string> pending_suggestions_;
  object_ptr<Peer> groupcall_default_join_as_;
  string theme_emoticon_;
  int32 requests_pending_;
  array<int64> recent_requesters_;
  object_ptr<Peer> default_send_as_;
  object_ptr<ChatReactions> available_reactions_;
  int32 reactions_limit_;
  object_ptr<peerStories> stories_;
  object_ptr<WallPaper> wallpaper_;
  int32 boosts_applied_;
  int32 boosts_unrestrict_;
  object_ptr<stickerSet> emojiset_;
  object_ptr<botVerification> bot_verification_;
  int32 stargifts_count_;
  enum Flags : std::int32_t { PARTICIPANTS_COUNT_MASK = 1, ADMINS_COUNT_MASK = 2, KICKED_COUNT_MASK = 4, BANNED_COUNT_MASK = 4, ONLINE_COUNT_MASK = 8192, MIGRATED_FROM_CHAT_ID_MASK = 16, MIGRATED_FROM_MAX_ID_MASK = 16, PINNED_MSG_ID_MASK = 32, AVAILABLE_MIN_ID_MASK = 512, FOLDER_ID_MASK = 2048, LINKED_CHAT_ID_MASK = 16384, SLOWMODE_SECONDS_MASK = 131072, SLOWMODE_NEXT_SEND_DATE_MASK = 262144, STATS_DC_MASK = 4096, TTL_PERIOD_MASK = 16777216, THEME_EMOTICON_MASK = 134217728, REQUESTS_PENDING_MASK = 268435456, REACTIONS_LIMIT_MASK = 8192, BOOSTS_APPLIED_MASK = 256, BOOSTS_UNRESTRICT_MASK = 512, STARGIFTS_COUNT_MASK = 262144 };

  channelFull();

  static const std::int32_t ID = 1389789291;

  static object_ptr<ChatFull> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Photo;

class User;

class botVerification;

class starsSubscriptionPricing;

class ChatInvite: public Object {
 public:

  static object_ptr<ChatInvite> fetch(TlBufferParser &p);
};

class chatInviteAlready final : public ChatInvite {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Chat> chat_;

  static const std::int32_t ID = 1516793212;

  static object_ptr<ChatInvite> fetch(TlBufferParser &p);

  explicit chatInviteAlready(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInvite final : public ChatInvite {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool channel_;
  bool broadcast_;
  bool public_;
  bool megagroup_;
  bool request_needed_;
  bool verified_;
  bool scam_;
  bool fake_;
  bool can_refulfill_subscription_;
  string title_;
  string about_;
  object_ptr<Photo> photo_;
  int32 participants_count_;
  array<object_ptr<User>> participants_;
  int32 color_;
  object_ptr<starsSubscriptionPricing> subscription_pricing_;
  int64 subscription_form_id_;
  object_ptr<botVerification> bot_verification_;
  enum Flags : std::int32_t { ABOUT_MASK = 32, SUBSCRIPTION_FORM_ID_MASK = 4096 };

  chatInvite();

  static const std::int32_t ID = 1553807106;

  static object_ptr<ChatInvite> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInvitePeek final : public ChatInvite {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Chat> chat_;
  int32 expires_;

  static const std::int32_t ID = 1634294960;

  static object_ptr<ChatInvite> fetch(TlBufferParser &p);

  explicit chatInvitePeek(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteImporter final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool requested_;
  bool via_chatlist_;
  int64 user_id_;
  int32 date_;
  string about_;
  int64 approved_by_;
  enum Flags : std::int32_t { ABOUT_MASK = 4, APPROVED_BY_MASK = 2 };

  chatInviteImporter();

  static const std::int32_t ID = -1940201511;

  static object_ptr<chatInviteImporter> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatOnlines final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 onlines_;

  static const std::int32_t ID = -264117680;

  static object_ptr<chatOnlines> fetch(TlBufferParser &p);

  explicit chatOnlines(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatParticipant: public Object {
 public:

  static object_ptr<ChatParticipant> fetch(TlBufferParser &p);
};

class chatParticipant final : public ChatParticipant {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  int64 inviter_id_;
  int32 date_;

  static const std::int32_t ID = -1070776313;

  static object_ptr<ChatParticipant> fetch(TlBufferParser &p);

  explicit chatParticipant(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatParticipantCreator final : public ChatParticipant {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;

  static const std::int32_t ID = -462696732;

  static object_ptr<ChatParticipant> fetch(TlBufferParser &p);

  explicit chatParticipantCreator(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatParticipantAdmin final : public ChatParticipant {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  int64 inviter_id_;
  int32 date_;

  static const std::int32_t ID = -1600962725;

  static object_ptr<ChatParticipant> fetch(TlBufferParser &p);

  explicit chatParticipantAdmin(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatParticipant;

class ChatParticipants: public Object {
 public:

  static object_ptr<ChatParticipants> fetch(TlBufferParser &p);
};

class chatParticipantsForbidden final : public ChatParticipants {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 chat_id_;
  object_ptr<ChatParticipant> self_participant_;

  chatParticipantsForbidden();

  static const std::int32_t ID = -2023500831;

  static object_ptr<ChatParticipants> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatParticipants final : public ChatParticipants {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;
  array<object_ptr<ChatParticipant>> participants_;
  int32 version_;

  static const std::int32_t ID = 1018991608;

  static object_ptr<ChatParticipants> fetch(TlBufferParser &p);

  explicit chatParticipants(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatPhoto: public Object {
 public:

  static object_ptr<ChatPhoto> fetch(TlBufferParser &p);
};

class chatPhotoEmpty final : public ChatPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 935395612;

  static object_ptr<ChatPhoto> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatPhoto final : public ChatPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool has_video_;
  int64 photo_id_;
  bytes stripped_thumb_;
  int32 dc_id_;
  enum Flags : std::int32_t { STRIPPED_THUMB_MASK = 2 };

  chatPhoto();

  static const std::int32_t ID = 476978193;

  static object_ptr<ChatPhoto> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Reaction;

class ChatReactions: public Object {
 public:

  static object_ptr<ChatReactions> fetch(TlBufferParser &p);
};

class chatReactionsNone final : public ChatReactions {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -352570692;

  static object_ptr<ChatReactions> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatReactionsAll final : public ChatReactions {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool allow_custom_;
  enum Flags : std::int32_t { ALLOW_CUSTOM_MASK = 1 };

  chatReactionsAll();

  chatReactionsAll(int32 flags_, bool allow_custom_);

  static const std::int32_t ID = 1385335754;

  static object_ptr<ChatReactions> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatReactionsSome final : public ChatReactions {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Reaction>> reactions_;

  explicit chatReactionsSome(array<object_ptr<Reaction>> &&reactions_);

  static const std::int32_t ID = 1713193015;

  static object_ptr<ChatReactions> fetch(TlBufferParser &p);

  explicit chatReactionsSome(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class codeSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool allow_flashcall_;
  bool current_number_;
  bool allow_app_hash_;
  bool allow_missed_call_;
  bool allow_firebase_;
  bool unknown_number_;
  array<bytes> logout_tokens_;
  string token_;
  bool app_sandbox_;
  enum Flags : std::int32_t { ALLOW_FLASHCALL_MASK = 1, CURRENT_NUMBER_MASK = 2, ALLOW_APP_HASH_MASK = 16, ALLOW_MISSED_CALL_MASK = 32, ALLOW_FIREBASE_MASK = 128, UNKNOWN_NUMBER_MASK = 512, LOGOUT_TOKENS_MASK = 64, TOKEN_MASK = 256, APP_SANDBOX_MASK = 256 };

  codeSettings(int32 flags_, bool allow_flashcall_, bool current_number_, bool allow_app_hash_, bool allow_missed_call_, bool allow_firebase_, bool unknown_number_, array<bytes> &&logout_tokens_, string const &token_, bool app_sandbox_);

  static const std::int32_t ID = -1390068360;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Reaction;

class dcOption;

class config final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool default_p2p_contacts_;
  bool preload_featured_stickers_;
  bool revoke_pm_inbox_;
  bool blocked_mode_;
  bool force_try_ipv6_;
  int32 date_;
  int32 expires_;
  bool test_mode_;
  int32 this_dc_;
  array<object_ptr<dcOption>> dc_options_;
  string dc_txt_domain_name_;
  int32 chat_size_max_;
  int32 megagroup_size_max_;
  int32 forwarded_count_max_;
  int32 online_update_period_ms_;
  int32 offline_blur_timeout_ms_;
  int32 offline_idle_timeout_ms_;
  int32 online_cloud_timeout_ms_;
  int32 notify_cloud_delay_ms_;
  int32 notify_default_delay_ms_;
  int32 push_chat_period_ms_;
  int32 push_chat_limit_;
  int32 edit_time_limit_;
  int32 revoke_time_limit_;
  int32 revoke_pm_time_limit_;
  int32 rating_e_decay_;
  int32 stickers_recent_limit_;
  int32 channels_read_media_period_;
  int32 tmp_sessions_;
  int32 call_receive_timeout_ms_;
  int32 call_ring_timeout_ms_;
  int32 call_connect_timeout_ms_;
  int32 call_packet_timeout_ms_;
  string me_url_prefix_;
  string autoupdate_url_prefix_;
  string gif_search_username_;
  string venue_search_username_;
  string img_search_username_;
  string static_maps_provider_;
  int32 caption_length_max_;
  int32 message_length_max_;
  int32 webfile_dc_id_;
  string suggested_lang_code_;
  int32 lang_pack_version_;
  int32 base_lang_pack_version_;
  object_ptr<Reaction> reactions_default_;
  string autologin_token_;
  enum Flags : std::int32_t { TMP_SESSIONS_MASK = 1, AUTOUPDATE_URL_PREFIX_MASK = 128, GIF_SEARCH_USERNAME_MASK = 512, VENUE_SEARCH_USERNAME_MASK = 1024, IMG_SEARCH_USERNAME_MASK = 2048, STATIC_MAPS_PROVIDER_MASK = 4096, SUGGESTED_LANG_CODE_MASK = 4, LANG_PACK_VERSION_MASK = 4, BASE_LANG_PACK_VERSION_MASK = 4, AUTOLOGIN_TOKEN_MASK = 65536 };

  config();

  static const std::int32_t ID = -870702050;

  static object_ptr<config> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessBotRecipients;

class connectedBot final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool can_reply_;
  int64 bot_id_;
  object_ptr<businessBotRecipients> recipients_;

  connectedBot();

  static const std::int32_t ID = -1123645951;

  static object_ptr<connectedBot> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class connectedBotStarRef final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool revoked_;
  string url_;
  int32 date_;
  int64 bot_id_;
  int32 commission_permille_;
  int32 duration_months_;
  int64 participants_;
  int64 revenue_;
  enum Flags : std::int32_t { DURATION_MONTHS_MASK = 1 };

  connectedBotStarRef();

  static const std::int32_t ID = 429997937;

  static object_ptr<connectedBotStarRef> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class contact final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  bool mutual_;

  static const std::int32_t ID = 341499403;

  static object_ptr<contact> fetch(TlBufferParser &p);

  explicit contact(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class birthday;

class contactBirthday final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 contact_id_;
  object_ptr<birthday> birthday_;

  static const std::int32_t ID = 496600883;

  static object_ptr<contactBirthday> fetch(TlBufferParser &p);

  explicit contactBirthday(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class UserStatus;

class contactStatus final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  object_ptr<UserStatus> status_;

  static const std::int32_t ID = 383348795;

  static object_ptr<contactStatus> fetch(TlBufferParser &p);

  explicit contactStatus(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dataJSON final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string data_;

  explicit dataJSON(string const &data_);

  static const std::int32_t ID = 2104790276;

  static object_ptr<dataJSON> fetch(TlBufferParser &p);

  explicit dataJSON(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dcOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool ipv6_;
  bool media_only_;
  bool tcpo_only_;
  bool cdn_;
  bool static_;
  bool this_port_only_;
  int32 id_;
  string ip_address_;
  int32 port_;
  bytes secret_;
  enum Flags : std::int32_t { SECRET_MASK = 1024 };

  dcOption();

  static const std::int32_t ID = 414687501;

  static object_ptr<dcOption> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class defaultHistoryTTL final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 period_;

  static const std::int32_t ID = 1135897376;

  static object_ptr<defaultHistoryTTL> fetch(TlBufferParser &p);

  explicit defaultHistoryTTL(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class DraftMessage;

class Peer;

class folder;

class peerNotifySettings;

class Dialog: public Object {
 public:

  static object_ptr<Dialog> fetch(TlBufferParser &p);
};

class dialog final : public Dialog {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pinned_;
  bool unread_mark_;
  bool view_forum_as_messages_;
  object_ptr<Peer> peer_;
  int32 top_message_;
  int32 read_inbox_max_id_;
  int32 read_outbox_max_id_;
  int32 unread_count_;
  int32 unread_mentions_count_;
  int32 unread_reactions_count_;
  object_ptr<peerNotifySettings> notify_settings_;
  int32 pts_;
  object_ptr<DraftMessage> draft_;
  int32 folder_id_;
  int32 ttl_period_;
  enum Flags : std::int32_t { PTS_MASK = 1, FOLDER_ID_MASK = 16, TTL_PERIOD_MASK = 32 };

  dialog();

  static const std::int32_t ID = -712374074;

  static object_ptr<Dialog> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dialogFolder final : public Dialog {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pinned_;
  object_ptr<folder> folder_;
  object_ptr<Peer> peer_;
  int32 top_message_;
  int32 unread_muted_peers_count_;
  int32 unread_unmuted_peers_count_;
  int32 unread_muted_messages_count_;
  int32 unread_unmuted_messages_count_;

  dialogFolder();

  static const std::int32_t ID = 1908216652;

  static object_ptr<Dialog> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class textWithEntities;

class DialogFilter: public Object {
 public:

  static object_ptr<DialogFilter> fetch(TlBufferParser &p);
};

class dialogFilter final : public DialogFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool contacts_;
  bool non_contacts_;
  bool groups_;
  bool broadcasts_;
  bool bots_;
  bool exclude_muted_;
  bool exclude_read_;
  bool exclude_archived_;
  bool title_noanimate_;
  int32 id_;
  object_ptr<textWithEntities> title_;
  string emoticon_;
  int32 color_;
  array<object_ptr<InputPeer>> pinned_peers_;
  array<object_ptr<InputPeer>> include_peers_;
  array<object_ptr<InputPeer>> exclude_peers_;
  enum Flags : std::int32_t { CONTACTS_MASK = 1, NON_CONTACTS_MASK = 2, GROUPS_MASK = 4, BROADCASTS_MASK = 8, BOTS_MASK = 16, EXCLUDE_MUTED_MASK = 2048, EXCLUDE_READ_MASK = 4096, EXCLUDE_ARCHIVED_MASK = 8192, TITLE_NOANIMATE_MASK = 268435456, EMOTICON_MASK = 33554432, COLOR_MASK = 134217728 };

  dialogFilter();

  dialogFilter(int32 flags_, bool contacts_, bool non_contacts_, bool groups_, bool broadcasts_, bool bots_, bool exclude_muted_, bool exclude_read_, bool exclude_archived_, bool title_noanimate_, int32 id_, object_ptr<textWithEntities> &&title_, string const &emoticon_, int32 color_, array<object_ptr<InputPeer>> &&pinned_peers_, array<object_ptr<InputPeer>> &&include_peers_, array<object_ptr<InputPeer>> &&exclude_peers_);

  static const std::int32_t ID = -1438177711;

  static object_ptr<DialogFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dialogFilterDefault final : public DialogFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 909284270;

  static object_ptr<DialogFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dialogFilterChatlist final : public DialogFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool has_my_invites_;
  bool title_noanimate_;
  int32 id_;
  object_ptr<textWithEntities> title_;
  string emoticon_;
  int32 color_;
  array<object_ptr<InputPeer>> pinned_peers_;
  array<object_ptr<InputPeer>> include_peers_;
  enum Flags : std::int32_t { HAS_MY_INVITES_MASK = 67108864, TITLE_NOANIMATE_MASK = 268435456, EMOTICON_MASK = 33554432, COLOR_MASK = 134217728 };

  dialogFilterChatlist();

  dialogFilterChatlist(int32 flags_, bool has_my_invites_, bool title_noanimate_, int32 id_, object_ptr<textWithEntities> &&title_, string const &emoticon_, int32 color_, array<object_ptr<InputPeer>> &&pinned_peers_, array<object_ptr<InputPeer>> &&include_peers_);

  static const std::int32_t ID = -1772913705;

  static object_ptr<DialogFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class DialogFilter;

class dialogFilterSuggested final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<DialogFilter> filter_;
  string description_;

  static const std::int32_t ID = 2004110666;

  static object_ptr<dialogFilterSuggested> fetch(TlBufferParser &p);

  explicit dialogFilterSuggested(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class DialogPeer: public Object {
 public:

  static object_ptr<DialogPeer> fetch(TlBufferParser &p);
};

class dialogPeer final : public DialogPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;

  static const std::int32_t ID = -445792507;

  static object_ptr<DialogPeer> fetch(TlBufferParser &p);

  explicit dialogPeer(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dialogPeerFolder final : public DialogPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 folder_id_;

  static const std::int32_t ID = 1363483106;

  static object_ptr<DialogPeer> fetch(TlBufferParser &p);

  explicit dialogPeerFolder(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class DocumentAttribute;

class PhotoSize;

class VideoSize;

class Document: public Object {
 public:

  static object_ptr<Document> fetch(TlBufferParser &p);
};

class documentEmpty final : public Document {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;

  static const std::int32_t ID = 922273905;

  static object_ptr<Document> fetch(TlBufferParser &p);

  explicit documentEmpty(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class document final : public Document {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 id_;
  int64 access_hash_;
  bytes file_reference_;
  int32 date_;
  string mime_type_;
  int64 size_;
  array<object_ptr<PhotoSize>> thumbs_;
  array<object_ptr<VideoSize>> video_thumbs_;
  int32 dc_id_;
  array<object_ptr<DocumentAttribute>> attributes_;

  document();

  document(int32 flags_, int64 id_, int64 access_hash_, bytes &&file_reference_, int32 date_, string const &mime_type_, int64 size_, array<object_ptr<PhotoSize>> &&thumbs_, array<object_ptr<VideoSize>> &&video_thumbs_, int32 dc_id_, array<object_ptr<DocumentAttribute>> &&attributes_);

  static const std::int32_t ID = -1881881384;

  static object_ptr<Document> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputStickerSet;

class maskCoords;

class DocumentAttribute: public Object {
 public:

  static object_ptr<DocumentAttribute> fetch(TlBufferParser &p);
};

class documentAttributeImageSize final : public DocumentAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 w_;
  int32 h_;

  documentAttributeImageSize(int32 w_, int32 h_);

  static const std::int32_t ID = 1815593308;

  static object_ptr<DocumentAttribute> fetch(TlBufferParser &p);

  explicit documentAttributeImageSize(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class documentAttributeAnimated final : public DocumentAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 297109817;

  static object_ptr<DocumentAttribute> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class documentAttributeSticker final : public DocumentAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool mask_;
  string alt_;
  object_ptr<InputStickerSet> stickerset_;
  object_ptr<maskCoords> mask_coords_;
  enum Flags : std::int32_t { MASK_MASK = 2, MASK_COORDS_MASK = 1 };

  documentAttributeSticker();

  documentAttributeSticker(int32 flags_, bool mask_, string const &alt_, object_ptr<InputStickerSet> &&stickerset_, object_ptr<maskCoords> &&mask_coords_);

  static const std::int32_t ID = 1662637586;

  static object_ptr<DocumentAttribute> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class documentAttributeVideo final : public DocumentAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool round_message_;
  bool supports_streaming_;
  bool nosound_;
  double duration_;
  int32 w_;
  int32 h_;
  int32 preload_prefix_size_;
  double video_start_ts_;
  string video_codec_;
  enum Flags : std::int32_t { ROUND_MESSAGE_MASK = 1, SUPPORTS_STREAMING_MASK = 2, NOSOUND_MASK = 8, PRELOAD_PREFIX_SIZE_MASK = 4, VIDEO_START_TS_MASK = 16, VIDEO_CODEC_MASK = 32 };

  documentAttributeVideo();

  documentAttributeVideo(int32 flags_, bool round_message_, bool supports_streaming_, bool nosound_, double duration_, int32 w_, int32 h_, int32 preload_prefix_size_, double video_start_ts_, string const &video_codec_);

  static const std::int32_t ID = 1137015880;

  static object_ptr<DocumentAttribute> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class documentAttributeAudio final : public DocumentAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool voice_;
  int32 duration_;
  string title_;
  string performer_;
  bytes waveform_;
  enum Flags : std::int32_t { VOICE_MASK = 1024, TITLE_MASK = 1, PERFORMER_MASK = 2, WAVEFORM_MASK = 4 };

  documentAttributeAudio();

  documentAttributeAudio(int32 flags_, bool voice_, int32 duration_, string const &title_, string const &performer_, bytes &&waveform_);

  static const std::int32_t ID = -1739392570;

  static object_ptr<DocumentAttribute> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class documentAttributeFilename final : public DocumentAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string file_name_;

  explicit documentAttributeFilename(string const &file_name_);

  static const std::int32_t ID = 358154344;

  static object_ptr<DocumentAttribute> fetch(TlBufferParser &p);

  explicit documentAttributeFilename(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class documentAttributeHasStickers final : public DocumentAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1744710921;

  static object_ptr<DocumentAttribute> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class documentAttributeCustomEmoji final : public DocumentAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool free_;
  bool text_color_;
  string alt_;
  object_ptr<InputStickerSet> stickerset_;
  enum Flags : std::int32_t { FREE_MASK = 1, TEXT_COLOR_MASK = 2 };

  documentAttributeCustomEmoji();

  documentAttributeCustomEmoji(int32 flags_, bool free_, bool text_color_, string const &alt_, object_ptr<InputStickerSet> &&stickerset_);

  static const std::int32_t ID = -48981863;

  static object_ptr<DocumentAttribute> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMedia;

class InputReplyTo;

class MessageEntity;

class DraftMessage: public Object {
 public:

  static object_ptr<DraftMessage> fetch(TlBufferParser &p);
};

class draftMessageEmpty final : public DraftMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 date_;
  enum Flags : std::int32_t { DATE_MASK = 1 };

  draftMessageEmpty();

  static const std::int32_t ID = 453805082;

  static object_ptr<DraftMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class draftMessage final : public DraftMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool no_webpage_;
  bool invert_media_;
  object_ptr<InputReplyTo> reply_to_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  object_ptr<InputMedia> media_;
  int32 date_;
  int64 effect_;
  enum Flags : std::int32_t { EFFECT_MASK = 128 };

  draftMessage();

  static const std::int32_t ID = 761606687;

  static object_ptr<DraftMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmailVerification: public Object {
 public:
};

class emailVerificationCode final : public EmailVerification {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  explicit emailVerificationCode(string const &code_);

  static const std::int32_t ID = -1842457175;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emailVerificationGoogle final : public EmailVerification {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  explicit emailVerificationGoogle(string const &token_);

  static const std::int32_t ID = -611279166;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emailVerificationApple final : public EmailVerification {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  explicit emailVerificationApple(string const &token_);

  static const std::int32_t ID = -1764723459;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmailVerifyPurpose: public Object {
 public:
};

class emailVerifyPurposeLoginSetup final : public EmailVerifyPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  string phone_code_hash_;

  emailVerifyPurposeLoginSetup(string const &phone_number_, string const &phone_code_hash_);

  static const std::int32_t ID = 1128644211;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emailVerifyPurposeLoginChange final : public EmailVerifyPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1383932651;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emailVerifyPurposePassport final : public EmailVerifyPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1141565819;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiGroup: public Object {
 public:

  static object_ptr<EmojiGroup> fetch(TlBufferParser &p);
};

class emojiGroup final : public EmojiGroup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  int64 icon_emoji_id_;
  array<string> emoticons_;

  static const std::int32_t ID = 2056961449;

  static object_ptr<EmojiGroup> fetch(TlBufferParser &p);

  explicit emojiGroup(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiGroupGreeting final : public EmojiGroup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  int64 icon_emoji_id_;
  array<string> emoticons_;

  static const std::int32_t ID = -2133693241;

  static object_ptr<EmojiGroup> fetch(TlBufferParser &p);

  explicit emojiGroupGreeting(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiGroupPremium final : public EmojiGroup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  int64 icon_emoji_id_;

  static const std::int32_t ID = 154914612;

  static object_ptr<EmojiGroup> fetch(TlBufferParser &p);

  explicit emojiGroupPremium(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiKeyword: public Object {
 public:

  static object_ptr<EmojiKeyword> fetch(TlBufferParser &p);
};

class emojiKeyword final : public EmojiKeyword {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string keyword_;
  array<string> emoticons_;

  static const std::int32_t ID = -709641735;

  static object_ptr<EmojiKeyword> fetch(TlBufferParser &p);

  explicit emojiKeyword(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiKeywordDeleted final : public EmojiKeyword {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string keyword_;
  array<string> emoticons_;

  static const std::int32_t ID = 594408994;

  static object_ptr<EmojiKeyword> fetch(TlBufferParser &p);

  explicit emojiKeywordDeleted(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiKeyword;

class emojiKeywordsDifference final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_code_;
  int32 from_version_;
  int32 version_;
  array<object_ptr<EmojiKeyword>> keywords_;

  static const std::int32_t ID = 1556570557;

  static object_ptr<emojiKeywordsDifference> fetch(TlBufferParser &p);

  explicit emojiKeywordsDifference(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiLanguage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_code_;

  static const std::int32_t ID = -1275374751;

  static object_ptr<emojiLanguage> fetch(TlBufferParser &p);

  explicit emojiLanguage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiList: public Object {
 public:

  static object_ptr<EmojiList> fetch(TlBufferParser &p);
};

class emojiListNotModified final : public EmojiList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1209970170;

  static object_ptr<EmojiList> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiList final : public EmojiList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<int64> document_id_;

  static const std::int32_t ID = 2048790993;

  static object_ptr<EmojiList> fetch(TlBufferParser &p);

  explicit emojiList(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiStatus: public Object {
 public:

  static object_ptr<EmojiStatus> fetch(TlBufferParser &p);
};

class emojiStatusEmpty final : public EmojiStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 769727150;

  static object_ptr<EmojiStatus> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatus final : public EmojiStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 document_id_;
  int32 until_;
  enum Flags : std::int32_t { UNTIL_MASK = 1 };

  emojiStatus();

  emojiStatus(int32 flags_, int64 document_id_, int32 until_);

  static const std::int32_t ID = -402717046;

  static object_ptr<EmojiStatus> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatusCollectible final : public EmojiStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 collectible_id_;
  int64 document_id_;
  string title_;
  string slug_;
  int64 pattern_document_id_;
  int32 center_color_;
  int32 edge_color_;
  int32 pattern_color_;
  int32 text_color_;
  int32 until_;
  enum Flags : std::int32_t { UNTIL_MASK = 1 };

  emojiStatusCollectible();

  emojiStatusCollectible(int32 flags_, int64 collectible_id_, int64 document_id_, string const &title_, string const &slug_, int64 pattern_document_id_, int32 center_color_, int32 edge_color_, int32 pattern_color_, int32 text_color_, int32 until_);

  static const std::int32_t ID = 1904500795;

  static object_ptr<EmojiStatus> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputEmojiStatusCollectible final : public EmojiStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 collectible_id_;
  int32 until_;
  enum Flags : std::int32_t { UNTIL_MASK = 1 };

  inputEmojiStatusCollectible();

  inputEmojiStatusCollectible(int32 flags_, int64 collectible_id_, int32 until_);

  static const std::int32_t ID = 118758847;

  static object_ptr<EmojiStatus> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiURL final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  static const std::int32_t ID = -1519029347;

  static object_ptr<emojiURL> fetch(TlBufferParser &p);

  explicit emojiURL(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EncryptedChat: public Object {
 public:

  static object_ptr<EncryptedChat> fetch(TlBufferParser &p);
};

class encryptedChatEmpty final : public EncryptedChat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;

  static const std::int32_t ID = -1417756512;

  static object_ptr<EncryptedChat> fetch(TlBufferParser &p);

  explicit encryptedChatEmpty(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class encryptedChatWaiting final : public EncryptedChat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int64 access_hash_;
  int32 date_;
  int64 admin_id_;
  int64 participant_id_;

  encryptedChatWaiting(int32 id_, int64 access_hash_, int32 date_, int64 admin_id_, int64 participant_id_);

  static const std::int32_t ID = 1722964307;

  static object_ptr<EncryptedChat> fetch(TlBufferParser &p);

  explicit encryptedChatWaiting(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class encryptedChatRequested final : public EncryptedChat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 folder_id_;
  int32 id_;
  int64 access_hash_;
  int32 date_;
  int64 admin_id_;
  int64 participant_id_;
  bytes g_a_;
  enum Flags : std::int32_t { FOLDER_ID_MASK = 1 };

  encryptedChatRequested();

  encryptedChatRequested(int32 flags_, int32 folder_id_, int32 id_, int64 access_hash_, int32 date_, int64 admin_id_, int64 participant_id_, bytes &&g_a_);

  static const std::int32_t ID = 1223809356;

  static object_ptr<EncryptedChat> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class encryptedChat final : public EncryptedChat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int64 access_hash_;
  int32 date_;
  int64 admin_id_;
  int64 participant_id_;
  bytes g_a_or_b_;
  int64 key_fingerprint_;

  encryptedChat(int32 id_, int64 access_hash_, int32 date_, int64 admin_id_, int64 participant_id_, bytes &&g_a_or_b_, int64 key_fingerprint_);

  static const std::int32_t ID = 1643173063;

  static object_ptr<EncryptedChat> fetch(TlBufferParser &p);

  explicit encryptedChat(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class encryptedChatDiscarded final : public EncryptedChat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool history_deleted_;
  int32 id_;

  encryptedChatDiscarded();

  static const std::int32_t ID = 505183301;

  static object_ptr<EncryptedChat> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EncryptedFile: public Object {
 public:

  static object_ptr<EncryptedFile> fetch(TlBufferParser &p);
};

class encryptedFileEmpty final : public EncryptedFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1038136962;

  static object_ptr<EncryptedFile> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class encryptedFile final : public EncryptedFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;
  int64 size_;
  int32 dc_id_;
  int32 key_fingerprint_;

  static const std::int32_t ID = -1476358952;

  static object_ptr<EncryptedFile> fetch(TlBufferParser &p);

  explicit encryptedFile(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EncryptedFile;

class EncryptedMessage: public Object {
 public:

  static object_ptr<EncryptedMessage> fetch(TlBufferParser &p);
};

class encryptedMessage final : public EncryptedMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 random_id_;
  int32 chat_id_;
  int32 date_;
  bytes bytes_;
  object_ptr<EncryptedFile> file_;

  static const std::int32_t ID = -317144808;

  static object_ptr<EncryptedMessage> fetch(TlBufferParser &p);

  explicit encryptedMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class encryptedMessageService final : public EncryptedMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 random_id_;
  int32 chat_id_;
  int32 date_;
  bytes bytes_;

  static const std::int32_t ID = 594758406;

  static object_ptr<EncryptedMessage> fetch(TlBufferParser &p);

  explicit encryptedMessageService(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class error final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 code_;
  string text_;

  static const std::int32_t ID = -994444869;

  static object_ptr<error> fetch(TlBufferParser &p);

  explicit error(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsSubscriptionPricing;

class ExportedChatInvite: public Object {
 public:

  static object_ptr<ExportedChatInvite> fetch(TlBufferParser &p);
};

class chatInviteExported final : public ExportedChatInvite {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool revoked_;
  bool permanent_;
  bool request_needed_;
  string link_;
  int64 admin_id_;
  int32 date_;
  int32 start_date_;
  int32 expire_date_;
  int32 usage_limit_;
  int32 usage_;
  int32 requested_;
  int32 subscription_expired_;
  string title_;
  object_ptr<starsSubscriptionPricing> subscription_pricing_;
  enum Flags : std::int32_t { START_DATE_MASK = 16, EXPIRE_DATE_MASK = 2, USAGE_LIMIT_MASK = 4, USAGE_MASK = 8, REQUESTED_MASK = 128, SUBSCRIPTION_EXPIRED_MASK = 1024, TITLE_MASK = 256 };

  chatInviteExported();

  static const std::int32_t ID = -1574126186;

  static object_ptr<ExportedChatInvite> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInvitePublicJoinRequests final : public ExportedChatInvite {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -317687113;

  static object_ptr<ExportedChatInvite> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class exportedChatlistInvite final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string title_;
  string url_;
  array<object_ptr<Peer>> peers_;

  exportedChatlistInvite();

  static const std::int32_t ID = 206668204;

  static object_ptr<exportedChatlistInvite> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class exportedContactToken final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int32 expires_;

  static const std::int32_t ID = 1103040667;

  static object_ptr<exportedContactToken> fetch(TlBufferParser &p);

  explicit exportedContactToken(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class exportedMessageLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;
  string html_;

  static const std::int32_t ID = 1571494644;

  static object_ptr<exportedMessageLink> fetch(TlBufferParser &p);

  explicit exportedMessageLink(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class exportedStoryLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;

  static const std::int32_t ID = 1070138683;

  static object_ptr<exportedStoryLink> fetch(TlBufferParser &p);

  explicit exportedStoryLink(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textWithEntities;

class factCheck final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool need_check_;
  string country_;
  object_ptr<textWithEntities> text_;
  int64 hash_;
  enum Flags : std::int32_t { COUNTRY_MASK = 2 };

  factCheck();

  static const std::int32_t ID = -1197736753;

  static object_ptr<factCheck> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileHash final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 offset_;
  int32 limit_;
  bytes hash_;

  static const std::int32_t ID = -207944868;

  static object_ptr<fileHash> fetch(TlBufferParser &p);

  explicit fileHash(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatPhoto;

class folder final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool autofill_new_broadcasts_;
  bool autofill_public_groups_;
  bool autofill_new_correspondents_;
  int32 id_;
  string title_;
  object_ptr<ChatPhoto> photo_;

  folder();

  static const std::int32_t ID = -11252123;

  static object_ptr<folder> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class folderPeer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 folder_id_;

  static const std::int32_t ID = -373643672;

  static object_ptr<folderPeer> fetch(TlBufferParser &p);

  explicit folderPeer(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class DraftMessage;

class Peer;

class peerNotifySettings;

class ForumTopic: public Object {
 public:

  static object_ptr<ForumTopic> fetch(TlBufferParser &p);
};

class forumTopicDeleted final : public ForumTopic {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;

  static const std::int32_t ID = 37687451;

  static object_ptr<ForumTopic> fetch(TlBufferParser &p);

  explicit forumTopicDeleted(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class forumTopic final : public ForumTopic {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool my_;
  bool closed_;
  bool pinned_;
  bool short_;
  bool hidden_;
  int32 id_;
  int32 date_;
  string title_;
  int32 icon_color_;
  int64 icon_emoji_id_;
  int32 top_message_;
  int32 read_inbox_max_id_;
  int32 read_outbox_max_id_;
  int32 unread_count_;
  int32 unread_mentions_count_;
  int32 unread_reactions_count_;
  object_ptr<Peer> from_id_;
  object_ptr<peerNotifySettings> notify_settings_;
  object_ptr<DraftMessage> draft_;
  enum Flags : std::int32_t { ICON_EMOJI_ID_MASK = 1 };

  forumTopic();

  static const std::int32_t ID = 1903173033;

  static object_ptr<ForumTopic> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class StoryItem;

class foundStory final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  object_ptr<StoryItem> story_;

  static const std::int32_t ID = -394605632;

  static object_ptr<foundStory> fetch(TlBufferParser &p);

  explicit foundStory(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class Photo;

class game final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 id_;
  int64 access_hash_;
  string short_name_;
  string title_;
  string description_;
  object_ptr<Photo> photo_;
  object_ptr<Document> document_;

  game();

  static const std::int32_t ID = -1107729093;

  static object_ptr<game> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GeoPoint: public Object {
 public:

  static object_ptr<GeoPoint> fetch(TlBufferParser &p);
};

class geoPointEmpty final : public GeoPoint {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 286776671;

  static object_ptr<GeoPoint> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class geoPoint final : public GeoPoint {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  double long_;
  double lat_;
  int64 access_hash_;
  int32 accuracy_radius_;
  enum Flags : std::int32_t { ACCURACY_RADIUS_MASK = 1 };

  geoPoint();

  geoPoint(int32 flags_, double long_, double lat_, int64 access_hash_, int32 accuracy_radius_);

  static const std::int32_t ID = -1297942941;

  static object_ptr<GeoPoint> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class geoPointAddress final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string country_iso2_;
  string state_;
  string city_;
  string street_;
  enum Flags : std::int32_t { STATE_MASK = 1, CITY_MASK = 2, STREET_MASK = 4 };

  geoPointAddress();

  geoPointAddress(int32 flags_, string const &country_iso2_, string const &state_, string const &city_, string const &street_);

  static const std::int32_t ID = -565420653;

  static object_ptr<geoPointAddress> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class globalPrivacySettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool archive_and_mute_new_noncontact_peers_;
  bool keep_archived_unmuted_;
  bool keep_archived_folders_;
  bool hide_read_marks_;
  bool new_noncontact_peers_require_premium_;
  enum Flags : std::int32_t { ARCHIVE_AND_MUTE_NEW_NONCONTACT_PEERS_MASK = 1, KEEP_ARCHIVED_UNMUTED_MASK = 2, KEEP_ARCHIVED_FOLDERS_MASK = 4, HIDE_READ_MARKS_MASK = 8, NEW_NONCONTACT_PEERS_REQUIRE_PREMIUM_MASK = 16 };

  globalPrivacySettings();

  globalPrivacySettings(int32 flags_, bool archive_and_mute_new_noncontact_peers_, bool keep_archived_unmuted_, bool keep_archived_folders_, bool hide_read_marks_, bool new_noncontact_peers_require_premium_);

  static const std::int32_t ID = 1934380235;

  static object_ptr<globalPrivacySettings> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GroupCall: public Object {
 public:

  static object_ptr<GroupCall> fetch(TlBufferParser &p);
};

class groupCallDiscarded final : public GroupCall {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;
  int32 duration_;

  static const std::int32_t ID = 2004925620;

  static object_ptr<GroupCall> fetch(TlBufferParser &p);

  explicit groupCallDiscarded(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCall final : public GroupCall {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool join_muted_;
  bool can_change_join_muted_;
  bool join_date_asc_;
  bool schedule_start_subscribed_;
  bool can_start_video_;
  bool record_video_active_;
  bool rtmp_stream_;
  bool listeners_hidden_;
  int64 id_;
  int64 access_hash_;
  int32 participants_count_;
  string title_;
  int32 stream_dc_id_;
  int32 record_start_date_;
  int32 schedule_date_;
  int32 unmuted_video_count_;
  int32 unmuted_video_limit_;
  int32 version_;
  int64 conference_from_call_;
  enum Flags : std::int32_t { TITLE_MASK = 8, STREAM_DC_ID_MASK = 16, RECORD_START_DATE_MASK = 32, SCHEDULE_DATE_MASK = 128, UNMUTED_VIDEO_COUNT_MASK = 1024, CONFERENCE_FROM_CALL_MASK = 16384 };

  groupCall();

  static const std::int32_t ID = -839330845;

  static object_ptr<GroupCall> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class groupCallParticipantVideo;

class groupCallParticipant final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool muted_;
  bool left_;
  bool can_self_unmute_;
  bool just_joined_;
  bool versioned_;
  bool min_;
  bool muted_by_you_;
  bool volume_by_admin_;
  bool self_;
  bool video_joined_;
  object_ptr<Peer> peer_;
  int32 date_;
  int32 active_date_;
  int32 source_;
  int32 volume_;
  string about_;
  int64 raise_hand_rating_;
  object_ptr<groupCallParticipantVideo> video_;
  object_ptr<groupCallParticipantVideo> presentation_;
  enum Flags : std::int32_t { ACTIVE_DATE_MASK = 8, VOLUME_MASK = 128, ABOUT_MASK = 2048, RAISE_HAND_RATING_MASK = 8192 };

  groupCallParticipant();

  static const std::int32_t ID = -341428482;

  static object_ptr<groupCallParticipant> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallParticipantVideoSourceGroup;

class groupCallParticipantVideo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool paused_;
  string endpoint_;
  array<object_ptr<groupCallParticipantVideoSourceGroup>> source_groups_;
  int32 audio_source_;
  enum Flags : std::int32_t { AUDIO_SOURCE_MASK = 2 };

  groupCallParticipantVideo();

  static const std::int32_t ID = 1735736008;

  static object_ptr<groupCallParticipantVideo> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallParticipantVideoSourceGroup final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string semantics_;
  array<int32> sources_;

  static const std::int32_t ID = -592373577;

  static object_ptr<groupCallParticipantVideoSourceGroup> fetch(TlBufferParser &p);

  explicit groupCallParticipantVideoSourceGroup(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallStreamChannel final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 channel_;
  int32 scale_;
  int64 last_timestamp_ms_;

  static const std::int32_t ID = -2132064081;

  static object_ptr<groupCallStreamChannel> fetch(TlBufferParser &p);

  explicit groupCallStreamChannel(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class highScore final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 pos_;
  int64 user_id_;
  int32 score_;

  static const std::int32_t ID = 1940093419;

  static object_ptr<highScore> fetch(TlBufferParser &p);

  explicit highScore(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class importedContact final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  int64 client_id_;

  static const std::int32_t ID = -1052885936;

  static object_ptr<importedContact> fetch(TlBufferParser &p);

  explicit importedContact(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineBotSwitchPM final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  string start_param_;

  inlineBotSwitchPM(string const &text_, string const &start_param_);

  static const std::int32_t ID = 1008755359;

  static object_ptr<inlineBotSwitchPM> fetch(TlBufferParser &p);

  explicit inlineBotSwitchPM(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineBotWebView final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  string url_;

  inlineBotWebView(string const &text_, string const &url_);

  static const std::int32_t ID = -1250781739;

  static object_ptr<inlineBotWebView> fetch(TlBufferParser &p);

  explicit inlineBotWebView(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InlineQueryPeerType: public Object {
 public:

  static object_ptr<InlineQueryPeerType> fetch(TlBufferParser &p);
};

class inlineQueryPeerTypeSameBotPM final : public InlineQueryPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 813821341;

  static object_ptr<InlineQueryPeerType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryPeerTypePM final : public InlineQueryPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -2093215828;

  static object_ptr<InlineQueryPeerType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryPeerTypeChat final : public InlineQueryPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -681130742;

  static object_ptr<InlineQueryPeerType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryPeerTypeMegagroup final : public InlineQueryPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1589952067;

  static object_ptr<InlineQueryPeerType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryPeerTypeBroadcast final : public InlineQueryPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1664413338;

  static object_ptr<InlineQueryPeerType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryPeerTypeBotPM final : public InlineQueryPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 238759180;

  static object_ptr<InlineQueryPeerType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class JSONValue;

class inputAppEvent final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double time_;
  string type_;
  int64 peer_;
  object_ptr<JSONValue> data_;

  inputAppEvent(double time_, string const &type_, int64 peer_, object_ptr<JSONValue> &&data_);

  static const std::int32_t ID = 488313413;

  static object_ptr<inputAppEvent> fetch(TlBufferParser &p);

  explicit inputAppEvent(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputUser;

class InputBotApp: public Object {
 public:
};

class inputBotAppID final : public InputBotApp {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputBotAppID(int64 id_, int64 access_hash_);

  static const std::int32_t ID = -1457472134;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotAppShortName final : public InputBotApp {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_id_;
  string short_name_;

  inputBotAppShortName(object_ptr<InputUser> &&bot_id_, string const &short_name_);

  static const std::int32_t ID = -1869872121;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputGeoPoint;

class MessageEntity;

class ReplyMarkup;

class dataJSON;

class inputWebDocument;

class invoice;

class InputBotInlineMessage: public Object {
 public:
};

class inputBotInlineMessageMediaAuto final : public InputBotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool invert_media_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  object_ptr<ReplyMarkup> reply_markup_;
  enum Flags : std::int32_t { INVERT_MEDIA_MASK = 8, ENTITIES_MASK = 2, REPLY_MARKUP_MASK = 4 };

  inputBotInlineMessageMediaAuto(int32 flags_, bool invert_media_, string const &message_, array<object_ptr<MessageEntity>> &&entities_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = 864077702;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineMessageText final : public InputBotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool no_webpage_;
  bool invert_media_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  object_ptr<ReplyMarkup> reply_markup_;
  enum Flags : std::int32_t { NO_WEBPAGE_MASK = 1, INVERT_MEDIA_MASK = 8, ENTITIES_MASK = 2, REPLY_MARKUP_MASK = 4 };

  inputBotInlineMessageText(int32 flags_, bool no_webpage_, bool invert_media_, string const &message_, array<object_ptr<MessageEntity>> &&entities_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = 1036876423;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineMessageMediaGeo final : public InputBotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputGeoPoint> geo_point_;
  int32 heading_;
  int32 period_;
  int32 proximity_notification_radius_;
  object_ptr<ReplyMarkup> reply_markup_;
  enum Flags : std::int32_t { HEADING_MASK = 1, PERIOD_MASK = 2, PROXIMITY_NOTIFICATION_RADIUS_MASK = 8, REPLY_MARKUP_MASK = 4 };

  inputBotInlineMessageMediaGeo(int32 flags_, object_ptr<InputGeoPoint> &&geo_point_, int32 heading_, int32 period_, int32 proximity_notification_radius_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = -1768777083;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineMessageMediaVenue final : public InputBotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputGeoPoint> geo_point_;
  string title_;
  string address_;
  string provider_;
  string venue_id_;
  string venue_type_;
  object_ptr<ReplyMarkup> reply_markup_;
  enum Flags : std::int32_t { REPLY_MARKUP_MASK = 4 };

  inputBotInlineMessageMediaVenue(int32 flags_, object_ptr<InputGeoPoint> &&geo_point_, string const &title_, string const &address_, string const &provider_, string const &venue_id_, string const &venue_type_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = 1098628881;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineMessageMediaContact final : public InputBotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string phone_number_;
  string first_name_;
  string last_name_;
  string vcard_;
  object_ptr<ReplyMarkup> reply_markup_;
  enum Flags : std::int32_t { REPLY_MARKUP_MASK = 4 };

  inputBotInlineMessageMediaContact(int32 flags_, string const &phone_number_, string const &first_name_, string const &last_name_, string const &vcard_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = -1494368259;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineMessageGame final : public InputBotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<ReplyMarkup> reply_markup_;
  enum Flags : std::int32_t { REPLY_MARKUP_MASK = 4 };

  inputBotInlineMessageGame(int32 flags_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = 1262639204;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineMessageMediaInvoice final : public InputBotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string title_;
  string description_;
  object_ptr<inputWebDocument> photo_;
  object_ptr<invoice> invoice_;
  bytes payload_;
  string provider_;
  object_ptr<dataJSON> provider_data_;
  object_ptr<ReplyMarkup> reply_markup_;
  enum Flags : std::int32_t { PHOTO_MASK = 1, REPLY_MARKUP_MASK = 4 };

  inputBotInlineMessageMediaInvoice(int32 flags_, string const &title_, string const &description_, object_ptr<inputWebDocument> &&photo_, object_ptr<invoice> &&invoice_, bytes &&payload_, string const &provider_, object_ptr<dataJSON> &&provider_data_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = -672693723;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineMessageMediaWebPage final : public InputBotInlineMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool invert_media_;
  bool force_large_media_;
  bool force_small_media_;
  bool optional_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  string url_;
  object_ptr<ReplyMarkup> reply_markup_;
  enum Flags : std::int32_t { INVERT_MEDIA_MASK = 8, FORCE_LARGE_MEDIA_MASK = 16, FORCE_SMALL_MEDIA_MASK = 32, OPTIONAL_MASK = 64, ENTITIES_MASK = 2, REPLY_MARKUP_MASK = 4 };

  inputBotInlineMessageMediaWebPage(int32 flags_, bool invert_media_, bool force_large_media_, bool force_small_media_, bool optional_, string const &message_, array<object_ptr<MessageEntity>> &&entities_, string const &url_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = -1109605104;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputBotInlineMessageID: public Object {
 public:

  static object_ptr<InputBotInlineMessageID> fetch(TlBufferParser &p);
};

class inputBotInlineMessageID final : public InputBotInlineMessageID {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 dc_id_;
  int64 id_;
  int64 access_hash_;

  inputBotInlineMessageID(int32 dc_id_, int64 id_, int64 access_hash_);

  static const std::int32_t ID = -1995686519;

  static object_ptr<InputBotInlineMessageID> fetch(TlBufferParser &p);

  explicit inputBotInlineMessageID(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineMessageID64 final : public InputBotInlineMessageID {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 dc_id_;
  int64 owner_id_;
  int32 id_;
  int64 access_hash_;

  inputBotInlineMessageID64(int32 dc_id_, int64 owner_id_, int32 id_, int64 access_hash_);

  static const std::int32_t ID = -1227287081;

  static object_ptr<InputBotInlineMessageID> fetch(TlBufferParser &p);

  explicit inputBotInlineMessageID64(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputBotInlineMessage;

class InputDocument;

class InputPhoto;

class inputWebDocument;

class InputBotInlineResult: public Object {
 public:
};

class inputBotInlineResult final : public InputBotInlineResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string id_;
  string type_;
  string title_;
  string description_;
  string url_;
  object_ptr<inputWebDocument> thumb_;
  object_ptr<inputWebDocument> content_;
  object_ptr<InputBotInlineMessage> send_message_;
  enum Flags : std::int32_t { TITLE_MASK = 2, DESCRIPTION_MASK = 4, URL_MASK = 8, THUMB_MASK = 16, CONTENT_MASK = 32 };

  inputBotInlineResult(int32 flags_, string const &id_, string const &type_, string const &title_, string const &description_, string const &url_, object_ptr<inputWebDocument> &&thumb_, object_ptr<inputWebDocument> &&content_, object_ptr<InputBotInlineMessage> &&send_message_);

  static const std::int32_t ID = -2000710887;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineResultPhoto final : public InputBotInlineResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string type_;
  object_ptr<InputPhoto> photo_;
  object_ptr<InputBotInlineMessage> send_message_;

  inputBotInlineResultPhoto(string const &id_, string const &type_, object_ptr<InputPhoto> &&photo_, object_ptr<InputBotInlineMessage> &&send_message_);

  static const std::int32_t ID = -1462213465;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineResultDocument final : public InputBotInlineResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string id_;
  string type_;
  string title_;
  string description_;
  object_ptr<InputDocument> document_;
  object_ptr<InputBotInlineMessage> send_message_;
  enum Flags : std::int32_t { TITLE_MASK = 2, DESCRIPTION_MASK = 4 };

  inputBotInlineResultDocument(int32 flags_, string const &id_, string const &type_, string const &title_, string const &description_, object_ptr<InputDocument> &&document_, object_ptr<InputBotInlineMessage> &&send_message_);

  static const std::int32_t ID = -459324;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBotInlineResultGame final : public InputBotInlineResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string short_name_;
  object_ptr<InputBotInlineMessage> send_message_;

  inputBotInlineResultGame(string const &id_, string const &short_name_, object_ptr<InputBotInlineMessage> &&send_message_);

  static const std::int32_t ID = 1336154098;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BusinessAwayMessageSchedule;

class inputBusinessRecipients;

class inputBusinessAwayMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool offline_only_;
  int32 shortcut_id_;
  object_ptr<BusinessAwayMessageSchedule> schedule_;
  object_ptr<inputBusinessRecipients> recipients_;
  enum Flags : std::int32_t { OFFLINE_ONLY_MASK = 1 };

  inputBusinessAwayMessage(int32 flags_, bool offline_only_, int32 shortcut_id_, object_ptr<BusinessAwayMessageSchedule> &&schedule_, object_ptr<inputBusinessRecipients> &&recipients_);

  static const std::int32_t ID = -2094959136;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputUser;

class inputBusinessBotRecipients final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool existing_chats_;
  bool new_chats_;
  bool contacts_;
  bool non_contacts_;
  bool exclude_selected_;
  array<object_ptr<InputUser>> users_;
  array<object_ptr<InputUser>> exclude_users_;
  enum Flags : std::int32_t { EXISTING_CHATS_MASK = 1, NEW_CHATS_MASK = 2, CONTACTS_MASK = 4, NON_CONTACTS_MASK = 8, EXCLUDE_SELECTED_MASK = 32, USERS_MASK = 16, EXCLUDE_USERS_MASK = 64 };

  inputBusinessBotRecipients(int32 flags_, bool existing_chats_, bool new_chats_, bool contacts_, bool non_contacts_, bool exclude_selected_, array<object_ptr<InputUser>> &&users_, array<object_ptr<InputUser>> &&exclude_users_);

  static const std::int32_t ID = -991587810;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageEntity;

class inputBusinessChatLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  string title_;
  enum Flags : std::int32_t { ENTITIES_MASK = 1, TITLE_MASK = 2 };

  inputBusinessChatLink(int32 flags_, string const &message_, array<object_ptr<MessageEntity>> &&entities_, string const &title_);

  static const std::int32_t ID = 292003751;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBusinessRecipients;

class inputBusinessGreetingMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  object_ptr<inputBusinessRecipients> recipients_;
  int32 no_activity_days_;

  inputBusinessGreetingMessage(int32 shortcut_id_, object_ptr<inputBusinessRecipients> &&recipients_, int32 no_activity_days_);

  static const std::int32_t ID = 26528571;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputDocument;

class inputBusinessIntro final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string title_;
  string description_;
  object_ptr<InputDocument> sticker_;
  enum Flags : std::int32_t { STICKER_MASK = 1 };

  inputBusinessIntro(int32 flags_, string const &title_, string const &description_, object_ptr<InputDocument> &&sticker_);

  static const std::int32_t ID = 163867085;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputUser;

class inputBusinessRecipients final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool existing_chats_;
  bool new_chats_;
  bool contacts_;
  bool non_contacts_;
  bool exclude_selected_;
  array<object_ptr<InputUser>> users_;
  enum Flags : std::int32_t { EXISTING_CHATS_MASK = 1, NEW_CHATS_MASK = 2, CONTACTS_MASK = 4, NON_CONTACTS_MASK = 8, EXCLUDE_SELECTED_MASK = 32, USERS_MASK = 16 };

  inputBusinessRecipients(int32 flags_, bool existing_chats_, bool new_chats_, bool contacts_, bool non_contacts_, bool exclude_selected_, array<object_ptr<InputUser>> &&users_);

  static const std::int32_t ID = 1871393450;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class InputChannel: public Object {
 public:

  static object_ptr<InputChannel> fetch(TlBufferParser &p);
};

class inputChannelEmpty final : public InputChannel {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -292807034;

  static object_ptr<InputChannel> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputChannel final : public InputChannel {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;
  int64 access_hash_;

  inputChannel(int64 channel_id_, int64 access_hash_);

  static const std::int32_t ID = -212145112;

  static object_ptr<InputChannel> fetch(TlBufferParser &p);

  explicit inputChannel(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputChannelFromMessage final : public InputChannel {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;
  int64 channel_id_;

  inputChannelFromMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_, int64 channel_id_);

  static const std::int32_t ID = 1536380829;

  static object_ptr<InputChannel> fetch(TlBufferParser &p);

  explicit inputChannelFromMessage(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class InputPhoto;

class VideoSize;

class InputChatPhoto: public Object {
 public:
};

class inputChatPhotoEmpty final : public InputChatPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 480546647;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputChatUploadedPhoto final : public InputChatPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputFile> file_;
  object_ptr<InputFile> video_;
  double video_start_ts_;
  object_ptr<VideoSize> video_emoji_markup_;
  enum Flags : std::int32_t { FILE_MASK = 1, VIDEO_MASK = 2, VIDEO_START_TS_MASK = 4, VIDEO_EMOJI_MARKUP_MASK = 8 };

  inputChatUploadedPhoto(int32 flags_, object_ptr<InputFile> &&file_, object_ptr<InputFile> &&video_, double video_start_ts_, object_ptr<VideoSize> &&video_emoji_markup_);

  static const std::int32_t ID = -1110593856;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputChatPhoto final : public InputChatPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPhoto> id_;

  explicit inputChatPhoto(object_ptr<InputPhoto> &&id_);

  static const std::int32_t ID = -1991004873;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputChatlistDialogFilter final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 filter_id_;

  explicit inputChatlistDialogFilter(int32 filter_id_);

  static const std::int32_t ID = -203367885;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputCheckPasswordSRP: public Object {
 public:
};

class inputCheckPasswordEmpty final : public InputCheckPasswordSRP {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1736378792;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputCheckPasswordSRP final : public InputCheckPasswordSRP {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 srp_id_;
  bytes A_;
  bytes M1_;

  inputCheckPasswordSRP(int64 srp_id_, bytes &&A_, bytes &&M1_);

  static const std::int32_t ID = -763367294;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputClientProxy final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string address_;
  int32 port_;

  static const std::int32_t ID = 1968737087;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputCollectible: public Object {
 public:
};

class inputCollectibleUsername final : public InputCollectible {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string username_;

  explicit inputCollectibleUsername(string const &username_);

  static const std::int32_t ID = -476815191;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputCollectiblePhone final : public InputCollectible {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_;

  explicit inputCollectiblePhone(string const &phone_);

  static const std::int32_t ID = -1562241884;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPhoneContact final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 client_id_;
  string phone_;
  string first_name_;
  string last_name_;

  inputPhoneContact(int64 client_id_, string const &phone_, string const &first_name_, string const &last_name_);

  static const std::int32_t ID = -208488460;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class InputDialogPeer: public Object {
 public:
};

class inputDialogPeer final : public InputDialogPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit inputDialogPeer(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = -55902537;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputDialogPeerFolder final : public InputDialogPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 folder_id_;

  explicit inputDialogPeerFolder(int32 folder_id_);

  static const std::int32_t ID = 1684014375;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputDocument: public Object {
 public:

  static object_ptr<InputDocument> fetch(TlBufferParser &p);
};

class inputDocumentEmpty final : public InputDocument {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1928391342;

  static object_ptr<InputDocument> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputDocument final : public InputDocument {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;
  bytes file_reference_;

  inputDocument(int64 id_, int64 access_hash_, bytes &&file_reference_);

  static const std::int32_t ID = 448771445;

  static object_ptr<InputDocument> fetch(TlBufferParser &p);

  explicit inputDocument(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputEncryptedChat final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_id_;
  int64 access_hash_;

  inputEncryptedChat(int32 chat_id_, int64 access_hash_);

  static const std::int32_t ID = -247351839;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputEncryptedFile: public Object {
 public:
};

class inputEncryptedFileEmpty final : public InputEncryptedFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 406307684;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputEncryptedFileUploaded final : public InputEncryptedFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 parts_;
  string md5_checksum_;
  int32 key_fingerprint_;

  inputEncryptedFileUploaded(int64 id_, int32 parts_, string const &md5_checksum_, int32 key_fingerprint_);

  static const std::int32_t ID = 1690108678;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputEncryptedFile final : public InputEncryptedFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputEncryptedFile(int64 id_, int64 access_hash_);

  static const std::int32_t ID = 1511503333;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputEncryptedFileBigUploaded final : public InputEncryptedFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 parts_;
  int32 key_fingerprint_;

  inputEncryptedFileBigUploaded(int64 id_, int32 parts_, int32 key_fingerprint_);

  static const std::int32_t ID = 767652808;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputDocument;

class InputFile: public Object {
 public:

  static object_ptr<InputFile> fetch(TlBufferParser &p);
};

class inputFile final : public InputFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 parts_;
  string name_;
  string md5_checksum_;

  inputFile(int64 id_, int32 parts_, string const &name_, string const &md5_checksum_);

  static const std::int32_t ID = -181407105;

  static object_ptr<InputFile> fetch(TlBufferParser &p);

  explicit inputFile(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputFileBig final : public InputFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 parts_;
  string name_;

  inputFileBig(int64 id_, int32 parts_, string const &name_);

  static const std::int32_t ID = -95482955;

  static object_ptr<InputFile> fetch(TlBufferParser &p);

  explicit inputFileBig(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputFileStoryDocument final : public InputFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputDocument> id_;

  explicit inputFileStoryDocument(object_ptr<InputDocument> &&id_);

  static const std::int32_t ID = 1658620744;

  static object_ptr<InputFile> fetch(TlBufferParser &p);

  explicit inputFileStoryDocument(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class InputStickerSet;

class inputGroupCall;

class InputFileLocation: public Object {
 public:
};

class inputPeerPhotoFileLocationLegacy final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool big_;
  object_ptr<InputPeer> peer_;
  int64 volume_id_;
  int32 local_id_;
  enum Flags : std::int32_t { BIG_MASK = 1 };

  inputPeerPhotoFileLocationLegacy(int32 flags_, bool big_, object_ptr<InputPeer> &&peer_, int64 volume_id_, int32 local_id_);

  static const std::int32_t ID = 668375447;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetThumbLegacy final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputStickerSet> stickerset_;
  int64 volume_id_;
  int32 local_id_;

  inputStickerSetThumbLegacy(object_ptr<InputStickerSet> &&stickerset_, int64 volume_id_, int32 local_id_);

  static const std::int32_t ID = 230353641;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputFileLocation final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 volume_id_;
  int32 local_id_;
  int64 secret_;
  bytes file_reference_;

  inputFileLocation(int64 volume_id_, int32 local_id_, int64 secret_, bytes &&file_reference_);

  static const std::int32_t ID = -539317279;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputEncryptedFileLocation final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputEncryptedFileLocation(int64 id_, int64 access_hash_);

  static const std::int32_t ID = -182231723;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputDocumentFileLocation final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;
  bytes file_reference_;
  string thumb_size_;

  inputDocumentFileLocation(int64 id_, int64 access_hash_, bytes &&file_reference_, string const &thumb_size_);

  static const std::int32_t ID = -1160743548;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputSecureFileLocation final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputSecureFileLocation(int64 id_, int64 access_hash_);

  static const std::int32_t ID = -876089816;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputTakeoutFileLocation final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 700340377;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPhotoFileLocation final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;
  bytes file_reference_;
  string thumb_size_;

  inputPhotoFileLocation(int64 id_, int64 access_hash_, bytes &&file_reference_, string const &thumb_size_);

  static const std::int32_t ID = 1075322878;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPhotoLegacyFileLocation final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;
  bytes file_reference_;
  int64 volume_id_;
  int32 local_id_;
  int64 secret_;

  inputPhotoLegacyFileLocation(int64 id_, int64 access_hash_, bytes &&file_reference_, int64 volume_id_, int32 local_id_, int64 secret_);

  static const std::int32_t ID = -667654413;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPeerPhotoFileLocation final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool big_;
  object_ptr<InputPeer> peer_;
  int64 photo_id_;
  enum Flags : std::int32_t { BIG_MASK = 1 };

  inputPeerPhotoFileLocation(int32 flags_, bool big_, object_ptr<InputPeer> &&peer_, int64 photo_id_);

  static const std::int32_t ID = 925204121;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetThumb final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputStickerSet> stickerset_;
  int32 thumb_version_;

  inputStickerSetThumb(object_ptr<InputStickerSet> &&stickerset_, int32 thumb_version_);

  static const std::int32_t ID = -1652231205;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputGroupCallStream final : public InputFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<inputGroupCall> call_;
  int64 time_ms_;
  int32 scale_;
  int32 video_channel_;
  int32 video_quality_;
  enum Flags : std::int32_t { VIDEO_CHANNEL_MASK = 1, VIDEO_QUALITY_MASK = 1 };

  inputGroupCallStream(int32 flags_, object_ptr<inputGroupCall> &&call_, int64 time_ms_, int32 scale_, int32 video_channel_, int32 video_quality_);

  static const std::int32_t ID = 93890858;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class inputFolderPeer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 folder_id_;

  inputFolderPeer(object_ptr<InputPeer> &&peer_, int32 folder_id_);

  static const std::int32_t ID = -70073706;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputUser;

class InputGame: public Object {
 public:

  static object_ptr<InputGame> fetch(TlBufferParser &p);
};

class inputGameID final : public InputGame {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputGameID(int64 id_, int64 access_hash_);

  static const std::int32_t ID = 53231223;

  static object_ptr<InputGame> fetch(TlBufferParser &p);

  explicit inputGameID(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputGameShortName final : public InputGame {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_id_;
  string short_name_;

  inputGameShortName(object_ptr<InputUser> &&bot_id_, string const &short_name_);

  static const std::int32_t ID = -1020139510;

  static object_ptr<InputGame> fetch(TlBufferParser &p);

  explicit inputGameShortName(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputGeoPoint: public Object {
 public:

  static object_ptr<InputGeoPoint> fetch(TlBufferParser &p);
};

class inputGeoPointEmpty final : public InputGeoPoint {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -457104426;

  static object_ptr<InputGeoPoint> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputGeoPoint final : public InputGeoPoint {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  double lat_;
  double long_;
  int32 accuracy_radius_;
  enum Flags : std::int32_t { ACCURACY_RADIUS_MASK = 1 };

  inputGeoPoint();

  inputGeoPoint(int32 flags_, double lat_, double long_, int32 accuracy_radius_);

  static const std::int32_t ID = 1210199983;

  static object_ptr<InputGeoPoint> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputGroupCall final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputGroupCall(int64 id_, int64 access_hash_);

  static const std::int32_t ID = -659913713;

  static object_ptr<inputGroupCall> fetch(TlBufferParser &p);

  explicit inputGroupCall(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class InputSavedStarGift;

class InputStorePaymentPurpose;

class premiumGiftCodeOption;

class textWithEntities;

class InputInvoice: public Object {
 public:
};

class inputInvoiceMessage final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;

  inputInvoiceMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_);

  static const std::int32_t ID = -977967015;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInvoiceSlug final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string slug_;

  explicit inputInvoiceSlug(string const &slug_);

  static const std::int32_t ID = -1020867857;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInvoicePremiumGiftCode final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputStorePaymentPurpose> purpose_;
  object_ptr<premiumGiftCodeOption> option_;

  inputInvoicePremiumGiftCode(object_ptr<InputStorePaymentPurpose> &&purpose_, object_ptr<premiumGiftCodeOption> &&option_);

  static const std::int32_t ID = -1734841331;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInvoiceStars final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputStorePaymentPurpose> purpose_;

  explicit inputInvoiceStars(object_ptr<InputStorePaymentPurpose> &&purpose_);

  static const std::int32_t ID = 1710230755;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInvoiceChatInviteSubscription final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string hash_;

  explicit inputInvoiceChatInviteSubscription(string const &hash_);

  static const std::int32_t ID = 887591921;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInvoiceStarGift final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool hide_name_;
  bool include_upgrade_;
  object_ptr<InputPeer> peer_;
  int64 gift_id_;
  object_ptr<textWithEntities> message_;
  enum Flags : std::int32_t { HIDE_NAME_MASK = 1, INCLUDE_UPGRADE_MASK = 4, MESSAGE_MASK = 2 };

  inputInvoiceStarGift(int32 flags_, bool hide_name_, bool include_upgrade_, object_ptr<InputPeer> &&peer_, int64 gift_id_, object_ptr<textWithEntities> &&message_);

  static const std::int32_t ID = -396206446;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInvoiceStarGiftUpgrade final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool keep_original_details_;
  object_ptr<InputSavedStarGift> stargift_;
  enum Flags : std::int32_t { KEEP_ORIGINAL_DETAILS_MASK = 1 };

  inputInvoiceStarGiftUpgrade(int32 flags_, bool keep_original_details_, object_ptr<InputSavedStarGift> &&stargift_);

  static const std::int32_t ID = 1300335965;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInvoiceStarGiftTransfer final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputSavedStarGift> stargift_;
  object_ptr<InputPeer> to_id_;

  inputInvoiceStarGiftTransfer(object_ptr<InputSavedStarGift> &&stargift_, object_ptr<InputPeer> &&to_id_);

  static const std::int32_t ID = 1247763417;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class DocumentAttribute;

class InputDocument;

class InputFile;

class InputGame;

class InputGeoPoint;

class InputMedia;

class InputPeer;

class InputPhoto;

class MessageEntity;

class dataJSON;

class inputWebDocument;

class invoice;

class poll;

class InputMedia: public Object {
 public:

  static object_ptr<InputMedia> fetch(TlBufferParser &p);
};

class inputMediaEmpty final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1771768449;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaUploadedPhoto final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool spoiler_;
  object_ptr<InputFile> file_;
  array<object_ptr<InputDocument>> stickers_;
  int32 ttl_seconds_;
  enum Flags : std::int32_t { SPOILER_MASK = 4, STICKERS_MASK = 1, TTL_SECONDS_MASK = 2 };

  inputMediaUploadedPhoto();

  inputMediaUploadedPhoto(int32 flags_, bool spoiler_, object_ptr<InputFile> &&file_, array<object_ptr<InputDocument>> &&stickers_, int32 ttl_seconds_);

  static const std::int32_t ID = 505969924;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaPhoto final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool spoiler_;
  object_ptr<InputPhoto> id_;
  int32 ttl_seconds_;
  enum Flags : std::int32_t { SPOILER_MASK = 2, TTL_SECONDS_MASK = 1 };

  inputMediaPhoto();

  inputMediaPhoto(int32 flags_, bool spoiler_, object_ptr<InputPhoto> &&id_, int32 ttl_seconds_);

  static const std::int32_t ID = -1279654347;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaGeoPoint final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputGeoPoint> geo_point_;

  explicit inputMediaGeoPoint(object_ptr<InputGeoPoint> &&geo_point_);

  static const std::int32_t ID = -104578748;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  explicit inputMediaGeoPoint(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaContact final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  string first_name_;
  string last_name_;
  string vcard_;

  inputMediaContact(string const &phone_number_, string const &first_name_, string const &last_name_, string const &vcard_);

  static const std::int32_t ID = -122978821;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  explicit inputMediaContact(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaUploadedDocument final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool nosound_video_;
  bool force_file_;
  bool spoiler_;
  object_ptr<InputFile> file_;
  object_ptr<InputFile> thumb_;
  string mime_type_;
  array<object_ptr<DocumentAttribute>> attributes_;
  array<object_ptr<InputDocument>> stickers_;
  object_ptr<InputPhoto> video_cover_;
  int32 video_timestamp_;
  int32 ttl_seconds_;
  enum Flags : std::int32_t { NOSOUND_VIDEO_MASK = 8, FORCE_FILE_MASK = 16, SPOILER_MASK = 32, THUMB_MASK = 4, STICKERS_MASK = 1, VIDEO_COVER_MASK = 64, VIDEO_TIMESTAMP_MASK = 128, TTL_SECONDS_MASK = 2 };

  inputMediaUploadedDocument();

  inputMediaUploadedDocument(int32 flags_, bool nosound_video_, bool force_file_, bool spoiler_, object_ptr<InputFile> &&file_, object_ptr<InputFile> &&thumb_, string const &mime_type_, array<object_ptr<DocumentAttribute>> &&attributes_, array<object_ptr<InputDocument>> &&stickers_, object_ptr<InputPhoto> &&video_cover_, int32 video_timestamp_, int32 ttl_seconds_);

  static const std::int32_t ID = 58495792;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaDocument final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool spoiler_;
  object_ptr<InputDocument> id_;
  object_ptr<InputPhoto> video_cover_;
  int32 video_timestamp_;
  int32 ttl_seconds_;
  string query_;
  enum Flags : std::int32_t { SPOILER_MASK = 4, VIDEO_COVER_MASK = 8, VIDEO_TIMESTAMP_MASK = 16, TTL_SECONDS_MASK = 1, QUERY_MASK = 2 };

  inputMediaDocument();

  inputMediaDocument(int32 flags_, bool spoiler_, object_ptr<InputDocument> &&id_, object_ptr<InputPhoto> &&video_cover_, int32 video_timestamp_, int32 ttl_seconds_, string const &query_);

  static const std::int32_t ID = -1468646731;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaVenue final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputGeoPoint> geo_point_;
  string title_;
  string address_;
  string provider_;
  string venue_id_;
  string venue_type_;

  inputMediaVenue(object_ptr<InputGeoPoint> &&geo_point_, string const &title_, string const &address_, string const &provider_, string const &venue_id_, string const &venue_type_);

  static const std::int32_t ID = -1052959727;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  explicit inputMediaVenue(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaPhotoExternal final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool spoiler_;
  string url_;
  int32 ttl_seconds_;
  enum Flags : std::int32_t { SPOILER_MASK = 2, TTL_SECONDS_MASK = 1 };

  inputMediaPhotoExternal();

  inputMediaPhotoExternal(int32 flags_, bool spoiler_, string const &url_, int32 ttl_seconds_);

  static const std::int32_t ID = -440664550;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaDocumentExternal final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool spoiler_;
  string url_;
  int32 ttl_seconds_;
  object_ptr<InputPhoto> video_cover_;
  int32 video_timestamp_;
  enum Flags : std::int32_t { SPOILER_MASK = 2, TTL_SECONDS_MASK = 1, VIDEO_COVER_MASK = 4, VIDEO_TIMESTAMP_MASK = 8 };

  inputMediaDocumentExternal();

  inputMediaDocumentExternal(int32 flags_, bool spoiler_, string const &url_, int32 ttl_seconds_, object_ptr<InputPhoto> &&video_cover_, int32 video_timestamp_);

  static const std::int32_t ID = 2006319353;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaGame final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputGame> id_;

  explicit inputMediaGame(object_ptr<InputGame> &&id_);

  static const std::int32_t ID = -750828557;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  explicit inputMediaGame(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaInvoice final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string title_;
  string description_;
  object_ptr<inputWebDocument> photo_;
  object_ptr<invoice> invoice_;
  bytes payload_;
  string provider_;
  object_ptr<dataJSON> provider_data_;
  string start_param_;
  object_ptr<InputMedia> extended_media_;
  enum Flags : std::int32_t { PHOTO_MASK = 1, PROVIDER_MASK = 8, START_PARAM_MASK = 2, EXTENDED_MEDIA_MASK = 4 };

  inputMediaInvoice();

  inputMediaInvoice(int32 flags_, string const &title_, string const &description_, object_ptr<inputWebDocument> &&photo_, object_ptr<invoice> &&invoice_, bytes &&payload_, string const &provider_, object_ptr<dataJSON> &&provider_data_, string const &start_param_, object_ptr<InputMedia> &&extended_media_);

  static const std::int32_t ID = 1080028941;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaGeoLive final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool stopped_;
  object_ptr<InputGeoPoint> geo_point_;
  int32 heading_;
  int32 period_;
  int32 proximity_notification_radius_;
  enum Flags : std::int32_t { STOPPED_MASK = 1, HEADING_MASK = 4, PERIOD_MASK = 2, PROXIMITY_NOTIFICATION_RADIUS_MASK = 8 };

  inputMediaGeoLive();

  inputMediaGeoLive(int32 flags_, bool stopped_, object_ptr<InputGeoPoint> &&geo_point_, int32 heading_, int32 period_, int32 proximity_notification_radius_);

  static const std::int32_t ID = -1759532989;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaPoll final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<poll> poll_;
  array<bytes> correct_answers_;
  string solution_;
  array<object_ptr<MessageEntity>> solution_entities_;
  enum Flags : std::int32_t { CORRECT_ANSWERS_MASK = 1, SOLUTION_MASK = 2, SOLUTION_ENTITIES_MASK = 2 };

  inputMediaPoll();

  inputMediaPoll(int32 flags_, object_ptr<poll> &&poll_, array<bytes> &&correct_answers_, string const &solution_, array<object_ptr<MessageEntity>> &&solution_entities_);

  static const std::int32_t ID = 261416433;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaDice final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoticon_;

  explicit inputMediaDice(string const &emoticon_);

  static const std::int32_t ID = -428884101;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  explicit inputMediaDice(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaStory final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 id_;

  inputMediaStory(object_ptr<InputPeer> &&peer_, int32 id_);

  static const std::int32_t ID = -1979852936;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  explicit inputMediaStory(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaWebPage final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool force_large_media_;
  bool force_small_media_;
  bool optional_;
  string url_;
  enum Flags : std::int32_t { FORCE_LARGE_MEDIA_MASK = 1, FORCE_SMALL_MEDIA_MASK = 2, OPTIONAL_MASK = 4 };

  inputMediaWebPage();

  inputMediaWebPage(int32 flags_, bool force_large_media_, bool force_small_media_, bool optional_, string const &url_);

  static const std::int32_t ID = -1038383031;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaPaidMedia final : public InputMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 stars_amount_;
  array<object_ptr<InputMedia>> extended_media_;
  string payload_;
  enum Flags : std::int32_t { PAYLOAD_MASK = 1 };

  inputMediaPaidMedia();

  inputMediaPaidMedia(int32 flags_, int64 stars_amount_, array<object_ptr<InputMedia>> &&extended_media_, string const &payload_);

  static const std::int32_t ID = -1005571194;

  static object_ptr<InputMedia> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessage: public Object {
 public:
};

class inputMessageID final : public InputMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;

  explicit inputMessageID(int32 id_);

  static const std::int32_t ID = -1502174430;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageReplyTo final : public InputMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;

  explicit inputMessageReplyTo(int32 id_);

  static const std::int32_t ID = -1160215659;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagePinned final : public InputMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -2037963464;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageCallbackQuery final : public InputMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int64 query_id_;

  inputMessageCallbackQuery(int32 id_, int64 query_id_);

  static const std::int32_t ID = -1392895362;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class InputNotifyPeer: public Object {
 public:
};

class inputNotifyPeer final : public InputNotifyPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit inputNotifyPeer(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = -1195615476;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputNotifyUsers final : public InputNotifyPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 423314455;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputNotifyChats final : public InputNotifyPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1251338318;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputNotifyBroadcasts final : public InputNotifyPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1311015810;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputNotifyForumTopic final : public InputNotifyPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 top_msg_id_;

  inputNotifyForumTopic(object_ptr<InputPeer> &&peer_, int32 top_msg_id_);

  static const std::int32_t ID = 1548122514;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dataJSON;

class InputPaymentCredentials: public Object {
 public:
};

class inputPaymentCredentialsSaved final : public InputPaymentCredentials {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  bytes tmp_password_;

  inputPaymentCredentialsSaved(string const &id_, bytes &&tmp_password_);

  static const std::int32_t ID = -1056001329;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPaymentCredentials final : public InputPaymentCredentials {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool save_;
  object_ptr<dataJSON> data_;
  enum Flags : std::int32_t { SAVE_MASK = 1 };

  inputPaymentCredentials(int32 flags_, bool save_, object_ptr<dataJSON> &&data_);

  static const std::int32_t ID = 873977640;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPaymentCredentialsApplePay final : public InputPaymentCredentials {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<dataJSON> payment_data_;

  explicit inputPaymentCredentialsApplePay(object_ptr<dataJSON> &&payment_data_);

  static const std::int32_t ID = 178373535;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPaymentCredentialsGooglePay final : public InputPaymentCredentials {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<dataJSON> payment_token_;

  explicit inputPaymentCredentialsGooglePay(object_ptr<dataJSON> &&payment_token_);

  static const std::int32_t ID = -1966921727;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class InputPeer: public Object {
 public:

  static object_ptr<InputPeer> fetch(TlBufferParser &p);
};

class inputPeerEmpty final : public InputPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2134579434;

  static object_ptr<InputPeer> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPeerSelf final : public InputPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2107670217;

  static object_ptr<InputPeer> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPeerChat final : public InputPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;

  explicit inputPeerChat(int64 chat_id_);

  static const std::int32_t ID = 900291769;

  static object_ptr<InputPeer> fetch(TlBufferParser &p);

  explicit inputPeerChat(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPeerUser final : public InputPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  int64 access_hash_;

  inputPeerUser(int64 user_id_, int64 access_hash_);

  static const std::int32_t ID = -571955892;

  static object_ptr<InputPeer> fetch(TlBufferParser &p);

  explicit inputPeerUser(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPeerChannel final : public InputPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;
  int64 access_hash_;

  inputPeerChannel(int64 channel_id_, int64 access_hash_);

  static const std::int32_t ID = 666680316;

  static object_ptr<InputPeer> fetch(TlBufferParser &p);

  explicit inputPeerChannel(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPeerUserFromMessage final : public InputPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;
  int64 user_id_;

  inputPeerUserFromMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_, int64 user_id_);

  static const std::int32_t ID = -1468331492;

  static object_ptr<InputPeer> fetch(TlBufferParser &p);

  explicit inputPeerUserFromMessage(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPeerChannelFromMessage final : public InputPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;
  int64 channel_id_;

  inputPeerChannelFromMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_, int64 channel_id_);

  static const std::int32_t ID = -1121318848;

  static object_ptr<InputPeer> fetch(TlBufferParser &p);

  explicit inputPeerChannelFromMessage(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NotificationSound;

class inputPeerNotifySettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool show_previews_;
  bool silent_;
  int32 mute_until_;
  object_ptr<NotificationSound> sound_;
  bool stories_muted_;
  bool stories_hide_sender_;
  object_ptr<NotificationSound> stories_sound_;
  enum Flags : std::int32_t { SHOW_PREVIEWS_MASK = 1, SILENT_MASK = 2, MUTE_UNTIL_MASK = 4, SOUND_MASK = 8, STORIES_MUTED_MASK = 64, STORIES_HIDE_SENDER_MASK = 128, STORIES_SOUND_MASK = 256 };

  inputPeerNotifySettings(int32 flags_, bool show_previews_, bool silent_, int32 mute_until_, object_ptr<NotificationSound> &&sound_, bool stories_muted_, bool stories_hide_sender_, object_ptr<NotificationSound> &&stories_sound_);

  static const std::int32_t ID = -892638494;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPhoneCall final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputPhoneCall(int64 id_, int64 access_hash_);

  static const std::int32_t ID = 506920429;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPhoto: public Object {
 public:

  static object_ptr<InputPhoto> fetch(TlBufferParser &p);
};

class inputPhotoEmpty final : public InputPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 483901197;

  static object_ptr<InputPhoto> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPhoto final : public InputPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;
  bytes file_reference_;

  inputPhoto(int64 id_, int64 access_hash_, bytes &&file_reference_);

  static const std::int32_t ID = 1001634122;

  static object_ptr<InputPhoto> fetch(TlBufferParser &p);

  explicit inputPhoto(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPrivacyKey: public Object {
 public:
};

class inputPrivacyKeyStatusTimestamp final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1335282456;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyChatInvite final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1107622874;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyPhoneCall final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -88417185;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyPhoneP2P final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -610373422;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyForwards final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1529000952;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyProfilePhoto final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1461304012;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyPhoneNumber final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 55761658;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyAddedByPhone final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -786326563;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyVoiceMessages final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1360618136;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyAbout final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 941870144;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyBirthday final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -698740276;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyKeyStarGiftsAutoSave final : public InputPrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -512548031;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputUser;

class InputPrivacyRule: public Object {
 public:
};

class inputPrivacyValueAllowContacts final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 218751099;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueAllowAll final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 407582158;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueAllowUsers final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<InputUser>> users_;

  explicit inputPrivacyValueAllowUsers(array<object_ptr<InputUser>> &&users_);

  static const std::int32_t ID = 320652927;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueDisallowContacts final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 195371015;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueDisallowAll final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -697604407;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueDisallowUsers final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<InputUser>> users_;

  explicit inputPrivacyValueDisallowUsers(array<object_ptr<InputUser>> &&users_);

  static const std::int32_t ID = -1877932953;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueAllowChatParticipants final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> chats_;

  explicit inputPrivacyValueAllowChatParticipants(array<int64> &&chats_);

  static const std::int32_t ID = -2079962673;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueDisallowChatParticipants final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> chats_;

  explicit inputPrivacyValueDisallowChatParticipants(array<int64> &&chats_);

  static const std::int32_t ID = -380694650;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueAllowCloseFriends final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 793067081;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueAllowPremium final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2009975281;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueAllowBots final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1515179237;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPrivacyValueDisallowBots final : public InputPrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -991594219;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputQuickReplyShortcut: public Object {
 public:
};

class inputQuickReplyShortcut final : public InputQuickReplyShortcut {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string shortcut_;

  explicit inputQuickReplyShortcut(string const &shortcut_);

  static const std::int32_t ID = 609840449;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputQuickReplyShortcutId final : public InputQuickReplyShortcut {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;

  explicit inputQuickReplyShortcutId(int32 shortcut_id_);

  static const std::int32_t ID = 18418929;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class MessageEntity;

class InputReplyTo: public Object {
 public:

  static object_ptr<InputReplyTo> fetch(TlBufferParser &p);
};

class inputReplyToMessage final : public InputReplyTo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 reply_to_msg_id_;
  int32 top_msg_id_;
  object_ptr<InputPeer> reply_to_peer_id_;
  string quote_text_;
  array<object_ptr<MessageEntity>> quote_entities_;
  int32 quote_offset_;
  enum Flags : std::int32_t { TOP_MSG_ID_MASK = 1, REPLY_TO_PEER_ID_MASK = 2, QUOTE_TEXT_MASK = 4, QUOTE_ENTITIES_MASK = 8, QUOTE_OFFSET_MASK = 16 };

  inputReplyToMessage();

  inputReplyToMessage(int32 flags_, int32 reply_to_msg_id_, int32 top_msg_id_, object_ptr<InputPeer> &&reply_to_peer_id_, string const &quote_text_, array<object_ptr<MessageEntity>> &&quote_entities_, int32 quote_offset_);

  static const std::int32_t ID = 583071445;

  static object_ptr<InputReplyTo> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputReplyToStory final : public InputReplyTo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 story_id_;

  inputReplyToStory(object_ptr<InputPeer> &&peer_, int32 story_id_);

  static const std::int32_t ID = 1484862010;

  static object_ptr<InputReplyTo> fetch(TlBufferParser &p);

  explicit inputReplyToStory(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class InputSavedStarGift: public Object {
 public:
};

class inputSavedStarGiftUser final : public InputSavedStarGift {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 msg_id_;

  explicit inputSavedStarGiftUser(int32 msg_id_);

  static const std::int32_t ID = 1764202389;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputSavedStarGiftChat final : public InputSavedStarGift {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int64 saved_id_;

  inputSavedStarGiftChat(object_ptr<InputPeer> &&peer_, int64 saved_id_);

  static const std::int32_t ID = -251549057;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputSecureFile: public Object {
 public:
};

class inputSecureFileUploaded final : public InputSecureFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 parts_;
  string md5_checksum_;
  bytes file_hash_;
  bytes secret_;

  inputSecureFileUploaded(int64 id_, int32 parts_, string const &md5_checksum_, bytes &&file_hash_, bytes &&secret_);

  static const std::int32_t ID = 859091184;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputSecureFile final : public InputSecureFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputSecureFile(int64 id_, int64 access_hash_);

  static const std::int32_t ID = 1399317950;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputSecureFile;

class SecurePlainData;

class SecureValueType;

class secureData;

class inputSecureValue final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<SecureValueType> type_;
  object_ptr<secureData> data_;
  object_ptr<InputSecureFile> front_side_;
  object_ptr<InputSecureFile> reverse_side_;
  object_ptr<InputSecureFile> selfie_;
  array<object_ptr<InputSecureFile>> translation_;
  array<object_ptr<InputSecureFile>> files_;
  object_ptr<SecurePlainData> plain_data_;
  enum Flags : std::int32_t { DATA_MASK = 1, FRONT_SIDE_MASK = 2, REVERSE_SIDE_MASK = 4, SELFIE_MASK = 8, TRANSLATION_MASK = 64, FILES_MASK = 16, PLAIN_DATA_MASK = 32 };

  inputSecureValue(int32 flags_, object_ptr<SecureValueType> &&type_, object_ptr<secureData> &&data_, object_ptr<InputSecureFile> &&front_side_, object_ptr<InputSecureFile> &&reverse_side_, object_ptr<InputSecureFile> &&selfie_, array<object_ptr<InputSecureFile>> &&translation_, array<object_ptr<InputSecureFile>> &&files_, object_ptr<SecurePlainData> &&plain_data_);

  static const std::int32_t ID = -618540889;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMedia;

class MessageEntity;

class inputSingleMedia final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputMedia> media_;
  int64 random_id_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  enum Flags : std::int32_t { ENTITIES_MASK = 1 };

  inputSingleMedia(int32 flags_, object_ptr<InputMedia> &&media_, int64 random_id_, string const &message_, array<object_ptr<MessageEntity>> &&entities_);

  static const std::int32_t ID = 482797855;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStarsTransaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool refund_;
  string id_;
  enum Flags : std::int32_t { REFUND_MASK = 1 };

  inputStarsTransaction(int32 flags_, bool refund_, string const &id_);

  static const std::int32_t ID = 543876817;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputStickerSet: public Object {
 public:

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);
};

class inputStickerSetEmpty final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -4838507;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetID final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputStickerSetID(int64 id_, int64 access_hash_);

  static const std::int32_t ID = -1645763991;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  explicit inputStickerSetID(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetShortName final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string short_name_;

  explicit inputStickerSetShortName(string const &short_name_);

  static const std::int32_t ID = -2044933984;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  explicit inputStickerSetShortName(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetAnimatedEmoji final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 42402760;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetDice final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoticon_;

  explicit inputStickerSetDice(string const &emoticon_);

  static const std::int32_t ID = -427863538;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  explicit inputStickerSetDice(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetAnimatedEmojiAnimations final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 215889721;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetPremiumGifts final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -930399486;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetEmojiGenericAnimations final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 80008398;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetEmojiDefaultStatuses final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 701560302;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetEmojiDefaultTopicIcons final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1153562857;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickerSetEmojiChannelDefaultStatuses final : public InputStickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1232373075;

  static object_ptr<InputStickerSet> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputDocument;

class maskCoords;

class inputStickerSetItem final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputDocument> document_;
  string emoji_;
  object_ptr<maskCoords> mask_coords_;
  string keywords_;
  enum Flags : std::int32_t { MASK_COORDS_MASK = 1, KEYWORDS_MASK = 2 };

  inputStickerSetItem(int32 flags_, object_ptr<InputDocument> &&document_, string const &emoji_, object_ptr<maskCoords> &&mask_coords_, string const &keywords_);

  static const std::int32_t ID = 853188252;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputDocument;

class InputPhoto;

class InputStickeredMedia: public Object {
 public:
};

class inputStickeredMediaPhoto final : public InputStickeredMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPhoto> id_;

  explicit inputStickeredMediaPhoto(object_ptr<InputPhoto> &&id_);

  static const std::int32_t ID = 1251549527;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStickeredMediaDocument final : public InputStickeredMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputDocument> id_;

  explicit inputStickeredMediaDocument(object_ptr<InputDocument> &&id_);

  static const std::int32_t ID = 70813275;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class InputUser;

class textWithEntities;

class InputStorePaymentPurpose: public Object {
 public:
};

class inputStorePaymentPremiumSubscription final : public InputStorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool restore_;
  bool upgrade_;
  enum Flags : std::int32_t { RESTORE_MASK = 1, UPGRADE_MASK = 2 };

  inputStorePaymentPremiumSubscription(int32 flags_, bool restore_, bool upgrade_);

  static const std::int32_t ID = -1502273946;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStorePaymentGiftPremium final : public InputStorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> user_id_;
  string currency_;
  int64 amount_;

  inputStorePaymentGiftPremium(object_ptr<InputUser> &&user_id_, string const &currency_, int64 amount_);

  static const std::int32_t ID = 1634697192;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStorePaymentPremiumGiftCode final : public InputStorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  array<object_ptr<InputUser>> users_;
  object_ptr<InputPeer> boost_peer_;
  string currency_;
  int64 amount_;
  object_ptr<textWithEntities> message_;
  enum Flags : std::int32_t { BOOST_PEER_MASK = 1, MESSAGE_MASK = 2 };

  inputStorePaymentPremiumGiftCode(int32 flags_, array<object_ptr<InputUser>> &&users_, object_ptr<InputPeer> &&boost_peer_, string const &currency_, int64 amount_, object_ptr<textWithEntities> &&message_);

  static const std::int32_t ID = -75955309;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStorePaymentPremiumGiveaway final : public InputStorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool only_new_subscribers_;
  bool winners_are_visible_;
  object_ptr<InputPeer> boost_peer_;
  array<object_ptr<InputPeer>> additional_peers_;
  array<string> countries_iso2_;
  string prize_description_;
  int64 random_id_;
  int32 until_date_;
  string currency_;
  int64 amount_;
  enum Flags : std::int32_t { ONLY_NEW_SUBSCRIBERS_MASK = 1, WINNERS_ARE_VISIBLE_MASK = 8, ADDITIONAL_PEERS_MASK = 2, COUNTRIES_ISO2_MASK = 4, PRIZE_DESCRIPTION_MASK = 16 };

  inputStorePaymentPremiumGiveaway(int32 flags_, bool only_new_subscribers_, bool winners_are_visible_, object_ptr<InputPeer> &&boost_peer_, array<object_ptr<InputPeer>> &&additional_peers_, array<string> &&countries_iso2_, string const &prize_description_, int64 random_id_, int32 until_date_, string const &currency_, int64 amount_);

  static const std::int32_t ID = 369444042;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStorePaymentStarsTopup final : public InputStorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 stars_;
  string currency_;
  int64 amount_;

  inputStorePaymentStarsTopup(int64 stars_, string const &currency_, int64 amount_);

  static const std::int32_t ID = -572715178;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStorePaymentStarsGift final : public InputStorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> user_id_;
  int64 stars_;
  string currency_;
  int64 amount_;

  inputStorePaymentStarsGift(object_ptr<InputUser> &&user_id_, int64 stars_, string const &currency_, int64 amount_);

  static const std::int32_t ID = 494149367;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStorePaymentStarsGiveaway final : public InputStorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool only_new_subscribers_;
  bool winners_are_visible_;
  int64 stars_;
  object_ptr<InputPeer> boost_peer_;
  array<object_ptr<InputPeer>> additional_peers_;
  array<string> countries_iso2_;
  string prize_description_;
  int64 random_id_;
  int32 until_date_;
  string currency_;
  int64 amount_;
  int32 users_;
  enum Flags : std::int32_t { ONLY_NEW_SUBSCRIBERS_MASK = 1, WINNERS_ARE_VISIBLE_MASK = 8, ADDITIONAL_PEERS_MASK = 2, COUNTRIES_ISO2_MASK = 4, PRIZE_DESCRIPTION_MASK = 16 };

  inputStorePaymentStarsGiveaway(int32 flags_, bool only_new_subscribers_, bool winners_are_visible_, int64 stars_, object_ptr<InputPeer> &&boost_peer_, array<object_ptr<InputPeer>> &&additional_peers_, array<string> &&countries_iso2_, string const &prize_description_, int64 random_id_, int32 until_date_, string const &currency_, int64 amount_, int32 users_);

  static const std::int32_t ID = 1964968186;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputTheme: public Object {
 public:
};

class inputTheme final : public InputTheme {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputTheme(int64 id_, int64 access_hash_);

  static const std::int32_t ID = 1012306921;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputThemeSlug final : public InputTheme {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string slug_;

  explicit inputThemeSlug(string const &slug_);

  static const std::int32_t ID = -175567375;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BaseTheme;

class InputWallPaper;

class wallPaperSettings;

class inputThemeSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool message_colors_animated_;
  object_ptr<BaseTheme> base_theme_;
  int32 accent_color_;
  int32 outbox_accent_color_;
  array<int32> message_colors_;
  object_ptr<InputWallPaper> wallpaper_;
  object_ptr<wallPaperSettings> wallpaper_settings_;
  enum Flags : std::int32_t { MESSAGE_COLORS_ANIMATED_MASK = 4, OUTBOX_ACCENT_COLOR_MASK = 8, MESSAGE_COLORS_MASK = 1, WALLPAPER_MASK = 2, WALLPAPER_SETTINGS_MASK = 2 };

  inputThemeSettings(int32 flags_, bool message_colors_animated_, object_ptr<BaseTheme> &&base_theme_, int32 accent_color_, int32 outbox_accent_color_, array<int32> &&message_colors_, object_ptr<InputWallPaper> &&wallpaper_, object_ptr<wallPaperSettings> &&wallpaper_settings_);

  static const std::int32_t ID = -1881255857;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class InputUser: public Object {
 public:

  static object_ptr<InputUser> fetch(TlBufferParser &p);
};

class inputUserEmpty final : public InputUser {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1182234929;

  static object_ptr<InputUser> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputUserSelf final : public InputUser {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -138301121;

  static object_ptr<InputUser> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputUser final : public InputUser {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  int64 access_hash_;

  inputUser(int64 user_id_, int64 access_hash_);

  static const std::int32_t ID = -233744186;

  static object_ptr<InputUser> fetch(TlBufferParser &p);

  explicit inputUser(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputUserFromMessage final : public InputUser {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;
  int64 user_id_;

  inputUserFromMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_, int64 user_id_);

  static const std::int32_t ID = 497305826;

  static object_ptr<InputUser> fetch(TlBufferParser &p);

  explicit inputUserFromMessage(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputWallPaper: public Object {
 public:
};

class inputWallPaper final : public InputWallPaper {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;

  inputWallPaper(int64 id_, int64 access_hash_);

  static const std::int32_t ID = -433014407;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputWallPaperSlug final : public InputWallPaper {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string slug_;

  explicit inputWallPaperSlug(string const &slug_);

  static const std::int32_t ID = 1913199744;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputWallPaperNoFile final : public InputWallPaper {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;

  explicit inputWallPaperNoFile(int64 id_);

  static const std::int32_t ID = -1770371538;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class DocumentAttribute;

class inputWebDocument final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int32 size_;
  string mime_type_;
  array<object_ptr<DocumentAttribute>> attributes_;

  inputWebDocument(string const &url_, int32 size_, string const &mime_type_, array<object_ptr<DocumentAttribute>> &&attributes_);

  static const std::int32_t ID = -1678949555;

  static object_ptr<inputWebDocument> fetch(TlBufferParser &p);

  explicit inputWebDocument(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputDocument;

class InputGeoPoint;

class InputWebFileLocation: public Object {
 public:
};

class inputWebFileLocation final : public InputWebFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int64 access_hash_;

  inputWebFileLocation(string const &url_, int64 access_hash_);

  static const std::int32_t ID = -1036396922;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputWebFileGeoPointLocation final : public InputWebFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputGeoPoint> geo_point_;
  int64 access_hash_;
  int32 w_;
  int32 h_;
  int32 zoom_;
  int32 scale_;

  inputWebFileGeoPointLocation(object_ptr<InputGeoPoint> &&geo_point_, int64 access_hash_, int32 w_, int32 h_, int32 zoom_, int32 scale_);

  static const std::int32_t ID = -1625153079;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputWebFileAudioAlbumThumbLocation final : public InputWebFileLocation {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool small_;
  object_ptr<InputDocument> document_;
  string title_;
  string performer_;
  enum Flags : std::int32_t { SMALL_MASK = 4, DOCUMENT_MASK = 1, TITLE_MASK = 2, PERFORMER_MASK = 2 };

  inputWebFileAudioAlbumThumbLocation(int32 flags_, bool small_, object_ptr<InputDocument> &&document_, string const &title_, string const &performer_);

  static const std::int32_t ID = -193992412;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class labeledPrice;

class invoice final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool test_;
  bool name_requested_;
  bool phone_requested_;
  bool email_requested_;
  bool shipping_address_requested_;
  bool flexible_;
  bool phone_to_provider_;
  bool email_to_provider_;
  bool recurring_;
  string currency_;
  array<object_ptr<labeledPrice>> prices_;
  int64 max_tip_amount_;
  array<int64> suggested_tip_amounts_;
  string terms_url_;
  int32 subscription_period_;
  enum Flags : std::int32_t { TEST_MASK = 1, NAME_REQUESTED_MASK = 2, PHONE_REQUESTED_MASK = 4, EMAIL_REQUESTED_MASK = 8, SHIPPING_ADDRESS_REQUESTED_MASK = 16, FLEXIBLE_MASK = 32, PHONE_TO_PROVIDER_MASK = 64, EMAIL_TO_PROVIDER_MASK = 128, RECURRING_MASK = 512, MAX_TIP_AMOUNT_MASK = 256, SUGGESTED_TIP_AMOUNTS_MASK = 256, TERMS_URL_MASK = 1024, SUBSCRIPTION_PERIOD_MASK = 2048 };

  invoice();

  invoice(int32 flags_, bool test_, bool name_requested_, bool phone_requested_, bool email_requested_, bool shipping_address_requested_, bool flexible_, bool phone_to_provider_, bool email_to_provider_, bool recurring_, string const &currency_, array<object_ptr<labeledPrice>> &&prices_, int64 max_tip_amount_, array<int64> &&suggested_tip_amounts_, string const &terms_url_, int32 subscription_period_);

  static const std::int32_t ID = 77522308;

  static object_ptr<invoice> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class IpPort: public Object {
 public:

  static object_ptr<IpPort> fetch(TlBufferParser &p);
};

class ipPort final : public IpPort {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 ipv4_;
  int32 port_;

  static const std::int32_t ID = -734810765;

  static object_ptr<IpPort> fetch(TlBufferParser &p);

  explicit ipPort(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ipPortSecret final : public IpPort {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 ipv4_;
  int32 port_;
  bytes secret_;

  static const std::int32_t ID = 932718150;

  static object_ptr<IpPort> fetch(TlBufferParser &p);

  explicit ipPortSecret(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class JSONValue;

class jsonObjectValue final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string key_;
  object_ptr<JSONValue> value_;

  jsonObjectValue(string const &key_, object_ptr<JSONValue> &&value_);

  static const std::int32_t ID = -1059185703;

  static object_ptr<jsonObjectValue> fetch(TlBufferParser &p);

  explicit jsonObjectValue(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class JSONValue;

class jsonObjectValue;

class JSONValue: public Object {
 public:

  static object_ptr<JSONValue> fetch(TlBufferParser &p);
};

class jsonNull final : public JSONValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1064139624;

  static object_ptr<JSONValue> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class jsonBool final : public JSONValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool value_;

  explicit jsonBool(bool value_);

  static const std::int32_t ID = -952869270;

  static object_ptr<JSONValue> fetch(TlBufferParser &p);

  explicit jsonBool(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class jsonNumber final : public JSONValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double value_;

  explicit jsonNumber(double value_);

  static const std::int32_t ID = 736157604;

  static object_ptr<JSONValue> fetch(TlBufferParser &p);

  explicit jsonNumber(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class jsonString final : public JSONValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string value_;

  explicit jsonString(string const &value_);

  static const std::int32_t ID = -1222740358;

  static object_ptr<JSONValue> fetch(TlBufferParser &p);

  explicit jsonString(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class jsonArray final : public JSONValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<JSONValue>> value_;

  explicit jsonArray(array<object_ptr<JSONValue>> &&value_);

  static const std::int32_t ID = -146520221;

  static object_ptr<JSONValue> fetch(TlBufferParser &p);

  explicit jsonArray(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class jsonObject final : public JSONValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<jsonObjectValue>> value_;

  explicit jsonObject(array<object_ptr<jsonObjectValue>> &&value_);

  static const std::int32_t ID = -1715350371;

  static object_ptr<JSONValue> fetch(TlBufferParser &p);

  explicit jsonObject(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InlineQueryPeerType;

class InputUser;

class RequestPeerType;

class KeyboardButton: public Object {
 public:

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);
};

class keyboardButton final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  explicit keyboardButton(string const &text_);

  static const std::int32_t ID = -1560655744;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButton(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonUrl final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  string url_;

  keyboardButtonUrl(string const &text_, string const &url_);

  static const std::int32_t ID = 629866245;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButtonUrl(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonCallback final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool requires_password_;
  string text_;
  bytes data_;
  enum Flags : std::int32_t { REQUIRES_PASSWORD_MASK = 1 };

  keyboardButtonCallback();

  keyboardButtonCallback(int32 flags_, bool requires_password_, string const &text_, bytes &&data_);

  static const std::int32_t ID = 901503851;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonRequestPhone final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  explicit keyboardButtonRequestPhone(string const &text_);

  static const std::int32_t ID = -1318425559;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButtonRequestPhone(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonRequestGeoLocation final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  explicit keyboardButtonRequestGeoLocation(string const &text_);

  static const std::int32_t ID = -59151553;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButtonRequestGeoLocation(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonSwitchInline final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool same_peer_;
  string text_;
  string query_;
  array<object_ptr<InlineQueryPeerType>> peer_types_;
  enum Flags : std::int32_t { SAME_PEER_MASK = 1, PEER_TYPES_MASK = 2 };

  keyboardButtonSwitchInline();

  keyboardButtonSwitchInline(int32 flags_, bool same_peer_, string const &text_, string const &query_, array<object_ptr<InlineQueryPeerType>> &&peer_types_);

  static const std::int32_t ID = -1816527947;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonGame final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  explicit keyboardButtonGame(string const &text_);

  static const std::int32_t ID = 1358175439;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButtonGame(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonBuy final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  explicit keyboardButtonBuy(string const &text_);

  static const std::int32_t ID = -1344716869;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButtonBuy(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonUrlAuth final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string text_;
  string fwd_text_;
  string url_;
  int32 button_id_;
  enum Flags : std::int32_t { FWD_TEXT_MASK = 1 };

  keyboardButtonUrlAuth();

  keyboardButtonUrlAuth(int32 flags_, string const &text_, string const &fwd_text_, string const &url_, int32 button_id_);

  static const std::int32_t ID = 280464681;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputKeyboardButtonUrlAuth final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool request_write_access_;
  string text_;
  string fwd_text_;
  string url_;
  object_ptr<InputUser> bot_;
  enum Flags : std::int32_t { REQUEST_WRITE_ACCESS_MASK = 1, FWD_TEXT_MASK = 2 };

  inputKeyboardButtonUrlAuth();

  inputKeyboardButtonUrlAuth(int32 flags_, bool request_write_access_, string const &text_, string const &fwd_text_, string const &url_, object_ptr<InputUser> &&bot_);

  static const std::int32_t ID = -802258988;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonRequestPoll final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool quiz_;
  string text_;
  enum Flags : std::int32_t { QUIZ_MASK = 1 };

  keyboardButtonRequestPoll();

  keyboardButtonRequestPoll(int32 flags_, bool quiz_, string const &text_);

  static const std::int32_t ID = -1144565411;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputKeyboardButtonUserProfile final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  object_ptr<InputUser> user_id_;

  inputKeyboardButtonUserProfile(string const &text_, object_ptr<InputUser> &&user_id_);

  static const std::int32_t ID = -376962181;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit inputKeyboardButtonUserProfile(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonUserProfile final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  int64 user_id_;

  keyboardButtonUserProfile(string const &text_, int64 user_id_);

  static const std::int32_t ID = 814112961;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButtonUserProfile(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonWebView final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  string url_;

  keyboardButtonWebView(string const &text_, string const &url_);

  static const std::int32_t ID = 326529584;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButtonWebView(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonSimpleWebView final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  string url_;

  keyboardButtonSimpleWebView(string const &text_, string const &url_);

  static const std::int32_t ID = -1598009252;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButtonSimpleWebView(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonRequestPeer final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  int32 button_id_;
  object_ptr<RequestPeerType> peer_type_;
  int32 max_quantity_;

  keyboardButtonRequestPeer(string const &text_, int32 button_id_, object_ptr<RequestPeerType> &&peer_type_, int32 max_quantity_);

  static const std::int32_t ID = 1406648280;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButtonRequestPeer(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputKeyboardButtonRequestPeer final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool name_requested_;
  bool username_requested_;
  bool photo_requested_;
  string text_;
  int32 button_id_;
  object_ptr<RequestPeerType> peer_type_;
  int32 max_quantity_;
  enum Flags : std::int32_t { NAME_REQUESTED_MASK = 1, USERNAME_REQUESTED_MASK = 2, PHOTO_REQUESTED_MASK = 4 };

  inputKeyboardButtonRequestPeer();

  inputKeyboardButtonRequestPeer(int32 flags_, bool name_requested_, bool username_requested_, bool photo_requested_, string const &text_, int32 button_id_, object_ptr<RequestPeerType> &&peer_type_, int32 max_quantity_);

  static const std::int32_t ID = -916050683;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonCopy final : public KeyboardButton {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  string copy_text_;

  keyboardButtonCopy(string const &text_, string const &copy_text_);

  static const std::int32_t ID = 1976723854;

  static object_ptr<KeyboardButton> fetch(TlBufferParser &p);

  explicit keyboardButtonCopy(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class KeyboardButton;

class keyboardButtonRow final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<KeyboardButton>> buttons_;

  explicit keyboardButtonRow(array<object_ptr<KeyboardButton>> &&buttons_);

  static const std::int32_t ID = 2002815875;

  static object_ptr<keyboardButtonRow> fetch(TlBufferParser &p);

  explicit keyboardButtonRow(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class labeledPrice final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string label_;
  int64 amount_;

  labeledPrice(string const &label_, int64 amount_);

  static const std::int32_t ID = -886477832;

  static object_ptr<labeledPrice> fetch(TlBufferParser &p);

  explicit labeledPrice(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LangPackString;

class langPackDifference final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_code_;
  int32 from_version_;
  int32 version_;
  array<object_ptr<LangPackString>> strings_;

  static const std::int32_t ID = -209337866;

  static object_ptr<langPackDifference> fetch(TlBufferParser &p);

  explicit langPackDifference(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class langPackLanguage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool official_;
  bool rtl_;
  bool beta_;
  string name_;
  string native_name_;
  string lang_code_;
  string base_lang_code_;
  string plural_code_;
  int32 strings_count_;
  int32 translated_count_;
  string translations_url_;
  enum Flags : std::int32_t { BASE_LANG_CODE_MASK = 2 };

  langPackLanguage();

  static const std::int32_t ID = -288727837;

  static object_ptr<langPackLanguage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LangPackString: public Object {
 public:

  static object_ptr<LangPackString> fetch(TlBufferParser &p);
};

class langPackString final : public LangPackString {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string key_;
  string value_;

  langPackString(string const &key_, string const &value_);

  static const std::int32_t ID = -892239370;

  static object_ptr<LangPackString> fetch(TlBufferParser &p);

  explicit langPackString(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class langPackStringPluralized final : public LangPackString {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string key_;
  string zero_value_;
  string one_value_;
  string two_value_;
  string few_value_;
  string many_value_;
  string other_value_;
  enum Flags : std::int32_t { ZERO_VALUE_MASK = 1, ONE_VALUE_MASK = 2, TWO_VALUE_MASK = 4, FEW_VALUE_MASK = 8, MANY_VALUE_MASK = 16 };

  langPackStringPluralized();

  langPackStringPluralized(int32 flags_, string const &key_, string const &zero_value_, string const &one_value_, string const &two_value_, string const &few_value_, string const &many_value_, string const &other_value_);

  static const std::int32_t ID = 1816636575;

  static object_ptr<LangPackString> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class langPackStringDeleted final : public LangPackString {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string key_;

  explicit langPackStringDeleted(string const &key_);

  static const std::int32_t ID = 695856818;

  static object_ptr<LangPackString> fetch(TlBufferParser &p);

  explicit langPackStringDeleted(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class maskCoords final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 n_;
  double x_;
  double y_;
  double zoom_;

  maskCoords(int32 n_, double x_, double y_, double zoom_);

  static const std::int32_t ID = -1361650766;

  static object_ptr<maskCoords> fetch(TlBufferParser &p);

  explicit maskCoords(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GeoPoint;

class InputChannel;

class Reaction;

class geoPointAddress;

class mediaAreaCoordinates;

class MediaArea: public Object {
 public:

  static object_ptr<MediaArea> fetch(TlBufferParser &p);
};

class mediaAreaVenue final : public MediaArea {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<mediaAreaCoordinates> coordinates_;
  object_ptr<GeoPoint> geo_;
  string title_;
  string address_;
  string provider_;
  string venue_id_;
  string venue_type_;

  mediaAreaVenue(object_ptr<mediaAreaCoordinates> &&coordinates_, object_ptr<GeoPoint> &&geo_, string const &title_, string const &address_, string const &provider_, string const &venue_id_, string const &venue_type_);

  static const std::int32_t ID = -1098720356;

  static object_ptr<MediaArea> fetch(TlBufferParser &p);

  explicit mediaAreaVenue(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaAreaVenue final : public MediaArea {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<mediaAreaCoordinates> coordinates_;
  int64 query_id_;
  string result_id_;

  inputMediaAreaVenue(object_ptr<mediaAreaCoordinates> &&coordinates_, int64 query_id_, string const &result_id_);

  static const std::int32_t ID = -1300094593;

  static object_ptr<MediaArea> fetch(TlBufferParser &p);

  explicit inputMediaAreaVenue(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class mediaAreaGeoPoint final : public MediaArea {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<mediaAreaCoordinates> coordinates_;
  object_ptr<GeoPoint> geo_;
  object_ptr<geoPointAddress> address_;
  enum Flags : std::int32_t { ADDRESS_MASK = 1 };

  mediaAreaGeoPoint();

  mediaAreaGeoPoint(int32 flags_, object_ptr<mediaAreaCoordinates> &&coordinates_, object_ptr<GeoPoint> &&geo_, object_ptr<geoPointAddress> &&address_);

  static const std::int32_t ID = -891992787;

  static object_ptr<MediaArea> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class mediaAreaSuggestedReaction final : public MediaArea {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool dark_;
  bool flipped_;
  object_ptr<mediaAreaCoordinates> coordinates_;
  object_ptr<Reaction> reaction_;
  enum Flags : std::int32_t { DARK_MASK = 1, FLIPPED_MASK = 2 };

  mediaAreaSuggestedReaction();

  mediaAreaSuggestedReaction(int32 flags_, bool dark_, bool flipped_, object_ptr<mediaAreaCoordinates> &&coordinates_, object_ptr<Reaction> &&reaction_);

  static const std::int32_t ID = 340088945;

  static object_ptr<MediaArea> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class mediaAreaChannelPost final : public MediaArea {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<mediaAreaCoordinates> coordinates_;
  int64 channel_id_;
  int32 msg_id_;

  mediaAreaChannelPost(object_ptr<mediaAreaCoordinates> &&coordinates_, int64 channel_id_, int32 msg_id_);

  static const std::int32_t ID = 1996756655;

  static object_ptr<MediaArea> fetch(TlBufferParser &p);

  explicit mediaAreaChannelPost(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMediaAreaChannelPost final : public MediaArea {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<mediaAreaCoordinates> coordinates_;
  object_ptr<InputChannel> channel_;
  int32 msg_id_;

  inputMediaAreaChannelPost(object_ptr<mediaAreaCoordinates> &&coordinates_, object_ptr<InputChannel> &&channel_, int32 msg_id_);

  static const std::int32_t ID = 577893055;

  static object_ptr<MediaArea> fetch(TlBufferParser &p);

  explicit inputMediaAreaChannelPost(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class mediaAreaUrl final : public MediaArea {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<mediaAreaCoordinates> coordinates_;
  string url_;

  mediaAreaUrl(object_ptr<mediaAreaCoordinates> &&coordinates_, string const &url_);

  static const std::int32_t ID = 926421125;

  static object_ptr<MediaArea> fetch(TlBufferParser &p);

  explicit mediaAreaUrl(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class mediaAreaWeather final : public MediaArea {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<mediaAreaCoordinates> coordinates_;
  string emoji_;
  double temperature_c_;
  int32 color_;

  mediaAreaWeather(object_ptr<mediaAreaCoordinates> &&coordinates_, string const &emoji_, double temperature_c_, int32 color_);

  static const std::int32_t ID = 1235637404;

  static object_ptr<MediaArea> fetch(TlBufferParser &p);

  explicit mediaAreaWeather(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class mediaAreaStarGift final : public MediaArea {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<mediaAreaCoordinates> coordinates_;
  string slug_;

  mediaAreaStarGift(object_ptr<mediaAreaCoordinates> &&coordinates_, string const &slug_);

  static const std::int32_t ID = 1468491885;

  static object_ptr<MediaArea> fetch(TlBufferParser &p);

  explicit mediaAreaStarGift(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class mediaAreaCoordinates final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  double x_;
  double y_;
  double w_;
  double h_;
  double rotation_;
  double radius_;
  enum Flags : std::int32_t { RADIUS_MASK = 1 };

  mediaAreaCoordinates();

  mediaAreaCoordinates(int32 flags_, double x_, double y_, double w_, double h_, double rotation_, double radius_);

  static const std::int32_t ID = -808853502;

  static object_ptr<mediaAreaCoordinates> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageAction;

class MessageEntity;

class MessageMedia;

class MessageReplyHeader;

class Peer;

class ReplyMarkup;

class factCheck;

class messageFwdHeader;

class messageReactions;

class messageReplies;

class restrictionReason;

class Message: public Object {
 public:

  static object_ptr<Message> fetch(TlBufferParser &p);
};

class messageEmpty final : public Message {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 id_;
  object_ptr<Peer> peer_id_;

  messageEmpty();

  static const std::int32_t ID = -1868117372;

  static object_ptr<Message> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message final : public Message {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool out_;
  bool mentioned_;
  bool media_unread_;
  bool silent_;
  bool post_;
  bool from_scheduled_;
  bool legacy_;
  bool edit_hide_;
  bool pinned_;
  bool noforwards_;
  bool invert_media_;
  int32 flags2_;
  bool offline_;
  bool video_processing_pending_;
  int32 id_;
  object_ptr<Peer> from_id_;
  int32 from_boosts_applied_;
  object_ptr<Peer> peer_id_;
  object_ptr<Peer> saved_peer_id_;
  object_ptr<messageFwdHeader> fwd_from_;
  int64 via_bot_id_;
  int64 via_business_bot_id_;
  object_ptr<MessageReplyHeader> reply_to_;
  int32 date_;
  string message_;
  object_ptr<MessageMedia> media_;
  object_ptr<ReplyMarkup> reply_markup_;
  array<object_ptr<MessageEntity>> entities_;
  int32 views_;
  int32 forwards_;
  object_ptr<messageReplies> replies_;
  int32 edit_date_;
  string post_author_;
  int64 grouped_id_;
  object_ptr<messageReactions> reactions_;
  array<object_ptr<restrictionReason>> restriction_reason_;
  int32 ttl_period_;
  int32 quick_reply_shortcut_id_;
  int64 effect_;
  object_ptr<factCheck> factcheck_;
  int32 report_delivery_until_date_;
  enum Flags : std::int32_t { FROM_BOOSTS_APPLIED_MASK = 536870912, VIA_BOT_ID_MASK = 2048, VIA_BUSINESS_BOT_ID_MASK = 1, VIEWS_MASK = 1024, FORWARDS_MASK = 1024, EDIT_DATE_MASK = 32768, POST_AUTHOR_MASK = 65536, GROUPED_ID_MASK = 131072, TTL_PERIOD_MASK = 33554432, QUICK_REPLY_SHORTCUT_ID_MASK = 1073741824, EFFECT_MASK = 4, REPORT_DELIVERY_UNTIL_DATE_MASK = 32 };

  message();

  message(int32 flags_, bool out_, bool mentioned_, bool media_unread_, bool silent_, bool post_, bool from_scheduled_, bool legacy_, bool edit_hide_, bool pinned_, bool noforwards_, bool invert_media_, int32 flags2_, bool offline_, bool video_processing_pending_, int32 id_, object_ptr<Peer> &&from_id_, int32 from_boosts_applied_, object_ptr<Peer> &&peer_id_, object_ptr<Peer> &&saved_peer_id_, object_ptr<messageFwdHeader> &&fwd_from_, int64 via_bot_id_, int64 via_business_bot_id_, object_ptr<MessageReplyHeader> &&reply_to_, int32 date_, string const &message_, object_ptr<MessageMedia> &&media_, object_ptr<ReplyMarkup> &&reply_markup_, array<object_ptr<MessageEntity>> &&entities_, int32 views_, int32 forwards_, object_ptr<messageReplies> &&replies_, int32 edit_date_, string const &post_author_, int64 grouped_id_, object_ptr<messageReactions> &&reactions_, array<object_ptr<restrictionReason>> &&restriction_reason_, int32 ttl_period_, int32 quick_reply_shortcut_id_, int64 effect_, object_ptr<factCheck> &&factcheck_, int32 report_delivery_until_date_);

  static const std::int32_t ID = -1761756183;

  static object_ptr<Message> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageService final : public Message {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool out_;
  bool mentioned_;
  bool media_unread_;
  bool reactions_are_possible_;
  bool silent_;
  bool post_;
  bool legacy_;
  int32 id_;
  object_ptr<Peer> from_id_;
  object_ptr<Peer> peer_id_;
  object_ptr<MessageReplyHeader> reply_to_;
  int32 date_;
  object_ptr<MessageAction> action_;
  object_ptr<messageReactions> reactions_;
  int32 ttl_period_;
  enum Flags : std::int32_t { TTL_PERIOD_MASK = 33554432 };

  messageService();

  static const std::int32_t ID = -741178048;

  static object_ptr<Message> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotApp;

class Peer;

class PhoneCallDiscardReason;

class Photo;

class RequestedPeer;

class SecureValueType;

class StarGift;

class WallPaper;

class inputGroupCall;

class paymentCharge;

class paymentRequestedInfo;

class secureCredentialsEncrypted;

class secureValue;

class textWithEntities;

class MessageAction: public Object {
 public:

  static object_ptr<MessageAction> fetch(TlBufferParser &p);
};

class messageActionEmpty final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1230047312;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChatCreate final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  array<int64> users_;

  static const std::int32_t ID = -1119368275;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionChatCreate(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChatEditTitle final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;

  static const std::int32_t ID = -1247687078;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionChatEditTitle(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChatEditPhoto final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Photo> photo_;

  static const std::int32_t ID = 2144015272;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionChatEditPhoto(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChatDeletePhoto final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1780220945;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChatAddUser final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> users_;

  static const std::int32_t ID = 365886720;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionChatAddUser(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChatDeleteUser final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;

  static const std::int32_t ID = -1539362612;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionChatDeleteUser(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChatJoinedByLink final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 inviter_id_;

  static const std::int32_t ID = 51520707;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionChatJoinedByLink(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChannelCreate final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;

  static const std::int32_t ID = -1781355374;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionChannelCreate(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChatMigrateTo final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;

  static const std::int32_t ID = -519864430;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionChatMigrateTo(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChannelMigrateFrom final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  int64 chat_id_;

  static const std::int32_t ID = -365344535;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionChannelMigrateFrom(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionPinMessage final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1799538451;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionHistoryClear final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1615153660;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionGameScore final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 game_id_;
  int32 score_;

  static const std::int32_t ID = -1834538890;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionGameScore(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionPaymentSentMe final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool recurring_init_;
  bool recurring_used_;
  string currency_;
  int64 total_amount_;
  bytes payload_;
  object_ptr<paymentRequestedInfo> info_;
  string shipping_option_id_;
  object_ptr<paymentCharge> charge_;
  int32 subscription_until_date_;
  enum Flags : std::int32_t { SHIPPING_OPTION_ID_MASK = 2, SUBSCRIPTION_UNTIL_DATE_MASK = 16 };

  messageActionPaymentSentMe();

  static const std::int32_t ID = -6288180;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionPaymentSent final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool recurring_init_;
  bool recurring_used_;
  string currency_;
  int64 total_amount_;
  string invoice_slug_;
  int32 subscription_until_date_;
  enum Flags : std::int32_t { INVOICE_SLUG_MASK = 1, SUBSCRIPTION_UNTIL_DATE_MASK = 16 };

  messageActionPaymentSent();

  static const std::int32_t ID = -970673810;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionPhoneCall final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool video_;
  int64 call_id_;
  object_ptr<PhoneCallDiscardReason> reason_;
  int32 duration_;
  enum Flags : std::int32_t { DURATION_MASK = 2 };

  messageActionPhoneCall();

  static const std::int32_t ID = -2132731265;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionScreenshotTaken final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1200788123;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionCustomAction final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string message_;

  static const std::int32_t ID = -85549226;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionCustomAction(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionBotAllowed final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool attach_menu_;
  bool from_request_;
  string domain_;
  object_ptr<BotApp> app_;
  enum Flags : std::int32_t { DOMAIN_MASK = 1 };

  messageActionBotAllowed();

  static const std::int32_t ID = -988359047;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionSecureValuesSentMe final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<secureValue>> values_;
  object_ptr<secureCredentialsEncrypted> credentials_;

  static const std::int32_t ID = 455635795;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionSecureValuesSentMe(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionSecureValuesSent final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<SecureValueType>> types_;

  static const std::int32_t ID = -648257196;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionSecureValuesSent(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionContactSignUp final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -202219658;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionGeoProximityReached final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> from_id_;
  object_ptr<Peer> to_id_;
  int32 distance_;

  static const std::int32_t ID = -1730095465;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionGeoProximityReached(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionGroupCall final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<inputGroupCall> call_;
  int32 duration_;
  enum Flags : std::int32_t { DURATION_MASK = 1 };

  messageActionGroupCall();

  static const std::int32_t ID = 2047704898;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionInviteToGroupCall final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputGroupCall> call_;
  array<int64> users_;

  static const std::int32_t ID = 1345295095;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionInviteToGroupCall(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionSetMessagesTTL final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 period_;
  int64 auto_setting_from_;
  enum Flags : std::int32_t { AUTO_SETTING_FROM_MASK = 1 };

  messageActionSetMessagesTTL();

  static const std::int32_t ID = 1007897979;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionGroupCallScheduled final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputGroupCall> call_;
  int32 schedule_date_;

  static const std::int32_t ID = -1281329567;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionGroupCallScheduled(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionSetChatTheme final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoticon_;

  static const std::int32_t ID = -1434950843;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionSetChatTheme(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionChatJoinedByRequest final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -339958837;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionWebViewDataSentMe final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  string data_;

  static const std::int32_t ID = 1205698681;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionWebViewDataSentMe(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionWebViewDataSent final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  static const std::int32_t ID = -1262252875;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionWebViewDataSent(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionGiftPremium final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string currency_;
  int64 amount_;
  int32 months_;
  string crypto_currency_;
  int64 crypto_amount_;
  object_ptr<textWithEntities> message_;
  enum Flags : std::int32_t { CRYPTO_CURRENCY_MASK = 1, CRYPTO_AMOUNT_MASK = 1 };

  messageActionGiftPremium();

  static const std::int32_t ID = 1818391802;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionTopicCreate final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string title_;
  int32 icon_color_;
  int64 icon_emoji_id_;
  enum Flags : std::int32_t { ICON_EMOJI_ID_MASK = 1 };

  messageActionTopicCreate();

  static const std::int32_t ID = 228168278;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionTopicEdit final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string title_;
  int64 icon_emoji_id_;
  bool closed_;
  bool hidden_;
  enum Flags : std::int32_t { TITLE_MASK = 1, ICON_EMOJI_ID_MASK = 2, CLOSED_MASK = 4, HIDDEN_MASK = 8 };

  messageActionTopicEdit();

  static const std::int32_t ID = -1064024032;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionSuggestProfilePhoto final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Photo> photo_;

  static const std::int32_t ID = 1474192222;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionSuggestProfilePhoto(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionRequestedPeer final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 button_id_;
  array<object_ptr<Peer>> peers_;

  static const std::int32_t ID = 827428507;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionRequestedPeer(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionSetChatWallPaper final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool same_;
  bool for_both_;
  object_ptr<WallPaper> wallpaper_;

  messageActionSetChatWallPaper();

  static const std::int32_t ID = 1348510708;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionGiftCode final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool via_giveaway_;
  bool unclaimed_;
  object_ptr<Peer> boost_peer_;
  int32 months_;
  string slug_;
  string currency_;
  int64 amount_;
  string crypto_currency_;
  int64 crypto_amount_;
  object_ptr<textWithEntities> message_;
  enum Flags : std::int32_t { CURRENCY_MASK = 4, AMOUNT_MASK = 4, CRYPTO_CURRENCY_MASK = 8, CRYPTO_AMOUNT_MASK = 8 };

  messageActionGiftCode();

  static const std::int32_t ID = 1456486804;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionGiveawayLaunch final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 stars_;
  enum Flags : std::int32_t { STARS_MASK = 1 };

  messageActionGiveawayLaunch();

  static const std::int32_t ID = -1475391004;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionGiveawayResults final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool stars_;
  int32 winners_count_;
  int32 unclaimed_count_;

  messageActionGiveawayResults();

  static const std::int32_t ID = -2015170219;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionBoostApply final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 boosts_;

  static const std::int32_t ID = -872240531;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionBoostApply(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionRequestedPeerSentMe final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 button_id_;
  array<object_ptr<RequestedPeer>> peers_;

  static const std::int32_t ID = -1816979384;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  explicit messageActionRequestedPeerSentMe(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionPaymentRefunded final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<Peer> peer_;
  string currency_;
  int64 total_amount_;
  bytes payload_;
  object_ptr<paymentCharge> charge_;
  enum Flags : std::int32_t { PAYLOAD_MASK = 1 };

  messageActionPaymentRefunded();

  static const std::int32_t ID = 1102307842;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionGiftStars final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string currency_;
  int64 amount_;
  int64 stars_;
  string crypto_currency_;
  int64 crypto_amount_;
  string transaction_id_;
  enum Flags : std::int32_t { CRYPTO_CURRENCY_MASK = 1, CRYPTO_AMOUNT_MASK = 1, TRANSACTION_ID_MASK = 2 };

  messageActionGiftStars();

  static const std::int32_t ID = 1171632161;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionPrizeStars final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool unclaimed_;
  int64 stars_;
  string transaction_id_;
  object_ptr<Peer> boost_peer_;
  int32 giveaway_msg_id_;

  messageActionPrizeStars();

  static const std::int32_t ID = -1341372510;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionStarGift final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool name_hidden_;
  bool saved_;
  bool converted_;
  bool upgraded_;
  bool refunded_;
  bool can_upgrade_;
  object_ptr<StarGift> gift_;
  object_ptr<textWithEntities> message_;
  int64 convert_stars_;
  int32 upgrade_msg_id_;
  int64 upgrade_stars_;
  object_ptr<Peer> from_id_;
  object_ptr<Peer> peer_;
  int64 saved_id_;
  enum Flags : std::int32_t { CONVERT_STARS_MASK = 16, UPGRADE_MSG_ID_MASK = 32, UPGRADE_STARS_MASK = 256, SAVED_ID_MASK = 4096 };

  messageActionStarGift();

  static const std::int32_t ID = 1192749220;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageActionStarGiftUnique final : public MessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool upgrade_;
  bool transferred_;
  bool saved_;
  bool refunded_;
  object_ptr<StarGift> gift_;
  int32 can_export_at_;
  int64 transfer_stars_;
  object_ptr<Peer> from_id_;
  object_ptr<Peer> peer_;
  int64 saved_id_;
  enum Flags : std::int32_t { CAN_EXPORT_AT_MASK = 8, TRANSFER_STARS_MASK = 16, SAVED_ID_MASK = 128 };

  messageActionStarGiftUnique();

  static const std::int32_t ID = -1394619519;

  static object_ptr<MessageAction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputUser;

class MessageEntity: public Object {
 public:

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);
};

class messageEntityUnknown final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityUnknown(int32 offset_, int32 length_);

  static const std::int32_t ID = -1148011883;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityUnknown(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityMention final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityMention(int32 offset_, int32 length_);

  static const std::int32_t ID = -100378723;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityMention(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityHashtag final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityHashtag(int32 offset_, int32 length_);

  static const std::int32_t ID = 1868782349;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityHashtag(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityBotCommand final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityBotCommand(int32 offset_, int32 length_);

  static const std::int32_t ID = 1827637959;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityBotCommand(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityUrl final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityUrl(int32 offset_, int32 length_);

  static const std::int32_t ID = 1859134776;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityUrl(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityEmail final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityEmail(int32 offset_, int32 length_);

  static const std::int32_t ID = 1692693954;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityEmail(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityBold final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityBold(int32 offset_, int32 length_);

  static const std::int32_t ID = -1117713463;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityBold(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityItalic final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityItalic(int32 offset_, int32 length_);

  static const std::int32_t ID = -2106619040;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityItalic(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityCode final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityCode(int32 offset_, int32 length_);

  static const std::int32_t ID = 681706865;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityCode(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityPre final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;
  string language_;

  messageEntityPre(int32 offset_, int32 length_, string const &language_);

  static const std::int32_t ID = 1938967520;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityPre(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityTextUrl final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;
  string url_;

  messageEntityTextUrl(int32 offset_, int32 length_, string const &url_);

  static const std::int32_t ID = 1990644519;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityTextUrl(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityMentionName final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;
  int64 user_id_;

  messageEntityMentionName(int32 offset_, int32 length_, int64 user_id_);

  static const std::int32_t ID = -595914432;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityMentionName(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageEntityMentionName final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;
  object_ptr<InputUser> user_id_;

  inputMessageEntityMentionName(int32 offset_, int32 length_, object_ptr<InputUser> &&user_id_);

  static const std::int32_t ID = 546203849;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit inputMessageEntityMentionName(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityPhone final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityPhone(int32 offset_, int32 length_);

  static const std::int32_t ID = -1687559349;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityPhone(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityCashtag final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityCashtag(int32 offset_, int32 length_);

  static const std::int32_t ID = 1280209983;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityCashtag(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityUnderline final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityUnderline(int32 offset_, int32 length_);

  static const std::int32_t ID = -1672577397;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityUnderline(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityStrike final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityStrike(int32 offset_, int32 length_);

  static const std::int32_t ID = -1090087980;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityStrike(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityBankCard final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntityBankCard(int32 offset_, int32 length_);

  static const std::int32_t ID = 1981704948;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityBankCard(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntitySpoiler final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;

  messageEntitySpoiler(int32 offset_, int32 length_);

  static const std::int32_t ID = 852137487;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntitySpoiler(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityCustomEmoji final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;
  int64 document_id_;

  messageEntityCustomEmoji(int32 offset_, int32 length_, int64 document_id_);

  static const std::int32_t ID = -925956616;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  explicit messageEntityCustomEmoji(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEntityBlockquote final : public MessageEntity {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool collapsed_;
  int32 offset_;
  int32 length_;
  enum Flags : std::int32_t { COLLAPSED_MASK = 1 };

  messageEntityBlockquote();

  messageEntityBlockquote(int32 flags_, bool collapsed_, int32 offset_, int32 length_);

  static const std::int32_t ID = -238245204;

  static object_ptr<MessageEntity> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageMedia;

class PhotoSize;

class MessageExtendedMedia: public Object {
 public:

  static object_ptr<MessageExtendedMedia> fetch(TlBufferParser &p);
};

class messageExtendedMediaPreview final : public MessageExtendedMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 w_;
  int32 h_;
  object_ptr<PhotoSize> thumb_;
  int32 video_duration_;
  enum Flags : std::int32_t { W_MASK = 1, H_MASK = 1, VIDEO_DURATION_MASK = 4 };

  messageExtendedMediaPreview();

  static const std::int32_t ID = -1386050360;

  static object_ptr<MessageExtendedMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageExtendedMedia final : public MessageExtendedMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageMedia> media_;

  static const std::int32_t ID = -297296796;

  static object_ptr<MessageExtendedMedia> fetch(TlBufferParser &p);

  explicit messageExtendedMedia(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class messageFwdHeader final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool imported_;
  bool saved_out_;
  object_ptr<Peer> from_id_;
  string from_name_;
  int32 date_;
  int32 channel_post_;
  string post_author_;
  object_ptr<Peer> saved_from_peer_;
  int32 saved_from_msg_id_;
  object_ptr<Peer> saved_from_id_;
  string saved_from_name_;
  int32 saved_date_;
  string psa_type_;
  enum Flags : std::int32_t { FROM_NAME_MASK = 32, CHANNEL_POST_MASK = 4, POST_AUTHOR_MASK = 8, SAVED_FROM_MSG_ID_MASK = 16, SAVED_FROM_NAME_MASK = 512, SAVED_DATE_MASK = 1024, PSA_TYPE_MASK = 64 };

  messageFwdHeader();

  static const std::int32_t ID = 1313731771;

  static object_ptr<messageFwdHeader> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class GeoPoint;

class MessageExtendedMedia;

class Peer;

class Photo;

class StoryItem;

class WebDocument;

class WebPage;

class game;

class poll;

class pollResults;

class MessageMedia: public Object {
 public:

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);
};

class messageMediaEmpty final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1038967584;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaPhoto final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool spoiler_;
  object_ptr<Photo> photo_;
  int32 ttl_seconds_;
  enum Flags : std::int32_t { TTL_SECONDS_MASK = 4 };

  messageMediaPhoto();

  static const std::int32_t ID = 1766936791;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaGeo final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<GeoPoint> geo_;

  static const std::int32_t ID = 1457575028;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  explicit messageMediaGeo(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaContact final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  string first_name_;
  string last_name_;
  string vcard_;
  int64 user_id_;

  static const std::int32_t ID = 1882335561;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  explicit messageMediaContact(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaUnsupported final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1618676578;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaDocument final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool nopremium_;
  bool spoiler_;
  bool video_;
  bool round_;
  bool voice_;
  object_ptr<Document> document_;
  array<object_ptr<Document>> alt_documents_;
  object_ptr<Photo> video_cover_;
  int32 video_timestamp_;
  int32 ttl_seconds_;
  enum Flags : std::int32_t { VIDEO_TIMESTAMP_MASK = 1024, TTL_SECONDS_MASK = 4 };

  messageMediaDocument();

  static const std::int32_t ID = 1389939929;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaWebPage final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool force_large_media_;
  bool force_small_media_;
  bool manual_;
  bool safe_;
  object_ptr<WebPage> webpage_;

  messageMediaWebPage();

  static const std::int32_t ID = -571405253;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaVenue final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<GeoPoint> geo_;
  string title_;
  string address_;
  string provider_;
  string venue_id_;
  string venue_type_;

  static const std::int32_t ID = 784356159;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  explicit messageMediaVenue(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaGame final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<game> game_;

  static const std::int32_t ID = -38694904;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  explicit messageMediaGame(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaInvoice final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool shipping_address_requested_;
  bool test_;
  string title_;
  string description_;
  object_ptr<WebDocument> photo_;
  int32 receipt_msg_id_;
  string currency_;
  int64 total_amount_;
  string start_param_;
  object_ptr<MessageExtendedMedia> extended_media_;
  enum Flags : std::int32_t { RECEIPT_MSG_ID_MASK = 4 };

  messageMediaInvoice();

  static const std::int32_t ID = -156940077;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaGeoLive final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<GeoPoint> geo_;
  int32 heading_;
  int32 period_;
  int32 proximity_notification_radius_;
  enum Flags : std::int32_t { HEADING_MASK = 1, PROXIMITY_NOTIFICATION_RADIUS_MASK = 2 };

  messageMediaGeoLive();

  static const std::int32_t ID = -1186937242;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaPoll final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<poll> poll_;
  object_ptr<pollResults> results_;

  static const std::int32_t ID = 1272375192;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  explicit messageMediaPoll(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaDice final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 value_;
  string emoticon_;

  static const std::int32_t ID = 1065280907;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  explicit messageMediaDice(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaStory final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool via_mention_;
  object_ptr<Peer> peer_;
  int32 id_;
  object_ptr<StoryItem> story_;

  messageMediaStory();

  static const std::int32_t ID = 1758159491;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaGiveaway final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool only_new_subscribers_;
  bool winners_are_visible_;
  array<int64> channels_;
  array<string> countries_iso2_;
  string prize_description_;
  int32 quantity_;
  int32 months_;
  int64 stars_;
  int32 until_date_;
  enum Flags : std::int32_t { PRIZE_DESCRIPTION_MASK = 8, MONTHS_MASK = 16, STARS_MASK = 32 };

  messageMediaGiveaway();

  static const std::int32_t ID = -1442366485;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaGiveawayResults final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool only_new_subscribers_;
  bool refunded_;
  int64 channel_id_;
  int32 additional_peers_count_;
  int32 launch_msg_id_;
  int32 winners_count_;
  int32 unclaimed_count_;
  array<int64> winners_;
  int32 months_;
  int64 stars_;
  string prize_description_;
  int32 until_date_;
  enum Flags : std::int32_t { ADDITIONAL_PEERS_COUNT_MASK = 8, MONTHS_MASK = 16, STARS_MASK = 32, PRIZE_DESCRIPTION_MASK = 2 };

  messageMediaGiveawayResults();

  static const std::int32_t ID = -827703647;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageMediaPaidMedia final : public MessageMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 stars_amount_;
  array<object_ptr<MessageExtendedMedia>> extended_media_;

  static const std::int32_t ID = -1467669359;

  static object_ptr<MessageMedia> fetch(TlBufferParser &p);

  explicit messageMediaPaidMedia(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class Reaction;

class messagePeerReaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool big_;
  bool unread_;
  bool my_;
  object_ptr<Peer> peer_id_;
  int32 date_;
  object_ptr<Reaction> reaction_;

  messagePeerReaction();

  static const std::int32_t ID = -1938180548;

  static object_ptr<messagePeerReaction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class MessagePeerVote: public Object {
 public:

  static object_ptr<MessagePeerVote> fetch(TlBufferParser &p);
};

class messagePeerVote final : public MessagePeerVote {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  bytes option_;
  int32 date_;

  static const std::int32_t ID = -1228133028;

  static object_ptr<MessagePeerVote> fetch(TlBufferParser &p);

  explicit messagePeerVote(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePeerVoteInputOption final : public MessagePeerVote {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 date_;

  static const std::int32_t ID = 1959634180;

  static object_ptr<MessagePeerVote> fetch(TlBufferParser &p);

  explicit messagePeerVoteInputOption(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePeerVoteMultiple final : public MessagePeerVote {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  array<bytes> options_;
  int32 date_;

  static const std::int32_t ID = 1177089766;

  static object_ptr<MessagePeerVote> fetch(TlBufferParser &p);

  explicit messagePeerVoteMultiple(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageRange final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 min_id_;
  int32 max_id_;

  messageRange(int32 min_id_, int32 max_id_);

  static const std::int32_t ID = 182649427;

  static object_ptr<messageRange> fetch(TlBufferParser &p);

  explicit messageRange(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePeerReaction;

class messageReactor;

class reactionCount;

class messageReactions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool min_;
  bool can_see_list_;
  bool reactions_as_tags_;
  array<object_ptr<reactionCount>> results_;
  array<object_ptr<messagePeerReaction>> recent_reactions_;
  array<object_ptr<messageReactor>> top_reactors_;

  messageReactions();

  static const std::int32_t ID = 171155211;

  static object_ptr<messageReactions> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class messageReactor final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool top_;
  bool my_;
  bool anonymous_;
  object_ptr<Peer> peer_id_;
  int32 count_;

  messageReactor();

  static const std::int32_t ID = 1269016922;

  static object_ptr<messageReactor> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class messageReplies final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool comments_;
  int32 replies_;
  int32 replies_pts_;
  array<object_ptr<Peer>> recent_repliers_;
  int64 channel_id_;
  int32 max_id_;
  int32 read_max_id_;
  enum Flags : std::int32_t { CHANNEL_ID_MASK = 1, MAX_ID_MASK = 4, READ_MAX_ID_MASK = 8 };

  messageReplies();

  static const std::int32_t ID = -2083123262;

  static object_ptr<messageReplies> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageEntity;

class MessageMedia;

class Peer;

class messageFwdHeader;

class MessageReplyHeader: public Object {
 public:

  static object_ptr<MessageReplyHeader> fetch(TlBufferParser &p);
};

class messageReplyHeader final : public MessageReplyHeader {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool reply_to_scheduled_;
  bool forum_topic_;
  bool quote_;
  int32 reply_to_msg_id_;
  object_ptr<Peer> reply_to_peer_id_;
  object_ptr<messageFwdHeader> reply_from_;
  object_ptr<MessageMedia> reply_media_;
  int32 reply_to_top_id_;
  string quote_text_;
  array<object_ptr<MessageEntity>> quote_entities_;
  int32 quote_offset_;
  enum Flags : std::int32_t { REPLY_TO_MSG_ID_MASK = 16, REPLY_TO_TOP_ID_MASK = 2, QUOTE_TEXT_MASK = 64, QUOTE_OFFSET_MASK = 1024 };

  messageReplyHeader();

  static const std::int32_t ID = -1346631205;

  static object_ptr<MessageReplyHeader> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReplyStoryHeader final : public MessageReplyHeader {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 story_id_;

  static const std::int32_t ID = 240843065;

  static object_ptr<MessageReplyHeader> fetch(TlBufferParser &p);

  explicit messageReplyStoryHeader(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReportOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  bytes option_;

  static const std::int32_t ID = 2030298073;

  static object_ptr<messageReportOption> fetch(TlBufferParser &p);

  explicit messageReportOption(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReplies;

class messageViews final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 views_;
  int32 forwards_;
  object_ptr<messageReplies> replies_;
  enum Flags : std::int32_t { VIEWS_MASK = 1, FORWARDS_MASK = 2 };

  messageViews();

  static const std::int32_t ID = 1163625789;

  static object_ptr<messageViews> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessagesFilter: public Object {
 public:

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);
};

class inputMessagesFilterEmpty final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1474492012;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterPhotos final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1777752804;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterVideo final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1614803355;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterPhotoVideo final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1458172132;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterDocument final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1629621880;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterUrl final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2129714567;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterGif final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -3644025;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterVoice final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1358283666;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterMusic final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 928101534;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterChatPhotos final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 975236280;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterPhoneCalls final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool missed_;
  enum Flags : std::int32_t { MISSED_MASK = 1 };

  inputMessagesFilterPhoneCalls();

  inputMessagesFilterPhoneCalls(int32 flags_, bool missed_);

  static const std::int32_t ID = -2134272152;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterRoundVoice final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2054952868;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterRoundVideo final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1253451181;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterMyMentions final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1040652646;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterGeo final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -419271411;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterContacts final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -530392189;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagesFilterPinned final : public MessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 464520273;

  static object_ptr<MessagesFilter> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class missingInvitee final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool premium_would_allow_invite_;
  bool premium_required_for_pm_;
  int64 user_id_;

  missingInvitee();

  static const std::int32_t ID = 1653379620;

  static object_ptr<missingInvitee> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class myBoost final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 slot_;
  object_ptr<Peer> peer_;
  int32 date_;
  int32 expires_;
  int32 cooldown_until_date_;
  enum Flags : std::int32_t { COOLDOWN_UNTIL_DATE_MASK = 2 };

  myBoost();

  static const std::int32_t ID = -1001897636;

  static object_ptr<myBoost> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class nearestDc final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string country_;
  int32 this_dc_;
  int32 nearest_dc_;

  static const std::int32_t ID = -1910892683;

  static object_ptr<nearestDc> fetch(TlBufferParser &p);

  explicit nearestDc(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NotificationSound: public Object {
 public:

  static object_ptr<NotificationSound> fetch(TlBufferParser &p);
};

class notificationSoundDefault final : public NotificationSound {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1746354498;

  static object_ptr<NotificationSound> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationSoundNone final : public NotificationSound {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1863070943;

  static object_ptr<NotificationSound> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationSoundLocal final : public NotificationSound {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  string data_;

  notificationSoundLocal(string const &title_, string const &data_);

  static const std::int32_t ID = -2096391452;

  static object_ptr<NotificationSound> fetch(TlBufferParser &p);

  explicit notificationSoundLocal(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationSoundRingtone final : public NotificationSound {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;

  explicit notificationSoundRingtone(int64 id_);

  static const std::int32_t ID = -9666487;

  static object_ptr<NotificationSound> fetch(TlBufferParser &p);

  explicit notificationSoundRingtone(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class NotifyPeer: public Object {
 public:

  static object_ptr<NotifyPeer> fetch(TlBufferParser &p);
};

class notifyPeer final : public NotifyPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;

  static const std::int32_t ID = -1613493288;

  static object_ptr<NotifyPeer> fetch(TlBufferParser &p);

  explicit notifyPeer(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notifyUsers final : public NotifyPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1261946036;

  static object_ptr<NotifyPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notifyChats final : public NotifyPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1073230141;

  static object_ptr<NotifyPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notifyBroadcasts final : public NotifyPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -703403793;

  static object_ptr<NotifyPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notifyForumTopic final : public NotifyPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 top_msg_id_;

  static const std::int32_t ID = 577659656;

  static object_ptr<NotifyPeer> fetch(TlBufferParser &p);

  explicit notifyForumTopic(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class outboxReadDate final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 date_;

  static const std::int32_t ID = 1001931436;

  static object_ptr<outboxReadDate> fetch(TlBufferParser &p);

  explicit outboxReadDate(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class PageBlock;

class Photo;

class page final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool part_;
  bool rtl_;
  bool v2_;
  string url_;
  array<object_ptr<PageBlock>> blocks_;
  array<object_ptr<Photo>> photos_;
  array<object_ptr<Document>> documents_;
  int32 views_;
  enum Flags : std::int32_t { VIEWS_MASK = 8 };

  page();

  static const std::int32_t ID = -1738178803;

  static object_ptr<page> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class GeoPoint;

class PageBlock;

class PageListItem;

class PageListOrderedItem;

class RichText;

class pageCaption;

class pageRelatedArticle;

class pageTableRow;

class PageBlock: public Object {
 public:

  static object_ptr<PageBlock> fetch(TlBufferParser &p);
};

class pageBlockUnsupported final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 324435594;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockTitle final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = 1890305021;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockTitle(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockSubtitle final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = -1879401953;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockSubtitle(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockAuthorDate final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> author_;
  int32 published_date_;

  static const std::int32_t ID = -1162877472;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockAuthorDate(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockHeader final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = -1076861716;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockHeader(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockSubheader final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = -248793375;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockSubheader(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockParagraph final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = 1182402406;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockParagraph(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockPreformatted final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string language_;

  static const std::int32_t ID = -1066346178;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockPreformatted(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockFooter final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = 1216809369;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockFooter(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockDivider final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -618614392;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockAnchor final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  static const std::int32_t ID = -837994576;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockAnchor(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockList final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PageListItem>> items_;

  static const std::int32_t ID = -454524911;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockList(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockBlockquote final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  object_ptr<RichText> caption_;

  static const std::int32_t ID = 641563686;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockBlockquote(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockPullquote final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  object_ptr<RichText> caption_;

  static const std::int32_t ID = 1329878739;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockPullquote(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockPhoto final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 photo_id_;
  object_ptr<pageCaption> caption_;
  string url_;
  int64 webpage_id_;
  enum Flags : std::int32_t { URL_MASK = 1, WEBPAGE_ID_MASK = 1 };

  pageBlockPhoto();

  static const std::int32_t ID = 391759200;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockVideo final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool autoplay_;
  bool loop_;
  int64 video_id_;
  object_ptr<pageCaption> caption_;

  pageBlockVideo();

  static const std::int32_t ID = 2089805750;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockCover final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PageBlock> cover_;

  static const std::int32_t ID = 972174080;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockCover(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockEmbed final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool full_width_;
  bool allow_scrolling_;
  string url_;
  string html_;
  int64 poster_photo_id_;
  int32 w_;
  int32 h_;
  object_ptr<pageCaption> caption_;
  enum Flags : std::int32_t { URL_MASK = 2, HTML_MASK = 4, POSTER_PHOTO_ID_MASK = 16, W_MASK = 32, H_MASK = 32 };

  pageBlockEmbed();

  static const std::int32_t ID = -1468953147;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockEmbedPost final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int64 webpage_id_;
  int64 author_photo_id_;
  string author_;
  int32 date_;
  array<object_ptr<PageBlock>> blocks_;
  object_ptr<pageCaption> caption_;

  static const std::int32_t ID = -229005301;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockEmbedPost(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockCollage final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PageBlock>> items_;
  object_ptr<pageCaption> caption_;

  static const std::int32_t ID = 1705048653;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockCollage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockSlideshow final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PageBlock>> items_;
  object_ptr<pageCaption> caption_;

  static const std::int32_t ID = 52401552;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockSlideshow(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockChannel final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Chat> channel_;

  static const std::int32_t ID = -283684427;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockChannel(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockAudio final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 audio_id_;
  object_ptr<pageCaption> caption_;

  static const std::int32_t ID = -2143067670;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockAudio(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockKicker final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = 504660880;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockKicker(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockTable final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool bordered_;
  bool striped_;
  object_ptr<RichText> title_;
  array<object_ptr<pageTableRow>> rows_;

  pageBlockTable();

  static const std::int32_t ID = -1085412734;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockOrderedList final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PageListOrderedItem>> items_;

  static const std::int32_t ID = -1702174239;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockOrderedList(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockDetails final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool open_;
  array<object_ptr<PageBlock>> blocks_;
  object_ptr<RichText> title_;

  pageBlockDetails();

  static const std::int32_t ID = 1987480557;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockRelatedArticles final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> title_;
  array<object_ptr<pageRelatedArticle>> articles_;

  static const std::int32_t ID = 370236054;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockRelatedArticles(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockMap final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<GeoPoint> geo_;
  int32 zoom_;
  int32 w_;
  int32 h_;
  object_ptr<pageCaption> caption_;

  static const std::int32_t ID = -1538310410;

  static object_ptr<PageBlock> fetch(TlBufferParser &p);

  explicit pageBlockMap(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class RichText;

class pageCaption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  object_ptr<RichText> credit_;

  static const std::int32_t ID = 1869903447;

  static object_ptr<pageCaption> fetch(TlBufferParser &p);

  explicit pageCaption(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PageBlock;

class RichText;

class PageListItem: public Object {
 public:

  static object_ptr<PageListItem> fetch(TlBufferParser &p);
};

class pageListItemText final : public PageListItem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = -1188055347;

  static object_ptr<PageListItem> fetch(TlBufferParser &p);

  explicit pageListItemText(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageListItemBlocks final : public PageListItem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PageBlock>> blocks_;

  static const std::int32_t ID = 635466748;

  static object_ptr<PageListItem> fetch(TlBufferParser &p);

  explicit pageListItemBlocks(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PageBlock;

class RichText;

class PageListOrderedItem: public Object {
 public:

  static object_ptr<PageListOrderedItem> fetch(TlBufferParser &p);
};

class pageListOrderedItemText final : public PageListOrderedItem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string num_;
  object_ptr<RichText> text_;

  static const std::int32_t ID = 1577484359;

  static object_ptr<PageListOrderedItem> fetch(TlBufferParser &p);

  explicit pageListOrderedItemText(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageListOrderedItemBlocks final : public PageListOrderedItem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string num_;
  array<object_ptr<PageBlock>> blocks_;

  static const std::int32_t ID = -1730311882;

  static object_ptr<PageListOrderedItem> fetch(TlBufferParser &p);

  explicit pageListOrderedItemBlocks(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageRelatedArticle final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string url_;
  int64 webpage_id_;
  string title_;
  string description_;
  int64 photo_id_;
  string author_;
  int32 published_date_;
  enum Flags : std::int32_t { TITLE_MASK = 1, DESCRIPTION_MASK = 2, PHOTO_ID_MASK = 4, AUTHOR_MASK = 8, PUBLISHED_DATE_MASK = 16 };

  pageRelatedArticle();

  static const std::int32_t ID = -1282352120;

  static object_ptr<pageRelatedArticle> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class RichText;

class pageTableCell final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool header_;
  bool align_center_;
  bool align_right_;
  bool valign_middle_;
  bool valign_bottom_;
  object_ptr<RichText> text_;
  int32 colspan_;
  int32 rowspan_;
  enum Flags : std::int32_t { COLSPAN_MASK = 2, ROWSPAN_MASK = 4 };

  pageTableCell();

  static const std::int32_t ID = 878078826;

  static object_ptr<pageTableCell> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageTableCell;

class pageTableRow final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<pageTableCell>> cells_;

  static const std::int32_t ID = -524237339;

  static object_ptr<pageTableRow> fetch(TlBufferParser &p);

  explicit pageTableRow(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPeer;

class PaidReactionPrivacy: public Object {
 public:

  static object_ptr<PaidReactionPrivacy> fetch(TlBufferParser &p);
};

class paidReactionPrivacyDefault final : public PaidReactionPrivacy {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 543872158;

  static object_ptr<PaidReactionPrivacy> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paidReactionPrivacyAnonymous final : public PaidReactionPrivacy {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 520887001;

  static object_ptr<PaidReactionPrivacy> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paidReactionPrivacyPeer final : public PaidReactionPrivacy {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit paidReactionPrivacyPeer(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = -596837136;

  static object_ptr<PaidReactionPrivacy> fetch(TlBufferParser &p);

  explicit paidReactionPrivacyPeer(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PasswordKdfAlgo: public Object {
 public:

  static object_ptr<PasswordKdfAlgo> fetch(TlBufferParser &p);
};

class passwordKdfAlgoUnknown final : public PasswordKdfAlgo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -732254058;

  static object_ptr<PasswordKdfAlgo> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow final : public PasswordKdfAlgo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes salt1_;
  bytes salt2_;
  int32 g_;
  bytes p_;

  passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(bytes &&salt1_, bytes &&salt2_, int32 g_, bytes &&p_);

  static const std::int32_t ID = 982592842;

  static object_ptr<PasswordKdfAlgo> fetch(TlBufferParser &p);

  explicit passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentCharge final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string provider_charge_id_;

  static const std::int32_t ID = -368917890;

  static object_ptr<paymentCharge> fetch(TlBufferParser &p);

  explicit paymentCharge(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentFormMethod final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string title_;

  static const std::int32_t ID = -1996951013;

  static object_ptr<paymentFormMethod> fetch(TlBufferParser &p);

  explicit paymentFormMethod(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class postAddress;

class paymentRequestedInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string name_;
  string phone_;
  string email_;
  object_ptr<postAddress> shipping_address_;
  enum Flags : std::int32_t { NAME_MASK = 1, PHONE_MASK = 2, EMAIL_MASK = 4, SHIPPING_ADDRESS_MASK = 8 };

  paymentRequestedInfo();

  paymentRequestedInfo(int32 flags_, string const &name_, string const &phone_, string const &email_, object_ptr<postAddress> &&shipping_address_);

  static const std::int32_t ID = -1868808300;

  static object_ptr<paymentRequestedInfo> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentSavedCredentialsCard final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string title_;

  static const std::int32_t ID = -842892769;

  static object_ptr<paymentSavedCredentialsCard> fetch(TlBufferParser &p);

  explicit paymentSavedCredentialsCard(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer: public Object {
 public:

  static object_ptr<Peer> fetch(TlBufferParser &p);
};

class peerUser final : public Peer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;

  explicit peerUser(int64 user_id_);

  static const std::int32_t ID = 1498486562;

  static object_ptr<Peer> fetch(TlBufferParser &p);

  explicit peerUser(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class peerChat final : public Peer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;

  explicit peerChat(int64 chat_id_);

  static const std::int32_t ID = 918946202;

  static object_ptr<Peer> fetch(TlBufferParser &p);

  explicit peerChat(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class peerChannel final : public Peer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;

  static const std::int32_t ID = -1566230754;

  static object_ptr<Peer> fetch(TlBufferParser &p);

  explicit peerChannel(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class peerBlocked final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_id_;
  int32 date_;

  static const std::int32_t ID = -386039788;

  static object_ptr<peerBlocked> fetch(TlBufferParser &p);

  explicit peerBlocked(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class peerColor final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 color_;
  int64 background_emoji_id_;
  enum Flags : std::int32_t { COLOR_MASK = 1, BACKGROUND_EMOJI_ID_MASK = 2 };

  peerColor();

  static const std::int32_t ID = -1253352753;

  static object_ptr<peerColor> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class PeerLocated: public Object {
 public:

  static object_ptr<PeerLocated> fetch(TlBufferParser &p);
};

class peerLocated final : public PeerLocated {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 expires_;
  int32 distance_;

  static const std::int32_t ID = -901375139;

  static object_ptr<PeerLocated> fetch(TlBufferParser &p);

  explicit peerLocated(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class peerSelfLocated final : public PeerLocated {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 expires_;

  static const std::int32_t ID = -118740917;

  static object_ptr<PeerLocated> fetch(TlBufferParser &p);

  explicit peerSelfLocated(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NotificationSound;

class peerNotifySettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool show_previews_;
  bool silent_;
  int32 mute_until_;
  object_ptr<NotificationSound> ios_sound_;
  object_ptr<NotificationSound> android_sound_;
  object_ptr<NotificationSound> other_sound_;
  bool stories_muted_;
  bool stories_hide_sender_;
  object_ptr<NotificationSound> stories_ios_sound_;
  object_ptr<NotificationSound> stories_android_sound_;
  object_ptr<NotificationSound> stories_other_sound_;
  enum Flags : std::int32_t { SHOW_PREVIEWS_MASK = 1, SILENT_MASK = 2, MUTE_UNTIL_MASK = 4, STORIES_MUTED_MASK = 64, STORIES_HIDE_SENDER_MASK = 128 };

  peerNotifySettings();

  static const std::int32_t ID = -1721619444;

  static object_ptr<peerNotifySettings> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class peerSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool report_spam_;
  bool add_contact_;
  bool block_contact_;
  bool share_contact_;
  bool need_contacts_exception_;
  bool report_geo_;
  bool autoarchived_;
  bool invite_members_;
  bool request_chat_broadcast_;
  bool business_bot_paused_;
  bool business_bot_can_reply_;
  int32 geo_distance_;
  string request_chat_title_;
  int32 request_chat_date_;
  int64 business_bot_id_;
  string business_bot_manage_url_;
  enum Flags : std::int32_t { GEO_DISTANCE_MASK = 64, REQUEST_CHAT_TITLE_MASK = 512, REQUEST_CHAT_DATE_MASK = 512, BUSINESS_BOT_ID_MASK = 8192, BUSINESS_BOT_MANAGE_URL_MASK = 8192 };

  peerSettings();

  static const std::int32_t ID = -1395233698;

  static object_ptr<peerSettings> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class StoryItem;

class peerStories final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<Peer> peer_;
  int32 max_read_id_;
  array<object_ptr<StoryItem>> stories_;
  enum Flags : std::int32_t { MAX_READ_ID_MASK = 1 };

  peerStories();

  static const std::int32_t ID = -1707742823;

  static object_ptr<peerStories> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PhoneCallDiscardReason;

class PhoneConnection;

class dataJSON;

class inputGroupCall;

class phoneCallProtocol;

class PhoneCall: public Object {
 public:

  static object_ptr<PhoneCall> fetch(TlBufferParser &p);
};

class phoneCallEmpty final : public PhoneCall {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;

  static const std::int32_t ID = 1399245077;

  static object_ptr<PhoneCall> fetch(TlBufferParser &p);

  explicit phoneCallEmpty(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneCallWaiting final : public PhoneCall {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool video_;
  int64 id_;
  int64 access_hash_;
  int32 date_;
  int64 admin_id_;
  int64 participant_id_;
  object_ptr<phoneCallProtocol> protocol_;
  int32 receive_date_;
  object_ptr<inputGroupCall> conference_call_;
  enum Flags : std::int32_t { RECEIVE_DATE_MASK = 1 };

  phoneCallWaiting();

  static const std::int32_t ID = -288085928;

  static object_ptr<PhoneCall> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneCallRequested final : public PhoneCall {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool video_;
  int64 id_;
  int64 access_hash_;
  int32 date_;
  int64 admin_id_;
  int64 participant_id_;
  bytes g_a_hash_;
  object_ptr<phoneCallProtocol> protocol_;
  object_ptr<inputGroupCall> conference_call_;

  phoneCallRequested();

  static const std::int32_t ID = 1161174115;

  static object_ptr<PhoneCall> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneCallAccepted final : public PhoneCall {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool video_;
  int64 id_;
  int64 access_hash_;
  int32 date_;
  int64 admin_id_;
  int64 participant_id_;
  bytes g_b_;
  object_ptr<phoneCallProtocol> protocol_;
  object_ptr<inputGroupCall> conference_call_;

  phoneCallAccepted();

  static const std::int32_t ID = 587035009;

  static object_ptr<PhoneCall> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneCall final : public PhoneCall {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool p2p_allowed_;
  bool video_;
  int64 id_;
  int64 access_hash_;
  int32 date_;
  int64 admin_id_;
  int64 participant_id_;
  bytes g_a_or_b_;
  int64 key_fingerprint_;
  object_ptr<phoneCallProtocol> protocol_;
  array<object_ptr<PhoneConnection>> connections_;
  int32 start_date_;
  object_ptr<dataJSON> custom_parameters_;
  object_ptr<inputGroupCall> conference_call_;

  phoneCall();

  static const std::int32_t ID = 1000707084;

  static object_ptr<PhoneCall> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneCallDiscarded final : public PhoneCall {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool need_rating_;
  bool need_debug_;
  bool video_;
  int64 id_;
  object_ptr<PhoneCallDiscardReason> reason_;
  int32 duration_;
  object_ptr<inputGroupCall> conference_call_;
  enum Flags : std::int32_t { DURATION_MASK = 2 };

  phoneCallDiscarded();

  static const std::int32_t ID = -103656189;

  static object_ptr<PhoneCall> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PhoneCallDiscardReason: public Object {
 public:

  static object_ptr<PhoneCallDiscardReason> fetch(TlBufferParser &p);
};

class phoneCallDiscardReasonMissed final : public PhoneCallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -2048646399;

  static object_ptr<PhoneCallDiscardReason> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneCallDiscardReasonDisconnect final : public PhoneCallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -527056480;

  static object_ptr<PhoneCallDiscardReason> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneCallDiscardReasonHangup final : public PhoneCallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1471006352;

  static object_ptr<PhoneCallDiscardReason> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneCallDiscardReasonBusy final : public PhoneCallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -84416311;

  static object_ptr<PhoneCallDiscardReason> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneCallDiscardReasonAllowGroupCall final : public PhoneCallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes encrypted_key_;

  explicit phoneCallDiscardReasonAllowGroupCall(bytes &&encrypted_key_);

  static const std::int32_t ID = -1344096199;

  static object_ptr<PhoneCallDiscardReason> fetch(TlBufferParser &p);

  explicit phoneCallDiscardReasonAllowGroupCall(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneCallProtocol final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool udp_p2p_;
  bool udp_reflector_;
  int32 min_layer_;
  int32 max_layer_;
  array<string> library_versions_;
  enum Flags : std::int32_t { UDP_P2P_MASK = 1, UDP_REFLECTOR_MASK = 2 };

  phoneCallProtocol();

  phoneCallProtocol(int32 flags_, bool udp_p2p_, bool udp_reflector_, int32 min_layer_, int32 max_layer_, array<string> &&library_versions_);

  static const std::int32_t ID = -58224696;

  static object_ptr<phoneCallProtocol> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PhoneConnection: public Object {
 public:

  static object_ptr<PhoneConnection> fetch(TlBufferParser &p);
};

class phoneConnection final : public PhoneConnection {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool tcp_;
  int64 id_;
  string ip_;
  string ipv6_;
  int32 port_;
  bytes peer_tag_;

  phoneConnection();

  static const std::int32_t ID = -1665063993;

  static object_ptr<PhoneConnection> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneConnectionWebrtc final : public PhoneConnection {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool turn_;
  bool stun_;
  int64 id_;
  string ip_;
  string ipv6_;
  int32 port_;
  string username_;
  string password_;

  phoneConnectionWebrtc();

  static const std::int32_t ID = 1667228533;

  static object_ptr<PhoneConnection> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PhotoSize;

class VideoSize;

class Photo: public Object {
 public:

  static object_ptr<Photo> fetch(TlBufferParser &p);
};

class photoEmpty final : public Photo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;

  static const std::int32_t ID = 590459437;

  static object_ptr<Photo> fetch(TlBufferParser &p);

  explicit photoEmpty(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photo final : public Photo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool has_stickers_;
  int64 id_;
  int64 access_hash_;
  bytes file_reference_;
  int32 date_;
  array<object_ptr<PhotoSize>> sizes_;
  array<object_ptr<VideoSize>> video_sizes_;
  int32 dc_id_;

  photo();

  static const std::int32_t ID = -82216347;

  static object_ptr<Photo> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PhotoSize: public Object {
 public:

  static object_ptr<PhotoSize> fetch(TlBufferParser &p);
};

class photoSizeEmpty final : public PhotoSize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string type_;

  explicit photoSizeEmpty(string const &type_);

  static const std::int32_t ID = 236446268;

  static object_ptr<PhotoSize> fetch(TlBufferParser &p);

  explicit photoSizeEmpty(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photoSize final : public PhotoSize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string type_;
  int32 w_;
  int32 h_;
  int32 size_;

  photoSize(string const &type_, int32 w_, int32 h_, int32 size_);

  static const std::int32_t ID = 1976012384;

  static object_ptr<PhotoSize> fetch(TlBufferParser &p);

  explicit photoSize(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photoCachedSize final : public PhotoSize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string type_;
  int32 w_;
  int32 h_;
  bytes bytes_;

  photoCachedSize(string const &type_, int32 w_, int32 h_, bytes &&bytes_);

  static const std::int32_t ID = 35527382;

  static object_ptr<PhotoSize> fetch(TlBufferParser &p);

  explicit photoCachedSize(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photoStrippedSize final : public PhotoSize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string type_;
  bytes bytes_;

  static const std::int32_t ID = -525288402;

  static object_ptr<PhotoSize> fetch(TlBufferParser &p);

  explicit photoStrippedSize(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photoSizeProgressive final : public PhotoSize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string type_;
  int32 w_;
  int32 h_;
  array<int32> sizes_;

  static const std::int32_t ID = -96535659;

  static object_ptr<PhotoSize> fetch(TlBufferParser &p);

  explicit photoSizeProgressive(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photoPathSize final : public PhotoSize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string type_;
  bytes bytes_;

  static const std::int32_t ID = -668906175;

  static object_ptr<PhotoSize> fetch(TlBufferParser &p);

  explicit photoPathSize(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pollAnswer;

class textWithEntities;

class poll final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 flags_;
  bool closed_;
  bool public_voters_;
  bool multiple_choice_;
  bool quiz_;
  object_ptr<textWithEntities> question_;
  array<object_ptr<pollAnswer>> answers_;
  int32 close_period_;
  int32 close_date_;
  enum Flags : std::int32_t { CLOSED_MASK = 1, PUBLIC_VOTERS_MASK = 2, MULTIPLE_CHOICE_MASK = 4, QUIZ_MASK = 8, CLOSE_PERIOD_MASK = 16, CLOSE_DATE_MASK = 32 };

  poll();

  poll(int64 id_, int32 flags_, bool closed_, bool public_voters_, bool multiple_choice_, bool quiz_, object_ptr<textWithEntities> &&question_, array<object_ptr<pollAnswer>> &&answers_, int32 close_period_, int32 close_date_);

  static const std::int32_t ID = 1484026161;

  static object_ptr<poll> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textWithEntities;

class pollAnswer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<textWithEntities> text_;
  bytes option_;

  pollAnswer(object_ptr<textWithEntities> &&text_, bytes &&option_);

  static const std::int32_t ID = -15277366;

  static object_ptr<pollAnswer> fetch(TlBufferParser &p);

  explicit pollAnswer(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pollAnswerVoters final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool chosen_;
  bool correct_;
  bytes option_;
  int32 voters_;

  pollAnswerVoters();

  static const std::int32_t ID = 997055186;

  static object_ptr<pollAnswerVoters> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageEntity;

class Peer;

class pollAnswerVoters;

class pollResults final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool min_;
  array<object_ptr<pollAnswerVoters>> results_;
  int32 total_voters_;
  array<object_ptr<Peer>> recent_voters_;
  string solution_;
  array<object_ptr<MessageEntity>> solution_entities_;
  enum Flags : std::int32_t { TOTAL_VOTERS_MASK = 4, SOLUTION_MASK = 16 };

  pollResults();

  static const std::int32_t ID = 2061444128;

  static object_ptr<pollResults> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class popularContact final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 client_id_;
  int32 importers_;

  static const std::int32_t ID = 1558266229;

  static object_ptr<popularContact> fetch(TlBufferParser &p);

  explicit popularContact(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class postAddress final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string street_line1_;
  string street_line2_;
  string city_;
  string state_;
  string country_iso2_;
  string post_code_;

  postAddress(string const &street_line1_, string const &street_line2_, string const &city_, string const &state_, string const &country_iso2_, string const &post_code_);

  static const std::int32_t ID = 512535275;

  static object_ptr<postAddress> fetch(TlBufferParser &p);

  explicit postAddress(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PostInteractionCounters: public Object {
 public:

  static object_ptr<PostInteractionCounters> fetch(TlBufferParser &p);
};

class postInteractionCountersMessage final : public PostInteractionCounters {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 msg_id_;
  int32 views_;
  int32 forwards_;
  int32 reactions_;

  static const std::int32_t ID = -419066241;

  static object_ptr<PostInteractionCounters> fetch(TlBufferParser &p);

  explicit postInteractionCountersMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class postInteractionCountersStory final : public PostInteractionCounters {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 story_id_;
  int32 views_;
  int32 forwards_;
  int32 reactions_;

  static const std::int32_t ID = -1974989273;

  static object_ptr<PostInteractionCounters> fetch(TlBufferParser &p);

  explicit postInteractionCountersStory(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumGiftCodeOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 users_;
  int32 months_;
  string store_product_;
  int32 store_quantity_;
  string currency_;
  int64 amount_;
  enum Flags : std::int32_t { STORE_PRODUCT_MASK = 1, STORE_QUANTITY_MASK = 2 };

  premiumGiftCodeOption();

  premiumGiftCodeOption(int32 flags_, int32 users_, int32 months_, string const &store_product_, int32 store_quantity_, string const &currency_, int64 amount_);

  static const std::int32_t ID = 629052971;

  static object_ptr<premiumGiftCodeOption> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumGiftOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 months_;
  string currency_;
  int64 amount_;
  string bot_url_;
  string store_product_;
  enum Flags : std::int32_t { STORE_PRODUCT_MASK = 1 };

  premiumGiftOption();

  static const std::int32_t ID = 1958953753;

  static object_ptr<premiumGiftOption> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumSubscriptionOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool current_;
  bool can_purchase_upgrade_;
  string transaction_;
  int32 months_;
  string currency_;
  int64 amount_;
  string bot_url_;
  string store_product_;
  enum Flags : std::int32_t { TRANSACTION_MASK = 8, STORE_PRODUCT_MASK = 1 };

  premiumSubscriptionOption();

  static const std::int32_t ID = 1596792306;

  static object_ptr<premiumSubscriptionOption> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PrepaidGiveaway: public Object {
 public:

  static object_ptr<PrepaidGiveaway> fetch(TlBufferParser &p);
};

class prepaidGiveaway final : public PrepaidGiveaway {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 months_;
  int32 quantity_;
  int32 date_;

  static const std::int32_t ID = -1303143084;

  static object_ptr<PrepaidGiveaway> fetch(TlBufferParser &p);

  explicit prepaidGiveaway(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class prepaidStarsGiveaway final : public PrepaidGiveaway {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 stars_;
  int32 quantity_;
  int32 boosts_;
  int32 date_;

  static const std::int32_t ID = -1700956192;

  static object_ptr<PrepaidGiveaway> fetch(TlBufferParser &p);

  explicit prepaidStarsGiveaway(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PrivacyKey: public Object {
 public:

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);
};

class privacyKeyStatusTimestamp final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1137792208;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyChatInvite final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1343122938;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyPhoneCall final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1030105979;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyPhoneP2P final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 961092808;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyForwards final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1777096355;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyProfilePhoto final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1777000467;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyPhoneNumber final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -778378131;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyAddedByPhone final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1124062251;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyVoiceMessages final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 110621716;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyAbout final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1534675103;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyBirthday final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 536913176;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyKeyStarGiftsAutoSave final : public PrivacyKey {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 749010424;

  static object_ptr<PrivacyKey> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PrivacyRule: public Object {
 public:

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);
};

class privacyValueAllowContacts final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -123988;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueAllowAll final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1698855810;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueAllowUsers final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> users_;

  static const std::int32_t ID = -1198497870;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  explicit privacyValueAllowUsers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueDisallowContacts final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -125240806;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueDisallowAll final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1955338397;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueDisallowUsers final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> users_;

  static const std::int32_t ID = -463335103;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  explicit privacyValueDisallowUsers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueAllowChatParticipants final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> chats_;

  static const std::int32_t ID = 1796427406;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  explicit privacyValueAllowChatParticipants(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueDisallowChatParticipants final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> chats_;

  static const std::int32_t ID = 1103656293;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  explicit privacyValueDisallowChatParticipants(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueAllowCloseFriends final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -135735141;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueAllowPremium final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -320241333;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueAllowBots final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 558242653;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class privacyValueDisallowBots final : public PrivacyRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -156895185;

  static object_ptr<PrivacyRule> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Message;

class Peer;

class StoryItem;

class PublicForward: public Object {
 public:

  static object_ptr<PublicForward> fetch(TlBufferParser &p);
};

class publicForwardMessage final : public PublicForward {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;

  static const std::int32_t ID = 32685898;

  static object_ptr<PublicForward> fetch(TlBufferParser &p);

  explicit publicForwardMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class publicForwardStory final : public PublicForward {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  object_ptr<StoryItem> story_;

  static const std::int32_t ID = -302797360;

  static object_ptr<PublicForward> fetch(TlBufferParser &p);

  explicit publicForwardStory(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class quickReply final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  string shortcut_;
  int32 top_message_;
  int32 count_;

  static const std::int32_t ID = 110563371;

  static object_ptr<quickReply> fetch(TlBufferParser &p);

  explicit quickReply(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Reaction: public Object {
 public:

  static object_ptr<Reaction> fetch(TlBufferParser &p);
};

class reactionEmpty final : public Reaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2046153753;

  static object_ptr<Reaction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reactionEmoji final : public Reaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoticon_;

  explicit reactionEmoji(string const &emoticon_);

  static const std::int32_t ID = 455247544;

  static object_ptr<Reaction> fetch(TlBufferParser &p);

  explicit reactionEmoji(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reactionCustomEmoji final : public Reaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 document_id_;

  explicit reactionCustomEmoji(int64 document_id_);

  static const std::int32_t ID = -1992950669;

  static object_ptr<Reaction> fetch(TlBufferParser &p);

  explicit reactionCustomEmoji(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reactionPaid final : public Reaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1379771627;

  static object_ptr<Reaction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Reaction;

class reactionCount final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 chosen_order_;
  object_ptr<Reaction> reaction_;
  int32 count_;
  enum Flags : std::int32_t { CHOSEN_ORDER_MASK = 1 };

  reactionCount();

  static const std::int32_t ID = -1546531968;

  static object_ptr<reactionCount> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionNotificationsFrom: public Object {
 public:

  static object_ptr<ReactionNotificationsFrom> fetch(TlBufferParser &p);
};

class reactionNotificationsFromContacts final : public ReactionNotificationsFrom {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1161583078;

  static object_ptr<ReactionNotificationsFrom> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reactionNotificationsFromAll final : public ReactionNotificationsFrom {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1268654752;

  static object_ptr<ReactionNotificationsFrom> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NotificationSound;

class ReactionNotificationsFrom;

class reactionsNotifySettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<ReactionNotificationsFrom> messages_notify_from_;
  object_ptr<ReactionNotificationsFrom> stories_notify_from_;
  object_ptr<NotificationSound> sound_;
  bool show_previews_;
  enum Flags : std::int32_t { MESSAGES_NOTIFY_FROM_MASK = 1, STORIES_NOTIFY_FROM_MASK = 2 };

  reactionsNotifySettings();

  reactionsNotifySettings(int32 flags_, object_ptr<ReactionNotificationsFrom> &&messages_notify_from_, object_ptr<ReactionNotificationsFrom> &&stories_notify_from_, object_ptr<NotificationSound> &&sound_, bool show_previews_);

  static const std::int32_t ID = 1457736048;

  static object_ptr<reactionsNotifySettings> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class readParticipantDate final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  int32 date_;

  static const std::int32_t ID = 1246753138;

  static object_ptr<readParticipantDate> fetch(TlBufferParser &p);

  explicit readParticipantDate(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class receivedNotifyMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int32 flags_;

  static const std::int32_t ID = -1551583367;

  static object_ptr<receivedNotifyMessage> fetch(TlBufferParser &p);

  explicit receivedNotifyMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatInvite;

class StickerSetCovered;

class RecentMeUrl: public Object {
 public:

  static object_ptr<RecentMeUrl> fetch(TlBufferParser &p);
};

class recentMeUrlUnknown final : public RecentMeUrl {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  static const std::int32_t ID = 1189204285;

  static object_ptr<RecentMeUrl> fetch(TlBufferParser &p);

  explicit recentMeUrlUnknown(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class recentMeUrlUser final : public RecentMeUrl {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int64 user_id_;

  static const std::int32_t ID = -1188296222;

  static object_ptr<RecentMeUrl> fetch(TlBufferParser &p);

  explicit recentMeUrlUser(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class recentMeUrlChat final : public RecentMeUrl {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int64 chat_id_;

  static const std::int32_t ID = -1294306862;

  static object_ptr<RecentMeUrl> fetch(TlBufferParser &p);

  explicit recentMeUrlChat(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class recentMeUrlChatInvite final : public RecentMeUrl {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  object_ptr<ChatInvite> chat_invite_;

  static const std::int32_t ID = -347535331;

  static object_ptr<RecentMeUrl> fetch(TlBufferParser &p);

  explicit recentMeUrlChatInvite(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class recentMeUrlStickerSet final : public RecentMeUrl {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  object_ptr<StickerSetCovered> set_;

  static const std::int32_t ID = -1140172836;

  static object_ptr<RecentMeUrl> fetch(TlBufferParser &p);

  explicit recentMeUrlStickerSet(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonRow;

class ReplyMarkup: public Object {
 public:

  static object_ptr<ReplyMarkup> fetch(TlBufferParser &p);
};

class replyKeyboardHide final : public ReplyMarkup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool selective_;
  enum Flags : std::int32_t { SELECTIVE_MASK = 4 };

  replyKeyboardHide();

  replyKeyboardHide(int32 flags_, bool selective_);

  static const std::int32_t ID = -1606526075;

  static object_ptr<ReplyMarkup> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class replyKeyboardForceReply final : public ReplyMarkup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool single_use_;
  bool selective_;
  string placeholder_;
  enum Flags : std::int32_t { SINGLE_USE_MASK = 2, SELECTIVE_MASK = 4, PLACEHOLDER_MASK = 8 };

  replyKeyboardForceReply();

  replyKeyboardForceReply(int32 flags_, bool single_use_, bool selective_, string const &placeholder_);

  static const std::int32_t ID = -2035021048;

  static object_ptr<ReplyMarkup> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class replyKeyboardMarkup final : public ReplyMarkup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool resize_;
  bool single_use_;
  bool selective_;
  bool persistent_;
  array<object_ptr<keyboardButtonRow>> rows_;
  string placeholder_;
  enum Flags : std::int32_t { RESIZE_MASK = 1, SINGLE_USE_MASK = 2, SELECTIVE_MASK = 4, PERSISTENT_MASK = 16, PLACEHOLDER_MASK = 8 };

  replyKeyboardMarkup();

  replyKeyboardMarkup(int32 flags_, bool resize_, bool single_use_, bool selective_, bool persistent_, array<object_ptr<keyboardButtonRow>> &&rows_, string const &placeholder_);

  static const std::int32_t ID = -2049074735;

  static object_ptr<ReplyMarkup> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class replyInlineMarkup final : public ReplyMarkup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<keyboardButtonRow>> rows_;

  explicit replyInlineMarkup(array<object_ptr<keyboardButtonRow>> &&rows_);

  static const std::int32_t ID = 1218642516;

  static object_ptr<ReplyMarkup> fetch(TlBufferParser &p);

  explicit replyInlineMarkup(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReportReason: public Object {
 public:
};

class inputReportReasonSpam final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1490799288;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputReportReasonViolence final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 505595789;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputReportReasonPornography final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 777640226;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputReportReasonChildAbuse final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1376497949;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputReportReasonOther final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1041980751;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputReportReasonCopyright final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1685456582;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputReportReasonGeoIrrelevant final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -606798099;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputReportReasonFake final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -170010905;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputReportReasonIllegalDrugs final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 177124030;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputReportReasonPersonalDetails final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1631091139;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReportOption;

class ReportResult: public Object {
 public:

  static object_ptr<ReportResult> fetch(TlBufferParser &p);
};

class reportResultChooseOption final : public ReportResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  array<object_ptr<messageReportOption>> options_;

  static const std::int32_t ID = -253435722;

  static object_ptr<ReportResult> fetch(TlBufferParser &p);

  explicit reportResultChooseOption(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportResultAddComment final : public ReportResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool optional_;
  bytes option_;

  reportResultAddComment();

  static const std::int32_t ID = 1862904881;

  static object_ptr<ReportResult> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportResultReported final : public ReportResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1917633461;

  static object_ptr<ReportResult> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatAdminRights;

class RequestPeerType: public Object {
 public:

  static object_ptr<RequestPeerType> fetch(TlBufferParser &p);
};

class requestPeerTypeUser final : public RequestPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool bot_;
  bool premium_;
  enum Flags : std::int32_t { BOT_MASK = 1, PREMIUM_MASK = 2 };

  requestPeerTypeUser();

  requestPeerTypeUser(int32 flags_, bool bot_, bool premium_);

  static const std::int32_t ID = 1597737472;

  static object_ptr<RequestPeerType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class requestPeerTypeChat final : public RequestPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool creator_;
  bool bot_participant_;
  bool has_username_;
  bool forum_;
  object_ptr<chatAdminRights> user_admin_rights_;
  object_ptr<chatAdminRights> bot_admin_rights_;
  enum Flags : std::int32_t { CREATOR_MASK = 1, BOT_PARTICIPANT_MASK = 32, HAS_USERNAME_MASK = 8, FORUM_MASK = 16, USER_ADMIN_RIGHTS_MASK = 2, BOT_ADMIN_RIGHTS_MASK = 4 };

  requestPeerTypeChat();

  requestPeerTypeChat(int32 flags_, bool creator_, bool bot_participant_, bool has_username_, bool forum_, object_ptr<chatAdminRights> &&user_admin_rights_, object_ptr<chatAdminRights> &&bot_admin_rights_);

  static const std::int32_t ID = -906990053;

  static object_ptr<RequestPeerType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class requestPeerTypeBroadcast final : public RequestPeerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool creator_;
  bool has_username_;
  object_ptr<chatAdminRights> user_admin_rights_;
  object_ptr<chatAdminRights> bot_admin_rights_;
  enum Flags : std::int32_t { CREATOR_MASK = 1, HAS_USERNAME_MASK = 8, USER_ADMIN_RIGHTS_MASK = 2, BOT_ADMIN_RIGHTS_MASK = 4 };

  requestPeerTypeBroadcast();

  requestPeerTypeBroadcast(int32 flags_, bool creator_, bool has_username_, object_ptr<chatAdminRights> &&user_admin_rights_, object_ptr<chatAdminRights> &&bot_admin_rights_);

  static const std::int32_t ID = 865857388;

  static object_ptr<RequestPeerType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Photo;

class RequestedPeer: public Object {
 public:

  static object_ptr<RequestedPeer> fetch(TlBufferParser &p);
};

class requestedPeerUser final : public RequestedPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 user_id_;
  string first_name_;
  string last_name_;
  string username_;
  object_ptr<Photo> photo_;
  enum Flags : std::int32_t { FIRST_NAME_MASK = 1, LAST_NAME_MASK = 1, USERNAME_MASK = 2 };

  requestedPeerUser();

  static const std::int32_t ID = -701500310;

  static object_ptr<RequestedPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class requestedPeerChat final : public RequestedPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 chat_id_;
  string title_;
  object_ptr<Photo> photo_;
  enum Flags : std::int32_t { TITLE_MASK = 1 };

  requestedPeerChat();

  static const std::int32_t ID = 1929860175;

  static object_ptr<RequestedPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class requestedPeerChannel final : public RequestedPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 channel_id_;
  string title_;
  string username_;
  object_ptr<Photo> photo_;
  enum Flags : std::int32_t { TITLE_MASK = 1, USERNAME_MASK = 2 };

  requestedPeerChannel();

  static const std::int32_t ID = -1952185372;

  static object_ptr<RequestedPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class restrictionReason final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string platform_;
  string reason_;
  string text_;

  static const std::int32_t ID = -797791052;

  static object_ptr<restrictionReason> fetch(TlBufferParser &p);

  explicit restrictionReason(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class RichText;

class RichText: public Object {
 public:

  static object_ptr<RichText> fetch(TlBufferParser &p);
};

class textEmpty final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -599948721;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textPlain final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  static const std::int32_t ID = 1950782688;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textPlain(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textBold final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = 1730456516;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textBold(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textItalic final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = -653089380;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textItalic(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textUnderline final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = -1054465340;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textUnderline(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textStrike final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = -1678197867;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textStrike(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textFixed final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = 1816074681;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textFixed(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textUrl final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string url_;
  int64 webpage_id_;

  static const std::int32_t ID = 1009288385;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textUrl(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEmail final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string email_;

  static const std::int32_t ID = -564523562;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textEmail(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textConcat final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<RichText>> texts_;

  static const std::int32_t ID = 2120376535;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textConcat(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textSubscript final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = -311786236;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textSubscript(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textSuperscript final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = -939827711;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textSuperscript(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textMarked final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  static const std::int32_t ID = 55281185;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textMarked(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textPhone final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string phone_;

  static const std::int32_t ID = 483104362;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textPhone(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textImage final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 document_id_;
  int32 w_;
  int32 h_;

  static const std::int32_t ID = 136105807;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textImage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textAnchor final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string name_;

  static const std::int32_t ID = 894777186;

  static object_ptr<RichText> fetch(TlBufferParser &p);

  explicit textAnchor(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class savedPhoneContact final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_;
  string first_name_;
  string last_name_;
  int32 date_;

  static const std::int32_t ID = 289586518;

  static object_ptr<savedPhoneContact> fetch(TlBufferParser &p);

  explicit savedPhoneContact(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class savedDialog final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pinned_;
  object_ptr<Peer> peer_;
  int32 top_message_;

  savedDialog();

  static const std::int32_t ID = -1115174036;

  static object_ptr<savedDialog> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Reaction;

class savedReactionTag final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<Reaction> reaction_;
  string title_;
  int32 count_;
  enum Flags : std::int32_t { TITLE_MASK = 1 };

  savedReactionTag();

  static const std::int32_t ID = -881854424;

  static object_ptr<savedReactionTag> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class StarGift;

class textWithEntities;

class savedStarGift final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool name_hidden_;
  bool unsaved_;
  bool refunded_;
  bool can_upgrade_;
  object_ptr<Peer> from_id_;
  int32 date_;
  object_ptr<StarGift> gift_;
  object_ptr<textWithEntities> message_;
  int32 msg_id_;
  int64 saved_id_;
  int64 convert_stars_;
  int64 upgrade_stars_;
  int32 can_export_at_;
  int64 transfer_stars_;
  enum Flags : std::int32_t { MSG_ID_MASK = 8, SAVED_ID_MASK = 2048, CONVERT_STARS_MASK = 16, UPGRADE_STARS_MASK = 64, CAN_EXPORT_AT_MASK = 128, TRANSFER_STARS_MASK = 256 };

  savedStarGift();

  static const std::int32_t ID = 1616305061;

  static object_ptr<savedStarGift> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchResultsCalendarPeriod final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 date_;
  int32 min_msg_id_;
  int32 max_msg_id_;
  int32 count_;

  static const std::int32_t ID = -911191137;

  static object_ptr<searchResultsCalendarPeriod> fetch(TlBufferParser &p);

  explicit searchResultsCalendarPeriod(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchResultPosition final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 msg_id_;
  int32 date_;
  int32 offset_;

  static const std::int32_t ID = 2137295719;

  static object_ptr<searchResultPosition> fetch(TlBufferParser &p);

  explicit searchResultPosition(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureCredentialsEncrypted final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes data_;
  bytes hash_;
  bytes secret_;

  secureCredentialsEncrypted(bytes &&data_, bytes &&hash_, bytes &&secret_);

  static const std::int32_t ID = 871426631;

  static object_ptr<secureCredentialsEncrypted> fetch(TlBufferParser &p);

  explicit secureCredentialsEncrypted(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureData final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes data_;
  bytes data_hash_;
  bytes secret_;

  secureData(bytes &&data_, bytes &&data_hash_, bytes &&secret_);

  static const std::int32_t ID = -1964327229;

  static object_ptr<secureData> fetch(TlBufferParser &p);

  explicit secureData(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecureFile: public Object {
 public:

  static object_ptr<SecureFile> fetch(TlBufferParser &p);
};

class secureFileEmpty final : public SecureFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1679398724;

  static object_ptr<SecureFile> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureFile final : public SecureFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 access_hash_;
  int64 size_;
  int32 dc_id_;
  int32 date_;
  bytes file_hash_;
  bytes secret_;

  static const std::int32_t ID = 2097791614;

  static object_ptr<SecureFile> fetch(TlBufferParser &p);

  explicit secureFile(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecurePasswordKdfAlgo: public Object {
 public:

  static object_ptr<SecurePasswordKdfAlgo> fetch(TlBufferParser &p);
};

class securePasswordKdfAlgoUnknown final : public SecurePasswordKdfAlgo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 4883767;

  static object_ptr<SecurePasswordKdfAlgo> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class securePasswordKdfAlgoPBKDF2HMACSHA512iter100000 final : public SecurePasswordKdfAlgo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes salt_;

  explicit securePasswordKdfAlgoPBKDF2HMACSHA512iter100000(bytes &&salt_);

  static const std::int32_t ID = -1141711456;

  static object_ptr<SecurePasswordKdfAlgo> fetch(TlBufferParser &p);

  explicit securePasswordKdfAlgoPBKDF2HMACSHA512iter100000(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class securePasswordKdfAlgoSHA512 final : public SecurePasswordKdfAlgo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes salt_;

  explicit securePasswordKdfAlgoSHA512(bytes &&salt_);

  static const std::int32_t ID = -2042159726;

  static object_ptr<SecurePasswordKdfAlgo> fetch(TlBufferParser &p);

  explicit securePasswordKdfAlgoSHA512(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecurePlainData: public Object {
 public:

  static object_ptr<SecurePlainData> fetch(TlBufferParser &p);
};

class securePlainPhone final : public SecurePlainData {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_;

  explicit securePlainPhone(string const &phone_);

  static const std::int32_t ID = 2103482845;

  static object_ptr<SecurePlainData> fetch(TlBufferParser &p);

  explicit securePlainPhone(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class securePlainEmail final : public SecurePlainData {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string email_;

  explicit securePlainEmail(string const &email_);

  static const std::int32_t ID = 569137759;

  static object_ptr<SecurePlainData> fetch(TlBufferParser &p);

  explicit securePlainEmail(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecureRequiredType;

class SecureValueType;

class SecureRequiredType: public Object {
 public:

  static object_ptr<SecureRequiredType> fetch(TlBufferParser &p);
};

class secureRequiredType final : public SecureRequiredType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool native_names_;
  bool selfie_required_;
  bool translation_required_;
  object_ptr<SecureValueType> type_;

  secureRequiredType();

  static const std::int32_t ID = -2103600678;

  static object_ptr<SecureRequiredType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureRequiredTypeOneOf final : public SecureRequiredType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<SecureRequiredType>> types_;

  static const std::int32_t ID = 41187252;

  static object_ptr<SecureRequiredType> fetch(TlBufferParser &p);

  explicit secureRequiredTypeOneOf(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecurePasswordKdfAlgo;

class secureSecretSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecurePasswordKdfAlgo> secure_algo_;
  bytes secure_secret_;
  int64 secure_secret_id_;

  secureSecretSettings(object_ptr<SecurePasswordKdfAlgo> &&secure_algo_, bytes &&secure_secret_, int64 secure_secret_id_);

  static const std::int32_t ID = 354925740;

  static object_ptr<secureSecretSettings> fetch(TlBufferParser &p);

  explicit secureSecretSettings(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecureFile;

class SecurePlainData;

class SecureValueType;

class secureData;

class secureValue final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<SecureValueType> type_;
  object_ptr<secureData> data_;
  object_ptr<SecureFile> front_side_;
  object_ptr<SecureFile> reverse_side_;
  object_ptr<SecureFile> selfie_;
  array<object_ptr<SecureFile>> translation_;
  array<object_ptr<SecureFile>> files_;
  object_ptr<SecurePlainData> plain_data_;
  bytes hash_;

  secureValue();

  static const std::int32_t ID = 411017418;

  static object_ptr<secureValue> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecureValueType;

class SecureValueError: public Object {
 public:

  static object_ptr<SecureValueError> fetch(TlBufferParser &p);
};

class secureValueErrorData final : public SecureValueError {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecureValueType> type_;
  bytes data_hash_;
  string field_;
  string text_;

  secureValueErrorData(object_ptr<SecureValueType> &&type_, bytes &&data_hash_, string const &field_, string const &text_);

  static const std::int32_t ID = -391902247;

  static object_ptr<SecureValueError> fetch(TlBufferParser &p);

  explicit secureValueErrorData(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueErrorFrontSide final : public SecureValueError {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecureValueType> type_;
  bytes file_hash_;
  string text_;

  secureValueErrorFrontSide(object_ptr<SecureValueType> &&type_, bytes &&file_hash_, string const &text_);

  static const std::int32_t ID = 12467706;

  static object_ptr<SecureValueError> fetch(TlBufferParser &p);

  explicit secureValueErrorFrontSide(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueErrorReverseSide final : public SecureValueError {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecureValueType> type_;
  bytes file_hash_;
  string text_;

  secureValueErrorReverseSide(object_ptr<SecureValueType> &&type_, bytes &&file_hash_, string const &text_);

  static const std::int32_t ID = -2037765467;

  static object_ptr<SecureValueError> fetch(TlBufferParser &p);

  explicit secureValueErrorReverseSide(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueErrorSelfie final : public SecureValueError {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecureValueType> type_;
  bytes file_hash_;
  string text_;

  secureValueErrorSelfie(object_ptr<SecureValueType> &&type_, bytes &&file_hash_, string const &text_);

  static const std::int32_t ID = -449327402;

  static object_ptr<SecureValueError> fetch(TlBufferParser &p);

  explicit secureValueErrorSelfie(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueErrorFile final : public SecureValueError {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecureValueType> type_;
  bytes file_hash_;
  string text_;

  secureValueErrorFile(object_ptr<SecureValueType> &&type_, bytes &&file_hash_, string const &text_);

  static const std::int32_t ID = 2054162547;

  static object_ptr<SecureValueError> fetch(TlBufferParser &p);

  explicit secureValueErrorFile(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueErrorFiles final : public SecureValueError {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecureValueType> type_;
  array<bytes> file_hash_;
  string text_;

  secureValueErrorFiles(object_ptr<SecureValueType> &&type_, array<bytes> &&file_hash_, string const &text_);

  static const std::int32_t ID = 1717706985;

  static object_ptr<SecureValueError> fetch(TlBufferParser &p);

  explicit secureValueErrorFiles(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueError final : public SecureValueError {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecureValueType> type_;
  bytes hash_;
  string text_;

  secureValueError(object_ptr<SecureValueType> &&type_, bytes &&hash_, string const &text_);

  static const std::int32_t ID = -2036501105;

  static object_ptr<SecureValueError> fetch(TlBufferParser &p);

  explicit secureValueError(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueErrorTranslationFile final : public SecureValueError {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecureValueType> type_;
  bytes file_hash_;
  string text_;

  secureValueErrorTranslationFile(object_ptr<SecureValueType> &&type_, bytes &&file_hash_, string const &text_);

  static const std::int32_t ID = -1592506512;

  static object_ptr<SecureValueError> fetch(TlBufferParser &p);

  explicit secureValueErrorTranslationFile(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueErrorTranslationFiles final : public SecureValueError {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecureValueType> type_;
  array<bytes> file_hash_;
  string text_;

  secureValueErrorTranslationFiles(object_ptr<SecureValueType> &&type_, array<bytes> &&file_hash_, string const &text_);

  static const std::int32_t ID = 878931416;

  static object_ptr<SecureValueError> fetch(TlBufferParser &p);

  explicit secureValueErrorTranslationFiles(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecureValueType;

class secureValueHash final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<SecureValueType> type_;
  bytes hash_;

  secureValueHash(object_ptr<SecureValueType> &&type_, bytes &&hash_);

  static const std::int32_t ID = -316748368;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecureValueType: public Object {
 public:

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);
};

class secureValueTypePersonalDetails final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1658158621;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypePassport final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1034709504;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypeDriverLicense final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 115615172;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypeIdentityCard final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1596951477;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypeInternalPassport final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1717268701;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypeAddress final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -874308058;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypeUtilityBill final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -63531698;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypeBankStatement final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1995211763;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypeRentalAgreement final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1954007928;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypePassportRegistration final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1713143702;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypeTemporaryRegistration final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -368907213;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypePhone final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1289704741;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureValueTypeEmail final : public SecureValueType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1908627474;

  static object_ptr<SecureValueType> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class sendAsPeer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool premium_required_;
  object_ptr<Peer> peer_;

  sendAsPeer();

  static const std::int32_t ID = -1206095820;

  static object_ptr<sendAsPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dataJSON;

class SendMessageAction: public Object {
 public:

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);
};

class sendMessageTypingAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 381645902;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageCancelAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -44119819;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageRecordVideoAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1584933265;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageUploadVideoAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  explicit sendMessageUploadVideoAction(int32 progress_);

  static const std::int32_t ID = -378127636;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  explicit sendMessageUploadVideoAction(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageRecordAudioAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -718310409;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageUploadAudioAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  explicit sendMessageUploadAudioAction(int32 progress_);

  static const std::int32_t ID = -212740181;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  explicit sendMessageUploadAudioAction(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageUploadPhotoAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  explicit sendMessageUploadPhotoAction(int32 progress_);

  static const std::int32_t ID = -774682074;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  explicit sendMessageUploadPhotoAction(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageUploadDocumentAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  explicit sendMessageUploadDocumentAction(int32 progress_);

  static const std::int32_t ID = -1441998364;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  explicit sendMessageUploadDocumentAction(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageGeoLocationAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 393186209;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageChooseContactAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1653390447;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageGamePlayAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -580219064;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageRecordRoundAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1997373508;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageUploadRoundAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  explicit sendMessageUploadRoundAction(int32 progress_);

  static const std::int32_t ID = 608050278;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  explicit sendMessageUploadRoundAction(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class speakingInGroupCallAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -651419003;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageHistoryImportAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  explicit sendMessageHistoryImportAction(int32 progress_);

  static const std::int32_t ID = -606432698;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  explicit sendMessageHistoryImportAction(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageChooseStickerAction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1336228175;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageEmojiInteraction final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoticon_;
  int32 msg_id_;
  object_ptr<dataJSON> interaction_;

  sendMessageEmojiInteraction(string const &emoticon_, int32 msg_id_, object_ptr<dataJSON> &&interaction_);

  static const std::int32_t ID = 630664139;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  explicit sendMessageEmojiInteraction(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sendMessageEmojiInteractionSeen final : public SendMessageAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoticon_;

  explicit sendMessageEmojiInteractionSeen(string const &emoticon_);

  static const std::int32_t ID = -1234857938;

  static object_ptr<SendMessageAction> fetch(TlBufferParser &p);

  explicit sendMessageEmojiInteractionSeen(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class labeledPrice;

class shippingOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string title_;
  array<object_ptr<labeledPrice>> prices_;

  shippingOption(string const &id_, string const &title_, array<object_ptr<labeledPrice>> &&prices_);

  static const std::int32_t ID = -1239335713;

  static object_ptr<shippingOption> fetch(TlBufferParser &p);

  explicit shippingOption(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class smsJob final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string job_id_;
  string phone_number_;
  string text_;

  static const std::int32_t ID = -425595208;

  static object_ptr<smsJob> fetch(TlBufferParser &p);

  explicit smsJob(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageEntity;

class MessageMedia;

class Photo;

class peerColor;

class sponsoredMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool recommended_;
  bool can_report_;
  bytes random_id_;
  string url_;
  string title_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  object_ptr<Photo> photo_;
  object_ptr<MessageMedia> media_;
  object_ptr<peerColor> color_;
  string button_text_;
  string sponsor_info_;
  string additional_info_;
  enum Flags : std::int32_t { SPONSOR_INFO_MASK = 128, ADDITIONAL_INFO_MASK = 256 };

  sponsoredMessage();

  static const std::int32_t ID = 1301522832;

  static object_ptr<sponsoredMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sponsoredMessageReportOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  bytes option_;

  static const std::int32_t ID = 1124938064;

  static object_ptr<sponsoredMessageReportOption> fetch(TlBufferParser &p);

  explicit sponsoredMessageReportOption(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class Peer;

class StarGiftAttribute;

class StarGift: public Object {
 public:

  static object_ptr<StarGift> fetch(TlBufferParser &p);
};

class starGift final : public StarGift {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool limited_;
  bool sold_out_;
  bool birthday_;
  int64 id_;
  object_ptr<Document> sticker_;
  int64 stars_;
  int32 availability_remains_;
  int32 availability_total_;
  int64 convert_stars_;
  int32 first_sale_date_;
  int32 last_sale_date_;
  int64 upgrade_stars_;
  enum Flags : std::int32_t { AVAILABILITY_REMAINS_MASK = 1, AVAILABILITY_TOTAL_MASK = 1, FIRST_SALE_DATE_MASK = 2, LAST_SALE_DATE_MASK = 2, UPGRADE_STARS_MASK = 8 };

  starGift();

  static const std::int32_t ID = 46953416;

  static object_ptr<StarGift> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starGiftUnique final : public StarGift {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 id_;
  string title_;
  string slug_;
  int32 num_;
  object_ptr<Peer> owner_id_;
  string owner_name_;
  string owner_address_;
  array<object_ptr<StarGiftAttribute>> attributes_;
  int32 availability_issued_;
  int32 availability_total_;
  string gift_address_;
  enum Flags : std::int32_t { OWNER_NAME_MASK = 2, OWNER_ADDRESS_MASK = 4, GIFT_ADDRESS_MASK = 8 };

  starGiftUnique();

  static const std::int32_t ID = 1549979985;

  static object_ptr<StarGift> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class Peer;

class textWithEntities;

class StarGiftAttribute: public Object {
 public:

  static object_ptr<StarGiftAttribute> fetch(TlBufferParser &p);
};

class starGiftAttributeModel final : public StarGiftAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  object_ptr<Document> document_;
  int32 rarity_permille_;

  static const std::int32_t ID = 970559507;

  static object_ptr<StarGiftAttribute> fetch(TlBufferParser &p);

  explicit starGiftAttributeModel(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starGiftAttributePattern final : public StarGiftAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  object_ptr<Document> document_;
  int32 rarity_permille_;

  static const std::int32_t ID = 330104601;

  static object_ptr<StarGiftAttribute> fetch(TlBufferParser &p);

  explicit starGiftAttributePattern(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starGiftAttributeBackdrop final : public StarGiftAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  int32 center_color_;
  int32 edge_color_;
  int32 pattern_color_;
  int32 text_color_;
  int32 rarity_permille_;

  static const std::int32_t ID = -1809377438;

  static object_ptr<StarGiftAttribute> fetch(TlBufferParser &p);

  explicit starGiftAttributeBackdrop(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starGiftAttributeOriginalDetails final : public StarGiftAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<Peer> sender_id_;
  object_ptr<Peer> recipient_id_;
  int32 date_;
  object_ptr<textWithEntities> message_;

  starGiftAttributeOriginalDetails();

  static const std::int32_t ID = -524291476;

  static object_ptr<StarGiftAttribute> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsAmount;

class starRefProgram final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 bot_id_;
  int32 commission_permille_;
  int32 duration_months_;
  int32 end_date_;
  object_ptr<starsAmount> daily_revenue_per_user_;
  enum Flags : std::int32_t { DURATION_MONTHS_MASK = 1, END_DATE_MASK = 2 };

  starRefProgram();

  static const std::int32_t ID = -586389774;

  static object_ptr<starRefProgram> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsAmount final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 amount_;
  int32 nanos_;

  static const std::int32_t ID = -1145654109;

  static object_ptr<starsAmount> fetch(TlBufferParser &p);

  explicit starsAmount(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsGiftOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool extended_;
  int64 stars_;
  string store_product_;
  string currency_;
  int64 amount_;
  enum Flags : std::int32_t { STORE_PRODUCT_MASK = 1 };

  starsGiftOption();

  static const std::int32_t ID = 1577421297;

  static object_ptr<starsGiftOption> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsGiveawayWinnersOption;

class starsGiveawayOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool extended_;
  bool default_;
  int64 stars_;
  int32 yearly_boosts_;
  string store_product_;
  string currency_;
  int64 amount_;
  array<object_ptr<starsGiveawayWinnersOption>> winners_;
  enum Flags : std::int32_t { STORE_PRODUCT_MASK = 4 };

  starsGiveawayOption();

  static const std::int32_t ID = -1798404822;

  static object_ptr<starsGiveawayOption> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsGiveawayWinnersOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool default_;
  int32 users_;
  int64 per_user_stars_;

  starsGiveawayWinnersOption();

  static const std::int32_t ID = 1411605001;

  static object_ptr<starsGiveawayWinnersOption> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsAmount;

class starsRevenueStatus final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool withdrawal_enabled_;
  object_ptr<starsAmount> current_balance_;
  object_ptr<starsAmount> available_balance_;
  object_ptr<starsAmount> overall_revenue_;
  int32 next_withdrawal_at_;
  enum Flags : std::int32_t { NEXT_WITHDRAWAL_AT_MASK = 2 };

  starsRevenueStatus();

  static const std::int32_t ID = -21080943;

  static object_ptr<starsRevenueStatus> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class WebDocument;

class starsSubscriptionPricing;

class starsSubscription final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool canceled_;
  bool can_refulfill_;
  bool missing_balance_;
  bool bot_canceled_;
  string id_;
  object_ptr<Peer> peer_;
  int32 until_date_;
  object_ptr<starsSubscriptionPricing> pricing_;
  string chat_invite_hash_;
  string title_;
  object_ptr<WebDocument> photo_;
  string invoice_slug_;
  enum Flags : std::int32_t { CHAT_INVITE_HASH_MASK = 8, TITLE_MASK = 16, INVOICE_SLUG_MASK = 64 };

  starsSubscription();

  static const std::int32_t ID = 779004698;

  static object_ptr<starsSubscription> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsSubscriptionPricing final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 period_;
  int64 amount_;

  starsSubscriptionPricing(int32 period_, int64 amount_);

  static const std::int32_t ID = 88173912;

  static object_ptr<starsSubscriptionPricing> fetch(TlBufferParser &p);

  explicit starsSubscriptionPricing(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsTopupOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool extended_;
  int64 stars_;
  string store_product_;
  string currency_;
  int64 amount_;
  enum Flags : std::int32_t { STORE_PRODUCT_MASK = 1 };

  starsTopupOption();

  static const std::int32_t ID = 198776256;

  static object_ptr<starsTopupOption> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageMedia;

class Peer;

class StarGift;

class StarsTransactionPeer;

class WebDocument;

class starsAmount;

class starsTransaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool refund_;
  bool pending_;
  bool failed_;
  bool gift_;
  bool reaction_;
  bool stargift_upgrade_;
  string id_;
  object_ptr<starsAmount> stars_;
  int32 date_;
  object_ptr<StarsTransactionPeer> peer_;
  string title_;
  string description_;
  object_ptr<WebDocument> photo_;
  int32 transaction_date_;
  string transaction_url_;
  bytes bot_payload_;
  int32 msg_id_;
  array<object_ptr<MessageMedia>> extended_media_;
  int32 subscription_period_;
  int32 giveaway_post_id_;
  object_ptr<StarGift> stargift_;
  int32 floodskip_number_;
  int32 starref_commission_permille_;
  object_ptr<Peer> starref_peer_;
  object_ptr<starsAmount> starref_amount_;
  enum Flags : std::int32_t { TITLE_MASK = 1, DESCRIPTION_MASK = 2, TRANSACTION_DATE_MASK = 32, TRANSACTION_URL_MASK = 32, BOT_PAYLOAD_MASK = 128, MSG_ID_MASK = 256, SUBSCRIPTION_PERIOD_MASK = 4096, GIVEAWAY_POST_ID_MASK = 8192, FLOODSKIP_NUMBER_MASK = 32768, STARREF_COMMISSION_PERMILLE_MASK = 65536 };

  starsTransaction();

  static const std::int32_t ID = 1692387622;

  static object_ptr<starsTransaction> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class StarsTransactionPeer: public Object {
 public:

  static object_ptr<StarsTransactionPeer> fetch(TlBufferParser &p);
};

class starsTransactionPeerUnsupported final : public StarsTransactionPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1779253276;

  static object_ptr<StarsTransactionPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsTransactionPeerAppStore final : public StarsTransactionPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1269320843;

  static object_ptr<StarsTransactionPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsTransactionPeerPlayMarket final : public StarsTransactionPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2069236235;

  static object_ptr<StarsTransactionPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsTransactionPeerPremiumBot final : public StarsTransactionPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 621656824;

  static object_ptr<StarsTransactionPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsTransactionPeerFragment final : public StarsTransactionPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -382740222;

  static object_ptr<StarsTransactionPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsTransactionPeer final : public StarsTransactionPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;

  static const std::int32_t ID = -670195363;

  static object_ptr<StarsTransactionPeer> fetch(TlBufferParser &p);

  explicit starsTransactionPeer(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsTransactionPeerAds final : public StarsTransactionPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1617438738;

  static object_ptr<StarsTransactionPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starsTransactionPeerAPI final : public StarsTransactionPeer {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -110658899;

  static object_ptr<StarsTransactionPeer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statsAbsValueAndPrev final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double current_;
  double previous_;

  static const std::int32_t ID = -884757282;

  static object_ptr<statsAbsValueAndPrev> fetch(TlBufferParser &p);

  explicit statsAbsValueAndPrev(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statsDateRangeDays final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 min_date_;
  int32 max_date_;

  static const std::int32_t ID = -1237848657;

  static object_ptr<statsDateRangeDays> fetch(TlBufferParser &p);

  explicit statsDateRangeDays(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dataJSON;

class StatsGraph: public Object {
 public:

  static object_ptr<StatsGraph> fetch(TlBufferParser &p);
};

class statsGraphAsync final : public StatsGraph {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  static const std::int32_t ID = 1244130093;

  static object_ptr<StatsGraph> fetch(TlBufferParser &p);

  explicit statsGraphAsync(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statsGraphError final : public StatsGraph {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string error_;

  static const std::int32_t ID = -1092839390;

  static object_ptr<StatsGraph> fetch(TlBufferParser &p);

  explicit statsGraphError(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statsGraph final : public StatsGraph {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<dataJSON> json_;
  string zoom_token_;
  enum Flags : std::int32_t { ZOOM_TOKEN_MASK = 1 };

  statsGraph();

  static const std::int32_t ID = -1901828938;

  static object_ptr<StatsGraph> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statsGroupTopAdmin final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  int32 deleted_;
  int32 kicked_;
  int32 banned_;

  static const std::int32_t ID = -682079097;

  static object_ptr<statsGroupTopAdmin> fetch(TlBufferParser &p);

  explicit statsGroupTopAdmin(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statsGroupTopInviter final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  int32 invitations_;

  static const std::int32_t ID = 1398765469;

  static object_ptr<statsGroupTopInviter> fetch(TlBufferParser &p);

  explicit statsGroupTopInviter(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statsGroupTopPoster final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  int32 messages_;
  int32 avg_chars_;

  static const std::int32_t ID = -1660637285;

  static object_ptr<statsGroupTopPoster> fetch(TlBufferParser &p);

  explicit statsGroupTopPoster(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statsPercentValue final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double part_;
  double total_;

  static const std::int32_t ID = -875679776;

  static object_ptr<statsPercentValue> fetch(TlBufferParser &p);

  explicit statsPercentValue(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statsURL final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  static const std::int32_t ID = 1202287072;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerKeyword final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 document_id_;
  array<string> keyword_;

  static const std::int32_t ID = -50416996;

  static object_ptr<stickerKeyword> fetch(TlBufferParser &p);

  explicit stickerKeyword(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerPack final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoticon_;
  array<int64> documents_;

  static const std::int32_t ID = 313694676;

  static object_ptr<stickerPack> fetch(TlBufferParser &p);

  explicit stickerPack(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PhotoSize;

class stickerSet final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool archived_;
  bool official_;
  bool masks_;
  bool emojis_;
  bool text_color_;
  bool channel_emoji_status_;
  bool creator_;
  int32 installed_date_;
  int64 id_;
  int64 access_hash_;
  string title_;
  string short_name_;
  array<object_ptr<PhotoSize>> thumbs_;
  int32 thumb_dc_id_;
  int32 thumb_version_;
  int64 thumb_document_id_;
  int32 count_;
  int32 hash_;
  enum Flags : std::int32_t { INSTALLED_DATE_MASK = 1, THUMB_DC_ID_MASK = 16, THUMB_VERSION_MASK = 16, THUMB_DOCUMENT_ID_MASK = 256 };

  stickerSet();

  static const std::int32_t ID = 768691932;

  static object_ptr<stickerSet> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class stickerKeyword;

class stickerPack;

class stickerSet;

class StickerSetCovered: public Object {
 public:

  static object_ptr<StickerSetCovered> fetch(TlBufferParser &p);
};

class stickerSetCovered final : public StickerSetCovered {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<stickerSet> set_;
  object_ptr<Document> cover_;

  static const std::int32_t ID = 1678812626;

  static object_ptr<StickerSetCovered> fetch(TlBufferParser &p);

  explicit stickerSetCovered(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerSetMultiCovered final : public StickerSetCovered {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<stickerSet> set_;
  array<object_ptr<Document>> covers_;

  static const std::int32_t ID = 872932635;

  static object_ptr<StickerSetCovered> fetch(TlBufferParser &p);

  explicit stickerSetMultiCovered(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerSetFullCovered final : public StickerSetCovered {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<stickerSet> set_;
  array<object_ptr<stickerPack>> packs_;
  array<object_ptr<stickerKeyword>> keywords_;
  array<object_ptr<Document>> documents_;

  static const std::int32_t ID = 1087454222;

  static object_ptr<StickerSetCovered> fetch(TlBufferParser &p);

  explicit stickerSetFullCovered(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerSetNoCovered final : public StickerSetCovered {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<stickerSet> set_;

  static const std::int32_t ID = 2008112412;

  static object_ptr<StickerSetCovered> fetch(TlBufferParser &p);

  explicit stickerSetNoCovered(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storiesStealthMode final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 active_until_date_;
  int32 cooldown_until_date_;
  enum Flags : std::int32_t { ACTIVE_UNTIL_DATE_MASK = 1, COOLDOWN_UNTIL_DATE_MASK = 2 };

  storiesStealthMode();

  static const std::int32_t ID = 1898850301;

  static object_ptr<storiesStealthMode> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class storyFwdHeader final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool modified_;
  object_ptr<Peer> from_;
  string from_name_;
  int32 story_id_;
  enum Flags : std::int32_t { FROM_NAME_MASK = 2, STORY_ID_MASK = 4 };

  storyFwdHeader();

  static const std::int32_t ID = -1205411504;

  static object_ptr<storyFwdHeader> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MediaArea;

class MessageEntity;

class MessageMedia;

class Peer;

class PrivacyRule;

class Reaction;

class storyFwdHeader;

class storyViews;

class StoryItem: public Object {
 public:

  static object_ptr<StoryItem> fetch(TlBufferParser &p);
};

class storyItemDeleted final : public StoryItem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;

  static const std::int32_t ID = 1374088783;

  static object_ptr<StoryItem> fetch(TlBufferParser &p);

  explicit storyItemDeleted(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyItemSkipped final : public StoryItem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool close_friends_;
  int32 id_;
  int32 date_;
  int32 expire_date_;

  storyItemSkipped();

  static const std::int32_t ID = -5388013;

  static object_ptr<StoryItem> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyItem final : public StoryItem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pinned_;
  bool public_;
  bool close_friends_;
  bool min_;
  bool noforwards_;
  bool edited_;
  bool contacts_;
  bool selected_contacts_;
  bool out_;
  int32 id_;
  int32 date_;
  object_ptr<Peer> from_id_;
  object_ptr<storyFwdHeader> fwd_from_;
  int32 expire_date_;
  string caption_;
  array<object_ptr<MessageEntity>> entities_;
  object_ptr<MessageMedia> media_;
  array<object_ptr<MediaArea>> media_areas_;
  array<object_ptr<PrivacyRule>> privacy_;
  object_ptr<storyViews> views_;
  object_ptr<Reaction> sent_reaction_;
  enum Flags : std::int32_t { CAPTION_MASK = 1 };

  storyItem();

  static const std::int32_t ID = 2041735716;

  static object_ptr<StoryItem> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Message;

class Peer;

class Reaction;

class StoryItem;

class StoryReaction: public Object {
 public:

  static object_ptr<StoryReaction> fetch(TlBufferParser &p);
};

class storyReaction final : public StoryReaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_id_;
  int32 date_;
  object_ptr<Reaction> reaction_;

  static const std::int32_t ID = 1620104917;

  static object_ptr<StoryReaction> fetch(TlBufferParser &p);

  explicit storyReaction(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyReactionPublicForward final : public StoryReaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;

  static const std::int32_t ID = -1146411453;

  static object_ptr<StoryReaction> fetch(TlBufferParser &p);

  explicit storyReactionPublicForward(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyReactionPublicRepost final : public StoryReaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_id_;
  object_ptr<StoryItem> story_;

  static const std::int32_t ID = -808644845;

  static object_ptr<StoryReaction> fetch(TlBufferParser &p);

  explicit storyReactionPublicRepost(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Message;

class Peer;

class Reaction;

class StoryItem;

class StoryView: public Object {
 public:

  static object_ptr<StoryView> fetch(TlBufferParser &p);
};

class storyView final : public StoryView {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool blocked_;
  bool blocked_my_stories_from_;
  int64 user_id_;
  int32 date_;
  object_ptr<Reaction> reaction_;

  storyView();

  static const std::int32_t ID = -1329730875;

  static object_ptr<StoryView> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyViewPublicForward final : public StoryView {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool blocked_;
  bool blocked_my_stories_from_;
  object_ptr<Message> message_;

  storyViewPublicForward();

  static const std::int32_t ID = -1870436597;

  static object_ptr<StoryView> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyViewPublicRepost final : public StoryView {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool blocked_;
  bool blocked_my_stories_from_;
  object_ptr<Peer> peer_id_;
  object_ptr<StoryItem> story_;

  storyViewPublicRepost();

  static const std::int32_t ID = -1116418231;

  static object_ptr<StoryView> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reactionCount;

class storyViews final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool has_viewers_;
  int32 views_count_;
  int32 forwards_count_;
  array<object_ptr<reactionCount>> reactions_;
  int32 reactions_count_;
  array<int64> recent_viewers_;
  enum Flags : std::int32_t { FORWARDS_COUNT_MASK = 4, REACTIONS_COUNT_MASK = 16 };

  storyViews();

  static const std::int32_t ID = -1923523370;

  static object_ptr<storyViews> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageEntity;

class textWithEntities final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  array<object_ptr<MessageEntity>> entities_;

  textWithEntities(string const &text_, array<object_ptr<MessageEntity>> &&entities_);

  static const std::int32_t ID = 1964978502;

  static object_ptr<textWithEntities> fetch(TlBufferParser &p);

  explicit textWithEntities(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class themeSettings;

class theme final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool creator_;
  bool default_;
  bool for_chat_;
  int64 id_;
  int64 access_hash_;
  string slug_;
  string title_;
  object_ptr<Document> document_;
  array<object_ptr<themeSettings>> settings_;
  string emoticon_;
  int32 installs_count_;
  enum Flags : std::int32_t { EMOTICON_MASK = 64, INSTALLS_COUNT_MASK = 16 };

  theme();

  static const std::int32_t ID = -1609668650;

  static object_ptr<theme> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BaseTheme;

class WallPaper;

class themeSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool message_colors_animated_;
  object_ptr<BaseTheme> base_theme_;
  int32 accent_color_;
  int32 outbox_accent_color_;
  array<int32> message_colors_;
  object_ptr<WallPaper> wallpaper_;
  enum Flags : std::int32_t { OUTBOX_ACCENT_COLOR_MASK = 8 };

  themeSettings();

  static const std::int32_t ID = -94849324;

  static object_ptr<themeSettings> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class timezone final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string name_;
  int32 utc_offset_;

  static const std::int32_t ID = -7173643;

  static object_ptr<timezone> fetch(TlBufferParser &p);

  explicit timezone(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Peer;

class topPeer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  double rating_;

  static const std::int32_t ID = -305282981;

  static object_ptr<topPeer> fetch(TlBufferParser &p);

  explicit topPeer(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class TopPeerCategory: public Object {
 public:

  static object_ptr<TopPeerCategory> fetch(TlBufferParser &p);
};

class topPeerCategoryBotsPM final : public TopPeerCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1419371685;

  static object_ptr<TopPeerCategory> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topPeerCategoryBotsInline final : public TopPeerCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 344356834;

  static object_ptr<TopPeerCategory> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topPeerCategoryCorrespondents final : public TopPeerCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 104314861;

  static object_ptr<TopPeerCategory> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topPeerCategoryGroups final : public TopPeerCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1122524854;

  static object_ptr<TopPeerCategory> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topPeerCategoryChannels final : public TopPeerCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 371037736;

  static object_ptr<TopPeerCategory> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topPeerCategoryPhoneCalls final : public TopPeerCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 511092620;

  static object_ptr<TopPeerCategory> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topPeerCategoryForwardUsers final : public TopPeerCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1472172887;

  static object_ptr<TopPeerCategory> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topPeerCategoryForwardChats final : public TopPeerCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -68239120;

  static object_ptr<TopPeerCategory> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topPeerCategoryBotsApp final : public TopPeerCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -39945236;

  static object_ptr<TopPeerCategory> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class TopPeerCategory;

class topPeer;

class topPeerCategoryPeers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<TopPeerCategory> category_;
  int32 count_;
  array<object_ptr<topPeer>> peers_;

  static const std::int32_t ID = -75283823;

  static object_ptr<topPeerCategoryPeers> fetch(TlBufferParser &p);

  explicit topPeerCategoryPeers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotMenuButton;

class ChannelParticipant;

class ChatParticipant;

class ChatParticipants;

class DialogFilter;

class DialogPeer;

class DraftMessage;

class EmojiStatus;

class EncryptedChat;

class EncryptedMessage;

class ExportedChatInvite;

class GeoPoint;

class GroupCall;

class InlineQueryPeerType;

class InputBotInlineMessageID;

class Message;

class MessageEntity;

class MessageExtendedMedia;

class MessageMedia;

class NotifyPeer;

class PaidReactionPrivacy;

class Peer;

class PeerLocated;

class PhoneCall;

class PrivacyKey;

class PrivacyRule;

class Reaction;

class SendMessageAction;

class StoryItem;

class UserStatus;

class WallPaper;

class WebPage;

class boost;

class botBusinessConnection;

class botCommand;

class broadcastRevenueBalances;

class chatBannedRights;

class dataJSON;

class dcOption;

class folderPeer;

class groupCallParticipant;

class inputGroupCall;

class langPackDifference;

class messageReactions;

class messages_StickerSet;

class paymentRequestedInfo;

class peerNotifySettings;

class peerSettings;

class poll;

class pollResults;

class postAddress;

class quickReply;

class reactionCount;

class starsAmount;

class starsRevenueStatus;

class storiesStealthMode;

class theme;

class username;

class Update: public Object {
 public:

  static object_ptr<Update> fetch(TlBufferParser &p);
};

class updateNewMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;
  int32 pts_;
  int32 pts_count_;

  updateNewMessage(object_ptr<Message> &&message_, int32 pts_, int32 pts_count_);

  static const std::int32_t ID = 522914557;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateNewMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageID final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int64 random_id_;

  static const std::int32_t ID = 1318109142;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateMessageID(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDeleteMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> messages_;
  int32 pts_;
  int32 pts_count_;

  updateDeleteMessages(array<int32> &&messages_, int32 pts_, int32 pts_count_);

  static const std::int32_t ID = -1576161051;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateDeleteMessages(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUserTyping final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  object_ptr<SendMessageAction> action_;

  static const std::int32_t ID = -1071741569;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateUserTyping(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatUserTyping final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;
  object_ptr<Peer> from_id_;
  object_ptr<SendMessageAction> action_;

  static const std::int32_t ID = -2092401936;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChatUserTyping(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatParticipants final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChatParticipants> participants_;

  static const std::int32_t ID = 125178264;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChatParticipants(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUserStatus final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  object_ptr<UserStatus> status_;

  static const std::int32_t ID = -440534818;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateUserStatus(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUserName final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  string first_name_;
  string last_name_;
  array<object_ptr<username>> usernames_;

  static const std::int32_t ID = -1484486364;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateUserName(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewAuthorization final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool unconfirmed_;
  int64 hash_;
  int32 date_;
  string device_;
  string location_;
  enum Flags : std::int32_t { DATE_MASK = 1, DEVICE_MASK = 1, LOCATION_MASK = 1 };

  updateNewAuthorization();

  static const std::int32_t ID = -1991136273;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewEncryptedMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<EncryptedMessage> message_;
  int32 qts_;

  static const std::int32_t ID = 314359194;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateNewEncryptedMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateEncryptedChatTyping final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_id_;

  static const std::int32_t ID = 386986326;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateEncryptedChatTyping(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateEncryption final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<EncryptedChat> chat_;
  int32 date_;

  static const std::int32_t ID = -1264392051;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateEncryption(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateEncryptedMessagesRead final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_id_;
  int32 max_date_;
  int32 date_;

  static const std::int32_t ID = 956179895;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateEncryptedMessagesRead(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatParticipantAdd final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;
  int64 user_id_;
  int64 inviter_id_;
  int32 date_;
  int32 version_;

  static const std::int32_t ID = 1037718609;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChatParticipantAdd(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatParticipantDelete final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;
  int64 user_id_;
  int32 version_;

  static const std::int32_t ID = -483443337;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChatParticipantDelete(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDcOptions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<dcOption>> dc_options_;

  static const std::int32_t ID = -1906403213;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateDcOptions(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNotifySettings final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<NotifyPeer> peer_;
  object_ptr<peerNotifySettings> notify_settings_;

  static const std::int32_t ID = -1094555409;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateNotifySettings(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateServiceNotification final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool popup_;
  bool invert_media_;
  int32 inbox_date_;
  string type_;
  string message_;
  object_ptr<MessageMedia> media_;
  array<object_ptr<MessageEntity>> entities_;
  enum Flags : std::int32_t { INBOX_DATE_MASK = 2 };

  updateServiceNotification();

  updateServiceNotification(int32 flags_, bool popup_, bool invert_media_, int32 inbox_date_, string const &type_, string const &message_, object_ptr<MessageMedia> &&media_, array<object_ptr<MessageEntity>> &&entities_);

  static const std::int32_t ID = -337352679;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePrivacy final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PrivacyKey> key_;
  array<object_ptr<PrivacyRule>> rules_;

  static const std::int32_t ID = -298113238;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updatePrivacy(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUserPhone final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  string phone_;

  static const std::int32_t ID = 88680979;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateUserPhone(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReadHistoryInbox final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 folder_id_;
  object_ptr<Peer> peer_;
  int32 max_id_;
  int32 still_unread_count_;
  int32 pts_;
  int32 pts_count_;
  enum Flags : std::int32_t { FOLDER_ID_MASK = 1 };

  updateReadHistoryInbox();

  static const std::int32_t ID = -1667805217;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReadHistoryOutbox final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 max_id_;
  int32 pts_;
  int32 pts_count_;

  static const std::int32_t ID = 791617983;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateReadHistoryOutbox(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateWebPage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<WebPage> webpage_;
  int32 pts_;
  int32 pts_count_;

  static const std::int32_t ID = 2139689491;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateWebPage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReadMessagesContents final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  array<int32> messages_;
  int32 pts_;
  int32 pts_count_;
  int32 date_;
  enum Flags : std::int32_t { DATE_MASK = 1 };

  updateReadMessagesContents();

  static const std::int32_t ID = -131960447;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelTooLong final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 channel_id_;
  int32 pts_;
  enum Flags : std::int32_t { PTS_MASK = 1 };

  updateChannelTooLong();

  updateChannelTooLong(int32 flags_, int64 channel_id_, int32 pts_);

  static const std::int32_t ID = 277713951;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannel final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;

  static const std::int32_t ID = 1666927625;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChannel(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewChannelMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;
  int32 pts_;
  int32 pts_count_;

  static const std::int32_t ID = 1656358105;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateNewChannelMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReadChannelInbox final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 folder_id_;
  int64 channel_id_;
  int32 max_id_;
  int32 still_unread_count_;
  int32 pts_;
  enum Flags : std::int32_t { FOLDER_ID_MASK = 1 };

  updateReadChannelInbox();

  static const std::int32_t ID = -1842450928;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDeleteChannelMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;
  array<int32> messages_;
  int32 pts_;
  int32 pts_count_;

  static const std::int32_t ID = -1020437742;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateDeleteChannelMessages(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelMessageViews final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;
  int32 id_;
  int32 views_;

  static const std::int32_t ID = -232346616;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChannelMessageViews(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatParticipantAdmin final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;
  int64 user_id_;
  bool is_admin_;
  int32 version_;

  static const std::int32_t ID = -674602590;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChatParticipantAdmin(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewStickerSet final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<messages_StickerSet> stickerset_;

  static const std::int32_t ID = 1753886890;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateNewStickerSet(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStickerSetsOrder final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool masks_;
  bool emojis_;
  array<int64> order_;

  updateStickerSetsOrder();

  static const std::int32_t ID = 196268545;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStickerSets final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool masks_;
  bool emojis_;

  updateStickerSets();

  static const std::int32_t ID = 834816008;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSavedGifs final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1821035490;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotInlineQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 query_id_;
  int64 user_id_;
  string query_;
  object_ptr<GeoPoint> geo_;
  object_ptr<InlineQueryPeerType> peer_type_;
  string offset_;

  updateBotInlineQuery();

  static const std::int32_t ID = 1232025500;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotInlineSend final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 user_id_;
  string query_;
  object_ptr<GeoPoint> geo_;
  string id_;
  object_ptr<InputBotInlineMessageID> msg_id_;

  updateBotInlineSend();

  static const std::int32_t ID = 317794823;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateEditChannelMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;
  int32 pts_;
  int32 pts_count_;

  updateEditChannelMessage(object_ptr<Message> &&message_, int32 pts_, int32 pts_count_);

  static const std::int32_t ID = 457133559;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateEditChannelMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotCallbackQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 query_id_;
  int64 user_id_;
  object_ptr<Peer> peer_;
  int32 msg_id_;
  int64 chat_instance_;
  bytes data_;
  string game_short_name_;
  enum Flags : std::int32_t { DATA_MASK = 1, GAME_SHORT_NAME_MASK = 2 };

  updateBotCallbackQuery();

  static const std::int32_t ID = -1177566067;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateEditMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;
  int32 pts_;
  int32 pts_count_;

  static const std::int32_t ID = -469536605;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateEditMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateInlineBotCallbackQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 query_id_;
  int64 user_id_;
  object_ptr<InputBotInlineMessageID> msg_id_;
  int64 chat_instance_;
  bytes data_;
  string game_short_name_;
  enum Flags : std::int32_t { DATA_MASK = 1, GAME_SHORT_NAME_MASK = 2 };

  updateInlineBotCallbackQuery();

  static const std::int32_t ID = 1763610706;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReadChannelOutbox final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;
  int32 max_id_;

  static const std::int32_t ID = -1218471511;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateReadChannelOutbox(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDraftMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<Peer> peer_;
  int32 top_msg_id_;
  object_ptr<DraftMessage> draft_;
  enum Flags : std::int32_t { TOP_MSG_ID_MASK = 1 };

  updateDraftMessage();

  static const std::int32_t ID = 457829485;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReadFeaturedStickers final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1461528386;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateRecentStickers final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1706939360;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateConfig final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1574314746;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePtsChanged final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 861169551;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelWebPage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;
  object_ptr<WebPage> webpage_;
  int32 pts_;
  int32 pts_count_;

  static const std::int32_t ID = 791390623;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChannelWebPage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDialogPinned final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pinned_;
  int32 folder_id_;
  object_ptr<DialogPeer> peer_;
  enum Flags : std::int32_t { FOLDER_ID_MASK = 2 };

  updateDialogPinned();

  static const std::int32_t ID = 1852826908;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePinnedDialogs final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 folder_id_;
  array<object_ptr<DialogPeer>> order_;
  enum Flags : std::int32_t { FOLDER_ID_MASK = 2 };

  updatePinnedDialogs();

  static const std::int32_t ID = -99664734;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotWebhookJSON final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<dataJSON> data_;

  static const std::int32_t ID = -2095595325;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotWebhookJSON(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotWebhookJSONQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 query_id_;
  object_ptr<dataJSON> data_;
  int32 timeout_;

  static const std::int32_t ID = -1684914010;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotWebhookJSONQuery(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotShippingQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 query_id_;
  int64 user_id_;
  bytes payload_;
  object_ptr<postAddress> shipping_address_;

  static const std::int32_t ID = -1246823043;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotShippingQuery(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotPrecheckoutQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 query_id_;
  int64 user_id_;
  bytes payload_;
  object_ptr<paymentRequestedInfo> info_;
  string shipping_option_id_;
  string currency_;
  int64 total_amount_;
  enum Flags : std::int32_t { SHIPPING_OPTION_ID_MASK = 2 };

  updateBotPrecheckoutQuery();

  static const std::int32_t ID = -1934976362;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePhoneCall final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PhoneCall> phone_call_;

  static const std::int32_t ID = -1425052898;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updatePhoneCall(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateLangPackTooLong final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_code_;

  static const std::int32_t ID = 1180041828;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateLangPackTooLong(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateLangPack final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<langPackDifference> difference_;

  static const std::int32_t ID = 1442983757;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateLangPack(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFavedStickers final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -451831443;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelReadMessagesContents final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 channel_id_;
  int32 top_msg_id_;
  array<int32> messages_;
  enum Flags : std::int32_t { TOP_MSG_ID_MASK = 1 };

  updateChannelReadMessagesContents();

  static const std::int32_t ID = -366410403;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateContactsReset final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1887741886;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelAvailableMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;
  int32 available_min_id_;

  static const std::int32_t ID = -1304443240;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChannelAvailableMessages(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDialogUnreadMark final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool unread_;
  object_ptr<DialogPeer> peer_;

  updateDialogUnreadMark();

  static const std::int32_t ID = -513517117;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessagePoll final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 poll_id_;
  object_ptr<poll> poll_;
  object_ptr<pollResults> results_;

  updateMessagePoll();

  static const std::int32_t ID = -1398708869;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatDefaultBannedRights final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  object_ptr<chatBannedRights> default_banned_rights_;
  int32 version_;

  static const std::int32_t ID = 1421875280;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChatDefaultBannedRights(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFolderPeers final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<folderPeer>> folder_peers_;
  int32 pts_;
  int32 pts_count_;

  static const std::int32_t ID = 422972864;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateFolderPeers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePeerSettings final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  object_ptr<peerSettings> settings_;

  static const std::int32_t ID = 1786671974;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updatePeerSettings(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePeerLocated final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PeerLocated>> peers_;

  static const std::int32_t ID = -1263546448;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updatePeerLocated(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewScheduledMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;

  static const std::int32_t ID = 967122427;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateNewScheduledMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDeleteScheduledMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<Peer> peer_;
  array<int32> messages_;
  array<int32> sent_messages_;

  updateDeleteScheduledMessages();

  static const std::int32_t ID = -223929981;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateTheme final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<theme> theme_;

  static const std::int32_t ID = -2112423005;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateTheme(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateGeoLiveViewed final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 msg_id_;

  static const std::int32_t ID = -2027964103;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateGeoLiveViewed(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateLoginToken final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1448076945;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessagePollVote final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 poll_id_;
  object_ptr<Peer> peer_;
  array<bytes> options_;
  int32 qts_;

  static const std::int32_t ID = 619974263;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateMessagePollVote(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDialogFilter final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 id_;
  object_ptr<DialogFilter> filter_;

  updateDialogFilter();

  static const std::int32_t ID = 654302845;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDialogFilterOrder final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> order_;

  static const std::int32_t ID = -1512627963;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateDialogFilterOrder(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDialogFilters final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 889491791;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePhoneCallSignalingData final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 phone_call_id_;
  bytes data_;

  static const std::int32_t ID = 643940105;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updatePhoneCallSignalingData(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelMessageForwards final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;
  int32 id_;
  int32 forwards_;

  static const std::int32_t ID = -761649164;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChannelMessageForwards(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReadChannelDiscussionInbox final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 channel_id_;
  int32 top_msg_id_;
  int32 read_max_id_;
  int64 broadcast_id_;
  int32 broadcast_post_;
  enum Flags : std::int32_t { BROADCAST_ID_MASK = 1, BROADCAST_POST_MASK = 1 };

  updateReadChannelDiscussionInbox();

  static const std::int32_t ID = -693004986;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReadChannelDiscussionOutbox final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;
  int32 top_msg_id_;
  int32 read_max_id_;

  static const std::int32_t ID = 1767677564;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateReadChannelDiscussionOutbox(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePeerBlocked final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool blocked_;
  bool blocked_my_stories_from_;
  object_ptr<Peer> peer_id_;

  updatePeerBlocked();

  static const std::int32_t ID = -337610926;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelUserTyping final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 channel_id_;
  int32 top_msg_id_;
  object_ptr<Peer> from_id_;
  object_ptr<SendMessageAction> action_;
  enum Flags : std::int32_t { TOP_MSG_ID_MASK = 1 };

  updateChannelUserTyping();

  static const std::int32_t ID = -1937192669;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePinnedMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pinned_;
  object_ptr<Peer> peer_;
  array<int32> messages_;
  int32 pts_;
  int32 pts_count_;

  updatePinnedMessages();

  static const std::int32_t ID = -309990731;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePinnedChannelMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pinned_;
  int64 channel_id_;
  array<int32> messages_;
  int32 pts_;
  int32 pts_count_;

  updatePinnedChannelMessages();

  static const std::int32_t ID = 1538885128;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChat final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;

  static const std::int32_t ID = -124097970;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChat(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateGroupCallParticipants final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputGroupCall> call_;
  array<object_ptr<groupCallParticipant>> participants_;
  int32 version_;

  static const std::int32_t ID = -219423922;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateGroupCallParticipants(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateGroupCall final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 chat_id_;
  object_ptr<GroupCall> call_;
  enum Flags : std::int32_t { CHAT_ID_MASK = 1 };

  updateGroupCall();

  static const std::int32_t ID = -1747565759;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePeerHistoryTTL final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<Peer> peer_;
  int32 ttl_period_;
  enum Flags : std::int32_t { TTL_PERIOD_MASK = 1 };

  updatePeerHistoryTTL();

  static const std::int32_t ID = -1147422299;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatParticipant final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 chat_id_;
  int32 date_;
  int64 actor_id_;
  int64 user_id_;
  object_ptr<ChatParticipant> prev_participant_;
  object_ptr<ChatParticipant> new_participant_;
  object_ptr<ExportedChatInvite> invite_;
  int32 qts_;

  updateChatParticipant();

  static const std::int32_t ID = -796432838;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelParticipant final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool via_chatlist_;
  int64 channel_id_;
  int32 date_;
  int64 actor_id_;
  int64 user_id_;
  object_ptr<ChannelParticipant> prev_participant_;
  object_ptr<ChannelParticipant> new_participant_;
  object_ptr<ExportedChatInvite> invite_;
  int32 qts_;

  updateChannelParticipant();

  static const std::int32_t ID = -1738720581;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotStopped final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  int32 date_;
  bool stopped_;
  int32 qts_;

  static const std::int32_t ID = -997782967;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotStopped(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateGroupCallConnection final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool presentation_;
  object_ptr<dataJSON> params_;

  updateGroupCallConnection();

  static const std::int32_t ID = 192428418;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotCommands final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int64 bot_id_;
  array<object_ptr<botCommand>> commands_;

  static const std::int32_t ID = 1299263278;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotCommands(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePendingJoinRequests final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 requests_pending_;
  array<int64> recent_requesters_;

  static const std::int32_t ID = 1885586395;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updatePendingJoinRequests(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotChatInviteRequester final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 date_;
  int64 user_id_;
  string about_;
  object_ptr<ExportedChatInvite> invite_;
  int32 qts_;

  static const std::int32_t ID = 299870598;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotChatInviteRequester(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageReactions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<Peer> peer_;
  int32 msg_id_;
  int32 top_msg_id_;
  object_ptr<messageReactions> reactions_;
  enum Flags : std::int32_t { TOP_MSG_ID_MASK = 1 };

  updateMessageReactions();

  static const std::int32_t ID = 1578843320;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateAttachMenuBots final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 397910539;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateWebViewResultSent final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 query_id_;

  static const std::int32_t ID = 361936797;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateWebViewResultSent(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotMenuButton final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 bot_id_;
  object_ptr<BotMenuButton> button_;

  static const std::int32_t ID = 347625491;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotMenuButton(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSavedRingtones final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1960361625;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateTranscribedAudio final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pending_;
  object_ptr<Peer> peer_;
  int32 msg_id_;
  int64 transcription_id_;
  string text_;

  updateTranscribedAudio();

  static const std::int32_t ID = 8703322;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReadFeaturedEmojiStickers final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -78886548;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUserEmojiStatus final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  object_ptr<EmojiStatus> emoji_status_;

  static const std::int32_t ID = 674706841;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateUserEmojiStatus(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateRecentEmojiStatuses final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 821314523;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateRecentReactions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1870160884;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMoveStickerSetToTop final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool masks_;
  bool emojis_;
  int64 stickerset_;

  updateMoveStickerSetToTop();

  static const std::int32_t ID = -2030252155;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageExtendedMedia final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 msg_id_;
  array<object_ptr<MessageExtendedMedia>> extended_media_;

  static const std::int32_t ID = -710666460;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateMessageExtendedMedia(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelPinnedTopic final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pinned_;
  int64 channel_id_;
  int32 topic_id_;

  updateChannelPinnedTopic();

  static const std::int32_t ID = 422509539;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelPinnedTopics final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 channel_id_;
  array<int32> order_;

  updateChannelPinnedTopics();

  static const std::int32_t ID = -31881726;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUser final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;

  static const std::int32_t ID = 542282808;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateUser(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateAutoSaveSettings final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -335171433;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStory final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  object_ptr<StoryItem> story_;

  static const std::int32_t ID = 1974712216;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateStory(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReadStories final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 max_id_;

  static const std::int32_t ID = -145845461;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateReadStories(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStoryID final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int64 random_id_;

  static const std::int32_t ID = 468923833;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateStoryID(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStoriesStealthMode final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<storiesStealthMode> stealth_mode_;

  static const std::int32_t ID = 738741697;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateStoriesStealthMode(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSentStoryReaction final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 story_id_;
  object_ptr<Reaction> reaction_;

  static const std::int32_t ID = 2103604867;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateSentStoryReaction(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotChatBoost final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  object_ptr<boost> boost_;
  int32 qts_;

  static const std::int32_t ID = -1873947492;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotChatBoost(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChannelViewForumAsMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 channel_id_;
  bool enabled_;

  static const std::int32_t ID = 129403168;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateChannelViewForumAsMessages(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePeerWallpaper final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool wallpaper_overridden_;
  object_ptr<Peer> peer_;
  object_ptr<WallPaper> wallpaper_;

  updatePeerWallpaper();

  static const std::int32_t ID = -1371598819;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotMessageReaction final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 msg_id_;
  int32 date_;
  object_ptr<Peer> actor_;
  array<object_ptr<Reaction>> old_reactions_;
  array<object_ptr<Reaction>> new_reactions_;
  int32 qts_;

  static const std::int32_t ID = -1407069234;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotMessageReaction(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotMessageReactions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  int32 msg_id_;
  int32 date_;
  array<object_ptr<reactionCount>> reactions_;
  int32 qts_;

  static const std::int32_t ID = 164329305;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotMessageReactions(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSavedDialogPinned final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pinned_;
  object_ptr<DialogPeer> peer_;

  updateSavedDialogPinned();

  static const std::int32_t ID = -1364222348;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePinnedSavedDialogs final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  array<object_ptr<DialogPeer>> order_;

  updatePinnedSavedDialogs();

  static const std::int32_t ID = 1751942566;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSavedReactionTags final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 969307186;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSmsJob final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string job_id_;

  static const std::int32_t ID = -245208620;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateSmsJob(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateQuickReplies final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<quickReply>> quick_replies_;

  static const std::int32_t ID = -112784718;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateQuickReplies(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewQuickReply final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<quickReply> quick_reply_;

  static const std::int32_t ID = -180508905;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateNewQuickReply(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDeleteQuickReply final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;

  static const std::int32_t ID = 1407644140;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateDeleteQuickReply(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateQuickReplyMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Message> message_;

  static const std::int32_t ID = 1040518415;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateQuickReplyMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDeleteQuickReplyMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  array<int32> messages_;

  static const std::int32_t ID = 1450174413;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateDeleteQuickReplyMessages(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotBusinessConnect final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<botBusinessConnection> connection_;
  int32 qts_;

  static const std::int32_t ID = -1964652166;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotBusinessConnect(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotNewBusinessMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string connection_id_;
  object_ptr<Message> message_;
  object_ptr<Message> reply_to_message_;
  int32 qts_;

  updateBotNewBusinessMessage();

  static const std::int32_t ID = -1646578564;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotEditBusinessMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string connection_id_;
  object_ptr<Message> message_;
  object_ptr<Message> reply_to_message_;
  int32 qts_;

  updateBotEditBusinessMessage();

  static const std::int32_t ID = 132077692;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotDeleteBusinessMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string connection_id_;
  object_ptr<Peer> peer_;
  array<int32> messages_;
  int32 qts_;

  static const std::int32_t ID = -1607821266;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotDeleteBusinessMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewStoryReaction final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 story_id_;
  object_ptr<Peer> peer_;
  object_ptr<Reaction> reaction_;

  static const std::int32_t ID = 405070859;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateNewStoryReaction(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBroadcastRevenueTransactions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  object_ptr<broadcastRevenueBalances> balances_;

  static const std::int32_t ID = -539401739;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBroadcastRevenueTransactions(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStarsBalance final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<starsAmount> balance_;

  static const std::int32_t ID = 1317053305;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateStarsBalance(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBusinessBotCallbackQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 query_id_;
  int64 user_id_;
  string connection_id_;
  object_ptr<Message> message_;
  object_ptr<Message> reply_to_message_;
  int64 chat_instance_;
  bytes data_;
  enum Flags : std::int32_t { DATA_MASK = 1 };

  updateBusinessBotCallbackQuery();

  static const std::int32_t ID = 513998247;

  static object_ptr<Update> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStarsRevenueStatus final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  object_ptr<starsRevenueStatus> status_;

  static const std::int32_t ID = -1518030823;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateStarsRevenueStatus(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBotPurchasedPaidMedia final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 user_id_;
  string payload_;
  int32 qts_;

  static const std::int32_t ID = 675009298;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updateBotPurchasedPaidMedia(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePaidReactionPrivacy final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PaidReactionPrivacy> private_;

  static const std::int32_t ID = -1955438642;

  static object_ptr<Update> fetch(TlBufferParser &p);

  explicit updatePaidReactionPrivacy(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class MessageEntity;

class MessageMedia;

class MessageReplyHeader;

class Update;

class User;

class messageFwdHeader;

class Updates: public Object {
 public:

  static object_ptr<Updates> fetch(TlBufferParser &p);
};

class updatesTooLong final : public Updates {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -484987010;

  static object_ptr<Updates> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateShortMessage final : public Updates {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool out_;
  bool mentioned_;
  bool media_unread_;
  bool silent_;
  int32 id_;
  int64 user_id_;
  string message_;
  int32 pts_;
  int32 pts_count_;
  int32 date_;
  object_ptr<messageFwdHeader> fwd_from_;
  int64 via_bot_id_;
  object_ptr<MessageReplyHeader> reply_to_;
  array<object_ptr<MessageEntity>> entities_;
  int32 ttl_period_;
  enum Flags : std::int32_t { VIA_BOT_ID_MASK = 2048, TTL_PERIOD_MASK = 33554432 };

  updateShortMessage();

  static const std::int32_t ID = 826001400;

  static object_ptr<Updates> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateShortChatMessage final : public Updates {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool out_;
  bool mentioned_;
  bool media_unread_;
  bool silent_;
  int32 id_;
  int64 from_id_;
  int64 chat_id_;
  string message_;
  int32 pts_;
  int32 pts_count_;
  int32 date_;
  object_ptr<messageFwdHeader> fwd_from_;
  int64 via_bot_id_;
  object_ptr<MessageReplyHeader> reply_to_;
  array<object_ptr<MessageEntity>> entities_;
  int32 ttl_period_;
  enum Flags : std::int32_t { VIA_BOT_ID_MASK = 2048, TTL_PERIOD_MASK = 33554432 };

  updateShortChatMessage();

  static const std::int32_t ID = 1299050149;

  static object_ptr<Updates> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateShort final : public Updates {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Update> update_;
  int32 date_;

  static const std::int32_t ID = 2027216577;

  static object_ptr<Updates> fetch(TlBufferParser &p);

  explicit updateShort(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatesCombined final : public Updates {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Update>> updates_;
  array<object_ptr<User>> users_;
  array<object_ptr<Chat>> chats_;
  int32 date_;
  int32 seq_start_;
  int32 seq_;

  static const std::int32_t ID = 1918567619;

  static object_ptr<Updates> fetch(TlBufferParser &p);

  explicit updatesCombined(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updates final : public Updates {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Update>> updates_;
  array<object_ptr<User>> users_;
  array<object_ptr<Chat>> chats_;
  int32 date_;
  int32 seq_;

  updates();

  static const std::int32_t ID = 1957577280;

  static object_ptr<Updates> fetch(TlBufferParser &p);

  explicit updates(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateShortSentMessage final : public Updates {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool out_;
  int32 id_;
  int32 pts_;
  int32 pts_count_;
  int32 date_;
  object_ptr<MessageMedia> media_;
  array<object_ptr<MessageEntity>> entities_;
  int32 ttl_period_;
  enum Flags : std::int32_t { TTL_PERIOD_MASK = 33554432 };

  updateShortSentMessage();

  static const std::int32_t ID = -1877614335;

  static object_ptr<Updates> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class UrlAuthResult: public Object {
 public:

  static object_ptr<UrlAuthResult> fetch(TlBufferParser &p);
};

class urlAuthResultRequest final : public UrlAuthResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool request_write_access_;
  object_ptr<User> bot_;
  string domain_;

  urlAuthResultRequest();

  static const std::int32_t ID = -1831650802;

  static object_ptr<UrlAuthResult> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class urlAuthResultAccepted final : public UrlAuthResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  static const std::int32_t ID = -1886646706;

  static object_ptr<UrlAuthResult> fetch(TlBufferParser &p);

  explicit urlAuthResultAccepted(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class urlAuthResultDefault final : public UrlAuthResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1445536993;

  static object_ptr<UrlAuthResult> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiStatus;

class UserProfilePhoto;

class UserStatus;

class peerColor;

class restrictionReason;

class username;

class User: public Object {
 public:

  static object_ptr<User> fetch(TlBufferParser &p);
};

class userEmpty final : public User {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;

  static const std::int32_t ID = -742634630;

  static object_ptr<User> fetch(TlBufferParser &p);

  explicit userEmpty(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class user final : public User {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool self_;
  bool contact_;
  bool mutual_contact_;
  bool deleted_;
  bool bot_;
  bool bot_chat_history_;
  bool bot_nochats_;
  bool verified_;
  bool restricted_;
  bool min_;
  bool bot_inline_geo_;
  bool support_;
  bool scam_;
  bool apply_min_photo_;
  bool fake_;
  bool bot_attach_menu_;
  bool premium_;
  bool attach_menu_enabled_;
  int32 flags2_;
  bool bot_can_edit_;
  bool close_friend_;
  bool stories_hidden_;
  bool stories_unavailable_;
  bool contact_require_premium_;
  bool bot_business_;
  bool bot_has_main_app_;
  int64 id_;
  int64 access_hash_;
  string first_name_;
  string last_name_;
  string username_;
  string phone_;
  object_ptr<UserProfilePhoto> photo_;
  object_ptr<UserStatus> status_;
  int32 bot_info_version_;
  array<object_ptr<restrictionReason>> restriction_reason_;
  string bot_inline_placeholder_;
  string lang_code_;
  object_ptr<EmojiStatus> emoji_status_;
  array<object_ptr<username>> usernames_;
  int32 stories_max_id_;
  object_ptr<peerColor> color_;
  object_ptr<peerColor> profile_color_;
  int32 bot_active_users_;
  int64 bot_verification_icon_;
  enum Flags : std::int32_t { ACCESS_HASH_MASK = 1, FIRST_NAME_MASK = 2, LAST_NAME_MASK = 4, USERNAME_MASK = 8, PHONE_MASK = 16, BOT_INFO_VERSION_MASK = 16384, BOT_INLINE_PLACEHOLDER_MASK = 524288, LANG_CODE_MASK = 4194304, STORIES_MAX_ID_MASK = 32, BOT_ACTIVE_USERS_MASK = 4096, BOT_VERIFICATION_ICON_MASK = 16384 };

  user();

  user(int32 flags_, bool self_, bool contact_, bool mutual_contact_, bool deleted_, bool bot_, bool bot_chat_history_, bool bot_nochats_, bool verified_, bool restricted_, bool min_, bool bot_inline_geo_, bool support_, bool scam_, bool apply_min_photo_, bool fake_, bool bot_attach_menu_, bool premium_, bool attach_menu_enabled_, int32 flags2_, bool bot_can_edit_, bool close_friend_, bool stories_hidden_, bool stories_unavailable_, bool contact_require_premium_, bool bot_business_, bool bot_has_main_app_, int64 id_, int64 access_hash_, string const &first_name_, string const &last_name_, string const &username_, string const &phone_, object_ptr<UserProfilePhoto> &&photo_, object_ptr<UserStatus> &&status_, int32 bot_info_version_, array<object_ptr<restrictionReason>> &&restriction_reason_, string const &bot_inline_placeholder_, string const &lang_code_, object_ptr<EmojiStatus> &&emoji_status_, array<object_ptr<username>> &&usernames_, int32 stories_max_id_, object_ptr<peerColor> &&color_, object_ptr<peerColor> &&profile_color_, int32 bot_active_users_, int64 bot_verification_icon_);

  static const std::int32_t ID = 1262928766;

  static object_ptr<User> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Photo;

class WallPaper;

class birthday;

class botInfo;

class botVerification;

class businessAwayMessage;

class businessGreetingMessage;

class businessIntro;

class businessLocation;

class businessWorkHours;

class chatAdminRights;

class peerNotifySettings;

class peerSettings;

class peerStories;

class premiumGiftOption;

class starRefProgram;

class userFull final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool blocked_;
  bool phone_calls_available_;
  bool phone_calls_private_;
  bool can_pin_message_;
  bool has_scheduled_;
  bool video_calls_available_;
  bool voice_messages_forbidden_;
  bool translations_disabled_;
  bool stories_pinned_available_;
  bool blocked_my_stories_from_;
  bool wallpaper_overridden_;
  bool contact_require_premium_;
  bool read_dates_private_;
  int32 flags2_;
  bool sponsored_enabled_;
  bool can_view_revenue_;
  bool bot_can_manage_emoji_status_;
  int64 id_;
  string about_;
  object_ptr<peerSettings> settings_;
  object_ptr<Photo> personal_photo_;
  object_ptr<Photo> profile_photo_;
  object_ptr<Photo> fallback_photo_;
  object_ptr<peerNotifySettings> notify_settings_;
  object_ptr<botInfo> bot_info_;
  int32 pinned_msg_id_;
  int32 common_chats_count_;
  int32 folder_id_;
  int32 ttl_period_;
  string theme_emoticon_;
  string private_forward_name_;
  object_ptr<chatAdminRights> bot_group_admin_rights_;
  object_ptr<chatAdminRights> bot_broadcast_admin_rights_;
  array<object_ptr<premiumGiftOption>> premium_gifts_;
  object_ptr<WallPaper> wallpaper_;
  object_ptr<peerStories> stories_;
  object_ptr<businessWorkHours> business_work_hours_;
  object_ptr<businessLocation> business_location_;
  object_ptr<businessGreetingMessage> business_greeting_message_;
  object_ptr<businessAwayMessage> business_away_message_;
  object_ptr<businessIntro> business_intro_;
  object_ptr<birthday> birthday_;
  int64 personal_channel_id_;
  int32 personal_channel_message_;
  int32 stargifts_count_;
  object_ptr<starRefProgram> starref_program_;
  object_ptr<botVerification> bot_verification_;
  enum Flags : std::int32_t { ABOUT_MASK = 2, PINNED_MSG_ID_MASK = 64, FOLDER_ID_MASK = 2048, TTL_PERIOD_MASK = 16384, THEME_EMOTICON_MASK = 32768, PRIVATE_FORWARD_NAME_MASK = 65536, PERSONAL_CHANNEL_ID_MASK = 64, PERSONAL_CHANNEL_MESSAGE_MASK = 64, STARGIFTS_COUNT_MASK = 256 };

  userFull();

  static const std::int32_t ID = 1301765052;

  static object_ptr<userFull> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class UserProfilePhoto: public Object {
 public:

  static object_ptr<UserProfilePhoto> fetch(TlBufferParser &p);
};

class userProfilePhotoEmpty final : public UserProfilePhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1326562017;

  static object_ptr<UserProfilePhoto> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userProfilePhoto final : public UserProfilePhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool has_video_;
  bool personal_;
  int64 photo_id_;
  bytes stripped_thumb_;
  int32 dc_id_;
  enum Flags : std::int32_t { STRIPPED_THUMB_MASK = 2 };

  userProfilePhoto();

  userProfilePhoto(int32 flags_, bool has_video_, bool personal_, int64 photo_id_, bytes &&stripped_thumb_, int32 dc_id_);

  static const std::int32_t ID = -2100168954;

  static object_ptr<UserProfilePhoto> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class UserStatus: public Object {
 public:

  static object_ptr<UserStatus> fetch(TlBufferParser &p);
};

class userStatusEmpty final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 164646985;

  static object_ptr<UserStatus> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userStatusOnline final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 expires_;

  static const std::int32_t ID = -306628279;

  static object_ptr<UserStatus> fetch(TlBufferParser &p);

  explicit userStatusOnline(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userStatusOffline final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 was_online_;

  static const std::int32_t ID = 9203775;

  static object_ptr<UserStatus> fetch(TlBufferParser &p);

  explicit userStatusOffline(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userStatusRecently final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool by_me_;

  userStatusRecently();

  static const std::int32_t ID = 2065268168;

  static object_ptr<UserStatus> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userStatusLastWeek final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool by_me_;

  userStatusLastWeek();

  static const std::int32_t ID = 1410997530;

  static object_ptr<UserStatus> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userStatusLastMonth final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool by_me_;

  userStatusLastMonth();

  static const std::int32_t ID = 1703516023;

  static object_ptr<UserStatus> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class username final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool editable_;
  bool active_;
  string username_;

  username();

  static const std::int32_t ID = -1274595769;

  static object_ptr<username> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputStickerSet;

class VideoSize: public Object {
 public:

  static object_ptr<VideoSize> fetch(TlBufferParser &p);
};

class videoSize final : public VideoSize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string type_;
  int32 w_;
  int32 h_;
  int32 size_;
  double video_start_ts_;
  enum Flags : std::int32_t { VIDEO_START_TS_MASK = 1 };

  videoSize();

  videoSize(int32 flags_, string const &type_, int32 w_, int32 h_, int32 size_, double video_start_ts_);

  static const std::int32_t ID = -567037804;

  static object_ptr<VideoSize> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class videoSizeEmojiMarkup final : public VideoSize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 emoji_id_;
  array<int32> background_colors_;

  videoSizeEmojiMarkup(int64 emoji_id_, array<int32> &&background_colors_);

  static const std::int32_t ID = -128171716;

  static object_ptr<VideoSize> fetch(TlBufferParser &p);

  explicit videoSizeEmojiMarkup(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class videoSizeStickerMarkup final : public VideoSize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputStickerSet> stickerset_;
  int64 sticker_id_;
  array<int32> background_colors_;

  videoSizeStickerMarkup(object_ptr<InputStickerSet> &&stickerset_, int64 sticker_id_, array<int32> &&background_colors_);

  static const std::int32_t ID = 228623102;

  static object_ptr<VideoSize> fetch(TlBufferParser &p);

  explicit videoSizeStickerMarkup(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class wallPaperSettings;

class WallPaper: public Object {
 public:

  static object_ptr<WallPaper> fetch(TlBufferParser &p);
};

class wallPaper final : public WallPaper {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 flags_;
  bool creator_;
  bool default_;
  bool pattern_;
  bool dark_;
  int64 access_hash_;
  string slug_;
  object_ptr<Document> document_;
  object_ptr<wallPaperSettings> settings_;

  wallPaper();

  static const std::int32_t ID = -1539849235;

  static object_ptr<WallPaper> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class wallPaperNoFile final : public WallPaper {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 flags_;
  bool default_;
  bool dark_;
  object_ptr<wallPaperSettings> settings_;

  wallPaperNoFile();

  static const std::int32_t ID = -528465642;

  static object_ptr<WallPaper> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class wallPaperSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool blur_;
  bool motion_;
  int32 background_color_;
  int32 second_background_color_;
  int32 third_background_color_;
  int32 fourth_background_color_;
  int32 intensity_;
  int32 rotation_;
  string emoticon_;
  enum Flags : std::int32_t { BLUR_MASK = 2, MOTION_MASK = 4, BACKGROUND_COLOR_MASK = 1, SECOND_BACKGROUND_COLOR_MASK = 16, THIRD_BACKGROUND_COLOR_MASK = 32, FOURTH_BACKGROUND_COLOR_MASK = 64, INTENSITY_MASK = 8, ROTATION_MASK = 16, EMOTICON_MASK = 128 };

  wallPaperSettings();

  wallPaperSettings(int32 flags_, bool blur_, bool motion_, int32 background_color_, int32 second_background_color_, int32 third_background_color_, int32 fourth_background_color_, int32 intensity_, int32 rotation_, string const &emoticon_);

  static const std::int32_t ID = 925826256;

  static object_ptr<wallPaperSettings> fetch(TlBufferParser &p);

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webAuthorization final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  int64 bot_id_;
  string domain_;
  string browser_;
  string platform_;
  int32 date_created_;
  int32 date_active_;
  string ip_;
  string region_;

  static const std::int32_t ID = -1493633966;

  static object_ptr<webAuthorization> fetch(TlBufferParser &p);

  explicit webAuthorization(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class DocumentAttribute;

class WebDocument: public Object {
 public:

  static object_ptr<WebDocument> fetch(TlBufferParser &p);
};

class webDocument final : public WebDocument {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int64 access_hash_;
  int32 size_;
  string mime_type_;
  array<object_ptr<DocumentAttribute>> attributes_;

  static const std::int32_t ID = 475467473;

  static object_ptr<WebDocument> fetch(TlBufferParser &p);

  explicit webDocument(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webDocumentNoProxy final : public WebDocument {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int32 size_;
  string mime_type_;
  array<object_ptr<DocumentAttribute>> attributes_;

  static const std::int32_t ID = -104284986;

  static object_ptr<WebDocument> fetch(TlBufferParser &p);

  explicit webDocumentNoProxy(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class Photo;

class WebPageAttribute;

class page;

class WebPage: public Object {
 public:

  static object_ptr<WebPage> fetch(TlBufferParser &p);
};

class webPageEmpty final : public WebPage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 id_;
  string url_;
  enum Flags : std::int32_t { URL_MASK = 1 };

  webPageEmpty();

  static const std::int32_t ID = 555358088;

  static object_ptr<WebPage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webPagePending final : public WebPage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 id_;
  string url_;
  int32 date_;
  enum Flags : std::int32_t { URL_MASK = 1 };

  webPagePending();

  static const std::int32_t ID = -1328464313;

  static object_ptr<WebPage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webPage final : public WebPage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool has_large_media_;
  bool video_cover_photo_;
  int64 id_;
  string url_;
  string display_url_;
  int32 hash_;
  string type_;
  string site_name_;
  string title_;
  string description_;
  object_ptr<Photo> photo_;
  string embed_url_;
  string embed_type_;
  int32 embed_width_;
  int32 embed_height_;
  int32 duration_;
  string author_;
  object_ptr<Document> document_;
  object_ptr<page> cached_page_;
  array<object_ptr<WebPageAttribute>> attributes_;
  enum Flags : std::int32_t { TYPE_MASK = 1, SITE_NAME_MASK = 2, TITLE_MASK = 4, DESCRIPTION_MASK = 8, EMBED_URL_MASK = 32, EMBED_TYPE_MASK = 32, EMBED_WIDTH_MASK = 64, EMBED_HEIGHT_MASK = 64, DURATION_MASK = 128, AUTHOR_MASK = 256 };

  webPage();

  static const std::int32_t ID = -392411726;

  static object_ptr<WebPage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webPageNotModified final : public WebPage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 cached_page_views_;
  enum Flags : std::int32_t { CACHED_PAGE_VIEWS_MASK = 1 };

  webPageNotModified();

  static const std::int32_t ID = 1930545681;

  static object_ptr<WebPage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class Peer;

class StarGift;

class StoryItem;

class themeSettings;

class WebPageAttribute: public Object {
 public:

  static object_ptr<WebPageAttribute> fetch(TlBufferParser &p);
};

class webPageAttributeTheme final : public WebPageAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  array<object_ptr<Document>> documents_;
  object_ptr<themeSettings> settings_;

  webPageAttributeTheme();

  static const std::int32_t ID = 1421174295;

  static object_ptr<WebPageAttribute> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webPageAttributeStory final : public WebPageAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<Peer> peer_;
  int32 id_;
  object_ptr<StoryItem> story_;

  webPageAttributeStory();

  static const std::int32_t ID = 781501415;

  static object_ptr<WebPageAttribute> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webPageAttributeStickerSet final : public WebPageAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool emojis_;
  bool text_color_;
  array<object_ptr<Document>> stickers_;

  webPageAttributeStickerSet();

  static const std::int32_t ID = 1355547603;

  static object_ptr<WebPageAttribute> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webPageAttributeUniqueStarGift final : public WebPageAttribute {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StarGift> gift_;

  static const std::int32_t ID = -814781000;

  static object_ptr<WebPageAttribute> fetch(TlBufferParser &p);

  explicit webPageAttributeUniqueStarGift(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputBotInlineMessageID;

class webViewMessageSent final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputBotInlineMessageID> msg_id_;

  webViewMessageSent();

  static const std::int32_t ID = 211046684;

  static object_ptr<webViewMessageSent> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webViewResultUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool fullsize_;
  bool fullscreen_;
  int64 query_id_;
  string url_;
  enum Flags : std::int32_t { QUERY_ID_MASK = 1 };

  webViewResultUrl();

  static const std::int32_t ID = 1294139288;

  static object_ptr<webViewResultUrl> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecureRequiredType;

class SecureValueError;

class User;

class secureValue;

class account_authorizationForm final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  array<object_ptr<SecureRequiredType>> required_types_;
  array<object_ptr<secureValue>> values_;
  array<object_ptr<SecureValueError>> errors_;
  array<object_ptr<User>> users_;
  string privacy_policy_url_;
  enum Flags : std::int32_t { PRIVACY_POLICY_URL_MASK = 1 };

  account_authorizationForm();

  static const std::int32_t ID = -1389486888;

  static object_ptr<account_authorizationForm> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorization;

class account_authorizations final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 authorization_ttl_days_;
  array<object_ptr<authorization>> authorizations_;

  static const std::int32_t ID = 1275039392;

  static object_ptr<account_authorizations> fetch(TlBufferParser &p);

  explicit account_authorizations(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autoDownloadSettings;

class account_autoDownloadSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<autoDownloadSettings> low_;
  object_ptr<autoDownloadSettings> medium_;
  object_ptr<autoDownloadSettings> high_;

  static const std::int32_t ID = 1674235686;

  static object_ptr<account_autoDownloadSettings> fetch(TlBufferParser &p);

  explicit account_autoDownloadSettings(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class autoSaveException;

class autoSaveSettings;

class account_autoSaveSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<autoSaveSettings> users_settings_;
  object_ptr<autoSaveSettings> chats_settings_;
  object_ptr<autoSaveSettings> broadcasts_settings_;
  array<object_ptr<autoSaveException>> exceptions_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 1279133341;

  static object_ptr<account_autoSaveSettings> fetch(TlBufferParser &p);

  explicit account_autoSaveSettings(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class businessChatLink;

class account_businessChatLinks final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<businessChatLink>> links_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -331111727;

  static object_ptr<account_businessChatLinks> fetch(TlBufferParser &p);

  explicit account_businessChatLinks(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class connectedBot;

class account_connectedBots final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<connectedBot>> connected_bots_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 400029819;

  static object_ptr<account_connectedBots> fetch(TlBufferParser &p);

  explicit account_connectedBots(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_contentSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool sensitive_enabled_;
  bool sensitive_can_change_;

  account_contentSettings();

  static const std::int32_t ID = 1474462241;

  static object_ptr<account_contentSettings> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_SentCode;

class account_EmailVerified: public Object {
 public:

  static object_ptr<account_EmailVerified> fetch(TlBufferParser &p);
};

class account_emailVerified final : public account_EmailVerified {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string email_;

  static const std::int32_t ID = 731303195;

  static object_ptr<account_EmailVerified> fetch(TlBufferParser &p);

  explicit account_emailVerified(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_emailVerifiedLogin final : public account_EmailVerified {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string email_;
  object_ptr<auth_SentCode> sent_code_;

  static const std::int32_t ID = -507835039;

  static object_ptr<account_EmailVerified> fetch(TlBufferParser &p);

  explicit account_emailVerifiedLogin(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiStatus;

class account_EmojiStatuses: public Object {
 public:

  static object_ptr<account_EmojiStatuses> fetch(TlBufferParser &p);
};

class account_emojiStatusesNotModified final : public account_EmojiStatuses {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -796072379;

  static object_ptr<account_EmojiStatuses> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_emojiStatuses final : public account_EmojiStatuses {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<EmojiStatus>> statuses_;

  static const std::int32_t ID = -1866176559;

  static object_ptr<account_EmojiStatuses> fetch(TlBufferParser &p);

  explicit account_emojiStatuses(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PasswordKdfAlgo;

class SecurePasswordKdfAlgo;

class account_password final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool has_recovery_;
  bool has_secure_values_;
  bool has_password_;
  object_ptr<PasswordKdfAlgo> current_algo_;
  bytes srp_B_;
  int64 srp_id_;
  string hint_;
  string email_unconfirmed_pattern_;
  object_ptr<PasswordKdfAlgo> new_algo_;
  object_ptr<SecurePasswordKdfAlgo> new_secure_algo_;
  bytes secure_random_;
  int32 pending_reset_date_;
  string login_email_pattern_;
  enum Flags : std::int32_t { SRP_B_MASK = 4, SRP_ID_MASK = 4, HINT_MASK = 8, EMAIL_UNCONFIRMED_PATTERN_MASK = 16, PENDING_RESET_DATE_MASK = 32, LOGIN_EMAIL_PATTERN_MASK = 64 };

  account_password();

  static const std::int32_t ID = -1787080453;

  static object_ptr<account_password> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PasswordKdfAlgo;

class secureSecretSettings;

class account_passwordInputSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<PasswordKdfAlgo> new_algo_;
  bytes new_password_hash_;
  string hint_;
  string email_;
  object_ptr<secureSecretSettings> new_secure_settings_;
  enum Flags : std::int32_t { NEW_ALGO_MASK = 1, NEW_PASSWORD_HASH_MASK = 1, HINT_MASK = 1, EMAIL_MASK = 2, NEW_SECURE_SETTINGS_MASK = 4 };

  account_passwordInputSettings(int32 flags_, object_ptr<PasswordKdfAlgo> &&new_algo_, bytes &&new_password_hash_, string const &hint_, string const &email_, object_ptr<secureSecretSettings> &&new_secure_settings_);

  static const std::int32_t ID = -1036572727;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureSecretSettings;

class account_passwordSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string email_;
  object_ptr<secureSecretSettings> secure_settings_;
  enum Flags : std::int32_t { EMAIL_MASK = 1 };

  account_passwordSettings();

  static const std::int32_t ID = -1705233435;

  static object_ptr<account_passwordSettings> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class PrivacyRule;

class User;

class account_privacyRules final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PrivacyRule>> rules_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 1352683077;

  static object_ptr<account_privacyRules> fetch(TlBufferParser &p);

  explicit account_privacyRules(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_ResetPasswordResult: public Object {
 public:

  static object_ptr<account_ResetPasswordResult> fetch(TlBufferParser &p);
};

class account_resetPasswordFailedWait final : public account_ResetPasswordResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 retry_date_;

  static const std::int32_t ID = -478701471;

  static object_ptr<account_ResetPasswordResult> fetch(TlBufferParser &p);

  explicit account_resetPasswordFailedWait(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_resetPasswordRequestedWait final : public account_ResetPasswordResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 until_date_;

  static const std::int32_t ID = -370148227;

  static object_ptr<account_ResetPasswordResult> fetch(TlBufferParser &p);

  explicit account_resetPasswordRequestedWait(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_resetPasswordOk final : public account_ResetPasswordResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -383330754;

  static object_ptr<account_ResetPasswordResult> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class MessageEntity;

class Peer;

class User;

class account_resolvedBusinessChatLinks final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<Peer> peer_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  account_resolvedBusinessChatLinks();

  static const std::int32_t ID = -1708937439;

  static object_ptr<account_resolvedBusinessChatLinks> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class account_SavedRingtone: public Object {
 public:

  static object_ptr<account_SavedRingtone> fetch(TlBufferParser &p);
};

class account_savedRingtone final : public account_SavedRingtone {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1222230163;

  static object_ptr<account_SavedRingtone> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_savedRingtoneConverted final : public account_SavedRingtone {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Document> document_;

  static const std::int32_t ID = 523271863;

  static object_ptr<account_SavedRingtone> fetch(TlBufferParser &p);

  explicit account_savedRingtoneConverted(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class account_SavedRingtones: public Object {
 public:

  static object_ptr<account_SavedRingtones> fetch(TlBufferParser &p);
};

class account_savedRingtonesNotModified final : public account_SavedRingtones {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -67704655;

  static object_ptr<account_SavedRingtones> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_savedRingtones final : public account_SavedRingtones {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<Document>> ringtones_;

  static const std::int32_t ID = -1041683259;

  static object_ptr<account_SavedRingtones> fetch(TlBufferParser &p);

  explicit account_savedRingtones(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_sentEmailCode final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string email_pattern_;
  int32 length_;

  static const std::int32_t ID = -2128640689;

  static object_ptr<account_sentEmailCode> fetch(TlBufferParser &p);

  explicit account_sentEmailCode(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_takeout final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;

  static const std::int32_t ID = 1304052993;

  static object_ptr<account_takeout> fetch(TlBufferParser &p);

  explicit account_takeout(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class theme;

class account_Themes: public Object {
 public:

  static object_ptr<account_Themes> fetch(TlBufferParser &p);
};

class account_themesNotModified final : public account_Themes {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -199313886;

  static object_ptr<account_Themes> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_themes final : public account_Themes {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<theme>> themes_;

  static const std::int32_t ID = -1707242387;

  static object_ptr<account_Themes> fetch(TlBufferParser &p);

  explicit account_themes(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_tmpPassword final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes tmp_password_;
  int32 valid_until_;

  static const std::int32_t ID = -614138572;

  static object_ptr<account_tmpPassword> fetch(TlBufferParser &p);

  explicit account_tmpPassword(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class WallPaper;

class account_WallPapers: public Object {
 public:

  static object_ptr<account_WallPapers> fetch(TlBufferParser &p);
};

class account_wallPapersNotModified final : public account_WallPapers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 471437699;

  static object_ptr<account_WallPapers> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class account_wallPapers final : public account_WallPapers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<WallPaper>> wallpapers_;

  static const std::int32_t ID = -842824308;

  static object_ptr<account_WallPapers> fetch(TlBufferParser &p);

  explicit account_wallPapers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class webAuthorization;

class account_webAuthorizations final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<webAuthorization>> authorizations_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -313079300;

  static object_ptr<account_webAuthorizations> fetch(TlBufferParser &p);

  explicit account_webAuthorizations(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class help_termsOfService;

class auth_Authorization: public Object {
 public:

  static object_ptr<auth_Authorization> fetch(TlBufferParser &p);
};

class auth_authorization final : public auth_Authorization {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool setup_password_required_;
  int32 otherwise_relogin_days_;
  int32 tmp_sessions_;
  bytes future_auth_token_;
  object_ptr<User> user_;
  enum Flags : std::int32_t { OTHERWISE_RELOGIN_DAYS_MASK = 2, TMP_SESSIONS_MASK = 1, FUTURE_AUTH_TOKEN_MASK = 4 };

  auth_authorization();

  static const std::int32_t ID = 782418132;

  static object_ptr<auth_Authorization> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_authorizationSignUpRequired final : public auth_Authorization {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<help_termsOfService> terms_of_service_;

  auth_authorizationSignUpRequired();

  static const std::int32_t ID = 1148485274;

  static object_ptr<auth_Authorization> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_CodeType: public Object {
 public:

  static object_ptr<auth_CodeType> fetch(TlBufferParser &p);
};

class auth_codeTypeSms final : public auth_CodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1923290508;

  static object_ptr<auth_CodeType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_codeTypeCall final : public auth_CodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1948046307;

  static object_ptr<auth_CodeType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_codeTypeFlashCall final : public auth_CodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 577556219;

  static object_ptr<auth_CodeType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_codeTypeMissedCall final : public auth_CodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -702884114;

  static object_ptr<auth_CodeType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_codeTypeFragmentSms final : public auth_CodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 116234636;

  static object_ptr<auth_CodeType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_exportedAuthorization final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  bytes bytes_;

  static const std::int32_t ID = -1271602504;

  static object_ptr<auth_exportedAuthorization> fetch(TlBufferParser &p);

  explicit auth_exportedAuthorization(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_loggedOut final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bytes future_auth_token_;
  enum Flags : std::int32_t { FUTURE_AUTH_TOKEN_MASK = 1 };

  auth_loggedOut();

  static const std::int32_t ID = -1012759713;

  static object_ptr<auth_loggedOut> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_Authorization;

class auth_LoginToken: public Object {
 public:

  static object_ptr<auth_LoginToken> fetch(TlBufferParser &p);
};

class auth_loginToken final : public auth_LoginToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 expires_;
  bytes token_;

  static const std::int32_t ID = 1654593920;

  static object_ptr<auth_LoginToken> fetch(TlBufferParser &p);

  explicit auth_loginToken(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_loginTokenMigrateTo final : public auth_LoginToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 dc_id_;
  bytes token_;

  static const std::int32_t ID = 110008598;

  static object_ptr<auth_LoginToken> fetch(TlBufferParser &p);

  explicit auth_loginTokenMigrateTo(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_loginTokenSuccess final : public auth_LoginToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<auth_Authorization> authorization_;

  static const std::int32_t ID = 957176926;

  static object_ptr<auth_LoginToken> fetch(TlBufferParser &p);

  explicit auth_loginTokenSuccess(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_passwordRecovery final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string email_pattern_;

  static const std::int32_t ID = 326715557;

  static object_ptr<auth_passwordRecovery> fetch(TlBufferParser &p);

  explicit auth_passwordRecovery(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_Authorization;

class auth_CodeType;

class auth_SentCodeType;

class auth_SentCode: public Object {
 public:

  static object_ptr<auth_SentCode> fetch(TlBufferParser &p);
};

class auth_sentCode final : public auth_SentCode {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<auth_SentCodeType> type_;
  string phone_code_hash_;
  object_ptr<auth_CodeType> next_type_;
  int32 timeout_;
  enum Flags : std::int32_t { TIMEOUT_MASK = 4 };

  auth_sentCode();

  static const std::int32_t ID = 1577067778;

  static object_ptr<auth_SentCode> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeSuccess final : public auth_SentCode {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<auth_Authorization> authorization_;

  static const std::int32_t ID = 596704836;

  static object_ptr<auth_SentCode> fetch(TlBufferParser &p);

  explicit auth_sentCodeSuccess(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_SentCodeType: public Object {
 public:

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);
};

class auth_sentCodeTypeApp final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 length_;

  static const std::int32_t ID = 1035688326;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  explicit auth_sentCodeTypeApp(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeTypeSms final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 length_;

  static const std::int32_t ID = -1073693790;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  explicit auth_sentCodeTypeSms(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeTypeCall final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 length_;

  static const std::int32_t ID = 1398007207;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  explicit auth_sentCodeTypeCall(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeTypeFlashCall final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string pattern_;

  static const std::int32_t ID = -1425815847;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  explicit auth_sentCodeTypeFlashCall(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeTypeMissedCall final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string prefix_;
  int32 length_;

  static const std::int32_t ID = -2113903484;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  explicit auth_sentCodeTypeMissedCall(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeTypeEmailCode final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool apple_signin_allowed_;
  bool google_signin_allowed_;
  string email_pattern_;
  int32 length_;
  int32 reset_available_period_;
  int32 reset_pending_date_;
  enum Flags : std::int32_t { RESET_AVAILABLE_PERIOD_MASK = 8, RESET_PENDING_DATE_MASK = 16 };

  auth_sentCodeTypeEmailCode();

  static const std::int32_t ID = -196020837;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeTypeSetUpEmailRequired final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool apple_signin_allowed_;
  bool google_signin_allowed_;

  auth_sentCodeTypeSetUpEmailRequired();

  static const std::int32_t ID = -1521934870;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeTypeFragmentSms final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int32 length_;

  static const std::int32_t ID = -648651719;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  explicit auth_sentCodeTypeFragmentSms(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeTypeFirebaseSms final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bytes nonce_;
  int64 play_integrity_project_id_;
  bytes play_integrity_nonce_;
  string receipt_;
  int32 push_timeout_;
  int32 length_;
  enum Flags : std::int32_t { NONCE_MASK = 1, PLAY_INTEGRITY_PROJECT_ID_MASK = 4, PLAY_INTEGRITY_NONCE_MASK = 4, RECEIPT_MASK = 2, PUSH_TIMEOUT_MASK = 2 };

  auth_sentCodeTypeFirebaseSms();

  static const std::int32_t ID = 10475318;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeTypeSmsWord final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string beginning_;
  enum Flags : std::int32_t { BEGINNING_MASK = 1 };

  auth_sentCodeTypeSmsWord();

  static const std::int32_t ID = -1542017919;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class auth_sentCodeTypeSmsPhrase final : public auth_SentCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string beginning_;
  enum Flags : std::int32_t { BEGINNING_MASK = 1 };

  auth_sentCodeTypeSmsPhrase();

  static const std::int32_t ID = -1284008785;

  static object_ptr<auth_SentCodeType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class bots_botInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  string about_;
  string description_;

  static const std::int32_t ID = -391678544;

  static object_ptr<bots_botInfo> fetch(TlBufferParser &p);

  explicit bots_botInfo(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class bots_popularAppBots final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string next_offset_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  bots_popularAppBots();

  static const std::int32_t ID = 428978491;

  static object_ptr<bots_popularAppBots> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botPreviewMedia;

class bots_previewInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<botPreviewMedia>> media_;
  array<string> lang_codes_;

  static const std::int32_t ID = 212278628;

  static object_ptr<bots_previewInfo> fetch(TlBufferParser &p);

  explicit bots_previewInfo(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class channelAdminLogEvent;

class channels_adminLogResults final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<channelAdminLogEvent>> events_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -309659827;

  static object_ptr<channels_adminLogResults> fetch(TlBufferParser &p);

  explicit channels_adminLogResults(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChannelParticipant;

class Chat;

class User;

class channels_channelParticipant final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChannelParticipant> participant_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -541588713;

  static object_ptr<channels_channelParticipant> fetch(TlBufferParser &p);

  explicit channels_channelParticipant(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChannelParticipant;

class Chat;

class User;

class channels_ChannelParticipants: public Object {
 public:

  static object_ptr<channels_ChannelParticipants> fetch(TlBufferParser &p);
};

class channels_channelParticipants final : public channels_ChannelParticipants {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<ChannelParticipant>> participants_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1699676497;

  static object_ptr<channels_ChannelParticipants> fetch(TlBufferParser &p);

  explicit channels_channelParticipants(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channels_channelParticipantsNotModified final : public channels_ChannelParticipants {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -266911767;

  static object_ptr<channels_ChannelParticipants> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class sendAsPeer;

class channels_sendAsPeers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<sendAsPeer>> peers_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -191450938;

  static object_ptr<channels_sendAsPeers> fetch(TlBufferParser &p);

  explicit channels_sendAsPeers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sponsoredMessageReportOption;

class channels_SponsoredMessageReportResult: public Object {
 public:

  static object_ptr<channels_SponsoredMessageReportResult> fetch(TlBufferParser &p);
};

class channels_sponsoredMessageReportResultChooseOption final : public channels_SponsoredMessageReportResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  array<object_ptr<sponsoredMessageReportOption>> options_;

  static const std::int32_t ID = -2073059774;

  static object_ptr<channels_SponsoredMessageReportResult> fetch(TlBufferParser &p);

  explicit channels_sponsoredMessageReportResultChooseOption(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channels_sponsoredMessageReportResultAdsHidden final : public channels_SponsoredMessageReportResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1044107055;

  static object_ptr<channels_SponsoredMessageReportResult> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class channels_sponsoredMessageReportResultReported final : public channels_SponsoredMessageReportResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1384544183;

  static object_ptr<channels_SponsoredMessageReportResult> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Peer;

class User;

class textWithEntities;

class chatlists_ChatlistInvite: public Object {
 public:

  static object_ptr<chatlists_ChatlistInvite> fetch(TlBufferParser &p);
};

class chatlists_chatlistInviteAlready final : public chatlists_ChatlistInvite {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 filter_id_;
  array<object_ptr<Peer>> missing_peers_;
  array<object_ptr<Peer>> already_peers_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -91752871;

  static object_ptr<chatlists_ChatlistInvite> fetch(TlBufferParser &p);

  explicit chatlists_chatlistInviteAlready(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatlists_chatlistInvite final : public chatlists_ChatlistInvite {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool title_noanimate_;
  object_ptr<textWithEntities> title_;
  string emoticon_;
  array<object_ptr<Peer>> peers_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { EMOTICON_MASK = 1 };

  chatlists_chatlistInvite();

  static const std::int32_t ID = -250687953;

  static object_ptr<chatlists_ChatlistInvite> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Peer;

class User;

class chatlists_chatlistUpdates final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Peer>> missing_peers_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1816295539;

  static object_ptr<chatlists_chatlistUpdates> fetch(TlBufferParser &p);

  explicit chatlists_chatlistUpdates(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class DialogFilter;

class exportedChatlistInvite;

class chatlists_exportedChatlistInvite final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<DialogFilter> filter_;
  object_ptr<exportedChatlistInvite> invite_;

  static const std::int32_t ID = 283567014;

  static object_ptr<chatlists_exportedChatlistInvite> fetch(TlBufferParser &p);

  explicit chatlists_exportedChatlistInvite(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class exportedChatlistInvite;

class chatlists_exportedInvites final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<exportedChatlistInvite>> invites_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 279670215;

  static object_ptr<chatlists_exportedInvites> fetch(TlBufferParser &p);

  explicit chatlists_exportedInvites(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class peerBlocked;

class contacts_Blocked: public Object {
 public:

  static object_ptr<contacts_Blocked> fetch(TlBufferParser &p);
};

class contacts_blocked final : public contacts_Blocked {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<peerBlocked>> blocked_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 182326673;

  static object_ptr<contacts_Blocked> fetch(TlBufferParser &p);

  explicit contacts_blocked(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class contacts_blockedSlice final : public contacts_Blocked {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<peerBlocked>> blocked_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -513392236;

  static object_ptr<contacts_Blocked> fetch(TlBufferParser &p);

  explicit contacts_blockedSlice(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class contactBirthday;

class contacts_contactBirthdays final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<contactBirthday>> contacts_;
  array<object_ptr<User>> users_;

  contacts_contactBirthdays(array<object_ptr<contactBirthday>> &&contacts_, array<object_ptr<User>> &&users_);

  static const std::int32_t ID = 290452237;

  static object_ptr<contacts_contactBirthdays> fetch(TlBufferParser &p);

  explicit contacts_contactBirthdays(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class contact;

class contacts_Contacts: public Object {
 public:

  static object_ptr<contacts_Contacts> fetch(TlBufferParser &p);
};

class contacts_contactsNotModified final : public contacts_Contacts {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1219778094;

  static object_ptr<contacts_Contacts> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class contacts_contacts final : public contacts_Contacts {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<contact>> contacts_;
  int32 saved_count_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -353862078;

  static object_ptr<contacts_Contacts> fetch(TlBufferParser &p);

  explicit contacts_contacts(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Peer;

class User;

class contacts_found final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Peer>> my_results_;
  array<object_ptr<Peer>> results_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1290580579;

  static object_ptr<contacts_found> fetch(TlBufferParser &p);

  explicit contacts_found(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class importedContact;

class popularContact;

class contacts_importedContacts final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<importedContact>> imported_;
  array<object_ptr<popularContact>> popular_invites_;
  array<int64> retry_contacts_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 2010127419;

  static object_ptr<contacts_importedContacts> fetch(TlBufferParser &p);

  explicit contacts_importedContacts(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Peer;

class User;

class contacts_resolvedPeer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Peer> peer_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 2131196633;

  static object_ptr<contacts_resolvedPeer> fetch(TlBufferParser &p);

  explicit contacts_resolvedPeer(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class topPeerCategoryPeers;

class contacts_TopPeers: public Object {
 public:

  static object_ptr<contacts_TopPeers> fetch(TlBufferParser &p);
};

class contacts_topPeersNotModified final : public contacts_TopPeers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -567906571;

  static object_ptr<contacts_TopPeers> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class contacts_topPeers final : public contacts_TopPeers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<topPeerCategoryPeers>> categories_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 1891070632;

  static object_ptr<contacts_TopPeers> fetch(TlBufferParser &p);

  explicit contacts_topPeers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class contacts_topPeersDisabled final : public contacts_TopPeers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1255369827;

  static object_ptr<contacts_TopPeers> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fragment_collectibleInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 purchase_date_;
  string currency_;
  int64 amount_;
  string crypto_currency_;
  int64 crypto_amount_;
  string url_;

  static const std::int32_t ID = 1857945489;

  static object_ptr<fragment_collectibleInfo> fetch(TlBufferParser &p);

  explicit fragment_collectibleInfo(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class JSONValue;

class help_AppConfig: public Object {
 public:

  static object_ptr<help_AppConfig> fetch(TlBufferParser &p);
};

class help_appConfigNotModified final : public help_AppConfig {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2094949405;

  static object_ptr<help_AppConfig> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_appConfig final : public help_AppConfig {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;
  object_ptr<JSONValue> config_;

  static const std::int32_t ID = -585598930;

  static object_ptr<help_AppConfig> fetch(TlBufferParser &p);

  explicit help_appConfig(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class MessageEntity;

class help_AppUpdate: public Object {
 public:

  static object_ptr<help_AppUpdate> fetch(TlBufferParser &p);
};

class help_appUpdate final : public help_AppUpdate {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool can_not_skip_;
  int32 id_;
  string version_;
  string text_;
  array<object_ptr<MessageEntity>> entities_;
  object_ptr<Document> document_;
  string url_;
  object_ptr<Document> sticker_;
  enum Flags : std::int32_t { URL_MASK = 4 };

  help_appUpdate();

  static const std::int32_t ID = -860107216;

  static object_ptr<help_AppUpdate> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_noAppUpdate final : public help_AppUpdate {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1000708810;

  static object_ptr<help_AppUpdate> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class accessPointRule;

class help_configSimple final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 date_;
  int32 expires_;
  array<object_ptr<accessPointRule>> rules_;

  static const std::int32_t ID = 1515793004;

  static object_ptr<help_configSimple> fetch(TlBufferParser &p);

  explicit help_configSimple(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_country;

class help_CountriesList: public Object {
 public:

  static object_ptr<help_CountriesList> fetch(TlBufferParser &p);
};

class help_countriesListNotModified final : public help_CountriesList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1815339214;

  static object_ptr<help_CountriesList> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_countriesList final : public help_CountriesList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<help_country>> countries_;
  int32 hash_;

  static const std::int32_t ID = -2016381538;

  static object_ptr<help_CountriesList> fetch(TlBufferParser &p);

  explicit help_countriesList(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_countryCode;

class help_country final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool hidden_;
  string iso2_;
  string default_name_;
  string name_;
  array<object_ptr<help_countryCode>> country_codes_;
  enum Flags : std::int32_t { NAME_MASK = 2 };

  help_country();

  static const std::int32_t ID = -1014526429;

  static object_ptr<help_country> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_countryCode final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string country_code_;
  array<string> prefixes_;
  array<string> patterns_;

  help_countryCode();

  static const std::int32_t ID = 1107543535;

  static object_ptr<help_countryCode> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageEntity;

class help_DeepLinkInfo: public Object {
 public:

  static object_ptr<help_DeepLinkInfo> fetch(TlBufferParser &p);
};

class help_deepLinkInfoEmpty final : public help_DeepLinkInfo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1722786150;

  static object_ptr<help_DeepLinkInfo> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_deepLinkInfo final : public help_DeepLinkInfo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool update_app_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;

  help_deepLinkInfo();

  static const std::int32_t ID = 1783556146;

  static object_ptr<help_DeepLinkInfo> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_inviteText final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string message_;

  static const std::int32_t ID = 415997816;

  static object_ptr<help_inviteText> fetch(TlBufferParser &p);

  explicit help_inviteText(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dataJSON;

class help_PassportConfig: public Object {
 public:

  static object_ptr<help_PassportConfig> fetch(TlBufferParser &p);
};

class help_passportConfigNotModified final : public help_PassportConfig {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1078332329;

  static object_ptr<help_PassportConfig> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_passportConfig final : public help_PassportConfig {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;
  object_ptr<dataJSON> countries_langs_;

  static const std::int32_t ID = -1600596305;

  static object_ptr<help_PassportConfig> fetch(TlBufferParser &p);

  explicit help_passportConfig(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_PeerColorSet;

class help_peerColorOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool hidden_;
  int32 color_id_;
  object_ptr<help_PeerColorSet> colors_;
  object_ptr<help_PeerColorSet> dark_colors_;
  int32 channel_min_level_;
  int32 group_min_level_;
  enum Flags : std::int32_t { CHANNEL_MIN_LEVEL_MASK = 8, GROUP_MIN_LEVEL_MASK = 16 };

  help_peerColorOption();

  static const std::int32_t ID = -1377014082;

  static object_ptr<help_peerColorOption> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_PeerColorSet: public Object {
 public:

  static object_ptr<help_PeerColorSet> fetch(TlBufferParser &p);
};

class help_peerColorSet final : public help_PeerColorSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> colors_;

  static const std::int32_t ID = 639736408;

  static object_ptr<help_PeerColorSet> fetch(TlBufferParser &p);

  explicit help_peerColorSet(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_peerColorProfileSet final : public help_PeerColorSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> palette_colors_;
  array<int32> bg_colors_;
  array<int32> story_colors_;

  static const std::int32_t ID = 1987928555;

  static object_ptr<help_PeerColorSet> fetch(TlBufferParser &p);

  explicit help_peerColorProfileSet(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_peerColorOption;

class help_PeerColors: public Object {
 public:

  static object_ptr<help_PeerColors> fetch(TlBufferParser &p);
};

class help_peerColorsNotModified final : public help_PeerColors {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 732034510;

  static object_ptr<help_PeerColors> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_peerColors final : public help_PeerColors {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;
  array<object_ptr<help_peerColorOption>> colors_;

  static const std::int32_t ID = 16313608;

  static object_ptr<help_PeerColors> fetch(TlBufferParser &p);

  explicit help_peerColors(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class MessageEntity;

class User;

class premiumSubscriptionOption;

class help_premiumPromo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string status_text_;
  array<object_ptr<MessageEntity>> status_entities_;
  array<string> video_sections_;
  array<object_ptr<Document>> videos_;
  array<object_ptr<premiumSubscriptionOption>> period_options_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 1395946908;

  static object_ptr<help_premiumPromo> fetch(TlBufferParser &p);

  explicit help_premiumPromo(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Peer;

class User;

class help_PromoData: public Object {
 public:

  static object_ptr<help_PromoData> fetch(TlBufferParser &p);
};

class help_promoDataEmpty final : public help_PromoData {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 expires_;

  static const std::int32_t ID = -1728664459;

  static object_ptr<help_PromoData> fetch(TlBufferParser &p);

  explicit help_promoDataEmpty(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_promoData final : public help_PromoData {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool proxy_;
  int32 expires_;
  object_ptr<Peer> peer_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  string psa_type_;
  string psa_message_;
  enum Flags : std::int32_t { PSA_TYPE_MASK = 2, PSA_MESSAGE_MASK = 4 };

  help_promoData();

  static const std::int32_t ID = -1942390465;

  static object_ptr<help_PromoData> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class RecentMeUrl;

class User;

class help_recentMeUrls final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<RecentMeUrl>> urls_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 235081943;

  static object_ptr<help_recentMeUrls> fetch(TlBufferParser &p);

  explicit help_recentMeUrls(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class help_support final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  object_ptr<User> user_;

  static const std::int32_t ID = 398898678;

  static object_ptr<help_support> fetch(TlBufferParser &p);

  explicit help_support(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_supportName final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  static const std::int32_t ID = -1945767479;

  static object_ptr<help_supportName> fetch(TlBufferParser &p);

  explicit help_supportName(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageEntity;

class dataJSON;

class help_termsOfService final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool popup_;
  object_ptr<dataJSON> id_;
  string text_;
  array<object_ptr<MessageEntity>> entities_;
  int32 min_age_confirm_;
  enum Flags : std::int32_t { MIN_AGE_CONFIRM_MASK = 2 };

  help_termsOfService();

  static const std::int32_t ID = 2013922064;

  static object_ptr<help_termsOfService> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_termsOfService;

class help_TermsOfServiceUpdate: public Object {
 public:

  static object_ptr<help_TermsOfServiceUpdate> fetch(TlBufferParser &p);
};

class help_termsOfServiceUpdateEmpty final : public help_TermsOfServiceUpdate {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 expires_;

  static const std::int32_t ID = -483352705;

  static object_ptr<help_TermsOfServiceUpdate> fetch(TlBufferParser &p);

  explicit help_termsOfServiceUpdateEmpty(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_termsOfServiceUpdate final : public help_TermsOfServiceUpdate {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 expires_;
  object_ptr<help_termsOfService> terms_of_service_;

  static const std::int32_t ID = 686618977;

  static object_ptr<help_TermsOfServiceUpdate> fetch(TlBufferParser &p);

  explicit help_termsOfServiceUpdate(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class timezone;

class help_TimezonesList: public Object {
 public:

  static object_ptr<help_TimezonesList> fetch(TlBufferParser &p);
};

class help_timezonesListNotModified final : public help_TimezonesList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1761146676;

  static object_ptr<help_TimezonesList> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_timezonesList final : public help_TimezonesList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<timezone>> timezones_;
  int32 hash_;

  static const std::int32_t ID = 2071260529;

  static object_ptr<help_TimezonesList> fetch(TlBufferParser &p);

  explicit help_timezonesList(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageEntity;

class help_UserInfo: public Object {
 public:

  static object_ptr<help_UserInfo> fetch(TlBufferParser &p);
};

class help_userInfoEmpty final : public help_UserInfo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -206688531;

  static object_ptr<help_UserInfo> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class help_userInfo final : public help_UserInfo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string message_;
  array<object_ptr<MessageEntity>> entities_;
  string author_;
  int32 date_;

  static const std::int32_t ID = 32192344;

  static object_ptr<help_UserInfo> fetch(TlBufferParser &p);

  explicit help_userInfo(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_affectedFoundMessages final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 pts_;
  int32 pts_count_;
  int32 offset_;
  array<int32> messages_;

  static const std::int32_t ID = -275956116;

  static object_ptr<messages_affectedFoundMessages> fetch(TlBufferParser &p);

  explicit messages_affectedFoundMessages(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_affectedHistory final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 pts_;
  int32 pts_count_;
  int32 offset_;

  static const std::int32_t ID = -1269012015;

  static object_ptr<messages_affectedHistory> fetch(TlBufferParser &p);

  explicit messages_affectedHistory(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_affectedMessages final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 pts_;
  int32 pts_count_;

  static const std::int32_t ID = -2066640507;

  static object_ptr<messages_affectedMessages> fetch(TlBufferParser &p);

  explicit messages_affectedMessages(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerSet;

class messages_AllStickers: public Object {
 public:

  static object_ptr<messages_AllStickers> fetch(TlBufferParser &p);
};

class messages_allStickersNotModified final : public messages_AllStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -395967805;

  static object_ptr<messages_AllStickers> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_allStickers final : public messages_AllStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<stickerSet>> sets_;

  static const std::int32_t ID = -843329861;

  static object_ptr<messages_AllStickers> fetch(TlBufferParser &p);

  explicit messages_allStickers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerSetCovered;

class messages_archivedStickers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<StickerSetCovered>> sets_;

  static const std::int32_t ID = 1338747336;

  static object_ptr<messages_archivedStickers> fetch(TlBufferParser &p);

  explicit messages_archivedStickers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class availableEffect;

class messages_AvailableEffects: public Object {
 public:

  static object_ptr<messages_AvailableEffects> fetch(TlBufferParser &p);
};

class messages_availableEffectsNotModified final : public messages_AvailableEffects {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -772957605;

  static object_ptr<messages_AvailableEffects> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_availableEffects final : public messages_AvailableEffects {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;
  array<object_ptr<availableEffect>> effects_;
  array<object_ptr<Document>> documents_;

  static const std::int32_t ID = -1109696146;

  static object_ptr<messages_AvailableEffects> fetch(TlBufferParser &p);

  explicit messages_availableEffects(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class availableReaction;

class messages_AvailableReactions: public Object {
 public:

  static object_ptr<messages_AvailableReactions> fetch(TlBufferParser &p);
};

class messages_availableReactionsNotModified final : public messages_AvailableReactions {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1626924713;

  static object_ptr<messages_AvailableReactions> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_availableReactions final : public messages_AvailableReactions {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;
  array<object_ptr<availableReaction>> reactions_;

  static const std::int32_t ID = 1989032621;

  static object_ptr<messages_AvailableReactions> fetch(TlBufferParser &p);

  explicit messages_availableReactions(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotApp;

class messages_botApp final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool inactive_;
  bool request_write_access_;
  bool has_settings_;
  object_ptr<BotApp> app_;

  messages_botApp();

  static const std::int32_t ID = -347034123;

  static object_ptr<messages_botApp> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_botCallbackAnswer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool alert_;
  bool has_url_;
  bool native_ui_;
  string message_;
  string url_;
  int32 cache_time_;
  enum Flags : std::int32_t { MESSAGE_MASK = 1, URL_MASK = 4 };

  messages_botCallbackAnswer();

  static const std::int32_t ID = 911761060;

  static object_ptr<messages_botCallbackAnswer> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_botPreparedInlineMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  int32 expire_date_;

  static const std::int32_t ID = -1899035375;

  static object_ptr<messages_botPreparedInlineMessage> fetch(TlBufferParser &p);

  explicit messages_botPreparedInlineMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotInlineResult;

class User;

class inlineBotSwitchPM;

class inlineBotWebView;

class messages_botResults final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool gallery_;
  int64 query_id_;
  string next_offset_;
  object_ptr<inlineBotSwitchPM> switch_pm_;
  object_ptr<inlineBotWebView> switch_webview_;
  array<object_ptr<BotInlineResult>> results_;
  int32 cache_time_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 2 };

  messages_botResults();

  static const std::int32_t ID = -534646026;

  static object_ptr<messages_botResults> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class chatAdminWithInvites;

class messages_chatAdminsWithInvites final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<chatAdminWithInvites>> admins_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1231326505;

  static object_ptr<messages_chatAdminsWithInvites> fetch(TlBufferParser &p);

  explicit messages_chatAdminsWithInvites(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class ChatFull;

class User;

class messages_chatFull final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChatFull> full_chat_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -438840932;

  static object_ptr<messages_chatFull> fetch(TlBufferParser &p);

  explicit messages_chatFull(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class chatInviteImporter;

class messages_chatInviteImporters final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<chatInviteImporter>> importers_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -2118733814;

  static object_ptr<messages_chatInviteImporters> fetch(TlBufferParser &p);

  explicit messages_chatInviteImporters(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class messages_Chats: public Object {
 public:

  static object_ptr<messages_Chats> fetch(TlBufferParser &p);
};

class messages_chats final : public messages_Chats {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Chat>> chats_;

  static const std::int32_t ID = 1694474197;

  static object_ptr<messages_Chats> fetch(TlBufferParser &p);

  explicit messages_chats(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_chatsSlice final : public messages_Chats {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<Chat>> chats_;

  static const std::int32_t ID = -1663561404;

  static object_ptr<messages_Chats> fetch(TlBufferParser &p);

  explicit messages_chatsSlice(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_checkedHistoryImportPeer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string confirm_text_;

  static const std::int32_t ID = -1571952873;

  static object_ptr<messages_checkedHistoryImportPeer> fetch(TlBufferParser &p);

  explicit messages_checkedHistoryImportPeer(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_DhConfig: public Object {
 public:

  static object_ptr<messages_DhConfig> fetch(TlBufferParser &p);
};

class messages_dhConfigNotModified final : public messages_DhConfig {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes random_;

  static const std::int32_t ID = -1058912715;

  static object_ptr<messages_DhConfig> fetch(TlBufferParser &p);

  explicit messages_dhConfigNotModified(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_dhConfig final : public messages_DhConfig {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 g_;
  bytes p_;
  int32 version_;
  bytes random_;

  static const std::int32_t ID = 740433629;

  static object_ptr<messages_DhConfig> fetch(TlBufferParser &p);

  explicit messages_dhConfig(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class DialogFilter;

class messages_dialogFilters final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool tags_enabled_;
  array<object_ptr<DialogFilter>> filters_;

  messages_dialogFilters();

  static const std::int32_t ID = 718878489;

  static object_ptr<messages_dialogFilters> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Dialog;

class Message;

class User;

class messages_Dialogs: public Object {
 public:

  static object_ptr<messages_Dialogs> fetch(TlBufferParser &p);
};

class messages_dialogs final : public messages_Dialogs {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Dialog>> dialogs_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 364538944;

  static object_ptr<messages_Dialogs> fetch(TlBufferParser &p);

  explicit messages_dialogs(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_dialogsSlice final : public messages_Dialogs {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<Dialog>> dialogs_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 1910543603;

  static object_ptr<messages_Dialogs> fetch(TlBufferParser &p);

  explicit messages_dialogsSlice(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_dialogsNotModified final : public messages_Dialogs {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;

  static const std::int32_t ID = -253500010;

  static object_ptr<messages_Dialogs> fetch(TlBufferParser &p);

  explicit messages_dialogsNotModified(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Message;

class User;

class messages_discussionMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  array<object_ptr<Message>> messages_;
  int32 max_id_;
  int32 read_inbox_max_id_;
  int32 read_outbox_max_id_;
  int32 unread_count_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { MAX_ID_MASK = 1, READ_INBOX_MAX_ID_MASK = 2, READ_OUTBOX_MAX_ID_MASK = 4 };

  messages_discussionMessage();

  static const std::int32_t ID = -1506535550;

  static object_ptr<messages_discussionMessage> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiGroup;

class messages_EmojiGroups: public Object {
 public:

  static object_ptr<messages_EmojiGroups> fetch(TlBufferParser &p);
};

class messages_emojiGroupsNotModified final : public messages_EmojiGroups {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1874111879;

  static object_ptr<messages_EmojiGroups> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_emojiGroups final : public messages_EmojiGroups {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;
  array<object_ptr<EmojiGroup>> groups_;

  static const std::int32_t ID = -2011186869;

  static object_ptr<messages_EmojiGroups> fetch(TlBufferParser &p);

  explicit messages_emojiGroups(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ExportedChatInvite;

class User;

class messages_ExportedChatInvite: public Object {
 public:

  static object_ptr<messages_ExportedChatInvite> fetch(TlBufferParser &p);
};

class messages_exportedChatInvite final : public messages_ExportedChatInvite {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ExportedChatInvite> invite_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 410107472;

  static object_ptr<messages_ExportedChatInvite> fetch(TlBufferParser &p);

  explicit messages_exportedChatInvite(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_exportedChatInviteReplaced final : public messages_ExportedChatInvite {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ExportedChatInvite> invite_;
  object_ptr<ExportedChatInvite> new_invite_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 572915951;

  static object_ptr<messages_ExportedChatInvite> fetch(TlBufferParser &p);

  explicit messages_exportedChatInviteReplaced(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ExportedChatInvite;

class User;

class messages_exportedChatInvites final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<ExportedChatInvite>> invites_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1111085620;

  static object_ptr<messages_exportedChatInvites> fetch(TlBufferParser &p);

  explicit messages_exportedChatInvites(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class stickerPack;

class messages_FavedStickers: public Object {
 public:

  static object_ptr<messages_FavedStickers> fetch(TlBufferParser &p);
};

class messages_favedStickersNotModified final : public messages_FavedStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1634752813;

  static object_ptr<messages_FavedStickers> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_favedStickers final : public messages_FavedStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<stickerPack>> packs_;
  array<object_ptr<Document>> stickers_;

  static const std::int32_t ID = 750063767;

  static object_ptr<messages_FavedStickers> fetch(TlBufferParser &p);

  explicit messages_favedStickers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerSetCovered;

class messages_FeaturedStickers: public Object {
 public:

  static object_ptr<messages_FeaturedStickers> fetch(TlBufferParser &p);
};

class messages_featuredStickersNotModified final : public messages_FeaturedStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;

  static const std::int32_t ID = -958657434;

  static object_ptr<messages_FeaturedStickers> fetch(TlBufferParser &p);

  explicit messages_featuredStickersNotModified(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_featuredStickers final : public messages_FeaturedStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool premium_;
  int64 hash_;
  int32 count_;
  array<object_ptr<StickerSetCovered>> sets_;
  array<int64> unread_;

  messages_featuredStickers();

  static const std::int32_t ID = -1103615738;

  static object_ptr<messages_FeaturedStickers> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class ForumTopic;

class Message;

class User;

class messages_forumTopics final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool order_by_create_date_;
  int32 count_;
  array<object_ptr<ForumTopic>> topics_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  int32 pts_;

  messages_forumTopics();

  static const std::int32_t ID = 913709011;

  static object_ptr<messages_forumTopics> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerSetCovered;

class messages_FoundStickerSets: public Object {
 public:

  static object_ptr<messages_FoundStickerSets> fetch(TlBufferParser &p);
};

class messages_foundStickerSetsNotModified final : public messages_FoundStickerSets {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 223655517;

  static object_ptr<messages_FoundStickerSets> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_foundStickerSets final : public messages_FoundStickerSets {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<StickerSetCovered>> sets_;

  static const std::int32_t ID = -1963942446;

  static object_ptr<messages_FoundStickerSets> fetch(TlBufferParser &p);

  explicit messages_foundStickerSets(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class messages_FoundStickers: public Object {
 public:

  static object_ptr<messages_FoundStickers> fetch(TlBufferParser &p);
};

class messages_foundStickersNotModified final : public messages_FoundStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 next_offset_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  messages_foundStickersNotModified();

  static const std::int32_t ID = 1611711796;

  static object_ptr<messages_FoundStickers> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_foundStickers final : public messages_FoundStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 next_offset_;
  int64 hash_;
  array<object_ptr<Document>> stickers_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  messages_foundStickers();

  static const std::int32_t ID = -2100698480;

  static object_ptr<messages_FoundStickers> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class highScore;

class messages_highScores final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<highScore>> scores_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1707344487;

  static object_ptr<messages_highScores> fetch(TlBufferParser &p);

  explicit messages_highScores(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_historyImport final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;

  static const std::int32_t ID = 375566091;

  static object_ptr<messages_historyImport> fetch(TlBufferParser &p);

  explicit messages_historyImport(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_historyImportParsed final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pm_;
  bool group_;
  string title_;
  enum Flags : std::int32_t { TITLE_MASK = 4 };

  messages_historyImportParsed();

  static const std::int32_t ID = 1578088377;

  static object_ptr<messages_historyImportParsed> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class messages_inactiveChats final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> dates_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1456996667;

  static object_ptr<messages_inactiveChats> fetch(TlBufferParser &p);

  explicit messages_inactiveChats(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Updates;

class missingInvitee;

class messages_invitedUsers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Updates> updates_;
  array<object_ptr<missingInvitee>> missing_invitees_;

  static const std::int32_t ID = 2136862630;

  static object_ptr<messages_invitedUsers> fetch(TlBufferParser &p);

  explicit messages_invitedUsers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_messageEditData final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool caption_;

  messages_messageEditData();

  static const std::int32_t ID = 649453030;

  static object_ptr<messages_messageEditData> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class messagePeerReaction;

class messages_messageReactionsList final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 count_;
  array<object_ptr<messagePeerReaction>> reactions_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  string next_offset_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  messages_messageReactionsList();

  static const std::int32_t ID = 834488621;

  static object_ptr<messages_messageReactionsList> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class messageViews;

class messages_messageViews final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<messageViews>> views_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1228606141;

  static object_ptr<messages_messageViews> fetch(TlBufferParser &p);

  explicit messages_messageViews(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class ForumTopic;

class Message;

class User;

class messages_Messages: public Object {
 public:

  static object_ptr<messages_Messages> fetch(TlBufferParser &p);
};

class messages_messages final : public messages_Messages {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1938715001;

  static object_ptr<messages_Messages> fetch(TlBufferParser &p);

  explicit messages_messages(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_messagesSlice final : public messages_Messages {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool inexact_;
  int32 count_;
  int32 next_rate_;
  int32 offset_id_offset_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { NEXT_RATE_MASK = 1, OFFSET_ID_OFFSET_MASK = 4 };

  messages_messagesSlice();

  static const std::int32_t ID = 978610270;

  static object_ptr<messages_Messages> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_channelMessages final : public messages_Messages {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool inexact_;
  int32 pts_;
  int32 count_;
  int32 offset_id_offset_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<ForumTopic>> topics_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { OFFSET_ID_OFFSET_MASK = 4 };

  messages_channelMessages();

  static const std::int32_t ID = -948520370;

  static object_ptr<messages_Messages> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_messagesNotModified final : public messages_Messages {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;

  static const std::int32_t ID = 1951620897;

  static object_ptr<messages_Messages> fetch(TlBufferParser &p);

  explicit messages_messagesNotModified(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerSetCovered;

class messages_myStickers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<StickerSetCovered>> sets_;

  static const std::int32_t ID = -83926371;

  static object_ptr<messages_myStickers> fetch(TlBufferParser &p);

  explicit messages_myStickers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Dialog;

class Message;

class User;

class updates_state;

class messages_peerDialogs final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Dialog>> dialogs_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  object_ptr<updates_state> state_;

  static const std::int32_t ID = 863093588;

  static object_ptr<messages_peerDialogs> fetch(TlBufferParser &p);

  explicit messages_peerDialogs(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class peerSettings;

class messages_peerSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<peerSettings> settings_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 1753266509;

  static object_ptr<messages_peerSettings> fetch(TlBufferParser &p);

  explicit messages_peerSettings(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotInlineResult;

class InlineQueryPeerType;

class User;

class messages_preparedInlineMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 query_id_;
  object_ptr<BotInlineResult> result_;
  array<object_ptr<InlineQueryPeerType>> peer_types_;
  int32 cache_time_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -11046771;

  static object_ptr<messages_preparedInlineMessage> fetch(TlBufferParser &p);

  explicit messages_preparedInlineMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Message;

class User;

class quickReply;

class messages_QuickReplies: public Object {
 public:

  static object_ptr<messages_QuickReplies> fetch(TlBufferParser &p);
};

class messages_quickReplies final : public messages_QuickReplies {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<quickReply>> quick_replies_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -963811691;

  static object_ptr<messages_QuickReplies> fetch(TlBufferParser &p);

  explicit messages_quickReplies(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_quickRepliesNotModified final : public messages_QuickReplies {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1603398491;

  static object_ptr<messages_QuickReplies> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Reaction;

class messages_Reactions: public Object {
 public:

  static object_ptr<messages_Reactions> fetch(TlBufferParser &p);
};

class messages_reactionsNotModified final : public messages_Reactions {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1334846497;

  static object_ptr<messages_Reactions> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_reactions final : public messages_Reactions {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<Reaction>> reactions_;

  static const std::int32_t ID = -352454890;

  static object_ptr<messages_Reactions> fetch(TlBufferParser &p);

  explicit messages_reactions(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class stickerPack;

class messages_RecentStickers: public Object {
 public:

  static object_ptr<messages_RecentStickers> fetch(TlBufferParser &p);
};

class messages_recentStickersNotModified final : public messages_RecentStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 186120336;

  static object_ptr<messages_RecentStickers> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_recentStickers final : public messages_RecentStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<stickerPack>> packs_;
  array<object_ptr<Document>> stickers_;
  array<int32> dates_;

  static const std::int32_t ID = -1999405994;

  static object_ptr<messages_RecentStickers> fetch(TlBufferParser &p);

  explicit messages_recentStickers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Message;

class User;

class savedDialog;

class messages_SavedDialogs: public Object {
 public:

  static object_ptr<messages_SavedDialogs> fetch(TlBufferParser &p);
};

class messages_savedDialogs final : public messages_SavedDialogs {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<savedDialog>> dialogs_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -130358751;

  static object_ptr<messages_SavedDialogs> fetch(TlBufferParser &p);

  explicit messages_savedDialogs(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_savedDialogsSlice final : public messages_SavedDialogs {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<savedDialog>> dialogs_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 1153080793;

  static object_ptr<messages_SavedDialogs> fetch(TlBufferParser &p);

  explicit messages_savedDialogsSlice(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_savedDialogsNotModified final : public messages_SavedDialogs {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;

  static const std::int32_t ID = -1071681560;

  static object_ptr<messages_SavedDialogs> fetch(TlBufferParser &p);

  explicit messages_savedDialogsNotModified(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class messages_SavedGifs: public Object {
 public:

  static object_ptr<messages_SavedGifs> fetch(TlBufferParser &p);
};

class messages_savedGifsNotModified final : public messages_SavedGifs {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -402498398;

  static object_ptr<messages_SavedGifs> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_savedGifs final : public messages_SavedGifs {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<Document>> gifs_;

  static const std::int32_t ID = -2069878259;

  static object_ptr<messages_SavedGifs> fetch(TlBufferParser &p);

  explicit messages_savedGifs(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class savedReactionTag;

class messages_SavedReactionTags: public Object {
 public:

  static object_ptr<messages_SavedReactionTags> fetch(TlBufferParser &p);
};

class messages_savedReactionTagsNotModified final : public messages_SavedReactionTags {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -2003084817;

  static object_ptr<messages_SavedReactionTags> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_savedReactionTags final : public messages_SavedReactionTags {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<savedReactionTag>> tags_;
  int64 hash_;

  static const std::int32_t ID = 844731658;

  static object_ptr<messages_SavedReactionTags> fetch(TlBufferParser &p);

  explicit messages_savedReactionTags(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessagesFilter;

class messages_searchCounter final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool inexact_;
  object_ptr<MessagesFilter> filter_;
  int32 count_;

  messages_searchCounter();

  static const std::int32_t ID = -398136321;

  static object_ptr<messages_searchCounter> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Message;

class User;

class searchResultsCalendarPeriod;

class messages_searchResultsCalendar final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool inexact_;
  int32 count_;
  int32 min_date_;
  int32 min_msg_id_;
  int32 offset_id_offset_;
  array<object_ptr<searchResultsCalendarPeriod>> periods_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { OFFSET_ID_OFFSET_MASK = 2 };

  messages_searchResultsCalendar();

  static const std::int32_t ID = 343859772;

  static object_ptr<messages_searchResultsCalendar> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchResultPosition;

class messages_searchResultsPositions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<searchResultPosition>> positions_;

  static const std::int32_t ID = 1404185519;

  static object_ptr<messages_searchResultsPositions> fetch(TlBufferParser &p);

  explicit messages_searchResultsPositions(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EncryptedFile;

class messages_SentEncryptedMessage: public Object {
 public:

  static object_ptr<messages_SentEncryptedMessage> fetch(TlBufferParser &p);
};

class messages_sentEncryptedMessage final : public messages_SentEncryptedMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 date_;

  static const std::int32_t ID = 1443858741;

  static object_ptr<messages_SentEncryptedMessage> fetch(TlBufferParser &p);

  explicit messages_sentEncryptedMessage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_sentEncryptedFile final : public messages_SentEncryptedMessage {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 date_;
  object_ptr<EncryptedFile> file_;

  static const std::int32_t ID = -1802240206;

  static object_ptr<messages_SentEncryptedMessage> fetch(TlBufferParser &p);

  explicit messages_sentEncryptedFile(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class sponsoredMessage;

class messages_SponsoredMessages: public Object {
 public:

  static object_ptr<messages_SponsoredMessages> fetch(TlBufferParser &p);
};

class messages_sponsoredMessages final : public messages_SponsoredMessages {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 posts_between_;
  array<object_ptr<sponsoredMessage>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { POSTS_BETWEEN_MASK = 1 };

  messages_sponsoredMessages();

  static const std::int32_t ID = -907141753;

  static object_ptr<messages_SponsoredMessages> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_sponsoredMessagesEmpty final : public messages_SponsoredMessages {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 406407439;

  static object_ptr<messages_SponsoredMessages> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class stickerKeyword;

class stickerPack;

class stickerSet;

class messages_StickerSet: public Object {
 public:

  static object_ptr<messages_StickerSet> fetch(TlBufferParser &p);
};

class messages_stickerSet final : public messages_StickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<stickerSet> set_;
  array<object_ptr<stickerPack>> packs_;
  array<object_ptr<stickerKeyword>> keywords_;
  array<object_ptr<Document>> documents_;

  messages_stickerSet(object_ptr<stickerSet> &&set_, array<object_ptr<stickerPack>> &&packs_, array<object_ptr<stickerKeyword>> &&keywords_, array<object_ptr<Document>> &&documents_);

  static const std::int32_t ID = 1846886166;

  static object_ptr<messages_StickerSet> fetch(TlBufferParser &p);

  explicit messages_stickerSet(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_stickerSetNotModified final : public messages_StickerSet {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -738646805;

  static object_ptr<messages_StickerSet> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerSetCovered;

class messages_StickerSetInstallResult: public Object {
 public:

  static object_ptr<messages_StickerSetInstallResult> fetch(TlBufferParser &p);
};

class messages_stickerSetInstallResultSuccess final : public messages_StickerSetInstallResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 946083368;

  static object_ptr<messages_StickerSetInstallResult> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_stickerSetInstallResultArchive final : public messages_StickerSetInstallResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<StickerSetCovered>> sets_;

  static const std::int32_t ID = 904138920;

  static object_ptr<messages_StickerSetInstallResult> fetch(TlBufferParser &p);

  explicit messages_stickerSetInstallResultArchive(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Document;

class messages_Stickers: public Object {
 public:

  static object_ptr<messages_Stickers> fetch(TlBufferParser &p);
};

class messages_stickersNotModified final : public messages_Stickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -244016606;

  static object_ptr<messages_Stickers> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_stickers final : public messages_Stickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;
  array<object_ptr<Document>> stickers_;

  static const std::int32_t ID = 816245886;

  static object_ptr<messages_Stickers> fetch(TlBufferParser &p);

  explicit messages_stickers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages_transcribedAudio final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool pending_;
  int64 transcription_id_;
  string text_;
  int32 trial_remains_num_;
  int32 trial_remains_until_date_;
  enum Flags : std::int32_t { TRIAL_REMAINS_NUM_MASK = 2, TRIAL_REMAINS_UNTIL_DATE_MASK = 2 };

  messages_transcribedAudio();

  static const std::int32_t ID = -809903785;

  static object_ptr<messages_transcribedAudio> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textWithEntities;

class messages_translateResult final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<textWithEntities>> result_;

  static const std::int32_t ID = 870003448;

  static object_ptr<messages_translateResult> fetch(TlBufferParser &p);

  explicit messages_translateResult(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class MessagePeerVote;

class User;

class messages_votesList final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 count_;
  array<object_ptr<MessagePeerVote>> votes_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  string next_offset_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  messages_votesList();

  static const std::int32_t ID = 1218005070;

  static object_ptr<messages_votesList> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class WebPage;

class messages_webPage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<WebPage> webpage_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -44166467;

  static object_ptr<messages_webPage> fetch(TlBufferParser &p);

  explicit messages_webPage(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageMedia;

class User;

class messages_webPagePreview final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageMedia> media_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1254192351;

  static object_ptr<messages_webPagePreview> fetch(TlBufferParser &p);

  explicit messages_webPagePreview(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class bankCardOpenUrl;

class payments_bankCardData final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  array<object_ptr<bankCardOpenUrl>> open_urls_;

  static const std::int32_t ID = 1042605427;

  static object_ptr<payments_bankCardData> fetch(TlBufferParser &p);

  explicit payments_bankCardData(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Peer;

class User;

class payments_checkedGiftCode final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool via_giveaway_;
  object_ptr<Peer> from_id_;
  int32 giveaway_msg_id_;
  int64 to_id_;
  int32 date_;
  int32 months_;
  int32 used_date_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { GIVEAWAY_MSG_ID_MASK = 8, TO_ID_MASK = 1, USED_DATE_MASK = 2 };

  payments_checkedGiftCode();

  static const std::int32_t ID = 675942550;

  static object_ptr<payments_checkedGiftCode> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class connectedBotStarRef;

class payments_connectedStarRefBots final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<connectedBotStarRef>> connected_bots_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1730811363;

  static object_ptr<payments_connectedStarRefBots> fetch(TlBufferParser &p);

  explicit payments_connectedStarRefBots(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_exportedInvoice final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  static const std::int32_t ID = -1362048039;

  static object_ptr<payments_exportedInvoice> fetch(TlBufferParser &p);

  explicit payments_exportedInvoice(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_GiveawayInfo: public Object {
 public:

  static object_ptr<payments_GiveawayInfo> fetch(TlBufferParser &p);
};

class payments_giveawayInfo final : public payments_GiveawayInfo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool participating_;
  bool preparing_results_;
  int32 start_date_;
  int32 joined_too_early_date_;
  int64 admin_disallowed_chat_id_;
  string disallowed_country_;
  enum Flags : std::int32_t { JOINED_TOO_EARLY_DATE_MASK = 2, ADMIN_DISALLOWED_CHAT_ID_MASK = 4, DISALLOWED_COUNTRY_MASK = 16 };

  payments_giveawayInfo();

  static const std::int32_t ID = 1130879648;

  static object_ptr<payments_GiveawayInfo> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_giveawayInfoResults final : public payments_GiveawayInfo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool winner_;
  bool refunded_;
  int32 start_date_;
  string gift_code_slug_;
  int64 stars_prize_;
  int32 finish_date_;
  int32 winners_count_;
  int32 activated_count_;
  enum Flags : std::int32_t { GIFT_CODE_SLUG_MASK = 8, STARS_PRIZE_MASK = 16, ACTIVATED_COUNT_MASK = 4 };

  payments_giveawayInfoResults();

  static const std::int32_t ID = -512366993;

  static object_ptr<payments_GiveawayInfo> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class WebDocument;

class dataJSON;

class invoice;

class paymentFormMethod;

class paymentRequestedInfo;

class paymentSavedCredentialsCard;

class payments_PaymentForm: public Object {
 public:

  static object_ptr<payments_PaymentForm> fetch(TlBufferParser &p);
};

class payments_paymentForm final : public payments_PaymentForm {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool can_save_credentials_;
  bool password_missing_;
  int64 form_id_;
  int64 bot_id_;
  string title_;
  string description_;
  object_ptr<WebDocument> photo_;
  object_ptr<invoice> invoice_;
  int64 provider_id_;
  string url_;
  string native_provider_;
  object_ptr<dataJSON> native_params_;
  array<object_ptr<paymentFormMethod>> additional_methods_;
  object_ptr<paymentRequestedInfo> saved_info_;
  array<object_ptr<paymentSavedCredentialsCard>> saved_credentials_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { NATIVE_PROVIDER_MASK = 16 };

  payments_paymentForm();

  static const std::int32_t ID = -1610250415;

  static object_ptr<payments_PaymentForm> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_paymentFormStars final : public payments_PaymentForm {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int64 form_id_;
  int64 bot_id_;
  string title_;
  string description_;
  object_ptr<WebDocument> photo_;
  object_ptr<invoice> invoice_;
  array<object_ptr<User>> users_;

  payments_paymentFormStars();

  static const std::int32_t ID = 2079764828;

  static object_ptr<payments_PaymentForm> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_paymentFormStarGift final : public payments_PaymentForm {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 form_id_;
  object_ptr<invoice> invoice_;

  static const std::int32_t ID = -1272590367;

  static object_ptr<payments_PaymentForm> fetch(TlBufferParser &p);

  explicit payments_paymentFormStarGift(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class WebDocument;

class invoice;

class paymentRequestedInfo;

class shippingOption;

class payments_PaymentReceipt: public Object {
 public:

  static object_ptr<payments_PaymentReceipt> fetch(TlBufferParser &p);
};

class payments_paymentReceipt final : public payments_PaymentReceipt {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 date_;
  int64 bot_id_;
  int64 provider_id_;
  string title_;
  string description_;
  object_ptr<WebDocument> photo_;
  object_ptr<invoice> invoice_;
  object_ptr<paymentRequestedInfo> info_;
  object_ptr<shippingOption> shipping_;
  int64 tip_amount_;
  string currency_;
  int64 total_amount_;
  string credentials_title_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { TIP_AMOUNT_MASK = 8 };

  payments_paymentReceipt();

  static const std::int32_t ID = 1891958275;

  static object_ptr<payments_PaymentReceipt> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_paymentReceiptStars final : public payments_PaymentReceipt {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 date_;
  int64 bot_id_;
  string title_;
  string description_;
  object_ptr<WebDocument> photo_;
  object_ptr<invoice> invoice_;
  string currency_;
  int64 total_amount_;
  string transaction_id_;
  array<object_ptr<User>> users_;

  payments_paymentReceiptStars();

  static const std::int32_t ID = -625215430;

  static object_ptr<payments_PaymentReceipt> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Updates;

class payments_PaymentResult: public Object {
 public:

  static object_ptr<payments_PaymentResult> fetch(TlBufferParser &p);
};

class payments_paymentResult final : public payments_PaymentResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Updates> updates_;

  static const std::int32_t ID = 1314881805;

  static object_ptr<payments_PaymentResult> fetch(TlBufferParser &p);

  explicit payments_paymentResult(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_paymentVerificationNeeded final : public payments_PaymentResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  static const std::int32_t ID = -666824391;

  static object_ptr<payments_PaymentResult> fetch(TlBufferParser &p);

  explicit payments_paymentVerificationNeeded(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentRequestedInfo;

class payments_savedInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool has_saved_credentials_;
  object_ptr<paymentRequestedInfo> saved_info_;

  payments_savedInfo();

  static const std::int32_t ID = -74456004;

  static object_ptr<payments_savedInfo> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class savedStarGift;

class payments_savedStarGifts final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 count_;
  bool chat_notifications_enabled_;
  array<object_ptr<savedStarGift>> gifts_;
  string next_offset_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { CHAT_NOTIFICATIONS_ENABLED_MASK = 2, NEXT_OFFSET_MASK = 1 };

  payments_savedStarGifts();

  static const std::int32_t ID = -1779201615;

  static object_ptr<payments_savedStarGifts> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StarGiftAttribute;

class payments_starGiftUpgradePreview final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<StarGiftAttribute>> sample_attributes_;

  static const std::int32_t ID = 377215243;

  static object_ptr<payments_starGiftUpgradePreview> fetch(TlBufferParser &p);

  explicit payments_starGiftUpgradePreview(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_starGiftWithdrawalUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  static const std::int32_t ID = -2069218660;

  static object_ptr<payments_starGiftWithdrawalUrl> fetch(TlBufferParser &p);

  explicit payments_starGiftWithdrawalUrl(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StarGift;

class payments_StarGifts: public Object {
 public:

  static object_ptr<payments_StarGifts> fetch(TlBufferParser &p);
};

class payments_starGiftsNotModified final : public payments_StarGifts {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1551326360;

  static object_ptr<payments_StarGifts> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_starGifts final : public payments_StarGifts {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;
  array<object_ptr<StarGift>> gifts_;

  static const std::int32_t ID = -1877571094;

  static object_ptr<payments_StarGifts> fetch(TlBufferParser &p);

  explicit payments_starGifts(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_starsRevenueAdsAccountUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  static const std::int32_t ID = 961445665;

  static object_ptr<payments_starsRevenueAdsAccountUrl> fetch(TlBufferParser &p);

  explicit payments_starsRevenueAdsAccountUrl(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatsGraph;

class starsRevenueStatus;

class payments_starsRevenueStats final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StatsGraph> revenue_graph_;
  object_ptr<starsRevenueStatus> status_;
  double usd_rate_;

  static const std::int32_t ID = -919881925;

  static object_ptr<payments_starsRevenueStats> fetch(TlBufferParser &p);

  explicit payments_starsRevenueStats(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class payments_starsRevenueWithdrawalUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  static const std::int32_t ID = 497778871;

  static object_ptr<payments_starsRevenueWithdrawalUrl> fetch(TlBufferParser &p);

  explicit payments_starsRevenueWithdrawalUrl(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class starsAmount;

class starsSubscription;

class starsTransaction;

class payments_starsStatus final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<starsAmount> balance_;
  array<object_ptr<starsSubscription>> subscriptions_;
  string subscriptions_next_offset_;
  int64 subscriptions_missing_balance_;
  array<object_ptr<starsTransaction>> history_;
  string next_offset_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { SUBSCRIPTIONS_NEXT_OFFSET_MASK = 4, SUBSCRIPTIONS_MISSING_BALANCE_MASK = 16, NEXT_OFFSET_MASK = 1 };

  payments_starsStatus();

  static const std::int32_t ID = 1822222573;

  static object_ptr<payments_starsStatus> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class starRefProgram;

class payments_suggestedStarRefBots final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 count_;
  array<object_ptr<starRefProgram>> suggested_bots_;
  array<object_ptr<User>> users_;
  string next_offset_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  payments_suggestedStarRefBots();

  static const std::int32_t ID = -1261053863;

  static object_ptr<payments_suggestedStarRefBots> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StarGift;

class User;

class payments_uniqueStarGift final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StarGift> gift_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -895289845;

  static object_ptr<payments_uniqueStarGift> fetch(TlBufferParser &p);

  explicit payments_uniqueStarGift(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class shippingOption;

class payments_validatedRequestedInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string id_;
  array<object_ptr<shippingOption>> shipping_options_;
  enum Flags : std::int32_t { ID_MASK = 1 };

  payments_validatedRequestedInfo();

  static const std::int32_t ID = -784000893;

  static object_ptr<payments_validatedRequestedInfo> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phone_exportedGroupCallInvite final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;

  static const std::int32_t ID = 541839704;

  static object_ptr<phone_exportedGroupCallInvite> fetch(TlBufferParser &p);

  explicit phone_exportedGroupCallInvite(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class GroupCall;

class User;

class groupCallParticipant;

class phone_groupCall final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<GroupCall> call_;
  array<object_ptr<groupCallParticipant>> participants_;
  string participants_next_offset_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1636664659;

  static object_ptr<phone_groupCall> fetch(TlBufferParser &p);

  explicit phone_groupCall(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallStreamChannel;

class phone_groupCallStreamChannels final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<groupCallStreamChannel>> channels_;

  static const std::int32_t ID = -790330702;

  static object_ptr<phone_groupCallStreamChannels> fetch(TlBufferParser &p);

  explicit phone_groupCallStreamChannels(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phone_groupCallStreamRtmpUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string key_;

  static const std::int32_t ID = 767505458;

  static object_ptr<phone_groupCallStreamRtmpUrl> fetch(TlBufferParser &p);

  explicit phone_groupCallStreamRtmpUrl(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class groupCallParticipant;

class phone_groupParticipants final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<groupCallParticipant>> participants_;
  string next_offset_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  int32 version_;

  phone_groupParticipants(int32 count_, array<object_ptr<groupCallParticipant>> &&participants_, string const &next_offset_, array<object_ptr<Chat>> &&chats_, array<object_ptr<User>> &&users_, int32 version_);

  static const std::int32_t ID = -193506890;

  static object_ptr<phone_groupParticipants> fetch(TlBufferParser &p);

  explicit phone_groupParticipants(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Peer;

class User;

class phone_joinAsPeers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Peer>> peers_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1343921601;

  static object_ptr<phone_joinAsPeers> fetch(TlBufferParser &p);

  explicit phone_joinAsPeers(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PhoneCall;

class User;

class phone_phoneCall final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PhoneCall> phone_call_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -326966976;

  static object_ptr<phone_phoneCall> fetch(TlBufferParser &p);

  explicit phone_phoneCall(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Photo;

class User;

class photos_photo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<Photo> photo_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 539045032;

  static object_ptr<photos_photo> fetch(TlBufferParser &p);

  explicit photos_photo(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Photo;

class User;

class photos_Photos: public Object {
 public:

  static object_ptr<photos_Photos> fetch(TlBufferParser &p);
};

class photos_photos final : public photos_Photos {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Photo>> photos_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1916114267;

  static object_ptr<photos_Photos> fetch(TlBufferParser &p);

  explicit photos_photos(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photos_photosSlice final : public photos_Photos {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<Photo>> photos_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 352657236;

  static object_ptr<photos_Photos> fetch(TlBufferParser &p);

  explicit photos_photosSlice(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class boost;

class premium_boostsList final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 count_;
  array<object_ptr<boost>> boosts_;
  string next_offset_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  premium_boostsList();

  static const std::int32_t ID = -2030542532;

  static object_ptr<premium_boostsList> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PrepaidGiveaway;

class statsPercentValue;

class premium_boostsStatus final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool my_boost_;
  int32 level_;
  int32 current_level_boosts_;
  int32 boosts_;
  int32 gift_boosts_;
  int32 next_level_boosts_;
  object_ptr<statsPercentValue> premium_audience_;
  string boost_url_;
  array<object_ptr<PrepaidGiveaway>> prepaid_giveaways_;
  array<int32> my_boost_slots_;
  enum Flags : std::int32_t { GIFT_BOOSTS_MASK = 16, NEXT_LEVEL_BOOSTS_MASK = 1 };

  premium_boostsStatus();

  static const std::int32_t ID = 1230586490;

  static object_ptr<premium_boostsStatus> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class myBoost;

class premium_myBoosts final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<myBoost>> my_boosts_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -1696454430;

  static object_ptr<premium_myBoosts> fetch(TlBufferParser &p);

  explicit premium_myBoosts(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class smsjobs_eligibleToJoin final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string terms_url_;
  int32 monthly_sent_sms_;

  static const std::int32_t ID = -594852657;

  static object_ptr<smsjobs_eligibleToJoin> fetch(TlBufferParser &p);

  explicit smsjobs_eligibleToJoin(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class smsjobs_status final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool allow_international_;
  int32 recent_sent_;
  int32 recent_since_;
  int32 recent_remains_;
  int32 total_sent_;
  int32 total_since_;
  string last_gift_slug_;
  string terms_url_;
  enum Flags : std::int32_t { LAST_GIFT_SLUG_MASK = 2 };

  smsjobs_status();

  static const std::int32_t ID = 720277905;

  static object_ptr<smsjobs_status> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatsGraph;

class broadcastRevenueBalances;

class stats_broadcastRevenueStats final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StatsGraph> top_hours_graph_;
  object_ptr<StatsGraph> revenue_graph_;
  object_ptr<broadcastRevenueBalances> balances_;
  double usd_rate_;

  static const std::int32_t ID = 1409802903;

  static object_ptr<stats_broadcastRevenueStats> fetch(TlBufferParser &p);

  explicit stats_broadcastRevenueStats(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BroadcastRevenueTransaction;

class stats_broadcastRevenueTransactions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<BroadcastRevenueTransaction>> transactions_;

  static const std::int32_t ID = -2028632986;

  static object_ptr<stats_broadcastRevenueTransactions> fetch(TlBufferParser &p);

  explicit stats_broadcastRevenueTransactions(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stats_broadcastRevenueWithdrawalUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  static const std::int32_t ID = -328886473;

  static object_ptr<stats_broadcastRevenueWithdrawalUrl> fetch(TlBufferParser &p);

  explicit stats_broadcastRevenueWithdrawalUrl(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PostInteractionCounters;

class StatsGraph;

class statsAbsValueAndPrev;

class statsDateRangeDays;

class statsPercentValue;

class stats_broadcastStats final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<statsDateRangeDays> period_;
  object_ptr<statsAbsValueAndPrev> followers_;
  object_ptr<statsAbsValueAndPrev> views_per_post_;
  object_ptr<statsAbsValueAndPrev> shares_per_post_;
  object_ptr<statsAbsValueAndPrev> reactions_per_post_;
  object_ptr<statsAbsValueAndPrev> views_per_story_;
  object_ptr<statsAbsValueAndPrev> shares_per_story_;
  object_ptr<statsAbsValueAndPrev> reactions_per_story_;
  object_ptr<statsPercentValue> enabled_notifications_;
  object_ptr<StatsGraph> growth_graph_;
  object_ptr<StatsGraph> followers_graph_;
  object_ptr<StatsGraph> mute_graph_;
  object_ptr<StatsGraph> top_hours_graph_;
  object_ptr<StatsGraph> interactions_graph_;
  object_ptr<StatsGraph> iv_interactions_graph_;
  object_ptr<StatsGraph> views_by_source_graph_;
  object_ptr<StatsGraph> new_followers_by_source_graph_;
  object_ptr<StatsGraph> languages_graph_;
  object_ptr<StatsGraph> reactions_by_emotion_graph_;
  object_ptr<StatsGraph> story_interactions_graph_;
  object_ptr<StatsGraph> story_reactions_by_emotion_graph_;
  array<object_ptr<PostInteractionCounters>> recent_posts_interactions_;

  static const std::int32_t ID = 963421692;

  static object_ptr<stats_broadcastStats> fetch(TlBufferParser &p);

  explicit stats_broadcastStats(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatsGraph;

class User;

class statsAbsValueAndPrev;

class statsDateRangeDays;

class statsGroupTopAdmin;

class statsGroupTopInviter;

class statsGroupTopPoster;

class stats_megagroupStats final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<statsDateRangeDays> period_;
  object_ptr<statsAbsValueAndPrev> members_;
  object_ptr<statsAbsValueAndPrev> messages_;
  object_ptr<statsAbsValueAndPrev> viewers_;
  object_ptr<statsAbsValueAndPrev> posters_;
  object_ptr<StatsGraph> growth_graph_;
  object_ptr<StatsGraph> members_graph_;
  object_ptr<StatsGraph> new_members_by_source_graph_;
  object_ptr<StatsGraph> languages_graph_;
  object_ptr<StatsGraph> messages_graph_;
  object_ptr<StatsGraph> actions_graph_;
  object_ptr<StatsGraph> top_hours_graph_;
  object_ptr<StatsGraph> weekdays_graph_;
  array<object_ptr<statsGroupTopPoster>> top_posters_;
  array<object_ptr<statsGroupTopAdmin>> top_admins_;
  array<object_ptr<statsGroupTopInviter>> top_inviters_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -276825834;

  static object_ptr<stats_megagroupStats> fetch(TlBufferParser &p);

  explicit stats_megagroupStats(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatsGraph;

class stats_messageStats final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StatsGraph> views_graph_;
  object_ptr<StatsGraph> reactions_by_emotion_graph_;

  static const std::int32_t ID = 2145983508;

  static object_ptr<stats_messageStats> fetch(TlBufferParser &p);

  explicit stats_messageStats(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class PublicForward;

class User;

class stats_publicForwards final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 count_;
  array<object_ptr<PublicForward>> forwards_;
  string next_offset_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  stats_publicForwards();

  static const std::int32_t ID = -1828487648;

  static object_ptr<stats_publicForwards> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatsGraph;

class stats_storyStats final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StatsGraph> views_graph_;
  object_ptr<StatsGraph> reactions_by_emotion_graph_;

  static const std::int32_t ID = 1355613820;

  static object_ptr<stats_storyStats> fetch(TlBufferParser &p);

  explicit stats_storyStats(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers_suggestedShortName final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string short_name_;

  static const std::int32_t ID = -2046910401;

  static object_ptr<stickers_suggestedShortName> fetch(TlBufferParser &p);

  explicit stickers_suggestedShortName(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_FileType: public Object {
 public:

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);
};

class storage_fileUnknown final : public storage_FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1432995067;

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_filePartial final : public storage_FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1086091090;

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_fileJpeg final : public storage_FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 8322574;

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_fileGif final : public storage_FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -891180321;

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_filePng final : public storage_FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 172975040;

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_filePdf final : public storage_FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1373745011;

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_fileMp3 final : public storage_FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1384777335;

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_fileMov final : public storage_FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1258941372;

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_fileMp4 final : public storage_FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1278304028;

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_fileWebp final : public storage_FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 276907596;

  static object_ptr<storage_FileType> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class peerStories;

class storiesStealthMode;

class stories_AllStories: public Object {
 public:

  static object_ptr<stories_AllStories> fetch(TlBufferParser &p);
};

class stories_allStoriesNotModified final : public stories_AllStories {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string state_;
  object_ptr<storiesStealthMode> stealth_mode_;

  stories_allStoriesNotModified();

  static const std::int32_t ID = 291044926;

  static object_ptr<stories_AllStories> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stories_allStories final : public stories_AllStories {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool has_more_;
  int32 count_;
  string state_;
  array<object_ptr<peerStories>> peer_stories_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  object_ptr<storiesStealthMode> stealth_mode_;

  stories_allStories();

  static const std::int32_t ID = 1862033025;

  static object_ptr<stories_AllStories> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class foundStory;

class stories_foundStories final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 count_;
  array<object_ptr<foundStory>> stories_;
  string next_offset_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  stories_foundStories();

  static const std::int32_t ID = -488736969;

  static object_ptr<stories_foundStories> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class peerStories;

class stories_peerStories final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<peerStories> stories_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -890861720;

  static object_ptr<stories_peerStories> fetch(TlBufferParser &p);

  explicit stories_peerStories(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class StoryItem;

class User;

class stories_stories final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 count_;
  array<object_ptr<StoryItem>> stories_;
  array<int32> pinned_to_top_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  stories_stories();

  static const std::int32_t ID = 1673780490;

  static object_ptr<stories_stories> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class StoryReaction;

class User;

class stories_storyReactionsList final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 count_;
  array<object_ptr<StoryReaction>> reactions_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  string next_offset_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  stories_storyReactionsList();

  static const std::int32_t ID = -1436583780;

  static object_ptr<stories_storyReactionsList> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class storyViews;

class stories_storyViews final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<storyViews>> views_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = -560009955;

  static object_ptr<stories_storyViews> fetch(TlBufferParser &p);

  explicit stories_storyViews(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class StoryView;

class User;

class stories_storyViewsList final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 count_;
  int32 views_count_;
  int32 forwards_count_;
  int32 reactions_count_;
  array<object_ptr<StoryView>> views_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  string next_offset_;
  enum Flags : std::int32_t { NEXT_OFFSET_MASK = 1 };

  stories_storyViewsList();

  static const std::int32_t ID = 1507299269;

  static object_ptr<stories_storyViewsList> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class Dialog;

class Message;

class Update;

class User;

class updates_ChannelDifference: public Object {
 public:

  static object_ptr<updates_ChannelDifference> fetch(TlBufferParser &p);
};

class updates_channelDifferenceEmpty final : public updates_ChannelDifference {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool final_;
  int32 pts_;
  int32 timeout_;
  enum Flags : std::int32_t { TIMEOUT_MASK = 2 };

  updates_channelDifferenceEmpty();

  static const std::int32_t ID = 1041346555;

  static object_ptr<updates_ChannelDifference> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updates_channelDifferenceTooLong final : public updates_ChannelDifference {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool final_;
  int32 timeout_;
  object_ptr<Dialog> dialog_;
  array<object_ptr<Message>> messages_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { TIMEOUT_MASK = 2 };

  updates_channelDifferenceTooLong();

  static const std::int32_t ID = -1531132162;

  static object_ptr<updates_ChannelDifference> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updates_channelDifference final : public updates_ChannelDifference {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool final_;
  int32 pts_;
  int32 timeout_;
  array<object_ptr<Message>> new_messages_;
  array<object_ptr<Update>> other_updates_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  enum Flags : std::int32_t { TIMEOUT_MASK = 2 };

  updates_channelDifference();

  static const std::int32_t ID = 543450958;

  static object_ptr<updates_ChannelDifference> fetch(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class EncryptedMessage;

class Message;

class Update;

class User;

class updates_state;

class updates_Difference: public Object {
 public:

  static object_ptr<updates_Difference> fetch(TlBufferParser &p);
};

class updates_differenceEmpty final : public updates_Difference {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 date_;
  int32 seq_;

  static const std::int32_t ID = 1567990072;

  static object_ptr<updates_Difference> fetch(TlBufferParser &p);

  explicit updates_differenceEmpty(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updates_difference final : public updates_Difference {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Message>> new_messages_;
  array<object_ptr<EncryptedMessage>> new_encrypted_messages_;
  array<object_ptr<Update>> other_updates_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  object_ptr<updates_state> state_;

  static const std::int32_t ID = 16030880;

  static object_ptr<updates_Difference> fetch(TlBufferParser &p);

  explicit updates_difference(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updates_differenceSlice final : public updates_Difference {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Message>> new_messages_;
  array<object_ptr<EncryptedMessage>> new_encrypted_messages_;
  array<object_ptr<Update>> other_updates_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;
  object_ptr<updates_state> intermediate_state_;

  updates_differenceSlice(array<object_ptr<Message>> &&new_messages_, array<object_ptr<EncryptedMessage>> &&new_encrypted_messages_, array<object_ptr<Update>> &&other_updates_, array<object_ptr<Chat>> &&chats_, array<object_ptr<User>> &&users_, object_ptr<updates_state> &&intermediate_state_);

  static const std::int32_t ID = -1459938943;

  static object_ptr<updates_Difference> fetch(TlBufferParser &p);

  explicit updates_differenceSlice(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updates_differenceTooLong final : public updates_Difference {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 pts_;

  static const std::int32_t ID = 1258196845;

  static object_ptr<updates_Difference> fetch(TlBufferParser &p);

  explicit updates_differenceTooLong(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updates_state final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 pts_;
  int32 qts_;
  int32 date_;
  int32 seq_;
  int32 unread_count_;

  static const std::int32_t ID = -1519637954;

  static object_ptr<updates_state> fetch(TlBufferParser &p);

  explicit updates_state(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upload_CdnFile: public Object {
 public:

  static object_ptr<upload_CdnFile> fetch(TlBufferParser &p);
};

class upload_cdnFileReuploadNeeded final : public upload_CdnFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes request_token_;

  static const std::int32_t ID = -290921362;

  static object_ptr<upload_CdnFile> fetch(TlBufferParser &p);

  explicit upload_cdnFileReuploadNeeded(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upload_cdnFile final : public upload_CdnFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes bytes_;

  static const std::int32_t ID = -1449145777;

  static object_ptr<upload_CdnFile> fetch(TlBufferParser &p);

  explicit upload_cdnFile(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileHash;

class storage_FileType;

class upload_File: public Object {
 public:

  static object_ptr<upload_File> fetch(TlBufferParser &p);
};

class upload_file final : public upload_File {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<storage_FileType> type_;
  int32 mtime_;
  bytes bytes_;

  static const std::int32_t ID = 157948117;

  static object_ptr<upload_File> fetch(TlBufferParser &p);

  explicit upload_file(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upload_fileCdnRedirect final : public upload_File {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 dc_id_;
  bytes file_token_;
  bytes encryption_key_;
  bytes encryption_iv_;
  array<object_ptr<fileHash>> file_hashes_;

  static const std::int32_t ID = -242427324;

  static object_ptr<upload_File> fetch(TlBufferParser &p);

  explicit upload_fileCdnRedirect(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storage_FileType;

class upload_webFile final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 size_;
  string mime_type_;
  object_ptr<storage_FileType> file_type_;
  int32 mtime_;
  bytes bytes_;

  static const std::int32_t ID = 568808380;

  static object_ptr<upload_webFile> fetch(TlBufferParser &p);

  explicit upload_webFile(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Chat;

class User;

class userFull;

class users_userFull final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<userFull> full_user_;
  array<object_ptr<Chat>> chats_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 997004590;

  static object_ptr<users_userFull> fetch(TlBufferParser &p);

  explicit users_userFull(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class User;

class users_Users: public Object {
 public:

  static object_ptr<users_Users> fetch(TlBufferParser &p);
};

class users_users final : public users_Users {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 1658259128;

  static object_ptr<users_Users> fetch(TlBufferParser &p);

  explicit users_users(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class users_usersSlice final : public users_Users {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;
  array<object_ptr<User>> users_;

  static const std::int32_t ID = 828000628;

  static object_ptr<users_Users> fetch(TlBufferParser &p);

  explicit users_usersSlice(TlBufferParser &p);

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secureCredentialsEncrypted;

class secureValueHash;

class account_acceptAuthorization final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 bot_id_;
  string scope_;
  string public_key_;
  array<object_ptr<secureValueHash>> value_hashes_;
  object_ptr<secureCredentialsEncrypted> credentials_;

  account_acceptAuthorization(int64 bot_id_, string const &scope_, string const &public_key_, array<object_ptr<secureValueHash>> &&value_hashes_, object_ptr<secureCredentialsEncrypted> &&credentials_);

  static const std::int32_t ID = -202552205;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_cancelPasswordEmail final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1043606090;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_changeAuthorizationSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool confirmed_;
  int64 hash_;
  bool encrypted_requests_disabled_;
  bool call_requests_disabled_;
  enum Flags : std::int32_t { CONFIRMED_MASK = 8, ENCRYPTED_REQUESTS_DISABLED_MASK = 1, CALL_REQUESTS_DISABLED_MASK = 2 };
  mutable int32 var0;

  account_changeAuthorizationSettings(int32 flags_, bool confirmed_, int64 hash_, bool encrypted_requests_disabled_, bool call_requests_disabled_);

  static const std::int32_t ID = 1089766498;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class User;

class account_changePhone final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  string phone_code_hash_;
  string phone_code_;

  account_changePhone(string const &phone_number_, string const &phone_code_hash_, string const &phone_code_);

  static const std::int32_t ID = 1891839707;

  using ReturnType = object_ptr<User>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_checkUsername final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string username_;

  explicit account_checkUsername(string const &username_);

  static const std::int32_t ID = 655677548;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_clearRecentEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 404757166;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_confirmPasswordEmail final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  explicit account_confirmPasswordEmail(string const &code_);

  static const std::int32_t ID = -1881204448;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_confirmPhone final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_code_hash_;
  string phone_code_;

  account_confirmPhone(string const &phone_code_hash_, string const &phone_code_);

  static const std::int32_t ID = 1596029123;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class businessChatLink;

class inputBusinessChatLink;

class account_createBusinessChatLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputBusinessChatLink> link_;

  explicit account_createBusinessChatLink(object_ptr<inputBusinessChatLink> &&link_);

  static const std::int32_t ID = -2007898482;

  using ReturnType = object_ptr<businessChatLink>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputDocument;

class inputThemeSettings;

class theme;

class account_createTheme final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string slug_;
  string title_;
  object_ptr<InputDocument> document_;
  array<object_ptr<inputThemeSettings>> settings_;
  enum Flags : std::int32_t { DOCUMENT_MASK = 4, SETTINGS_MASK = 8 };
  mutable int32 var0;

  account_createTheme(int32 flags_, string const &slug_, string const &title_, object_ptr<InputDocument> &&document_, array<object_ptr<inputThemeSettings>> &&settings_);

  static const std::int32_t ID = 1697530880;

  using ReturnType = object_ptr<theme>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_declinePasswordReset final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1284770294;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputCheckPasswordSRP;

class account_deleteAccount final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string reason_;
  object_ptr<InputCheckPasswordSRP> password_;
  enum Flags : std::int32_t { PASSWORD_MASK = 1 };
  mutable int32 var0;

  account_deleteAccount(int32 flags_, string const &reason_, object_ptr<InputCheckPasswordSRP> &&password_);

  static const std::int32_t ID = -1564422284;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_deleteAutoSaveExceptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1404829728;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_deleteBusinessChatLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string slug_;

  explicit account_deleteBusinessChatLink(string const &slug_);

  static const std::int32_t ID = 1611085428;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class SecureValueType;

class account_deleteSecureValue final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<SecureValueType>> types_;

  explicit account_deleteSecureValue(array<object_ptr<SecureValueType>> &&types_);

  static const std::int32_t ID = -1199522741;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class account_disablePeerConnectedBot final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit account_disablePeerConnectedBot(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = 1581481689;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class businessChatLink;

class inputBusinessChatLink;

class account_editBusinessChatLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string slug_;
  object_ptr<inputBusinessChatLink> link_;

  account_editBusinessChatLink(string const &slug_, object_ptr<inputBusinessChatLink> &&link_);

  static const std::int32_t ID = -1942744913;

  using ReturnType = object_ptr<businessChatLink>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_finishTakeoutSession final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool success_;
  enum Flags : std::int32_t { SUCCESS_MASK = 1 };
  mutable int32 var0;

  account_finishTakeoutSession(int32 flags_, bool success_);

  static const std::int32_t ID = 489050862;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class accountDaysTTL;

class account_getAccountTTL final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 150761757;

  using ReturnType = object_ptr<accountDaysTTL>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class secureValue;

class account_getAllSecureValues final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1299661699;

  using ReturnType = array<object_ptr<secureValue>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_authorizationForm;

class account_getAuthorizationForm final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 bot_id_;
  string scope_;
  string public_key_;

  account_getAuthorizationForm(int64 bot_id_, string const &scope_, string const &public_key_);

  static const std::int32_t ID = -1456907910;

  using ReturnType = object_ptr<account_authorizationForm>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_authorizations;

class account_getAuthorizations final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -484392616;

  using ReturnType = object_ptr<account_authorizations>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_autoDownloadSettings;

class account_getAutoDownloadSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1457130303;

  using ReturnType = object_ptr<account_autoDownloadSettings>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_autoSaveSettings;

class account_getAutoSaveSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1379156774;

  using ReturnType = object_ptr<account_autoSaveSettings>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Updates;

class account_getBotBusinessConnection final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string connection_id_;

  explicit account_getBotBusinessConnection(string const &connection_id_);

  static const std::int32_t ID = 1990746736;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_businessChatLinks;

class account_getBusinessChatLinks final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1869667809;

  using ReturnType = object_ptr<account_businessChatLinks>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_EmojiStatuses;

class account_getChannelDefaultEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getChannelDefaultEmojiStatuses(int64 hash_);

  static const std::int32_t ID = 1999087573;

  using ReturnType = object_ptr<account_EmojiStatuses>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EmojiList;

class account_getChannelRestrictedStatusEmojis final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getChannelRestrictedStatusEmojis(int64 hash_);

  static const std::int32_t ID = 900325589;

  using ReturnType = object_ptr<EmojiList>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_Themes;

class account_getChatThemes final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getChatThemes(int64 hash_);

  static const std::int32_t ID = -700916087;

  using ReturnType = object_ptr<account_Themes>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_EmojiStatuses;

class account_getCollectibleEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getCollectibleEmojiStatuses(int64 hash_);

  static const std::int32_t ID = 779830595;

  using ReturnType = object_ptr<account_EmojiStatuses>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_connectedBots;

class account_getConnectedBots final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1319421967;

  using ReturnType = object_ptr<account_connectedBots>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_getContactSignUpNotification final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1626880216;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_contentSettings;

class account_getContentSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1952756306;

  using ReturnType = object_ptr<account_contentSettings>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EmojiList;

class account_getDefaultBackgroundEmojis final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getDefaultBackgroundEmojis(int64 hash_);

  static const std::int32_t ID = -1509246514;

  using ReturnType = object_ptr<EmojiList>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_EmojiStatuses;

class account_getDefaultEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getDefaultEmojiStatuses(int64 hash_);

  static const std::int32_t ID = -696962170;

  using ReturnType = object_ptr<account_EmojiStatuses>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EmojiList;

class account_getDefaultGroupPhotoEmojis final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getDefaultGroupPhotoEmojis(int64 hash_);

  static const std::int32_t ID = -1856479058;

  using ReturnType = object_ptr<EmojiList>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EmojiList;

class account_getDefaultProfilePhotoEmojis final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getDefaultProfilePhotoEmojis(int64 hash_);

  static const std::int32_t ID = -495647960;

  using ReturnType = object_ptr<EmojiList>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class globalPrivacySettings;

class account_getGlobalPrivacySettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -349483786;

  using ReturnType = object_ptr<globalPrivacySettings>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputWallPaper;

class WallPaper;

class account_getMultiWallPapers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<InputWallPaper>> wallpapers_;

  explicit account_getMultiWallPapers(array<object_ptr<InputWallPaper>> &&wallpapers_);

  static const std::int32_t ID = 1705865692;

  using ReturnType = array<object_ptr<WallPaper>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputNotifyPeer;

class Updates;

class account_getNotifyExceptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool compare_sound_;
  bool compare_stories_;
  object_ptr<InputNotifyPeer> peer_;
  enum Flags : std::int32_t { COMPARE_SOUND_MASK = 2, COMPARE_STORIES_MASK = 4, PEER_MASK = 1 };
  mutable int32 var0;

  account_getNotifyExceptions(int32 flags_, bool compare_sound_, bool compare_stories_, object_ptr<InputNotifyPeer> &&peer_);

  static const std::int32_t ID = 1398240377;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputNotifyPeer;

class peerNotifySettings;

class account_getNotifySettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputNotifyPeer> peer_;

  explicit account_getNotifySettings(object_ptr<InputNotifyPeer> &&peer_);

  static const std::int32_t ID = 313765169;

  using ReturnType = object_ptr<peerNotifySettings>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_password;

class account_getPassword final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1418342645;

  using ReturnType = object_ptr<account_password>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputCheckPasswordSRP;

class account_passwordSettings;

class account_getPasswordSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputCheckPasswordSRP> password_;

  explicit account_getPasswordSettings(object_ptr<InputCheckPasswordSRP> &&password_);

  static const std::int32_t ID = -1663767815;

  using ReturnType = object_ptr<account_passwordSettings>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPrivacyKey;

class account_privacyRules;

class account_getPrivacy final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPrivacyKey> key_;

  explicit account_getPrivacy(object_ptr<InputPrivacyKey> &&key_);

  static const std::int32_t ID = -623130288;

  using ReturnType = object_ptr<account_privacyRules>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class reactionsNotifySettings;

class account_getReactionsNotifySettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 115172684;

  using ReturnType = object_ptr<reactionsNotifySettings>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_EmojiStatuses;

class account_getRecentEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getRecentEmojiStatuses(int64 hash_);

  static const std::int32_t ID = 257392901;

  using ReturnType = object_ptr<account_EmojiStatuses>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_SavedRingtones;

class account_getSavedRingtones final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getSavedRingtones(int64 hash_);

  static const std::int32_t ID = -510647672;

  using ReturnType = object_ptr<account_SavedRingtones>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class SecureValueType;

class secureValue;

class account_getSecureValue final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<SecureValueType>> types_;

  explicit account_getSecureValue(array<object_ptr<SecureValueType>> &&types_);

  static const std::int32_t ID = 1936088002;

  using ReturnType = array<object_ptr<secureValue>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputTheme;

class theme;

class account_getTheme final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string format_;
  object_ptr<InputTheme> theme_;

  account_getTheme(string const &format_, object_ptr<InputTheme> &&theme_);

  static const std::int32_t ID = 978872812;

  using ReturnType = object_ptr<theme>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_Themes;

class account_getThemes final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string format_;
  int64 hash_;

  account_getThemes(string const &format_, int64 hash_);

  static const std::int32_t ID = 1913054296;

  using ReturnType = object_ptr<account_Themes>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputCheckPasswordSRP;

class account_tmpPassword;

class account_getTmpPassword final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputCheckPasswordSRP> password_;
  int32 period_;

  account_getTmpPassword(object_ptr<InputCheckPasswordSRP> &&password_, int32 period_);

  static const std::int32_t ID = 1151208273;

  using ReturnType = object_ptr<account_tmpPassword>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputWallPaper;

class WallPaper;

class account_getWallPaper final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputWallPaper> wallpaper_;

  explicit account_getWallPaper(object_ptr<InputWallPaper> &&wallpaper_);

  static const std::int32_t ID = -57811990;

  using ReturnType = object_ptr<WallPaper>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_WallPapers;

class account_getWallPapers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_getWallPapers(int64 hash_);

  static const std::int32_t ID = 127302966;

  using ReturnType = object_ptr<account_WallPapers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_webAuthorizations;

class account_getWebAuthorizations final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 405695855;

  using ReturnType = object_ptr<account_webAuthorizations>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_takeout;

class account_initTakeoutSession final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool contacts_;
  bool message_users_;
  bool message_chats_;
  bool message_megagroups_;
  bool message_channels_;
  bool files_;
  int64 file_max_size_;
  enum Flags : std::int32_t { CONTACTS_MASK = 1, MESSAGE_USERS_MASK = 2, MESSAGE_CHATS_MASK = 4, MESSAGE_MEGAGROUPS_MASK = 8, MESSAGE_CHANNELS_MASK = 16, FILES_MASK = 32, FILE_MAX_SIZE_MASK = 32 };
  mutable int32 var0;

  account_initTakeoutSession(int32 flags_, bool contacts_, bool message_users_, bool message_chats_, bool message_megagroups_, bool message_channels_, bool files_, int64 file_max_size_);

  static const std::int32_t ID = -1896617296;

  using ReturnType = object_ptr<account_takeout>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class BaseTheme;

class InputTheme;

class account_installTheme final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool dark_;
  object_ptr<InputTheme> theme_;
  string format_;
  object_ptr<BaseTheme> base_theme_;
  enum Flags : std::int32_t { DARK_MASK = 1, THEME_MASK = 2, FORMAT_MASK = 4, BASE_THEME_MASK = 8 };
  mutable int32 var0;

  account_installTheme(int32 flags_, bool dark_, object_ptr<InputTheme> &&theme_, string const &format_, object_ptr<BaseTheme> &&base_theme_);

  static const std::int32_t ID = -953697477;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputWallPaper;

class wallPaperSettings;

class account_installWallPaper final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputWallPaper> wallpaper_;
  object_ptr<wallPaperSettings> settings_;

  account_installWallPaper(object_ptr<InputWallPaper> &&wallpaper_, object_ptr<wallPaperSettings> &&settings_);

  static const std::int32_t ID = -18000023;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_invalidateSignInCodes final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> codes_;

  explicit account_invalidateSignInCodes(array<string> &&codes_);

  static const std::int32_t ID = -896866118;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_registerDevice final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool no_muted_;
  int32 token_type_;
  string token_;
  bool app_sandbox_;
  bytes secret_;
  array<int64> other_uids_;
  enum Flags : std::int32_t { NO_MUTED_MASK = 1 };
  mutable int32 var0;

  account_registerDevice(int32 flags_, bool no_muted_, int32 token_type_, string const &token_, bool app_sandbox_, bytes &&secret_, array<int64> &&other_uids_);

  static const std::int32_t ID = -326762118;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_reorderUsernames final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> order_;

  explicit account_reorderUsernames(array<string> &&order_);

  static const std::int32_t ID = -279966037;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class ReportReason;

class account_reportPeer final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  object_ptr<ReportReason> reason_;
  string message_;

  account_reportPeer(object_ptr<InputPeer> &&peer_, object_ptr<ReportReason> &&reason_, string const &message_);

  static const std::int32_t ID = -977650298;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class InputPhoto;

class ReportReason;

class account_reportProfilePhoto final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  object_ptr<InputPhoto> photo_id_;
  object_ptr<ReportReason> reason_;
  string message_;

  account_reportProfilePhoto(object_ptr<InputPeer> &&peer_, object_ptr<InputPhoto> &&photo_id_, object_ptr<ReportReason> &&reason_, string const &message_);

  static const std::int32_t ID = -91437323;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_resendPasswordEmail final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2055154197;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_resetAuthorization final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_resetAuthorization(int64 hash_);

  static const std::int32_t ID = -545786948;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_resetNotifySettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -612493497;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_ResetPasswordResult;

class account_resetPassword final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1828139493;

  using ReturnType = object_ptr<account_ResetPasswordResult>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_resetWallPapers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1153722364;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_resetWebAuthorization final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit account_resetWebAuthorization(int64 hash_);

  static const std::int32_t ID = 755087855;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_resetWebAuthorizations final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1747789204;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_resolvedBusinessChatLinks;

class account_resolveBusinessChatLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string slug_;

  explicit account_resolveBusinessChatLink(string const &slug_);

  static const std::int32_t ID = 1418913262;

  using ReturnType = object_ptr<account_resolvedBusinessChatLinks>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class autoDownloadSettings;

class account_saveAutoDownloadSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool low_;
  bool high_;
  object_ptr<autoDownloadSettings> settings_;
  enum Flags : std::int32_t { LOW_MASK = 1, HIGH_MASK = 2 };
  mutable int32 var0;

  account_saveAutoDownloadSettings(int32 flags_, bool low_, bool high_, object_ptr<autoDownloadSettings> &&settings_);

  static const std::int32_t ID = 1995661875;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class autoSaveSettings;

class account_saveAutoSaveSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool users_;
  bool chats_;
  bool broadcasts_;
  object_ptr<InputPeer> peer_;
  object_ptr<autoSaveSettings> settings_;
  enum Flags : std::int32_t { USERS_MASK = 1, CHATS_MASK = 2, BROADCASTS_MASK = 4, PEER_MASK = 8 };
  mutable int32 var0;

  account_saveAutoSaveSettings(int32 flags_, bool users_, bool chats_, bool broadcasts_, object_ptr<InputPeer> &&peer_, object_ptr<autoSaveSettings> &&settings_);

  static const std::int32_t ID = -694451359;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputDocument;

class account_SavedRingtone;

class account_saveRingtone final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputDocument> id_;
  bool unsave_;

  account_saveRingtone(object_ptr<InputDocument> &&id_, bool unsave_);

  static const std::int32_t ID = 1038768899;

  using ReturnType = object_ptr<account_SavedRingtone>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class inputSecureValue;

class secureValue;

class account_saveSecureValue final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputSecureValue> value_;
  int64 secure_secret_id_;

  account_saveSecureValue(object_ptr<inputSecureValue> &&value_, int64 secure_secret_id_);

  static const std::int32_t ID = -1986010339;

  using ReturnType = object_ptr<secureValue>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputTheme;

class account_saveTheme final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputTheme> theme_;
  bool unsave_;

  account_saveTheme(object_ptr<InputTheme> &&theme_, bool unsave_);

  static const std::int32_t ID = -229175188;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputWallPaper;

class wallPaperSettings;

class account_saveWallPaper final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputWallPaper> wallpaper_;
  bool unsave_;
  object_ptr<wallPaperSettings> settings_;

  account_saveWallPaper(object_ptr<InputWallPaper> &&wallpaper_, bool unsave_, object_ptr<wallPaperSettings> &&settings_);

  static const std::int32_t ID = 1817860919;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_SentCode;

class codeSettings;

class account_sendChangePhoneCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  object_ptr<codeSettings> settings_;

  account_sendChangePhoneCode(string const &phone_number_, object_ptr<codeSettings> &&settings_);

  static const std::int32_t ID = -2108208411;

  using ReturnType = object_ptr<auth_SentCode>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_SentCode;

class codeSettings;

class account_sendConfirmPhoneCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string hash_;
  object_ptr<codeSettings> settings_;

  account_sendConfirmPhoneCode(string const &hash_, object_ptr<codeSettings> &&settings_);

  static const std::int32_t ID = 457157256;

  using ReturnType = object_ptr<auth_SentCode>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EmailVerifyPurpose;

class account_sentEmailCode;

class account_sendVerifyEmailCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<EmailVerifyPurpose> purpose_;
  string email_;

  account_sendVerifyEmailCode(object_ptr<EmailVerifyPurpose> &&purpose_, string const &email_);

  static const std::int32_t ID = -1730136133;

  using ReturnType = object_ptr<account_sentEmailCode>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_SentCode;

class codeSettings;

class account_sendVerifyPhoneCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  object_ptr<codeSettings> settings_;

  account_sendVerifyPhoneCode(string const &phone_number_, object_ptr<codeSettings> &&settings_);

  static const std::int32_t ID = -1516022023;

  using ReturnType = object_ptr<auth_SentCode>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class accountDaysTTL;

class account_setAccountTTL final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<accountDaysTTL> ttl_;

  explicit account_setAccountTTL(object_ptr<accountDaysTTL> &&ttl_);

  static const std::int32_t ID = 608323678;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_setAuthorizationTTL final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 authorization_ttl_days_;

  explicit account_setAuthorizationTTL(int32 authorization_ttl_days_);

  static const std::int32_t ID = -1081501024;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_setContactSignUpNotification final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool silent_;

  explicit account_setContactSignUpNotification(bool silent_);

  static const std::int32_t ID = -806076575;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_setContentSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool sensitive_enabled_;
  enum Flags : std::int32_t { SENSITIVE_ENABLED_MASK = 1 };
  mutable int32 var0;

  account_setContentSettings(int32 flags_, bool sensitive_enabled_);

  static const std::int32_t ID = -1250643605;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class globalPrivacySettings;

class account_setGlobalPrivacySettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<globalPrivacySettings> settings_;

  explicit account_setGlobalPrivacySettings(object_ptr<globalPrivacySettings> &&settings_);

  static const std::int32_t ID = 517647042;

  using ReturnType = object_ptr<globalPrivacySettings>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPrivacyKey;

class InputPrivacyRule;

class account_privacyRules;

class account_setPrivacy final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPrivacyKey> key_;
  array<object_ptr<InputPrivacyRule>> rules_;

  account_setPrivacy(object_ptr<InputPrivacyKey> &&key_, array<object_ptr<InputPrivacyRule>> &&rules_);

  static const std::int32_t ID = -906486552;

  using ReturnType = object_ptr<account_privacyRules>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class reactionsNotifySettings;

class account_setReactionsNotifySettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<reactionsNotifySettings> settings_;

  explicit account_setReactionsNotifySettings(object_ptr<reactionsNotifySettings> &&settings_);

  static const std::int32_t ID = 829220168;

  using ReturnType = object_ptr<reactionsNotifySettings>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class account_toggleConnectedBotPaused final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  bool paused_;

  account_toggleConnectedBotPaused(object_ptr<InputPeer> &&peer_, bool paused_);

  static const std::int32_t ID = 1684934807;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_toggleSponsoredMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool enabled_;

  explicit account_toggleSponsoredMessages(bool enabled_);

  static const std::int32_t ID = -1176919155;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_toggleUsername final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string username_;
  bool active_;

  account_toggleUsername(string const &username_, bool active_);

  static const std::int32_t ID = 1490465654;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_unregisterDevice final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 token_type_;
  string token_;
  array<int64> other_uids_;

  account_unregisterDevice(int32 token_type_, string const &token_, array<int64> &&other_uids_);

  static const std::int32_t ID = 1779249670;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class birthday;

class account_updateBirthday final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<birthday> birthday_;
  enum Flags : std::int32_t { BIRTHDAY_MASK = 1 };
  mutable int32 var0;

  account_updateBirthday(int32 flags_, object_ptr<birthday> &&birthday_);

  static const std::int32_t ID = -865203183;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class inputBusinessAwayMessage;

class account_updateBusinessAwayMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<inputBusinessAwayMessage> message_;
  enum Flags : std::int32_t { MESSAGE_MASK = 1 };
  mutable int32 var0;

  account_updateBusinessAwayMessage(int32 flags_, object_ptr<inputBusinessAwayMessage> &&message_);

  static const std::int32_t ID = -1570078811;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class inputBusinessGreetingMessage;

class account_updateBusinessGreetingMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<inputBusinessGreetingMessage> message_;
  enum Flags : std::int32_t { MESSAGE_MASK = 1 };
  mutable int32 var0;

  account_updateBusinessGreetingMessage(int32 flags_, object_ptr<inputBusinessGreetingMessage> &&message_);

  static const std::int32_t ID = 1724755908;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class inputBusinessIntro;

class account_updateBusinessIntro final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<inputBusinessIntro> intro_;
  enum Flags : std::int32_t { INTRO_MASK = 1 };
  mutable int32 var0;

  account_updateBusinessIntro(int32 flags_, object_ptr<inputBusinessIntro> &&intro_);

  static const std::int32_t ID = -1508585420;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputGeoPoint;

class account_updateBusinessLocation final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputGeoPoint> geo_point_;
  string address_;
  enum Flags : std::int32_t { GEO_POINT_MASK = 2, ADDRESS_MASK = 1 };
  mutable int32 var0;

  account_updateBusinessLocation(int32 flags_, object_ptr<InputGeoPoint> &&geo_point_, string const &address_);

  static const std::int32_t ID = -1637149926;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class businessWorkHours;

class account_updateBusinessWorkHours final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<businessWorkHours> business_work_hours_;
  enum Flags : std::int32_t { BUSINESS_WORK_HOURS_MASK = 1 };
  mutable int32 var0;

  account_updateBusinessWorkHours(int32 flags_, object_ptr<businessWorkHours> &&business_work_hours_);

  static const std::int32_t ID = 1258348646;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_updateColor final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool for_profile_;
  int32 color_;
  int64 background_emoji_id_;
  enum Flags : std::int32_t { FOR_PROFILE_MASK = 2, COLOR_MASK = 4, BACKGROUND_EMOJI_ID_MASK = 1 };
  mutable int32 var0;

  account_updateColor(int32 flags_, bool for_profile_, int32 color_, int64 background_emoji_id_);

  static const std::int32_t ID = 2096079197;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class Updates;

class inputBusinessBotRecipients;

class account_updateConnectedBot final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool can_reply_;
  bool deleted_;
  object_ptr<InputUser> bot_;
  object_ptr<inputBusinessBotRecipients> recipients_;
  enum Flags : std::int32_t { CAN_REPLY_MASK = 1, DELETED_MASK = 2 };
  mutable int32 var0;

  account_updateConnectedBot(int32 flags_, bool can_reply_, bool deleted_, object_ptr<InputUser> &&bot_, object_ptr<inputBusinessBotRecipients> &&recipients_);

  static const std::int32_t ID = 1138250269;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_updateDeviceLocked final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 period_;

  explicit account_updateDeviceLocked(int32 period_);

  static const std::int32_t ID = 954152242;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EmojiStatus;

class account_updateEmojiStatus final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<EmojiStatus> emoji_status_;

  explicit account_updateEmojiStatus(object_ptr<EmojiStatus> &&emoji_status_);

  static const std::int32_t ID = -70001045;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputNotifyPeer;

class inputPeerNotifySettings;

class account_updateNotifySettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputNotifyPeer> peer_;
  object_ptr<inputPeerNotifySettings> settings_;

  account_updateNotifySettings(object_ptr<InputNotifyPeer> &&peer_, object_ptr<inputPeerNotifySettings> &&settings_);

  static const std::int32_t ID = -2067899501;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputCheckPasswordSRP;

class account_passwordInputSettings;

class account_updatePasswordSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputCheckPasswordSRP> password_;
  object_ptr<account_passwordInputSettings> new_settings_;

  account_updatePasswordSettings(object_ptr<InputCheckPasswordSRP> &&password_, object_ptr<account_passwordInputSettings> &&new_settings_);

  static const std::int32_t ID = -1516564433;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class account_updatePersonalChannel final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;

  explicit account_updatePersonalChannel(object_ptr<InputChannel> &&channel_);

  static const std::int32_t ID = -649919008;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class User;

class account_updateProfile final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string first_name_;
  string last_name_;
  string about_;
  enum Flags : std::int32_t { FIRST_NAME_MASK = 1, LAST_NAME_MASK = 2, ABOUT_MASK = 4 };
  mutable int32 var0;

  account_updateProfile(int32 flags_, string const &first_name_, string const &last_name_, string const &about_);

  static const std::int32_t ID = 2018596725;

  using ReturnType = object_ptr<User>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_updateStatus final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool offline_;

  explicit account_updateStatus(bool offline_);

  static const std::int32_t ID = 1713919532;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputDocument;

class InputTheme;

class inputThemeSettings;

class theme;

class account_updateTheme final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string format_;
  object_ptr<InputTheme> theme_;
  string slug_;
  string title_;
  object_ptr<InputDocument> document_;
  array<object_ptr<inputThemeSettings>> settings_;
  enum Flags : std::int32_t { SLUG_MASK = 1, TITLE_MASK = 2, DOCUMENT_MASK = 4, SETTINGS_MASK = 8 };
  mutable int32 var0;

  account_updateTheme(int32 flags_, string const &format_, object_ptr<InputTheme> &&theme_, string const &slug_, string const &title_, object_ptr<InputDocument> &&document_, array<object_ptr<inputThemeSettings>> &&settings_);

  static const std::int32_t ID = 737414348;

  using ReturnType = object_ptr<theme>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class User;

class account_updateUsername final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string username_;

  explicit account_updateUsername(string const &username_);

  static const std::int32_t ID = 1040964988;

  using ReturnType = object_ptr<User>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Document;

class InputFile;

class account_uploadRingtone final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> file_;
  string file_name_;
  string mime_type_;

  account_uploadRingtone(object_ptr<InputFile> &&file_, string const &file_name_, string const &mime_type_);

  static const std::int32_t ID = -2095414366;

  using ReturnType = object_ptr<Document>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Document;

class InputFile;

class account_uploadTheme final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputFile> file_;
  object_ptr<InputFile> thumb_;
  string file_name_;
  string mime_type_;
  enum Flags : std::int32_t { THUMB_MASK = 1 };
  mutable int32 var0;

  account_uploadTheme(int32 flags_, object_ptr<InputFile> &&file_, object_ptr<InputFile> &&thumb_, string const &file_name_, string const &mime_type_);

  static const std::int32_t ID = 473805619;

  using ReturnType = object_ptr<Document>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputFile;

class WallPaper;

class wallPaperSettings;

class account_uploadWallPaper final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool for_chat_;
  object_ptr<InputFile> file_;
  string mime_type_;
  object_ptr<wallPaperSettings> settings_;
  enum Flags : std::int32_t { FOR_CHAT_MASK = 1 };
  mutable int32 var0;

  account_uploadWallPaper(int32 flags_, bool for_chat_, object_ptr<InputFile> &&file_, string const &mime_type_, object_ptr<wallPaperSettings> &&settings_);

  static const std::int32_t ID = -476410109;

  using ReturnType = object_ptr<WallPaper>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EmailVerification;

class EmailVerifyPurpose;

class account_EmailVerified;

class account_verifyEmail final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<EmailVerifyPurpose> purpose_;
  object_ptr<EmailVerification> verification_;

  account_verifyEmail(object_ptr<EmailVerifyPurpose> &&purpose_, object_ptr<EmailVerification> &&verification_);

  static const std::int32_t ID = 53322959;

  using ReturnType = object_ptr<account_EmailVerified>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_verifyPhone final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  string phone_code_hash_;
  string phone_code_;

  account_verifyPhone(string const &phone_number_, string const &phone_code_hash_, string const &phone_code_);

  static const std::int32_t ID = 1305716726;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class authorization;

class auth_acceptLoginToken final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes token_;

  explicit auth_acceptLoginToken(bytes &&token_);

  static const std::int32_t ID = -392909491;

  using ReturnType = object_ptr<authorization>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_bindTempAuthKey final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 perm_auth_key_id_;
  int64 nonce_;
  int32 expires_at_;
  bytes encrypted_message_;

  auth_bindTempAuthKey(int64 perm_auth_key_id_, int64 nonce_, int32 expires_at_, bytes &&encrypted_message_);

  static const std::int32_t ID = -841733627;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_cancelCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  string phone_code_hash_;

  auth_cancelCode(string const &phone_number_, string const &phone_code_hash_);

  static const std::int32_t ID = 520357240;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputCheckPasswordSRP;

class auth_Authorization;

class auth_checkPassword final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputCheckPasswordSRP> password_;

  explicit auth_checkPassword(object_ptr<InputCheckPasswordSRP> &&password_);

  static const std::int32_t ID = -779399914;

  using ReturnType = object_ptr<auth_Authorization>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_checkRecoveryPassword final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  explicit auth_checkRecoveryPassword(string const &code_);

  static const std::int32_t ID = 221691769;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_dropTempAuthKeys final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> except_auth_keys_;

  explicit auth_dropTempAuthKeys(array<int64> &&except_auth_keys_);

  static const std::int32_t ID = -1907842680;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_exportedAuthorization;

class auth_exportAuthorization final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 dc_id_;

  explicit auth_exportAuthorization(int32 dc_id_);

  static const std::int32_t ID = -440401971;

  using ReturnType = object_ptr<auth_exportedAuthorization>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_LoginToken;

class auth_exportLoginToken final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 api_id_;
  string api_hash_;
  array<int64> except_ids_;

  auth_exportLoginToken(int32 api_id_, string const &api_hash_, array<int64> &&except_ids_);

  static const std::int32_t ID = -1210022402;

  using ReturnType = object_ptr<auth_LoginToken>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_Authorization;

class auth_importAuthorization final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  bytes bytes_;

  auth_importAuthorization(int64 id_, bytes &&bytes_);

  static const std::int32_t ID = -1518699091;

  using ReturnType = object_ptr<auth_Authorization>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_Authorization;

class auth_importBotAuthorization final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 api_id_;
  string api_hash_;
  string bot_auth_token_;

  auth_importBotAuthorization(int32 flags_, int32 api_id_, string const &api_hash_, string const &bot_auth_token_);

  static const std::int32_t ID = 1738800940;

  using ReturnType = object_ptr<auth_Authorization>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_LoginToken;

class auth_importLoginToken final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes token_;

  explicit auth_importLoginToken(bytes &&token_);

  static const std::int32_t ID = -1783866140;

  using ReturnType = object_ptr<auth_LoginToken>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_Authorization;

class auth_importWebTokenAuthorization final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 api_id_;
  string api_hash_;
  string web_auth_token_;

  auth_importWebTokenAuthorization(int32 api_id_, string const &api_hash_, string const &web_auth_token_);

  static const std::int32_t ID = 767062953;

  using ReturnType = object_ptr<auth_Authorization>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_loggedOut;

class auth_logOut final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1047706137;

  using ReturnType = object_ptr<auth_loggedOut>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class account_passwordInputSettings;

class auth_Authorization;

class auth_recoverPassword final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string code_;
  object_ptr<account_passwordInputSettings> new_settings_;
  enum Flags : std::int32_t { NEW_SETTINGS_MASK = 1 };
  mutable int32 var0;

  auth_recoverPassword(int32 flags_, string const &code_, object_ptr<account_passwordInputSettings> &&new_settings_);

  static const std::int32_t ID = 923364464;

  using ReturnType = object_ptr<auth_Authorization>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_reportMissingCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  string phone_code_hash_;
  string mnc_;

  auth_reportMissingCode(string const &phone_number_, string const &phone_code_hash_, string const &mnc_);

  static const std::int32_t ID = -878841866;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_requestFirebaseSms final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string phone_number_;
  string phone_code_hash_;
  string safety_net_token_;
  string play_integrity_token_;
  string ios_push_secret_;
  enum Flags : std::int32_t { SAFETY_NET_TOKEN_MASK = 1, PLAY_INTEGRITY_TOKEN_MASK = 4, IOS_PUSH_SECRET_MASK = 2 };
  mutable int32 var0;

  auth_requestFirebaseSms(int32 flags_, string const &phone_number_, string const &phone_code_hash_, string const &safety_net_token_, string const &play_integrity_token_, string const &ios_push_secret_);

  static const std::int32_t ID = -1908857314;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_passwordRecovery;

class auth_requestPasswordRecovery final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -661144474;

  using ReturnType = object_ptr<auth_passwordRecovery>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_SentCode;

class auth_resendCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string phone_number_;
  string phone_code_hash_;
  string reason_;
  enum Flags : std::int32_t { REASON_MASK = 1 };
  mutable int32 var0;

  auth_resendCode(int32 flags_, string const &phone_number_, string const &phone_code_hash_, string const &reason_);

  static const std::int32_t ID = -890997469;

  using ReturnType = object_ptr<auth_SentCode>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_resetAuthorizations final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1616179942;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_SentCode;

class auth_resetLoginEmail final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  string phone_code_hash_;

  auth_resetLoginEmail(string const &phone_number_, string const &phone_code_hash_);

  static const std::int32_t ID = 2123760019;

  using ReturnType = object_ptr<auth_SentCode>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_SentCode;

class codeSettings;

class auth_sendCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  int32 api_id_;
  string api_hash_;
  object_ptr<codeSettings> settings_;

  auth_sendCode(string const &phone_number_, int32 api_id_, string const &api_hash_, object_ptr<codeSettings> &&settings_);

  static const std::int32_t ID = -1502141361;

  using ReturnType = object_ptr<auth_SentCode>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EmailVerification;

class auth_Authorization;

class auth_signIn final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string phone_number_;
  string phone_code_hash_;
  string phone_code_;
  object_ptr<EmailVerification> email_verification_;
  enum Flags : std::int32_t { PHONE_CODE_MASK = 1, EMAIL_VERIFICATION_MASK = 2 };
  mutable int32 var0;

  auth_signIn(int32 flags_, string const &phone_number_, string const &phone_code_hash_, string const &phone_code_, object_ptr<EmailVerification> &&email_verification_);

  static const std::int32_t ID = -1923962543;

  using ReturnType = object_ptr<auth_Authorization>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class auth_Authorization;

class auth_signUp final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool no_joined_notifications_;
  string phone_number_;
  string phone_code_hash_;
  string first_name_;
  string last_name_;
  enum Flags : std::int32_t { NO_JOINED_NOTIFICATIONS_MASK = 1 };
  mutable int32 var0;

  auth_signUp(int32 flags_, bool no_joined_notifications_, string const &phone_number_, string const &phone_code_hash_, string const &first_name_, string const &last_name_);

  static const std::int32_t ID = -1429752041;

  using ReturnType = object_ptr<auth_Authorization>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputMedia;

class InputUser;

class botPreviewMedia;

class bots_addPreviewMedia final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  string lang_code_;
  object_ptr<InputMedia> media_;

  bots_addPreviewMedia(object_ptr<InputUser> &&bot_, string const &lang_code_, object_ptr<InputMedia> &&media_);

  static const std::int32_t ID = 397326170;

  using ReturnType = object_ptr<botPreviewMedia>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class Updates;

class bots_allowSendMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;

  explicit bots_allowSendMessage(object_ptr<InputUser> &&bot_);

  static const std::int32_t ID = -248323089;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class dataJSON;

class bots_answerWebhookJSONQuery final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 query_id_;
  object_ptr<dataJSON> data_;

  bots_answerWebhookJSONQuery(int64 query_id_, object_ptr<dataJSON> &&data_);

  static const std::int32_t ID = -434028723;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class bots_canSendMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;

  explicit bots_canSendMessage(object_ptr<InputUser> &&bot_);

  static const std::int32_t ID = 324662502;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class bots_checkDownloadFileParams final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  string file_name_;
  string url_;

  bots_checkDownloadFileParams(object_ptr<InputUser> &&bot_, string const &file_name_, string const &url_);

  static const std::int32_t ID = 1342666121;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputMedia;

class InputUser;

class bots_deletePreviewMedia final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  string lang_code_;
  array<object_ptr<InputMedia>> media_;

  bots_deletePreviewMedia(object_ptr<InputUser> &&bot_, string const &lang_code_, array<object_ptr<InputMedia>> &&media_);

  static const std::int32_t ID = 755054003;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputMedia;

class InputUser;

class botPreviewMedia;

class bots_editPreviewMedia final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  string lang_code_;
  object_ptr<InputMedia> media_;
  object_ptr<InputMedia> new_media_;

  bots_editPreviewMedia(object_ptr<InputUser> &&bot_, string const &lang_code_, object_ptr<InputMedia> &&media_, object_ptr<InputMedia> &&new_media_);

  static const std::int32_t ID = -2061148049;

  using ReturnType = object_ptr<botPreviewMedia>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class User;

class bots_getAdminedBots final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1334764157;

  using ReturnType = array<object_ptr<User>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class BotCommandScope;

class botCommand;

class bots_getBotCommands final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BotCommandScope> scope_;
  string lang_code_;

  bots_getBotCommands(object_ptr<BotCommandScope> &&scope_, string const &lang_code_);

  static const std::int32_t ID = -481554986;

  using ReturnType = array<object_ptr<botCommand>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class bots_botInfo;

class bots_getBotInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputUser> bot_;
  string lang_code_;
  enum Flags : std::int32_t { BOT_MASK = 1 };
  mutable int32 var0;

  bots_getBotInfo(int32 flags_, object_ptr<InputUser> &&bot_, string const &lang_code_);

  static const std::int32_t ID = -589753091;

  using ReturnType = object_ptr<bots_botInfo>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class BotMenuButton;

class InputUser;

class bots_getBotMenuButton final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> user_id_;

  explicit bots_getBotMenuButton(object_ptr<InputUser> &&user_id_);

  static const std::int32_t ID = -1671369944;

  using ReturnType = object_ptr<BotMenuButton>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class users_Users;

class bots_getBotRecommendations final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;

  explicit bots_getBotRecommendations(object_ptr<InputUser> &&bot_);

  static const std::int32_t ID = -1581840363;

  using ReturnType = object_ptr<users_Users>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class bots_popularAppBots;

class bots_getPopularAppBots final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string offset_;
  int32 limit_;

  bots_getPopularAppBots(string const &offset_, int32 limit_);

  static const std::int32_t ID = -1034878574;

  using ReturnType = object_ptr<bots_popularAppBots>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class bots_previewInfo;

class bots_getPreviewInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  string lang_code_;

  bots_getPreviewInfo(object_ptr<InputUser> &&bot_, string const &lang_code_);

  static const std::int32_t ID = 1111143341;

  using ReturnType = object_ptr<bots_previewInfo>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class botPreviewMedia;

class bots_getPreviewMedias final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;

  explicit bots_getPreviewMedias(object_ptr<InputUser> &&bot_);

  static const std::int32_t ID = -1566222003;

  using ReturnType = array<object_ptr<botPreviewMedia>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class dataJSON;

class bots_invokeWebViewCustomMethod final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  string custom_method_;
  object_ptr<dataJSON> params_;

  bots_invokeWebViewCustomMethod(object_ptr<InputUser> &&bot_, string const &custom_method_, object_ptr<dataJSON> &&params_);

  static const std::int32_t ID = 142591463;

  using ReturnType = object_ptr<dataJSON>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputMedia;

class InputUser;

class bots_reorderPreviewMedias final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  string lang_code_;
  array<object_ptr<InputMedia>> order_;

  bots_reorderPreviewMedias(object_ptr<InputUser> &&bot_, string const &lang_code_, array<object_ptr<InputMedia>> &&order_);

  static const std::int32_t ID = -1238895702;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class bots_reorderUsernames final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  array<string> order_;

  bots_reorderUsernames(object_ptr<InputUser> &&bot_, array<string> &&order_);

  static const std::int32_t ID = -1760972350;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class BotCommandScope;

class bots_resetBotCommands final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BotCommandScope> scope_;
  string lang_code_;

  bots_resetBotCommands(object_ptr<BotCommandScope> &&scope_, string const &lang_code_);

  static const std::int32_t ID = 1032708345;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class dataJSON;

class bots_sendCustomRequest final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string custom_method_;
  object_ptr<dataJSON> params_;

  bots_sendCustomRequest(string const &custom_method_, object_ptr<dataJSON> &&params_);

  static const std::int32_t ID = -1440257555;

  using ReturnType = object_ptr<dataJSON>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class chatAdminRights;

class bots_setBotBroadcastDefaultAdminRights final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatAdminRights> admin_rights_;

  explicit bots_setBotBroadcastDefaultAdminRights(object_ptr<chatAdminRights> &&admin_rights_);

  static const std::int32_t ID = 2021942497;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class BotCommandScope;

class botCommand;

class bots_setBotCommands final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BotCommandScope> scope_;
  string lang_code_;
  array<object_ptr<botCommand>> commands_;

  bots_setBotCommands(object_ptr<BotCommandScope> &&scope_, string const &lang_code_, array<object_ptr<botCommand>> &&commands_);

  static const std::int32_t ID = 85399130;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class chatAdminRights;

class bots_setBotGroupDefaultAdminRights final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatAdminRights> admin_rights_;

  explicit bots_setBotGroupDefaultAdminRights(object_ptr<chatAdminRights> &&admin_rights_);

  static const std::int32_t ID = -1839281686;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class bots_setBotInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputUser> bot_;
  string lang_code_;
  string name_;
  string about_;
  string description_;
  enum Flags : std::int32_t { BOT_MASK = 4, NAME_MASK = 8, ABOUT_MASK = 1, DESCRIPTION_MASK = 2 };
  mutable int32 var0;

  bots_setBotInfo(int32 flags_, object_ptr<InputUser> &&bot_, string const &lang_code_, string const &name_, string const &about_, string const &description_);

  static const std::int32_t ID = 282013987;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class BotMenuButton;

class InputUser;

class bots_setBotMenuButton final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> user_id_;
  object_ptr<BotMenuButton> button_;

  bots_setBotMenuButton(object_ptr<InputUser> &&user_id_, object_ptr<BotMenuButton> &&button_);

  static const std::int32_t ID = 1157944655;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class InputUser;

class bots_setCustomVerification final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool enabled_;
  object_ptr<InputUser> bot_;
  object_ptr<InputPeer> peer_;
  string custom_description_;
  enum Flags : std::int32_t { ENABLED_MASK = 2, BOT_MASK = 1, CUSTOM_DESCRIPTION_MASK = 4 };
  mutable int32 var0;

  bots_setCustomVerification(int32 flags_, bool enabled_, object_ptr<InputUser> &&bot_, object_ptr<InputPeer> &&peer_, string const &custom_description_);

  static const std::int32_t ID = -1953898563;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class bots_toggleUserEmojiStatusPermission final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  bool enabled_;

  bots_toggleUserEmojiStatusPermission(object_ptr<InputUser> &&bot_, bool enabled_);

  static const std::int32_t ID = 115237778;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class bots_toggleUsername final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  string username_;
  bool active_;

  bots_toggleUsername(object_ptr<InputUser> &&bot_, string const &username_, bool active_);

  static const std::int32_t ID = 87861619;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class starRefProgram;

class bots_updateStarRefProgram final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputUser> bot_;
  int32 commission_permille_;
  int32 duration_months_;
  enum Flags : std::int32_t { DURATION_MONTHS_MASK = 1 };
  mutable int32 var0;

  bots_updateStarRefProgram(int32 flags_, object_ptr<InputUser> &&bot_, int32 commission_permille_, int32 duration_months_);

  static const std::int32_t ID = 2005621427;

  using ReturnType = object_ptr<starRefProgram>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EmojiStatus;

class InputUser;

class bots_updateUserEmojiStatus final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> user_id_;
  object_ptr<EmojiStatus> emoji_status_;

  bots_updateUserEmojiStatus(object_ptr<InputUser> &&user_id_, object_ptr<EmojiStatus> &&emoji_status_);

  static const std::int32_t ID = -308334395;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class channels_checkUsername final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  string username_;

  channels_checkUsername(object_ptr<InputChannel> &&channel_, string const &username_);

  static const std::int32_t ID = 283557164;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_convertToGigagroup final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;

  explicit channels_convertToGigagroup(object_ptr<InputChannel> &&channel_);

  static const std::int32_t ID = 187239529;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputGeoPoint;

class Updates;

class channels_createChannel final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool broadcast_;
  bool megagroup_;
  bool for_import_;
  bool forum_;
  string title_;
  string about_;
  object_ptr<InputGeoPoint> geo_point_;
  string address_;
  int32 ttl_period_;
  enum Flags : std::int32_t { BROADCAST_MASK = 1, MEGAGROUP_MASK = 2, FOR_IMPORT_MASK = 8, FORUM_MASK = 32, GEO_POINT_MASK = 4, ADDRESS_MASK = 4, TTL_PERIOD_MASK = 16 };
  mutable int32 var0;

  channels_createChannel(int32 flags_, bool broadcast_, bool megagroup_, bool for_import_, bool forum_, string const &title_, string const &about_, object_ptr<InputGeoPoint> &&geo_point_, string const &address_, int32 ttl_period_);

  static const std::int32_t ID = -1862244601;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputPeer;

class Updates;

class channels_createForumTopic final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputChannel> channel_;
  string title_;
  int32 icon_color_;
  int64 icon_emoji_id_;
  int64 random_id_;
  object_ptr<InputPeer> send_as_;
  enum Flags : std::int32_t { ICON_COLOR_MASK = 1, ICON_EMOJI_ID_MASK = 8, SEND_AS_MASK = 4 };
  mutable int32 var0;

  channels_createForumTopic(int32 flags_, object_ptr<InputChannel> &&channel_, string const &title_, int32 icon_color_, int64 icon_emoji_id_, int64 random_id_, object_ptr<InputPeer> &&send_as_);

  static const std::int32_t ID = -200539612;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class channels_deactivateAllUsernames final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;

  explicit channels_deactivateAllUsernames(object_ptr<InputChannel> &&channel_);

  static const std::int32_t ID = 170155475;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_deleteChannel final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;

  explicit channels_deleteChannel(object_ptr<InputChannel> &&channel_);

  static const std::int32_t ID = -1072619549;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_deleteHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool for_everyone_;
  object_ptr<InputChannel> channel_;
  int32 max_id_;
  enum Flags : std::int32_t { FOR_EVERYONE_MASK = 1 };
  mutable int32 var0;

  channels_deleteHistory(int32 flags_, bool for_everyone_, object_ptr<InputChannel> &&channel_, int32 max_id_);

  static const std::int32_t ID = -1683319225;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class messages_affectedMessages;

class channels_deleteMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  array<int32> id_;

  channels_deleteMessages(object_ptr<InputChannel> &&channel_, array<int32> &&id_);

  static const std::int32_t ID = -2067661490;

  using ReturnType = object_ptr<messages_affectedMessages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputPeer;

class messages_affectedHistory;

class channels_deleteParticipantHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<InputPeer> participant_;

  channels_deleteParticipantHistory(object_ptr<InputChannel> &&channel_, object_ptr<InputPeer> &&participant_);

  static const std::int32_t ID = 913655003;

  using ReturnType = object_ptr<messages_affectedHistory>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class messages_affectedHistory;

class channels_deleteTopicHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  int32 top_msg_id_;

  channels_deleteTopicHistory(object_ptr<InputChannel> &&channel_, int32 top_msg_id_);

  static const std::int32_t ID = 876830509;

  using ReturnType = object_ptr<messages_affectedHistory>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputUser;

class Updates;

class chatAdminRights;

class channels_editAdmin final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<InputUser> user_id_;
  object_ptr<chatAdminRights> admin_rights_;
  string rank_;

  channels_editAdmin(object_ptr<InputChannel> &&channel_, object_ptr<InputUser> &&user_id_, object_ptr<chatAdminRights> &&admin_rights_, string const &rank_);

  static const std::int32_t ID = -751007486;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputPeer;

class Updates;

class chatBannedRights;

class channels_editBanned final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<InputPeer> participant_;
  object_ptr<chatBannedRights> banned_rights_;

  channels_editBanned(object_ptr<InputChannel> &&channel_, object_ptr<InputPeer> &&participant_, object_ptr<chatBannedRights> &&banned_rights_);

  static const std::int32_t ID = -1763259007;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputCheckPasswordSRP;

class InputUser;

class Updates;

class channels_editCreator final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<InputUser> user_id_;
  object_ptr<InputCheckPasswordSRP> password_;

  channels_editCreator(object_ptr<InputChannel> &&channel_, object_ptr<InputUser> &&user_id_, object_ptr<InputCheckPasswordSRP> &&password_);

  static const std::int32_t ID = -1892102881;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_editForumTopic final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputChannel> channel_;
  int32 topic_id_;
  string title_;
  int64 icon_emoji_id_;
  bool closed_;
  bool hidden_;
  enum Flags : std::int32_t { TITLE_MASK = 1, ICON_EMOJI_ID_MASK = 2, CLOSED_MASK = 4, HIDDEN_MASK = 8 };
  mutable int32 var0;

  channels_editForumTopic(int32 flags_, object_ptr<InputChannel> &&channel_, int32 topic_id_, string const &title_, int64 icon_emoji_id_, bool closed_, bool hidden_);

  static const std::int32_t ID = -186670715;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputGeoPoint;

class channels_editLocation final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<InputGeoPoint> geo_point_;
  string address_;

  channels_editLocation(object_ptr<InputChannel> &&channel_, object_ptr<InputGeoPoint> &&geo_point_, string const &address_);

  static const std::int32_t ID = 1491484525;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputChatPhoto;

class Updates;

class channels_editPhoto final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<InputChatPhoto> photo_;

  channels_editPhoto(object_ptr<InputChannel> &&channel_, object_ptr<InputChatPhoto> &&photo_);

  static const std::int32_t ID = -248621111;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_editTitle final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  string title_;

  channels_editTitle(object_ptr<InputChannel> &&channel_, string const &title_);

  static const std::int32_t ID = 1450044624;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class exportedMessageLink;

class channels_exportMessageLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool grouped_;
  bool thread_;
  object_ptr<InputChannel> channel_;
  int32 id_;
  enum Flags : std::int32_t { GROUPED_MASK = 1, THREAD_MASK = 2 };
  mutable int32 var0;

  channels_exportMessageLink(int32 flags_, bool grouped_, bool thread_, object_ptr<InputChannel> &&channel_, int32 id_);

  static const std::int32_t ID = -432034325;

  using ReturnType = object_ptr<exportedMessageLink>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputUser;

class channelAdminLogEventsFilter;

class channels_adminLogResults;

class channels_getAdminLog final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputChannel> channel_;
  string q_;
  object_ptr<channelAdminLogEventsFilter> events_filter_;
  array<object_ptr<InputUser>> admins_;
  int64 max_id_;
  int64 min_id_;
  int32 limit_;
  enum Flags : std::int32_t { EVENTS_FILTER_MASK = 1, ADMINS_MASK = 2 };
  mutable int32 var0;

  channels_getAdminLog(int32 flags_, object_ptr<InputChannel> &&channel_, string const &q_, object_ptr<channelAdminLogEventsFilter> &&events_filter_, array<object_ptr<InputUser>> &&admins_, int64 max_id_, int64 min_id_, int32 limit_);

  static const std::int32_t ID = 870184064;

  using ReturnType = object_ptr<channels_adminLogResults>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_Chats;

class channels_getAdminedPublicChannels final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool by_location_;
  bool check_limit_;
  bool for_personal_;
  enum Flags : std::int32_t { BY_LOCATION_MASK = 1, CHECK_LIMIT_MASK = 2, FOR_PERSONAL_MASK = 4 };
  mutable int32 var0;

  channels_getAdminedPublicChannels(int32 flags_, bool by_location_, bool check_limit_, bool for_personal_);

  static const std::int32_t ID = -122669393;

  using ReturnType = object_ptr<messages_Chats>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class messages_Chats;

class channels_getChannelRecommendations final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputChannel> channel_;
  enum Flags : std::int32_t { CHANNEL_MASK = 1 };
  mutable int32 var0;

  channels_getChannelRecommendations(int32 flags_, object_ptr<InputChannel> &&channel_);

  static const std::int32_t ID = 631707458;

  using ReturnType = object_ptr<messages_Chats>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class messages_Chats;

class channels_getChannels final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<InputChannel>> id_;

  explicit channels_getChannels(array<object_ptr<InputChannel>> &&id_);

  static const std::int32_t ID = 176122811;

  using ReturnType = object_ptr<messages_Chats>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class messages_forumTopics;

class channels_getForumTopics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputChannel> channel_;
  string q_;
  int32 offset_date_;
  int32 offset_id_;
  int32 offset_topic_;
  int32 limit_;
  enum Flags : std::int32_t { Q_MASK = 1 };
  mutable int32 var0;

  channels_getForumTopics(int32 flags_, object_ptr<InputChannel> &&channel_, string const &q_, int32 offset_date_, int32 offset_id_, int32 offset_topic_, int32 limit_);

  static const std::int32_t ID = 233136337;

  using ReturnType = object_ptr<messages_forumTopics>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class messages_forumTopics;

class channels_getForumTopicsByID final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  array<int32> topics_;

  channels_getForumTopicsByID(object_ptr<InputChannel> &&channel_, array<int32> &&topics_);

  static const std::int32_t ID = -1333584199;

  using ReturnType = object_ptr<messages_forumTopics>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class messages_chatFull;

class channels_getFullChannel final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;

  explicit channels_getFullChannel(object_ptr<InputChannel> &&channel_);

  static const std::int32_t ID = 141781513;

  using ReturnType = object_ptr<messages_chatFull>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_Chats;

class channels_getGroupsForDiscussion final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -170208392;

  using ReturnType = object_ptr<messages_Chats>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_inactiveChats;

class channels_getInactiveChannels final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 300429806;

  using ReturnType = object_ptr<messages_inactiveChats>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_Chats;

class channels_getLeftChannels final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;

  explicit channels_getLeftChannels(int32 offset_);

  static const std::int32_t ID = -2092831552;

  using ReturnType = object_ptr<messages_Chats>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputMessage;

class messages_Messages;

class channels_getMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  array<object_ptr<InputMessage>> id_;

  channels_getMessages(object_ptr<InputChannel> &&channel_, array<object_ptr<InputMessage>> &&id_);

  static const std::int32_t ID = -1383294429;

  using ReturnType = object_ptr<messages_Messages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputPeer;

class channels_channelParticipant;

class channels_getParticipant final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<InputPeer> participant_;

  channels_getParticipant(object_ptr<InputChannel> &&channel_, object_ptr<InputPeer> &&participant_);

  static const std::int32_t ID = -1599378234;

  using ReturnType = object_ptr<channels_channelParticipant>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class ChannelParticipantsFilter;

class InputChannel;

class channels_ChannelParticipants;

class channels_getParticipants final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<ChannelParticipantsFilter> filter_;
  int32 offset_;
  int32 limit_;
  int64 hash_;

  channels_getParticipants(object_ptr<InputChannel> &&channel_, object_ptr<ChannelParticipantsFilter> &&filter_, int32 offset_, int32 limit_, int64 hash_);

  static const std::int32_t ID = 2010044880;

  using ReturnType = object_ptr<channels_ChannelParticipants>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class channels_sendAsPeers;

class channels_getSendAs final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool for_paid_reactions_;
  object_ptr<InputPeer> peer_;
  enum Flags : std::int32_t { FOR_PAID_REACTIONS_MASK = 1 };
  mutable int32 var0;

  channels_getSendAs(int32 flags_, bool for_paid_reactions_, object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = -410672065;

  using ReturnType = object_ptr<channels_sendAsPeers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputUser;

class messages_invitedUsers;

class channels_inviteToChannel final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  array<object_ptr<InputUser>> users_;

  channels_inviteToChannel(object_ptr<InputChannel> &&channel_, array<object_ptr<InputUser>> &&users_);

  static const std::int32_t ID = -907854508;

  using ReturnType = object_ptr<messages_invitedUsers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_joinChannel final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;

  explicit channels_joinChannel(object_ptr<InputChannel> &&channel_);

  static const std::int32_t ID = 615851205;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_leaveChannel final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;

  explicit channels_leaveChannel(object_ptr<InputChannel> &&channel_);

  static const std::int32_t ID = -130635115;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class channels_readHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  int32 max_id_;

  channels_readHistory(object_ptr<InputChannel> &&channel_, int32 max_id_);

  static const std::int32_t ID = -871347913;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class channels_readMessageContents final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  array<int32> id_;

  channels_readMessageContents(object_ptr<InputChannel> &&channel_, array<int32> &&id_);

  static const std::int32_t ID = -357180360;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_reorderPinnedForumTopics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool force_;
  object_ptr<InputChannel> channel_;
  array<int32> order_;
  enum Flags : std::int32_t { FORCE_MASK = 1 };
  mutable int32 var0;

  channels_reorderPinnedForumTopics(int32 flags_, bool force_, object_ptr<InputChannel> &&channel_, array<int32> &&order_);

  static const std::int32_t ID = 693150095;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class channels_reorderUsernames final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  array<string> order_;

  channels_reorderUsernames(object_ptr<InputChannel> &&channel_, array<string> &&order_);

  static const std::int32_t ID = -1268978403;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class channels_reportAntiSpamFalsePositive final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  int32 msg_id_;

  channels_reportAntiSpamFalsePositive(object_ptr<InputChannel> &&channel_, int32 msg_id_);

  static const std::int32_t ID = -1471109485;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputPeer;

class channels_reportSpam final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<InputPeer> participant_;
  array<int32> id_;

  channels_reportSpam(object_ptr<InputChannel> &&channel_, object_ptr<InputPeer> &&participant_, array<int32> &&id_);

  static const std::int32_t ID = -196443371;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_restrictSponsoredMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  bool restricted_;

  channels_restrictSponsoredMessages(object_ptr<InputChannel> &&channel_, bool restricted_);

  static const std::int32_t ID = -1696000743;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_Messages;

class channels_searchPosts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string hashtag_;
  int32 offset_rate_;
  object_ptr<InputPeer> offset_peer_;
  int32 offset_id_;
  int32 limit_;

  channels_searchPosts(string const &hashtag_, int32 offset_rate_, object_ptr<InputPeer> &&offset_peer_, int32 offset_id_, int32 limit_);

  static const std::int32_t ID = -778069893;

  using ReturnType = object_ptr<messages_Messages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_setBoostsToUnblockRestrictions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  int32 boosts_;

  channels_setBoostsToUnblockRestrictions(object_ptr<InputChannel> &&channel_, int32 boosts_);

  static const std::int32_t ID = -1388733202;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class channels_setDiscussionGroup final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> broadcast_;
  object_ptr<InputChannel> group_;

  channels_setDiscussionGroup(object_ptr<InputChannel> &&broadcast_, object_ptr<InputChannel> &&group_);

  static const std::int32_t ID = 1079520178;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputStickerSet;

class channels_setEmojiStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<InputStickerSet> stickerset_;

  channels_setEmojiStickers(object_ptr<InputChannel> &&channel_, object_ptr<InputStickerSet> &&stickerset_);

  static const std::int32_t ID = 1020866743;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class InputStickerSet;

class channels_setStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<InputStickerSet> stickerset_;

  channels_setStickers(object_ptr<InputChannel> &&channel_, object_ptr<InputStickerSet> &&stickerset_);

  static const std::int32_t ID = -359881479;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_toggleAntiSpam final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  bool enabled_;

  channels_toggleAntiSpam(object_ptr<InputChannel> &&channel_, bool enabled_);

  static const std::int32_t ID = 1760814315;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_toggleForum final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  bool enabled_;

  channels_toggleForum(object_ptr<InputChannel> &&channel_, bool enabled_);

  static const std::int32_t ID = -1540781271;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_toggleJoinRequest final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  bool enabled_;

  channels_toggleJoinRequest(object_ptr<InputChannel> &&channel_, bool enabled_);

  static const std::int32_t ID = 1277789622;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_toggleJoinToSend final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  bool enabled_;

  channels_toggleJoinToSend(object_ptr<InputChannel> &&channel_, bool enabled_);

  static const std::int32_t ID = -456419968;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_toggleParticipantsHidden final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  bool enabled_;

  channels_toggleParticipantsHidden(object_ptr<InputChannel> &&channel_, bool enabled_);

  static const std::int32_t ID = 1785624660;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_togglePreHistoryHidden final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  bool enabled_;

  channels_togglePreHistoryHidden(object_ptr<InputChannel> &&channel_, bool enabled_);

  static const std::int32_t ID = -356796084;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_toggleSignatures final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool signatures_enabled_;
  bool profiles_enabled_;
  object_ptr<InputChannel> channel_;
  enum Flags : std::int32_t { SIGNATURES_ENABLED_MASK = 1, PROFILES_ENABLED_MASK = 2 };
  mutable int32 var0;

  channels_toggleSignatures(int32 flags_, bool signatures_enabled_, bool profiles_enabled_, object_ptr<InputChannel> &&channel_);

  static const std::int32_t ID = 1099781276;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_toggleSlowMode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  int32 seconds_;

  channels_toggleSlowMode(object_ptr<InputChannel> &&channel_, int32 seconds_);

  static const std::int32_t ID = -304832784;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class channels_toggleUsername final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  string username_;
  bool active_;

  channels_toggleUsername(object_ptr<InputChannel> &&channel_, string const &username_, bool active_);

  static const std::int32_t ID = 1358053637;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_toggleViewForumAsMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  bool enabled_;

  channels_toggleViewForumAsMessages(object_ptr<InputChannel> &&channel_, bool enabled_);

  static const std::int32_t ID = -1757889771;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_updateColor final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool for_profile_;
  object_ptr<InputChannel> channel_;
  int32 color_;
  int64 background_emoji_id_;
  enum Flags : std::int32_t { FOR_PROFILE_MASK = 2, COLOR_MASK = 4, BACKGROUND_EMOJI_ID_MASK = 1 };
  mutable int32 var0;

  channels_updateColor(int32 flags_, bool for_profile_, object_ptr<InputChannel> &&channel_, int32 color_, int64 background_emoji_id_);

  static const std::int32_t ID = -659933583;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EmojiStatus;

class InputChannel;

class Updates;

class channels_updateEmojiStatus final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  object_ptr<EmojiStatus> emoji_status_;

  channels_updateEmojiStatus(object_ptr<InputChannel> &&channel_, object_ptr<EmojiStatus> &&emoji_status_);

  static const std::int32_t ID = -254548312;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class Updates;

class channels_updatePinnedForumTopic final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  int32 topic_id_;
  bool pinned_;

  channels_updatePinnedForumTopic(object_ptr<InputChannel> &&channel_, int32 topic_id_, bool pinned_);

  static const std::int32_t ID = 1814925350;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChannel;

class channels_updateUsername final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputChannel> channel_;
  string username_;

  channels_updateUsername(object_ptr<InputChannel> &&channel_, string const &username_);

  static const std::int32_t ID = 890549214;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class chatlists_ChatlistInvite;

class chatlists_checkChatlistInvite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string slug_;

  explicit chatlists_checkChatlistInvite(string const &slug_);

  static const std::int32_t ID = 1103171583;

  using ReturnType = object_ptr<chatlists_ChatlistInvite>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class inputChatlistDialogFilter;

class chatlists_deleteExportedInvite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputChatlistDialogFilter> chatlist_;
  string slug_;

  chatlists_deleteExportedInvite(object_ptr<inputChatlistDialogFilter> &&chatlist_, string const &slug_);

  static const std::int32_t ID = 1906072670;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class exportedChatlistInvite;

class inputChatlistDialogFilter;

class chatlists_editExportedInvite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<inputChatlistDialogFilter> chatlist_;
  string slug_;
  string title_;
  array<object_ptr<InputPeer>> peers_;
  enum Flags : std::int32_t { TITLE_MASK = 2, PEERS_MASK = 4 };
  mutable int32 var0;

  chatlists_editExportedInvite(int32 flags_, object_ptr<inputChatlistDialogFilter> &&chatlist_, string const &slug_, string const &title_, array<object_ptr<InputPeer>> &&peers_);

  static const std::int32_t ID = 1698543165;

  using ReturnType = object_ptr<exportedChatlistInvite>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class chatlists_exportedChatlistInvite;

class inputChatlistDialogFilter;

class chatlists_exportChatlistInvite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputChatlistDialogFilter> chatlist_;
  string title_;
  array<object_ptr<InputPeer>> peers_;

  chatlists_exportChatlistInvite(object_ptr<inputChatlistDialogFilter> &&chatlist_, string const &title_, array<object_ptr<InputPeer>> &&peers_);

  static const std::int32_t ID = -2072885362;

  using ReturnType = object_ptr<chatlists_exportedChatlistInvite>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class chatlists_chatlistUpdates;

class inputChatlistDialogFilter;

class chatlists_getChatlistUpdates final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputChatlistDialogFilter> chatlist_;

  explicit chatlists_getChatlistUpdates(object_ptr<inputChatlistDialogFilter> &&chatlist_);

  static const std::int32_t ID = -1992190687;

  using ReturnType = object_ptr<chatlists_chatlistUpdates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class chatlists_exportedInvites;

class inputChatlistDialogFilter;

class chatlists_getExportedInvites final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputChatlistDialogFilter> chatlist_;

  explicit chatlists_getExportedInvites(object_ptr<inputChatlistDialogFilter> &&chatlist_);

  static const std::int32_t ID = -838608253;

  using ReturnType = object_ptr<chatlists_exportedInvites>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Peer;

class inputChatlistDialogFilter;

class chatlists_getLeaveChatlistSuggestions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputChatlistDialogFilter> chatlist_;

  explicit chatlists_getLeaveChatlistSuggestions(object_ptr<inputChatlistDialogFilter> &&chatlist_);

  static const std::int32_t ID = -37955820;

  using ReturnType = array<object_ptr<Peer>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class inputChatlistDialogFilter;

class chatlists_hideChatlistUpdates final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputChatlistDialogFilter> chatlist_;

  explicit chatlists_hideChatlistUpdates(object_ptr<inputChatlistDialogFilter> &&chatlist_);

  static const std::int32_t ID = 1726252795;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Updates;

class chatlists_joinChatlistInvite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string slug_;
  array<object_ptr<InputPeer>> peers_;

  chatlists_joinChatlistInvite(string const &slug_, array<object_ptr<InputPeer>> &&peers_);

  static const std::int32_t ID = -1498291302;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Updates;

class inputChatlistDialogFilter;

class chatlists_joinChatlistUpdates final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputChatlistDialogFilter> chatlist_;
  array<object_ptr<InputPeer>> peers_;

  chatlists_joinChatlistUpdates(object_ptr<inputChatlistDialogFilter> &&chatlist_, array<object_ptr<InputPeer>> &&peers_);

  static const std::int32_t ID = -527828747;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Updates;

class inputChatlistDialogFilter;

class chatlists_leaveChatlist final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputChatlistDialogFilter> chatlist_;
  array<object_ptr<InputPeer>> peers_;

  chatlists_leaveChatlist(object_ptr<inputChatlistDialogFilter> &&chatlist_, array<object_ptr<InputPeer>> &&peers_);

  static const std::int32_t ID = 1962598714;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class Updates;

class contacts_acceptContact final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> id_;

  explicit contacts_acceptContact(object_ptr<InputUser> &&id_);

  static const std::int32_t ID = -130964977;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class Updates;

class contacts_addContact final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool add_phone_privacy_exception_;
  object_ptr<InputUser> id_;
  string first_name_;
  string last_name_;
  string phone_;
  enum Flags : std::int32_t { ADD_PHONE_PRIVACY_EXCEPTION_MASK = 1 };
  mutable int32 var0;

  contacts_addContact(int32 flags_, bool add_phone_privacy_exception_, object_ptr<InputUser> &&id_, string const &first_name_, string const &last_name_, string const &phone_);

  static const std::int32_t ID = -386636848;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class contacts_block final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool my_stories_from_;
  object_ptr<InputPeer> id_;
  enum Flags : std::int32_t { MY_STORIES_FROM_MASK = 1 };
  mutable int32 var0;

  contacts_block(int32 flags_, bool my_stories_from_, object_ptr<InputPeer> &&id_);

  static const std::int32_t ID = 774801204;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Updates;

class contacts_blockFromReplies final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool delete_message_;
  bool delete_history_;
  bool report_spam_;
  int32 msg_id_;
  enum Flags : std::int32_t { DELETE_MESSAGE_MASK = 1, DELETE_HISTORY_MASK = 2, REPORT_SPAM_MASK = 4 };
  mutable int32 var0;

  contacts_blockFromReplies(int32 flags_, bool delete_message_, bool delete_history_, bool report_spam_, int32 msg_id_);

  static const std::int32_t ID = 698914348;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_deleteByPhones final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> phones_;

  explicit contacts_deleteByPhones(array<string> &&phones_);

  static const std::int32_t ID = 269745566;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class Updates;

class contacts_deleteContacts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<InputUser>> id_;

  explicit contacts_deleteContacts(array<object_ptr<InputUser>> &&id_);

  static const std::int32_t ID = 157945344;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_editCloseFriends final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> id_;

  explicit contacts_editCloseFriends(array<int64> &&id_);

  static const std::int32_t ID = -1167653392;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class exportedContactToken;

class contacts_exportContactToken final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -127582169;

  using ReturnType = object_ptr<exportedContactToken>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_contactBirthdays;

class contacts_getBirthdays final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -621959068;

  using ReturnType = object_ptr<contacts_contactBirthdays>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_Blocked;

class contacts_getBlocked final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool my_stories_from_;
  int32 offset_;
  int32 limit_;
  enum Flags : std::int32_t { MY_STORIES_FROM_MASK = 1 };
  mutable int32 var0;

  contacts_getBlocked(int32 flags_, bool my_stories_from_, int32 offset_, int32 limit_);

  static const std::int32_t ID = -1702457472;

  using ReturnType = object_ptr<contacts_Blocked>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_getContactIDs final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit contacts_getContactIDs(int64 hash_);

  static const std::int32_t ID = 2061264541;

  using ReturnType = array<int32>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_Contacts;

class contacts_getContacts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit contacts_getContacts(int64 hash_);

  static const std::int32_t ID = 1574346258;

  using ReturnType = object_ptr<contacts_Contacts>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputGeoPoint;

class Updates;

class contacts_getLocated final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool background_;
  object_ptr<InputGeoPoint> geo_point_;
  int32 self_expires_;
  enum Flags : std::int32_t { BACKGROUND_MASK = 2, SELF_EXPIRES_MASK = 1 };
  mutable int32 var0;

  contacts_getLocated(int32 flags_, bool background_, object_ptr<InputGeoPoint> &&geo_point_, int32 self_expires_);

  static const std::int32_t ID = -750207932;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class savedPhoneContact;

class contacts_getSaved final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -2098076769;

  using ReturnType = array<object_ptr<savedPhoneContact>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contactStatus;

class contacts_getStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -995929106;

  using ReturnType = array<object_ptr<contactStatus>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_TopPeers;

class contacts_getTopPeers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool correspondents_;
  bool bots_pm_;
  bool bots_inline_;
  bool phone_calls_;
  bool forward_users_;
  bool forward_chats_;
  bool groups_;
  bool channels_;
  bool bots_app_;
  int32 offset_;
  int32 limit_;
  int64 hash_;
  enum Flags : std::int32_t { CORRESPONDENTS_MASK = 1, BOTS_PM_MASK = 2, BOTS_INLINE_MASK = 4, PHONE_CALLS_MASK = 8, FORWARD_USERS_MASK = 16, FORWARD_CHATS_MASK = 32, GROUPS_MASK = 1024, CHANNELS_MASK = 32768, BOTS_APP_MASK = 65536 };
  mutable int32 var0;

  contacts_getTopPeers(int32 flags_, bool correspondents_, bool bots_pm_, bool bots_inline_, bool phone_calls_, bool forward_users_, bool forward_chats_, bool groups_, bool channels_, bool bots_app_, int32 offset_, int32 limit_, int64 hash_);

  static const std::int32_t ID = -1758168906;

  using ReturnType = object_ptr<contacts_TopPeers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class User;

class contacts_importContactToken final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  explicit contacts_importContactToken(string const &token_);

  static const std::int32_t ID = 318789512;

  using ReturnType = object_ptr<User>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_importedContacts;

class inputPhoneContact;

class contacts_importContacts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<inputPhoneContact>> contacts_;

  explicit contacts_importContacts(array<object_ptr<inputPhoneContact>> &&contacts_);

  static const std::int32_t ID = 746589157;

  using ReturnType = object_ptr<contacts_importedContacts>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_resetSaved final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -2020263951;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class TopPeerCategory;

class contacts_resetTopPeerRating final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<TopPeerCategory> category_;
  object_ptr<InputPeer> peer_;

  contacts_resetTopPeerRating(object_ptr<TopPeerCategory> &&category_, object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = 451113900;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_resolvedPeer;

class contacts_resolvePhone final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_;

  explicit contacts_resolvePhone(string const &phone_);

  static const std::int32_t ID = -1963375804;

  using ReturnType = object_ptr<contacts_resolvedPeer>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_resolvedPeer;

class contacts_resolveUsername final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  string username_;
  string referer_;
  enum Flags : std::int32_t { REFERER_MASK = 1 };
  mutable int32 var0;

  contacts_resolveUsername(int32 flags_, string const &username_, string const &referer_);

  static const std::int32_t ID = 1918565308;

  using ReturnType = object_ptr<contacts_resolvedPeer>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_found;

class contacts_search final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string q_;
  int32 limit_;

  contacts_search(string const &q_, int32 limit_);

  static const std::int32_t ID = 301470424;

  using ReturnType = object_ptr<contacts_found>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class contacts_setBlocked final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool my_stories_from_;
  array<object_ptr<InputPeer>> id_;
  int32 limit_;
  enum Flags : std::int32_t { MY_STORIES_FROM_MASK = 1 };
  mutable int32 var0;

  contacts_setBlocked(int32 flags_, bool my_stories_from_, array<object_ptr<InputPeer>> &&id_, int32 limit_);

  static const std::int32_t ID = -1798939530;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class contacts_toggleTopPeers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool enabled_;

  explicit contacts_toggleTopPeers(bool enabled_);

  static const std::int32_t ID = -2062238246;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class contacts_unblock final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool my_stories_from_;
  object_ptr<InputPeer> id_;
  enum Flags : std::int32_t { MY_STORIES_FROM_MASK = 1 };
  mutable int32 var0;

  contacts_unblock(int32 flags_, bool my_stories_from_, object_ptr<InputPeer> &&id_);

  static const std::int32_t ID = -1252994264;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Updates;

class inputFolderPeer;

class folders_editPeerFolders final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<inputFolderPeer>> folder_peers_;

  explicit folders_editPeerFolders(array<object_ptr<inputFolderPeer>> &&folder_peers_);

  static const std::int32_t ID = 1749536939;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputCollectible;

class fragment_collectibleInfo;

class fragment_getCollectibleInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputCollectible> collectible_;

  explicit fragment_getCollectibleInfo(object_ptr<InputCollectible> &&collectible_);

  static const std::int32_t ID = -1105295942;

  using ReturnType = object_ptr<fragment_collectibleInfo>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class dataJSON;

class help_acceptTermsOfService final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<dataJSON> id_;

  explicit help_acceptTermsOfService(object_ptr<dataJSON> &&id_);

  static const std::int32_t ID = -294455398;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class help_dismissSuggestion final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  string suggestion_;

  help_dismissSuggestion(object_ptr<InputPeer> &&peer_, string const &suggestion_);

  static const std::int32_t ID = -183649631;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class MessageEntity;

class help_UserInfo;

class help_editUserInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> user_id_;
  string message_;
  array<object_ptr<MessageEntity>> entities_;

  help_editUserInfo(object_ptr<InputUser> &&user_id_, string const &message_, array<object_ptr<MessageEntity>> &&entities_);

  static const std::int32_t ID = 1723407216;

  using ReturnType = object_ptr<help_UserInfo>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_AppConfig;

class help_getAppConfig final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit help_getAppConfig(int32 hash_);

  static const std::int32_t ID = 1642330196;

  using ReturnType = object_ptr<help_AppConfig>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_AppUpdate;

class help_getAppUpdate final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string source_;

  explicit help_getAppUpdate(string const &source_);

  static const std::int32_t ID = 1378703997;

  using ReturnType = object_ptr<help_AppUpdate>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class cdnConfig;

class help_getCdnConfig final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1375900482;

  using ReturnType = object_ptr<cdnConfig>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class config;

class help_getConfig final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -990308245;

  using ReturnType = object_ptr<config>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_CountriesList;

class help_getCountriesList final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_code_;
  int32 hash_;

  help_getCountriesList(string const &lang_code_, int32 hash_);

  static const std::int32_t ID = 1935116200;

  using ReturnType = object_ptr<help_CountriesList>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_DeepLinkInfo;

class help_getDeepLinkInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string path_;

  explicit help_getDeepLinkInfo(string const &path_);

  static const std::int32_t ID = 1072547679;

  using ReturnType = object_ptr<help_DeepLinkInfo>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_inviteText;

class help_getInviteText final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1295590211;

  using ReturnType = object_ptr<help_inviteText>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class nearestDc;

class help_getNearestDc final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 531836966;

  using ReturnType = object_ptr<nearestDc>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_PassportConfig;

class help_getPassportConfig final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit help_getPassportConfig(int32 hash_);

  static const std::int32_t ID = -966677240;

  using ReturnType = object_ptr<help_PassportConfig>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_PeerColors;

class help_getPeerColors final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit help_getPeerColors(int32 hash_);

  static const std::int32_t ID = -629083089;

  using ReturnType = object_ptr<help_PeerColors>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_PeerColors;

class help_getPeerProfileColors final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit help_getPeerProfileColors(int32 hash_);

  static const std::int32_t ID = -1412453891;

  using ReturnType = object_ptr<help_PeerColors>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_premiumPromo;

class help_getPremiumPromo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1206152236;

  using ReturnType = object_ptr<help_premiumPromo>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_PromoData;

class help_getPromoData final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1063816159;

  using ReturnType = object_ptr<help_PromoData>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_recentMeUrls;

class help_getRecentMeUrls final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string referer_;

  explicit help_getRecentMeUrls(string const &referer_);

  static const std::int32_t ID = 1036054804;

  using ReturnType = object_ptr<help_recentMeUrls>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_support;

class help_getSupport final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1663104819;

  using ReturnType = object_ptr<help_support>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_supportName;

class help_getSupportName final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -748624084;

  using ReturnType = object_ptr<help_supportName>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_TermsOfServiceUpdate;

class help_getTermsOfServiceUpdate final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 749019089;

  using ReturnType = object_ptr<help_TermsOfServiceUpdate>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_TimezonesList;

class help_getTimezonesList final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit help_getTimezonesList(int32 hash_);

  static const std::int32_t ID = 1236468288;

  using ReturnType = object_ptr<help_TimezonesList>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class help_UserInfo;

class help_getUserInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> user_id_;

  explicit help_getUserInfo(object_ptr<InputUser> &&user_id_);

  static const std::int32_t ID = 59377875;

  using ReturnType = object_ptr<help_UserInfo>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class help_hidePromoData final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit help_hidePromoData(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = 505748629;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class inputAppEvent;

class help_saveAppLog final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<inputAppEvent>> events_;

  explicit help_saveAppLog(array<object_ptr<inputAppEvent>> &&events_);

  static const std::int32_t ID = 1862465352;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class help_setBotUpdatesStatus final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 pending_updates_count_;
  string message_;

  help_setBotUpdatesStatus(int32 pending_updates_count_, string const &message_);

  static const std::int32_t ID = -333262899;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class error;

class invokeWithApnsSecretPrefix final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string nonce_;
  string secret_;

  invokeWithApnsSecretPrefix(string const &nonce_, string const &secret_);

  static const std::int32_t ID = 229528824;

  using ReturnType = object_ptr<error>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class error;

class invokeWithBusinessConnectionPrefix final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string connection_id_;

  explicit invokeWithBusinessConnectionPrefix(string const &connection_id_);

  static const std::int32_t ID = -584540274;

  using ReturnType = object_ptr<error>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class error;

class invokeWithGooglePlayIntegrityPrefix final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string nonce_;
  string token_;

  invokeWithGooglePlayIntegrityPrefix(string const &nonce_, string const &token_);

  static const std::int32_t ID = 502868356;

  using ReturnType = object_ptr<error>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class error;

class invokeWithReCaptchaPrefix final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  explicit invokeWithReCaptchaPrefix(string const &token_);

  static const std::int32_t ID = -1380249708;

  using ReturnType = object_ptr<error>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class langPackDifference;

class langpack_getDifference final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_pack_;
  string lang_code_;
  int32 from_version_;

  langpack_getDifference(string const &lang_pack_, string const &lang_code_, int32 from_version_);

  static const std::int32_t ID = -845657435;

  using ReturnType = object_ptr<langPackDifference>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class langPackDifference;

class langpack_getLangPack final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_pack_;
  string lang_code_;

  langpack_getLangPack(string const &lang_pack_, string const &lang_code_);

  static const std::int32_t ID = -219008246;

  using ReturnType = object_ptr<langPackDifference>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class langPackLanguage;

class langpack_getLanguage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_pack_;
  string lang_code_;

  langpack_getLanguage(string const &lang_pack_, string const &lang_code_);

  static const std::int32_t ID = 1784243458;

  using ReturnType = object_ptr<langPackLanguage>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class langPackLanguage;

class langpack_getLanguages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_pack_;

  explicit langpack_getLanguages(string const &lang_pack_);

  static const std::int32_t ID = 1120311183;

  using ReturnType = array<object_ptr<langPackLanguage>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class LangPackString;

class langpack_getStrings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_pack_;
  string lang_code_;
  array<string> keys_;

  langpack_getStrings(string const &lang_pack_, string const &lang_code_, array<string> &&keys_);

  static const std::int32_t ID = -269862909;

  using ReturnType = array<object_ptr<LangPackString>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class EncryptedChat;

class inputEncryptedChat;

class messages_acceptEncryption final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputEncryptedChat> peer_;
  bytes g_b_;
  int64 key_fingerprint_;

  messages_acceptEncryption(object_ptr<inputEncryptedChat> &&peer_, bytes &&g_b_, int64 key_fingerprint_);

  static const std::int32_t ID = 1035731989;

  using ReturnType = object_ptr<EncryptedChat>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class UrlAuthResult;

class messages_acceptUrlAuth final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool write_allowed_;
  object_ptr<InputPeer> peer_;
  int32 msg_id_;
  int32 button_id_;
  string url_;
  enum Flags : std::int32_t { WRITE_ALLOWED_MASK = 1, PEER_MASK = 2, MSG_ID_MASK = 2, BUTTON_ID_MASK = 2, URL_MASK = 4 };
  mutable int32 var0;

  messages_acceptUrlAuth(int32 flags_, bool write_allowed_, object_ptr<InputPeer> &&peer_, int32 msg_id_, int32 button_id_, string const &url_);

  static const std::int32_t ID = -1322487515;

  using ReturnType = object_ptr<UrlAuthResult>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class messages_invitedUsers;

class messages_addChatUser final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;
  object_ptr<InputUser> user_id_;
  int32 fwd_limit_;

  messages_addChatUser(int64 chat_id_, object_ptr<InputUser> &&user_id_, int32 fwd_limit_);

  static const std::int32_t ID = -876162809;

  using ReturnType = object_ptr<messages_invitedUsers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class ChatInvite;

class messages_checkChatInvite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string hash_;

  explicit messages_checkChatInvite(string const &hash_);

  static const std::int32_t ID = 1051570619;

  using ReturnType = object_ptr<ChatInvite>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_historyImportParsed;

class messages_checkHistoryImport final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string import_head_;

  explicit messages_checkHistoryImport(string const &import_head_);

  static const std::int32_t ID = 1140726259;

  using ReturnType = object_ptr<messages_historyImportParsed>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_checkedHistoryImportPeer;

class messages_checkHistoryImportPeer final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit messages_checkHistoryImportPeer(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = 1573261059;

  using ReturnType = object_ptr<messages_checkedHistoryImportPeer>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_checkQuickReplyShortcut final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string shortcut_;

  explicit messages_checkQuickReplyShortcut(string const &shortcut_);

  static const std::int32_t ID = -237962285;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_clearAllDrafts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 2119757468;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_clearRecentReactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -1644236876;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_clearRecentStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool attached_;
  enum Flags : std::int32_t { ATTACHED_MASK = 1 };
  mutable int32 var0;

  messages_clearRecentStickers(int32 flags_, bool attached_);

  static const std::int32_t ID = -1986437075;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_clickSponsoredMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool media_;
  bool fullscreen_;
  object_ptr<InputPeer> peer_;
  bytes random_id_;
  enum Flags : std::int32_t { MEDIA_MASK = 1, FULLSCREEN_MASK = 2 };
  mutable int32 var0;

  messages_clickSponsoredMessage(int32 flags_, bool media_, bool fullscreen_, object_ptr<InputPeer> &&peer_, bytes &&random_id_);

  static const std::int32_t ID = 252261477;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class messages_invitedUsers;

class messages_createChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  array<object_ptr<InputUser>> users_;
  string title_;
  int32 ttl_period_;
  enum Flags : std::int32_t { TTL_PERIOD_MASK = 1 };
  mutable int32 var0;

  messages_createChat(int32 flags_, array<object_ptr<InputUser>> &&users_, string const &title_, int32 ttl_period_);

  static const std::int32_t ID = -1831936556;

  using ReturnType = object_ptr<messages_invitedUsers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_deleteChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;

  explicit messages_deleteChat(int64 chat_id_);

  static const std::int32_t ID = 1540419152;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class Updates;

class messages_deleteChatUser final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool revoke_history_;
  int64 chat_id_;
  object_ptr<InputUser> user_id_;
  enum Flags : std::int32_t { REVOKE_HISTORY_MASK = 1 };
  mutable int32 var0;

  messages_deleteChatUser(int32 flags_, bool revoke_history_, int64 chat_id_, object_ptr<InputUser> &&user_id_);

  static const std::int32_t ID = -1575461717;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_deleteExportedChatInvite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  string link_;

  messages_deleteExportedChatInvite(object_ptr<InputPeer> &&peer_, string const &link_);

  static const std::int32_t ID = -731601877;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Updates;

class messages_deleteFactCheck final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;

  messages_deleteFactCheck(object_ptr<InputPeer> &&peer_, int32 msg_id_);

  static const std::int32_t ID = -774204404;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_affectedHistory;

class messages_deleteHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool just_clear_;
  bool revoke_;
  object_ptr<InputPeer> peer_;
  int32 max_id_;
  int32 min_date_;
  int32 max_date_;
  enum Flags : std::int32_t { JUST_CLEAR_MASK = 1, REVOKE_MASK = 2, MIN_DATE_MASK = 4, MAX_DATE_MASK = 8 };
  mutable int32 var0;

  messages_deleteHistory(int32 flags_, bool just_clear_, bool revoke_, object_ptr<InputPeer> &&peer_, int32 max_id_, int32 min_date_, int32 max_date_);

  static const std::int32_t ID = -1332768214;

  using ReturnType = object_ptr<messages_affectedHistory>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_affectedMessages;

class messages_deleteMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool revoke_;
  array<int32> id_;
  enum Flags : std::int32_t { REVOKE_MASK = 1 };
  mutable int32 var0;

  messages_deleteMessages(int32 flags_, bool revoke_, array<int32> &&id_);

  static const std::int32_t ID = -443640366;

  using ReturnType = object_ptr<messages_affectedMessages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_affectedFoundMessages;

class messages_deletePhoneCallHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool revoke_;
  enum Flags : std::int32_t { REVOKE_MASK = 1 };
  mutable int32 var0;

  messages_deletePhoneCallHistory(int32 flags_, bool revoke_);

  static const std::int32_t ID = -104078327;

  using ReturnType = object_ptr<messages_affectedFoundMessages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Updates;

class messages_deleteQuickReplyMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  array<int32> id_;

  messages_deleteQuickReplyMessages(int32 shortcut_id_, array<int32> &&id_);

  static const std::int32_t ID = -519706352;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_deleteQuickReplyShortcut final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;

  explicit messages_deleteQuickReplyShortcut(int32 shortcut_id_);

  static const std::int32_t ID = 1019234112;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class InputUser;

class messages_deleteRevokedExportedChatInvites final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  object_ptr<InputUser> admin_id_;

  messages_deleteRevokedExportedChatInvites(object_ptr<InputPeer> &&peer_, object_ptr<InputUser> &&admin_id_);

  static const std::int32_t ID = 1452833749;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_affectedHistory;

class messages_deleteSavedHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputPeer> peer_;
  int32 max_id_;
  int32 min_date_;
  int32 max_date_;
  enum Flags : std::int32_t { MIN_DATE_MASK = 4, MAX_DATE_MASK = 8 };
  mutable int32 var0;

  messages_deleteSavedHistory(int32 flags_, object_ptr<InputPeer> &&peer_, int32 max_id_, int32 min_date_, int32 max_date_);

  static const std::int32_t ID = 1855459371;

  using ReturnType = object_ptr<messages_affectedHistory>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Updates;

class messages_deleteScheduledMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  array<int32> id_;

  messages_deleteScheduledMessages(object_ptr<InputPeer> &&peer_, array<int32> &&id_);

  static const std::int32_t ID = 1504586518;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_discardEncryption final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool delete_history_;
  int32 chat_id_;
  enum Flags : std::int32_t { DELETE_HISTORY_MASK = 1 };
  mutable int32 var0;

  messages_discardEncryption(int32 flags_, bool delete_history_, int32 chat_id_);

  static const std::int32_t ID = -208425312;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_editChatAbout final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  string about_;

  messages_editChatAbout(object_ptr<InputPeer> &&peer_, string const &about_);

  static const std::int32_t ID = -554301545;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class messages_editChatAdmin final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;
  object_ptr<InputUser> user_id_;
  bool is_admin_;

  messages_editChatAdmin(int64 chat_id_, object_ptr<InputUser> &&user_id_, bool is_admin_);

  static const std::int32_t ID = -1470377534;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Updates;

class chatBannedRights;

class messages_editChatDefaultBannedRights final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  object_ptr<chatBannedRights> banned_rights_;

  messages_editChatDefaultBannedRights(object_ptr<InputPeer> &&peer_, object_ptr<chatBannedRights> &&banned_rights_);

  static const std::int32_t ID = -1517917375;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputChatPhoto;

class Updates;

class messages_editChatPhoto final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;
  object_ptr<InputChatPhoto> photo_;

  messages_editChatPhoto(int64 chat_id_, object_ptr<InputChatPhoto> &&photo_);

  static const std::int32_t ID = 903730804;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Updates;

class messages_editChatTitle final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;
  string title_;

  messages_editChatTitle(int64 chat_id_, string const &title_);

  static const std::int32_t ID = 1937260541;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_ExportedChatInvite;

class messages_editExportedChatInvite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool revoked_;
  object_ptr<InputPeer> peer_;
  string link_;
  int32 expire_date_;
  int32 usage_limit_;
  bool request_needed_;
  string title_;
  enum Flags : std::int32_t { REVOKED_MASK = 4, EXPIRE_DATE_MASK = 1, USAGE_LIMIT_MASK = 2, REQUEST_NEEDED_MASK = 8, TITLE_MASK = 16 };
  mutable int32 var0;

  messages_editExportedChatInvite(int32 flags_, bool revoked_, object_ptr<InputPeer> &&peer_, string const &link_, int32 expire_date_, int32 usage_limit_, bool request_needed_, string const &title_);

  static const std::int32_t ID = -1110823051;

  using ReturnType = object_ptr<messages_ExportedChatInvite>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Updates;

class textWithEntities;

class messages_editFactCheck final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;
  object_ptr<textWithEntities> text_;

  messages_editFactCheck(object_ptr<InputPeer> &&peer_, int32 msg_id_, object_ptr<textWithEntities> &&text_);

  static const std::int32_t ID = 92925557;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputBotInlineMessageID;

class InputMedia;

class MessageEntity;

class ReplyMarkup;

class messages_editInlineBotMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool no_webpage_;
  bool invert_media_;
  object_ptr<InputBotInlineMessageID> id_;
  string message_;
  object_ptr<InputMedia> media_;
  object_ptr<ReplyMarkup> reply_markup_;
  array<object_ptr<MessageEntity>> entities_;
  enum Flags : std::int32_t { NO_WEBPAGE_MASK = 2, INVERT_MEDIA_MASK = 65536, MESSAGE_MASK = 2048, MEDIA_MASK = 16384, REPLY_MARKUP_MASK = 4, ENTITIES_MASK = 8 };
  mutable int32 var0;

  messages_editInlineBotMessage(int32 flags_, bool no_webpage_, bool invert_media_, object_ptr<InputBotInlineMessageID> &&id_, string const &message_, object_ptr<InputMedia> &&media_, object_ptr<ReplyMarkup> &&reply_markup_, array<object_ptr<MessageEntity>> &&entities_);

  static const std::int32_t ID = -2091549254;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputMedia;

class InputPeer;

class MessageEntity;

class ReplyMarkup;

class Updates;

class messages_editMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool no_webpage_;
  bool invert_media_;
  object_ptr<InputPeer> peer_;
  int32 id_;
  string message_;
  object_ptr<InputMedia> media_;
  object_ptr<ReplyMarkup> reply_markup_;
  array<object_ptr<MessageEntity>> entities_;
  int32 schedule_date_;
  int32 quick_reply_shortcut_id_;
  enum Flags : std::int32_t { NO_WEBPAGE_MASK = 2, INVERT_MEDIA_MASK = 65536, MESSAGE_MASK = 2048, MEDIA_MASK = 16384, REPLY_MARKUP_MASK = 4, ENTITIES_MASK = 8, SCHEDULE_DATE_MASK = 32768, QUICK_REPLY_SHORTCUT_ID_MASK = 131072 };
  mutable int32 var0;

  messages_editMessage(int32 flags_, bool no_webpage_, bool invert_media_, object_ptr<InputPeer> &&peer_, int32 id_, string const &message_, object_ptr<InputMedia> &&media_, object_ptr<ReplyMarkup> &&reply_markup_, array<object_ptr<MessageEntity>> &&entities_, int32 schedule_date_, int32 quick_reply_shortcut_id_);

  static const std::int32_t ID = -539934715;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_editQuickReplyShortcut final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  string shortcut_;

  messages_editQuickReplyShortcut(int32 shortcut_id_, string const &shortcut_);

  static const std::int32_t ID = 1543519471;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class ExportedChatInvite;

class InputPeer;

class starsSubscriptionPricing;

class messages_exportChatInvite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool legacy_revoke_permanent_;
  bool request_needed_;
  object_ptr<InputPeer> peer_;
  int32 expire_date_;
  int32 usage_limit_;
  string title_;
  object_ptr<starsSubscriptionPricing> subscription_pricing_;
  enum Flags : std::int32_t { LEGACY_REVOKE_PERMANENT_MASK = 4, REQUEST_NEEDED_MASK = 8, EXPIRE_DATE_MASK = 1, USAGE_LIMIT_MASK = 2, TITLE_MASK = 16, SUBSCRIPTION_PRICING_MASK = 32 };
  mutable int32 var0;

  messages_exportChatInvite(int32 flags_, bool legacy_revoke_permanent_, bool request_needed_, object_ptr<InputPeer> &&peer_, int32 expire_date_, int32 usage_limit_, string const &title_, object_ptr<starsSubscriptionPricing> &&subscription_pricing_);

  static const std::int32_t ID = -1537876336;

  using ReturnType = object_ptr<ExportedChatInvite>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputDocument;

class messages_faveSticker final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputDocument> id_;
  bool unfave_;

  messages_faveSticker(object_ptr<InputDocument> &&id_, bool unfave_);

  static const std::int32_t ID = -1174420133;

  using ReturnType = bool;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class InputQuickReplyShortcut;

class Updates;

class messages_forwardMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool silent_;
  bool background_;
  bool with_my_score_;
  bool drop_author_;
  bool drop_media_captions_;
  bool noforwards_;
  bool allow_paid_floodskip_;
  object_ptr<InputPeer> from_peer_;
  array<int32> id_;
  array<int64> random_id_;
  object_ptr<InputPeer> to_peer_;
  int32 top_msg_id_;
  int32 schedule_date_;
  object_ptr<InputPeer> send_as_;
  object_ptr<InputQuickReplyShortcut> quick_reply_shortcut_;
  int32 video_timestamp_;
  enum Flags : std::int32_t { SILENT_MASK = 32, BACKGROUND_MASK = 64, WITH_MY_SCORE_MASK = 256, DROP_AUTHOR_MASK = 2048, DROP_MEDIA_CAPTIONS_MASK = 4096, NOFORWARDS_MASK = 16384, ALLOW_PAID_FLOODSKIP_MASK = 524288, TOP_MSG_ID_MASK = 512, SCHEDULE_DATE_MASK = 1024, SEND_AS_MASK = 8192, QUICK_REPLY_SHORTCUT_MASK = 131072, VIDEO_TIMESTAMP_MASK = 1048576 };
  mutable int32 var0;

  messages_forwardMessages(int32 flags_, bool silent_, bool background_, bool with_my_score_, bool drop_author_, bool drop_media_captions_, bool noforwards_, bool allow_paid_floodskip_, object_ptr<InputPeer> &&from_peer_, array<int32> &&id_, array<int64> &&random_id_, object_ptr<InputPeer> &&to_peer_, int32 top_msg_id_, int32 schedule_date_, object_ptr<InputPeer> &&send_as_, object_ptr<InputQuickReplyShortcut> &&quick_reply_shortcut_, int32 video_timestamp_);

  static const std::int32_t ID = 1836374536;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_chatAdminsWithInvites;

class messages_getAdminsWithInvites final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit messages_getAdminsWithInvites(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = 958457583;

  using ReturnType = object_ptr<messages_chatAdminsWithInvites>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Updates;

class messages_getAllDrafts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1782549861;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_AllStickers;

class messages_getAllStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit messages_getAllStickers(int64 hash_);

  static const std::int32_t ID = -1197432408;

  using ReturnType = object_ptr<messages_AllStickers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_archivedStickers;

class messages_getArchivedStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool masks_;
  bool emojis_;
  int64 offset_id_;
  int32 limit_;
  enum Flags : std::int32_t { MASKS_MASK = 1, EMOJIS_MASK = 2 };
  mutable int32 var0;

  messages_getArchivedStickers(int32 flags_, bool masks_, bool emojis_, int64 offset_id_, int32 limit_);

  static const std::int32_t ID = 1475442322;

  using ReturnType = object_ptr<messages_archivedStickers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class attachMenuBotsBot;

class messages_getAttachMenuBot final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;

  explicit messages_getAttachMenuBot(object_ptr<InputUser> &&bot_);

  static const std::int32_t ID = 1998676370;

  using ReturnType = object_ptr<attachMenuBotsBot>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class AttachMenuBots;

class messages_getAttachMenuBots final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit messages_getAttachMenuBots(int64 hash_);

  static const std::int32_t ID = 385663691;

  using ReturnType = object_ptr<AttachMenuBots>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputStickeredMedia;

class StickerSetCovered;

class messages_getAttachedStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputStickeredMedia> media_;

  explicit messages_getAttachedStickers(object_ptr<InputStickeredMedia> &&media_);

  static const std::int32_t ID = -866424884;

  using ReturnType = array<object_ptr<StickerSetCovered>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_AvailableEffects;

class messages_getAvailableEffects final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit messages_getAvailableEffects(int32 hash_);

  static const std::int32_t ID = -559805895;

  using ReturnType = object_ptr<messages_AvailableEffects>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_AvailableReactions;

class messages_getAvailableReactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit messages_getAvailableReactions(int32 hash_);

  static const std::int32_t ID = 417243308;

  using ReturnType = object_ptr<messages_AvailableReactions>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputBotApp;

class messages_botApp;

class messages_getBotApp final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputBotApp> app_;
  int64 hash_;

  messages_getBotApp(object_ptr<InputBotApp> &&app_, int64 hash_);

  static const std::int32_t ID = 889046467;

  using ReturnType = object_ptr<messages_botApp>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputCheckPasswordSRP;

class InputPeer;

class messages_botCallbackAnswer;

class messages_getBotCallbackAnswer final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool game_;
  object_ptr<InputPeer> peer_;
  int32 msg_id_;
  bytes data_;
  object_ptr<InputCheckPasswordSRP> password_;
  enum Flags : std::int32_t { GAME_MASK = 2, DATA_MASK = 1, PASSWORD_MASK = 4 };
  mutable int32 var0;

  messages_getBotCallbackAnswer(int32 flags_, bool game_, object_ptr<InputPeer> &&peer_, int32 msg_id_, bytes &&data_, object_ptr<InputCheckPasswordSRP> &&password_);

  static const std::int32_t ID = -1824339449;

  using ReturnType = object_ptr<messages_botCallbackAnswer>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class InputUser;

class messages_chatInviteImporters;

class messages_getChatInviteImporters final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool requested_;
  bool subscription_expired_;
  object_ptr<InputPeer> peer_;
  string link_;
  string q_;
  int32 offset_date_;
  object_ptr<InputUser> offset_user_;
  int32 limit_;
  enum Flags : std::int32_t { REQUESTED_MASK = 1, SUBSCRIPTION_EXPIRED_MASK = 8, LINK_MASK = 2, Q_MASK = 4 };
  mutable int32 var0;

  messages_getChatInviteImporters(int32 flags_, bool requested_, bool subscription_expired_, object_ptr<InputPeer> &&peer_, string const &link_, string const &q_, int32 offset_date_, object_ptr<InputUser> &&offset_user_, int32 limit_);

  static const std::int32_t ID = -553329330;

  using ReturnType = object_ptr<messages_chatInviteImporters>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_Chats;

class messages_getChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> id_;

  explicit messages_getChats(array<int64> &&id_);

  static const std::int32_t ID = 1240027791;

  using ReturnType = object_ptr<messages_Chats>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class messages_Chats;

class messages_getCommonChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> user_id_;
  int64 max_id_;
  int32 limit_;

  messages_getCommonChats(object_ptr<InputUser> &&user_id_, int64 max_id_, int32 limit_);

  static const std::int32_t ID = -468934396;

  using ReturnType = object_ptr<messages_Chats>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Document;

class messages_getCustomEmojiDocuments final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> document_id_;

  explicit messages_getCustomEmojiDocuments(array<int64> &&document_id_);

  static const std::int32_t ID = -643100844;

  using ReturnType = array<object_ptr<Document>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class defaultHistoryTTL;

class messages_getDefaultHistoryTTL final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1703637384;

  using ReturnType = object_ptr<defaultHistoryTTL>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_Reactions;

class messages_getDefaultTagReactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit messages_getDefaultTagReactions(int64 hash_);

  static const std::int32_t ID = -1107741656;

  using ReturnType = object_ptr<messages_Reactions>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_DhConfig;

class messages_getDhConfig final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 version_;
  int32 random_length_;

  messages_getDhConfig(int32 version_, int32 random_length_);

  static const std::int32_t ID = 651135312;

  using ReturnType = object_ptr<messages_DhConfig>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_dialogFilters;

class messages_getDialogFilters final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -271283063;

  using ReturnType = object_ptr<messages_dialogFilters>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class DialogPeer;

class messages_getDialogUnreadMarks final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 585256482;

  using ReturnType = array<object_ptr<DialogPeer>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_Dialogs;

class messages_getDialogs final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool exclude_pinned_;
  int32 folder_id_;
  int32 offset_date_;
  int32 offset_id_;
  object_ptr<InputPeer> offset_peer_;
  int32 limit_;
  int64 hash_;
  enum Flags : std::int32_t { EXCLUDE_PINNED_MASK = 1, FOLDER_ID_MASK = 2 };
  mutable int32 var0;

  messages_getDialogs(int32 flags_, bool exclude_pinned_, int32 folder_id_, int32 offset_date_, int32 offset_id_, object_ptr<InputPeer> &&offset_peer_, int32 limit_, int64 hash_);

  static const std::int32_t ID = -1594569905;

  using ReturnType = object_ptr<messages_Dialogs>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_discussionMessage;

class messages_getDiscussionMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;

  messages_getDiscussionMessage(object_ptr<InputPeer> &&peer_, int32 msg_id_);

  static const std::int32_t ID = 1147761405;

  using ReturnType = object_ptr<messages_discussionMessage>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Document;

class messages_getDocumentByHash final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes sha256_;
  int64 size_;
  string mime_type_;

  messages_getDocumentByHash(bytes &&sha256_, int64 size_, string const &mime_type_);

  static const std::int32_t ID = -1309538785;

  using ReturnType = object_ptr<Document>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_EmojiGroups;

class messages_getEmojiGroups final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit messages_getEmojiGroups(int32 hash_);

  static const std::int32_t ID = 1955122779;

  using ReturnType = object_ptr<messages_EmojiGroups>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class emojiKeywordsDifference;

class messages_getEmojiKeywords final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_code_;

  explicit messages_getEmojiKeywords(string const &lang_code_);

  static const std::int32_t ID = 899735650;

  using ReturnType = object_ptr<emojiKeywordsDifference>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class emojiKeywordsDifference;

class messages_getEmojiKeywordsDifference final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_code_;
  int32 from_version_;

  messages_getEmojiKeywordsDifference(string const &lang_code_, int32 from_version_);

  static const std::int32_t ID = 352892591;

  using ReturnType = object_ptr<emojiKeywordsDifference>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class emojiLanguage;

class messages_getEmojiKeywordsLanguages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> lang_codes_;

  explicit messages_getEmojiKeywordsLanguages(array<string> &&lang_codes_);

  static const std::int32_t ID = 1318675378;

  using ReturnType = array<object_ptr<emojiLanguage>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_EmojiGroups;

class messages_getEmojiProfilePhotoGroups final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit messages_getEmojiProfilePhotoGroups(int32 hash_);

  static const std::int32_t ID = 564480243;

  using ReturnType = object_ptr<messages_EmojiGroups>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_EmojiGroups;

class messages_getEmojiStatusGroups final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit messages_getEmojiStatusGroups(int32 hash_);

  static const std::int32_t ID = 785209037;

  using ReturnType = object_ptr<messages_EmojiGroups>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_EmojiGroups;

class messages_getEmojiStickerGroups final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 hash_;

  explicit messages_getEmojiStickerGroups(int32 hash_);

  static const std::int32_t ID = 500711669;

  using ReturnType = object_ptr<messages_EmojiGroups>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_AllStickers;

class messages_getEmojiStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit messages_getEmojiStickers(int64 hash_);

  static const std::int32_t ID = -67329649;

  using ReturnType = object_ptr<messages_AllStickers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class emojiURL;

class messages_getEmojiURL final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string lang_code_;

  explicit messages_getEmojiURL(string const &lang_code_);

  static const std::int32_t ID = -709817306;

  using ReturnType = object_ptr<emojiURL>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_ExportedChatInvite;

class messages_getExportedChatInvite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  string link_;

  messages_getExportedChatInvite(object_ptr<InputPeer> &&peer_, string const &link_);

  static const std::int32_t ID = 1937010524;

  using ReturnType = object_ptr<messages_ExportedChatInvite>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class InputUser;

class messages_exportedChatInvites;

class messages_getExportedChatInvites final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool revoked_;
  object_ptr<InputPeer> peer_;
  object_ptr<InputUser> admin_id_;
  int32 offset_date_;
  string offset_link_;
  int32 limit_;
  enum Flags : std::int32_t { REVOKED_MASK = 8, OFFSET_DATE_MASK = 4, OFFSET_LINK_MASK = 4 };
  mutable int32 var0;

  messages_getExportedChatInvites(int32 flags_, bool revoked_, object_ptr<InputPeer> &&peer_, object_ptr<InputUser> &&admin_id_, int32 offset_date_, string const &offset_link_, int32 limit_);

  static const std::int32_t ID = -1565154314;

  using ReturnType = object_ptr<messages_exportedChatInvites>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Updates;

class messages_getExtendedMedia final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  array<int32> id_;

  messages_getExtendedMedia(object_ptr<InputPeer> &&peer_, array<int32> &&id_);

  static const std::int32_t ID = -2064119788;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class factCheck;

class messages_getFactCheck final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  array<int32> msg_id_;

  messages_getFactCheck(object_ptr<InputPeer> &&peer_, array<int32> &&msg_id_);

  static const std::int32_t ID = -1177696786;

  using ReturnType = array<object_ptr<factCheck>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_FavedStickers;

class messages_getFavedStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit messages_getFavedStickers(int64 hash_);

  static const std::int32_t ID = 82946729;

  using ReturnType = object_ptr<messages_FavedStickers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_FeaturedStickers;

class messages_getFeaturedEmojiStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit messages_getFeaturedEmojiStickers(int64 hash_);

  static const std::int32_t ID = 248473398;

  using ReturnType = object_ptr<messages_FeaturedStickers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_FeaturedStickers;

class messages_getFeaturedStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit messages_getFeaturedStickers(int64 hash_);

  static const std::int32_t ID = 1685588756;

  using ReturnType = object_ptr<messages_FeaturedStickers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_chatFull;

class messages_getFullChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_id_;

  explicit messages_getFullChat(int64 chat_id_);

  static const std::int32_t ID = -1364194508;

  using ReturnType = object_ptr<messages_chatFull>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class InputUser;

class messages_highScores;

class messages_getGameHighScores final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 id_;
  object_ptr<InputUser> user_id_;

  messages_getGameHighScores(object_ptr<InputPeer> &&peer_, int32 id_, object_ptr<InputUser> &&user_id_);

  static const std::int32_t ID = -400399203;

  using ReturnType = object_ptr<messages_highScores>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_Messages;

class messages_getHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 offset_id_;
  int32 offset_date_;
  int32 add_offset_;
  int32 limit_;
  int32 max_id_;
  int32 min_id_;
  int64 hash_;

  messages_getHistory(object_ptr<InputPeer> &&peer_, int32 offset_id_, int32 offset_date_, int32 add_offset_, int32 limit_, int32 max_id_, int32 min_id_, int64 hash_);

  static const std::int32_t ID = 1143203525;

  using ReturnType = object_ptr<messages_Messages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputGeoPoint;

class InputPeer;

class InputUser;

class messages_botResults;

class messages_getInlineBotResults final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputUser> bot_;
  object_ptr<InputPeer> peer_;
  object_ptr<InputGeoPoint> geo_point_;
  string query_;
  string offset_;
  enum Flags : std::int32_t { GEO_POINT_MASK = 1 };
  mutable int32 var0;

  messages_getInlineBotResults(int32 flags_, object_ptr<InputUser> &&bot_, object_ptr<InputPeer> &&peer_, object_ptr<InputGeoPoint> &&geo_point_, string const &query_, string const &offset_);

  static const std::int32_t ID = 1364105629;

  using ReturnType = object_ptr<messages_botResults>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputBotInlineMessageID;

class InputUser;

class messages_highScores;

class messages_getInlineGameHighScores final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputBotInlineMessageID> id_;
  object_ptr<InputUser> user_id_;

  messages_getInlineGameHighScores(object_ptr<InputBotInlineMessageID> &&id_, object_ptr<InputUser> &&user_id_);

  static const std::int32_t ID = 258170395;

  using ReturnType = object_ptr<messages_highScores>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_AllStickers;

class messages_getMaskStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit messages_getMaskStickers(int64 hash_);

  static const std::int32_t ID = 1678738104;

  using ReturnType = object_ptr<messages_AllStickers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_messageEditData;

class messages_getMessageEditData final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 id_;

  messages_getMessageEditData(object_ptr<InputPeer> &&peer_, int32 id_);

  static const std::int32_t ID = -39416522;

  using ReturnType = object_ptr<messages_messageEditData>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Reaction;

class messages_messageReactionsList;

class messages_getMessageReactionsList final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputPeer> peer_;
  int32 id_;
  object_ptr<Reaction> reaction_;
  string offset_;
  int32 limit_;
  enum Flags : std::int32_t { REACTION_MASK = 1, OFFSET_MASK = 2 };
  mutable int32 var0;

  messages_getMessageReactionsList(int32 flags_, object_ptr<InputPeer> &&peer_, int32 id_, object_ptr<Reaction> &&reaction_, string const &offset_, int32 limit_);

  static const std::int32_t ID = 1176190792;

  using ReturnType = object_ptr<messages_messageReactionsList>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class readParticipantDate;

class messages_getMessageReadParticipants final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;

  messages_getMessageReadParticipants(object_ptr<InputPeer> &&peer_, int32 msg_id_);

  static const std::int32_t ID = 834782287;

  using ReturnType = array<object_ptr<readParticipantDate>>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputMessage;

class messages_Messages;

class messages_getMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<InputMessage>> id_;

  explicit messages_getMessages(array<object_ptr<InputMessage>> &&id_);

  static const std::int32_t ID = 1673946374;

  using ReturnType = object_ptr<messages_Messages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Updates;

class messages_getMessagesReactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  array<int32> id_;

  messages_getMessagesReactions(object_ptr<InputPeer> &&peer_, array<int32> &&id_);

  static const std::int32_t ID = -1950707482;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_messageViews;

class messages_getMessagesViews final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  array<int32> id_;
  bool increment_;

  messages_getMessagesViews(object_ptr<InputPeer> &&peer_, array<int32> &&id_, bool increment_);

  static const std::int32_t ID = 1468322785;

  using ReturnType = object_ptr<messages_messageViews>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_myStickers;

class messages_getMyStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 offset_id_;
  int32 limit_;

  messages_getMyStickers(int64 offset_id_, int32 limit_);

  static const std::int32_t ID = -793386500;

  using ReturnType = object_ptr<messages_myStickers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_FeaturedStickers;

class messages_getOldFeaturedStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 limit_;
  int64 hash_;

  messages_getOldFeaturedStickers(int32 offset_, int32 limit_, int64 hash_);

  static const std::int32_t ID = 2127598753;

  using ReturnType = object_ptr<messages_FeaturedStickers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class chatOnlines;

class messages_getOnlines final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit messages_getOnlines(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = 1848369232;

  using ReturnType = object_ptr<chatOnlines>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class outboxReadDate;

class messages_getOutboxReadDate final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;

  messages_getOutboxReadDate(object_ptr<InputPeer> &&peer_, int32 msg_id_);

  static const std::int32_t ID = -1941176739;

  using ReturnType = object_ptr<outboxReadDate>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class Updates;

class messages_getPaidReactionPrivacy final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = 1193563562;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputDialogPeer;

class messages_peerDialogs;

class messages_getPeerDialogs final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<InputDialogPeer>> peers_;

  explicit messages_getPeerDialogs(array<object_ptr<InputDialogPeer>> &&peers_);

  static const std::int32_t ID = -462373635;

  using ReturnType = object_ptr<messages_peerDialogs>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_peerSettings;

class messages_getPeerSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;

  explicit messages_getPeerSettings(object_ptr<InputPeer> &&peer_);

  static const std::int32_t ID = -270948702;

  using ReturnType = object_ptr<messages_peerSettings>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_peerDialogs;

class messages_getPinnedDialogs final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 folder_id_;

  explicit messages_getPinnedDialogs(int32 folder_id_);

  static const std::int32_t ID = -692498958;

  using ReturnType = object_ptr<messages_peerDialogs>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_SavedDialogs;

class messages_getPinnedSavedDialogs final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  static const std::int32_t ID = -700607264;

  using ReturnType = object_ptr<messages_SavedDialogs>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class Updates;

class messages_getPollResults final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;

  messages_getPollResults(object_ptr<InputPeer> &&peer_, int32 msg_id_);

  static const std::int32_t ID = 1941660731;

  using ReturnType = object_ptr<Updates>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_votesList;

class messages_getPollVotes final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputPeer> peer_;
  int32 id_;
  bytes option_;
  string offset_;
  int32 limit_;
  enum Flags : std::int32_t { OPTION_MASK = 1, OFFSET_MASK = 2 };
  mutable int32 var0;

  messages_getPollVotes(int32 flags_, object_ptr<InputPeer> &&peer_, int32 id_, bytes &&option_, string const &offset_, int32 limit_);

  static const std::int32_t ID = -1200736242;

  using ReturnType = object_ptr<messages_votesList>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputUser;

class messages_preparedInlineMessage;

class messages_getPreparedInlineMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputUser> bot_;
  string id_;

  messages_getPreparedInlineMessage(object_ptr<InputUser> &&bot_, string const &id_);

  static const std::int32_t ID = -2055291464;

  using ReturnType = object_ptr<messages_preparedInlineMessage>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_QuickReplies;

class messages_getQuickReplies final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit messages_getQuickReplies(int64 hash_);

  static const std::int32_t ID = -729550168;

  using ReturnType = object_ptr<messages_QuickReplies>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_Messages;

class messages_getQuickReplyMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  int32 shortcut_id_;
  array<int32> id_;
  int64 hash_;
  enum Flags : std::int32_t { ID_MASK = 1 };
  mutable int32 var0;

  messages_getQuickReplyMessages(int32 flags_, int32 shortcut_id_, array<int32> &&id_, int64 hash_);

  static const std::int32_t ID = -1801153085;

  using ReturnType = object_ptr<messages_Messages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_Messages;

class messages_getRecentLocations final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 limit_;
  int64 hash_;

  messages_getRecentLocations(object_ptr<InputPeer> &&peer_, int32 limit_, int64 hash_);

  static const std::int32_t ID = 1881817312;

  using ReturnType = object_ptr<messages_Messages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_Reactions;

class messages_getRecentReactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 limit_;
  int64 hash_;

  messages_getRecentReactions(int32 limit_, int64 hash_);

  static const std::int32_t ID = 960896434;

  using ReturnType = object_ptr<messages_Reactions>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_RecentStickers;

class messages_getRecentStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool attached_;
  int64 hash_;
  enum Flags : std::int32_t { ATTACHED_MASK = 1 };
  mutable int32 var0;

  messages_getRecentStickers(int32 flags_, bool attached_, int64 hash_);

  static const std::int32_t ID = -1649852357;

  using ReturnType = object_ptr<messages_RecentStickers>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_Messages;

class messages_getReplies final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 msg_id_;
  int32 offset_id_;
  int32 offset_date_;
  int32 add_offset_;
  int32 limit_;
  int32 max_id_;
  int32 min_id_;
  int64 hash_;

  messages_getReplies(object_ptr<InputPeer> &&peer_, int32 msg_id_, int32 offset_id_, int32 offset_date_, int32 add_offset_, int32 limit_, int32 max_id_, int32 min_id_, int64 hash_);

  static const std::int32_t ID = 584962828;

  using ReturnType = object_ptr<messages_Messages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_SavedDialogs;

class messages_getSavedDialogs final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  bool exclude_pinned_;
  int32 offset_date_;
  int32 offset_id_;
  object_ptr<InputPeer> offset_peer_;
  int32 limit_;
  int64 hash_;
  enum Flags : std::int32_t { EXCLUDE_PINNED_MASK = 1 };
  mutable int32 var0;

  messages_getSavedDialogs(int32 flags_, bool exclude_pinned_, int32 offset_date_, int32 offset_id_, object_ptr<InputPeer> &&offset_peer_, int32 limit_, int64 hash_);

  static const std::int32_t ID = 1401016858;

  using ReturnType = object_ptr<messages_SavedDialogs>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class messages_SavedGifs;

class messages_getSavedGifs final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 hash_;

  explicit messages_getSavedGifs(int64 hash_);

  static const std::int32_t ID = 1559270965;

  using ReturnType = object_ptr<messages_SavedGifs>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_Messages;

class messages_getSavedHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int32 offset_id_;
  int32 offset_date_;
  int32 add_offset_;
  int32 limit_;
  int32 max_id_;
  int32 min_id_;
  int64 hash_;

  messages_getSavedHistory(object_ptr<InputPeer> &&peer_, int32 offset_id_, int32 offset_date_, int32 add_offset_, int32 limit_, int32 max_id_, int32 min_id_, int64 hash_);

  static const std::int32_t ID = 1033519437;

  using ReturnType = object_ptr<messages_Messages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_SavedReactionTags;

class messages_getSavedReactionTags final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputPeer> peer_;
  int64 hash_;
  enum Flags : std::int32_t { PEER_MASK = 1 };
  mutable int32 var0;

  messages_getSavedReactionTags(int32 flags_, object_ptr<InputPeer> &&peer_, int64 hash_);

  static const std::int32_t ID = 909631579;

  using ReturnType = object_ptr<messages_SavedReactionTags>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_Messages;

class messages_getScheduledHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  int64 hash_;

  messages_getScheduledHistory(object_ptr<InputPeer> &&peer_, int64 hash_);

  static const std::int32_t ID = -183077365;

  using ReturnType = object_ptr<messages_Messages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class messages_Messages;

class messages_getScheduledMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPeer> peer_;
  array<int32> id_;

  messages_getScheduledMessages(object_ptr<InputPeer> &&peer_, array<int32> &&id_);

  static const std::int32_t ID = -1111817116;

  using ReturnType = object_ptr<messages_Messages>;

  void store(TlStorerCalcLength &s) const final;

  void store(TlStorerUnsafe &s) const final;

  void store(TlStorerToString &s, const char *field_name) const final;

  static ReturnType fetch_result(TlBufferParser &p);
};

class InputPeer;

class MessagesFilter;

class messages_searchCounter;

class messages_getSearchCounters final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 flags_;
  object_ptr<InputPeer> peer_;
  object_ptr<InputPeer> saved_peer_id_;
  int32 top_msg_id_;
  array<object_ptr<MessagesFilter>> filters_;
  enum Flags : std::int32_t { SAVED_PEER_ID_MASK = 4, TOP_MSG_ID_M