#include "td_api.h"

#include "td/utils/common.h"
#include "td/utils/format.h"
#include "td/utils/logging.h"
#include "td/utils/SliceBuilder.h"
#include "td/utils/tl_parsers.h"
#include "td/utils/tl_storers.h"
#include "td/utils/TlStorerToString.h"

namespace td {
namespace td_api {

std::string to_string(const BaseObject &value) {
  TlStorerToString storer;
  value.store(storer, "");
  return storer.move_as_string();
}

accentColor::accentColor()
  : id_()
  , built_in_accent_color_id_()
  , light_theme_colors_()
  , dark_theme_colors_()
  , min_channel_chat_boost_level_()
{}

accentColor::accentColor(int32 id_, int32 built_in_accent_color_id_, array<int32> &&light_theme_colors_, array<int32> &&dark_theme_colors_, int32 min_channel_chat_boost_level_)
  : id_(id_)
  , built_in_accent_color_id_(built_in_accent_color_id_)
  , light_theme_colors_(std::move(light_theme_colors_))
  , dark_theme_colors_(std::move(dark_theme_colors_))
  , min_channel_chat_boost_level_(min_channel_chat_boost_level_)
{}

const std::int32_t accentColor::ID;

void accentColor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "accentColor");
    s.store_field("id", id_);
    s.store_field("built_in_accent_color_id", built_in_accent_color_id_);
    { s.store_vector_begin("light_theme_colors", light_theme_colors_.size()); for (const auto &_value : light_theme_colors_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("dark_theme_colors", dark_theme_colors_.size()); for (const auto &_value : dark_theme_colors_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("min_channel_chat_boost_level", min_channel_chat_boost_level_);
    s.store_class_end();
  }
}

accountTtl::accountTtl()
  : days_()
{}

accountTtl::accountTtl(int32 days_)
  : days_(days_)
{}

const std::int32_t accountTtl::ID;

void accountTtl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "accountTtl");
    s.store_field("days", days_);
    s.store_class_end();
  }
}

addedReaction::addedReaction()
  : type_()
  , sender_id_()
  , is_outgoing_()
  , date_()
{}

addedReaction::addedReaction(object_ptr<ReactionType> &&type_, object_ptr<MessageSender> &&sender_id_, bool is_outgoing_, int32 date_)
  : type_(std::move(type_))
  , sender_id_(std::move(sender_id_))
  , is_outgoing_(is_outgoing_)
  , date_(date_)
{}

const std::int32_t addedReaction::ID;

void addedReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "addedReaction");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_object_field("sender_id", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_field("is_outgoing", is_outgoing_);
    s.store_field("date", date_);
    s.store_class_end();
  }
}

addedReactions::addedReactions()
  : total_count_()
  , reactions_()
  , next_offset_()
{}

addedReactions::addedReactions(int32 total_count_, array<object_ptr<addedReaction>> &&reactions_, string const &next_offset_)
  : total_count_(total_count_)
  , reactions_(std::move(reactions_))
  , next_offset_(next_offset_)
{}

const std::int32_t addedReactions::ID;

void addedReactions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "addedReactions");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("reactions", reactions_.size()); for (const auto &_value : reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

address::address()
  : country_code_()
  , state_()
  , city_()
  , street_line1_()
  , street_line2_()
  , postal_code_()
{}

address::address(string const &country_code_, string const &state_, string const &city_, string const &street_line1_, string const &street_line2_, string const &postal_code_)
  : country_code_(country_code_)
  , state_(state_)
  , city_(city_)
  , street_line1_(street_line1_)
  , street_line2_(street_line2_)
  , postal_code_(postal_code_)
{}

const std::int32_t address::ID;

void address::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "address");
    s.store_field("country_code", country_code_);
    s.store_field("state", state_);
    s.store_field("city", city_);
    s.store_field("street_line1", street_line1_);
    s.store_field("street_line2", street_line2_);
    s.store_field("postal_code", postal_code_);
    s.store_class_end();
  }
}

affiliateInfo::affiliateInfo()
  : commission_per_mille_()
  , affiliate_chat_id_()
  , star_amount_()
{}

affiliateInfo::affiliateInfo(int32 commission_per_mille_, int53 affiliate_chat_id_, object_ptr<starAmount> &&star_amount_)
  : commission_per_mille_(commission_per_mille_)
  , affiliate_chat_id_(affiliate_chat_id_)
  , star_amount_(std::move(star_amount_))
{}

const std::int32_t affiliateInfo::ID;

void affiliateInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "affiliateInfo");
    s.store_field("commission_per_mille", commission_per_mille_);
    s.store_field("affiliate_chat_id", affiliate_chat_id_);
    s.store_object_field("star_amount", static_cast<const BaseObject *>(star_amount_.get()));
    s.store_class_end();
  }
}

affiliateProgramInfo::affiliateProgramInfo()
  : parameters_()
  , end_date_()
  , daily_revenue_per_user_amount_()
{}

affiliateProgramInfo::affiliateProgramInfo(object_ptr<affiliateProgramParameters> &&parameters_, int32 end_date_, object_ptr<starAmount> &&daily_revenue_per_user_amount_)
  : parameters_(std::move(parameters_))
  , end_date_(end_date_)
  , daily_revenue_per_user_amount_(std::move(daily_revenue_per_user_amount_))
{}

const std::int32_t affiliateProgramInfo::ID;

void affiliateProgramInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "affiliateProgramInfo");
    s.store_object_field("parameters", static_cast<const BaseObject *>(parameters_.get()));
    s.store_field("end_date", end_date_);
    s.store_object_field("daily_revenue_per_user_amount", static_cast<const BaseObject *>(daily_revenue_per_user_amount_.get()));
    s.store_class_end();
  }
}

affiliateProgramParameters::affiliateProgramParameters()
  : commission_per_mille_()
  , month_count_()
{}

affiliateProgramParameters::affiliateProgramParameters(int32 commission_per_mille_, int32 month_count_)
  : commission_per_mille_(commission_per_mille_)
  , month_count_(month_count_)
{}

const std::int32_t affiliateProgramParameters::ID;

void affiliateProgramParameters::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "affiliateProgramParameters");
    s.store_field("commission_per_mille", commission_per_mille_);
    s.store_field("month_count", month_count_);
    s.store_class_end();
  }
}

affiliateProgramSortOrderProfitability::affiliateProgramSortOrderProfitability() {
}

const std::int32_t affiliateProgramSortOrderProfitability::ID;

void affiliateProgramSortOrderProfitability::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "affiliateProgramSortOrderProfitability");
    s.store_class_end();
  }
}

affiliateProgramSortOrderCreationDate::affiliateProgramSortOrderCreationDate() {
}

const std::int32_t affiliateProgramSortOrderCreationDate::ID;

void affiliateProgramSortOrderCreationDate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "affiliateProgramSortOrderCreationDate");
    s.store_class_end();
  }
}

affiliateProgramSortOrderRevenue::affiliateProgramSortOrderRevenue() {
}

const std::int32_t affiliateProgramSortOrderRevenue::ID;

void affiliateProgramSortOrderRevenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "affiliateProgramSortOrderRevenue");
    s.store_class_end();
  }
}

affiliateTypeCurrentUser::affiliateTypeCurrentUser() {
}

const std::int32_t affiliateTypeCurrentUser::ID;

void affiliateTypeCurrentUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "affiliateTypeCurrentUser");
    s.store_class_end();
  }
}

affiliateTypeBot::affiliateTypeBot()
  : user_id_()
{}

affiliateTypeBot::affiliateTypeBot(int53 user_id_)
  : user_id_(user_id_)
{}

const std::int32_t affiliateTypeBot::ID;

void affiliateTypeBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "affiliateTypeBot");
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

affiliateTypeChannel::affiliateTypeChannel()
  : chat_id_()
{}

affiliateTypeChannel::affiliateTypeChannel(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t affiliateTypeChannel::ID;

void affiliateTypeChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "affiliateTypeChannel");
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

alternativeVideo::alternativeVideo()
  : width_()
  , height_()
  , codec_()
  , hls_file_()
  , video_()
{}

alternativeVideo::alternativeVideo(int32 width_, int32 height_, string const &codec_, object_ptr<file> &&hls_file_, object_ptr<file> &&video_)
  : width_(width_)
  , height_(height_)
  , codec_(codec_)
  , hls_file_(std::move(hls_file_))
  , video_(std::move(video_))
{}

const std::int32_t alternativeVideo::ID;

void alternativeVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "alternativeVideo");
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_field("codec", codec_);
    s.store_object_field("hls_file", static_cast<const BaseObject *>(hls_file_.get()));
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_class_end();
  }
}

animatedChatPhoto::animatedChatPhoto()
  : length_()
  , file_()
  , main_frame_timestamp_()
{}

animatedChatPhoto::animatedChatPhoto(int32 length_, object_ptr<file> &&file_, double main_frame_timestamp_)
  : length_(length_)
  , file_(std::move(file_))
  , main_frame_timestamp_(main_frame_timestamp_)
{}

const std::int32_t animatedChatPhoto::ID;

void animatedChatPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "animatedChatPhoto");
    s.store_field("length", length_);
    s.store_object_field("file", static_cast<const BaseObject *>(file_.get()));
    s.store_field("main_frame_timestamp", main_frame_timestamp_);
    s.store_class_end();
  }
}

animatedEmoji::animatedEmoji()
  : sticker_()
  , sticker_width_()
  , sticker_height_()
  , fitzpatrick_type_()
  , sound_()
{}

animatedEmoji::animatedEmoji(object_ptr<sticker> &&sticker_, int32 sticker_width_, int32 sticker_height_, int32 fitzpatrick_type_, object_ptr<file> &&sound_)
  : sticker_(std::move(sticker_))
  , sticker_width_(sticker_width_)
  , sticker_height_(sticker_height_)
  , fitzpatrick_type_(fitzpatrick_type_)
  , sound_(std::move(sound_))
{}

const std::int32_t animatedEmoji::ID;

void animatedEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "animatedEmoji");
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_field("sticker_width", sticker_width_);
    s.store_field("sticker_height", sticker_height_);
    s.store_field("fitzpatrick_type", fitzpatrick_type_);
    s.store_object_field("sound", static_cast<const BaseObject *>(sound_.get()));
    s.store_class_end();
  }
}

animation::animation()
  : duration_()
  , width_()
  , height_()
  , file_name_()
  , mime_type_()
  , has_stickers_()
  , minithumbnail_()
  , thumbnail_()
  , animation_()
{}

animation::animation(int32 duration_, int32 width_, int32 height_, string const &file_name_, string const &mime_type_, bool has_stickers_, object_ptr<minithumbnail> &&minithumbnail_, object_ptr<thumbnail> &&thumbnail_, object_ptr<file> &&animation_)
  : duration_(duration_)
  , width_(width_)
  , height_(height_)
  , file_name_(file_name_)
  , mime_type_(mime_type_)
  , has_stickers_(has_stickers_)
  , minithumbnail_(std::move(minithumbnail_))
  , thumbnail_(std::move(thumbnail_))
  , animation_(std::move(animation_))
{}

const std::int32_t animation::ID;

void animation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "animation");
    s.store_field("duration", duration_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_field("file_name", file_name_);
    s.store_field("mime_type", mime_type_);
    s.store_field("has_stickers", has_stickers_);
    s.store_object_field("minithumbnail", static_cast<const BaseObject *>(minithumbnail_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_class_end();
  }
}

animations::animations()
  : animations_()
{}

animations::animations(array<object_ptr<animation>> &&animations_)
  : animations_(std::move(animations_))
{}

const std::int32_t animations::ID;

void animations::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "animations");
    { s.store_vector_begin("animations", animations_.size()); for (const auto &_value : animations_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

archiveChatListSettings::archiveChatListSettings()
  : archive_and_mute_new_chats_from_unknown_users_()
  , keep_unmuted_chats_archived_()
  , keep_chats_from_folders_archived_()
{}

archiveChatListSettings::archiveChatListSettings(bool archive_and_mute_new_chats_from_unknown_users_, bool keep_unmuted_chats_archived_, bool keep_chats_from_folders_archived_)
  : archive_and_mute_new_chats_from_unknown_users_(archive_and_mute_new_chats_from_unknown_users_)
  , keep_unmuted_chats_archived_(keep_unmuted_chats_archived_)
  , keep_chats_from_folders_archived_(keep_chats_from_folders_archived_)
{}

const std::int32_t archiveChatListSettings::ID;

void archiveChatListSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "archiveChatListSettings");
    s.store_field("archive_and_mute_new_chats_from_unknown_users", archive_and_mute_new_chats_from_unknown_users_);
    s.store_field("keep_unmuted_chats_archived", keep_unmuted_chats_archived_);
    s.store_field("keep_chats_from_folders_archived", keep_chats_from_folders_archived_);
    s.store_class_end();
  }
}

attachmentMenuBot::attachmentMenuBot()
  : bot_user_id_()
  , supports_self_chat_()
  , supports_user_chats_()
  , supports_bot_chats_()
  , supports_group_chats_()
  , supports_channel_chats_()
  , request_write_access_()
  , is_added_()
  , show_in_attachment_menu_()
  , show_in_side_menu_()
  , show_disclaimer_in_side_menu_()
  , name_()
  , name_color_()
  , default_icon_()
  , ios_static_icon_()
  , ios_animated_icon_()
  , ios_side_menu_icon_()
  , android_icon_()
  , android_side_menu_icon_()
  , macos_icon_()
  , macos_side_menu_icon_()
  , icon_color_()
  , web_app_placeholder_()
{}

attachmentMenuBot::attachmentMenuBot(int53 bot_user_id_, bool supports_self_chat_, bool supports_user_chats_, bool supports_bot_chats_, bool supports_group_chats_, bool supports_channel_chats_, bool request_write_access_, bool is_added_, bool show_in_attachment_menu_, bool show_in_side_menu_, bool show_disclaimer_in_side_menu_, string const &name_, object_ptr<attachmentMenuBotColor> &&name_color_, object_ptr<file> &&default_icon_, object_ptr<file> &&ios_static_icon_, object_ptr<file> &&ios_animated_icon_, object_ptr<file> &&ios_side_menu_icon_, object_ptr<file> &&android_icon_, object_ptr<file> &&android_side_menu_icon_, object_ptr<file> &&macos_icon_, object_ptr<file> &&macos_side_menu_icon_, object_ptr<attachmentMenuBotColor> &&icon_color_, object_ptr<file> &&web_app_placeholder_)
  : bot_user_id_(bot_user_id_)
  , supports_self_chat_(supports_self_chat_)
  , supports_user_chats_(supports_user_chats_)
  , supports_bot_chats_(supports_bot_chats_)
  , supports_group_chats_(supports_group_chats_)
  , supports_channel_chats_(supports_channel_chats_)
  , request_write_access_(request_write_access_)
  , is_added_(is_added_)
  , show_in_attachment_menu_(show_in_attachment_menu_)
  , show_in_side_menu_(show_in_side_menu_)
  , show_disclaimer_in_side_menu_(show_disclaimer_in_side_menu_)
  , name_(name_)
  , name_color_(std::move(name_color_))
  , default_icon_(std::move(default_icon_))
  , ios_static_icon_(std::move(ios_static_icon_))
  , ios_animated_icon_(std::move(ios_animated_icon_))
  , ios_side_menu_icon_(std::move(ios_side_menu_icon_))
  , android_icon_(std::move(android_icon_))
  , android_side_menu_icon_(std::move(android_side_menu_icon_))
  , macos_icon_(std::move(macos_icon_))
  , macos_side_menu_icon_(std::move(macos_side_menu_icon_))
  , icon_color_(std::move(icon_color_))
  , web_app_placeholder_(std::move(web_app_placeholder_))
{}

const std::int32_t attachmentMenuBot::ID;

void attachmentMenuBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachmentMenuBot");
    s.store_field("bot_user_id", bot_user_id_);
    s.store_field("supports_self_chat", supports_self_chat_);
    s.store_field("supports_user_chats", supports_user_chats_);
    s.store_field("supports_bot_chats", supports_bot_chats_);
    s.store_field("supports_group_chats", supports_group_chats_);
    s.store_field("supports_channel_chats", supports_channel_chats_);
    s.store_field("request_write_access", request_write_access_);
    s.store_field("is_added", is_added_);
    s.store_field("show_in_attachment_menu", show_in_attachment_menu_);
    s.store_field("show_in_side_menu", show_in_side_menu_);
    s.store_field("show_disclaimer_in_side_menu", show_disclaimer_in_side_menu_);
    s.store_field("name", name_);
    s.store_object_field("name_color", static_cast<const BaseObject *>(name_color_.get()));
    s.store_object_field("default_icon", static_cast<const BaseObject *>(default_icon_.get()));
    s.store_object_field("ios_static_icon", static_cast<const BaseObject *>(ios_static_icon_.get()));
    s.store_object_field("ios_animated_icon", static_cast<const BaseObject *>(ios_animated_icon_.get()));
    s.store_object_field("ios_side_menu_icon", static_cast<const BaseObject *>(ios_side_menu_icon_.get()));
    s.store_object_field("android_icon", static_cast<const BaseObject *>(android_icon_.get()));
    s.store_object_field("android_side_menu_icon", static_cast<const BaseObject *>(android_side_menu_icon_.get()));
    s.store_object_field("macos_icon", static_cast<const BaseObject *>(macos_icon_.get()));
    s.store_object_field("macos_side_menu_icon", static_cast<const BaseObject *>(macos_side_menu_icon_.get()));
    s.store_object_field("icon_color", static_cast<const BaseObject *>(icon_color_.get()));
    s.store_object_field("web_app_placeholder", static_cast<const BaseObject *>(web_app_placeholder_.get()));
    s.store_class_end();
  }
}

attachmentMenuBotColor::attachmentMenuBotColor()
  : light_color_()
  , dark_color_()
{}

attachmentMenuBotColor::attachmentMenuBotColor(int32 light_color_, int32 dark_color_)
  : light_color_(light_color_)
  , dark_color_(dark_color_)
{}

const std::int32_t attachmentMenuBotColor::ID;

void attachmentMenuBotColor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "attachmentMenuBotColor");
    s.store_field("light_color", light_color_);
    s.store_field("dark_color", dark_color_);
    s.store_class_end();
  }
}

audio::audio()
  : duration_()
  , title_()
  , performer_()
  , file_name_()
  , mime_type_()
  , album_cover_minithumbnail_()
  , album_cover_thumbnail_()
  , external_album_covers_()
  , audio_()
{}

audio::audio(int32 duration_, string const &title_, string const &performer_, string const &file_name_, string const &mime_type_, object_ptr<minithumbnail> &&album_cover_minithumbnail_, object_ptr<thumbnail> &&album_cover_thumbnail_, array<object_ptr<thumbnail>> &&external_album_covers_, object_ptr<file> &&audio_)
  : duration_(duration_)
  , title_(title_)
  , performer_(performer_)
  , file_name_(file_name_)
  , mime_type_(mime_type_)
  , album_cover_minithumbnail_(std::move(album_cover_minithumbnail_))
  , album_cover_thumbnail_(std::move(album_cover_thumbnail_))
  , external_album_covers_(std::move(external_album_covers_))
  , audio_(std::move(audio_))
{}

const std::int32_t audio::ID;

void audio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "audio");
    s.store_field("duration", duration_);
    s.store_field("title", title_);
    s.store_field("performer", performer_);
    s.store_field("file_name", file_name_);
    s.store_field("mime_type", mime_type_);
    s.store_object_field("album_cover_minithumbnail", static_cast<const BaseObject *>(album_cover_minithumbnail_.get()));
    s.store_object_field("album_cover_thumbnail", static_cast<const BaseObject *>(album_cover_thumbnail_.get()));
    { s.store_vector_begin("external_album_covers", external_album_covers_.size()); for (const auto &_value : external_album_covers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("audio", static_cast<const BaseObject *>(audio_.get()));
    s.store_class_end();
  }
}

authenticationCodeInfo::authenticationCodeInfo()
  : phone_number_()
  , type_()
  , next_type_()
  , timeout_()
{}

authenticationCodeInfo::authenticationCodeInfo(string const &phone_number_, object_ptr<AuthenticationCodeType> &&type_, object_ptr<AuthenticationCodeType> &&next_type_, int32 timeout_)
  : phone_number_(phone_number_)
  , type_(std::move(type_))
  , next_type_(std::move(next_type_))
  , timeout_(timeout_)
{}

const std::int32_t authenticationCodeInfo::ID;

void authenticationCodeInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeInfo");
    s.store_field("phone_number", phone_number_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_object_field("next_type", static_cast<const BaseObject *>(next_type_.get()));
    s.store_field("timeout", timeout_);
    s.store_class_end();
  }
}

authenticationCodeTypeTelegramMessage::authenticationCodeTypeTelegramMessage()
  : length_()
{}

authenticationCodeTypeTelegramMessage::authenticationCodeTypeTelegramMessage(int32 length_)
  : length_(length_)
{}

const std::int32_t authenticationCodeTypeTelegramMessage::ID;

void authenticationCodeTypeTelegramMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeTypeTelegramMessage");
    s.store_field("length", length_);
    s.store_class_end();
  }
}

authenticationCodeTypeSms::authenticationCodeTypeSms()
  : length_()
{}

authenticationCodeTypeSms::authenticationCodeTypeSms(int32 length_)
  : length_(length_)
{}

const std::int32_t authenticationCodeTypeSms::ID;

void authenticationCodeTypeSms::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeTypeSms");
    s.store_field("length", length_);
    s.store_class_end();
  }
}

authenticationCodeTypeSmsWord::authenticationCodeTypeSmsWord()
  : first_letter_()
{}

authenticationCodeTypeSmsWord::authenticationCodeTypeSmsWord(string const &first_letter_)
  : first_letter_(first_letter_)
{}

const std::int32_t authenticationCodeTypeSmsWord::ID;

void authenticationCodeTypeSmsWord::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeTypeSmsWord");
    s.store_field("first_letter", first_letter_);
    s.store_class_end();
  }
}

authenticationCodeTypeSmsPhrase::authenticationCodeTypeSmsPhrase()
  : first_word_()
{}

authenticationCodeTypeSmsPhrase::authenticationCodeTypeSmsPhrase(string const &first_word_)
  : first_word_(first_word_)
{}

const std::int32_t authenticationCodeTypeSmsPhrase::ID;

void authenticationCodeTypeSmsPhrase::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeTypeSmsPhrase");
    s.store_field("first_word", first_word_);
    s.store_class_end();
  }
}

authenticationCodeTypeCall::authenticationCodeTypeCall()
  : length_()
{}

authenticationCodeTypeCall::authenticationCodeTypeCall(int32 length_)
  : length_(length_)
{}

const std::int32_t authenticationCodeTypeCall::ID;

void authenticationCodeTypeCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeTypeCall");
    s.store_field("length", length_);
    s.store_class_end();
  }
}

authenticationCodeTypeFlashCall::authenticationCodeTypeFlashCall()
  : pattern_()
{}

authenticationCodeTypeFlashCall::authenticationCodeTypeFlashCall(string const &pattern_)
  : pattern_(pattern_)
{}

const std::int32_t authenticationCodeTypeFlashCall::ID;

void authenticationCodeTypeFlashCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeTypeFlashCall");
    s.store_field("pattern", pattern_);
    s.store_class_end();
  }
}

authenticationCodeTypeMissedCall::authenticationCodeTypeMissedCall()
  : phone_number_prefix_()
  , length_()
{}

authenticationCodeTypeMissedCall::authenticationCodeTypeMissedCall(string const &phone_number_prefix_, int32 length_)
  : phone_number_prefix_(phone_number_prefix_)
  , length_(length_)
{}

const std::int32_t authenticationCodeTypeMissedCall::ID;

void authenticationCodeTypeMissedCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeTypeMissedCall");
    s.store_field("phone_number_prefix", phone_number_prefix_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

authenticationCodeTypeFragment::authenticationCodeTypeFragment()
  : url_()
  , length_()
{}

authenticationCodeTypeFragment::authenticationCodeTypeFragment(string const &url_, int32 length_)
  : url_(url_)
  , length_(length_)
{}

const std::int32_t authenticationCodeTypeFragment::ID;

void authenticationCodeTypeFragment::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeTypeFragment");
    s.store_field("url", url_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

authenticationCodeTypeFirebaseAndroid::authenticationCodeTypeFirebaseAndroid()
  : device_verification_parameters_()
  , length_()
{}

authenticationCodeTypeFirebaseAndroid::authenticationCodeTypeFirebaseAndroid(object_ptr<FirebaseDeviceVerificationParameters> &&device_verification_parameters_, int32 length_)
  : device_verification_parameters_(std::move(device_verification_parameters_))
  , length_(length_)
{}

const std::int32_t authenticationCodeTypeFirebaseAndroid::ID;

void authenticationCodeTypeFirebaseAndroid::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeTypeFirebaseAndroid");
    s.store_object_field("device_verification_parameters", static_cast<const BaseObject *>(device_verification_parameters_.get()));
    s.store_field("length", length_);
    s.store_class_end();
  }
}

authenticationCodeTypeFirebaseIos::authenticationCodeTypeFirebaseIos()
  : receipt_()
  , push_timeout_()
  , length_()
{}

authenticationCodeTypeFirebaseIos::authenticationCodeTypeFirebaseIos(string const &receipt_, int32 push_timeout_, int32 length_)
  : receipt_(receipt_)
  , push_timeout_(push_timeout_)
  , length_(length_)
{}

const std::int32_t authenticationCodeTypeFirebaseIos::ID;

void authenticationCodeTypeFirebaseIos::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authenticationCodeTypeFirebaseIos");
    s.store_field("receipt", receipt_);
    s.store_field("push_timeout", push_timeout_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

authorizationStateWaitTdlibParameters::authorizationStateWaitTdlibParameters() {
}

const std::int32_t authorizationStateWaitTdlibParameters::ID;

void authorizationStateWaitTdlibParameters::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateWaitTdlibParameters");
    s.store_class_end();
  }
}

authorizationStateWaitPhoneNumber::authorizationStateWaitPhoneNumber() {
}

const std::int32_t authorizationStateWaitPhoneNumber::ID;

void authorizationStateWaitPhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateWaitPhoneNumber");
    s.store_class_end();
  }
}

authorizationStateWaitEmailAddress::authorizationStateWaitEmailAddress()
  : allow_apple_id_()
  , allow_google_id_()
{}

authorizationStateWaitEmailAddress::authorizationStateWaitEmailAddress(bool allow_apple_id_, bool allow_google_id_)
  : allow_apple_id_(allow_apple_id_)
  , allow_google_id_(allow_google_id_)
{}

const std::int32_t authorizationStateWaitEmailAddress::ID;

void authorizationStateWaitEmailAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateWaitEmailAddress");
    s.store_field("allow_apple_id", allow_apple_id_);
    s.store_field("allow_google_id", allow_google_id_);
    s.store_class_end();
  }
}

authorizationStateWaitEmailCode::authorizationStateWaitEmailCode()
  : allow_apple_id_()
  , allow_google_id_()
  , code_info_()
  , email_address_reset_state_()
{}

authorizationStateWaitEmailCode::authorizationStateWaitEmailCode(bool allow_apple_id_, bool allow_google_id_, object_ptr<emailAddressAuthenticationCodeInfo> &&code_info_, object_ptr<EmailAddressResetState> &&email_address_reset_state_)
  : allow_apple_id_(allow_apple_id_)
  , allow_google_id_(allow_google_id_)
  , code_info_(std::move(code_info_))
  , email_address_reset_state_(std::move(email_address_reset_state_))
{}

const std::int32_t authorizationStateWaitEmailCode::ID;

void authorizationStateWaitEmailCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateWaitEmailCode");
    s.store_field("allow_apple_id", allow_apple_id_);
    s.store_field("allow_google_id", allow_google_id_);
    s.store_object_field("code_info", static_cast<const BaseObject *>(code_info_.get()));
    s.store_object_field("email_address_reset_state", static_cast<const BaseObject *>(email_address_reset_state_.get()));
    s.store_class_end();
  }
}

authorizationStateWaitCode::authorizationStateWaitCode()
  : code_info_()
{}

authorizationStateWaitCode::authorizationStateWaitCode(object_ptr<authenticationCodeInfo> &&code_info_)
  : code_info_(std::move(code_info_))
{}

const std::int32_t authorizationStateWaitCode::ID;

void authorizationStateWaitCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateWaitCode");
    s.store_object_field("code_info", static_cast<const BaseObject *>(code_info_.get()));
    s.store_class_end();
  }
}

authorizationStateWaitOtherDeviceConfirmation::authorizationStateWaitOtherDeviceConfirmation()
  : link_()
{}

authorizationStateWaitOtherDeviceConfirmation::authorizationStateWaitOtherDeviceConfirmation(string const &link_)
  : link_(link_)
{}

const std::int32_t authorizationStateWaitOtherDeviceConfirmation::ID;

void authorizationStateWaitOtherDeviceConfirmation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateWaitOtherDeviceConfirmation");
    s.store_field("link", link_);
    s.store_class_end();
  }
}

authorizationStateWaitRegistration::authorizationStateWaitRegistration()
  : terms_of_service_()
{}

authorizationStateWaitRegistration::authorizationStateWaitRegistration(object_ptr<termsOfService> &&terms_of_service_)
  : terms_of_service_(std::move(terms_of_service_))
{}

const std::int32_t authorizationStateWaitRegistration::ID;

void authorizationStateWaitRegistration::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateWaitRegistration");
    s.store_object_field("terms_of_service", static_cast<const BaseObject *>(terms_of_service_.get()));
    s.store_class_end();
  }
}

authorizationStateWaitPassword::authorizationStateWaitPassword()
  : password_hint_()
  , has_recovery_email_address_()
  , has_passport_data_()
  , recovery_email_address_pattern_()
{}

authorizationStateWaitPassword::authorizationStateWaitPassword(string const &password_hint_, bool has_recovery_email_address_, bool has_passport_data_, string const &recovery_email_address_pattern_)
  : password_hint_(password_hint_)
  , has_recovery_email_address_(has_recovery_email_address_)
  , has_passport_data_(has_passport_data_)
  , recovery_email_address_pattern_(recovery_email_address_pattern_)
{}

const std::int32_t authorizationStateWaitPassword::ID;

void authorizationStateWaitPassword::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateWaitPassword");
    s.store_field("password_hint", password_hint_);
    s.store_field("has_recovery_email_address", has_recovery_email_address_);
    s.store_field("has_passport_data", has_passport_data_);
    s.store_field("recovery_email_address_pattern", recovery_email_address_pattern_);
    s.store_class_end();
  }
}

authorizationStateReady::authorizationStateReady() {
}

const std::int32_t authorizationStateReady::ID;

void authorizationStateReady::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateReady");
    s.store_class_end();
  }
}

authorizationStateLoggingOut::authorizationStateLoggingOut() {
}

const std::int32_t authorizationStateLoggingOut::ID;

void authorizationStateLoggingOut::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateLoggingOut");
    s.store_class_end();
  }
}

authorizationStateClosing::authorizationStateClosing() {
}

const std::int32_t authorizationStateClosing::ID;

void authorizationStateClosing::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateClosing");
    s.store_class_end();
  }
}

authorizationStateClosed::authorizationStateClosed() {
}

const std::int32_t authorizationStateClosed::ID;

void authorizationStateClosed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "authorizationStateClosed");
    s.store_class_end();
  }
}

autoDownloadSettings::autoDownloadSettings()
  : is_auto_download_enabled_()
  , max_photo_file_size_()
  , max_video_file_size_()
  , max_other_file_size_()
  , video_upload_bitrate_()
  , preload_large_videos_()
  , preload_next_audio_()
  , preload_stories_()
  , use_less_data_for_calls_()
{}

autoDownloadSettings::autoDownloadSettings(bool is_auto_download_enabled_, int32 max_photo_file_size_, int53 max_video_file_size_, int53 max_other_file_size_, int32 video_upload_bitrate_, bool preload_large_videos_, bool preload_next_audio_, bool preload_stories_, bool use_less_data_for_calls_)
  : is_auto_download_enabled_(is_auto_download_enabled_)
  , max_photo_file_size_(max_photo_file_size_)
  , max_video_file_size_(max_video_file_size_)
  , max_other_file_size_(max_other_file_size_)
  , video_upload_bitrate_(video_upload_bitrate_)
  , preload_large_videos_(preload_large_videos_)
  , preload_next_audio_(preload_next_audio_)
  , preload_stories_(preload_stories_)
  , use_less_data_for_calls_(use_less_data_for_calls_)
{}

const std::int32_t autoDownloadSettings::ID;

void autoDownloadSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autoDownloadSettings");
    s.store_field("is_auto_download_enabled", is_auto_download_enabled_);
    s.store_field("max_photo_file_size", max_photo_file_size_);
    s.store_field("max_video_file_size", max_video_file_size_);
    s.store_field("max_other_file_size", max_other_file_size_);
    s.store_field("video_upload_bitrate", video_upload_bitrate_);
    s.store_field("preload_large_videos", preload_large_videos_);
    s.store_field("preload_next_audio", preload_next_audio_);
    s.store_field("preload_stories", preload_stories_);
    s.store_field("use_less_data_for_calls", use_less_data_for_calls_);
    s.store_class_end();
  }
}

autoDownloadSettingsPresets::autoDownloadSettingsPresets()
  : low_()
  , medium_()
  , high_()
{}

autoDownloadSettingsPresets::autoDownloadSettingsPresets(object_ptr<autoDownloadSettings> &&low_, object_ptr<autoDownloadSettings> &&medium_, object_ptr<autoDownloadSettings> &&high_)
  : low_(std::move(low_))
  , medium_(std::move(medium_))
  , high_(std::move(high_))
{}

const std::int32_t autoDownloadSettingsPresets::ID;

void autoDownloadSettingsPresets::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autoDownloadSettingsPresets");
    s.store_object_field("low", static_cast<const BaseObject *>(low_.get()));
    s.store_object_field("medium", static_cast<const BaseObject *>(medium_.get()));
    s.store_object_field("high", static_cast<const BaseObject *>(high_.get()));
    s.store_class_end();
  }
}

autosaveSettings::autosaveSettings()
  : private_chat_settings_()
  , group_settings_()
  , channel_settings_()
  , exceptions_()
{}

autosaveSettings::autosaveSettings(object_ptr<scopeAutosaveSettings> &&private_chat_settings_, object_ptr<scopeAutosaveSettings> &&group_settings_, object_ptr<scopeAutosaveSettings> &&channel_settings_, array<object_ptr<autosaveSettingsException>> &&exceptions_)
  : private_chat_settings_(std::move(private_chat_settings_))
  , group_settings_(std::move(group_settings_))
  , channel_settings_(std::move(channel_settings_))
  , exceptions_(std::move(exceptions_))
{}

const std::int32_t autosaveSettings::ID;

void autosaveSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autosaveSettings");
    s.store_object_field("private_chat_settings", static_cast<const BaseObject *>(private_chat_settings_.get()));
    s.store_object_field("group_settings", static_cast<const BaseObject *>(group_settings_.get()));
    s.store_object_field("channel_settings", static_cast<const BaseObject *>(channel_settings_.get()));
    { s.store_vector_begin("exceptions", exceptions_.size()); for (const auto &_value : exceptions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

autosaveSettingsException::autosaveSettingsException()
  : chat_id_()
  , settings_()
{}

autosaveSettingsException::autosaveSettingsException(int53 chat_id_, object_ptr<scopeAutosaveSettings> &&settings_)
  : chat_id_(chat_id_)
  , settings_(std::move(settings_))
{}

const std::int32_t autosaveSettingsException::ID;

void autosaveSettingsException::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autosaveSettingsException");
    s.store_field("chat_id", chat_id_);
    s.store_object_field("settings", static_cast<const BaseObject *>(settings_.get()));
    s.store_class_end();
  }
}

autosaveSettingsScopePrivateChats::autosaveSettingsScopePrivateChats() {
}

const std::int32_t autosaveSettingsScopePrivateChats::ID;

void autosaveSettingsScopePrivateChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autosaveSettingsScopePrivateChats");
    s.store_class_end();
  }
}

autosaveSettingsScopeGroupChats::autosaveSettingsScopeGroupChats() {
}

const std::int32_t autosaveSettingsScopeGroupChats::ID;

void autosaveSettingsScopeGroupChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autosaveSettingsScopeGroupChats");
    s.store_class_end();
  }
}

autosaveSettingsScopeChannelChats::autosaveSettingsScopeChannelChats() {
}

const std::int32_t autosaveSettingsScopeChannelChats::ID;

void autosaveSettingsScopeChannelChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autosaveSettingsScopeChannelChats");
    s.store_class_end();
  }
}

autosaveSettingsScopeChat::autosaveSettingsScopeChat()
  : chat_id_()
{}

autosaveSettingsScopeChat::autosaveSettingsScopeChat(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t autosaveSettingsScopeChat::ID;

void autosaveSettingsScopeChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "autosaveSettingsScopeChat");
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

availableReaction::availableReaction()
  : type_()
  , needs_premium_()
{}

availableReaction::availableReaction(object_ptr<ReactionType> &&type_, bool needs_premium_)
  : type_(std::move(type_))
  , needs_premium_(needs_premium_)
{}

const std::int32_t availableReaction::ID;

void availableReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "availableReaction");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("needs_premium", needs_premium_);
    s.store_class_end();
  }
}

availableReactions::availableReactions()
  : top_reactions_()
  , recent_reactions_()
  , popular_reactions_()
  , allow_custom_emoji_()
  , are_tags_()
  , unavailability_reason_()
{}

availableReactions::availableReactions(array<object_ptr<availableReaction>> &&top_reactions_, array<object_ptr<availableReaction>> &&recent_reactions_, array<object_ptr<availableReaction>> &&popular_reactions_, bool allow_custom_emoji_, bool are_tags_, object_ptr<ReactionUnavailabilityReason> &&unavailability_reason_)
  : top_reactions_(std::move(top_reactions_))
  , recent_reactions_(std::move(recent_reactions_))
  , popular_reactions_(std::move(popular_reactions_))
  , allow_custom_emoji_(allow_custom_emoji_)
  , are_tags_(are_tags_)
  , unavailability_reason_(std::move(unavailability_reason_))
{}

const std::int32_t availableReactions::ID;

void availableReactions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "availableReactions");
    { s.store_vector_begin("top_reactions", top_reactions_.size()); for (const auto &_value : top_reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("recent_reactions", recent_reactions_.size()); for (const auto &_value : recent_reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("popular_reactions", popular_reactions_.size()); for (const auto &_value : popular_reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("allow_custom_emoji", allow_custom_emoji_);
    s.store_field("are_tags", are_tags_);
    s.store_object_field("unavailability_reason", static_cast<const BaseObject *>(unavailability_reason_.get()));
    s.store_class_end();
  }
}

background::background()
  : id_()
  , is_default_()
  , is_dark_()
  , name_()
  , document_()
  , type_()
{}

background::background(int64 id_, bool is_default_, bool is_dark_, string const &name_, object_ptr<document> &&document_, object_ptr<BackgroundType> &&type_)
  : id_(id_)
  , is_default_(is_default_)
  , is_dark_(is_dark_)
  , name_(name_)
  , document_(std::move(document_))
  , type_(std::move(type_))
{}

const std::int32_t background::ID;

void background::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "background");
    s.store_field("id", id_);
    s.store_field("is_default", is_default_);
    s.store_field("is_dark", is_dark_);
    s.store_field("name", name_);
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

backgroundFillSolid::backgroundFillSolid()
  : color_()
{}

backgroundFillSolid::backgroundFillSolid(int32 color_)
  : color_(color_)
{}

const std::int32_t backgroundFillSolid::ID;

void backgroundFillSolid::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "backgroundFillSolid");
    s.store_field("color", color_);
    s.store_class_end();
  }
}

backgroundFillGradient::backgroundFillGradient()
  : top_color_()
  , bottom_color_()
  , rotation_angle_()
{}

backgroundFillGradient::backgroundFillGradient(int32 top_color_, int32 bottom_color_, int32 rotation_angle_)
  : top_color_(top_color_)
  , bottom_color_(bottom_color_)
  , rotation_angle_(rotation_angle_)
{}

const std::int32_t backgroundFillGradient::ID;

void backgroundFillGradient::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "backgroundFillGradient");
    s.store_field("top_color", top_color_);
    s.store_field("bottom_color", bottom_color_);
    s.store_field("rotation_angle", rotation_angle_);
    s.store_class_end();
  }
}

backgroundFillFreeformGradient::backgroundFillFreeformGradient()
  : colors_()
{}

backgroundFillFreeformGradient::backgroundFillFreeformGradient(array<int32> &&colors_)
  : colors_(std::move(colors_))
{}

const std::int32_t backgroundFillFreeformGradient::ID;

void backgroundFillFreeformGradient::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "backgroundFillFreeformGradient");
    { s.store_vector_begin("colors", colors_.size()); for (const auto &_value : colors_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

backgroundTypeWallpaper::backgroundTypeWallpaper()
  : is_blurred_()
  , is_moving_()
{}

backgroundTypeWallpaper::backgroundTypeWallpaper(bool is_blurred_, bool is_moving_)
  : is_blurred_(is_blurred_)
  , is_moving_(is_moving_)
{}

const std::int32_t backgroundTypeWallpaper::ID;

void backgroundTypeWallpaper::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "backgroundTypeWallpaper");
    s.store_field("is_blurred", is_blurred_);
    s.store_field("is_moving", is_moving_);
    s.store_class_end();
  }
}

backgroundTypePattern::backgroundTypePattern()
  : fill_()
  , intensity_()
  , is_inverted_()
  , is_moving_()
{}

backgroundTypePattern::backgroundTypePattern(object_ptr<BackgroundFill> &&fill_, int32 intensity_, bool is_inverted_, bool is_moving_)
  : fill_(std::move(fill_))
  , intensity_(intensity_)
  , is_inverted_(is_inverted_)
  , is_moving_(is_moving_)
{}

const std::int32_t backgroundTypePattern::ID;

void backgroundTypePattern::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "backgroundTypePattern");
    s.store_object_field("fill", static_cast<const BaseObject *>(fill_.get()));
    s.store_field("intensity", intensity_);
    s.store_field("is_inverted", is_inverted_);
    s.store_field("is_moving", is_moving_);
    s.store_class_end();
  }
}

backgroundTypeFill::backgroundTypeFill()
  : fill_()
{}

backgroundTypeFill::backgroundTypeFill(object_ptr<BackgroundFill> &&fill_)
  : fill_(std::move(fill_))
{}

const std::int32_t backgroundTypeFill::ID;

void backgroundTypeFill::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "backgroundTypeFill");
    s.store_object_field("fill", static_cast<const BaseObject *>(fill_.get()));
    s.store_class_end();
  }
}

backgroundTypeChatTheme::backgroundTypeChatTheme()
  : theme_name_()
{}

backgroundTypeChatTheme::backgroundTypeChatTheme(string const &theme_name_)
  : theme_name_(theme_name_)
{}

const std::int32_t backgroundTypeChatTheme::ID;

void backgroundTypeChatTheme::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "backgroundTypeChatTheme");
    s.store_field("theme_name", theme_name_);
    s.store_class_end();
  }
}

backgrounds::backgrounds()
  : backgrounds_()
{}

backgrounds::backgrounds(array<object_ptr<background>> &&backgrounds_)
  : backgrounds_(std::move(backgrounds_))
{}

const std::int32_t backgrounds::ID;

void backgrounds::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "backgrounds");
    { s.store_vector_begin("backgrounds", backgrounds_.size()); for (const auto &_value : backgrounds_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

bankCardActionOpenUrl::bankCardActionOpenUrl()
  : text_()
  , url_()
{}

bankCardActionOpenUrl::bankCardActionOpenUrl(string const &text_, string const &url_)
  : text_(text_)
  , url_(url_)
{}

const std::int32_t bankCardActionOpenUrl::ID;

void bankCardActionOpenUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "bankCardActionOpenUrl");
    s.store_field("text", text_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

bankCardInfo::bankCardInfo()
  : title_()
  , actions_()
{}

bankCardInfo::bankCardInfo(string const &title_, array<object_ptr<bankCardActionOpenUrl>> &&actions_)
  : title_(title_)
  , actions_(std::move(actions_))
{}

const std::int32_t bankCardInfo::ID;

void bankCardInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "bankCardInfo");
    s.store_field("title", title_);
    { s.store_vector_begin("actions", actions_.size()); for (const auto &_value : actions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

basicGroup::basicGroup()
  : id_()
  , member_count_()
  , status_()
  , is_active_()
  , upgraded_to_supergroup_id_()
{}

basicGroup::basicGroup(int53 id_, int32 member_count_, object_ptr<ChatMemberStatus> &&status_, bool is_active_, int53 upgraded_to_supergroup_id_)
  : id_(id_)
  , member_count_(member_count_)
  , status_(std::move(status_))
  , is_active_(is_active_)
  , upgraded_to_supergroup_id_(upgraded_to_supergroup_id_)
{}

const std::int32_t basicGroup::ID;

void basicGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "basicGroup");
    s.store_field("id", id_);
    s.store_field("member_count", member_count_);
    s.store_object_field("status", static_cast<const BaseObject *>(status_.get()));
    s.store_field("is_active", is_active_);
    s.store_field("upgraded_to_supergroup_id", upgraded_to_supergroup_id_);
    s.store_class_end();
  }
}

basicGroupFullInfo::basicGroupFullInfo()
  : photo_()
  , description_()
  , creator_user_id_()
  , members_()
  , can_hide_members_()
  , can_toggle_aggressive_anti_spam_()
  , invite_link_()
  , bot_commands_()
{}

basicGroupFullInfo::basicGroupFullInfo(object_ptr<chatPhoto> &&photo_, string const &description_, int53 creator_user_id_, array<object_ptr<chatMember>> &&members_, bool can_hide_members_, bool can_toggle_aggressive_anti_spam_, object_ptr<chatInviteLink> &&invite_link_, array<object_ptr<botCommands>> &&bot_commands_)
  : photo_(std::move(photo_))
  , description_(description_)
  , creator_user_id_(creator_user_id_)
  , members_(std::move(members_))
  , can_hide_members_(can_hide_members_)
  , can_toggle_aggressive_anti_spam_(can_toggle_aggressive_anti_spam_)
  , invite_link_(std::move(invite_link_))
  , bot_commands_(std::move(bot_commands_))
{}

const std::int32_t basicGroupFullInfo::ID;

void basicGroupFullInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "basicGroupFullInfo");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("description", description_);
    s.store_field("creator_user_id", creator_user_id_);
    { s.store_vector_begin("members", members_.size()); for (const auto &_value : members_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("can_hide_members", can_hide_members_);
    s.store_field("can_toggle_aggressive_anti_spam", can_toggle_aggressive_anti_spam_);
    s.store_object_field("invite_link", static_cast<const BaseObject *>(invite_link_.get()));
    { s.store_vector_begin("bot_commands", bot_commands_.size()); for (const auto &_value : bot_commands_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

birthdate::birthdate()
  : day_()
  , month_()
  , year_()
{}

birthdate::birthdate(int32 day_, int32 month_, int32 year_)
  : day_(day_)
  , month_(month_)
  , year_(year_)
{}

const std::int32_t birthdate::ID;

void birthdate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "birthdate");
    s.store_field("day", day_);
    s.store_field("month", month_);
    s.store_field("year", year_);
    s.store_class_end();
  }
}

blockListMain::blockListMain() {
}

const std::int32_t blockListMain::ID;

void blockListMain::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "blockListMain");
    s.store_class_end();
  }
}

blockListStories::blockListStories() {
}

const std::int32_t blockListStories::ID;

void blockListStories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "blockListStories");
    s.store_class_end();
  }
}

botCommand::botCommand()
  : command_()
  , description_()
{}

botCommand::botCommand(string const &command_, string const &description_)
  : command_(command_)
  , description_(description_)
{}

const std::int32_t botCommand::ID;

void botCommand::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommand");
    s.store_field("command", command_);
    s.store_field("description", description_);
    s.store_class_end();
  }
}

botCommandScopeDefault::botCommandScopeDefault() {
}

const std::int32_t botCommandScopeDefault::ID;

void botCommandScopeDefault::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeDefault");
    s.store_class_end();
  }
}

botCommandScopeAllPrivateChats::botCommandScopeAllPrivateChats() {
}

const std::int32_t botCommandScopeAllPrivateChats::ID;

void botCommandScopeAllPrivateChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeAllPrivateChats");
    s.store_class_end();
  }
}

botCommandScopeAllGroupChats::botCommandScopeAllGroupChats() {
}

const std::int32_t botCommandScopeAllGroupChats::ID;

void botCommandScopeAllGroupChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeAllGroupChats");
    s.store_class_end();
  }
}

botCommandScopeAllChatAdministrators::botCommandScopeAllChatAdministrators() {
}

const std::int32_t botCommandScopeAllChatAdministrators::ID;

void botCommandScopeAllChatAdministrators::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeAllChatAdministrators");
    s.store_class_end();
  }
}

botCommandScopeChat::botCommandScopeChat()
  : chat_id_()
{}

botCommandScopeChat::botCommandScopeChat(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t botCommandScopeChat::ID;

void botCommandScopeChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeChat");
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

botCommandScopeChatAdministrators::botCommandScopeChatAdministrators()
  : chat_id_()
{}

botCommandScopeChatAdministrators::botCommandScopeChatAdministrators(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t botCommandScopeChatAdministrators::ID;

void botCommandScopeChatAdministrators::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeChatAdministrators");
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

botCommandScopeChatMember::botCommandScopeChatMember()
  : chat_id_()
  , user_id_()
{}

botCommandScopeChatMember::botCommandScopeChatMember(int53 chat_id_, int53 user_id_)
  : chat_id_(chat_id_)
  , user_id_(user_id_)
{}

const std::int32_t botCommandScopeChatMember::ID;

void botCommandScopeChatMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommandScopeChatMember");
    s.store_field("chat_id", chat_id_);
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

botCommands::botCommands()
  : bot_user_id_()
  , commands_()
{}

botCommands::botCommands(int53 bot_user_id_, array<object_ptr<botCommand>> &&commands_)
  : bot_user_id_(bot_user_id_)
  , commands_(std::move(commands_))
{}

const std::int32_t botCommands::ID;

void botCommands::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botCommands");
    s.store_field("bot_user_id", bot_user_id_);
    { s.store_vector_begin("commands", commands_.size()); for (const auto &_value : commands_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

botInfo::botInfo()
  : short_description_()
  , description_()
  , photo_()
  , animation_()
  , menu_button_()
  , commands_()
  , privacy_policy_url_()
  , default_group_administrator_rights_()
  , default_channel_administrator_rights_()
  , affiliate_program_()
  , web_app_background_light_color_()
  , web_app_background_dark_color_()
  , web_app_header_light_color_()
  , web_app_header_dark_color_()
  , verification_parameters_()
  , can_get_revenue_statistics_()
  , can_manage_emoji_status_()
  , has_media_previews_()
  , edit_commands_link_()
  , edit_description_link_()
  , edit_description_media_link_()
  , edit_settings_link_()
{}

botInfo::botInfo(string const &short_description_, string const &description_, object_ptr<photo> &&photo_, object_ptr<animation> &&animation_, object_ptr<botMenuButton> &&menu_button_, array<object_ptr<botCommand>> &&commands_, string const &privacy_policy_url_, object_ptr<chatAdministratorRights> &&default_group_administrator_rights_, object_ptr<chatAdministratorRights> &&default_channel_administrator_rights_, object_ptr<affiliateProgramInfo> &&affiliate_program_, int32 web_app_background_light_color_, int32 web_app_background_dark_color_, int32 web_app_header_light_color_, int32 web_app_header_dark_color_, object_ptr<botVerificationParameters> &&verification_parameters_, bool can_get_revenue_statistics_, bool can_manage_emoji_status_, bool has_media_previews_, object_ptr<InternalLinkType> &&edit_commands_link_, object_ptr<InternalLinkType> &&edit_description_link_, object_ptr<InternalLinkType> &&edit_description_media_link_, object_ptr<InternalLinkType> &&edit_settings_link_)
  : short_description_(short_description_)
  , description_(description_)
  , photo_(std::move(photo_))
  , animation_(std::move(animation_))
  , menu_button_(std::move(menu_button_))
  , commands_(std::move(commands_))
  , privacy_policy_url_(privacy_policy_url_)
  , default_group_administrator_rights_(std::move(default_group_administrator_rights_))
  , default_channel_administrator_rights_(std::move(default_channel_administrator_rights_))
  , affiliate_program_(std::move(affiliate_program_))
  , web_app_background_light_color_(web_app_background_light_color_)
  , web_app_background_dark_color_(web_app_background_dark_color_)
  , web_app_header_light_color_(web_app_header_light_color_)
  , web_app_header_dark_color_(web_app_header_dark_color_)
  , verification_parameters_(std::move(verification_parameters_))
  , can_get_revenue_statistics_(can_get_revenue_statistics_)
  , can_manage_emoji_status_(can_manage_emoji_status_)
  , has_media_previews_(has_media_previews_)
  , edit_commands_link_(std::move(edit_commands_link_))
  , edit_description_link_(std::move(edit_description_link_))
  , edit_description_media_link_(std::move(edit_description_media_link_))
  , edit_settings_link_(std::move(edit_settings_link_))
{}

const std::int32_t botInfo::ID;

void botInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botInfo");
    s.store_field("short_description", short_description_);
    s.store_field("description", description_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_object_field("menu_button", static_cast<const BaseObject *>(menu_button_.get()));
    { s.store_vector_begin("commands", commands_.size()); for (const auto &_value : commands_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("privacy_policy_url", privacy_policy_url_);
    s.store_object_field("default_group_administrator_rights", static_cast<const BaseObject *>(default_group_administrator_rights_.get()));
    s.store_object_field("default_channel_administrator_rights", static_cast<const BaseObject *>(default_channel_administrator_rights_.get()));
    s.store_object_field("affiliate_program", static_cast<const BaseObject *>(affiliate_program_.get()));
    s.store_field("web_app_background_light_color", web_app_background_light_color_);
    s.store_field("web_app_background_dark_color", web_app_background_dark_color_);
    s.store_field("web_app_header_light_color", web_app_header_light_color_);
    s.store_field("web_app_header_dark_color", web_app_header_dark_color_);
    s.store_object_field("verification_parameters", static_cast<const BaseObject *>(verification_parameters_.get()));
    s.store_field("can_get_revenue_statistics", can_get_revenue_statistics_);
    s.store_field("can_manage_emoji_status", can_manage_emoji_status_);
    s.store_field("has_media_previews", has_media_previews_);
    s.store_object_field("edit_commands_link", static_cast<const BaseObject *>(edit_commands_link_.get()));
    s.store_object_field("edit_description_link", static_cast<const BaseObject *>(edit_description_link_.get()));
    s.store_object_field("edit_description_media_link", static_cast<const BaseObject *>(edit_description_media_link_.get()));
    s.store_object_field("edit_settings_link", static_cast<const BaseObject *>(edit_settings_link_.get()));
    s.store_class_end();
  }
}

botMediaPreview::botMediaPreview()
  : date_()
  , content_()
{}

botMediaPreview::botMediaPreview(int32 date_, object_ptr<StoryContent> &&content_)
  : date_(date_)
  , content_(std::move(content_))
{}

const std::int32_t botMediaPreview::ID;

void botMediaPreview::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botMediaPreview");
    s.store_field("date", date_);
    s.store_object_field("content", static_cast<const BaseObject *>(content_.get()));
    s.store_class_end();
  }
}

botMediaPreviewInfo::botMediaPreviewInfo()
  : previews_()
  , language_codes_()
{}

botMediaPreviewInfo::botMediaPreviewInfo(array<object_ptr<botMediaPreview>> &&previews_, array<string> &&language_codes_)
  : previews_(std::move(previews_))
  , language_codes_(std::move(language_codes_))
{}

const std::int32_t botMediaPreviewInfo::ID;

void botMediaPreviewInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botMediaPreviewInfo");
    { s.store_vector_begin("previews", previews_.size()); for (const auto &_value : previews_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("language_codes", language_codes_.size()); for (const auto &_value : language_codes_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

botMediaPreviews::botMediaPreviews()
  : previews_()
{}

botMediaPreviews::botMediaPreviews(array<object_ptr<botMediaPreview>> &&previews_)
  : previews_(std::move(previews_))
{}

const std::int32_t botMediaPreviews::ID;

void botMediaPreviews::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botMediaPreviews");
    { s.store_vector_begin("previews", previews_.size()); for (const auto &_value : previews_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

botMenuButton::botMenuButton()
  : text_()
  , url_()
{}

botMenuButton::botMenuButton(string const &text_, string const &url_)
  : text_(text_)
  , url_(url_)
{}

const std::int32_t botMenuButton::ID;

void botMenuButton::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botMenuButton");
    s.store_field("text", text_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

botVerification::botVerification()
  : bot_user_id_()
  , icon_custom_emoji_id_()
  , custom_description_()
{}

botVerification::botVerification(int53 bot_user_id_, int64 icon_custom_emoji_id_, object_ptr<formattedText> &&custom_description_)
  : bot_user_id_(bot_user_id_)
  , icon_custom_emoji_id_(icon_custom_emoji_id_)
  , custom_description_(std::move(custom_description_))
{}

const std::int32_t botVerification::ID;

void botVerification::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botVerification");
    s.store_field("bot_user_id", bot_user_id_);
    s.store_field("icon_custom_emoji_id", icon_custom_emoji_id_);
    s.store_object_field("custom_description", static_cast<const BaseObject *>(custom_description_.get()));
    s.store_class_end();
  }
}

botVerificationParameters::botVerificationParameters()
  : icon_custom_emoji_id_()
  , organization_name_()
  , default_custom_description_()
  , can_set_custom_description_()
{}

botVerificationParameters::botVerificationParameters(int64 icon_custom_emoji_id_, string const &organization_name_, object_ptr<formattedText> &&default_custom_description_, bool can_set_custom_description_)
  : icon_custom_emoji_id_(icon_custom_emoji_id_)
  , organization_name_(organization_name_)
  , default_custom_description_(std::move(default_custom_description_))
  , can_set_custom_description_(can_set_custom_description_)
{}

const std::int32_t botVerificationParameters::ID;

void botVerificationParameters::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botVerificationParameters");
    s.store_field("icon_custom_emoji_id", icon_custom_emoji_id_);
    s.store_field("organization_name", organization_name_);
    s.store_object_field("default_custom_description", static_cast<const BaseObject *>(default_custom_description_.get()));
    s.store_field("can_set_custom_description", can_set_custom_description_);
    s.store_class_end();
  }
}

botWriteAccessAllowReasonConnectedWebsite::botWriteAccessAllowReasonConnectedWebsite()
  : domain_name_()
{}

botWriteAccessAllowReasonConnectedWebsite::botWriteAccessAllowReasonConnectedWebsite(string const &domain_name_)
  : domain_name_(domain_name_)
{}

const std::int32_t botWriteAccessAllowReasonConnectedWebsite::ID;

void botWriteAccessAllowReasonConnectedWebsite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botWriteAccessAllowReasonConnectedWebsite");
    s.store_field("domain_name", domain_name_);
    s.store_class_end();
  }
}

botWriteAccessAllowReasonAddedToAttachmentMenu::botWriteAccessAllowReasonAddedToAttachmentMenu() {
}

const std::int32_t botWriteAccessAllowReasonAddedToAttachmentMenu::ID;

void botWriteAccessAllowReasonAddedToAttachmentMenu::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botWriteAccessAllowReasonAddedToAttachmentMenu");
    s.store_class_end();
  }
}

botWriteAccessAllowReasonLaunchedWebApp::botWriteAccessAllowReasonLaunchedWebApp()
  : web_app_()
{}

botWriteAccessAllowReasonLaunchedWebApp::botWriteAccessAllowReasonLaunchedWebApp(object_ptr<webApp> &&web_app_)
  : web_app_(std::move(web_app_))
{}

const std::int32_t botWriteAccessAllowReasonLaunchedWebApp::ID;

void botWriteAccessAllowReasonLaunchedWebApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botWriteAccessAllowReasonLaunchedWebApp");
    s.store_object_field("web_app", static_cast<const BaseObject *>(web_app_.get()));
    s.store_class_end();
  }
}

botWriteAccessAllowReasonAcceptedRequest::botWriteAccessAllowReasonAcceptedRequest() {
}

const std::int32_t botWriteAccessAllowReasonAcceptedRequest::ID;

void botWriteAccessAllowReasonAcceptedRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "botWriteAccessAllowReasonAcceptedRequest");
    s.store_class_end();
  }
}

businessAwayMessageScheduleAlways::businessAwayMessageScheduleAlways() {
}

const std::int32_t businessAwayMessageScheduleAlways::ID;

void businessAwayMessageScheduleAlways::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessAwayMessageScheduleAlways");
    s.store_class_end();
  }
}

businessAwayMessageScheduleOutsideOfOpeningHours::businessAwayMessageScheduleOutsideOfOpeningHours() {
}

const std::int32_t businessAwayMessageScheduleOutsideOfOpeningHours::ID;

void businessAwayMessageScheduleOutsideOfOpeningHours::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessAwayMessageScheduleOutsideOfOpeningHours");
    s.store_class_end();
  }
}

businessAwayMessageScheduleCustom::businessAwayMessageScheduleCustom()
  : start_date_()
  , end_date_()
{}

businessAwayMessageScheduleCustom::businessAwayMessageScheduleCustom(int32 start_date_, int32 end_date_)
  : start_date_(start_date_)
  , end_date_(end_date_)
{}

const std::int32_t businessAwayMessageScheduleCustom::ID;

void businessAwayMessageScheduleCustom::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessAwayMessageScheduleCustom");
    s.store_field("start_date", start_date_);
    s.store_field("end_date", end_date_);
    s.store_class_end();
  }
}

businessAwayMessageSettings::businessAwayMessageSettings()
  : shortcut_id_()
  , recipients_()
  , schedule_()
  , offline_only_()
{}

businessAwayMessageSettings::businessAwayMessageSettings(int32 shortcut_id_, object_ptr<businessRecipients> &&recipients_, object_ptr<BusinessAwayMessageSchedule> &&schedule_, bool offline_only_)
  : shortcut_id_(shortcut_id_)
  , recipients_(std::move(recipients_))
  , schedule_(std::move(schedule_))
  , offline_only_(offline_only_)
{}

const std::int32_t businessAwayMessageSettings::ID;

void businessAwayMessageSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessAwayMessageSettings");
    s.store_field("shortcut_id", shortcut_id_);
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_object_field("schedule", static_cast<const BaseObject *>(schedule_.get()));
    s.store_field("offline_only", offline_only_);
    s.store_class_end();
  }
}

businessBotManageBar::businessBotManageBar()
  : bot_user_id_()
  , manage_url_()
  , is_bot_paused_()
  , can_bot_reply_()
{}

businessBotManageBar::businessBotManageBar(int53 bot_user_id_, string const &manage_url_, bool is_bot_paused_, bool can_bot_reply_)
  : bot_user_id_(bot_user_id_)
  , manage_url_(manage_url_)
  , is_bot_paused_(is_bot_paused_)
  , can_bot_reply_(can_bot_reply_)
{}

const std::int32_t businessBotManageBar::ID;

void businessBotManageBar::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessBotManageBar");
    s.store_field("bot_user_id", bot_user_id_);
    s.store_field("manage_url", manage_url_);
    s.store_field("is_bot_paused", is_bot_paused_);
    s.store_field("can_bot_reply", can_bot_reply_);
    s.store_class_end();
  }
}

businessChatLink::businessChatLink()
  : link_()
  , text_()
  , title_()
  , view_count_()
{}

businessChatLink::businessChatLink(string const &link_, object_ptr<formattedText> &&text_, string const &title_, int32 view_count_)
  : link_(link_)
  , text_(std::move(text_))
  , title_(title_)
  , view_count_(view_count_)
{}

const std::int32_t businessChatLink::ID;

void businessChatLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessChatLink");
    s.store_field("link", link_);
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("title", title_);
    s.store_field("view_count", view_count_);
    s.store_class_end();
  }
}

businessChatLinkInfo::businessChatLinkInfo()
  : chat_id_()
  , text_()
{}

businessChatLinkInfo::businessChatLinkInfo(int53 chat_id_, object_ptr<formattedText> &&text_)
  : chat_id_(chat_id_)
  , text_(std::move(text_))
{}

const std::int32_t businessChatLinkInfo::ID;

void businessChatLinkInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessChatLinkInfo");
    s.store_field("chat_id", chat_id_);
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

businessChatLinks::businessChatLinks()
  : links_()
{}

businessChatLinks::businessChatLinks(array<object_ptr<businessChatLink>> &&links_)
  : links_(std::move(links_))
{}

const std::int32_t businessChatLinks::ID;

void businessChatLinks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessChatLinks");
    { s.store_vector_begin("links", links_.size()); for (const auto &_value : links_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

businessConnectedBot::businessConnectedBot()
  : bot_user_id_()
  , recipients_()
  , can_reply_()
{}

businessConnectedBot::businessConnectedBot(int53 bot_user_id_, object_ptr<businessRecipients> &&recipients_, bool can_reply_)
  : bot_user_id_(bot_user_id_)
  , recipients_(std::move(recipients_))
  , can_reply_(can_reply_)
{}

const std::int32_t businessConnectedBot::ID;

void businessConnectedBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessConnectedBot");
    s.store_field("bot_user_id", bot_user_id_);
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_field("can_reply", can_reply_);
    s.store_class_end();
  }
}

businessConnection::businessConnection()
  : id_()
  , user_id_()
  , user_chat_id_()
  , date_()
  , can_reply_()
  , is_enabled_()
{}

businessConnection::businessConnection(string const &id_, int53 user_id_, int53 user_chat_id_, int32 date_, bool can_reply_, bool is_enabled_)
  : id_(id_)
  , user_id_(user_id_)
  , user_chat_id_(user_chat_id_)
  , date_(date_)
  , can_reply_(can_reply_)
  , is_enabled_(is_enabled_)
{}

const std::int32_t businessConnection::ID;

void businessConnection::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessConnection");
    s.store_field("id", id_);
    s.store_field("user_id", user_id_);
    s.store_field("user_chat_id", user_chat_id_);
    s.store_field("date", date_);
    s.store_field("can_reply", can_reply_);
    s.store_field("is_enabled", is_enabled_);
    s.store_class_end();
  }
}

businessFeatureLocation::businessFeatureLocation() {
}

const std::int32_t businessFeatureLocation::ID;

void businessFeatureLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureLocation");
    s.store_class_end();
  }
}

businessFeatureOpeningHours::businessFeatureOpeningHours() {
}

const std::int32_t businessFeatureOpeningHours::ID;

void businessFeatureOpeningHours::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureOpeningHours");
    s.store_class_end();
  }
}

businessFeatureQuickReplies::businessFeatureQuickReplies() {
}

const std::int32_t businessFeatureQuickReplies::ID;

void businessFeatureQuickReplies::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureQuickReplies");
    s.store_class_end();
  }
}

businessFeatureGreetingMessage::businessFeatureGreetingMessage() {
}

const std::int32_t businessFeatureGreetingMessage::ID;

void businessFeatureGreetingMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureGreetingMessage");
    s.store_class_end();
  }
}

businessFeatureAwayMessage::businessFeatureAwayMessage() {
}

const std::int32_t businessFeatureAwayMessage::ID;

void businessFeatureAwayMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureAwayMessage");
    s.store_class_end();
  }
}

businessFeatureAccountLinks::businessFeatureAccountLinks() {
}

const std::int32_t businessFeatureAccountLinks::ID;

void businessFeatureAccountLinks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureAccountLinks");
    s.store_class_end();
  }
}

businessFeatureStartPage::businessFeatureStartPage() {
}

const std::int32_t businessFeatureStartPage::ID;

void businessFeatureStartPage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureStartPage");
    s.store_class_end();
  }
}

businessFeatureBots::businessFeatureBots() {
}

const std::int32_t businessFeatureBots::ID;

void businessFeatureBots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureBots");
    s.store_class_end();
  }
}

businessFeatureEmojiStatus::businessFeatureEmojiStatus() {
}

const std::int32_t businessFeatureEmojiStatus::ID;

void businessFeatureEmojiStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureEmojiStatus");
    s.store_class_end();
  }
}

businessFeatureChatFolderTags::businessFeatureChatFolderTags() {
}

const std::int32_t businessFeatureChatFolderTags::ID;

void businessFeatureChatFolderTags::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureChatFolderTags");
    s.store_class_end();
  }
}

businessFeatureUpgradedStories::businessFeatureUpgradedStories() {
}

const std::int32_t businessFeatureUpgradedStories::ID;

void businessFeatureUpgradedStories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatureUpgradedStories");
    s.store_class_end();
  }
}

businessFeaturePromotionAnimation::businessFeaturePromotionAnimation()
  : feature_()
  , animation_()
{}

businessFeaturePromotionAnimation::businessFeaturePromotionAnimation(object_ptr<BusinessFeature> &&feature_, object_ptr<animation> &&animation_)
  : feature_(std::move(feature_))
  , animation_(std::move(animation_))
{}

const std::int32_t businessFeaturePromotionAnimation::ID;

void businessFeaturePromotionAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeaturePromotionAnimation");
    s.store_object_field("feature", static_cast<const BaseObject *>(feature_.get()));
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_class_end();
  }
}

businessFeatures::businessFeatures()
  : features_()
{}

businessFeatures::businessFeatures(array<object_ptr<BusinessFeature>> &&features_)
  : features_(std::move(features_))
{}

const std::int32_t businessFeatures::ID;

void businessFeatures::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessFeatures");
    { s.store_vector_begin("features", features_.size()); for (const auto &_value : features_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

businessGreetingMessageSettings::businessGreetingMessageSettings()
  : shortcut_id_()
  , recipients_()
  , inactivity_days_()
{}

businessGreetingMessageSettings::businessGreetingMessageSettings(int32 shortcut_id_, object_ptr<businessRecipients> &&recipients_, int32 inactivity_days_)
  : shortcut_id_(shortcut_id_)
  , recipients_(std::move(recipients_))
  , inactivity_days_(inactivity_days_)
{}

const std::int32_t businessGreetingMessageSettings::ID;

void businessGreetingMessageSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessGreetingMessageSettings");
    s.store_field("shortcut_id", shortcut_id_);
    s.store_object_field("recipients", static_cast<const BaseObject *>(recipients_.get()));
    s.store_field("inactivity_days", inactivity_days_);
    s.store_class_end();
  }
}

businessInfo::businessInfo()
  : location_()
  , opening_hours_()
  , local_opening_hours_()
  , next_open_in_()
  , next_close_in_()
  , greeting_message_settings_()
  , away_message_settings_()
  , start_page_()
{}

businessInfo::businessInfo(object_ptr<businessLocation> &&location_, object_ptr<businessOpeningHours> &&opening_hours_, object_ptr<businessOpeningHours> &&local_opening_hours_, int32 next_open_in_, int32 next_close_in_, object_ptr<businessGreetingMessageSettings> &&greeting_message_settings_, object_ptr<businessAwayMessageSettings> &&away_message_settings_, object_ptr<businessStartPage> &&start_page_)
  : location_(std::move(location_))
  , opening_hours_(std::move(opening_hours_))
  , local_opening_hours_(std::move(local_opening_hours_))
  , next_open_in_(next_open_in_)
  , next_close_in_(next_close_in_)
  , greeting_message_settings_(std::move(greeting_message_settings_))
  , away_message_settings_(std::move(away_message_settings_))
  , start_page_(std::move(start_page_))
{}

const std::int32_t businessInfo::ID;

void businessInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessInfo");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_object_field("opening_hours", static_cast<const BaseObject *>(opening_hours_.get()));
    s.store_object_field("local_opening_hours", static_cast<const BaseObject *>(local_opening_hours_.get()));
    s.store_field("next_open_in", next_open_in_);
    s.store_field("next_close_in", next_close_in_);
    s.store_object_field("greeting_message_settings", static_cast<const BaseObject *>(greeting_message_settings_.get()));
    s.store_object_field("away_message_settings", static_cast<const BaseObject *>(away_message_settings_.get()));
    s.store_object_field("start_page", static_cast<const BaseObject *>(start_page_.get()));
    s.store_class_end();
  }
}

businessLocation::businessLocation()
  : location_()
  , address_()
{}

businessLocation::businessLocation(object_ptr<location> &&location_, string const &address_)
  : location_(std::move(location_))
  , address_(address_)
{}

const std::int32_t businessLocation::ID;

void businessLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessLocation");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_field("address", address_);
    s.store_class_end();
  }
}

businessMessage::businessMessage()
  : message_()
  , reply_to_message_()
{}

businessMessage::businessMessage(object_ptr<message> &&message_, object_ptr<message> &&reply_to_message_)
  : message_(std::move(message_))
  , reply_to_message_(std::move(reply_to_message_))
{}

const std::int32_t businessMessage::ID;

void businessMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessMessage");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_object_field("reply_to_message", static_cast<const BaseObject *>(reply_to_message_.get()));
    s.store_class_end();
  }
}

businessMessages::businessMessages()
  : messages_()
{}

businessMessages::businessMessages(array<object_ptr<businessMessage>> &&messages_)
  : messages_(std::move(messages_))
{}

const std::int32_t businessMessages::ID;

void businessMessages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessMessages");
    { s.store_vector_begin("messages", messages_.size()); for (const auto &_value : messages_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

businessOpeningHours::businessOpeningHours()
  : time_zone_id_()
  , opening_hours_()
{}

businessOpeningHours::businessOpeningHours(string const &time_zone_id_, array<object_ptr<businessOpeningHoursInterval>> &&opening_hours_)
  : time_zone_id_(time_zone_id_)
  , opening_hours_(std::move(opening_hours_))
{}

const std::int32_t businessOpeningHours::ID;

void businessOpeningHours::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessOpeningHours");
    s.store_field("time_zone_id", time_zone_id_);
    { s.store_vector_begin("opening_hours", opening_hours_.size()); for (const auto &_value : opening_hours_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

businessOpeningHoursInterval::businessOpeningHoursInterval()
  : start_minute_()
  , end_minute_()
{}

businessOpeningHoursInterval::businessOpeningHoursInterval(int32 start_minute_, int32 end_minute_)
  : start_minute_(start_minute_)
  , end_minute_(end_minute_)
{}

const std::int32_t businessOpeningHoursInterval::ID;

void businessOpeningHoursInterval::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessOpeningHoursInterval");
    s.store_field("start_minute", start_minute_);
    s.store_field("end_minute", end_minute_);
    s.store_class_end();
  }
}

businessRecipients::businessRecipients()
  : chat_ids_()
  , excluded_chat_ids_()
  , select_existing_chats_()
  , select_new_chats_()
  , select_contacts_()
  , select_non_contacts_()
  , exclude_selected_()
{}

businessRecipients::businessRecipients(array<int53> &&chat_ids_, array<int53> &&excluded_chat_ids_, bool select_existing_chats_, bool select_new_chats_, bool select_contacts_, bool select_non_contacts_, bool exclude_selected_)
  : chat_ids_(std::move(chat_ids_))
  , excluded_chat_ids_(std::move(excluded_chat_ids_))
  , select_existing_chats_(select_existing_chats_)
  , select_new_chats_(select_new_chats_)
  , select_contacts_(select_contacts_)
  , select_non_contacts_(select_non_contacts_)
  , exclude_selected_(exclude_selected_)
{}

const std::int32_t businessRecipients::ID;

void businessRecipients::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessRecipients");
    { s.store_vector_begin("chat_ids", chat_ids_.size()); for (const auto &_value : chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("excluded_chat_ids", excluded_chat_ids_.size()); for (const auto &_value : excluded_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("select_existing_chats", select_existing_chats_);
    s.store_field("select_new_chats", select_new_chats_);
    s.store_field("select_contacts", select_contacts_);
    s.store_field("select_non_contacts", select_non_contacts_);
    s.store_field("exclude_selected", exclude_selected_);
    s.store_class_end();
  }
}

businessStartPage::businessStartPage()
  : title_()
  , message_()
  , sticker_()
{}

businessStartPage::businessStartPage(string const &title_, string const &message_, object_ptr<sticker> &&sticker_)
  : title_(title_)
  , message_(message_)
  , sticker_(std::move(sticker_))
{}

const std::int32_t businessStartPage::ID;

void businessStartPage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "businessStartPage");
    s.store_field("title", title_);
    s.store_field("message", message_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

call::call()
  : id_()
  , user_id_()
  , is_outgoing_()
  , is_video_()
  , state_()
  , group_call_id_()
{}

call::call(int32 id_, int53 user_id_, bool is_outgoing_, bool is_video_, object_ptr<CallState> &&state_, int32 group_call_id_)
  : id_(id_)
  , user_id_(user_id_)
  , is_outgoing_(is_outgoing_)
  , is_video_(is_video_)
  , state_(std::move(state_))
  , group_call_id_(group_call_id_)
{}

const std::int32_t call::ID;

void call::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "call");
    s.store_field("id", id_);
    s.store_field("user_id", user_id_);
    s.store_field("is_outgoing", is_outgoing_);
    s.store_field("is_video", is_video_);
    s.store_object_field("state", static_cast<const BaseObject *>(state_.get()));
    s.store_field("group_call_id", group_call_id_);
    s.store_class_end();
  }
}

callDiscardReasonEmpty::callDiscardReasonEmpty() {
}

const std::int32_t callDiscardReasonEmpty::ID;

void callDiscardReasonEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callDiscardReasonEmpty");
    s.store_class_end();
  }
}

callDiscardReasonMissed::callDiscardReasonMissed() {
}

const std::int32_t callDiscardReasonMissed::ID;

void callDiscardReasonMissed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callDiscardReasonMissed");
    s.store_class_end();
  }
}

callDiscardReasonDeclined::callDiscardReasonDeclined() {
}

const std::int32_t callDiscardReasonDeclined::ID;

void callDiscardReasonDeclined::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callDiscardReasonDeclined");
    s.store_class_end();
  }
}

callDiscardReasonDisconnected::callDiscardReasonDisconnected() {
}

const std::int32_t callDiscardReasonDisconnected::ID;

void callDiscardReasonDisconnected::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callDiscardReasonDisconnected");
    s.store_class_end();
  }
}

callDiscardReasonHungUp::callDiscardReasonHungUp() {
}

const std::int32_t callDiscardReasonHungUp::ID;

void callDiscardReasonHungUp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callDiscardReasonHungUp");
    s.store_class_end();
  }
}

callDiscardReasonAllowGroupCall::callDiscardReasonAllowGroupCall()
  : encrypted_group_call_key_()
{}

callDiscardReasonAllowGroupCall::callDiscardReasonAllowGroupCall(bytes const &encrypted_group_call_key_)
  : encrypted_group_call_key_(std::move(encrypted_group_call_key_))
{}

const std::int32_t callDiscardReasonAllowGroupCall::ID;

void callDiscardReasonAllowGroupCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callDiscardReasonAllowGroupCall");
    s.store_bytes_field("encrypted_group_call_key", encrypted_group_call_key_);
    s.store_class_end();
  }
}

callId::callId()
  : id_()
{}

callId::callId(int32 id_)
  : id_(id_)
{}

const std::int32_t callId::ID;

void callId::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callId");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

callProblemEcho::callProblemEcho() {
}

const std::int32_t callProblemEcho::ID;

void callProblemEcho::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callProblemEcho");
    s.store_class_end();
  }
}

callProblemNoise::callProblemNoise() {
}

const std::int32_t callProblemNoise::ID;

void callProblemNoise::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callProblemNoise");
    s.store_class_end();
  }
}

callProblemInterruptions::callProblemInterruptions() {
}

const std::int32_t callProblemInterruptions::ID;

void callProblemInterruptions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callProblemInterruptions");
    s.store_class_end();
  }
}

callProblemDistortedSpeech::callProblemDistortedSpeech() {
}

const std::int32_t callProblemDistortedSpeech::ID;

void callProblemDistortedSpeech::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callProblemDistortedSpeech");
    s.store_class_end();
  }
}

callProblemSilentLocal::callProblemSilentLocal() {
}

const std::int32_t callProblemSilentLocal::ID;

void callProblemSilentLocal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callProblemSilentLocal");
    s.store_class_end();
  }
}

callProblemSilentRemote::callProblemSilentRemote() {
}

const std::int32_t callProblemSilentRemote::ID;

void callProblemSilentRemote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callProblemSilentRemote");
    s.store_class_end();
  }
}

callProblemDropped::callProblemDropped() {
}

const std::int32_t callProblemDropped::ID;

void callProblemDropped::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callProblemDropped");
    s.store_class_end();
  }
}

callProblemDistortedVideo::callProblemDistortedVideo() {
}

const std::int32_t callProblemDistortedVideo::ID;

void callProblemDistortedVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callProblemDistortedVideo");
    s.store_class_end();
  }
}

callProblemPixelatedVideo::callProblemPixelatedVideo() {
}

const std::int32_t callProblemPixelatedVideo::ID;

void callProblemPixelatedVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callProblemPixelatedVideo");
    s.store_class_end();
  }
}

callProtocol::callProtocol()
  : udp_p2p_()
  , udp_reflector_()
  , min_layer_()
  , max_layer_()
  , library_versions_()
{}

callProtocol::callProtocol(bool udp_p2p_, bool udp_reflector_, int32 min_layer_, int32 max_layer_, array<string> &&library_versions_)
  : udp_p2p_(udp_p2p_)
  , udp_reflector_(udp_reflector_)
  , min_layer_(min_layer_)
  , max_layer_(max_layer_)
  , library_versions_(std::move(library_versions_))
{}

const std::int32_t callProtocol::ID;

void callProtocol::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callProtocol");
    s.store_field("udp_p2p", udp_p2p_);
    s.store_field("udp_reflector", udp_reflector_);
    s.store_field("min_layer", min_layer_);
    s.store_field("max_layer", max_layer_);
    { s.store_vector_begin("library_versions", library_versions_.size()); for (const auto &_value : library_versions_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

callServer::callServer()
  : id_()
  , ip_address_()
  , ipv6_address_()
  , port_()
  , type_()
{}

callServer::callServer(int64 id_, string const &ip_address_, string const &ipv6_address_, int32 port_, object_ptr<CallServerType> &&type_)
  : id_(id_)
  , ip_address_(ip_address_)
  , ipv6_address_(ipv6_address_)
  , port_(port_)
  , type_(std::move(type_))
{}

const std::int32_t callServer::ID;

void callServer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callServer");
    s.store_field("id", id_);
    s.store_field("ip_address", ip_address_);
    s.store_field("ipv6_address", ipv6_address_);
    s.store_field("port", port_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

callServerTypeTelegramReflector::callServerTypeTelegramReflector()
  : peer_tag_()
  , is_tcp_()
{}

callServerTypeTelegramReflector::callServerTypeTelegramReflector(bytes const &peer_tag_, bool is_tcp_)
  : peer_tag_(std::move(peer_tag_))
  , is_tcp_(is_tcp_)
{}

const std::int32_t callServerTypeTelegramReflector::ID;

void callServerTypeTelegramReflector::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callServerTypeTelegramReflector");
    s.store_bytes_field("peer_tag", peer_tag_);
    s.store_field("is_tcp", is_tcp_);
    s.store_class_end();
  }
}

callServerTypeWebrtc::callServerTypeWebrtc()
  : username_()
  , password_()
  , supports_turn_()
  , supports_stun_()
{}

callServerTypeWebrtc::callServerTypeWebrtc(string const &username_, string const &password_, bool supports_turn_, bool supports_stun_)
  : username_(username_)
  , password_(password_)
  , supports_turn_(supports_turn_)
  , supports_stun_(supports_stun_)
{}

const std::int32_t callServerTypeWebrtc::ID;

void callServerTypeWebrtc::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callServerTypeWebrtc");
    s.store_field("username", username_);
    s.store_field("password", password_);
    s.store_field("supports_turn", supports_turn_);
    s.store_field("supports_stun", supports_stun_);
    s.store_class_end();
  }
}

callStatePending::callStatePending()
  : is_created_()
  , is_received_()
{}

callStatePending::callStatePending(bool is_created_, bool is_received_)
  : is_created_(is_created_)
  , is_received_(is_received_)
{}

const std::int32_t callStatePending::ID;

void callStatePending::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callStatePending");
    s.store_field("is_created", is_created_);
    s.store_field("is_received", is_received_);
    s.store_class_end();
  }
}

callStateExchangingKeys::callStateExchangingKeys() {
}

const std::int32_t callStateExchangingKeys::ID;

void callStateExchangingKeys::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callStateExchangingKeys");
    s.store_class_end();
  }
}

callStateReady::callStateReady()
  : protocol_()
  , servers_()
  , config_()
  , encryption_key_()
  , emojis_()
  , allow_p2p_()
  , custom_parameters_()
{}

callStateReady::callStateReady(object_ptr<callProtocol> &&protocol_, array<object_ptr<callServer>> &&servers_, string const &config_, bytes const &encryption_key_, array<string> &&emojis_, bool allow_p2p_, string const &custom_parameters_)
  : protocol_(std::move(protocol_))
  , servers_(std::move(servers_))
  , config_(config_)
  , encryption_key_(std::move(encryption_key_))
  , emojis_(std::move(emojis_))
  , allow_p2p_(allow_p2p_)
  , custom_parameters_(custom_parameters_)
{}

const std::int32_t callStateReady::ID;

void callStateReady::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callStateReady");
    s.store_object_field("protocol", static_cast<const BaseObject *>(protocol_.get()));
    { s.store_vector_begin("servers", servers_.size()); for (const auto &_value : servers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("config", config_);
    s.store_bytes_field("encryption_key", encryption_key_);
    { s.store_vector_begin("emojis", emojis_.size()); for (const auto &_value : emojis_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("allow_p2p", allow_p2p_);
    s.store_field("custom_parameters", custom_parameters_);
    s.store_class_end();
  }
}

callStateHangingUp::callStateHangingUp() {
}

const std::int32_t callStateHangingUp::ID;

void callStateHangingUp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callStateHangingUp");
    s.store_class_end();
  }
}

callStateDiscarded::callStateDiscarded()
  : reason_()
  , need_rating_()
  , need_debug_information_()
  , need_log_()
{}

callStateDiscarded::callStateDiscarded(object_ptr<CallDiscardReason> &&reason_, bool need_rating_, bool need_debug_information_, bool need_log_)
  : reason_(std::move(reason_))
  , need_rating_(need_rating_)
  , need_debug_information_(need_debug_information_)
  , need_log_(need_log_)
{}

const std::int32_t callStateDiscarded::ID;

void callStateDiscarded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callStateDiscarded");
    s.store_object_field("reason", static_cast<const BaseObject *>(reason_.get()));
    s.store_field("need_rating", need_rating_);
    s.store_field("need_debug_information", need_debug_information_);
    s.store_field("need_log", need_log_);
    s.store_class_end();
  }
}

callStateError::callStateError()
  : error_()
{}

callStateError::callStateError(object_ptr<error> &&error_)
  : error_(std::move(error_))
{}

const std::int32_t callStateError::ID;

void callStateError::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callStateError");
    s.store_object_field("error", static_cast<const BaseObject *>(error_.get()));
    s.store_class_end();
  }
}

callbackQueryAnswer::callbackQueryAnswer()
  : text_()
  , show_alert_()
  , url_()
{}

callbackQueryAnswer::callbackQueryAnswer(string const &text_, bool show_alert_, string const &url_)
  : text_(text_)
  , show_alert_(show_alert_)
  , url_(url_)
{}

const std::int32_t callbackQueryAnswer::ID;

void callbackQueryAnswer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callbackQueryAnswer");
    s.store_field("text", text_);
    s.store_field("show_alert", show_alert_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

callbackQueryPayloadData::callbackQueryPayloadData()
  : data_()
{}

callbackQueryPayloadData::callbackQueryPayloadData(bytes const &data_)
  : data_(std::move(data_))
{}

const std::int32_t callbackQueryPayloadData::ID;

void callbackQueryPayloadData::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callbackQueryPayloadData");
    s.store_bytes_field("data", data_);
    s.store_class_end();
  }
}

callbackQueryPayloadDataWithPassword::callbackQueryPayloadDataWithPassword()
  : password_()
  , data_()
{}

callbackQueryPayloadDataWithPassword::callbackQueryPayloadDataWithPassword(string const &password_, bytes const &data_)
  : password_(password_)
  , data_(std::move(data_))
{}

const std::int32_t callbackQueryPayloadDataWithPassword::ID;

void callbackQueryPayloadDataWithPassword::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callbackQueryPayloadDataWithPassword");
    s.store_field("password", password_);
    s.store_bytes_field("data", data_);
    s.store_class_end();
  }
}

callbackQueryPayloadGame::callbackQueryPayloadGame()
  : game_short_name_()
{}

callbackQueryPayloadGame::callbackQueryPayloadGame(string const &game_short_name_)
  : game_short_name_(game_short_name_)
{}

const std::int32_t callbackQueryPayloadGame::ID;

void callbackQueryPayloadGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "callbackQueryPayloadGame");
    s.store_field("game_short_name", game_short_name_);
    s.store_class_end();
  }
}

canSendMessageToUserResultOk::canSendMessageToUserResultOk() {
}

const std::int32_t canSendMessageToUserResultOk::ID;

void canSendMessageToUserResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canSendMessageToUserResultOk");
    s.store_class_end();
  }
}

canSendMessageToUserResultUserIsDeleted::canSendMessageToUserResultUserIsDeleted() {
}

const std::int32_t canSendMessageToUserResultUserIsDeleted::ID;

void canSendMessageToUserResultUserIsDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canSendMessageToUserResultUserIsDeleted");
    s.store_class_end();
  }
}

canSendMessageToUserResultUserRestrictsNewChats::canSendMessageToUserResultUserRestrictsNewChats() {
}

const std::int32_t canSendMessageToUserResultUserRestrictsNewChats::ID;

void canSendMessageToUserResultUserRestrictsNewChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canSendMessageToUserResultUserRestrictsNewChats");
    s.store_class_end();
  }
}

canSendStoryResultOk::canSendStoryResultOk() {
}

const std::int32_t canSendStoryResultOk::ID;

void canSendStoryResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canSendStoryResultOk");
    s.store_class_end();
  }
}

canSendStoryResultPremiumNeeded::canSendStoryResultPremiumNeeded() {
}

const std::int32_t canSendStoryResultPremiumNeeded::ID;

void canSendStoryResultPremiumNeeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canSendStoryResultPremiumNeeded");
    s.store_class_end();
  }
}

canSendStoryResultBoostNeeded::canSendStoryResultBoostNeeded() {
}

const std::int32_t canSendStoryResultBoostNeeded::ID;

void canSendStoryResultBoostNeeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canSendStoryResultBoostNeeded");
    s.store_class_end();
  }
}

canSendStoryResultActiveStoryLimitExceeded::canSendStoryResultActiveStoryLimitExceeded() {
}

const std::int32_t canSendStoryResultActiveStoryLimitExceeded::ID;

void canSendStoryResultActiveStoryLimitExceeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canSendStoryResultActiveStoryLimitExceeded");
    s.store_class_end();
  }
}

canSendStoryResultWeeklyLimitExceeded::canSendStoryResultWeeklyLimitExceeded()
  : retry_after_()
{}

canSendStoryResultWeeklyLimitExceeded::canSendStoryResultWeeklyLimitExceeded(int32 retry_after_)
  : retry_after_(retry_after_)
{}

const std::int32_t canSendStoryResultWeeklyLimitExceeded::ID;

void canSendStoryResultWeeklyLimitExceeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canSendStoryResultWeeklyLimitExceeded");
    s.store_field("retry_after", retry_after_);
    s.store_class_end();
  }
}

canSendStoryResultMonthlyLimitExceeded::canSendStoryResultMonthlyLimitExceeded()
  : retry_after_()
{}

canSendStoryResultMonthlyLimitExceeded::canSendStoryResultMonthlyLimitExceeded(int32 retry_after_)
  : retry_after_(retry_after_)
{}

const std::int32_t canSendStoryResultMonthlyLimitExceeded::ID;

void canSendStoryResultMonthlyLimitExceeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canSendStoryResultMonthlyLimitExceeded");
    s.store_field("retry_after", retry_after_);
    s.store_class_end();
  }
}

canTransferOwnershipResultOk::canTransferOwnershipResultOk() {
}

const std::int32_t canTransferOwnershipResultOk::ID;

void canTransferOwnershipResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canTransferOwnershipResultOk");
    s.store_class_end();
  }
}

canTransferOwnershipResultPasswordNeeded::canTransferOwnershipResultPasswordNeeded() {
}

const std::int32_t canTransferOwnershipResultPasswordNeeded::ID;

void canTransferOwnershipResultPasswordNeeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canTransferOwnershipResultPasswordNeeded");
    s.store_class_end();
  }
}

canTransferOwnershipResultPasswordTooFresh::canTransferOwnershipResultPasswordTooFresh()
  : retry_after_()
{}

canTransferOwnershipResultPasswordTooFresh::canTransferOwnershipResultPasswordTooFresh(int32 retry_after_)
  : retry_after_(retry_after_)
{}

const std::int32_t canTransferOwnershipResultPasswordTooFresh::ID;

void canTransferOwnershipResultPasswordTooFresh::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canTransferOwnershipResultPasswordTooFresh");
    s.store_field("retry_after", retry_after_);
    s.store_class_end();
  }
}

canTransferOwnershipResultSessionTooFresh::canTransferOwnershipResultSessionTooFresh()
  : retry_after_()
{}

canTransferOwnershipResultSessionTooFresh::canTransferOwnershipResultSessionTooFresh(int32 retry_after_)
  : retry_after_(retry_after_)
{}

const std::int32_t canTransferOwnershipResultSessionTooFresh::ID;

void canTransferOwnershipResultSessionTooFresh::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "canTransferOwnershipResultSessionTooFresh");
    s.store_field("retry_after", retry_after_);
    s.store_class_end();
  }
}

chat::chat()
  : id_()
  , type_()
  , title_()
  , photo_()
  , accent_color_id_()
  , background_custom_emoji_id_()
  , profile_accent_color_id_()
  , profile_background_custom_emoji_id_()
  , permissions_()
  , last_message_()
  , positions_()
  , chat_lists_()
  , message_sender_id_()
  , block_list_()
  , has_protected_content_()
  , is_translatable_()
  , is_marked_as_unread_()
  , view_as_topics_()
  , has_scheduled_messages_()
  , can_be_deleted_only_for_self_()
  , can_be_deleted_for_all_users_()
  , can_be_reported_()
  , default_disable_notification_()
  , unread_count_()
  , last_read_inbox_message_id_()
  , last_read_outbox_message_id_()
  , unread_mention_count_()
  , unread_reaction_count_()
  , notification_settings_()
  , available_reactions_()
  , message_auto_delete_time_()
  , emoji_status_()
  , background_()
  , theme_name_()
  , action_bar_()
  , business_bot_manage_bar_()
  , video_chat_()
  , pending_join_requests_()
  , reply_markup_message_id_()
  , draft_message_()
  , client_data_()
{}

chat::chat(int53 id_, object_ptr<ChatType> &&type_, string const &title_, object_ptr<chatPhotoInfo> &&photo_, int32 accent_color_id_, int64 background_custom_emoji_id_, int32 profile_accent_color_id_, int64 profile_background_custom_emoji_id_, object_ptr<chatPermissions> &&permissions_, object_ptr<message> &&last_message_, array<object_ptr<chatPosition>> &&positions_, array<object_ptr<ChatList>> &&chat_lists_, object_ptr<MessageSender> &&message_sender_id_, object_ptr<BlockList> &&block_list_, bool has_protected_content_, bool is_translatable_, bool is_marked_as_unread_, bool view_as_topics_, bool has_scheduled_messages_, bool can_be_deleted_only_for_self_, bool can_be_deleted_for_all_users_, bool can_be_reported_, bool default_disable_notification_, int32 unread_count_, int53 last_read_inbox_message_id_, int53 last_read_outbox_message_id_, int32 unread_mention_count_, int32 unread_reaction_count_, object_ptr<chatNotificationSettings> &&notification_settings_, object_ptr<ChatAvailableReactions> &&available_reactions_, int32 message_auto_delete_time_, object_ptr<emojiStatus> &&emoji_status_, object_ptr<chatBackground> &&background_, string const &theme_name_, object_ptr<ChatActionBar> &&action_bar_, object_ptr<businessBotManageBar> &&business_bot_manage_bar_, object_ptr<videoChat> &&video_chat_, object_ptr<chatJoinRequestsInfo> &&pending_join_requests_, int53 reply_markup_message_id_, object_ptr<draftMessage> &&draft_message_, string const &client_data_)
  : id_(id_)
  , type_(std::move(type_))
  , title_(title_)
  , photo_(std::move(photo_))
  , accent_color_id_(accent_color_id_)
  , background_custom_emoji_id_(background_custom_emoji_id_)
  , profile_accent_color_id_(profile_accent_color_id_)
  , profile_background_custom_emoji_id_(profile_background_custom_emoji_id_)
  , permissions_(std::move(permissions_))
  , last_message_(std::move(last_message_))
  , positions_(std::move(positions_))
  , chat_lists_(std::move(chat_lists_))
  , message_sender_id_(std::move(message_sender_id_))
  , block_list_(std::move(block_list_))
  , has_protected_content_(has_protected_content_)
  , is_translatable_(is_translatable_)
  , is_marked_as_unread_(is_marked_as_unread_)
  , view_as_topics_(view_as_topics_)
  , has_scheduled_messages_(has_scheduled_messages_)
  , can_be_deleted_only_for_self_(can_be_deleted_only_for_self_)
  , can_be_deleted_for_all_users_(can_be_deleted_for_all_users_)
  , can_be_reported_(can_be_reported_)
  , default_disable_notification_(default_disable_notification_)
  , unread_count_(unread_count_)
  , last_read_inbox_message_id_(last_read_inbox_message_id_)
  , last_read_outbox_message_id_(last_read_outbox_message_id_)
  , unread_mention_count_(unread_mention_count_)
  , unread_reaction_count_(unread_reaction_count_)
  , notification_settings_(std::move(notification_settings_))
  , available_reactions_(std::move(available_reactions_))
  , message_auto_delete_time_(message_auto_delete_time_)
  , emoji_status_(std::move(emoji_status_))
  , background_(std::move(background_))
  , theme_name_(theme_name_)
  , action_bar_(std::move(action_bar_))
  , business_bot_manage_bar_(std::move(business_bot_manage_bar_))
  , video_chat_(std::move(video_chat_))
  , pending_join_requests_(std::move(pending_join_requests_))
  , reply_markup_message_id_(reply_markup_message_id_)
  , draft_message_(std::move(draft_message_))
  , client_data_(client_data_)
{}

const std::int32_t chat::ID;

void chat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chat");
    s.store_field("id", id_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("title", title_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("accent_color_id", accent_color_id_);
    s.store_field("background_custom_emoji_id", background_custom_emoji_id_);
    s.store_field("profile_accent_color_id", profile_accent_color_id_);
    s.store_field("profile_background_custom_emoji_id", profile_background_custom_emoji_id_);
    s.store_object_field("permissions", static_cast<const BaseObject *>(permissions_.get()));
    s.store_object_field("last_message", static_cast<const BaseObject *>(last_message_.get()));
    { s.store_vector_begin("positions", positions_.size()); for (const auto &_value : positions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("chat_lists", chat_lists_.size()); for (const auto &_value : chat_lists_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("message_sender_id", static_cast<const BaseObject *>(message_sender_id_.get()));
    s.store_object_field("block_list", static_cast<const BaseObject *>(block_list_.get()));
    s.store_field("has_protected_content", has_protected_content_);
    s.store_field("is_translatable", is_translatable_);
    s.store_field("is_marked_as_unread", is_marked_as_unread_);
    s.store_field("view_as_topics", view_as_topics_);
    s.store_field("has_scheduled_messages", has_scheduled_messages_);
    s.store_field("can_be_deleted_only_for_self", can_be_deleted_only_for_self_);
    s.store_field("can_be_deleted_for_all_users", can_be_deleted_for_all_users_);
    s.store_field("can_be_reported", can_be_reported_);
    s.store_field("default_disable_notification", default_disable_notification_);
    s.store_field("unread_count", unread_count_);
    s.store_field("last_read_inbox_message_id", last_read_inbox_message_id_);
    s.store_field("last_read_outbox_message_id", last_read_outbox_message_id_);
    s.store_field("unread_mention_count", unread_mention_count_);
    s.store_field("unread_reaction_count", unread_reaction_count_);
    s.store_object_field("notification_settings", static_cast<const BaseObject *>(notification_settings_.get()));
    s.store_object_field("available_reactions", static_cast<const BaseObject *>(available_reactions_.get()));
    s.store_field("message_auto_delete_time", message_auto_delete_time_);
    s.store_object_field("emoji_status", static_cast<const BaseObject *>(emoji_status_.get()));
    s.store_object_field("background", static_cast<const BaseObject *>(background_.get()));
    s.store_field("theme_name", theme_name_);
    s.store_object_field("action_bar", static_cast<const BaseObject *>(action_bar_.get()));
    s.store_object_field("business_bot_manage_bar", static_cast<const BaseObject *>(business_bot_manage_bar_.get()));
    s.store_object_field("video_chat", static_cast<const BaseObject *>(video_chat_.get()));
    s.store_object_field("pending_join_requests", static_cast<const BaseObject *>(pending_join_requests_.get()));
    s.store_field("reply_markup_message_id", reply_markup_message_id_);
    s.store_object_field("draft_message", static_cast<const BaseObject *>(draft_message_.get()));
    s.store_field("client_data", client_data_);
    s.store_class_end();
  }
}

chatActionTyping::chatActionTyping() {
}

const std::int32_t chatActionTyping::ID;

void chatActionTyping::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionTyping");
    s.store_class_end();
  }
}

chatActionRecordingVideo::chatActionRecordingVideo() {
}

const std::int32_t chatActionRecordingVideo::ID;

void chatActionRecordingVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionRecordingVideo");
    s.store_class_end();
  }
}

chatActionUploadingVideo::chatActionUploadingVideo()
  : progress_()
{}

chatActionUploadingVideo::chatActionUploadingVideo(int32 progress_)
  : progress_(progress_)
{}

const std::int32_t chatActionUploadingVideo::ID;

void chatActionUploadingVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionUploadingVideo");
    s.store_field("progress", progress_);
    s.store_class_end();
  }
}

chatActionRecordingVoiceNote::chatActionRecordingVoiceNote() {
}

const std::int32_t chatActionRecordingVoiceNote::ID;

void chatActionRecordingVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionRecordingVoiceNote");
    s.store_class_end();
  }
}

chatActionUploadingVoiceNote::chatActionUploadingVoiceNote()
  : progress_()
{}

chatActionUploadingVoiceNote::chatActionUploadingVoiceNote(int32 progress_)
  : progress_(progress_)
{}

const std::int32_t chatActionUploadingVoiceNote::ID;

void chatActionUploadingVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionUploadingVoiceNote");
    s.store_field("progress", progress_);
    s.store_class_end();
  }
}

chatActionUploadingPhoto::chatActionUploadingPhoto()
  : progress_()
{}

chatActionUploadingPhoto::chatActionUploadingPhoto(int32 progress_)
  : progress_(progress_)
{}

const std::int32_t chatActionUploadingPhoto::ID;

void chatActionUploadingPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionUploadingPhoto");
    s.store_field("progress", progress_);
    s.store_class_end();
  }
}

chatActionUploadingDocument::chatActionUploadingDocument()
  : progress_()
{}

chatActionUploadingDocument::chatActionUploadingDocument(int32 progress_)
  : progress_(progress_)
{}

const std::int32_t chatActionUploadingDocument::ID;

void chatActionUploadingDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionUploadingDocument");
    s.store_field("progress", progress_);
    s.store_class_end();
  }
}

chatActionChoosingSticker::chatActionChoosingSticker() {
}

const std::int32_t chatActionChoosingSticker::ID;

void chatActionChoosingSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionChoosingSticker");
    s.store_class_end();
  }
}

chatActionChoosingLocation::chatActionChoosingLocation() {
}

const std::int32_t chatActionChoosingLocation::ID;

void chatActionChoosingLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionChoosingLocation");
    s.store_class_end();
  }
}

chatActionChoosingContact::chatActionChoosingContact() {
}

const std::int32_t chatActionChoosingContact::ID;

void chatActionChoosingContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionChoosingContact");
    s.store_class_end();
  }
}

chatActionStartPlayingGame::chatActionStartPlayingGame() {
}

const std::int32_t chatActionStartPlayingGame::ID;

void chatActionStartPlayingGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionStartPlayingGame");
    s.store_class_end();
  }
}

chatActionRecordingVideoNote::chatActionRecordingVideoNote() {
}

const std::int32_t chatActionRecordingVideoNote::ID;

void chatActionRecordingVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionRecordingVideoNote");
    s.store_class_end();
  }
}

chatActionUploadingVideoNote::chatActionUploadingVideoNote()
  : progress_()
{}

chatActionUploadingVideoNote::chatActionUploadingVideoNote(int32 progress_)
  : progress_(progress_)
{}

const std::int32_t chatActionUploadingVideoNote::ID;

void chatActionUploadingVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionUploadingVideoNote");
    s.store_field("progress", progress_);
    s.store_class_end();
  }
}

chatActionWatchingAnimations::chatActionWatchingAnimations()
  : emoji_()
{}

chatActionWatchingAnimations::chatActionWatchingAnimations(string const &emoji_)
  : emoji_(emoji_)
{}

const std::int32_t chatActionWatchingAnimations::ID;

void chatActionWatchingAnimations::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionWatchingAnimations");
    s.store_field("emoji", emoji_);
    s.store_class_end();
  }
}

chatActionCancel::chatActionCancel() {
}

const std::int32_t chatActionCancel::ID;

void chatActionCancel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionCancel");
    s.store_class_end();
  }
}

chatActionBarReportSpam::chatActionBarReportSpam()
  : can_unarchive_()
{}

chatActionBarReportSpam::chatActionBarReportSpam(bool can_unarchive_)
  : can_unarchive_(can_unarchive_)
{}

const std::int32_t chatActionBarReportSpam::ID;

void chatActionBarReportSpam::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionBarReportSpam");
    s.store_field("can_unarchive", can_unarchive_);
    s.store_class_end();
  }
}

chatActionBarInviteMembers::chatActionBarInviteMembers() {
}

const std::int32_t chatActionBarInviteMembers::ID;

void chatActionBarInviteMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionBarInviteMembers");
    s.store_class_end();
  }
}

chatActionBarReportAddBlock::chatActionBarReportAddBlock()
  : can_unarchive_()
{}

chatActionBarReportAddBlock::chatActionBarReportAddBlock(bool can_unarchive_)
  : can_unarchive_(can_unarchive_)
{}

const std::int32_t chatActionBarReportAddBlock::ID;

void chatActionBarReportAddBlock::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionBarReportAddBlock");
    s.store_field("can_unarchive", can_unarchive_);
    s.store_class_end();
  }
}

chatActionBarAddContact::chatActionBarAddContact() {
}

const std::int32_t chatActionBarAddContact::ID;

void chatActionBarAddContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionBarAddContact");
    s.store_class_end();
  }
}

chatActionBarSharePhoneNumber::chatActionBarSharePhoneNumber() {
}

const std::int32_t chatActionBarSharePhoneNumber::ID;

void chatActionBarSharePhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionBarSharePhoneNumber");
    s.store_class_end();
  }
}

chatActionBarJoinRequest::chatActionBarJoinRequest()
  : title_()
  , is_channel_()
  , request_date_()
{}

chatActionBarJoinRequest::chatActionBarJoinRequest(string const &title_, bool is_channel_, int32 request_date_)
  : title_(title_)
  , is_channel_(is_channel_)
  , request_date_(request_date_)
{}

const std::int32_t chatActionBarJoinRequest::ID;

void chatActionBarJoinRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActionBarJoinRequest");
    s.store_field("title", title_);
    s.store_field("is_channel", is_channel_);
    s.store_field("request_date", request_date_);
    s.store_class_end();
  }
}

chatActiveStories::chatActiveStories()
  : chat_id_()
  , list_()
  , order_()
  , max_read_story_id_()
  , stories_()
{}

chatActiveStories::chatActiveStories(int53 chat_id_, object_ptr<StoryList> &&list_, int53 order_, int32 max_read_story_id_, array<object_ptr<storyInfo>> &&stories_)
  : chat_id_(chat_id_)
  , list_(std::move(list_))
  , order_(order_)
  , max_read_story_id_(max_read_story_id_)
  , stories_(std::move(stories_))
{}

const std::int32_t chatActiveStories::ID;

void chatActiveStories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatActiveStories");
    s.store_field("chat_id", chat_id_);
    s.store_object_field("list", static_cast<const BaseObject *>(list_.get()));
    s.store_field("order", order_);
    s.store_field("max_read_story_id", max_read_story_id_);
    { s.store_vector_begin("stories", stories_.size()); for (const auto &_value : stories_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatAdministrator::chatAdministrator()
  : user_id_()
  , custom_title_()
  , is_owner_()
{}

chatAdministrator::chatAdministrator(int53 user_id_, string const &custom_title_, bool is_owner_)
  : user_id_(user_id_)
  , custom_title_(custom_title_)
  , is_owner_(is_owner_)
{}

const std::int32_t chatAdministrator::ID;

void chatAdministrator::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatAdministrator");
    s.store_field("user_id", user_id_);
    s.store_field("custom_title", custom_title_);
    s.store_field("is_owner", is_owner_);
    s.store_class_end();
  }
}

chatAdministratorRights::chatAdministratorRights()
  : can_manage_chat_()
  , can_change_info_()
  , can_post_messages_()
  , can_edit_messages_()
  , can_delete_messages_()
  , can_invite_users_()
  , can_restrict_members_()
  , can_pin_messages_()
  , can_manage_topics_()
  , can_promote_members_()
  , can_manage_video_chats_()
  , can_post_stories_()
  , can_edit_stories_()
  , can_delete_stories_()
  , is_anonymous_()
{}

chatAdministratorRights::chatAdministratorRights(bool can_manage_chat_, bool can_change_info_, bool can_post_messages_, bool can_edit_messages_, bool can_delete_messages_, bool can_invite_users_, bool can_restrict_members_, bool can_pin_messages_, bool can_manage_topics_, bool can_promote_members_, bool can_manage_video_chats_, bool can_post_stories_, bool can_edit_stories_, bool can_delete_stories_, bool is_anonymous_)
  : can_manage_chat_(can_manage_chat_)
  , can_change_info_(can_change_info_)
  , can_post_messages_(can_post_messages_)
  , can_edit_messages_(can_edit_messages_)
  , can_delete_messages_(can_delete_messages_)
  , can_invite_users_(can_invite_users_)
  , can_restrict_members_(can_restrict_members_)
  , can_pin_messages_(can_pin_messages_)
  , can_manage_topics_(can_manage_topics_)
  , can_promote_members_(can_promote_members_)
  , can_manage_video_chats_(can_manage_video_chats_)
  , can_post_stories_(can_post_stories_)
  , can_edit_stories_(can_edit_stories_)
  , can_delete_stories_(can_delete_stories_)
  , is_anonymous_(is_anonymous_)
{}

const std::int32_t chatAdministratorRights::ID;

void chatAdministratorRights::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatAdministratorRights");
    s.store_field("can_manage_chat", can_manage_chat_);
    s.store_field("can_change_info", can_change_info_);
    s.store_field("can_post_messages", can_post_messages_);
    s.store_field("can_edit_messages", can_edit_messages_);
    s.store_field("can_delete_messages", can_delete_messages_);
    s.store_field("can_invite_users", can_invite_users_);
    s.store_field("can_restrict_members", can_restrict_members_);
    s.store_field("can_pin_messages", can_pin_messages_);
    s.store_field("can_manage_topics", can_manage_topics_);
    s.store_field("can_promote_members", can_promote_members_);
    s.store_field("can_manage_video_chats", can_manage_video_chats_);
    s.store_field("can_post_stories", can_post_stories_);
    s.store_field("can_edit_stories", can_edit_stories_);
    s.store_field("can_delete_stories", can_delete_stories_);
    s.store_field("is_anonymous", is_anonymous_);
    s.store_class_end();
  }
}

chatAdministrators::chatAdministrators()
  : administrators_()
{}

chatAdministrators::chatAdministrators(array<object_ptr<chatAdministrator>> &&administrators_)
  : administrators_(std::move(administrators_))
{}

const std::int32_t chatAdministrators::ID;

void chatAdministrators::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatAdministrators");
    { s.store_vector_begin("administrators", administrators_.size()); for (const auto &_value : administrators_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatAvailableReactionsAll::chatAvailableReactionsAll()
  : max_reaction_count_()
{}

chatAvailableReactionsAll::chatAvailableReactionsAll(int32 max_reaction_count_)
  : max_reaction_count_(max_reaction_count_)
{}

const std::int32_t chatAvailableReactionsAll::ID;

void chatAvailableReactionsAll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatAvailableReactionsAll");
    s.store_field("max_reaction_count", max_reaction_count_);
    s.store_class_end();
  }
}

chatAvailableReactionsSome::chatAvailableReactionsSome()
  : reactions_()
  , max_reaction_count_()
{}

chatAvailableReactionsSome::chatAvailableReactionsSome(array<object_ptr<ReactionType>> &&reactions_, int32 max_reaction_count_)
  : reactions_(std::move(reactions_))
  , max_reaction_count_(max_reaction_count_)
{}

const std::int32_t chatAvailableReactionsSome::ID;

void chatAvailableReactionsSome::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatAvailableReactionsSome");
    { s.store_vector_begin("reactions", reactions_.size()); for (const auto &_value : reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("max_reaction_count", max_reaction_count_);
    s.store_class_end();
  }
}

chatBackground::chatBackground()
  : background_()
  , dark_theme_dimming_()
{}

chatBackground::chatBackground(object_ptr<background> &&background_, int32 dark_theme_dimming_)
  : background_(std::move(background_))
  , dark_theme_dimming_(dark_theme_dimming_)
{}

const std::int32_t chatBackground::ID;

void chatBackground::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBackground");
    s.store_object_field("background", static_cast<const BaseObject *>(background_.get()));
    s.store_field("dark_theme_dimming", dark_theme_dimming_);
    s.store_class_end();
  }
}

chatBoost::chatBoost()
  : id_()
  , count_()
  , source_()
  , start_date_()
  , expiration_date_()
{}

chatBoost::chatBoost(string const &id_, int32 count_, object_ptr<ChatBoostSource> &&source_, int32 start_date_, int32 expiration_date_)
  : id_(id_)
  , count_(count_)
  , source_(std::move(source_))
  , start_date_(start_date_)
  , expiration_date_(expiration_date_)
{}

const std::int32_t chatBoost::ID;

void chatBoost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoost");
    s.store_field("id", id_);
    s.store_field("count", count_);
    s.store_object_field("source", static_cast<const BaseObject *>(source_.get()));
    s.store_field("start_date", start_date_);
    s.store_field("expiration_date", expiration_date_);
    s.store_class_end();
  }
}

chatBoostFeatures::chatBoostFeatures()
  : features_()
  , min_profile_background_custom_emoji_boost_level_()
  , min_background_custom_emoji_boost_level_()
  , min_emoji_status_boost_level_()
  , min_chat_theme_background_boost_level_()
  , min_custom_background_boost_level_()
  , min_custom_emoji_sticker_set_boost_level_()
  , min_speech_recognition_boost_level_()
  , min_sponsored_message_disable_boost_level_()
{}

chatBoostFeatures::chatBoostFeatures(array<object_ptr<chatBoostLevelFeatures>> &&features_, int32 min_profile_background_custom_emoji_boost_level_, int32 min_background_custom_emoji_boost_level_, int32 min_emoji_status_boost_level_, int32 min_chat_theme_background_boost_level_, int32 min_custom_background_boost_level_, int32 min_custom_emoji_sticker_set_boost_level_, int32 min_speech_recognition_boost_level_, int32 min_sponsored_message_disable_boost_level_)
  : features_(std::move(features_))
  , min_profile_background_custom_emoji_boost_level_(min_profile_background_custom_emoji_boost_level_)
  , min_background_custom_emoji_boost_level_(min_background_custom_emoji_boost_level_)
  , min_emoji_status_boost_level_(min_emoji_status_boost_level_)
  , min_chat_theme_background_boost_level_(min_chat_theme_background_boost_level_)
  , min_custom_background_boost_level_(min_custom_background_boost_level_)
  , min_custom_emoji_sticker_set_boost_level_(min_custom_emoji_sticker_set_boost_level_)
  , min_speech_recognition_boost_level_(min_speech_recognition_boost_level_)
  , min_sponsored_message_disable_boost_level_(min_sponsored_message_disable_boost_level_)
{}

const std::int32_t chatBoostFeatures::ID;

void chatBoostFeatures::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoostFeatures");
    { s.store_vector_begin("features", features_.size()); for (const auto &_value : features_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("min_profile_background_custom_emoji_boost_level", min_profile_background_custom_emoji_boost_level_);
    s.store_field("min_background_custom_emoji_boost_level", min_background_custom_emoji_boost_level_);
    s.store_field("min_emoji_status_boost_level", min_emoji_status_boost_level_);
    s.store_field("min_chat_theme_background_boost_level", min_chat_theme_background_boost_level_);
    s.store_field("min_custom_background_boost_level", min_custom_background_boost_level_);
    s.store_field("min_custom_emoji_sticker_set_boost_level", min_custom_emoji_sticker_set_boost_level_);
    s.store_field("min_speech_recognition_boost_level", min_speech_recognition_boost_level_);
    s.store_field("min_sponsored_message_disable_boost_level", min_sponsored_message_disable_boost_level_);
    s.store_class_end();
  }
}

chatBoostLevelFeatures::chatBoostLevelFeatures()
  : level_()
  , story_per_day_count_()
  , custom_emoji_reaction_count_()
  , title_color_count_()
  , profile_accent_color_count_()
  , can_set_profile_background_custom_emoji_()
  , accent_color_count_()
  , can_set_background_custom_emoji_()
  , can_set_emoji_status_()
  , chat_theme_background_count_()
  , can_set_custom_background_()
  , can_set_custom_emoji_sticker_set_()
  , can_recognize_speech_()
  , can_disable_sponsored_messages_()
{}

chatBoostLevelFeatures::chatBoostLevelFeatures(int32 level_, int32 story_per_day_count_, int32 custom_emoji_reaction_count_, int32 title_color_count_, int32 profile_accent_color_count_, bool can_set_profile_background_custom_emoji_, int32 accent_color_count_, bool can_set_background_custom_emoji_, bool can_set_emoji_status_, int32 chat_theme_background_count_, bool can_set_custom_background_, bool can_set_custom_emoji_sticker_set_, bool can_recognize_speech_, bool can_disable_sponsored_messages_)
  : level_(level_)
  , story_per_day_count_(story_per_day_count_)
  , custom_emoji_reaction_count_(custom_emoji_reaction_count_)
  , title_color_count_(title_color_count_)
  , profile_accent_color_count_(profile_accent_color_count_)
  , can_set_profile_background_custom_emoji_(can_set_profile_background_custom_emoji_)
  , accent_color_count_(accent_color_count_)
  , can_set_background_custom_emoji_(can_set_background_custom_emoji_)
  , can_set_emoji_status_(can_set_emoji_status_)
  , chat_theme_background_count_(chat_theme_background_count_)
  , can_set_custom_background_(can_set_custom_background_)
  , can_set_custom_emoji_sticker_set_(can_set_custom_emoji_sticker_set_)
  , can_recognize_speech_(can_recognize_speech_)
  , can_disable_sponsored_messages_(can_disable_sponsored_messages_)
{}

const std::int32_t chatBoostLevelFeatures::ID;

void chatBoostLevelFeatures::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoostLevelFeatures");
    s.store_field("level", level_);
    s.store_field("story_per_day_count", story_per_day_count_);
    s.store_field("custom_emoji_reaction_count", custom_emoji_reaction_count_);
    s.store_field("title_color_count", title_color_count_);
    s.store_field("profile_accent_color_count", profile_accent_color_count_);
    s.store_field("can_set_profile_background_custom_emoji", can_set_profile_background_custom_emoji_);
    s.store_field("accent_color_count", accent_color_count_);
    s.store_field("can_set_background_custom_emoji", can_set_background_custom_emoji_);
    s.store_field("can_set_emoji_status", can_set_emoji_status_);
    s.store_field("chat_theme_background_count", chat_theme_background_count_);
    s.store_field("can_set_custom_background", can_set_custom_background_);
    s.store_field("can_set_custom_emoji_sticker_set", can_set_custom_emoji_sticker_set_);
    s.store_field("can_recognize_speech", can_recognize_speech_);
    s.store_field("can_disable_sponsored_messages", can_disable_sponsored_messages_);
    s.store_class_end();
  }
}

chatBoostLink::chatBoostLink()
  : link_()
  , is_public_()
{}

chatBoostLink::chatBoostLink(string const &link_, bool is_public_)
  : link_(link_)
  , is_public_(is_public_)
{}

const std::int32_t chatBoostLink::ID;

void chatBoostLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoostLink");
    s.store_field("link", link_);
    s.store_field("is_public", is_public_);
    s.store_class_end();
  }
}

chatBoostLinkInfo::chatBoostLinkInfo()
  : is_public_()
  , chat_id_()
{}

chatBoostLinkInfo::chatBoostLinkInfo(bool is_public_, int53 chat_id_)
  : is_public_(is_public_)
  , chat_id_(chat_id_)
{}

const std::int32_t chatBoostLinkInfo::ID;

void chatBoostLinkInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoostLinkInfo");
    s.store_field("is_public", is_public_);
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

chatBoostSlot::chatBoostSlot()
  : slot_id_()
  , currently_boosted_chat_id_()
  , start_date_()
  , expiration_date_()
  , cooldown_until_date_()
{}

chatBoostSlot::chatBoostSlot(int32 slot_id_, int53 currently_boosted_chat_id_, int32 start_date_, int32 expiration_date_, int32 cooldown_until_date_)
  : slot_id_(slot_id_)
  , currently_boosted_chat_id_(currently_boosted_chat_id_)
  , start_date_(start_date_)
  , expiration_date_(expiration_date_)
  , cooldown_until_date_(cooldown_until_date_)
{}

const std::int32_t chatBoostSlot::ID;

void chatBoostSlot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoostSlot");
    s.store_field("slot_id", slot_id_);
    s.store_field("currently_boosted_chat_id", currently_boosted_chat_id_);
    s.store_field("start_date", start_date_);
    s.store_field("expiration_date", expiration_date_);
    s.store_field("cooldown_until_date", cooldown_until_date_);
    s.store_class_end();
  }
}

chatBoostSlots::chatBoostSlots()
  : slots_()
{}

chatBoostSlots::chatBoostSlots(array<object_ptr<chatBoostSlot>> &&slots_)
  : slots_(std::move(slots_))
{}

const std::int32_t chatBoostSlots::ID;

void chatBoostSlots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoostSlots");
    { s.store_vector_begin("slots", slots_.size()); for (const auto &_value : slots_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatBoostSourceGiftCode::chatBoostSourceGiftCode()
  : user_id_()
  , gift_code_()
{}

chatBoostSourceGiftCode::chatBoostSourceGiftCode(int53 user_id_, string const &gift_code_)
  : user_id_(user_id_)
  , gift_code_(gift_code_)
{}

const std::int32_t chatBoostSourceGiftCode::ID;

void chatBoostSourceGiftCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoostSourceGiftCode");
    s.store_field("user_id", user_id_);
    s.store_field("gift_code", gift_code_);
    s.store_class_end();
  }
}

chatBoostSourceGiveaway::chatBoostSourceGiveaway()
  : user_id_()
  , gift_code_()
  , star_count_()
  , giveaway_message_id_()
  , is_unclaimed_()
{}

chatBoostSourceGiveaway::chatBoostSourceGiveaway(int53 user_id_, string const &gift_code_, int53 star_count_, int53 giveaway_message_id_, bool is_unclaimed_)
  : user_id_(user_id_)
  , gift_code_(gift_code_)
  , star_count_(star_count_)
  , giveaway_message_id_(giveaway_message_id_)
  , is_unclaimed_(is_unclaimed_)
{}

const std::int32_t chatBoostSourceGiveaway::ID;

void chatBoostSourceGiveaway::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoostSourceGiveaway");
    s.store_field("user_id", user_id_);
    s.store_field("gift_code", gift_code_);
    s.store_field("star_count", star_count_);
    s.store_field("giveaway_message_id", giveaway_message_id_);
    s.store_field("is_unclaimed", is_unclaimed_);
    s.store_class_end();
  }
}

chatBoostSourcePremium::chatBoostSourcePremium()
  : user_id_()
{}

chatBoostSourcePremium::chatBoostSourcePremium(int53 user_id_)
  : user_id_(user_id_)
{}

const std::int32_t chatBoostSourcePremium::ID;

void chatBoostSourcePremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoostSourcePremium");
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

chatBoostStatus::chatBoostStatus()
  : boost_url_()
  , applied_slot_ids_()
  , level_()
  , gift_code_boost_count_()
  , boost_count_()
  , current_level_boost_count_()
  , next_level_boost_count_()
  , premium_member_count_()
  , premium_member_percentage_()
  , prepaid_giveaways_()
{}

chatBoostStatus::chatBoostStatus(string const &boost_url_, array<int32> &&applied_slot_ids_, int32 level_, int32 gift_code_boost_count_, int32 boost_count_, int32 current_level_boost_count_, int32 next_level_boost_count_, int32 premium_member_count_, double premium_member_percentage_, array<object_ptr<prepaidGiveaway>> &&prepaid_giveaways_)
  : boost_url_(boost_url_)
  , applied_slot_ids_(std::move(applied_slot_ids_))
  , level_(level_)
  , gift_code_boost_count_(gift_code_boost_count_)
  , boost_count_(boost_count_)
  , current_level_boost_count_(current_level_boost_count_)
  , next_level_boost_count_(next_level_boost_count_)
  , premium_member_count_(premium_member_count_)
  , premium_member_percentage_(premium_member_percentage_)
  , prepaid_giveaways_(std::move(prepaid_giveaways_))
{}

const std::int32_t chatBoostStatus::ID;

void chatBoostStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatBoostStatus");
    s.store_field("boost_url", boost_url_);
    { s.store_vector_begin("applied_slot_ids", applied_slot_ids_.size()); for (const auto &_value : applied_slot_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("level", level_);
    s.store_field("gift_code_boost_count", gift_code_boost_count_);
    s.store_field("boost_count", boost_count_);
    s.store_field("current_level_boost_count", current_level_boost_count_);
    s.store_field("next_level_boost_count", next_level_boost_count_);
    s.store_field("premium_member_count", premium_member_count_);
    s.store_field("premium_member_percentage", premium_member_percentage_);
    { s.store_vector_begin("prepaid_giveaways", prepaid_giveaways_.size()); for (const auto &_value : prepaid_giveaways_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatEvent::chatEvent()
  : id_()
  , date_()
  , member_id_()
  , action_()
{}

chatEvent::chatEvent(int64 id_, int32 date_, object_ptr<MessageSender> &&member_id_, object_ptr<ChatEventAction> &&action_)
  : id_(id_)
  , date_(date_)
  , member_id_(std::move(member_id_))
  , action_(std::move(action_))
{}

const std::int32_t chatEvent::ID;

void chatEvent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEvent");
    s.store_field("id", id_);
    s.store_field("date", date_);
    s.store_object_field("member_id", static_cast<const BaseObject *>(member_id_.get()));
    s.store_object_field("action", static_cast<const BaseObject *>(action_.get()));
    s.store_class_end();
  }
}

chatEventMessageEdited::chatEventMessageEdited()
  : old_message_()
  , new_message_()
{}

chatEventMessageEdited::chatEventMessageEdited(object_ptr<message> &&old_message_, object_ptr<message> &&new_message_)
  : old_message_(std::move(old_message_))
  , new_message_(std::move(new_message_))
{}

const std::int32_t chatEventMessageEdited::ID;

void chatEventMessageEdited::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMessageEdited");
    s.store_object_field("old_message", static_cast<const BaseObject *>(old_message_.get()));
    s.store_object_field("new_message", static_cast<const BaseObject *>(new_message_.get()));
    s.store_class_end();
  }
}

chatEventMessageDeleted::chatEventMessageDeleted()
  : message_()
  , can_report_anti_spam_false_positive_()
{}

chatEventMessageDeleted::chatEventMessageDeleted(object_ptr<message> &&message_, bool can_report_anti_spam_false_positive_)
  : message_(std::move(message_))
  , can_report_anti_spam_false_positive_(can_report_anti_spam_false_positive_)
{}

const std::int32_t chatEventMessageDeleted::ID;

void chatEventMessageDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMessageDeleted");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_field("can_report_anti_spam_false_positive", can_report_anti_spam_false_positive_);
    s.store_class_end();
  }
}

chatEventMessagePinned::chatEventMessagePinned()
  : message_()
{}

chatEventMessagePinned::chatEventMessagePinned(object_ptr<message> &&message_)
  : message_(std::move(message_))
{}

const std::int32_t chatEventMessagePinned::ID;

void chatEventMessagePinned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMessagePinned");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

chatEventMessageUnpinned::chatEventMessageUnpinned()
  : message_()
{}

chatEventMessageUnpinned::chatEventMessageUnpinned(object_ptr<message> &&message_)
  : message_(std::move(message_))
{}

const std::int32_t chatEventMessageUnpinned::ID;

void chatEventMessageUnpinned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMessageUnpinned");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

chatEventPollStopped::chatEventPollStopped()
  : message_()
{}

chatEventPollStopped::chatEventPollStopped(object_ptr<message> &&message_)
  : message_(std::move(message_))
{}

const std::int32_t chatEventPollStopped::ID;

void chatEventPollStopped::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventPollStopped");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

chatEventMemberJoined::chatEventMemberJoined() {
}

const std::int32_t chatEventMemberJoined::ID;

void chatEventMemberJoined::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMemberJoined");
    s.store_class_end();
  }
}

chatEventMemberJoinedByInviteLink::chatEventMemberJoinedByInviteLink()
  : invite_link_()
  , via_chat_folder_invite_link_()
{}

chatEventMemberJoinedByInviteLink::chatEventMemberJoinedByInviteLink(object_ptr<chatInviteLink> &&invite_link_, bool via_chat_folder_invite_link_)
  : invite_link_(std::move(invite_link_))
  , via_chat_folder_invite_link_(via_chat_folder_invite_link_)
{}

const std::int32_t chatEventMemberJoinedByInviteLink::ID;

void chatEventMemberJoinedByInviteLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMemberJoinedByInviteLink");
    s.store_object_field("invite_link", static_cast<const BaseObject *>(invite_link_.get()));
    s.store_field("via_chat_folder_invite_link", via_chat_folder_invite_link_);
    s.store_class_end();
  }
}

chatEventMemberJoinedByRequest::chatEventMemberJoinedByRequest()
  : approver_user_id_()
  , invite_link_()
{}

chatEventMemberJoinedByRequest::chatEventMemberJoinedByRequest(int53 approver_user_id_, object_ptr<chatInviteLink> &&invite_link_)
  : approver_user_id_(approver_user_id_)
  , invite_link_(std::move(invite_link_))
{}

const std::int32_t chatEventMemberJoinedByRequest::ID;

void chatEventMemberJoinedByRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMemberJoinedByRequest");
    s.store_field("approver_user_id", approver_user_id_);
    s.store_object_field("invite_link", static_cast<const BaseObject *>(invite_link_.get()));
    s.store_class_end();
  }
}

chatEventMemberInvited::chatEventMemberInvited()
  : user_id_()
  , status_()
{}

chatEventMemberInvited::chatEventMemberInvited(int53 user_id_, object_ptr<ChatMemberStatus> &&status_)
  : user_id_(user_id_)
  , status_(std::move(status_))
{}

const std::int32_t chatEventMemberInvited::ID;

void chatEventMemberInvited::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMemberInvited");
    s.store_field("user_id", user_id_);
    s.store_object_field("status", static_cast<const BaseObject *>(status_.get()));
    s.store_class_end();
  }
}

chatEventMemberLeft::chatEventMemberLeft() {
}

const std::int32_t chatEventMemberLeft::ID;

void chatEventMemberLeft::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMemberLeft");
    s.store_class_end();
  }
}

chatEventMemberPromoted::chatEventMemberPromoted()
  : user_id_()
  , old_status_()
  , new_status_()
{}

chatEventMemberPromoted::chatEventMemberPromoted(int53 user_id_, object_ptr<ChatMemberStatus> &&old_status_, object_ptr<ChatMemberStatus> &&new_status_)
  : user_id_(user_id_)
  , old_status_(std::move(old_status_))
  , new_status_(std::move(new_status_))
{}

const std::int32_t chatEventMemberPromoted::ID;

void chatEventMemberPromoted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMemberPromoted");
    s.store_field("user_id", user_id_);
    s.store_object_field("old_status", static_cast<const BaseObject *>(old_status_.get()));
    s.store_object_field("new_status", static_cast<const BaseObject *>(new_status_.get()));
    s.store_class_end();
  }
}

chatEventMemberRestricted::chatEventMemberRestricted()
  : member_id_()
  , old_status_()
  , new_status_()
{}

chatEventMemberRestricted::chatEventMemberRestricted(object_ptr<MessageSender> &&member_id_, object_ptr<ChatMemberStatus> &&old_status_, object_ptr<ChatMemberStatus> &&new_status_)
  : member_id_(std::move(member_id_))
  , old_status_(std::move(old_status_))
  , new_status_(std::move(new_status_))
{}

const std::int32_t chatEventMemberRestricted::ID;

void chatEventMemberRestricted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMemberRestricted");
    s.store_object_field("member_id", static_cast<const BaseObject *>(member_id_.get()));
    s.store_object_field("old_status", static_cast<const BaseObject *>(old_status_.get()));
    s.store_object_field("new_status", static_cast<const BaseObject *>(new_status_.get()));
    s.store_class_end();
  }
}

chatEventMemberSubscriptionExtended::chatEventMemberSubscriptionExtended()
  : user_id_()
  , old_status_()
  , new_status_()
{}

chatEventMemberSubscriptionExtended::chatEventMemberSubscriptionExtended(int53 user_id_, object_ptr<ChatMemberStatus> &&old_status_, object_ptr<ChatMemberStatus> &&new_status_)
  : user_id_(user_id_)
  , old_status_(std::move(old_status_))
  , new_status_(std::move(new_status_))
{}

const std::int32_t chatEventMemberSubscriptionExtended::ID;

void chatEventMemberSubscriptionExtended::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMemberSubscriptionExtended");
    s.store_field("user_id", user_id_);
    s.store_object_field("old_status", static_cast<const BaseObject *>(old_status_.get()));
    s.store_object_field("new_status", static_cast<const BaseObject *>(new_status_.get()));
    s.store_class_end();
  }
}

chatEventAvailableReactionsChanged::chatEventAvailableReactionsChanged()
  : old_available_reactions_()
  , new_available_reactions_()
{}

chatEventAvailableReactionsChanged::chatEventAvailableReactionsChanged(object_ptr<ChatAvailableReactions> &&old_available_reactions_, object_ptr<ChatAvailableReactions> &&new_available_reactions_)
  : old_available_reactions_(std::move(old_available_reactions_))
  , new_available_reactions_(std::move(new_available_reactions_))
{}

const std::int32_t chatEventAvailableReactionsChanged::ID;

void chatEventAvailableReactionsChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventAvailableReactionsChanged");
    s.store_object_field("old_available_reactions", static_cast<const BaseObject *>(old_available_reactions_.get()));
    s.store_object_field("new_available_reactions", static_cast<const BaseObject *>(new_available_reactions_.get()));
    s.store_class_end();
  }
}

chatEventBackgroundChanged::chatEventBackgroundChanged()
  : old_background_()
  , new_background_()
{}

chatEventBackgroundChanged::chatEventBackgroundChanged(object_ptr<chatBackground> &&old_background_, object_ptr<chatBackground> &&new_background_)
  : old_background_(std::move(old_background_))
  , new_background_(std::move(new_background_))
{}

const std::int32_t chatEventBackgroundChanged::ID;

void chatEventBackgroundChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventBackgroundChanged");
    s.store_object_field("old_background", static_cast<const BaseObject *>(old_background_.get()));
    s.store_object_field("new_background", static_cast<const BaseObject *>(new_background_.get()));
    s.store_class_end();
  }
}

chatEventDescriptionChanged::chatEventDescriptionChanged()
  : old_description_()
  , new_description_()
{}

chatEventDescriptionChanged::chatEventDescriptionChanged(string const &old_description_, string const &new_description_)
  : old_description_(old_description_)
  , new_description_(new_description_)
{}

const std::int32_t chatEventDescriptionChanged::ID;

void chatEventDescriptionChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventDescriptionChanged");
    s.store_field("old_description", old_description_);
    s.store_field("new_description", new_description_);
    s.store_class_end();
  }
}

chatEventEmojiStatusChanged::chatEventEmojiStatusChanged()
  : old_emoji_status_()
  , new_emoji_status_()
{}

chatEventEmojiStatusChanged::chatEventEmojiStatusChanged(object_ptr<emojiStatus> &&old_emoji_status_, object_ptr<emojiStatus> &&new_emoji_status_)
  : old_emoji_status_(std::move(old_emoji_status_))
  , new_emoji_status_(std::move(new_emoji_status_))
{}

const std::int32_t chatEventEmojiStatusChanged::ID;

void chatEventEmojiStatusChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventEmojiStatusChanged");
    s.store_object_field("old_emoji_status", static_cast<const BaseObject *>(old_emoji_status_.get()));
    s.store_object_field("new_emoji_status", static_cast<const BaseObject *>(new_emoji_status_.get()));
    s.store_class_end();
  }
}

chatEventLinkedChatChanged::chatEventLinkedChatChanged()
  : old_linked_chat_id_()
  , new_linked_chat_id_()
{}

chatEventLinkedChatChanged::chatEventLinkedChatChanged(int53 old_linked_chat_id_, int53 new_linked_chat_id_)
  : old_linked_chat_id_(old_linked_chat_id_)
  , new_linked_chat_id_(new_linked_chat_id_)
{}

const std::int32_t chatEventLinkedChatChanged::ID;

void chatEventLinkedChatChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventLinkedChatChanged");
    s.store_field("old_linked_chat_id", old_linked_chat_id_);
    s.store_field("new_linked_chat_id", new_linked_chat_id_);
    s.store_class_end();
  }
}

chatEventLocationChanged::chatEventLocationChanged()
  : old_location_()
  , new_location_()
{}

chatEventLocationChanged::chatEventLocationChanged(object_ptr<chatLocation> &&old_location_, object_ptr<chatLocation> &&new_location_)
  : old_location_(std::move(old_location_))
  , new_location_(std::move(new_location_))
{}

const std::int32_t chatEventLocationChanged::ID;

void chatEventLocationChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventLocationChanged");
    s.store_object_field("old_location", static_cast<const BaseObject *>(old_location_.get()));
    s.store_object_field("new_location", static_cast<const BaseObject *>(new_location_.get()));
    s.store_class_end();
  }
}

chatEventMessageAutoDeleteTimeChanged::chatEventMessageAutoDeleteTimeChanged()
  : old_message_auto_delete_time_()
  , new_message_auto_delete_time_()
{}

chatEventMessageAutoDeleteTimeChanged::chatEventMessageAutoDeleteTimeChanged(int32 old_message_auto_delete_time_, int32 new_message_auto_delete_time_)
  : old_message_auto_delete_time_(old_message_auto_delete_time_)
  , new_message_auto_delete_time_(new_message_auto_delete_time_)
{}

const std::int32_t chatEventMessageAutoDeleteTimeChanged::ID;

void chatEventMessageAutoDeleteTimeChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventMessageAutoDeleteTimeChanged");
    s.store_field("old_message_auto_delete_time", old_message_auto_delete_time_);
    s.store_field("new_message_auto_delete_time", new_message_auto_delete_time_);
    s.store_class_end();
  }
}

chatEventPermissionsChanged::chatEventPermissionsChanged()
  : old_permissions_()
  , new_permissions_()
{}

chatEventPermissionsChanged::chatEventPermissionsChanged(object_ptr<chatPermissions> &&old_permissions_, object_ptr<chatPermissions> &&new_permissions_)
  : old_permissions_(std::move(old_permissions_))
  , new_permissions_(std::move(new_permissions_))
{}

const std::int32_t chatEventPermissionsChanged::ID;

void chatEventPermissionsChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventPermissionsChanged");
    s.store_object_field("old_permissions", static_cast<const BaseObject *>(old_permissions_.get()));
    s.store_object_field("new_permissions", static_cast<const BaseObject *>(new_permissions_.get()));
    s.store_class_end();
  }
}

chatEventPhotoChanged::chatEventPhotoChanged()
  : old_photo_()
  , new_photo_()
{}

chatEventPhotoChanged::chatEventPhotoChanged(object_ptr<chatPhoto> &&old_photo_, object_ptr<chatPhoto> &&new_photo_)
  : old_photo_(std::move(old_photo_))
  , new_photo_(std::move(new_photo_))
{}

const std::int32_t chatEventPhotoChanged::ID;

void chatEventPhotoChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventPhotoChanged");
    s.store_object_field("old_photo", static_cast<const BaseObject *>(old_photo_.get()));
    s.store_object_field("new_photo", static_cast<const BaseObject *>(new_photo_.get()));
    s.store_class_end();
  }
}

chatEventSlowModeDelayChanged::chatEventSlowModeDelayChanged()
  : old_slow_mode_delay_()
  , new_slow_mode_delay_()
{}

chatEventSlowModeDelayChanged::chatEventSlowModeDelayChanged(int32 old_slow_mode_delay_, int32 new_slow_mode_delay_)
  : old_slow_mode_delay_(old_slow_mode_delay_)
  , new_slow_mode_delay_(new_slow_mode_delay_)
{}

const std::int32_t chatEventSlowModeDelayChanged::ID;

void chatEventSlowModeDelayChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventSlowModeDelayChanged");
    s.store_field("old_slow_mode_delay", old_slow_mode_delay_);
    s.store_field("new_slow_mode_delay", new_slow_mode_delay_);
    s.store_class_end();
  }
}

chatEventStickerSetChanged::chatEventStickerSetChanged()
  : old_sticker_set_id_()
  , new_sticker_set_id_()
{}

chatEventStickerSetChanged::chatEventStickerSetChanged(int64 old_sticker_set_id_, int64 new_sticker_set_id_)
  : old_sticker_set_id_(old_sticker_set_id_)
  , new_sticker_set_id_(new_sticker_set_id_)
{}

const std::int32_t chatEventStickerSetChanged::ID;

void chatEventStickerSetChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventStickerSetChanged");
    s.store_field("old_sticker_set_id", old_sticker_set_id_);
    s.store_field("new_sticker_set_id", new_sticker_set_id_);
    s.store_class_end();
  }
}

chatEventCustomEmojiStickerSetChanged::chatEventCustomEmojiStickerSetChanged()
  : old_sticker_set_id_()
  , new_sticker_set_id_()
{}

chatEventCustomEmojiStickerSetChanged::chatEventCustomEmojiStickerSetChanged(int64 old_sticker_set_id_, int64 new_sticker_set_id_)
  : old_sticker_set_id_(old_sticker_set_id_)
  , new_sticker_set_id_(new_sticker_set_id_)
{}

const std::int32_t chatEventCustomEmojiStickerSetChanged::ID;

void chatEventCustomEmojiStickerSetChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventCustomEmojiStickerSetChanged");
    s.store_field("old_sticker_set_id", old_sticker_set_id_);
    s.store_field("new_sticker_set_id", new_sticker_set_id_);
    s.store_class_end();
  }
}

chatEventTitleChanged::chatEventTitleChanged()
  : old_title_()
  , new_title_()
{}

chatEventTitleChanged::chatEventTitleChanged(string const &old_title_, string const &new_title_)
  : old_title_(old_title_)
  , new_title_(new_title_)
{}

const std::int32_t chatEventTitleChanged::ID;

void chatEventTitleChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventTitleChanged");
    s.store_field("old_title", old_title_);
    s.store_field("new_title", new_title_);
    s.store_class_end();
  }
}

chatEventUsernameChanged::chatEventUsernameChanged()
  : old_username_()
  , new_username_()
{}

chatEventUsernameChanged::chatEventUsernameChanged(string const &old_username_, string const &new_username_)
  : old_username_(old_username_)
  , new_username_(new_username_)
{}

const std::int32_t chatEventUsernameChanged::ID;

void chatEventUsernameChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventUsernameChanged");
    s.store_field("old_username", old_username_);
    s.store_field("new_username", new_username_);
    s.store_class_end();
  }
}

chatEventActiveUsernamesChanged::chatEventActiveUsernamesChanged()
  : old_usernames_()
  , new_usernames_()
{}

chatEventActiveUsernamesChanged::chatEventActiveUsernamesChanged(array<string> &&old_usernames_, array<string> &&new_usernames_)
  : old_usernames_(std::move(old_usernames_))
  , new_usernames_(std::move(new_usernames_))
{}

const std::int32_t chatEventActiveUsernamesChanged::ID;

void chatEventActiveUsernamesChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventActiveUsernamesChanged");
    { s.store_vector_begin("old_usernames", old_usernames_.size()); for (const auto &_value : old_usernames_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("new_usernames", new_usernames_.size()); for (const auto &_value : new_usernames_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatEventAccentColorChanged::chatEventAccentColorChanged()
  : old_accent_color_id_()
  , old_background_custom_emoji_id_()
  , new_accent_color_id_()
  , new_background_custom_emoji_id_()
{}

chatEventAccentColorChanged::chatEventAccentColorChanged(int32 old_accent_color_id_, int64 old_background_custom_emoji_id_, int32 new_accent_color_id_, int64 new_background_custom_emoji_id_)
  : old_accent_color_id_(old_accent_color_id_)
  , old_background_custom_emoji_id_(old_background_custom_emoji_id_)
  , new_accent_color_id_(new_accent_color_id_)
  , new_background_custom_emoji_id_(new_background_custom_emoji_id_)
{}

const std::int32_t chatEventAccentColorChanged::ID;

void chatEventAccentColorChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventAccentColorChanged");
    s.store_field("old_accent_color_id", old_accent_color_id_);
    s.store_field("old_background_custom_emoji_id", old_background_custom_emoji_id_);
    s.store_field("new_accent_color_id", new_accent_color_id_);
    s.store_field("new_background_custom_emoji_id", new_background_custom_emoji_id_);
    s.store_class_end();
  }
}

chatEventProfileAccentColorChanged::chatEventProfileAccentColorChanged()
  : old_profile_accent_color_id_()
  , old_profile_background_custom_emoji_id_()
  , new_profile_accent_color_id_()
  , new_profile_background_custom_emoji_id_()
{}

chatEventProfileAccentColorChanged::chatEventProfileAccentColorChanged(int32 old_profile_accent_color_id_, int64 old_profile_background_custom_emoji_id_, int32 new_profile_accent_color_id_, int64 new_profile_background_custom_emoji_id_)
  : old_profile_accent_color_id_(old_profile_accent_color_id_)
  , old_profile_background_custom_emoji_id_(old_profile_background_custom_emoji_id_)
  , new_profile_accent_color_id_(new_profile_accent_color_id_)
  , new_profile_background_custom_emoji_id_(new_profile_background_custom_emoji_id_)
{}

const std::int32_t chatEventProfileAccentColorChanged::ID;

void chatEventProfileAccentColorChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventProfileAccentColorChanged");
    s.store_field("old_profile_accent_color_id", old_profile_accent_color_id_);
    s.store_field("old_profile_background_custom_emoji_id", old_profile_background_custom_emoji_id_);
    s.store_field("new_profile_accent_color_id", new_profile_accent_color_id_);
    s.store_field("new_profile_background_custom_emoji_id", new_profile_background_custom_emoji_id_);
    s.store_class_end();
  }
}

chatEventHasProtectedContentToggled::chatEventHasProtectedContentToggled()
  : has_protected_content_()
{}

chatEventHasProtectedContentToggled::chatEventHasProtectedContentToggled(bool has_protected_content_)
  : has_protected_content_(has_protected_content_)
{}

const std::int32_t chatEventHasProtectedContentToggled::ID;

void chatEventHasProtectedContentToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventHasProtectedContentToggled");
    s.store_field("has_protected_content", has_protected_content_);
    s.store_class_end();
  }
}

chatEventInvitesToggled::chatEventInvitesToggled()
  : can_invite_users_()
{}

chatEventInvitesToggled::chatEventInvitesToggled(bool can_invite_users_)
  : can_invite_users_(can_invite_users_)
{}

const std::int32_t chatEventInvitesToggled::ID;

void chatEventInvitesToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventInvitesToggled");
    s.store_field("can_invite_users", can_invite_users_);
    s.store_class_end();
  }
}

chatEventIsAllHistoryAvailableToggled::chatEventIsAllHistoryAvailableToggled()
  : is_all_history_available_()
{}

chatEventIsAllHistoryAvailableToggled::chatEventIsAllHistoryAvailableToggled(bool is_all_history_available_)
  : is_all_history_available_(is_all_history_available_)
{}

const std::int32_t chatEventIsAllHistoryAvailableToggled::ID;

void chatEventIsAllHistoryAvailableToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventIsAllHistoryAvailableToggled");
    s.store_field("is_all_history_available", is_all_history_available_);
    s.store_class_end();
  }
}

chatEventHasAggressiveAntiSpamEnabledToggled::chatEventHasAggressiveAntiSpamEnabledToggled()
  : has_aggressive_anti_spam_enabled_()
{}

chatEventHasAggressiveAntiSpamEnabledToggled::chatEventHasAggressiveAntiSpamEnabledToggled(bool has_aggressive_anti_spam_enabled_)
  : has_aggressive_anti_spam_enabled_(has_aggressive_anti_spam_enabled_)
{}

const std::int32_t chatEventHasAggressiveAntiSpamEnabledToggled::ID;

void chatEventHasAggressiveAntiSpamEnabledToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventHasAggressiveAntiSpamEnabledToggled");
    s.store_field("has_aggressive_anti_spam_enabled", has_aggressive_anti_spam_enabled_);
    s.store_class_end();
  }
}

chatEventSignMessagesToggled::chatEventSignMessagesToggled()
  : sign_messages_()
{}

chatEventSignMessagesToggled::chatEventSignMessagesToggled(bool sign_messages_)
  : sign_messages_(sign_messages_)
{}

const std::int32_t chatEventSignMessagesToggled::ID;

void chatEventSignMessagesToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventSignMessagesToggled");
    s.store_field("sign_messages", sign_messages_);
    s.store_class_end();
  }
}

chatEventShowMessageSenderToggled::chatEventShowMessageSenderToggled()
  : show_message_sender_()
{}

chatEventShowMessageSenderToggled::chatEventShowMessageSenderToggled(bool show_message_sender_)
  : show_message_sender_(show_message_sender_)
{}

const std::int32_t chatEventShowMessageSenderToggled::ID;

void chatEventShowMessageSenderToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventShowMessageSenderToggled");
    s.store_field("show_message_sender", show_message_sender_);
    s.store_class_end();
  }
}

chatEventInviteLinkEdited::chatEventInviteLinkEdited()
  : old_invite_link_()
  , new_invite_link_()
{}

chatEventInviteLinkEdited::chatEventInviteLinkEdited(object_ptr<chatInviteLink> &&old_invite_link_, object_ptr<chatInviteLink> &&new_invite_link_)
  : old_invite_link_(std::move(old_invite_link_))
  , new_invite_link_(std::move(new_invite_link_))
{}

const std::int32_t chatEventInviteLinkEdited::ID;

void chatEventInviteLinkEdited::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventInviteLinkEdited");
    s.store_object_field("old_invite_link", static_cast<const BaseObject *>(old_invite_link_.get()));
    s.store_object_field("new_invite_link", static_cast<const BaseObject *>(new_invite_link_.get()));
    s.store_class_end();
  }
}

chatEventInviteLinkRevoked::chatEventInviteLinkRevoked()
  : invite_link_()
{}

chatEventInviteLinkRevoked::chatEventInviteLinkRevoked(object_ptr<chatInviteLink> &&invite_link_)
  : invite_link_(std::move(invite_link_))
{}

const std::int32_t chatEventInviteLinkRevoked::ID;

void chatEventInviteLinkRevoked::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventInviteLinkRevoked");
    s.store_object_field("invite_link", static_cast<const BaseObject *>(invite_link_.get()));
    s.store_class_end();
  }
}

chatEventInviteLinkDeleted::chatEventInviteLinkDeleted()
  : invite_link_()
{}

chatEventInviteLinkDeleted::chatEventInviteLinkDeleted(object_ptr<chatInviteLink> &&invite_link_)
  : invite_link_(std::move(invite_link_))
{}

const std::int32_t chatEventInviteLinkDeleted::ID;

void chatEventInviteLinkDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventInviteLinkDeleted");
    s.store_object_field("invite_link", static_cast<const BaseObject *>(invite_link_.get()));
    s.store_class_end();
  }
}

chatEventVideoChatCreated::chatEventVideoChatCreated()
  : group_call_id_()
{}

chatEventVideoChatCreated::chatEventVideoChatCreated(int32 group_call_id_)
  : group_call_id_(group_call_id_)
{}

const std::int32_t chatEventVideoChatCreated::ID;

void chatEventVideoChatCreated::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventVideoChatCreated");
    s.store_field("group_call_id", group_call_id_);
    s.store_class_end();
  }
}

chatEventVideoChatEnded::chatEventVideoChatEnded()
  : group_call_id_()
{}

chatEventVideoChatEnded::chatEventVideoChatEnded(int32 group_call_id_)
  : group_call_id_(group_call_id_)
{}

const std::int32_t chatEventVideoChatEnded::ID;

void chatEventVideoChatEnded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventVideoChatEnded");
    s.store_field("group_call_id", group_call_id_);
    s.store_class_end();
  }
}

chatEventVideoChatMuteNewParticipantsToggled::chatEventVideoChatMuteNewParticipantsToggled()
  : mute_new_participants_()
{}

chatEventVideoChatMuteNewParticipantsToggled::chatEventVideoChatMuteNewParticipantsToggled(bool mute_new_participants_)
  : mute_new_participants_(mute_new_participants_)
{}

const std::int32_t chatEventVideoChatMuteNewParticipantsToggled::ID;

void chatEventVideoChatMuteNewParticipantsToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventVideoChatMuteNewParticipantsToggled");
    s.store_field("mute_new_participants", mute_new_participants_);
    s.store_class_end();
  }
}

chatEventVideoChatParticipantIsMutedToggled::chatEventVideoChatParticipantIsMutedToggled()
  : participant_id_()
  , is_muted_()
{}

chatEventVideoChatParticipantIsMutedToggled::chatEventVideoChatParticipantIsMutedToggled(object_ptr<MessageSender> &&participant_id_, bool is_muted_)
  : participant_id_(std::move(participant_id_))
  , is_muted_(is_muted_)
{}

const std::int32_t chatEventVideoChatParticipantIsMutedToggled::ID;

void chatEventVideoChatParticipantIsMutedToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventVideoChatParticipantIsMutedToggled");
    s.store_object_field("participant_id", static_cast<const BaseObject *>(participant_id_.get()));
    s.store_field("is_muted", is_muted_);
    s.store_class_end();
  }
}

chatEventVideoChatParticipantVolumeLevelChanged::chatEventVideoChatParticipantVolumeLevelChanged()
  : participant_id_()
  , volume_level_()
{}

chatEventVideoChatParticipantVolumeLevelChanged::chatEventVideoChatParticipantVolumeLevelChanged(object_ptr<MessageSender> &&participant_id_, int32 volume_level_)
  : participant_id_(std::move(participant_id_))
  , volume_level_(volume_level_)
{}

const std::int32_t chatEventVideoChatParticipantVolumeLevelChanged::ID;

void chatEventVideoChatParticipantVolumeLevelChanged::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventVideoChatParticipantVolumeLevelChanged");
    s.store_object_field("participant_id", static_cast<const BaseObject *>(participant_id_.get()));
    s.store_field("volume_level", volume_level_);
    s.store_class_end();
  }
}

chatEventIsForumToggled::chatEventIsForumToggled()
  : is_forum_()
{}

chatEventIsForumToggled::chatEventIsForumToggled(bool is_forum_)
  : is_forum_(is_forum_)
{}

const std::int32_t chatEventIsForumToggled::ID;

void chatEventIsForumToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventIsForumToggled");
    s.store_field("is_forum", is_forum_);
    s.store_class_end();
  }
}

chatEventForumTopicCreated::chatEventForumTopicCreated()
  : topic_info_()
{}

chatEventForumTopicCreated::chatEventForumTopicCreated(object_ptr<forumTopicInfo> &&topic_info_)
  : topic_info_(std::move(topic_info_))
{}

const std::int32_t chatEventForumTopicCreated::ID;

void chatEventForumTopicCreated::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventForumTopicCreated");
    s.store_object_field("topic_info", static_cast<const BaseObject *>(topic_info_.get()));
    s.store_class_end();
  }
}

chatEventForumTopicEdited::chatEventForumTopicEdited()
  : old_topic_info_()
  , new_topic_info_()
{}

chatEventForumTopicEdited::chatEventForumTopicEdited(object_ptr<forumTopicInfo> &&old_topic_info_, object_ptr<forumTopicInfo> &&new_topic_info_)
  : old_topic_info_(std::move(old_topic_info_))
  , new_topic_info_(std::move(new_topic_info_))
{}

const std::int32_t chatEventForumTopicEdited::ID;

void chatEventForumTopicEdited::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventForumTopicEdited");
    s.store_object_field("old_topic_info", static_cast<const BaseObject *>(old_topic_info_.get()));
    s.store_object_field("new_topic_info", static_cast<const BaseObject *>(new_topic_info_.get()));
    s.store_class_end();
  }
}

chatEventForumTopicToggleIsClosed::chatEventForumTopicToggleIsClosed()
  : topic_info_()
{}

chatEventForumTopicToggleIsClosed::chatEventForumTopicToggleIsClosed(object_ptr<forumTopicInfo> &&topic_info_)
  : topic_info_(std::move(topic_info_))
{}

const std::int32_t chatEventForumTopicToggleIsClosed::ID;

void chatEventForumTopicToggleIsClosed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventForumTopicToggleIsClosed");
    s.store_object_field("topic_info", static_cast<const BaseObject *>(topic_info_.get()));
    s.store_class_end();
  }
}

chatEventForumTopicToggleIsHidden::chatEventForumTopicToggleIsHidden()
  : topic_info_()
{}

chatEventForumTopicToggleIsHidden::chatEventForumTopicToggleIsHidden(object_ptr<forumTopicInfo> &&topic_info_)
  : topic_info_(std::move(topic_info_))
{}

const std::int32_t chatEventForumTopicToggleIsHidden::ID;

void chatEventForumTopicToggleIsHidden::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventForumTopicToggleIsHidden");
    s.store_object_field("topic_info", static_cast<const BaseObject *>(topic_info_.get()));
    s.store_class_end();
  }
}

chatEventForumTopicDeleted::chatEventForumTopicDeleted()
  : topic_info_()
{}

chatEventForumTopicDeleted::chatEventForumTopicDeleted(object_ptr<forumTopicInfo> &&topic_info_)
  : topic_info_(std::move(topic_info_))
{}

const std::int32_t chatEventForumTopicDeleted::ID;

void chatEventForumTopicDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventForumTopicDeleted");
    s.store_object_field("topic_info", static_cast<const BaseObject *>(topic_info_.get()));
    s.store_class_end();
  }
}

chatEventForumTopicPinned::chatEventForumTopicPinned()
  : old_topic_info_()
  , new_topic_info_()
{}

chatEventForumTopicPinned::chatEventForumTopicPinned(object_ptr<forumTopicInfo> &&old_topic_info_, object_ptr<forumTopicInfo> &&new_topic_info_)
  : old_topic_info_(std::move(old_topic_info_))
  , new_topic_info_(std::move(new_topic_info_))
{}

const std::int32_t chatEventForumTopicPinned::ID;

void chatEventForumTopicPinned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventForumTopicPinned");
    s.store_object_field("old_topic_info", static_cast<const BaseObject *>(old_topic_info_.get()));
    s.store_object_field("new_topic_info", static_cast<const BaseObject *>(new_topic_info_.get()));
    s.store_class_end();
  }
}

chatEventLogFilters::chatEventLogFilters()
  : message_edits_()
  , message_deletions_()
  , message_pins_()
  , member_joins_()
  , member_leaves_()
  , member_invites_()
  , member_promotions_()
  , member_restrictions_()
  , info_changes_()
  , setting_changes_()
  , invite_link_changes_()
  , video_chat_changes_()
  , forum_changes_()
  , subscription_extensions_()
{}

chatEventLogFilters::chatEventLogFilters(bool message_edits_, bool message_deletions_, bool message_pins_, bool member_joins_, bool member_leaves_, bool member_invites_, bool member_promotions_, bool member_restrictions_, bool info_changes_, bool setting_changes_, bool invite_link_changes_, bool video_chat_changes_, bool forum_changes_, bool subscription_extensions_)
  : message_edits_(message_edits_)
  , message_deletions_(message_deletions_)
  , message_pins_(message_pins_)
  , member_joins_(member_joins_)
  , member_leaves_(member_leaves_)
  , member_invites_(member_invites_)
  , member_promotions_(member_promotions_)
  , member_restrictions_(member_restrictions_)
  , info_changes_(info_changes_)
  , setting_changes_(setting_changes_)
  , invite_link_changes_(invite_link_changes_)
  , video_chat_changes_(video_chat_changes_)
  , forum_changes_(forum_changes_)
  , subscription_extensions_(subscription_extensions_)
{}

const std::int32_t chatEventLogFilters::ID;

void chatEventLogFilters::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEventLogFilters");
    s.store_field("message_edits", message_edits_);
    s.store_field("message_deletions", message_deletions_);
    s.store_field("message_pins", message_pins_);
    s.store_field("member_joins", member_joins_);
    s.store_field("member_leaves", member_leaves_);
    s.store_field("member_invites", member_invites_);
    s.store_field("member_promotions", member_promotions_);
    s.store_field("member_restrictions", member_restrictions_);
    s.store_field("info_changes", info_changes_);
    s.store_field("setting_changes", setting_changes_);
    s.store_field("invite_link_changes", invite_link_changes_);
    s.store_field("video_chat_changes", video_chat_changes_);
    s.store_field("forum_changes", forum_changes_);
    s.store_field("subscription_extensions", subscription_extensions_);
    s.store_class_end();
  }
}

chatEvents::chatEvents()
  : events_()
{}

chatEvents::chatEvents(array<object_ptr<chatEvent>> &&events_)
  : events_(std::move(events_))
{}

const std::int32_t chatEvents::ID;

void chatEvents::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatEvents");
    { s.store_vector_begin("events", events_.size()); for (const auto &_value : events_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatFolder::chatFolder()
  : name_()
  , icon_()
  , color_id_()
  , is_shareable_()
  , pinned_chat_ids_()
  , included_chat_ids_()
  , excluded_chat_ids_()
  , exclude_muted_()
  , exclude_read_()
  , exclude_archived_()
  , include_contacts_()
  , include_non_contacts_()
  , include_bots_()
  , include_groups_()
  , include_channels_()
{}

chatFolder::chatFolder(object_ptr<chatFolderName> &&name_, object_ptr<chatFolderIcon> &&icon_, int32 color_id_, bool is_shareable_, array<int53> &&pinned_chat_ids_, array<int53> &&included_chat_ids_, array<int53> &&excluded_chat_ids_, bool exclude_muted_, bool exclude_read_, bool exclude_archived_, bool include_contacts_, bool include_non_contacts_, bool include_bots_, bool include_groups_, bool include_channels_)
  : name_(std::move(name_))
  , icon_(std::move(icon_))
  , color_id_(color_id_)
  , is_shareable_(is_shareable_)
  , pinned_chat_ids_(std::move(pinned_chat_ids_))
  , included_chat_ids_(std::move(included_chat_ids_))
  , excluded_chat_ids_(std::move(excluded_chat_ids_))
  , exclude_muted_(exclude_muted_)
  , exclude_read_(exclude_read_)
  , exclude_archived_(exclude_archived_)
  , include_contacts_(include_contacts_)
  , include_non_contacts_(include_non_contacts_)
  , include_bots_(include_bots_)
  , include_groups_(include_groups_)
  , include_channels_(include_channels_)
{}

const std::int32_t chatFolder::ID;

void chatFolder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatFolder");
    s.store_object_field("name", static_cast<const BaseObject *>(name_.get()));
    s.store_object_field("icon", static_cast<const BaseObject *>(icon_.get()));
    s.store_field("color_id", color_id_);
    s.store_field("is_shareable", is_shareable_);
    { s.store_vector_begin("pinned_chat_ids", pinned_chat_ids_.size()); for (const auto &_value : pinned_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("included_chat_ids", included_chat_ids_.size()); for (const auto &_value : included_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("excluded_chat_ids", excluded_chat_ids_.size()); for (const auto &_value : excluded_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("exclude_muted", exclude_muted_);
    s.store_field("exclude_read", exclude_read_);
    s.store_field("exclude_archived", exclude_archived_);
    s.store_field("include_contacts", include_contacts_);
    s.store_field("include_non_contacts", include_non_contacts_);
    s.store_field("include_bots", include_bots_);
    s.store_field("include_groups", include_groups_);
    s.store_field("include_channels", include_channels_);
    s.store_class_end();
  }
}

chatFolderIcon::chatFolderIcon()
  : name_()
{}

chatFolderIcon::chatFolderIcon(string const &name_)
  : name_(name_)
{}

const std::int32_t chatFolderIcon::ID;

void chatFolderIcon::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatFolderIcon");
    s.store_field("name", name_);
    s.store_class_end();
  }
}

chatFolderInfo::chatFolderInfo()
  : id_()
  , name_()
  , icon_()
  , color_id_()
  , is_shareable_()
  , has_my_invite_links_()
{}

chatFolderInfo::chatFolderInfo(int32 id_, object_ptr<chatFolderName> &&name_, object_ptr<chatFolderIcon> &&icon_, int32 color_id_, bool is_shareable_, bool has_my_invite_links_)
  : id_(id_)
  , name_(std::move(name_))
  , icon_(std::move(icon_))
  , color_id_(color_id_)
  , is_shareable_(is_shareable_)
  , has_my_invite_links_(has_my_invite_links_)
{}

const std::int32_t chatFolderInfo::ID;

void chatFolderInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatFolderInfo");
    s.store_field("id", id_);
    s.store_object_field("name", static_cast<const BaseObject *>(name_.get()));
    s.store_object_field("icon", static_cast<const BaseObject *>(icon_.get()));
    s.store_field("color_id", color_id_);
    s.store_field("is_shareable", is_shareable_);
    s.store_field("has_my_invite_links", has_my_invite_links_);
    s.store_class_end();
  }
}

chatFolderInviteLink::chatFolderInviteLink()
  : invite_link_()
  , name_()
  , chat_ids_()
{}

chatFolderInviteLink::chatFolderInviteLink(string const &invite_link_, string const &name_, array<int53> &&chat_ids_)
  : invite_link_(invite_link_)
  , name_(name_)
  , chat_ids_(std::move(chat_ids_))
{}

const std::int32_t chatFolderInviteLink::ID;

void chatFolderInviteLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatFolderInviteLink");
    s.store_field("invite_link", invite_link_);
    s.store_field("name", name_);
    { s.store_vector_begin("chat_ids", chat_ids_.size()); for (const auto &_value : chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatFolderInviteLinkInfo::chatFolderInviteLinkInfo()
  : chat_folder_info_()
  , missing_chat_ids_()
  , added_chat_ids_()
{}

chatFolderInviteLinkInfo::chatFolderInviteLinkInfo(object_ptr<chatFolderInfo> &&chat_folder_info_, array<int53> &&missing_chat_ids_, array<int53> &&added_chat_ids_)
  : chat_folder_info_(std::move(chat_folder_info_))
  , missing_chat_ids_(std::move(missing_chat_ids_))
  , added_chat_ids_(std::move(added_chat_ids_))
{}

const std::int32_t chatFolderInviteLinkInfo::ID;

void chatFolderInviteLinkInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatFolderInviteLinkInfo");
    s.store_object_field("chat_folder_info", static_cast<const BaseObject *>(chat_folder_info_.get()));
    { s.store_vector_begin("missing_chat_ids", missing_chat_ids_.size()); for (const auto &_value : missing_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("added_chat_ids", added_chat_ids_.size()); for (const auto &_value : added_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatFolderInviteLinks::chatFolderInviteLinks()
  : invite_links_()
{}

chatFolderInviteLinks::chatFolderInviteLinks(array<object_ptr<chatFolderInviteLink>> &&invite_links_)
  : invite_links_(std::move(invite_links_))
{}

const std::int32_t chatFolderInviteLinks::ID;

void chatFolderInviteLinks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatFolderInviteLinks");
    { s.store_vector_begin("invite_links", invite_links_.size()); for (const auto &_value : invite_links_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatFolderName::chatFolderName()
  : text_()
  , animate_custom_emoji_()
{}

chatFolderName::chatFolderName(object_ptr<formattedText> &&text_, bool animate_custom_emoji_)
  : text_(std::move(text_))
  , animate_custom_emoji_(animate_custom_emoji_)
{}

const std::int32_t chatFolderName::ID;

void chatFolderName::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatFolderName");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("animate_custom_emoji", animate_custom_emoji_);
    s.store_class_end();
  }
}

chatInviteLink::chatInviteLink()
  : invite_link_()
  , name_()
  , creator_user_id_()
  , date_()
  , edit_date_()
  , expiration_date_()
  , subscription_pricing_()
  , member_limit_()
  , member_count_()
  , expired_member_count_()
  , pending_join_request_count_()
  , creates_join_request_()
  , is_primary_()
  , is_revoked_()
{}

chatInviteLink::chatInviteLink(string const &invite_link_, string const &name_, int53 creator_user_id_, int32 date_, int32 edit_date_, int32 expiration_date_, object_ptr<starSubscriptionPricing> &&subscription_pricing_, int32 member_limit_, int32 member_count_, int32 expired_member_count_, int32 pending_join_request_count_, bool creates_join_request_, bool is_primary_, bool is_revoked_)
  : invite_link_(invite_link_)
  , name_(name_)
  , creator_user_id_(creator_user_id_)
  , date_(date_)
  , edit_date_(edit_date_)
  , expiration_date_(expiration_date_)
  , subscription_pricing_(std::move(subscription_pricing_))
  , member_limit_(member_limit_)
  , member_count_(member_count_)
  , expired_member_count_(expired_member_count_)
  , pending_join_request_count_(pending_join_request_count_)
  , creates_join_request_(creates_join_request_)
  , is_primary_(is_primary_)
  , is_revoked_(is_revoked_)
{}

const std::int32_t chatInviteLink::ID;

void chatInviteLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteLink");
    s.store_field("invite_link", invite_link_);
    s.store_field("name", name_);
    s.store_field("creator_user_id", creator_user_id_);
    s.store_field("date", date_);
    s.store_field("edit_date", edit_date_);
    s.store_field("expiration_date", expiration_date_);
    s.store_object_field("subscription_pricing", static_cast<const BaseObject *>(subscription_pricing_.get()));
    s.store_field("member_limit", member_limit_);
    s.store_field("member_count", member_count_);
    s.store_field("expired_member_count", expired_member_count_);
    s.store_field("pending_join_request_count", pending_join_request_count_);
    s.store_field("creates_join_request", creates_join_request_);
    s.store_field("is_primary", is_primary_);
    s.store_field("is_revoked", is_revoked_);
    s.store_class_end();
  }
}

chatInviteLinkCount::chatInviteLinkCount()
  : user_id_()
  , invite_link_count_()
  , revoked_invite_link_count_()
{}

chatInviteLinkCount::chatInviteLinkCount(int53 user_id_, int32 invite_link_count_, int32 revoked_invite_link_count_)
  : user_id_(user_id_)
  , invite_link_count_(invite_link_count_)
  , revoked_invite_link_count_(revoked_invite_link_count_)
{}

const std::int32_t chatInviteLinkCount::ID;

void chatInviteLinkCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteLinkCount");
    s.store_field("user_id", user_id_);
    s.store_field("invite_link_count", invite_link_count_);
    s.store_field("revoked_invite_link_count", revoked_invite_link_count_);
    s.store_class_end();
  }
}

chatInviteLinkCounts::chatInviteLinkCounts()
  : invite_link_counts_()
{}

chatInviteLinkCounts::chatInviteLinkCounts(array<object_ptr<chatInviteLinkCount>> &&invite_link_counts_)
  : invite_link_counts_(std::move(invite_link_counts_))
{}

const std::int32_t chatInviteLinkCounts::ID;

void chatInviteLinkCounts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteLinkCounts");
    { s.store_vector_begin("invite_link_counts", invite_link_counts_.size()); for (const auto &_value : invite_link_counts_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatInviteLinkInfo::chatInviteLinkInfo()
  : chat_id_()
  , accessible_for_()
  , type_()
  , title_()
  , photo_()
  , accent_color_id_()
  , description_()
  , member_count_()
  , member_user_ids_()
  , subscription_info_()
  , creates_join_request_()
  , is_public_()
  , verification_status_()
{}

chatInviteLinkInfo::chatInviteLinkInfo(int53 chat_id_, int32 accessible_for_, object_ptr<InviteLinkChatType> &&type_, string const &title_, object_ptr<chatPhotoInfo> &&photo_, int32 accent_color_id_, string const &description_, int32 member_count_, array<int53> &&member_user_ids_, object_ptr<chatInviteLinkSubscriptionInfo> &&subscription_info_, bool creates_join_request_, bool is_public_, object_ptr<verificationStatus> &&verification_status_)
  : chat_id_(chat_id_)
  , accessible_for_(accessible_for_)
  , type_(std::move(type_))
  , title_(title_)
  , photo_(std::move(photo_))
  , accent_color_id_(accent_color_id_)
  , description_(description_)
  , member_count_(member_count_)
  , member_user_ids_(std::move(member_user_ids_))
  , subscription_info_(std::move(subscription_info_))
  , creates_join_request_(creates_join_request_)
  , is_public_(is_public_)
  , verification_status_(std::move(verification_status_))
{}

const std::int32_t chatInviteLinkInfo::ID;

void chatInviteLinkInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteLinkInfo");
    s.store_field("chat_id", chat_id_);
    s.store_field("accessible_for", accessible_for_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("title", title_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("accent_color_id", accent_color_id_);
    s.store_field("description", description_);
    s.store_field("member_count", member_count_);
    { s.store_vector_begin("member_user_ids", member_user_ids_.size()); for (const auto &_value : member_user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_object_field("subscription_info", static_cast<const BaseObject *>(subscription_info_.get()));
    s.store_field("creates_join_request", creates_join_request_);
    s.store_field("is_public", is_public_);
    s.store_object_field("verification_status", static_cast<const BaseObject *>(verification_status_.get()));
    s.store_class_end();
  }
}

chatInviteLinkMember::chatInviteLinkMember()
  : user_id_()
  , joined_chat_date_()
  , via_chat_folder_invite_link_()
  , approver_user_id_()
{}

chatInviteLinkMember::chatInviteLinkMember(int53 user_id_, int32 joined_chat_date_, bool via_chat_folder_invite_link_, int53 approver_user_id_)
  : user_id_(user_id_)
  , joined_chat_date_(joined_chat_date_)
  , via_chat_folder_invite_link_(via_chat_folder_invite_link_)
  , approver_user_id_(approver_user_id_)
{}

const std::int32_t chatInviteLinkMember::ID;

void chatInviteLinkMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteLinkMember");
    s.store_field("user_id", user_id_);
    s.store_field("joined_chat_date", joined_chat_date_);
    s.store_field("via_chat_folder_invite_link", via_chat_folder_invite_link_);
    s.store_field("approver_user_id", approver_user_id_);
    s.store_class_end();
  }
}

chatInviteLinkMembers::chatInviteLinkMembers()
  : total_count_()
  , members_()
{}

chatInviteLinkMembers::chatInviteLinkMembers(int32 total_count_, array<object_ptr<chatInviteLinkMember>> &&members_)
  : total_count_(total_count_)
  , members_(std::move(members_))
{}

const std::int32_t chatInviteLinkMembers::ID;

void chatInviteLinkMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteLinkMembers");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("members", members_.size()); for (const auto &_value : members_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatInviteLinkSubscriptionInfo::chatInviteLinkSubscriptionInfo()
  : pricing_()
  , can_reuse_()
  , form_id_()
{}

chatInviteLinkSubscriptionInfo::chatInviteLinkSubscriptionInfo(object_ptr<starSubscriptionPricing> &&pricing_, bool can_reuse_, int64 form_id_)
  : pricing_(std::move(pricing_))
  , can_reuse_(can_reuse_)
  , form_id_(form_id_)
{}

const std::int32_t chatInviteLinkSubscriptionInfo::ID;

void chatInviteLinkSubscriptionInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteLinkSubscriptionInfo");
    s.store_object_field("pricing", static_cast<const BaseObject *>(pricing_.get()));
    s.store_field("can_reuse", can_reuse_);
    s.store_field("form_id", form_id_);
    s.store_class_end();
  }
}

chatInviteLinks::chatInviteLinks()
  : total_count_()
  , invite_links_()
{}

chatInviteLinks::chatInviteLinks(int32 total_count_, array<object_ptr<chatInviteLink>> &&invite_links_)
  : total_count_(total_count_)
  , invite_links_(std::move(invite_links_))
{}

const std::int32_t chatInviteLinks::ID;

void chatInviteLinks::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatInviteLinks");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("invite_links", invite_links_.size()); for (const auto &_value : invite_links_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatJoinRequest::chatJoinRequest()
  : user_id_()
  , date_()
  , bio_()
{}

chatJoinRequest::chatJoinRequest(int53 user_id_, int32 date_, string const &bio_)
  : user_id_(user_id_)
  , date_(date_)
  , bio_(bio_)
{}

const std::int32_t chatJoinRequest::ID;

void chatJoinRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatJoinRequest");
    s.store_field("user_id", user_id_);
    s.store_field("date", date_);
    s.store_field("bio", bio_);
    s.store_class_end();
  }
}

chatJoinRequests::chatJoinRequests()
  : total_count_()
  , requests_()
{}

chatJoinRequests::chatJoinRequests(int32 total_count_, array<object_ptr<chatJoinRequest>> &&requests_)
  : total_count_(total_count_)
  , requests_(std::move(requests_))
{}

const std::int32_t chatJoinRequests::ID;

void chatJoinRequests::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatJoinRequests");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("requests", requests_.size()); for (const auto &_value : requests_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatJoinRequestsInfo::chatJoinRequestsInfo()
  : total_count_()
  , user_ids_()
{}

chatJoinRequestsInfo::chatJoinRequestsInfo(int32 total_count_, array<int53> &&user_ids_)
  : total_count_(total_count_)
  , user_ids_(std::move(user_ids_))
{}

const std::int32_t chatJoinRequestsInfo::ID;

void chatJoinRequestsInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatJoinRequestsInfo");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("user_ids", user_ids_.size()); for (const auto &_value : user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatListMain::chatListMain() {
}

const std::int32_t chatListMain::ID;

void chatListMain::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatListMain");
    s.store_class_end();
  }
}

chatListArchive::chatListArchive() {
}

const std::int32_t chatListArchive::ID;

void chatListArchive::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatListArchive");
    s.store_class_end();
  }
}

chatListFolder::chatListFolder()
  : chat_folder_id_()
{}

chatListFolder::chatListFolder(int32 chat_folder_id_)
  : chat_folder_id_(chat_folder_id_)
{}

const std::int32_t chatListFolder::ID;

void chatListFolder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatListFolder");
    s.store_field("chat_folder_id", chat_folder_id_);
    s.store_class_end();
  }
}

chatLists::chatLists()
  : chat_lists_()
{}

chatLists::chatLists(array<object_ptr<ChatList>> &&chat_lists_)
  : chat_lists_(std::move(chat_lists_))
{}

const std::int32_t chatLists::ID;

void chatLists::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatLists");
    { s.store_vector_begin("chat_lists", chat_lists_.size()); for (const auto &_value : chat_lists_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatLocation::chatLocation()
  : location_()
  , address_()
{}

chatLocation::chatLocation(object_ptr<location> &&location_, string const &address_)
  : location_(std::move(location_))
  , address_(address_)
{}

const std::int32_t chatLocation::ID;

void chatLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatLocation");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_field("address", address_);
    s.store_class_end();
  }
}

chatMember::chatMember()
  : member_id_()
  , inviter_user_id_()
  , joined_chat_date_()
  , status_()
{}

chatMember::chatMember(object_ptr<MessageSender> &&member_id_, int53 inviter_user_id_, int32 joined_chat_date_, object_ptr<ChatMemberStatus> &&status_)
  : member_id_(std::move(member_id_))
  , inviter_user_id_(inviter_user_id_)
  , joined_chat_date_(joined_chat_date_)
  , status_(std::move(status_))
{}

const std::int32_t chatMember::ID;

void chatMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMember");
    s.store_object_field("member_id", static_cast<const BaseObject *>(member_id_.get()));
    s.store_field("inviter_user_id", inviter_user_id_);
    s.store_field("joined_chat_date", joined_chat_date_);
    s.store_object_field("status", static_cast<const BaseObject *>(status_.get()));
    s.store_class_end();
  }
}

chatMemberStatusCreator::chatMemberStatusCreator()
  : custom_title_()
  , is_anonymous_()
  , is_member_()
{}

chatMemberStatusCreator::chatMemberStatusCreator(string const &custom_title_, bool is_anonymous_, bool is_member_)
  : custom_title_(custom_title_)
  , is_anonymous_(is_anonymous_)
  , is_member_(is_member_)
{}

const std::int32_t chatMemberStatusCreator::ID;

void chatMemberStatusCreator::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMemberStatusCreator");
    s.store_field("custom_title", custom_title_);
    s.store_field("is_anonymous", is_anonymous_);
    s.store_field("is_member", is_member_);
    s.store_class_end();
  }
}

chatMemberStatusAdministrator::chatMemberStatusAdministrator()
  : custom_title_()
  , can_be_edited_()
  , rights_()
{}

chatMemberStatusAdministrator::chatMemberStatusAdministrator(string const &custom_title_, bool can_be_edited_, object_ptr<chatAdministratorRights> &&rights_)
  : custom_title_(custom_title_)
  , can_be_edited_(can_be_edited_)
  , rights_(std::move(rights_))
{}

const std::int32_t chatMemberStatusAdministrator::ID;

void chatMemberStatusAdministrator::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMemberStatusAdministrator");
    s.store_field("custom_title", custom_title_);
    s.store_field("can_be_edited", can_be_edited_);
    s.store_object_field("rights", static_cast<const BaseObject *>(rights_.get()));
    s.store_class_end();
  }
}

chatMemberStatusMember::chatMemberStatusMember()
  : member_until_date_()
{}

chatMemberStatusMember::chatMemberStatusMember(int32 member_until_date_)
  : member_until_date_(member_until_date_)
{}

const std::int32_t chatMemberStatusMember::ID;

void chatMemberStatusMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMemberStatusMember");
    s.store_field("member_until_date", member_until_date_);
    s.store_class_end();
  }
}

chatMemberStatusRestricted::chatMemberStatusRestricted()
  : is_member_()
  , restricted_until_date_()
  , permissions_()
{}

chatMemberStatusRestricted::chatMemberStatusRestricted(bool is_member_, int32 restricted_until_date_, object_ptr<chatPermissions> &&permissions_)
  : is_member_(is_member_)
  , restricted_until_date_(restricted_until_date_)
  , permissions_(std::move(permissions_))
{}

const std::int32_t chatMemberStatusRestricted::ID;

void chatMemberStatusRestricted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMemberStatusRestricted");
    s.store_field("is_member", is_member_);
    s.store_field("restricted_until_date", restricted_until_date_);
    s.store_object_field("permissions", static_cast<const BaseObject *>(permissions_.get()));
    s.store_class_end();
  }
}

chatMemberStatusLeft::chatMemberStatusLeft() {
}

const std::int32_t chatMemberStatusLeft::ID;

void chatMemberStatusLeft::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMemberStatusLeft");
    s.store_class_end();
  }
}

chatMemberStatusBanned::chatMemberStatusBanned()
  : banned_until_date_()
{}

chatMemberStatusBanned::chatMemberStatusBanned(int32 banned_until_date_)
  : banned_until_date_(banned_until_date_)
{}

const std::int32_t chatMemberStatusBanned::ID;

void chatMemberStatusBanned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMemberStatusBanned");
    s.store_field("banned_until_date", banned_until_date_);
    s.store_class_end();
  }
}

chatMembers::chatMembers()
  : total_count_()
  , members_()
{}

chatMembers::chatMembers(int32 total_count_, array<object_ptr<chatMember>> &&members_)
  : total_count_(total_count_)
  , members_(std::move(members_))
{}

const std::int32_t chatMembers::ID;

void chatMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMembers");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("members", members_.size()); for (const auto &_value : members_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatMembersFilterContacts::chatMembersFilterContacts() {
}

const std::int32_t chatMembersFilterContacts::ID;

void chatMembersFilterContacts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMembersFilterContacts");
    s.store_class_end();
  }
}

chatMembersFilterAdministrators::chatMembersFilterAdministrators() {
}

const std::int32_t chatMembersFilterAdministrators::ID;

void chatMembersFilterAdministrators::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMembersFilterAdministrators");
    s.store_class_end();
  }
}

chatMembersFilterMembers::chatMembersFilterMembers() {
}

const std::int32_t chatMembersFilterMembers::ID;

void chatMembersFilterMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMembersFilterMembers");
    s.store_class_end();
  }
}

chatMembersFilterMention::chatMembersFilterMention()
  : message_thread_id_()
{}

chatMembersFilterMention::chatMembersFilterMention(int53 message_thread_id_)
  : message_thread_id_(message_thread_id_)
{}

const std::int32_t chatMembersFilterMention::ID;

void chatMembersFilterMention::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMembersFilterMention");
    s.store_field("message_thread_id", message_thread_id_);
    s.store_class_end();
  }
}

chatMembersFilterRestricted::chatMembersFilterRestricted() {
}

const std::int32_t chatMembersFilterRestricted::ID;

void chatMembersFilterRestricted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMembersFilterRestricted");
    s.store_class_end();
  }
}

chatMembersFilterBanned::chatMembersFilterBanned() {
}

const std::int32_t chatMembersFilterBanned::ID;

void chatMembersFilterBanned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMembersFilterBanned");
    s.store_class_end();
  }
}

chatMembersFilterBots::chatMembersFilterBots() {
}

const std::int32_t chatMembersFilterBots::ID;

void chatMembersFilterBots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMembersFilterBots");
    s.store_class_end();
  }
}

chatMessageSender::chatMessageSender()
  : sender_()
  , needs_premium_()
{}

chatMessageSender::chatMessageSender(object_ptr<MessageSender> &&sender_, bool needs_premium_)
  : sender_(std::move(sender_))
  , needs_premium_(needs_premium_)
{}

const std::int32_t chatMessageSender::ID;

void chatMessageSender::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMessageSender");
    s.store_object_field("sender", static_cast<const BaseObject *>(sender_.get()));
    s.store_field("needs_premium", needs_premium_);
    s.store_class_end();
  }
}

chatMessageSenders::chatMessageSenders()
  : senders_()
{}

chatMessageSenders::chatMessageSenders(array<object_ptr<chatMessageSender>> &&senders_)
  : senders_(std::move(senders_))
{}

const std::int32_t chatMessageSenders::ID;

void chatMessageSenders::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatMessageSenders");
    { s.store_vector_begin("senders", senders_.size()); for (const auto &_value : senders_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatNotificationSettings::chatNotificationSettings()
  : use_default_mute_for_()
  , mute_for_()
  , use_default_sound_()
  , sound_id_()
  , use_default_show_preview_()
  , show_preview_()
  , use_default_mute_stories_()
  , mute_stories_()
  , use_default_story_sound_()
  , story_sound_id_()
  , use_default_show_story_sender_()
  , show_story_sender_()
  , use_default_disable_pinned_message_notifications_()
  , disable_pinned_message_notifications_()
  , use_default_disable_mention_notifications_()
  , disable_mention_notifications_()
{}

chatNotificationSettings::chatNotificationSettings(bool use_default_mute_for_, int32 mute_for_, bool use_default_sound_, int64 sound_id_, bool use_default_show_preview_, bool show_preview_, bool use_default_mute_stories_, bool mute_stories_, bool use_default_story_sound_, int64 story_sound_id_, bool use_default_show_story_sender_, bool show_story_sender_, bool use_default_disable_pinned_message_notifications_, bool disable_pinned_message_notifications_, bool use_default_disable_mention_notifications_, bool disable_mention_notifications_)
  : use_default_mute_for_(use_default_mute_for_)
  , mute_for_(mute_for_)
  , use_default_sound_(use_default_sound_)
  , sound_id_(sound_id_)
  , use_default_show_preview_(use_default_show_preview_)
  , show_preview_(show_preview_)
  , use_default_mute_stories_(use_default_mute_stories_)
  , mute_stories_(mute_stories_)
  , use_default_story_sound_(use_default_story_sound_)
  , story_sound_id_(story_sound_id_)
  , use_default_show_story_sender_(use_default_show_story_sender_)
  , show_story_sender_(show_story_sender_)
  , use_default_disable_pinned_message_notifications_(use_default_disable_pinned_message_notifications_)
  , disable_pinned_message_notifications_(disable_pinned_message_notifications_)
  , use_default_disable_mention_notifications_(use_default_disable_mention_notifications_)
  , disable_mention_notifications_(disable_mention_notifications_)
{}

const std::int32_t chatNotificationSettings::ID;

void chatNotificationSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatNotificationSettings");
    s.store_field("use_default_mute_for", use_default_mute_for_);
    s.store_field("mute_for", mute_for_);
    s.store_field("use_default_sound", use_default_sound_);
    s.store_field("sound_id", sound_id_);
    s.store_field("use_default_show_preview", use_default_show_preview_);
    s.store_field("show_preview", show_preview_);
    s.store_field("use_default_mute_stories", use_default_mute_stories_);
    s.store_field("mute_stories", mute_stories_);
    s.store_field("use_default_story_sound", use_default_story_sound_);
    s.store_field("story_sound_id", story_sound_id_);
    s.store_field("use_default_show_story_sender", use_default_show_story_sender_);
    s.store_field("show_story_sender", show_story_sender_);
    s.store_field("use_default_disable_pinned_message_notifications", use_default_disable_pinned_message_notifications_);
    s.store_field("disable_pinned_message_notifications", disable_pinned_message_notifications_);
    s.store_field("use_default_disable_mention_notifications", use_default_disable_mention_notifications_);
    s.store_field("disable_mention_notifications", disable_mention_notifications_);
    s.store_class_end();
  }
}

chatPermissions::chatPermissions()
  : can_send_basic_messages_()
  , can_send_audios_()
  , can_send_documents_()
  , can_send_photos_()
  , can_send_videos_()
  , can_send_video_notes_()
  , can_send_voice_notes_()
  , can_send_polls_()
  , can_send_other_messages_()
  , can_add_link_previews_()
  , can_change_info_()
  , can_invite_users_()
  , can_pin_messages_()
  , can_create_topics_()
{}

chatPermissions::chatPermissions(bool can_send_basic_messages_, bool can_send_audios_, bool can_send_documents_, bool can_send_photos_, bool can_send_videos_, bool can_send_video_notes_, bool can_send_voice_notes_, bool can_send_polls_, bool can_send_other_messages_, bool can_add_link_previews_, bool can_change_info_, bool can_invite_users_, bool can_pin_messages_, bool can_create_topics_)
  : can_send_basic_messages_(can_send_basic_messages_)
  , can_send_audios_(can_send_audios_)
  , can_send_documents_(can_send_documents_)
  , can_send_photos_(can_send_photos_)
  , can_send_videos_(can_send_videos_)
  , can_send_video_notes_(can_send_video_notes_)
  , can_send_voice_notes_(can_send_voice_notes_)
  , can_send_polls_(can_send_polls_)
  , can_send_other_messages_(can_send_other_messages_)
  , can_add_link_previews_(can_add_link_previews_)
  , can_change_info_(can_change_info_)
  , can_invite_users_(can_invite_users_)
  , can_pin_messages_(can_pin_messages_)
  , can_create_topics_(can_create_topics_)
{}

const std::int32_t chatPermissions::ID;

void chatPermissions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatPermissions");
    s.store_field("can_send_basic_messages", can_send_basic_messages_);
    s.store_field("can_send_audios", can_send_audios_);
    s.store_field("can_send_documents", can_send_documents_);
    s.store_field("can_send_photos", can_send_photos_);
    s.store_field("can_send_videos", can_send_videos_);
    s.store_field("can_send_video_notes", can_send_video_notes_);
    s.store_field("can_send_voice_notes", can_send_voice_notes_);
    s.store_field("can_send_polls", can_send_polls_);
    s.store_field("can_send_other_messages", can_send_other_messages_);
    s.store_field("can_add_link_previews", can_add_link_previews_);
    s.store_field("can_change_info", can_change_info_);
    s.store_field("can_invite_users", can_invite_users_);
    s.store_field("can_pin_messages", can_pin_messages_);
    s.store_field("can_create_topics", can_create_topics_);
    s.store_class_end();
  }
}

chatPhoto::chatPhoto()
  : id_()
  , added_date_()
  , minithumbnail_()
  , sizes_()
  , animation_()
  , small_animation_()
  , sticker_()
{}

chatPhoto::chatPhoto(int64 id_, int32 added_date_, object_ptr<minithumbnail> &&minithumbnail_, array<object_ptr<photoSize>> &&sizes_, object_ptr<animatedChatPhoto> &&animation_, object_ptr<animatedChatPhoto> &&small_animation_, object_ptr<chatPhotoSticker> &&sticker_)
  : id_(id_)
  , added_date_(added_date_)
  , minithumbnail_(std::move(minithumbnail_))
  , sizes_(std::move(sizes_))
  , animation_(std::move(animation_))
  , small_animation_(std::move(small_animation_))
  , sticker_(std::move(sticker_))
{}

const std::int32_t chatPhoto::ID;

void chatPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatPhoto");
    s.store_field("id", id_);
    s.store_field("added_date", added_date_);
    s.store_object_field("minithumbnail", static_cast<const BaseObject *>(minithumbnail_.get()));
    { s.store_vector_begin("sizes", sizes_.size()); for (const auto &_value : sizes_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_object_field("small_animation", static_cast<const BaseObject *>(small_animation_.get()));
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

chatPhotoInfo::chatPhotoInfo()
  : small_()
  , big_()
  , minithumbnail_()
  , has_animation_()
  , is_personal_()
{}

chatPhotoInfo::chatPhotoInfo(object_ptr<file> &&small_, object_ptr<file> &&big_, object_ptr<minithumbnail> &&minithumbnail_, bool has_animation_, bool is_personal_)
  : small_(std::move(small_))
  , big_(std::move(big_))
  , minithumbnail_(std::move(minithumbnail_))
  , has_animation_(has_animation_)
  , is_personal_(is_personal_)
{}

const std::int32_t chatPhotoInfo::ID;

void chatPhotoInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatPhotoInfo");
    s.store_object_field("small", static_cast<const BaseObject *>(small_.get()));
    s.store_object_field("big", static_cast<const BaseObject *>(big_.get()));
    s.store_object_field("minithumbnail", static_cast<const BaseObject *>(minithumbnail_.get()));
    s.store_field("has_animation", has_animation_);
    s.store_field("is_personal", is_personal_);
    s.store_class_end();
  }
}

chatPhotoSticker::chatPhotoSticker()
  : type_()
  , background_fill_()
{}

chatPhotoSticker::chatPhotoSticker(object_ptr<ChatPhotoStickerType> &&type_, object_ptr<BackgroundFill> &&background_fill_)
  : type_(std::move(type_))
  , background_fill_(std::move(background_fill_))
{}

const std::int32_t chatPhotoSticker::ID;

void chatPhotoSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatPhotoSticker");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_object_field("background_fill", static_cast<const BaseObject *>(background_fill_.get()));
    s.store_class_end();
  }
}

chatPhotoStickerTypeRegularOrMask::chatPhotoStickerTypeRegularOrMask()
  : sticker_set_id_()
  , sticker_id_()
{}

chatPhotoStickerTypeRegularOrMask::chatPhotoStickerTypeRegularOrMask(int64 sticker_set_id_, int64 sticker_id_)
  : sticker_set_id_(sticker_set_id_)
  , sticker_id_(sticker_id_)
{}

const std::int32_t chatPhotoStickerTypeRegularOrMask::ID;

void chatPhotoStickerTypeRegularOrMask::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatPhotoStickerTypeRegularOrMask");
    s.store_field("sticker_set_id", sticker_set_id_);
    s.store_field("sticker_id", sticker_id_);
    s.store_class_end();
  }
}

chatPhotoStickerTypeCustomEmoji::chatPhotoStickerTypeCustomEmoji()
  : custom_emoji_id_()
{}

chatPhotoStickerTypeCustomEmoji::chatPhotoStickerTypeCustomEmoji(int64 custom_emoji_id_)
  : custom_emoji_id_(custom_emoji_id_)
{}

const std::int32_t chatPhotoStickerTypeCustomEmoji::ID;

void chatPhotoStickerTypeCustomEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatPhotoStickerTypeCustomEmoji");
    s.store_field("custom_emoji_id", custom_emoji_id_);
    s.store_class_end();
  }
}

chatPhotos::chatPhotos()
  : total_count_()
  , photos_()
{}

chatPhotos::chatPhotos(int32 total_count_, array<object_ptr<chatPhoto>> &&photos_)
  : total_count_(total_count_)
  , photos_(std::move(photos_))
{}

const std::int32_t chatPhotos::ID;

void chatPhotos::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatPhotos");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("photos", photos_.size()); for (const auto &_value : photos_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatPosition::chatPosition()
  : list_()
  , order_()
  , is_pinned_()
  , source_()
{}

chatPosition::chatPosition(object_ptr<ChatList> &&list_, int64 order_, bool is_pinned_, object_ptr<ChatSource> &&source_)
  : list_(std::move(list_))
  , order_(order_)
  , is_pinned_(is_pinned_)
  , source_(std::move(source_))
{}

const std::int32_t chatPosition::ID;

void chatPosition::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatPosition");
    s.store_object_field("list", static_cast<const BaseObject *>(list_.get()));
    s.store_field("order", order_);
    s.store_field("is_pinned", is_pinned_);
    s.store_object_field("source", static_cast<const BaseObject *>(source_.get()));
    s.store_class_end();
  }
}

chatRevenueAmount::chatRevenueAmount()
  : cryptocurrency_()
  , total_amount_()
  , balance_amount_()
  , available_amount_()
  , withdrawal_enabled_()
{}

chatRevenueAmount::chatRevenueAmount(string const &cryptocurrency_, int64 total_amount_, int64 balance_amount_, int64 available_amount_, bool withdrawal_enabled_)
  : cryptocurrency_(cryptocurrency_)
  , total_amount_(total_amount_)
  , balance_amount_(balance_amount_)
  , available_amount_(available_amount_)
  , withdrawal_enabled_(withdrawal_enabled_)
{}

const std::int32_t chatRevenueAmount::ID;

void chatRevenueAmount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatRevenueAmount");
    s.store_field("cryptocurrency", cryptocurrency_);
    s.store_field("total_amount", total_amount_);
    s.store_field("balance_amount", balance_amount_);
    s.store_field("available_amount", available_amount_);
    s.store_field("withdrawal_enabled", withdrawal_enabled_);
    s.store_class_end();
  }
}

chatRevenueStatistics::chatRevenueStatistics()
  : revenue_by_hour_graph_()
  , revenue_graph_()
  , revenue_amount_()
  , usd_rate_()
{}

chatRevenueStatistics::chatRevenueStatistics(object_ptr<StatisticalGraph> &&revenue_by_hour_graph_, object_ptr<StatisticalGraph> &&revenue_graph_, object_ptr<chatRevenueAmount> &&revenue_amount_, double usd_rate_)
  : revenue_by_hour_graph_(std::move(revenue_by_hour_graph_))
  , revenue_graph_(std::move(revenue_graph_))
  , revenue_amount_(std::move(revenue_amount_))
  , usd_rate_(usd_rate_)
{}

const std::int32_t chatRevenueStatistics::ID;

void chatRevenueStatistics::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatRevenueStatistics");
    s.store_object_field("revenue_by_hour_graph", static_cast<const BaseObject *>(revenue_by_hour_graph_.get()));
    s.store_object_field("revenue_graph", static_cast<const BaseObject *>(revenue_graph_.get()));
    s.store_object_field("revenue_amount", static_cast<const BaseObject *>(revenue_amount_.get()));
    s.store_field("usd_rate", usd_rate_);
    s.store_class_end();
  }
}

chatRevenueTransaction::chatRevenueTransaction()
  : cryptocurrency_()
  , cryptocurrency_amount_()
  , type_()
{}

chatRevenueTransaction::chatRevenueTransaction(string const &cryptocurrency_, int64 cryptocurrency_amount_, object_ptr<ChatRevenueTransactionType> &&type_)
  : cryptocurrency_(cryptocurrency_)
  , cryptocurrency_amount_(cryptocurrency_amount_)
  , type_(std::move(type_))
{}

const std::int32_t chatRevenueTransaction::ID;

void chatRevenueTransaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatRevenueTransaction");
    s.store_field("cryptocurrency", cryptocurrency_);
    s.store_field("cryptocurrency_amount", cryptocurrency_amount_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

chatRevenueTransactionTypeEarnings::chatRevenueTransactionTypeEarnings()
  : start_date_()
  , end_date_()
{}

chatRevenueTransactionTypeEarnings::chatRevenueTransactionTypeEarnings(int32 start_date_, int32 end_date_)
  : start_date_(start_date_)
  , end_date_(end_date_)
{}

const std::int32_t chatRevenueTransactionTypeEarnings::ID;

void chatRevenueTransactionTypeEarnings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatRevenueTransactionTypeEarnings");
    s.store_field("start_date", start_date_);
    s.store_field("end_date", end_date_);
    s.store_class_end();
  }
}

chatRevenueTransactionTypeWithdrawal::chatRevenueTransactionTypeWithdrawal()
  : withdrawal_date_()
  , provider_()
  , state_()
{}

chatRevenueTransactionTypeWithdrawal::chatRevenueTransactionTypeWithdrawal(int32 withdrawal_date_, string const &provider_, object_ptr<RevenueWithdrawalState> &&state_)
  : withdrawal_date_(withdrawal_date_)
  , provider_(provider_)
  , state_(std::move(state_))
{}

const std::int32_t chatRevenueTransactionTypeWithdrawal::ID;

void chatRevenueTransactionTypeWithdrawal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatRevenueTransactionTypeWithdrawal");
    s.store_field("withdrawal_date", withdrawal_date_);
    s.store_field("provider", provider_);
    s.store_object_field("state", static_cast<const BaseObject *>(state_.get()));
    s.store_class_end();
  }
}

chatRevenueTransactionTypeRefund::chatRevenueTransactionTypeRefund()
  : refund_date_()
  , provider_()
{}

chatRevenueTransactionTypeRefund::chatRevenueTransactionTypeRefund(int32 refund_date_, string const &provider_)
  : refund_date_(refund_date_)
  , provider_(provider_)
{}

const std::int32_t chatRevenueTransactionTypeRefund::ID;

void chatRevenueTransactionTypeRefund::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatRevenueTransactionTypeRefund");
    s.store_field("refund_date", refund_date_);
    s.store_field("provider", provider_);
    s.store_class_end();
  }
}

chatRevenueTransactions::chatRevenueTransactions()
  : total_count_()
  , transactions_()
{}

chatRevenueTransactions::chatRevenueTransactions(int32 total_count_, array<object_ptr<chatRevenueTransaction>> &&transactions_)
  : total_count_(total_count_)
  , transactions_(std::move(transactions_))
{}

const std::int32_t chatRevenueTransactions::ID;

void chatRevenueTransactions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatRevenueTransactions");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("transactions", transactions_.size()); for (const auto &_value : transactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatSourceMtprotoProxy::chatSourceMtprotoProxy() {
}

const std::int32_t chatSourceMtprotoProxy::ID;

void chatSourceMtprotoProxy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatSourceMtprotoProxy");
    s.store_class_end();
  }
}

chatSourcePublicServiceAnnouncement::chatSourcePublicServiceAnnouncement()
  : type_()
  , text_()
{}

chatSourcePublicServiceAnnouncement::chatSourcePublicServiceAnnouncement(string const &type_, string const &text_)
  : type_(type_)
  , text_(text_)
{}

const std::int32_t chatSourcePublicServiceAnnouncement::ID;

void chatSourcePublicServiceAnnouncement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatSourcePublicServiceAnnouncement");
    s.store_field("type", type_);
    s.store_field("text", text_);
    s.store_class_end();
  }
}

chatStatisticsSupergroup::chatStatisticsSupergroup()
  : period_()
  , member_count_()
  , message_count_()
  , viewer_count_()
  , sender_count_()
  , member_count_graph_()
  , join_graph_()
  , join_by_source_graph_()
  , language_graph_()
  , message_content_graph_()
  , action_graph_()
  , day_graph_()
  , week_graph_()
  , top_senders_()
  , top_administrators_()
  , top_inviters_()
{}

chatStatisticsSupergroup::chatStatisticsSupergroup(object_ptr<dateRange> &&period_, object_ptr<statisticalValue> &&member_count_, object_ptr<statisticalValue> &&message_count_, object_ptr<statisticalValue> &&viewer_count_, object_ptr<statisticalValue> &&sender_count_, object_ptr<StatisticalGraph> &&member_count_graph_, object_ptr<StatisticalGraph> &&join_graph_, object_ptr<StatisticalGraph> &&join_by_source_graph_, object_ptr<StatisticalGraph> &&language_graph_, object_ptr<StatisticalGraph> &&message_content_graph_, object_ptr<StatisticalGraph> &&action_graph_, object_ptr<StatisticalGraph> &&day_graph_, object_ptr<StatisticalGraph> &&week_graph_, array<object_ptr<chatStatisticsMessageSenderInfo>> &&top_senders_, array<object_ptr<chatStatisticsAdministratorActionsInfo>> &&top_administrators_, array<object_ptr<chatStatisticsInviterInfo>> &&top_inviters_)
  : period_(std::move(period_))
  , member_count_(std::move(member_count_))
  , message_count_(std::move(message_count_))
  , viewer_count_(std::move(viewer_count_))
  , sender_count_(std::move(sender_count_))
  , member_count_graph_(std::move(member_count_graph_))
  , join_graph_(std::move(join_graph_))
  , join_by_source_graph_(std::move(join_by_source_graph_))
  , language_graph_(std::move(language_graph_))
  , message_content_graph_(std::move(message_content_graph_))
  , action_graph_(std::move(action_graph_))
  , day_graph_(std::move(day_graph_))
  , week_graph_(std::move(week_graph_))
  , top_senders_(std::move(top_senders_))
  , top_administrators_(std::move(top_administrators_))
  , top_inviters_(std::move(top_inviters_))
{}

const std::int32_t chatStatisticsSupergroup::ID;

void chatStatisticsSupergroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatStatisticsSupergroup");
    s.store_object_field("period", static_cast<const BaseObject *>(period_.get()));
    s.store_object_field("member_count", static_cast<const BaseObject *>(member_count_.get()));
    s.store_object_field("message_count", static_cast<const BaseObject *>(message_count_.get()));
    s.store_object_field("viewer_count", static_cast<const BaseObject *>(viewer_count_.get()));
    s.store_object_field("sender_count", static_cast<const BaseObject *>(sender_count_.get()));
    s.store_object_field("member_count_graph", static_cast<const BaseObject *>(member_count_graph_.get()));
    s.store_object_field("join_graph", static_cast<const BaseObject *>(join_graph_.get()));
    s.store_object_field("join_by_source_graph", static_cast<const BaseObject *>(join_by_source_graph_.get()));
    s.store_object_field("language_graph", static_cast<const BaseObject *>(language_graph_.get()));
    s.store_object_field("message_content_graph", static_cast<const BaseObject *>(message_content_graph_.get()));
    s.store_object_field("action_graph", static_cast<const BaseObject *>(action_graph_.get()));
    s.store_object_field("day_graph", static_cast<const BaseObject *>(day_graph_.get()));
    s.store_object_field("week_graph", static_cast<const BaseObject *>(week_graph_.get()));
    { s.store_vector_begin("top_senders", top_senders_.size()); for (const auto &_value : top_senders_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("top_administrators", top_administrators_.size()); for (const auto &_value : top_administrators_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("top_inviters", top_inviters_.size()); for (const auto &_value : top_inviters_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatStatisticsChannel::chatStatisticsChannel()
  : period_()
  , member_count_()
  , mean_message_view_count_()
  , mean_message_share_count_()
  , mean_message_reaction_count_()
  , mean_story_view_count_()
  , mean_story_share_count_()
  , mean_story_reaction_count_()
  , enabled_notifications_percentage_()
  , member_count_graph_()
  , join_graph_()
  , mute_graph_()
  , view_count_by_hour_graph_()
  , view_count_by_source_graph_()
  , join_by_source_graph_()
  , language_graph_()
  , message_interaction_graph_()
  , message_reaction_graph_()
  , story_interaction_graph_()
  , story_reaction_graph_()
  , instant_view_interaction_graph_()
  , recent_interactions_()
{}

chatStatisticsChannel::chatStatisticsChannel(object_ptr<dateRange> &&period_, object_ptr<statisticalValue> &&member_count_, object_ptr<statisticalValue> &&mean_message_view_count_, object_ptr<statisticalValue> &&mean_message_share_count_, object_ptr<statisticalValue> &&mean_message_reaction_count_, object_ptr<statisticalValue> &&mean_story_view_count_, object_ptr<statisticalValue> &&mean_story_share_count_, object_ptr<statisticalValue> &&mean_story_reaction_count_, double enabled_notifications_percentage_, object_ptr<StatisticalGraph> &&member_count_graph_, object_ptr<StatisticalGraph> &&join_graph_, object_ptr<StatisticalGraph> &&mute_graph_, object_ptr<StatisticalGraph> &&view_count_by_hour_graph_, object_ptr<StatisticalGraph> &&view_count_by_source_graph_, object_ptr<StatisticalGraph> &&join_by_source_graph_, object_ptr<StatisticalGraph> &&language_graph_, object_ptr<StatisticalGraph> &&message_interaction_graph_, object_ptr<StatisticalGraph> &&message_reaction_graph_, object_ptr<StatisticalGraph> &&story_interaction_graph_, object_ptr<StatisticalGraph> &&story_reaction_graph_, object_ptr<StatisticalGraph> &&instant_view_interaction_graph_, array<object_ptr<chatStatisticsInteractionInfo>> &&recent_interactions_)
  : period_(std::move(period_))
  , member_count_(std::move(member_count_))
  , mean_message_view_count_(std::move(mean_message_view_count_))
  , mean_message_share_count_(std::move(mean_message_share_count_))
  , mean_message_reaction_count_(std::move(mean_message_reaction_count_))
  , mean_story_view_count_(std::move(mean_story_view_count_))
  , mean_story_share_count_(std::move(mean_story_share_count_))
  , mean_story_reaction_count_(std::move(mean_story_reaction_count_))
  , enabled_notifications_percentage_(enabled_notifications_percentage_)
  , member_count_graph_(std::move(member_count_graph_))
  , join_graph_(std::move(join_graph_))
  , mute_graph_(std::move(mute_graph_))
  , view_count_by_hour_graph_(std::move(view_count_by_hour_graph_))
  , view_count_by_source_graph_(std::move(view_count_by_source_graph_))
  , join_by_source_graph_(std::move(join_by_source_graph_))
  , language_graph_(std::move(language_graph_))
  , message_interaction_graph_(std::move(message_interaction_graph_))
  , message_reaction_graph_(std::move(message_reaction_graph_))
  , story_interaction_graph_(std::move(story_interaction_graph_))
  , story_reaction_graph_(std::move(story_reaction_graph_))
  , instant_view_interaction_graph_(std::move(instant_view_interaction_graph_))
  , recent_interactions_(std::move(recent_interactions_))
{}

const std::int32_t chatStatisticsChannel::ID;

void chatStatisticsChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatStatisticsChannel");
    s.store_object_field("period", static_cast<const BaseObject *>(period_.get()));
    s.store_object_field("member_count", static_cast<const BaseObject *>(member_count_.get()));
    s.store_object_field("mean_message_view_count", static_cast<const BaseObject *>(mean_message_view_count_.get()));
    s.store_object_field("mean_message_share_count", static_cast<const BaseObject *>(mean_message_share_count_.get()));
    s.store_object_field("mean_message_reaction_count", static_cast<const BaseObject *>(mean_message_reaction_count_.get()));
    s.store_object_field("mean_story_view_count", static_cast<const BaseObject *>(mean_story_view_count_.get()));
    s.store_object_field("mean_story_share_count", static_cast<const BaseObject *>(mean_story_share_count_.get()));
    s.store_object_field("mean_story_reaction_count", static_cast<const BaseObject *>(mean_story_reaction_count_.get()));
    s.store_field("enabled_notifications_percentage", enabled_notifications_percentage_);
    s.store_object_field("member_count_graph", static_cast<const BaseObject *>(member_count_graph_.get()));
    s.store_object_field("join_graph", static_cast<const BaseObject *>(join_graph_.get()));
    s.store_object_field("mute_graph", static_cast<const BaseObject *>(mute_graph_.get()));
    s.store_object_field("view_count_by_hour_graph", static_cast<const BaseObject *>(view_count_by_hour_graph_.get()));
    s.store_object_field("view_count_by_source_graph", static_cast<const BaseObject *>(view_count_by_source_graph_.get()));
    s.store_object_field("join_by_source_graph", static_cast<const BaseObject *>(join_by_source_graph_.get()));
    s.store_object_field("language_graph", static_cast<const BaseObject *>(language_graph_.get()));
    s.store_object_field("message_interaction_graph", static_cast<const BaseObject *>(message_interaction_graph_.get()));
    s.store_object_field("message_reaction_graph", static_cast<const BaseObject *>(message_reaction_graph_.get()));
    s.store_object_field("story_interaction_graph", static_cast<const BaseObject *>(story_interaction_graph_.get()));
    s.store_object_field("story_reaction_graph", static_cast<const BaseObject *>(story_reaction_graph_.get()));
    s.store_object_field("instant_view_interaction_graph", static_cast<const BaseObject *>(instant_view_interaction_graph_.get()));
    { s.store_vector_begin("recent_interactions", recent_interactions_.size()); for (const auto &_value : recent_interactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

chatStatisticsAdministratorActionsInfo::chatStatisticsAdministratorActionsInfo()
  : user_id_()
  , deleted_message_count_()
  , banned_user_count_()
  , restricted_user_count_()
{}

chatStatisticsAdministratorActionsInfo::chatStatisticsAdministratorActionsInfo(int53 user_id_, int32 deleted_message_count_, int32 banned_user_count_, int32 restricted_user_count_)
  : user_id_(user_id_)
  , deleted_message_count_(deleted_message_count_)
  , banned_user_count_(banned_user_count_)
  , restricted_user_count_(restricted_user_count_)
{}

const std::int32_t chatStatisticsAdministratorActionsInfo::ID;

void chatStatisticsAdministratorActionsInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatStatisticsAdministratorActionsInfo");
    s.store_field("user_id", user_id_);
    s.store_field("deleted_message_count", deleted_message_count_);
    s.store_field("banned_user_count", banned_user_count_);
    s.store_field("restricted_user_count", restricted_user_count_);
    s.store_class_end();
  }
}

chatStatisticsInteractionInfo::chatStatisticsInteractionInfo()
  : object_type_()
  , view_count_()
  , forward_count_()
  , reaction_count_()
{}

chatStatisticsInteractionInfo::chatStatisticsInteractionInfo(object_ptr<ChatStatisticsObjectType> &&object_type_, int32 view_count_, int32 forward_count_, int32 reaction_count_)
  : object_type_(std::move(object_type_))
  , view_count_(view_count_)
  , forward_count_(forward_count_)
  , reaction_count_(reaction_count_)
{}

const std::int32_t chatStatisticsInteractionInfo::ID;

void chatStatisticsInteractionInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatStatisticsInteractionInfo");
    s.store_object_field("object_type", static_cast<const BaseObject *>(object_type_.get()));
    s.store_field("view_count", view_count_);
    s.store_field("forward_count", forward_count_);
    s.store_field("reaction_count", reaction_count_);
    s.store_class_end();
  }
}

chatStatisticsInviterInfo::chatStatisticsInviterInfo()
  : user_id_()
  , added_member_count_()
{}

chatStatisticsInviterInfo::chatStatisticsInviterInfo(int53 user_id_, int32 added_member_count_)
  : user_id_(user_id_)
  , added_member_count_(added_member_count_)
{}

const std::int32_t chatStatisticsInviterInfo::ID;

void chatStatisticsInviterInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatStatisticsInviterInfo");
    s.store_field("user_id", user_id_);
    s.store_field("added_member_count", added_member_count_);
    s.store_class_end();
  }
}

chatStatisticsMessageSenderInfo::chatStatisticsMessageSenderInfo()
  : user_id_()
  , sent_message_count_()
  , average_character_count_()
{}

chatStatisticsMessageSenderInfo::chatStatisticsMessageSenderInfo(int53 user_id_, int32 sent_message_count_, int32 average_character_count_)
  : user_id_(user_id_)
  , sent_message_count_(sent_message_count_)
  , average_character_count_(average_character_count_)
{}

const std::int32_t chatStatisticsMessageSenderInfo::ID;

void chatStatisticsMessageSenderInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatStatisticsMessageSenderInfo");
    s.store_field("user_id", user_id_);
    s.store_field("sent_message_count", sent_message_count_);
    s.store_field("average_character_count", average_character_count_);
    s.store_class_end();
  }
}

chatStatisticsObjectTypeMessage::chatStatisticsObjectTypeMessage()
  : message_id_()
{}

chatStatisticsObjectTypeMessage::chatStatisticsObjectTypeMessage(int53 message_id_)
  : message_id_(message_id_)
{}

const std::int32_t chatStatisticsObjectTypeMessage::ID;

void chatStatisticsObjectTypeMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatStatisticsObjectTypeMessage");
    s.store_field("message_id", message_id_);
    s.store_class_end();
  }
}

chatStatisticsObjectTypeStory::chatStatisticsObjectTypeStory()
  : story_id_()
{}

chatStatisticsObjectTypeStory::chatStatisticsObjectTypeStory(int32 story_id_)
  : story_id_(story_id_)
{}

const std::int32_t chatStatisticsObjectTypeStory::ID;

void chatStatisticsObjectTypeStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatStatisticsObjectTypeStory");
    s.store_field("story_id", story_id_);
    s.store_class_end();
  }
}

chatTheme::chatTheme()
  : name_()
  , light_settings_()
  , dark_settings_()
{}

chatTheme::chatTheme(string const &name_, object_ptr<themeSettings> &&light_settings_, object_ptr<themeSettings> &&dark_settings_)
  : name_(name_)
  , light_settings_(std::move(light_settings_))
  , dark_settings_(std::move(dark_settings_))
{}

const std::int32_t chatTheme::ID;

void chatTheme::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatTheme");
    s.store_field("name", name_);
    s.store_object_field("light_settings", static_cast<const BaseObject *>(light_settings_.get()));
    s.store_object_field("dark_settings", static_cast<const BaseObject *>(dark_settings_.get()));
    s.store_class_end();
  }
}

chatTypePrivate::chatTypePrivate()
  : user_id_()
{}

chatTypePrivate::chatTypePrivate(int53 user_id_)
  : user_id_(user_id_)
{}

const std::int32_t chatTypePrivate::ID;

void chatTypePrivate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatTypePrivate");
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

chatTypeBasicGroup::chatTypeBasicGroup()
  : basic_group_id_()
{}

chatTypeBasicGroup::chatTypeBasicGroup(int53 basic_group_id_)
  : basic_group_id_(basic_group_id_)
{}

const std::int32_t chatTypeBasicGroup::ID;

void chatTypeBasicGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatTypeBasicGroup");
    s.store_field("basic_group_id", basic_group_id_);
    s.store_class_end();
  }
}

chatTypeSupergroup::chatTypeSupergroup()
  : supergroup_id_()
  , is_channel_()
{}

chatTypeSupergroup::chatTypeSupergroup(int53 supergroup_id_, bool is_channel_)
  : supergroup_id_(supergroup_id_)
  , is_channel_(is_channel_)
{}

const std::int32_t chatTypeSupergroup::ID;

void chatTypeSupergroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatTypeSupergroup");
    s.store_field("supergroup_id", supergroup_id_);
    s.store_field("is_channel", is_channel_);
    s.store_class_end();
  }
}

chatTypeSecret::chatTypeSecret()
  : secret_chat_id_()
  , user_id_()
{}

chatTypeSecret::chatTypeSecret(int32 secret_chat_id_, int53 user_id_)
  : secret_chat_id_(secret_chat_id_)
  , user_id_(user_id_)
{}

const std::int32_t chatTypeSecret::ID;

void chatTypeSecret::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chatTypeSecret");
    s.store_field("secret_chat_id", secret_chat_id_);
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

chats::chats()
  : total_count_()
  , chat_ids_()
{}

chats::chats(int32 total_count_, array<int53> &&chat_ids_)
  : total_count_(total_count_)
  , chat_ids_(std::move(chat_ids_))
{}

const std::int32_t chats::ID;

void chats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "chats");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("chat_ids", chat_ids_.size()); for (const auto &_value : chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

checkChatUsernameResultOk::checkChatUsernameResultOk() {
}

const std::int32_t checkChatUsernameResultOk::ID;

void checkChatUsernameResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "checkChatUsernameResultOk");
    s.store_class_end();
  }
}

checkChatUsernameResultUsernameInvalid::checkChatUsernameResultUsernameInvalid() {
}

const std::int32_t checkChatUsernameResultUsernameInvalid::ID;

void checkChatUsernameResultUsernameInvalid::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "checkChatUsernameResultUsernameInvalid");
    s.store_class_end();
  }
}

checkChatUsernameResultUsernameOccupied::checkChatUsernameResultUsernameOccupied() {
}

const std::int32_t checkChatUsernameResultUsernameOccupied::ID;

void checkChatUsernameResultUsernameOccupied::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "checkChatUsernameResultUsernameOccupied");
    s.store_class_end();
  }
}

checkChatUsernameResultUsernamePurchasable::checkChatUsernameResultUsernamePurchasable() {
}

const std::int32_t checkChatUsernameResultUsernamePurchasable::ID;

void checkChatUsernameResultUsernamePurchasable::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "checkChatUsernameResultUsernamePurchasable");
    s.store_class_end();
  }
}

checkChatUsernameResultPublicChatsTooMany::checkChatUsernameResultPublicChatsTooMany() {
}

const std::int32_t checkChatUsernameResultPublicChatsTooMany::ID;

void checkChatUsernameResultPublicChatsTooMany::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "checkChatUsernameResultPublicChatsTooMany");
    s.store_class_end();
  }
}

checkChatUsernameResultPublicGroupsUnavailable::checkChatUsernameResultPublicGroupsUnavailable() {
}

const std::int32_t checkChatUsernameResultPublicGroupsUnavailable::ID;

void checkChatUsernameResultPublicGroupsUnavailable::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "checkChatUsernameResultPublicGroupsUnavailable");
    s.store_class_end();
  }
}

checkStickerSetNameResultOk::checkStickerSetNameResultOk() {
}

const std::int32_t checkStickerSetNameResultOk::ID;

void checkStickerSetNameResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "checkStickerSetNameResultOk");
    s.store_class_end();
  }
}

checkStickerSetNameResultNameInvalid::checkStickerSetNameResultNameInvalid() {
}

const std::int32_t checkStickerSetNameResultNameInvalid::ID;

void checkStickerSetNameResultNameInvalid::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "checkStickerSetNameResultNameInvalid");
    s.store_class_end();
  }
}

checkStickerSetNameResultNameOccupied::checkStickerSetNameResultNameOccupied() {
}

const std::int32_t checkStickerSetNameResultNameOccupied::ID;

void checkStickerSetNameResultNameOccupied::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "checkStickerSetNameResultNameOccupied");
    s.store_class_end();
  }
}

closeBirthdayUser::closeBirthdayUser()
  : user_id_()
  , birthdate_()
{}

closeBirthdayUser::closeBirthdayUser(int53 user_id_, object_ptr<birthdate> &&birthdate_)
  : user_id_(user_id_)
  , birthdate_(std::move(birthdate_))
{}

const std::int32_t closeBirthdayUser::ID;

void closeBirthdayUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "closeBirthdayUser");
    s.store_field("user_id", user_id_);
    s.store_object_field("birthdate", static_cast<const BaseObject *>(birthdate_.get()));
    s.store_class_end();
  }
}

closedVectorPath::closedVectorPath()
  : commands_()
{}

closedVectorPath::closedVectorPath(array<object_ptr<VectorPathCommand>> &&commands_)
  : commands_(std::move(commands_))
{}

const std::int32_t closedVectorPath::ID;

void closedVectorPath::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "closedVectorPath");
    { s.store_vector_begin("commands", commands_.size()); for (const auto &_value : commands_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

collectibleItemInfo::collectibleItemInfo()
  : purchase_date_()
  , currency_()
  , amount_()
  , cryptocurrency_()
  , cryptocurrency_amount_()
  , url_()
{}

collectibleItemInfo::collectibleItemInfo(int32 purchase_date_, string const &currency_, int53 amount_, string const &cryptocurrency_, int64 cryptocurrency_amount_, string const &url_)
  : purchase_date_(purchase_date_)
  , currency_(currency_)
  , amount_(amount_)
  , cryptocurrency_(cryptocurrency_)
  , cryptocurrency_amount_(cryptocurrency_amount_)
  , url_(url_)
{}

const std::int32_t collectibleItemInfo::ID;

void collectibleItemInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "collectibleItemInfo");
    s.store_field("purchase_date", purchase_date_);
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("cryptocurrency", cryptocurrency_);
    s.store_field("cryptocurrency_amount", cryptocurrency_amount_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

collectibleItemTypeUsername::collectibleItemTypeUsername()
  : username_()
{}

collectibleItemTypeUsername::collectibleItemTypeUsername(string const &username_)
  : username_(username_)
{}

const std::int32_t collectibleItemTypeUsername::ID;

void collectibleItemTypeUsername::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "collectibleItemTypeUsername");
    s.store_field("username", username_);
    s.store_class_end();
  }
}

collectibleItemTypePhoneNumber::collectibleItemTypePhoneNumber()
  : phone_number_()
{}

collectibleItemTypePhoneNumber::collectibleItemTypePhoneNumber(string const &phone_number_)
  : phone_number_(phone_number_)
{}

const std::int32_t collectibleItemTypePhoneNumber::ID;

void collectibleItemTypePhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "collectibleItemTypePhoneNumber");
    s.store_field("phone_number", phone_number_);
    s.store_class_end();
  }
}

connectedAffiliateProgram::connectedAffiliateProgram()
  : url_()
  , bot_user_id_()
  , parameters_()
  , connection_date_()
  , is_disconnected_()
  , user_count_()
  , revenue_star_count_()
{}

connectedAffiliateProgram::connectedAffiliateProgram(string const &url_, int53 bot_user_id_, object_ptr<affiliateProgramParameters> &&parameters_, int32 connection_date_, bool is_disconnected_, int64 user_count_, int64 revenue_star_count_)
  : url_(url_)
  , bot_user_id_(bot_user_id_)
  , parameters_(std::move(parameters_))
  , connection_date_(connection_date_)
  , is_disconnected_(is_disconnected_)
  , user_count_(user_count_)
  , revenue_star_count_(revenue_star_count_)
{}

const std::int32_t connectedAffiliateProgram::ID;

void connectedAffiliateProgram::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectedAffiliateProgram");
    s.store_field("url", url_);
    s.store_field("bot_user_id", bot_user_id_);
    s.store_object_field("parameters", static_cast<const BaseObject *>(parameters_.get()));
    s.store_field("connection_date", connection_date_);
    s.store_field("is_disconnected", is_disconnected_);
    s.store_field("user_count", user_count_);
    s.store_field("revenue_star_count", revenue_star_count_);
    s.store_class_end();
  }
}

connectedAffiliatePrograms::connectedAffiliatePrograms()
  : total_count_()
  , programs_()
  , next_offset_()
{}

connectedAffiliatePrograms::connectedAffiliatePrograms(int32 total_count_, array<object_ptr<connectedAffiliateProgram>> &&programs_, string const &next_offset_)
  : total_count_(total_count_)
  , programs_(std::move(programs_))
  , next_offset_(next_offset_)
{}

const std::int32_t connectedAffiliatePrograms::ID;

void connectedAffiliatePrograms::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectedAffiliatePrograms");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("programs", programs_.size()); for (const auto &_value : programs_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

connectedWebsite::connectedWebsite()
  : id_()
  , domain_name_()
  , bot_user_id_()
  , browser_()
  , platform_()
  , log_in_date_()
  , last_active_date_()
  , ip_address_()
  , location_()
{}

connectedWebsite::connectedWebsite(int64 id_, string const &domain_name_, int53 bot_user_id_, string const &browser_, string const &platform_, int32 log_in_date_, int32 last_active_date_, string const &ip_address_, string const &location_)
  : id_(id_)
  , domain_name_(domain_name_)
  , bot_user_id_(bot_user_id_)
  , browser_(browser_)
  , platform_(platform_)
  , log_in_date_(log_in_date_)
  , last_active_date_(last_active_date_)
  , ip_address_(ip_address_)
  , location_(location_)
{}

const std::int32_t connectedWebsite::ID;

void connectedWebsite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectedWebsite");
    s.store_field("id", id_);
    s.store_field("domain_name", domain_name_);
    s.store_field("bot_user_id", bot_user_id_);
    s.store_field("browser", browser_);
    s.store_field("platform", platform_);
    s.store_field("log_in_date", log_in_date_);
    s.store_field("last_active_date", last_active_date_);
    s.store_field("ip_address", ip_address_);
    s.store_field("location", location_);
    s.store_class_end();
  }
}

connectedWebsites::connectedWebsites()
  : websites_()
{}

connectedWebsites::connectedWebsites(array<object_ptr<connectedWebsite>> &&websites_)
  : websites_(std::move(websites_))
{}

const std::int32_t connectedWebsites::ID;

void connectedWebsites::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectedWebsites");
    { s.store_vector_begin("websites", websites_.size()); for (const auto &_value : websites_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

connectionStateWaitingForNetwork::connectionStateWaitingForNetwork() {
}

const std::int32_t connectionStateWaitingForNetwork::ID;

void connectionStateWaitingForNetwork::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectionStateWaitingForNetwork");
    s.store_class_end();
  }
}

connectionStateConnectingToProxy::connectionStateConnectingToProxy() {
}

const std::int32_t connectionStateConnectingToProxy::ID;

void connectionStateConnectingToProxy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectionStateConnectingToProxy");
    s.store_class_end();
  }
}

connectionStateConnecting::connectionStateConnecting() {
}

const std::int32_t connectionStateConnecting::ID;

void connectionStateConnecting::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectionStateConnecting");
    s.store_class_end();
  }
}

connectionStateUpdating::connectionStateUpdating() {
}

const std::int32_t connectionStateUpdating::ID;

void connectionStateUpdating::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectionStateUpdating");
    s.store_class_end();
  }
}

connectionStateReady::connectionStateReady() {
}

const std::int32_t connectionStateReady::ID;

void connectionStateReady::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "connectionStateReady");
    s.store_class_end();
  }
}

contact::contact()
  : phone_number_()
  , first_name_()
  , last_name_()
  , vcard_()
  , user_id_()
{}

contact::contact(string const &phone_number_, string const &first_name_, string const &last_name_, string const &vcard_, int53 user_id_)
  : phone_number_(phone_number_)
  , first_name_(first_name_)
  , last_name_(last_name_)
  , vcard_(vcard_)
  , user_id_(user_id_)
{}

const std::int32_t contact::ID;

void contact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "contact");
    s.store_field("phone_number", phone_number_);
    s.store_field("first_name", first_name_);
    s.store_field("last_name", last_name_);
    s.store_field("vcard", vcard_);
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

count::count()
  : count_()
{}

count::count(int32 count_)
  : count_(count_)
{}

const std::int32_t count::ID;

void count::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "count");
    s.store_field("count", count_);
    s.store_class_end();
  }
}

countries::countries()
  : countries_()
{}

countries::countries(array<object_ptr<countryInfo>> &&countries_)
  : countries_(std::move(countries_))
{}

const std::int32_t countries::ID;

void countries::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "countries");
    { s.store_vector_begin("countries", countries_.size()); for (const auto &_value : countries_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

countryInfo::countryInfo()
  : country_code_()
  , name_()
  , english_name_()
  , is_hidden_()
  , calling_codes_()
{}

countryInfo::countryInfo(string const &country_code_, string const &name_, string const &english_name_, bool is_hidden_, array<string> &&calling_codes_)
  : country_code_(country_code_)
  , name_(name_)
  , english_name_(english_name_)
  , is_hidden_(is_hidden_)
  , calling_codes_(std::move(calling_codes_))
{}

const std::int32_t countryInfo::ID;

void countryInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "countryInfo");
    s.store_field("country_code", country_code_);
    s.store_field("name", name_);
    s.store_field("english_name", english_name_);
    s.store_field("is_hidden", is_hidden_);
    { s.store_vector_begin("calling_codes", calling_codes_.size()); for (const auto &_value : calling_codes_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

createdBasicGroupChat::createdBasicGroupChat()
  : chat_id_()
  , failed_to_add_members_()
{}

createdBasicGroupChat::createdBasicGroupChat(int53 chat_id_, object_ptr<failedToAddMembers> &&failed_to_add_members_)
  : chat_id_(chat_id_)
  , failed_to_add_members_(std::move(failed_to_add_members_))
{}

const std::int32_t createdBasicGroupChat::ID;

void createdBasicGroupChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "createdBasicGroupChat");
    s.store_field("chat_id", chat_id_);
    s.store_object_field("failed_to_add_members", static_cast<const BaseObject *>(failed_to_add_members_.get()));
    s.store_class_end();
  }
}

currentWeather::currentWeather()
  : temperature_()
  , emoji_()
{}

currentWeather::currentWeather(double temperature_, string const &emoji_)
  : temperature_(temperature_)
  , emoji_(emoji_)
{}

const std::int32_t currentWeather::ID;

void currentWeather::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "currentWeather");
    s.store_field("temperature", temperature_);
    s.store_field("emoji", emoji_);
    s.store_class_end();
  }
}

customRequestResult::customRequestResult()
  : result_()
{}

customRequestResult::customRequestResult(string const &result_)
  : result_(result_)
{}

const std::int32_t customRequestResult::ID;

void customRequestResult::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "customRequestResult");
    s.store_field("result", result_);
    s.store_class_end();
  }
}

databaseStatistics::databaseStatistics()
  : statistics_()
{}

databaseStatistics::databaseStatistics(string const &statistics_)
  : statistics_(statistics_)
{}

const std::int32_t databaseStatistics::ID;

void databaseStatistics::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "databaseStatistics");
    s.store_field("statistics", statistics_);
    s.store_class_end();
  }
}

date::date()
  : day_()
  , month_()
  , year_()
{}

date::date(int32 day_, int32 month_, int32 year_)
  : day_(day_)
  , month_(month_)
  , year_(year_)
{}

const std::int32_t date::ID;

void date::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "date");
    s.store_field("day", day_);
    s.store_field("month", month_);
    s.store_field("year", year_);
    s.store_class_end();
  }
}

dateRange::dateRange()
  : start_date_()
  , end_date_()
{}

dateRange::dateRange(int32 start_date_, int32 end_date_)
  : start_date_(start_date_)
  , end_date_(end_date_)
{}

const std::int32_t dateRange::ID;

void dateRange::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "dateRange");
    s.store_field("start_date", start_date_);
    s.store_field("end_date", end_date_);
    s.store_class_end();
  }
}

datedFile::datedFile()
  : file_()
  , date_()
{}

datedFile::datedFile(object_ptr<file> &&file_, int32 date_)
  : file_(std::move(file_))
  , date_(date_)
{}

const std::int32_t datedFile::ID;

void datedFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "datedFile");
    s.store_object_field("file", static_cast<const BaseObject *>(file_.get()));
    s.store_field("date", date_);
    s.store_class_end();
  }
}

deepLinkInfo::deepLinkInfo()
  : text_()
  , need_update_application_()
{}

deepLinkInfo::deepLinkInfo(object_ptr<formattedText> &&text_, bool need_update_application_)
  : text_(std::move(text_))
  , need_update_application_(need_update_application_)
{}

const std::int32_t deepLinkInfo::ID;

void deepLinkInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deepLinkInfo");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("need_update_application", need_update_application_);
    s.store_class_end();
  }
}

deviceTokenFirebaseCloudMessaging::deviceTokenFirebaseCloudMessaging()
  : token_()
  , encrypt_()
{}

deviceTokenFirebaseCloudMessaging::deviceTokenFirebaseCloudMessaging(string const &token_, bool encrypt_)
  : token_(token_)
  , encrypt_(encrypt_)
{}

const std::int32_t deviceTokenFirebaseCloudMessaging::ID;

void deviceTokenFirebaseCloudMessaging::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenFirebaseCloudMessaging");
    s.store_field("token", token_);
    s.store_field("encrypt", encrypt_);
    s.store_class_end();
  }
}

deviceTokenApplePush::deviceTokenApplePush()
  : device_token_()
  , is_app_sandbox_()
{}

deviceTokenApplePush::deviceTokenApplePush(string const &device_token_, bool is_app_sandbox_)
  : device_token_(device_token_)
  , is_app_sandbox_(is_app_sandbox_)
{}

const std::int32_t deviceTokenApplePush::ID;

void deviceTokenApplePush::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenApplePush");
    s.store_field("device_token", device_token_);
    s.store_field("is_app_sandbox", is_app_sandbox_);
    s.store_class_end();
  }
}

deviceTokenApplePushVoIP::deviceTokenApplePushVoIP()
  : device_token_()
  , is_app_sandbox_()
  , encrypt_()
{}

deviceTokenApplePushVoIP::deviceTokenApplePushVoIP(string const &device_token_, bool is_app_sandbox_, bool encrypt_)
  : device_token_(device_token_)
  , is_app_sandbox_(is_app_sandbox_)
  , encrypt_(encrypt_)
{}

const std::int32_t deviceTokenApplePushVoIP::ID;

void deviceTokenApplePushVoIP::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenApplePushVoIP");
    s.store_field("device_token", device_token_);
    s.store_field("is_app_sandbox", is_app_sandbox_);
    s.store_field("encrypt", encrypt_);
    s.store_class_end();
  }
}

deviceTokenWindowsPush::deviceTokenWindowsPush()
  : access_token_()
{}

deviceTokenWindowsPush::deviceTokenWindowsPush(string const &access_token_)
  : access_token_(access_token_)
{}

const std::int32_t deviceTokenWindowsPush::ID;

void deviceTokenWindowsPush::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenWindowsPush");
    s.store_field("access_token", access_token_);
    s.store_class_end();
  }
}

deviceTokenMicrosoftPush::deviceTokenMicrosoftPush()
  : channel_uri_()
{}

deviceTokenMicrosoftPush::deviceTokenMicrosoftPush(string const &channel_uri_)
  : channel_uri_(channel_uri_)
{}

const std::int32_t deviceTokenMicrosoftPush::ID;

void deviceTokenMicrosoftPush::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenMicrosoftPush");
    s.store_field("channel_uri", channel_uri_);
    s.store_class_end();
  }
}

deviceTokenMicrosoftPushVoIP::deviceTokenMicrosoftPushVoIP()
  : channel_uri_()
{}

deviceTokenMicrosoftPushVoIP::deviceTokenMicrosoftPushVoIP(string const &channel_uri_)
  : channel_uri_(channel_uri_)
{}

const std::int32_t deviceTokenMicrosoftPushVoIP::ID;

void deviceTokenMicrosoftPushVoIP::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenMicrosoftPushVoIP");
    s.store_field("channel_uri", channel_uri_);
    s.store_class_end();
  }
}

deviceTokenWebPush::deviceTokenWebPush()
  : endpoint_()
  , p256dh_base64url_()
  , auth_base64url_()
{}

deviceTokenWebPush::deviceTokenWebPush(string const &endpoint_, string const &p256dh_base64url_, string const &auth_base64url_)
  : endpoint_(endpoint_)
  , p256dh_base64url_(p256dh_base64url_)
  , auth_base64url_(auth_base64url_)
{}

const std::int32_t deviceTokenWebPush::ID;

void deviceTokenWebPush::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenWebPush");
    s.store_field("endpoint", endpoint_);
    s.store_field("p256dh_base64url", p256dh_base64url_);
    s.store_field("auth_base64url", auth_base64url_);
    s.store_class_end();
  }
}

deviceTokenSimplePush::deviceTokenSimplePush()
  : endpoint_()
{}

deviceTokenSimplePush::deviceTokenSimplePush(string const &endpoint_)
  : endpoint_(endpoint_)
{}

const std::int32_t deviceTokenSimplePush::ID;

void deviceTokenSimplePush::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenSimplePush");
    s.store_field("endpoint", endpoint_);
    s.store_class_end();
  }
}

deviceTokenUbuntuPush::deviceTokenUbuntuPush()
  : token_()
{}

deviceTokenUbuntuPush::deviceTokenUbuntuPush(string const &token_)
  : token_(token_)
{}

const std::int32_t deviceTokenUbuntuPush::ID;

void deviceTokenUbuntuPush::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenUbuntuPush");
    s.store_field("token", token_);
    s.store_class_end();
  }
}

deviceTokenBlackBerryPush::deviceTokenBlackBerryPush()
  : token_()
{}

deviceTokenBlackBerryPush::deviceTokenBlackBerryPush(string const &token_)
  : token_(token_)
{}

const std::int32_t deviceTokenBlackBerryPush::ID;

void deviceTokenBlackBerryPush::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenBlackBerryPush");
    s.store_field("token", token_);
    s.store_class_end();
  }
}

deviceTokenTizenPush::deviceTokenTizenPush()
  : reg_id_()
{}

deviceTokenTizenPush::deviceTokenTizenPush(string const &reg_id_)
  : reg_id_(reg_id_)
{}

const std::int32_t deviceTokenTizenPush::ID;

void deviceTokenTizenPush::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenTizenPush");
    s.store_field("reg_id", reg_id_);
    s.store_class_end();
  }
}

deviceTokenHuaweiPush::deviceTokenHuaweiPush()
  : token_()
  , encrypt_()
{}

deviceTokenHuaweiPush::deviceTokenHuaweiPush(string const &token_, bool encrypt_)
  : token_(token_)
  , encrypt_(encrypt_)
{}

const std::int32_t deviceTokenHuaweiPush::ID;

void deviceTokenHuaweiPush::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "deviceTokenHuaweiPush");
    s.store_field("token", token_);
    s.store_field("encrypt", encrypt_);
    s.store_class_end();
  }
}

diceStickersRegular::diceStickersRegular()
  : sticker_()
{}

diceStickersRegular::diceStickersRegular(object_ptr<sticker> &&sticker_)
  : sticker_(std::move(sticker_))
{}

const std::int32_t diceStickersRegular::ID;

void diceStickersRegular::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "diceStickersRegular");
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

diceStickersSlotMachine::diceStickersSlotMachine()
  : background_()
  , lever_()
  , left_reel_()
  , center_reel_()
  , right_reel_()
{}

diceStickersSlotMachine::diceStickersSlotMachine(object_ptr<sticker> &&background_, object_ptr<sticker> &&lever_, object_ptr<sticker> &&left_reel_, object_ptr<sticker> &&center_reel_, object_ptr<sticker> &&right_reel_)
  : background_(std::move(background_))
  , lever_(std::move(lever_))
  , left_reel_(std::move(left_reel_))
  , center_reel_(std::move(center_reel_))
  , right_reel_(std::move(right_reel_))
{}

const std::int32_t diceStickersSlotMachine::ID;

void diceStickersSlotMachine::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "diceStickersSlotMachine");
    s.store_object_field("background", static_cast<const BaseObject *>(background_.get()));
    s.store_object_field("lever", static_cast<const BaseObject *>(lever_.get()));
    s.store_object_field("left_reel", static_cast<const BaseObject *>(left_reel_.get()));
    s.store_object_field("center_reel", static_cast<const BaseObject *>(center_reel_.get()));
    s.store_object_field("right_reel", static_cast<const BaseObject *>(right_reel_.get()));
    s.store_class_end();
  }
}

document::document()
  : file_name_()
  , mime_type_()
  , minithumbnail_()
  , thumbnail_()
  , document_()
{}

document::document(string const &file_name_, string const &mime_type_, object_ptr<minithumbnail> &&minithumbnail_, object_ptr<thumbnail> &&thumbnail_, object_ptr<file> &&document_)
  : file_name_(file_name_)
  , mime_type_(mime_type_)
  , minithumbnail_(std::move(minithumbnail_))
  , thumbnail_(std::move(thumbnail_))
  , document_(std::move(document_))
{}

const std::int32_t document::ID;

void document::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "document");
    s.store_field("file_name", file_name_);
    s.store_field("mime_type", mime_type_);
    s.store_object_field("minithumbnail", static_cast<const BaseObject *>(minithumbnail_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_class_end();
  }
}

downloadedFileCounts::downloadedFileCounts()
  : active_count_()
  , paused_count_()
  , completed_count_()
{}

downloadedFileCounts::downloadedFileCounts(int32 active_count_, int32 paused_count_, int32 completed_count_)
  : active_count_(active_count_)
  , paused_count_(paused_count_)
  , completed_count_(completed_count_)
{}

const std::int32_t downloadedFileCounts::ID;

void downloadedFileCounts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "downloadedFileCounts");
    s.store_field("active_count", active_count_);
    s.store_field("paused_count", paused_count_);
    s.store_field("completed_count", completed_count_);
    s.store_class_end();
  }
}

draftMessage::draftMessage()
  : reply_to_()
  , date_()
  , input_message_text_()
  , effect_id_()
{}

draftMessage::draftMessage(object_ptr<InputMessageReplyTo> &&reply_to_, int32 date_, object_ptr<InputMessageContent> &&input_message_text_, int64 effect_id_)
  : reply_to_(std::move(reply_to_))
  , date_(date_)
  , input_message_text_(std::move(input_message_text_))
  , effect_id_(effect_id_)
{}

const std::int32_t draftMessage::ID;

void draftMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "draftMessage");
    s.store_object_field("reply_to", static_cast<const BaseObject *>(reply_to_.get()));
    s.store_field("date", date_);
    s.store_object_field("input_message_text", static_cast<const BaseObject *>(input_message_text_.get()));
    s.store_field("effect_id", effect_id_);
    s.store_class_end();
  }
}

emailAddressAuthenticationCode::emailAddressAuthenticationCode()
  : code_()
{}

emailAddressAuthenticationCode::emailAddressAuthenticationCode(string const &code_)
  : code_(code_)
{}

const std::int32_t emailAddressAuthenticationCode::ID;

void emailAddressAuthenticationCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailAddressAuthenticationCode");
    s.store_field("code", code_);
    s.store_class_end();
  }
}

emailAddressAuthenticationAppleId::emailAddressAuthenticationAppleId()
  : token_()
{}

emailAddressAuthenticationAppleId::emailAddressAuthenticationAppleId(string const &token_)
  : token_(token_)
{}

const std::int32_t emailAddressAuthenticationAppleId::ID;

void emailAddressAuthenticationAppleId::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailAddressAuthenticationAppleId");
    s.store_field("token", token_);
    s.store_class_end();
  }
}

emailAddressAuthenticationGoogleId::emailAddressAuthenticationGoogleId()
  : token_()
{}

emailAddressAuthenticationGoogleId::emailAddressAuthenticationGoogleId(string const &token_)
  : token_(token_)
{}

const std::int32_t emailAddressAuthenticationGoogleId::ID;

void emailAddressAuthenticationGoogleId::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailAddressAuthenticationGoogleId");
    s.store_field("token", token_);
    s.store_class_end();
  }
}

emailAddressAuthenticationCodeInfo::emailAddressAuthenticationCodeInfo()
  : email_address_pattern_()
  , length_()
{}

emailAddressAuthenticationCodeInfo::emailAddressAuthenticationCodeInfo(string const &email_address_pattern_, int32 length_)
  : email_address_pattern_(email_address_pattern_)
  , length_(length_)
{}

const std::int32_t emailAddressAuthenticationCodeInfo::ID;

void emailAddressAuthenticationCodeInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailAddressAuthenticationCodeInfo");
    s.store_field("email_address_pattern", email_address_pattern_);
    s.store_field("length", length_);
    s.store_class_end();
  }
}

emailAddressResetStateAvailable::emailAddressResetStateAvailable()
  : wait_period_()
{}

emailAddressResetStateAvailable::emailAddressResetStateAvailable(int32 wait_period_)
  : wait_period_(wait_period_)
{}

const std::int32_t emailAddressResetStateAvailable::ID;

void emailAddressResetStateAvailable::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailAddressResetStateAvailable");
    s.store_field("wait_period", wait_period_);
    s.store_class_end();
  }
}

emailAddressResetStatePending::emailAddressResetStatePending()
  : reset_in_()
{}

emailAddressResetStatePending::emailAddressResetStatePending(int32 reset_in_)
  : reset_in_(reset_in_)
{}

const std::int32_t emailAddressResetStatePending::ID;

void emailAddressResetStatePending::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emailAddressResetStatePending");
    s.store_field("reset_in", reset_in_);
    s.store_class_end();
  }
}

emojiCategories::emojiCategories()
  : categories_()
{}

emojiCategories::emojiCategories(array<object_ptr<emojiCategory>> &&categories_)
  : categories_(std::move(categories_))
{}

const std::int32_t emojiCategories::ID;

void emojiCategories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiCategories");
    { s.store_vector_begin("categories", categories_.size()); for (const auto &_value : categories_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

emojiCategory::emojiCategory()
  : name_()
  , icon_()
  , source_()
  , is_greeting_()
{}

emojiCategory::emojiCategory(string const &name_, object_ptr<sticker> &&icon_, object_ptr<EmojiCategorySource> &&source_, bool is_greeting_)
  : name_(name_)
  , icon_(std::move(icon_))
  , source_(std::move(source_))
  , is_greeting_(is_greeting_)
{}

const std::int32_t emojiCategory::ID;

void emojiCategory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiCategory");
    s.store_field("name", name_);
    s.store_object_field("icon", static_cast<const BaseObject *>(icon_.get()));
    s.store_object_field("source", static_cast<const BaseObject *>(source_.get()));
    s.store_field("is_greeting", is_greeting_);
    s.store_class_end();
  }
}

emojiCategorySourceSearch::emojiCategorySourceSearch()
  : emojis_()
{}

emojiCategorySourceSearch::emojiCategorySourceSearch(array<string> &&emojis_)
  : emojis_(std::move(emojis_))
{}

const std::int32_t emojiCategorySourceSearch::ID;

void emojiCategorySourceSearch::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiCategorySourceSearch");
    { s.store_vector_begin("emojis", emojis_.size()); for (const auto &_value : emojis_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

emojiCategorySourcePremium::emojiCategorySourcePremium() {
}

const std::int32_t emojiCategorySourcePremium::ID;

void emojiCategorySourcePremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiCategorySourcePremium");
    s.store_class_end();
  }
}

emojiCategoryTypeDefault::emojiCategoryTypeDefault() {
}

const std::int32_t emojiCategoryTypeDefault::ID;

void emojiCategoryTypeDefault::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiCategoryTypeDefault");
    s.store_class_end();
  }
}

emojiCategoryTypeRegularStickers::emojiCategoryTypeRegularStickers() {
}

const std::int32_t emojiCategoryTypeRegularStickers::ID;

void emojiCategoryTypeRegularStickers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiCategoryTypeRegularStickers");
    s.store_class_end();
  }
}

emojiCategoryTypeEmojiStatus::emojiCategoryTypeEmojiStatus() {
}

const std::int32_t emojiCategoryTypeEmojiStatus::ID;

void emojiCategoryTypeEmojiStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiCategoryTypeEmojiStatus");
    s.store_class_end();
  }
}

emojiCategoryTypeChatPhoto::emojiCategoryTypeChatPhoto() {
}

const std::int32_t emojiCategoryTypeChatPhoto::ID;

void emojiCategoryTypeChatPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiCategoryTypeChatPhoto");
    s.store_class_end();
  }
}

emojiKeyword::emojiKeyword()
  : emoji_()
  , keyword_()
{}

emojiKeyword::emojiKeyword(string const &emoji_, string const &keyword_)
  : emoji_(emoji_)
  , keyword_(keyword_)
{}

const std::int32_t emojiKeyword::ID;

void emojiKeyword::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiKeyword");
    s.store_field("emoji", emoji_);
    s.store_field("keyword", keyword_);
    s.store_class_end();
  }
}

emojiKeywords::emojiKeywords()
  : emoji_keywords_()
{}

emojiKeywords::emojiKeywords(array<object_ptr<emojiKeyword>> &&emoji_keywords_)
  : emoji_keywords_(std::move(emoji_keywords_))
{}

const std::int32_t emojiKeywords::ID;

void emojiKeywords::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiKeywords");
    { s.store_vector_begin("emoji_keywords", emoji_keywords_.size()); for (const auto &_value : emoji_keywords_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

emojiReaction::emojiReaction()
  : emoji_()
  , title_()
  , is_active_()
  , static_icon_()
  , appear_animation_()
  , select_animation_()
  , activate_animation_()
  , effect_animation_()
  , around_animation_()
  , center_animation_()
{}

emojiReaction::emojiReaction(string const &emoji_, string const &title_, bool is_active_, object_ptr<sticker> &&static_icon_, object_ptr<sticker> &&appear_animation_, object_ptr<sticker> &&select_animation_, object_ptr<sticker> &&activate_animation_, object_ptr<sticker> &&effect_animation_, object_ptr<sticker> &&around_animation_, object_ptr<sticker> &&center_animation_)
  : emoji_(emoji_)
  , title_(title_)
  , is_active_(is_active_)
  , static_icon_(std::move(static_icon_))
  , appear_animation_(std::move(appear_animation_))
  , select_animation_(std::move(select_animation_))
  , activate_animation_(std::move(activate_animation_))
  , effect_animation_(std::move(effect_animation_))
  , around_animation_(std::move(around_animation_))
  , center_animation_(std::move(center_animation_))
{}

const std::int32_t emojiReaction::ID;

void emojiReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiReaction");
    s.store_field("emoji", emoji_);
    s.store_field("title", title_);
    s.store_field("is_active", is_active_);
    s.store_object_field("static_icon", static_cast<const BaseObject *>(static_icon_.get()));
    s.store_object_field("appear_animation", static_cast<const BaseObject *>(appear_animation_.get()));
    s.store_object_field("select_animation", static_cast<const BaseObject *>(select_animation_.get()));
    s.store_object_field("activate_animation", static_cast<const BaseObject *>(activate_animation_.get()));
    s.store_object_field("effect_animation", static_cast<const BaseObject *>(effect_animation_.get()));
    s.store_object_field("around_animation", static_cast<const BaseObject *>(around_animation_.get()));
    s.store_object_field("center_animation", static_cast<const BaseObject *>(center_animation_.get()));
    s.store_class_end();
  }
}

emojiStatus::emojiStatus()
  : type_()
  , expiration_date_()
{}

emojiStatus::emojiStatus(object_ptr<EmojiStatusType> &&type_, int32 expiration_date_)
  : type_(std::move(type_))
  , expiration_date_(expiration_date_)
{}

const std::int32_t emojiStatus::ID;

void emojiStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiStatus");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("expiration_date", expiration_date_);
    s.store_class_end();
  }
}

emojiStatusCustomEmojis::emojiStatusCustomEmojis()
  : custom_emoji_ids_()
{}

emojiStatusCustomEmojis::emojiStatusCustomEmojis(array<int64> &&custom_emoji_ids_)
  : custom_emoji_ids_(std::move(custom_emoji_ids_))
{}

const std::int32_t emojiStatusCustomEmojis::ID;

void emojiStatusCustomEmojis::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiStatusCustomEmojis");
    { s.store_vector_begin("custom_emoji_ids", custom_emoji_ids_.size()); for (const auto &_value : custom_emoji_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

emojiStatusTypeCustomEmoji::emojiStatusTypeCustomEmoji()
  : custom_emoji_id_()
{}

emojiStatusTypeCustomEmoji::emojiStatusTypeCustomEmoji(int64 custom_emoji_id_)
  : custom_emoji_id_(custom_emoji_id_)
{}

const std::int32_t emojiStatusTypeCustomEmoji::ID;

void emojiStatusTypeCustomEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiStatusTypeCustomEmoji");
    s.store_field("custom_emoji_id", custom_emoji_id_);
    s.store_class_end();
  }
}

emojiStatusTypeUpgradedGift::emojiStatusTypeUpgradedGift()
  : upgraded_gift_id_()
  , gift_title_()
  , gift_name_()
  , model_custom_emoji_id_()
  , symbol_custom_emoji_id_()
  , backdrop_colors_()
{}

emojiStatusTypeUpgradedGift::emojiStatusTypeUpgradedGift(int64 upgraded_gift_id_, string const &gift_title_, string const &gift_name_, int64 model_custom_emoji_id_, int64 symbol_custom_emoji_id_, object_ptr<upgradedGiftBackdropColors> &&backdrop_colors_)
  : upgraded_gift_id_(upgraded_gift_id_)
  , gift_title_(gift_title_)
  , gift_name_(gift_name_)
  , model_custom_emoji_id_(model_custom_emoji_id_)
  , symbol_custom_emoji_id_(symbol_custom_emoji_id_)
  , backdrop_colors_(std::move(backdrop_colors_))
{}

const std::int32_t emojiStatusTypeUpgradedGift::ID;

void emojiStatusTypeUpgradedGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiStatusTypeUpgradedGift");
    s.store_field("upgraded_gift_id", upgraded_gift_id_);
    s.store_field("gift_title", gift_title_);
    s.store_field("gift_name", gift_name_);
    s.store_field("model_custom_emoji_id", model_custom_emoji_id_);
    s.store_field("symbol_custom_emoji_id", symbol_custom_emoji_id_);
    s.store_object_field("backdrop_colors", static_cast<const BaseObject *>(backdrop_colors_.get()));
    s.store_class_end();
  }
}

emojiStatuses::emojiStatuses()
  : emoji_statuses_()
{}

emojiStatuses::emojiStatuses(array<object_ptr<emojiStatus>> &&emoji_statuses_)
  : emoji_statuses_(std::move(emoji_statuses_))
{}

const std::int32_t emojiStatuses::ID;

void emojiStatuses::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojiStatuses");
    { s.store_vector_begin("emoji_statuses", emoji_statuses_.size()); for (const auto &_value : emoji_statuses_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

emojis::emojis()
  : emojis_()
{}

emojis::emojis(array<string> &&emojis_)
  : emojis_(std::move(emojis_))
{}

const std::int32_t emojis::ID;

void emojis::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "emojis");
    { s.store_vector_begin("emojis", emojis_.size()); for (const auto &_value : emojis_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

encryptedCredentials::encryptedCredentials()
  : data_()
  , hash_()
  , secret_()
{}

encryptedCredentials::encryptedCredentials(bytes const &data_, bytes const &hash_, bytes const &secret_)
  : data_(std::move(data_))
  , hash_(std::move(hash_))
  , secret_(std::move(secret_))
{}

const std::int32_t encryptedCredentials::ID;

void encryptedCredentials::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedCredentials");
    s.store_bytes_field("data", data_);
    s.store_bytes_field("hash", hash_);
    s.store_bytes_field("secret", secret_);
    s.store_class_end();
  }
}

encryptedPassportElement::encryptedPassportElement()
  : type_()
  , data_()
  , front_side_()
  , reverse_side_()
  , selfie_()
  , translation_()
  , files_()
  , value_()
  , hash_()
{}

encryptedPassportElement::encryptedPassportElement(object_ptr<PassportElementType> &&type_, bytes const &data_, object_ptr<datedFile> &&front_side_, object_ptr<datedFile> &&reverse_side_, object_ptr<datedFile> &&selfie_, array<object_ptr<datedFile>> &&translation_, array<object_ptr<datedFile>> &&files_, string const &value_, string const &hash_)
  : type_(std::move(type_))
  , data_(std::move(data_))
  , front_side_(std::move(front_side_))
  , reverse_side_(std::move(reverse_side_))
  , selfie_(std::move(selfie_))
  , translation_(std::move(translation_))
  , files_(std::move(files_))
  , value_(value_)
  , hash_(hash_)
{}

const std::int32_t encryptedPassportElement::ID;

void encryptedPassportElement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "encryptedPassportElement");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_bytes_field("data", data_);
    s.store_object_field("front_side", static_cast<const BaseObject *>(front_side_.get()));
    s.store_object_field("reverse_side", static_cast<const BaseObject *>(reverse_side_.get()));
    s.store_object_field("selfie", static_cast<const BaseObject *>(selfie_.get()));
    { s.store_vector_begin("translation", translation_.size()); for (const auto &_value : translation_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("files", files_.size()); for (const auto &_value : files_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("value", value_);
    s.store_field("hash", hash_);
    s.store_class_end();
  }
}

error::error()
  : code_()
  , message_()
{}

error::error(int32 code_, string const &message_)
  : code_(code_)
  , message_(message_)
{}

const std::int32_t error::ID;

void error::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "error");
    s.store_field("code", code_);
    s.store_field("message", message_);
    s.store_class_end();
  }
}

factCheck::factCheck()
  : text_()
  , country_code_()
{}

factCheck::factCheck(object_ptr<formattedText> &&text_, string const &country_code_)
  : text_(std::move(text_))
  , country_code_(country_code_)
{}

const std::int32_t factCheck::ID;

void factCheck::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "factCheck");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("country_code", country_code_);
    s.store_class_end();
  }
}

failedToAddMember::failedToAddMember()
  : user_id_()
  , premium_would_allow_invite_()
  , premium_required_to_send_messages_()
{}

failedToAddMember::failedToAddMember(int53 user_id_, bool premium_would_allow_invite_, bool premium_required_to_send_messages_)
  : user_id_(user_id_)
  , premium_would_allow_invite_(premium_would_allow_invite_)
  , premium_required_to_send_messages_(premium_required_to_send_messages_)
{}

const std::int32_t failedToAddMember::ID;

void failedToAddMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "failedToAddMember");
    s.store_field("user_id", user_id_);
    s.store_field("premium_would_allow_invite", premium_would_allow_invite_);
    s.store_field("premium_required_to_send_messages", premium_required_to_send_messages_);
    s.store_class_end();
  }
}

failedToAddMembers::failedToAddMembers()
  : failed_to_add_members_()
{}

failedToAddMembers::failedToAddMembers(array<object_ptr<failedToAddMember>> &&failed_to_add_members_)
  : failed_to_add_members_(std::move(failed_to_add_members_))
{}

const std::int32_t failedToAddMembers::ID;

void failedToAddMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "failedToAddMembers");
    { s.store_vector_begin("failed_to_add_members", failed_to_add_members_.size()); for (const auto &_value : failed_to_add_members_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

file::file()
  : id_()
  , size_()
  , expected_size_()
  , local_()
  , remote_()
{}

file::file(int32 id_, int53 size_, int53 expected_size_, object_ptr<localFile> &&local_, object_ptr<remoteFile> &&remote_)
  : id_(id_)
  , size_(size_)
  , expected_size_(expected_size_)
  , local_(std::move(local_))
  , remote_(std::move(remote_))
{}

const std::int32_t file::ID;

void file::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "file");
    s.store_field("id", id_);
    s.store_field("size", size_);
    s.store_field("expected_size", expected_size_);
    s.store_object_field("local", static_cast<const BaseObject *>(local_.get()));
    s.store_object_field("remote", static_cast<const BaseObject *>(remote_.get()));
    s.store_class_end();
  }
}

fileDownload::fileDownload()
  : file_id_()
  , message_()
  , add_date_()
  , complete_date_()
  , is_paused_()
{}

fileDownload::fileDownload(int32 file_id_, object_ptr<message> &&message_, int32 add_date_, int32 complete_date_, bool is_paused_)
  : file_id_(file_id_)
  , message_(std::move(message_))
  , add_date_(add_date_)
  , complete_date_(complete_date_)
  , is_paused_(is_paused_)
{}

const std::int32_t fileDownload::ID;

void fileDownload::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileDownload");
    s.store_field("file_id", file_id_);
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_field("add_date", add_date_);
    s.store_field("complete_date", complete_date_);
    s.store_field("is_paused", is_paused_);
    s.store_class_end();
  }
}

fileDownloadedPrefixSize::fileDownloadedPrefixSize()
  : size_()
{}

fileDownloadedPrefixSize::fileDownloadedPrefixSize(int53 size_)
  : size_(size_)
{}

const std::int32_t fileDownloadedPrefixSize::ID;

void fileDownloadedPrefixSize::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileDownloadedPrefixSize");
    s.store_field("size", size_);
    s.store_class_end();
  }
}

filePart::filePart()
  : data_()
{}

filePart::filePart(bytes const &data_)
  : data_(std::move(data_))
{}

const std::int32_t filePart::ID;

void filePart::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "filePart");
    s.store_bytes_field("data", data_);
    s.store_class_end();
  }
}

fileTypeNone::fileTypeNone() {
}

const std::int32_t fileTypeNone::ID;

void fileTypeNone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeNone");
    s.store_class_end();
  }
}

fileTypeAnimation::fileTypeAnimation() {
}

const std::int32_t fileTypeAnimation::ID;

void fileTypeAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeAnimation");
    s.store_class_end();
  }
}

fileTypeAudio::fileTypeAudio() {
}

const std::int32_t fileTypeAudio::ID;

void fileTypeAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeAudio");
    s.store_class_end();
  }
}

fileTypeDocument::fileTypeDocument() {
}

const std::int32_t fileTypeDocument::ID;

void fileTypeDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeDocument");
    s.store_class_end();
  }
}

fileTypeNotificationSound::fileTypeNotificationSound() {
}

const std::int32_t fileTypeNotificationSound::ID;

void fileTypeNotificationSound::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeNotificationSound");
    s.store_class_end();
  }
}

fileTypePhoto::fileTypePhoto() {
}

const std::int32_t fileTypePhoto::ID;

void fileTypePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypePhoto");
    s.store_class_end();
  }
}

fileTypePhotoStory::fileTypePhotoStory() {
}

const std::int32_t fileTypePhotoStory::ID;

void fileTypePhotoStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypePhotoStory");
    s.store_class_end();
  }
}

fileTypeProfilePhoto::fileTypeProfilePhoto() {
}

const std::int32_t fileTypeProfilePhoto::ID;

void fileTypeProfilePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeProfilePhoto");
    s.store_class_end();
  }
}

fileTypeSecret::fileTypeSecret() {
}

const std::int32_t fileTypeSecret::ID;

void fileTypeSecret::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeSecret");
    s.store_class_end();
  }
}

fileTypeSecretThumbnail::fileTypeSecretThumbnail() {
}

const std::int32_t fileTypeSecretThumbnail::ID;

void fileTypeSecretThumbnail::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeSecretThumbnail");
    s.store_class_end();
  }
}

fileTypeSecure::fileTypeSecure() {
}

const std::int32_t fileTypeSecure::ID;

void fileTypeSecure::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeSecure");
    s.store_class_end();
  }
}

fileTypeSelfDestructingPhoto::fileTypeSelfDestructingPhoto() {
}

const std::int32_t fileTypeSelfDestructingPhoto::ID;

void fileTypeSelfDestructingPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeSelfDestructingPhoto");
    s.store_class_end();
  }
}

fileTypeSelfDestructingVideo::fileTypeSelfDestructingVideo() {
}

const std::int32_t fileTypeSelfDestructingVideo::ID;

void fileTypeSelfDestructingVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeSelfDestructingVideo");
    s.store_class_end();
  }
}

fileTypeSelfDestructingVideoNote::fileTypeSelfDestructingVideoNote() {
}

const std::int32_t fileTypeSelfDestructingVideoNote::ID;

void fileTypeSelfDestructingVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeSelfDestructingVideoNote");
    s.store_class_end();
  }
}

fileTypeSelfDestructingVoiceNote::fileTypeSelfDestructingVoiceNote() {
}

const std::int32_t fileTypeSelfDestructingVoiceNote::ID;

void fileTypeSelfDestructingVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeSelfDestructingVoiceNote");
    s.store_class_end();
  }
}

fileTypeSticker::fileTypeSticker() {
}

const std::int32_t fileTypeSticker::ID;

void fileTypeSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeSticker");
    s.store_class_end();
  }
}

fileTypeThumbnail::fileTypeThumbnail() {
}

const std::int32_t fileTypeThumbnail::ID;

void fileTypeThumbnail::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeThumbnail");
    s.store_class_end();
  }
}

fileTypeUnknown::fileTypeUnknown() {
}

const std::int32_t fileTypeUnknown::ID;

void fileTypeUnknown::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeUnknown");
    s.store_class_end();
  }
}

fileTypeVideo::fileTypeVideo() {
}

const std::int32_t fileTypeVideo::ID;

void fileTypeVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeVideo");
    s.store_class_end();
  }
}

fileTypeVideoNote::fileTypeVideoNote() {
}

const std::int32_t fileTypeVideoNote::ID;

void fileTypeVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeVideoNote");
    s.store_class_end();
  }
}

fileTypeVideoStory::fileTypeVideoStory() {
}

const std::int32_t fileTypeVideoStory::ID;

void fileTypeVideoStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeVideoStory");
    s.store_class_end();
  }
}

fileTypeVoiceNote::fileTypeVoiceNote() {
}

const std::int32_t fileTypeVoiceNote::ID;

void fileTypeVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeVoiceNote");
    s.store_class_end();
  }
}

fileTypeWallpaper::fileTypeWallpaper() {
}

const std::int32_t fileTypeWallpaper::ID;

void fileTypeWallpaper::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "fileTypeWallpaper");
    s.store_class_end();
  }
}

firebaseAuthenticationSettingsAndroid::firebaseAuthenticationSettingsAndroid() {
}

const std::int32_t firebaseAuthenticationSettingsAndroid::ID;

void firebaseAuthenticationSettingsAndroid::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "firebaseAuthenticationSettingsAndroid");
    s.store_class_end();
  }
}

firebaseAuthenticationSettingsIos::firebaseAuthenticationSettingsIos()
  : device_token_()
  , is_app_sandbox_()
{}

firebaseAuthenticationSettingsIos::firebaseAuthenticationSettingsIos(string const &device_token_, bool is_app_sandbox_)
  : device_token_(device_token_)
  , is_app_sandbox_(is_app_sandbox_)
{}

const std::int32_t firebaseAuthenticationSettingsIos::ID;

void firebaseAuthenticationSettingsIos::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "firebaseAuthenticationSettingsIos");
    s.store_field("device_token", device_token_);
    s.store_field("is_app_sandbox", is_app_sandbox_);
    s.store_class_end();
  }
}

firebaseDeviceVerificationParametersSafetyNet::firebaseDeviceVerificationParametersSafetyNet()
  : nonce_()
{}

firebaseDeviceVerificationParametersSafetyNet::firebaseDeviceVerificationParametersSafetyNet(bytes const &nonce_)
  : nonce_(std::move(nonce_))
{}

const std::int32_t firebaseDeviceVerificationParametersSafetyNet::ID;

void firebaseDeviceVerificationParametersSafetyNet::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "firebaseDeviceVerificationParametersSafetyNet");
    s.store_bytes_field("nonce", nonce_);
    s.store_class_end();
  }
}

firebaseDeviceVerificationParametersPlayIntegrity::firebaseDeviceVerificationParametersPlayIntegrity()
  : nonce_()
  , cloud_project_number_()
{}

firebaseDeviceVerificationParametersPlayIntegrity::firebaseDeviceVerificationParametersPlayIntegrity(string const &nonce_, int64 cloud_project_number_)
  : nonce_(nonce_)
  , cloud_project_number_(cloud_project_number_)
{}

const std::int32_t firebaseDeviceVerificationParametersPlayIntegrity::ID;

void firebaseDeviceVerificationParametersPlayIntegrity::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "firebaseDeviceVerificationParametersPlayIntegrity");
    s.store_field("nonce", nonce_);
    s.store_field("cloud_project_number", cloud_project_number_);
    s.store_class_end();
  }
}

formattedText::formattedText()
  : text_()
  , entities_()
{}

formattedText::formattedText(string const &text_, array<object_ptr<textEntity>> &&entities_)
  : text_(text_)
  , entities_(std::move(entities_))
{}

const std::int32_t formattedText::ID;

void formattedText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "formattedText");
    s.store_field("text", text_);
    { s.store_vector_begin("entities", entities_.size()); for (const auto &_value : entities_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

forumTopic::forumTopic()
  : info_()
  , last_message_()
  , is_pinned_()
  , unread_count_()
  , last_read_inbox_message_id_()
  , last_read_outbox_message_id_()
  , unread_mention_count_()
  , unread_reaction_count_()
  , notification_settings_()
  , draft_message_()
{}

forumTopic::forumTopic(object_ptr<forumTopicInfo> &&info_, object_ptr<message> &&last_message_, bool is_pinned_, int32 unread_count_, int53 last_read_inbox_message_id_, int53 last_read_outbox_message_id_, int32 unread_mention_count_, int32 unread_reaction_count_, object_ptr<chatNotificationSettings> &&notification_settings_, object_ptr<draftMessage> &&draft_message_)
  : info_(std::move(info_))
  , last_message_(std::move(last_message_))
  , is_pinned_(is_pinned_)
  , unread_count_(unread_count_)
  , last_read_inbox_message_id_(last_read_inbox_message_id_)
  , last_read_outbox_message_id_(last_read_outbox_message_id_)
  , unread_mention_count_(unread_mention_count_)
  , unread_reaction_count_(unread_reaction_count_)
  , notification_settings_(std::move(notification_settings_))
  , draft_message_(std::move(draft_message_))
{}

const std::int32_t forumTopic::ID;

void forumTopic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "forumTopic");
    s.store_object_field("info", static_cast<const BaseObject *>(info_.get()));
    s.store_object_field("last_message", static_cast<const BaseObject *>(last_message_.get()));
    s.store_field("is_pinned", is_pinned_);
    s.store_field("unread_count", unread_count_);
    s.store_field("last_read_inbox_message_id", last_read_inbox_message_id_);
    s.store_field("last_read_outbox_message_id", last_read_outbox_message_id_);
    s.store_field("unread_mention_count", unread_mention_count_);
    s.store_field("unread_reaction_count", unread_reaction_count_);
    s.store_object_field("notification_settings", static_cast<const BaseObject *>(notification_settings_.get()));
    s.store_object_field("draft_message", static_cast<const BaseObject *>(draft_message_.get()));
    s.store_class_end();
  }
}

forumTopicIcon::forumTopicIcon()
  : color_()
  , custom_emoji_id_()
{}

forumTopicIcon::forumTopicIcon(int32 color_, int64 custom_emoji_id_)
  : color_(color_)
  , custom_emoji_id_(custom_emoji_id_)
{}

const std::int32_t forumTopicIcon::ID;

void forumTopicIcon::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "forumTopicIcon");
    s.store_field("color", color_);
    s.store_field("custom_emoji_id", custom_emoji_id_);
    s.store_class_end();
  }
}

forumTopicInfo::forumTopicInfo()
  : message_thread_id_()
  , name_()
  , icon_()
  , creation_date_()
  , creator_id_()
  , is_general_()
  , is_outgoing_()
  , is_closed_()
  , is_hidden_()
{}

forumTopicInfo::forumTopicInfo(int53 message_thread_id_, string const &name_, object_ptr<forumTopicIcon> &&icon_, int32 creation_date_, object_ptr<MessageSender> &&creator_id_, bool is_general_, bool is_outgoing_, bool is_closed_, bool is_hidden_)
  : message_thread_id_(message_thread_id_)
  , name_(name_)
  , icon_(std::move(icon_))
  , creation_date_(creation_date_)
  , creator_id_(std::move(creator_id_))
  , is_general_(is_general_)
  , is_outgoing_(is_outgoing_)
  , is_closed_(is_closed_)
  , is_hidden_(is_hidden_)
{}

const std::int32_t forumTopicInfo::ID;

void forumTopicInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "forumTopicInfo");
    s.store_field("message_thread_id", message_thread_id_);
    s.store_field("name", name_);
    s.store_object_field("icon", static_cast<const BaseObject *>(icon_.get()));
    s.store_field("creation_date", creation_date_);
    s.store_object_field("creator_id", static_cast<const BaseObject *>(creator_id_.get()));
    s.store_field("is_general", is_general_);
    s.store_field("is_outgoing", is_outgoing_);
    s.store_field("is_closed", is_closed_);
    s.store_field("is_hidden", is_hidden_);
    s.store_class_end();
  }
}

forumTopics::forumTopics()
  : total_count_()
  , topics_()
  , next_offset_date_()
  , next_offset_message_id_()
  , next_offset_message_thread_id_()
{}

forumTopics::forumTopics(int32 total_count_, array<object_ptr<forumTopic>> &&topics_, int32 next_offset_date_, int53 next_offset_message_id_, int53 next_offset_message_thread_id_)
  : total_count_(total_count_)
  , topics_(std::move(topics_))
  , next_offset_date_(next_offset_date_)
  , next_offset_message_id_(next_offset_message_id_)
  , next_offset_message_thread_id_(next_offset_message_thread_id_)
{}

const std::int32_t forumTopics::ID;

void forumTopics::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "forumTopics");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("topics", topics_.size()); for (const auto &_value : topics_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset_date", next_offset_date_);
    s.store_field("next_offset_message_id", next_offset_message_id_);
    s.store_field("next_offset_message_thread_id", next_offset_message_thread_id_);
    s.store_class_end();
  }
}

forwardSource::forwardSource()
  : chat_id_()
  , message_id_()
  , sender_id_()
  , sender_name_()
  , date_()
  , is_outgoing_()
{}

forwardSource::forwardSource(int53 chat_id_, int53 message_id_, object_ptr<MessageSender> &&sender_id_, string const &sender_name_, int32 date_, bool is_outgoing_)
  : chat_id_(chat_id_)
  , message_id_(message_id_)
  , sender_id_(std::move(sender_id_))
  , sender_name_(sender_name_)
  , date_(date_)
  , is_outgoing_(is_outgoing_)
{}

const std::int32_t forwardSource::ID;

void forwardSource::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "forwardSource");
    s.store_field("chat_id", chat_id_);
    s.store_field("message_id", message_id_);
    s.store_object_field("sender_id", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_field("sender_name", sender_name_);
    s.store_field("date", date_);
    s.store_field("is_outgoing", is_outgoing_);
    s.store_class_end();
  }
}

foundAffiliateProgram::foundAffiliateProgram()
  : bot_user_id_()
  , info_()
{}

foundAffiliateProgram::foundAffiliateProgram(int53 bot_user_id_, object_ptr<affiliateProgramInfo> &&info_)
  : bot_user_id_(bot_user_id_)
  , info_(std::move(info_))
{}

const std::int32_t foundAffiliateProgram::ID;

void foundAffiliateProgram::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundAffiliateProgram");
    s.store_field("bot_user_id", bot_user_id_);
    s.store_object_field("info", static_cast<const BaseObject *>(info_.get()));
    s.store_class_end();
  }
}

foundAffiliatePrograms::foundAffiliatePrograms()
  : total_count_()
  , programs_()
  , next_offset_()
{}

foundAffiliatePrograms::foundAffiliatePrograms(int32 total_count_, array<object_ptr<foundAffiliateProgram>> &&programs_, string const &next_offset_)
  : total_count_(total_count_)
  , programs_(std::move(programs_))
  , next_offset_(next_offset_)
{}

const std::int32_t foundAffiliatePrograms::ID;

void foundAffiliatePrograms::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundAffiliatePrograms");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("programs", programs_.size()); for (const auto &_value : programs_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

foundChatBoosts::foundChatBoosts()
  : total_count_()
  , boosts_()
  , next_offset_()
{}

foundChatBoosts::foundChatBoosts(int32 total_count_, array<object_ptr<chatBoost>> &&boosts_, string const &next_offset_)
  : total_count_(total_count_)
  , boosts_(std::move(boosts_))
  , next_offset_(next_offset_)
{}

const std::int32_t foundChatBoosts::ID;

void foundChatBoosts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundChatBoosts");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("boosts", boosts_.size()); for (const auto &_value : boosts_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

foundChatMessages::foundChatMessages()
  : total_count_()
  , messages_()
  , next_from_message_id_()
{}

foundChatMessages::foundChatMessages(int32 total_count_, array<object_ptr<message>> &&messages_, int53 next_from_message_id_)
  : total_count_(total_count_)
  , messages_(std::move(messages_))
  , next_from_message_id_(next_from_message_id_)
{}

const std::int32_t foundChatMessages::ID;

void foundChatMessages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundChatMessages");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("messages", messages_.size()); for (const auto &_value : messages_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_from_message_id", next_from_message_id_);
    s.store_class_end();
  }
}

foundFileDownloads::foundFileDownloads()
  : total_counts_()
  , files_()
  , next_offset_()
{}

foundFileDownloads::foundFileDownloads(object_ptr<downloadedFileCounts> &&total_counts_, array<object_ptr<fileDownload>> &&files_, string const &next_offset_)
  : total_counts_(std::move(total_counts_))
  , files_(std::move(files_))
  , next_offset_(next_offset_)
{}

const std::int32_t foundFileDownloads::ID;

void foundFileDownloads::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundFileDownloads");
    s.store_object_field("total_counts", static_cast<const BaseObject *>(total_counts_.get()));
    { s.store_vector_begin("files", files_.size()); for (const auto &_value : files_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

foundMessages::foundMessages()
  : total_count_()
  , messages_()
  , next_offset_()
{}

foundMessages::foundMessages(int32 total_count_, array<object_ptr<message>> &&messages_, string const &next_offset_)
  : total_count_(total_count_)
  , messages_(std::move(messages_))
  , next_offset_(next_offset_)
{}

const std::int32_t foundMessages::ID;

void foundMessages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundMessages");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("messages", messages_.size()); for (const auto &_value : messages_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

foundPosition::foundPosition()
  : position_()
{}

foundPosition::foundPosition(int32 position_)
  : position_(position_)
{}

const std::int32_t foundPosition::ID;

void foundPosition::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundPosition");
    s.store_field("position", position_);
    s.store_class_end();
  }
}

foundPositions::foundPositions()
  : total_count_()
  , positions_()
{}

foundPositions::foundPositions(int32 total_count_, array<int32> &&positions_)
  : total_count_(total_count_)
  , positions_(std::move(positions_))
{}

const std::int32_t foundPositions::ID;

void foundPositions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundPositions");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("positions", positions_.size()); for (const auto &_value : positions_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

foundStories::foundStories()
  : total_count_()
  , stories_()
  , next_offset_()
{}

foundStories::foundStories(int32 total_count_, array<object_ptr<story>> &&stories_, string const &next_offset_)
  : total_count_(total_count_)
  , stories_(std::move(stories_))
  , next_offset_(next_offset_)
{}

const std::int32_t foundStories::ID;

void foundStories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundStories");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("stories", stories_.size()); for (const auto &_value : stories_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

foundUsers::foundUsers()
  : user_ids_()
  , next_offset_()
{}

foundUsers::foundUsers(array<int53> &&user_ids_, string const &next_offset_)
  : user_ids_(std::move(user_ids_))
  , next_offset_(next_offset_)
{}

const std::int32_t foundUsers::ID;

void foundUsers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundUsers");
    { s.store_vector_begin("user_ids", user_ids_.size()); for (const auto &_value : user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

foundWebApp::foundWebApp()
  : web_app_()
  , request_write_access_()
  , skip_confirmation_()
{}

foundWebApp::foundWebApp(object_ptr<webApp> &&web_app_, bool request_write_access_, bool skip_confirmation_)
  : web_app_(std::move(web_app_))
  , request_write_access_(request_write_access_)
  , skip_confirmation_(skip_confirmation_)
{}

const std::int32_t foundWebApp::ID;

void foundWebApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "foundWebApp");
    s.store_object_field("web_app", static_cast<const BaseObject *>(web_app_.get()));
    s.store_field("request_write_access", request_write_access_);
    s.store_field("skip_confirmation", skip_confirmation_);
    s.store_class_end();
  }
}

game::game()
  : id_()
  , short_name_()
  , title_()
  , text_()
  , description_()
  , photo_()
  , animation_()
{}

game::game(int64 id_, string const &short_name_, string const &title_, object_ptr<formattedText> &&text_, string const &description_, object_ptr<photo> &&photo_, object_ptr<animation> &&animation_)
  : id_(id_)
  , short_name_(short_name_)
  , title_(title_)
  , text_(std::move(text_))
  , description_(description_)
  , photo_(std::move(photo_))
  , animation_(std::move(animation_))
{}

const std::int32_t game::ID;

void game::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "game");
    s.store_field("id", id_);
    s.store_field("short_name", short_name_);
    s.store_field("title", title_);
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("description", description_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_class_end();
  }
}

gameHighScore::gameHighScore()
  : position_()
  , user_id_()
  , score_()
{}

gameHighScore::gameHighScore(int32 position_, int53 user_id_, int32 score_)
  : position_(position_)
  , user_id_(user_id_)
  , score_(score_)
{}

const std::int32_t gameHighScore::ID;

void gameHighScore::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "gameHighScore");
    s.store_field("position", position_);
    s.store_field("user_id", user_id_);
    s.store_field("score", score_);
    s.store_class_end();
  }
}

gameHighScores::gameHighScores()
  : scores_()
{}

gameHighScores::gameHighScores(array<object_ptr<gameHighScore>> &&scores_)
  : scores_(std::move(scores_))
{}

const std::int32_t gameHighScores::ID;

void gameHighScores::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "gameHighScores");
    { s.store_vector_begin("scores", scores_.size()); for (const auto &_value : scores_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

gift::gift()
  : id_()
  , sticker_()
  , star_count_()
  , default_sell_star_count_()
  , upgrade_star_count_()
  , is_for_birthday_()
  , remaining_count_()
  , total_count_()
  , first_send_date_()
  , last_send_date_()
{}

gift::gift(int64 id_, object_ptr<sticker> &&sticker_, int53 star_count_, int53 default_sell_star_count_, int53 upgrade_star_count_, bool is_for_birthday_, int32 remaining_count_, int32 total_count_, int32 first_send_date_, int32 last_send_date_)
  : id_(id_)
  , sticker_(std::move(sticker_))
  , star_count_(star_count_)
  , default_sell_star_count_(default_sell_star_count_)
  , upgrade_star_count_(upgrade_star_count_)
  , is_for_birthday_(is_for_birthday_)
  , remaining_count_(remaining_count_)
  , total_count_(total_count_)
  , first_send_date_(first_send_date_)
  , last_send_date_(last_send_date_)
{}

const std::int32_t gift::ID;

void gift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "gift");
    s.store_field("id", id_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_field("star_count", star_count_);
    s.store_field("default_sell_star_count", default_sell_star_count_);
    s.store_field("upgrade_star_count", upgrade_star_count_);
    s.store_field("is_for_birthday", is_for_birthday_);
    s.store_field("remaining_count", remaining_count_);
    s.store_field("total_count", total_count_);
    s.store_field("first_send_date", first_send_date_);
    s.store_field("last_send_date", last_send_date_);
    s.store_class_end();
  }
}

giftUpgradePreview::giftUpgradePreview()
  : models_()
  , symbols_()
  , backdrops_()
{}

giftUpgradePreview::giftUpgradePreview(array<object_ptr<upgradedGiftModel>> &&models_, array<object_ptr<upgradedGiftSymbol>> &&symbols_, array<object_ptr<upgradedGiftBackdrop>> &&backdrops_)
  : models_(std::move(models_))
  , symbols_(std::move(symbols_))
  , backdrops_(std::move(backdrops_))
{}

const std::int32_t giftUpgradePreview::ID;

void giftUpgradePreview::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giftUpgradePreview");
    { s.store_vector_begin("models", models_.size()); for (const auto &_value : models_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("symbols", symbols_.size()); for (const auto &_value : symbols_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("backdrops", backdrops_.size()); for (const auto &_value : backdrops_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

gifts::gifts()
  : gifts_()
{}

gifts::gifts(array<object_ptr<gift>> &&gifts_)
  : gifts_(std::move(gifts_))
{}

const std::int32_t gifts::ID;

void gifts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "gifts");
    { s.store_vector_begin("gifts", gifts_.size()); for (const auto &_value : gifts_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

giveawayInfoOngoing::giveawayInfoOngoing()
  : creation_date_()
  , status_()
  , is_ended_()
{}

giveawayInfoOngoing::giveawayInfoOngoing(int32 creation_date_, object_ptr<GiveawayParticipantStatus> &&status_, bool is_ended_)
  : creation_date_(creation_date_)
  , status_(std::move(status_))
  , is_ended_(is_ended_)
{}

const std::int32_t giveawayInfoOngoing::ID;

void giveawayInfoOngoing::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giveawayInfoOngoing");
    s.store_field("creation_date", creation_date_);
    s.store_object_field("status", static_cast<const BaseObject *>(status_.get()));
    s.store_field("is_ended", is_ended_);
    s.store_class_end();
  }
}

giveawayInfoCompleted::giveawayInfoCompleted()
  : creation_date_()
  , actual_winners_selection_date_()
  , was_refunded_()
  , is_winner_()
  , winner_count_()
  , activation_count_()
  , gift_code_()
  , won_star_count_()
{}

giveawayInfoCompleted::giveawayInfoCompleted(int32 creation_date_, int32 actual_winners_selection_date_, bool was_refunded_, bool is_winner_, int32 winner_count_, int32 activation_count_, string const &gift_code_, int53 won_star_count_)
  : creation_date_(creation_date_)
  , actual_winners_selection_date_(actual_winners_selection_date_)
  , was_refunded_(was_refunded_)
  , is_winner_(is_winner_)
  , winner_count_(winner_count_)
  , activation_count_(activation_count_)
  , gift_code_(gift_code_)
  , won_star_count_(won_star_count_)
{}

const std::int32_t giveawayInfoCompleted::ID;

void giveawayInfoCompleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giveawayInfoCompleted");
    s.store_field("creation_date", creation_date_);
    s.store_field("actual_winners_selection_date", actual_winners_selection_date_);
    s.store_field("was_refunded", was_refunded_);
    s.store_field("is_winner", is_winner_);
    s.store_field("winner_count", winner_count_);
    s.store_field("activation_count", activation_count_);
    s.store_field("gift_code", gift_code_);
    s.store_field("won_star_count", won_star_count_);
    s.store_class_end();
  }
}

giveawayParameters::giveawayParameters()
  : boosted_chat_id_()
  , additional_chat_ids_()
  , winners_selection_date_()
  , only_new_members_()
  , has_public_winners_()
  , country_codes_()
  , prize_description_()
{}

giveawayParameters::giveawayParameters(int53 boosted_chat_id_, array<int53> &&additional_chat_ids_, int32 winners_selection_date_, bool only_new_members_, bool has_public_winners_, array<string> &&country_codes_, string const &prize_description_)
  : boosted_chat_id_(boosted_chat_id_)
  , additional_chat_ids_(std::move(additional_chat_ids_))
  , winners_selection_date_(winners_selection_date_)
  , only_new_members_(only_new_members_)
  , has_public_winners_(has_public_winners_)
  , country_codes_(std::move(country_codes_))
  , prize_description_(prize_description_)
{}

const std::int32_t giveawayParameters::ID;

void giveawayParameters::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giveawayParameters");
    s.store_field("boosted_chat_id", boosted_chat_id_);
    { s.store_vector_begin("additional_chat_ids", additional_chat_ids_.size()); for (const auto &_value : additional_chat_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("winners_selection_date", winners_selection_date_);
    s.store_field("only_new_members", only_new_members_);
    s.store_field("has_public_winners", has_public_winners_);
    { s.store_vector_begin("country_codes", country_codes_.size()); for (const auto &_value : country_codes_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("prize_description", prize_description_);
    s.store_class_end();
  }
}

giveawayParticipantStatusEligible::giveawayParticipantStatusEligible() {
}

const std::int32_t giveawayParticipantStatusEligible::ID;

void giveawayParticipantStatusEligible::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giveawayParticipantStatusEligible");
    s.store_class_end();
  }
}

giveawayParticipantStatusParticipating::giveawayParticipantStatusParticipating() {
}

const std::int32_t giveawayParticipantStatusParticipating::ID;

void giveawayParticipantStatusParticipating::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giveawayParticipantStatusParticipating");
    s.store_class_end();
  }
}

giveawayParticipantStatusAlreadyWasMember::giveawayParticipantStatusAlreadyWasMember()
  : joined_chat_date_()
{}

giveawayParticipantStatusAlreadyWasMember::giveawayParticipantStatusAlreadyWasMember(int32 joined_chat_date_)
  : joined_chat_date_(joined_chat_date_)
{}

const std::int32_t giveawayParticipantStatusAlreadyWasMember::ID;

void giveawayParticipantStatusAlreadyWasMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giveawayParticipantStatusAlreadyWasMember");
    s.store_field("joined_chat_date", joined_chat_date_);
    s.store_class_end();
  }
}

giveawayParticipantStatusAdministrator::giveawayParticipantStatusAdministrator()
  : chat_id_()
{}

giveawayParticipantStatusAdministrator::giveawayParticipantStatusAdministrator(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t giveawayParticipantStatusAdministrator::ID;

void giveawayParticipantStatusAdministrator::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giveawayParticipantStatusAdministrator");
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

giveawayParticipantStatusDisallowedCountry::giveawayParticipantStatusDisallowedCountry()
  : user_country_code_()
{}

giveawayParticipantStatusDisallowedCountry::giveawayParticipantStatusDisallowedCountry(string const &user_country_code_)
  : user_country_code_(user_country_code_)
{}

const std::int32_t giveawayParticipantStatusDisallowedCountry::ID;

void giveawayParticipantStatusDisallowedCountry::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giveawayParticipantStatusDisallowedCountry");
    s.store_field("user_country_code", user_country_code_);
    s.store_class_end();
  }
}

giveawayPrizePremium::giveawayPrizePremium()
  : month_count_()
{}

giveawayPrizePremium::giveawayPrizePremium(int32 month_count_)
  : month_count_(month_count_)
{}

const std::int32_t giveawayPrizePremium::ID;

void giveawayPrizePremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giveawayPrizePremium");
    s.store_field("month_count", month_count_);
    s.store_class_end();
  }
}

giveawayPrizeStars::giveawayPrizeStars()
  : star_count_()
{}

giveawayPrizeStars::giveawayPrizeStars(int53 star_count_)
  : star_count_(star_count_)
{}

const std::int32_t giveawayPrizeStars::ID;

void giveawayPrizeStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "giveawayPrizeStars");
    s.store_field("star_count", star_count_);
    s.store_class_end();
  }
}

groupCall::groupCall()
  : id_()
  , title_()
  , scheduled_start_date_()
  , enabled_start_notification_()
  , is_active_()
  , is_rtmp_stream_()
  , is_joined_()
  , need_rejoin_()
  , can_be_managed_()
  , participant_count_()
  , has_hidden_listeners_()
  , loaded_all_participants_()
  , recent_speakers_()
  , is_my_video_enabled_()
  , is_my_video_paused_()
  , can_enable_video_()
  , mute_new_participants_()
  , can_toggle_mute_new_participants_()
  , record_duration_()
  , is_video_recorded_()
  , duration_()
{}

groupCall::groupCall(int32 id_, string const &title_, int32 scheduled_start_date_, bool enabled_start_notification_, bool is_active_, bool is_rtmp_stream_, bool is_joined_, bool need_rejoin_, bool can_be_managed_, int32 participant_count_, bool has_hidden_listeners_, bool loaded_all_participants_, array<object_ptr<groupCallRecentSpeaker>> &&recent_speakers_, bool is_my_video_enabled_, bool is_my_video_paused_, bool can_enable_video_, bool mute_new_participants_, bool can_toggle_mute_new_participants_, int32 record_duration_, bool is_video_recorded_, int32 duration_)
  : id_(id_)
  , title_(title_)
  , scheduled_start_date_(scheduled_start_date_)
  , enabled_start_notification_(enabled_start_notification_)
  , is_active_(is_active_)
  , is_rtmp_stream_(is_rtmp_stream_)
  , is_joined_(is_joined_)
  , need_rejoin_(need_rejoin_)
  , can_be_managed_(can_be_managed_)
  , participant_count_(participant_count_)
  , has_hidden_listeners_(has_hidden_listeners_)
  , loaded_all_participants_(loaded_all_participants_)
  , recent_speakers_(std::move(recent_speakers_))
  , is_my_video_enabled_(is_my_video_enabled_)
  , is_my_video_paused_(is_my_video_paused_)
  , can_enable_video_(can_enable_video_)
  , mute_new_participants_(mute_new_participants_)
  , can_toggle_mute_new_participants_(can_toggle_mute_new_participants_)
  , record_duration_(record_duration_)
  , is_video_recorded_(is_video_recorded_)
  , duration_(duration_)
{}

const std::int32_t groupCall::ID;

void groupCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCall");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_field("scheduled_start_date", scheduled_start_date_);
    s.store_field("enabled_start_notification", enabled_start_notification_);
    s.store_field("is_active", is_active_);
    s.store_field("is_rtmp_stream", is_rtmp_stream_);
    s.store_field("is_joined", is_joined_);
    s.store_field("need_rejoin", need_rejoin_);
    s.store_field("can_be_managed", can_be_managed_);
    s.store_field("participant_count", participant_count_);
    s.store_field("has_hidden_listeners", has_hidden_listeners_);
    s.store_field("loaded_all_participants", loaded_all_participants_);
    { s.store_vector_begin("recent_speakers", recent_speakers_.size()); for (const auto &_value : recent_speakers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("is_my_video_enabled", is_my_video_enabled_);
    s.store_field("is_my_video_paused", is_my_video_paused_);
    s.store_field("can_enable_video", can_enable_video_);
    s.store_field("mute_new_participants", mute_new_participants_);
    s.store_field("can_toggle_mute_new_participants", can_toggle_mute_new_participants_);
    s.store_field("record_duration", record_duration_);
    s.store_field("is_video_recorded", is_video_recorded_);
    s.store_field("duration", duration_);
    s.store_class_end();
  }
}

groupCallId::groupCallId()
  : id_()
{}

groupCallId::groupCallId(int32 id_)
  : id_(id_)
{}

const std::int32_t groupCallId::ID;

void groupCallId::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallId");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

groupCallParticipant::groupCallParticipant()
  : participant_id_()
  , audio_source_id_()
  , screen_sharing_audio_source_id_()
  , video_info_()
  , screen_sharing_video_info_()
  , bio_()
  , is_current_user_()
  , is_speaking_()
  , is_hand_raised_()
  , can_be_muted_for_all_users_()
  , can_be_unmuted_for_all_users_()
  , can_be_muted_for_current_user_()
  , can_be_unmuted_for_current_user_()
  , is_muted_for_all_users_()
  , is_muted_for_current_user_()
  , can_unmute_self_()
  , volume_level_()
  , order_()
{}

groupCallParticipant::groupCallParticipant(object_ptr<MessageSender> &&participant_id_, int32 audio_source_id_, int32 screen_sharing_audio_source_id_, object_ptr<groupCallParticipantVideoInfo> &&video_info_, object_ptr<groupCallParticipantVideoInfo> &&screen_sharing_video_info_, string const &bio_, bool is_current_user_, bool is_speaking_, bool is_hand_raised_, bool can_be_muted_for_all_users_, bool can_be_unmuted_for_all_users_, bool can_be_muted_for_current_user_, bool can_be_unmuted_for_current_user_, bool is_muted_for_all_users_, bool is_muted_for_current_user_, bool can_unmute_self_, int32 volume_level_, string const &order_)
  : participant_id_(std::move(participant_id_))
  , audio_source_id_(audio_source_id_)
  , screen_sharing_audio_source_id_(screen_sharing_audio_source_id_)
  , video_info_(std::move(video_info_))
  , screen_sharing_video_info_(std::move(screen_sharing_video_info_))
  , bio_(bio_)
  , is_current_user_(is_current_user_)
  , is_speaking_(is_speaking_)
  , is_hand_raised_(is_hand_raised_)
  , can_be_muted_for_all_users_(can_be_muted_for_all_users_)
  , can_be_unmuted_for_all_users_(can_be_unmuted_for_all_users_)
  , can_be_muted_for_current_user_(can_be_muted_for_current_user_)
  , can_be_unmuted_for_current_user_(can_be_unmuted_for_current_user_)
  , is_muted_for_all_users_(is_muted_for_all_users_)
  , is_muted_for_current_user_(is_muted_for_current_user_)
  , can_unmute_self_(can_unmute_self_)
  , volume_level_(volume_level_)
  , order_(order_)
{}

const std::int32_t groupCallParticipant::ID;

void groupCallParticipant::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallParticipant");
    s.store_object_field("participant_id", static_cast<const BaseObject *>(participant_id_.get()));
    s.store_field("audio_source_id", audio_source_id_);
    s.store_field("screen_sharing_audio_source_id", screen_sharing_audio_source_id_);
    s.store_object_field("video_info", static_cast<const BaseObject *>(video_info_.get()));
    s.store_object_field("screen_sharing_video_info", static_cast<const BaseObject *>(screen_sharing_video_info_.get()));
    s.store_field("bio", bio_);
    s.store_field("is_current_user", is_current_user_);
    s.store_field("is_speaking", is_speaking_);
    s.store_field("is_hand_raised", is_hand_raised_);
    s.store_field("can_be_muted_for_all_users", can_be_muted_for_all_users_);
    s.store_field("can_be_unmuted_for_all_users", can_be_unmuted_for_all_users_);
    s.store_field("can_be_muted_for_current_user", can_be_muted_for_current_user_);
    s.store_field("can_be_unmuted_for_current_user", can_be_unmuted_for_current_user_);
    s.store_field("is_muted_for_all_users", is_muted_for_all_users_);
    s.store_field("is_muted_for_current_user", is_muted_for_current_user_);
    s.store_field("can_unmute_self", can_unmute_self_);
    s.store_field("volume_level", volume_level_);
    s.store_field("order", order_);
    s.store_class_end();
  }
}

groupCallParticipantVideoInfo::groupCallParticipantVideoInfo()
  : source_groups_()
  , endpoint_id_()
  , is_paused_()
{}

groupCallParticipantVideoInfo::groupCallParticipantVideoInfo(array<object_ptr<groupCallVideoSourceGroup>> &&source_groups_, string const &endpoint_id_, bool is_paused_)
  : source_groups_(std::move(source_groups_))
  , endpoint_id_(endpoint_id_)
  , is_paused_(is_paused_)
{}

const std::int32_t groupCallParticipantVideoInfo::ID;

void groupCallParticipantVideoInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallParticipantVideoInfo");
    { s.store_vector_begin("source_groups", source_groups_.size()); for (const auto &_value : source_groups_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("endpoint_id", endpoint_id_);
    s.store_field("is_paused", is_paused_);
    s.store_class_end();
  }
}

groupCallRecentSpeaker::groupCallRecentSpeaker()
  : participant_id_()
  , is_speaking_()
{}

groupCallRecentSpeaker::groupCallRecentSpeaker(object_ptr<MessageSender> &&participant_id_, bool is_speaking_)
  : participant_id_(std::move(participant_id_))
  , is_speaking_(is_speaking_)
{}

const std::int32_t groupCallRecentSpeaker::ID;

void groupCallRecentSpeaker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallRecentSpeaker");
    s.store_object_field("participant_id", static_cast<const BaseObject *>(participant_id_.get()));
    s.store_field("is_speaking", is_speaking_);
    s.store_class_end();
  }
}

groupCallStream::groupCallStream()
  : channel_id_()
  , scale_()
  , time_offset_()
{}

groupCallStream::groupCallStream(int32 channel_id_, int32 scale_, int53 time_offset_)
  : channel_id_(channel_id_)
  , scale_(scale_)
  , time_offset_(time_offset_)
{}

const std::int32_t groupCallStream::ID;

void groupCallStream::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallStream");
    s.store_field("channel_id", channel_id_);
    s.store_field("scale", scale_);
    s.store_field("time_offset", time_offset_);
    s.store_class_end();
  }
}

groupCallStreams::groupCallStreams()
  : streams_()
{}

groupCallStreams::groupCallStreams(array<object_ptr<groupCallStream>> &&streams_)
  : streams_(std::move(streams_))
{}

const std::int32_t groupCallStreams::ID;

void groupCallStreams::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallStreams");
    { s.store_vector_begin("streams", streams_.size()); for (const auto &_value : streams_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

groupCallVideoQualityThumbnail::groupCallVideoQualityThumbnail() {
}

const std::int32_t groupCallVideoQualityThumbnail::ID;

void groupCallVideoQualityThumbnail::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallVideoQualityThumbnail");
    s.store_class_end();
  }
}

groupCallVideoQualityMedium::groupCallVideoQualityMedium() {
}

const std::int32_t groupCallVideoQualityMedium::ID;

void groupCallVideoQualityMedium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallVideoQualityMedium");
    s.store_class_end();
  }
}

groupCallVideoQualityFull::groupCallVideoQualityFull() {
}

const std::int32_t groupCallVideoQualityFull::ID;

void groupCallVideoQualityFull::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallVideoQualityFull");
    s.store_class_end();
  }
}

groupCallVideoSourceGroup::groupCallVideoSourceGroup()
  : semantics_()
  , source_ids_()
{}

groupCallVideoSourceGroup::groupCallVideoSourceGroup(string const &semantics_, array<int32> &&source_ids_)
  : semantics_(semantics_)
  , source_ids_(std::move(source_ids_))
{}

const std::int32_t groupCallVideoSourceGroup::ID;

void groupCallVideoSourceGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "groupCallVideoSourceGroup");
    s.store_field("semantics", semantics_);
    { s.store_vector_begin("source_ids", source_ids_.size()); for (const auto &_value : source_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

hashtags::hashtags()
  : hashtags_()
{}

hashtags::hashtags(array<string> &&hashtags_)
  : hashtags_(std::move(hashtags_))
{}

const std::int32_t hashtags::ID;

void hashtags::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "hashtags");
    { s.store_vector_begin("hashtags", hashtags_.size()); for (const auto &_value : hashtags_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

httpUrl::httpUrl()
  : url_()
{}

httpUrl::httpUrl(string const &url_)
  : url_(url_)
{}

const std::int32_t httpUrl::ID;

void httpUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "httpUrl");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

identityDocument::identityDocument()
  : number_()
  , expiration_date_()
  , front_side_()
  , reverse_side_()
  , selfie_()
  , translation_()
{}

identityDocument::identityDocument(string const &number_, object_ptr<date> &&expiration_date_, object_ptr<datedFile> &&front_side_, object_ptr<datedFile> &&reverse_side_, object_ptr<datedFile> &&selfie_, array<object_ptr<datedFile>> &&translation_)
  : number_(number_)
  , expiration_date_(std::move(expiration_date_))
  , front_side_(std::move(front_side_))
  , reverse_side_(std::move(reverse_side_))
  , selfie_(std::move(selfie_))
  , translation_(std::move(translation_))
{}

const std::int32_t identityDocument::ID;

void identityDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "identityDocument");
    s.store_field("number", number_);
    s.store_object_field("expiration_date", static_cast<const BaseObject *>(expiration_date_.get()));
    s.store_object_field("front_side", static_cast<const BaseObject *>(front_side_.get()));
    s.store_object_field("reverse_side", static_cast<const BaseObject *>(reverse_side_.get()));
    s.store_object_field("selfie", static_cast<const BaseObject *>(selfie_.get()));
    { s.store_vector_begin("translation", translation_.size()); for (const auto &_value : translation_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

importedContacts::importedContacts()
  : user_ids_()
  , importer_count_()
{}

importedContacts::importedContacts(array<int53> &&user_ids_, array<int32> &&importer_count_)
  : user_ids_(std::move(user_ids_))
  , importer_count_(std::move(importer_count_))
{}

const std::int32_t importedContacts::ID;

void importedContacts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "importedContacts");
    { s.store_vector_begin("user_ids", user_ids_.size()); for (const auto &_value : user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("importer_count", importer_count_.size()); for (const auto &_value : importer_count_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

inlineKeyboardButton::inlineKeyboardButton()
  : text_()
  , type_()
{}

inlineKeyboardButton::inlineKeyboardButton(string const &text_, object_ptr<InlineKeyboardButtonType> &&type_)
  : text_(text_)
  , type_(std::move(type_))
{}

const std::int32_t inlineKeyboardButton::ID;

void inlineKeyboardButton::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButton");
    s.store_field("text", text_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

inlineKeyboardButtonTypeUrl::inlineKeyboardButtonTypeUrl()
  : url_()
{}

inlineKeyboardButtonTypeUrl::inlineKeyboardButtonTypeUrl(string const &url_)
  : url_(url_)
{}

const std::int32_t inlineKeyboardButtonTypeUrl::ID;

void inlineKeyboardButtonTypeUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButtonTypeUrl");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

inlineKeyboardButtonTypeLoginUrl::inlineKeyboardButtonTypeLoginUrl()
  : url_()
  , id_()
  , forward_text_()
{}

inlineKeyboardButtonTypeLoginUrl::inlineKeyboardButtonTypeLoginUrl(string const &url_, int53 id_, string const &forward_text_)
  : url_(url_)
  , id_(id_)
  , forward_text_(forward_text_)
{}

const std::int32_t inlineKeyboardButtonTypeLoginUrl::ID;

void inlineKeyboardButtonTypeLoginUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButtonTypeLoginUrl");
    s.store_field("url", url_);
    s.store_field("id", id_);
    s.store_field("forward_text", forward_text_);
    s.store_class_end();
  }
}

inlineKeyboardButtonTypeWebApp::inlineKeyboardButtonTypeWebApp()
  : url_()
{}

inlineKeyboardButtonTypeWebApp::inlineKeyboardButtonTypeWebApp(string const &url_)
  : url_(url_)
{}

const std::int32_t inlineKeyboardButtonTypeWebApp::ID;

void inlineKeyboardButtonTypeWebApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButtonTypeWebApp");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

inlineKeyboardButtonTypeCallback::inlineKeyboardButtonTypeCallback()
  : data_()
{}

inlineKeyboardButtonTypeCallback::inlineKeyboardButtonTypeCallback(bytes const &data_)
  : data_(std::move(data_))
{}

const std::int32_t inlineKeyboardButtonTypeCallback::ID;

void inlineKeyboardButtonTypeCallback::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButtonTypeCallback");
    s.store_bytes_field("data", data_);
    s.store_class_end();
  }
}

inlineKeyboardButtonTypeCallbackWithPassword::inlineKeyboardButtonTypeCallbackWithPassword()
  : data_()
{}

inlineKeyboardButtonTypeCallbackWithPassword::inlineKeyboardButtonTypeCallbackWithPassword(bytes const &data_)
  : data_(std::move(data_))
{}

const std::int32_t inlineKeyboardButtonTypeCallbackWithPassword::ID;

void inlineKeyboardButtonTypeCallbackWithPassword::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButtonTypeCallbackWithPassword");
    s.store_bytes_field("data", data_);
    s.store_class_end();
  }
}

inlineKeyboardButtonTypeCallbackGame::inlineKeyboardButtonTypeCallbackGame() {
}

const std::int32_t inlineKeyboardButtonTypeCallbackGame::ID;

void inlineKeyboardButtonTypeCallbackGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButtonTypeCallbackGame");
    s.store_class_end();
  }
}

inlineKeyboardButtonTypeSwitchInline::inlineKeyboardButtonTypeSwitchInline()
  : query_()
  , target_chat_()
{}

inlineKeyboardButtonTypeSwitchInline::inlineKeyboardButtonTypeSwitchInline(string const &query_, object_ptr<TargetChat> &&target_chat_)
  : query_(query_)
  , target_chat_(std::move(target_chat_))
{}

const std::int32_t inlineKeyboardButtonTypeSwitchInline::ID;

void inlineKeyboardButtonTypeSwitchInline::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButtonTypeSwitchInline");
    s.store_field("query", query_);
    s.store_object_field("target_chat", static_cast<const BaseObject *>(target_chat_.get()));
    s.store_class_end();
  }
}

inlineKeyboardButtonTypeBuy::inlineKeyboardButtonTypeBuy() {
}

const std::int32_t inlineKeyboardButtonTypeBuy::ID;

void inlineKeyboardButtonTypeBuy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButtonTypeBuy");
    s.store_class_end();
  }
}

inlineKeyboardButtonTypeUser::inlineKeyboardButtonTypeUser()
  : user_id_()
{}

inlineKeyboardButtonTypeUser::inlineKeyboardButtonTypeUser(int53 user_id_)
  : user_id_(user_id_)
{}

const std::int32_t inlineKeyboardButtonTypeUser::ID;

void inlineKeyboardButtonTypeUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButtonTypeUser");
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

inlineKeyboardButtonTypeCopyText::inlineKeyboardButtonTypeCopyText()
  : text_()
{}

inlineKeyboardButtonTypeCopyText::inlineKeyboardButtonTypeCopyText(string const &text_)
  : text_(text_)
{}

const std::int32_t inlineKeyboardButtonTypeCopyText::ID;

void inlineKeyboardButtonTypeCopyText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineKeyboardButtonTypeCopyText");
    s.store_field("text", text_);
    s.store_class_end();
  }
}

inlineQueryResultArticle::inlineQueryResultArticle()
  : id_()
  , url_()
  , title_()
  , description_()
  , thumbnail_()
{}

inlineQueryResultArticle::inlineQueryResultArticle(string const &id_, string const &url_, string const &title_, string const &description_, object_ptr<thumbnail> &&thumbnail_)
  : id_(id_)
  , url_(url_)
  , title_(title_)
  , description_(description_)
  , thumbnail_(std::move(thumbnail_))
{}

const std::int32_t inlineQueryResultArticle::ID;

void inlineQueryResultArticle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultArticle");
    s.store_field("id", id_);
    s.store_field("url", url_);
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_class_end();
  }
}

inlineQueryResultContact::inlineQueryResultContact()
  : id_()
  , contact_()
  , thumbnail_()
{}

inlineQueryResultContact::inlineQueryResultContact(string const &id_, object_ptr<contact> &&contact_, object_ptr<thumbnail> &&thumbnail_)
  : id_(id_)
  , contact_(std::move(contact_))
  , thumbnail_(std::move(thumbnail_))
{}

const std::int32_t inlineQueryResultContact::ID;

void inlineQueryResultContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultContact");
    s.store_field("id", id_);
    s.store_object_field("contact", static_cast<const BaseObject *>(contact_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_class_end();
  }
}

inlineQueryResultLocation::inlineQueryResultLocation()
  : id_()
  , location_()
  , title_()
  , thumbnail_()
{}

inlineQueryResultLocation::inlineQueryResultLocation(string const &id_, object_ptr<location> &&location_, string const &title_, object_ptr<thumbnail> &&thumbnail_)
  : id_(id_)
  , location_(std::move(location_))
  , title_(title_)
  , thumbnail_(std::move(thumbnail_))
{}

const std::int32_t inlineQueryResultLocation::ID;

void inlineQueryResultLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultLocation");
    s.store_field("id", id_);
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_field("title", title_);
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_class_end();
  }
}

inlineQueryResultVenue::inlineQueryResultVenue()
  : id_()
  , venue_()
  , thumbnail_()
{}

inlineQueryResultVenue::inlineQueryResultVenue(string const &id_, object_ptr<venue> &&venue_, object_ptr<thumbnail> &&thumbnail_)
  : id_(id_)
  , venue_(std::move(venue_))
  , thumbnail_(std::move(thumbnail_))
{}

const std::int32_t inlineQueryResultVenue::ID;

void inlineQueryResultVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultVenue");
    s.store_field("id", id_);
    s.store_object_field("venue", static_cast<const BaseObject *>(venue_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_class_end();
  }
}

inlineQueryResultGame::inlineQueryResultGame()
  : id_()
  , game_()
{}

inlineQueryResultGame::inlineQueryResultGame(string const &id_, object_ptr<game> &&game_)
  : id_(id_)
  , game_(std::move(game_))
{}

const std::int32_t inlineQueryResultGame::ID;

void inlineQueryResultGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultGame");
    s.store_field("id", id_);
    s.store_object_field("game", static_cast<const BaseObject *>(game_.get()));
    s.store_class_end();
  }
}

inlineQueryResultAnimation::inlineQueryResultAnimation()
  : id_()
  , animation_()
  , title_()
{}

inlineQueryResultAnimation::inlineQueryResultAnimation(string const &id_, object_ptr<animation> &&animation_, string const &title_)
  : id_(id_)
  , animation_(std::move(animation_))
  , title_(title_)
{}

const std::int32_t inlineQueryResultAnimation::ID;

void inlineQueryResultAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultAnimation");
    s.store_field("id", id_);
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_field("title", title_);
    s.store_class_end();
  }
}

inlineQueryResultAudio::inlineQueryResultAudio()
  : id_()
  , audio_()
{}

inlineQueryResultAudio::inlineQueryResultAudio(string const &id_, object_ptr<audio> &&audio_)
  : id_(id_)
  , audio_(std::move(audio_))
{}

const std::int32_t inlineQueryResultAudio::ID;

void inlineQueryResultAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultAudio");
    s.store_field("id", id_);
    s.store_object_field("audio", static_cast<const BaseObject *>(audio_.get()));
    s.store_class_end();
  }
}

inlineQueryResultDocument::inlineQueryResultDocument()
  : id_()
  , document_()
  , title_()
  , description_()
{}

inlineQueryResultDocument::inlineQueryResultDocument(string const &id_, object_ptr<document> &&document_, string const &title_, string const &description_)
  : id_(id_)
  , document_(std::move(document_))
  , title_(title_)
  , description_(description_)
{}

const std::int32_t inlineQueryResultDocument::ID;

void inlineQueryResultDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultDocument");
    s.store_field("id", id_);
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_class_end();
  }
}

inlineQueryResultPhoto::inlineQueryResultPhoto()
  : id_()
  , photo_()
  , title_()
  , description_()
{}

inlineQueryResultPhoto::inlineQueryResultPhoto(string const &id_, object_ptr<photo> &&photo_, string const &title_, string const &description_)
  : id_(id_)
  , photo_(std::move(photo_))
  , title_(title_)
  , description_(description_)
{}

const std::int32_t inlineQueryResultPhoto::ID;

void inlineQueryResultPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultPhoto");
    s.store_field("id", id_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_class_end();
  }
}

inlineQueryResultSticker::inlineQueryResultSticker()
  : id_()
  , sticker_()
{}

inlineQueryResultSticker::inlineQueryResultSticker(string const &id_, object_ptr<sticker> &&sticker_)
  : id_(id_)
  , sticker_(std::move(sticker_))
{}

const std::int32_t inlineQueryResultSticker::ID;

void inlineQueryResultSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultSticker");
    s.store_field("id", id_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

inlineQueryResultVideo::inlineQueryResultVideo()
  : id_()
  , video_()
  , title_()
  , description_()
{}

inlineQueryResultVideo::inlineQueryResultVideo(string const &id_, object_ptr<video> &&video_, string const &title_, string const &description_)
  : id_(id_)
  , video_(std::move(video_))
  , title_(title_)
  , description_(description_)
{}

const std::int32_t inlineQueryResultVideo::ID;

void inlineQueryResultVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultVideo");
    s.store_field("id", id_);
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_class_end();
  }
}

inlineQueryResultVoiceNote::inlineQueryResultVoiceNote()
  : id_()
  , voice_note_()
  , title_()
{}

inlineQueryResultVoiceNote::inlineQueryResultVoiceNote(string const &id_, object_ptr<voiceNote> &&voice_note_, string const &title_)
  : id_(id_)
  , voice_note_(std::move(voice_note_))
  , title_(title_)
{}

const std::int32_t inlineQueryResultVoiceNote::ID;

void inlineQueryResultVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultVoiceNote");
    s.store_field("id", id_);
    s.store_object_field("voice_note", static_cast<const BaseObject *>(voice_note_.get()));
    s.store_field("title", title_);
    s.store_class_end();
  }
}

inlineQueryResults::inlineQueryResults()
  : inline_query_id_()
  , button_()
  , results_()
  , next_offset_()
{}

inlineQueryResults::inlineQueryResults(int64 inline_query_id_, object_ptr<inlineQueryResultsButton> &&button_, array<object_ptr<InlineQueryResult>> &&results_, string const &next_offset_)
  : inline_query_id_(inline_query_id_)
  , button_(std::move(button_))
  , results_(std::move(results_))
  , next_offset_(next_offset_)
{}

const std::int32_t inlineQueryResults::ID;

void inlineQueryResults::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResults");
    s.store_field("inline_query_id", inline_query_id_);
    s.store_object_field("button", static_cast<const BaseObject *>(button_.get()));
    { s.store_vector_begin("results", results_.size()); for (const auto &_value : results_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

inlineQueryResultsButton::inlineQueryResultsButton()
  : text_()
  , type_()
{}

inlineQueryResultsButton::inlineQueryResultsButton(string const &text_, object_ptr<InlineQueryResultsButtonType> &&type_)
  : text_(text_)
  , type_(std::move(type_))
{}

const std::int32_t inlineQueryResultsButton::ID;

void inlineQueryResultsButton::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultsButton");
    s.store_field("text", text_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

inlineQueryResultsButtonTypeStartBot::inlineQueryResultsButtonTypeStartBot()
  : parameter_()
{}

inlineQueryResultsButtonTypeStartBot::inlineQueryResultsButtonTypeStartBot(string const &parameter_)
  : parameter_(parameter_)
{}

const std::int32_t inlineQueryResultsButtonTypeStartBot::ID;

void inlineQueryResultsButtonTypeStartBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultsButtonTypeStartBot");
    s.store_field("parameter", parameter_);
    s.store_class_end();
  }
}

inlineQueryResultsButtonTypeWebApp::inlineQueryResultsButtonTypeWebApp()
  : url_()
{}

inlineQueryResultsButtonTypeWebApp::inlineQueryResultsButtonTypeWebApp(string const &url_)
  : url_(url_)
{}

const std::int32_t inlineQueryResultsButtonTypeWebApp::ID;

void inlineQueryResultsButtonTypeWebApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inlineQueryResultsButtonTypeWebApp");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

inputBackgroundLocal::inputBackgroundLocal()
  : background_()
{}

inputBackgroundLocal::inputBackgroundLocal(object_ptr<InputFile> &&background_)
  : background_(std::move(background_))
{}

const std::int32_t inputBackgroundLocal::ID;

void inputBackgroundLocal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBackgroundLocal");
    s.store_object_field("background", static_cast<const BaseObject *>(background_.get()));
    s.store_class_end();
  }
}

inputBackgroundRemote::inputBackgroundRemote()
  : background_id_()
{}

inputBackgroundRemote::inputBackgroundRemote(int64 background_id_)
  : background_id_(background_id_)
{}

const std::int32_t inputBackgroundRemote::ID;

void inputBackgroundRemote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBackgroundRemote");
    s.store_field("background_id", background_id_);
    s.store_class_end();
  }
}

inputBackgroundPrevious::inputBackgroundPrevious()
  : message_id_()
{}

inputBackgroundPrevious::inputBackgroundPrevious(int53 message_id_)
  : message_id_(message_id_)
{}

const std::int32_t inputBackgroundPrevious::ID;

void inputBackgroundPrevious::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBackgroundPrevious");
    s.store_field("message_id", message_id_);
    s.store_class_end();
  }
}

inputBusinessChatLink::inputBusinessChatLink()
  : text_()
  , title_()
{}

inputBusinessChatLink::inputBusinessChatLink(object_ptr<formattedText> &&text_, string const &title_)
  : text_(std::move(text_))
  , title_(title_)
{}

const std::int32_t inputBusinessChatLink::ID;

void inputBusinessChatLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBusinessChatLink");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("title", title_);
    s.store_class_end();
  }
}

inputBusinessStartPage::inputBusinessStartPage()
  : title_()
  , message_()
  , sticker_()
{}

inputBusinessStartPage::inputBusinessStartPage(string const &title_, string const &message_, object_ptr<InputFile> &&sticker_)
  : title_(title_)
  , message_(message_)
  , sticker_(std::move(sticker_))
{}

const std::int32_t inputBusinessStartPage::ID;

void inputBusinessStartPage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputBusinessStartPage");
    s.store_field("title", title_);
    s.store_field("message", message_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

inputChatPhotoPrevious::inputChatPhotoPrevious()
  : chat_photo_id_()
{}

inputChatPhotoPrevious::inputChatPhotoPrevious(int64 chat_photo_id_)
  : chat_photo_id_(chat_photo_id_)
{}

const std::int32_t inputChatPhotoPrevious::ID;

void inputChatPhotoPrevious::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChatPhotoPrevious");
    s.store_field("chat_photo_id", chat_photo_id_);
    s.store_class_end();
  }
}

inputChatPhotoStatic::inputChatPhotoStatic()
  : photo_()
{}

inputChatPhotoStatic::inputChatPhotoStatic(object_ptr<InputFile> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t inputChatPhotoStatic::ID;

void inputChatPhotoStatic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChatPhotoStatic");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

inputChatPhotoAnimation::inputChatPhotoAnimation()
  : animation_()
  , main_frame_timestamp_()
{}

inputChatPhotoAnimation::inputChatPhotoAnimation(object_ptr<InputFile> &&animation_, double main_frame_timestamp_)
  : animation_(std::move(animation_))
  , main_frame_timestamp_(main_frame_timestamp_)
{}

const std::int32_t inputChatPhotoAnimation::ID;

void inputChatPhotoAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChatPhotoAnimation");
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_field("main_frame_timestamp", main_frame_timestamp_);
    s.store_class_end();
  }
}

inputChatPhotoSticker::inputChatPhotoSticker()
  : sticker_()
{}

inputChatPhotoSticker::inputChatPhotoSticker(object_ptr<chatPhotoSticker> &&sticker_)
  : sticker_(std::move(sticker_))
{}

const std::int32_t inputChatPhotoSticker::ID;

void inputChatPhotoSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputChatPhotoSticker");
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

inputCredentialsSaved::inputCredentialsSaved()
  : saved_credentials_id_()
{}

inputCredentialsSaved::inputCredentialsSaved(string const &saved_credentials_id_)
  : saved_credentials_id_(saved_credentials_id_)
{}

const std::int32_t inputCredentialsSaved::ID;

void inputCredentialsSaved::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputCredentialsSaved");
    s.store_field("saved_credentials_id", saved_credentials_id_);
    s.store_class_end();
  }
}

inputCredentialsNew::inputCredentialsNew()
  : data_()
  , allow_save_()
{}

inputCredentialsNew::inputCredentialsNew(string const &data_, bool allow_save_)
  : data_(data_)
  , allow_save_(allow_save_)
{}

const std::int32_t inputCredentialsNew::ID;

void inputCredentialsNew::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputCredentialsNew");
    s.store_field("data", data_);
    s.store_field("allow_save", allow_save_);
    s.store_class_end();
  }
}

inputCredentialsApplePay::inputCredentialsApplePay()
  : data_()
{}

inputCredentialsApplePay::inputCredentialsApplePay(string const &data_)
  : data_(data_)
{}

const std::int32_t inputCredentialsApplePay::ID;

void inputCredentialsApplePay::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputCredentialsApplePay");
    s.store_field("data", data_);
    s.store_class_end();
  }
}

inputCredentialsGooglePay::inputCredentialsGooglePay()
  : data_()
{}

inputCredentialsGooglePay::inputCredentialsGooglePay(string const &data_)
  : data_(data_)
{}

const std::int32_t inputCredentialsGooglePay::ID;

void inputCredentialsGooglePay::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputCredentialsGooglePay");
    s.store_field("data", data_);
    s.store_class_end();
  }
}

inputFileId::inputFileId()
  : id_()
{}

inputFileId::inputFileId(int32 id_)
  : id_(id_)
{}

const std::int32_t inputFileId::ID;

void inputFileId::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputFileId");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

inputFileRemote::inputFileRemote()
  : id_()
{}

inputFileRemote::inputFileRemote(string const &id_)
  : id_(id_)
{}

const std::int32_t inputFileRemote::ID;

void inputFileRemote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputFileRemote");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

inputFileLocal::inputFileLocal()
  : path_()
{}

inputFileLocal::inputFileLocal(string const &path_)
  : path_(path_)
{}

const std::int32_t inputFileLocal::ID;

void inputFileLocal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputFileLocal");
    s.store_field("path", path_);
    s.store_class_end();
  }
}

inputFileGenerated::inputFileGenerated()
  : original_path_()
  , conversion_()
  , expected_size_()
{}

inputFileGenerated::inputFileGenerated(string const &original_path_, string const &conversion_, int53 expected_size_)
  : original_path_(original_path_)
  , conversion_(conversion_)
  , expected_size_(expected_size_)
{}

const std::int32_t inputFileGenerated::ID;

void inputFileGenerated::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputFileGenerated");
    s.store_field("original_path", original_path_);
    s.store_field("conversion", conversion_);
    s.store_field("expected_size", expected_size_);
    s.store_class_end();
  }
}

inputIdentityDocument::inputIdentityDocument()
  : number_()
  , expiration_date_()
  , front_side_()
  , reverse_side_()
  , selfie_()
  , translation_()
{}

inputIdentityDocument::inputIdentityDocument(string const &number_, object_ptr<date> &&expiration_date_, object_ptr<InputFile> &&front_side_, object_ptr<InputFile> &&reverse_side_, object_ptr<InputFile> &&selfie_, array<object_ptr<InputFile>> &&translation_)
  : number_(number_)
  , expiration_date_(std::move(expiration_date_))
  , front_side_(std::move(front_side_))
  , reverse_side_(std::move(reverse_side_))
  , selfie_(std::move(selfie_))
  , translation_(std::move(translation_))
{}

const std::int32_t inputIdentityDocument::ID;

void inputIdentityDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputIdentityDocument");
    s.store_field("number", number_);
    s.store_object_field("expiration_date", static_cast<const BaseObject *>(expiration_date_.get()));
    s.store_object_field("front_side", static_cast<const BaseObject *>(front_side_.get()));
    s.store_object_field("reverse_side", static_cast<const BaseObject *>(reverse_side_.get()));
    s.store_object_field("selfie", static_cast<const BaseObject *>(selfie_.get()));
    { s.store_vector_begin("translation", translation_.size()); for (const auto &_value : translation_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

inputInlineQueryResultAnimation::inputInlineQueryResultAnimation()
  : id_()
  , title_()
  , thumbnail_url_()
  , thumbnail_mime_type_()
  , video_url_()
  , video_mime_type_()
  , video_duration_()
  , video_width_()
  , video_height_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultAnimation::inputInlineQueryResultAnimation(string const &id_, string const &title_, string const &thumbnail_url_, string const &thumbnail_mime_type_, string const &video_url_, string const &video_mime_type_, int32 video_duration_, int32 video_width_, int32 video_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , title_(title_)
  , thumbnail_url_(thumbnail_url_)
  , thumbnail_mime_type_(thumbnail_mime_type_)
  , video_url_(video_url_)
  , video_mime_type_(video_mime_type_)
  , video_duration_(video_duration_)
  , video_width_(video_width_)
  , video_height_(video_height_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultAnimation::ID;

void inputInlineQueryResultAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultAnimation");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_field("thumbnail_url", thumbnail_url_);
    s.store_field("thumbnail_mime_type", thumbnail_mime_type_);
    s.store_field("video_url", video_url_);
    s.store_field("video_mime_type", video_mime_type_);
    s.store_field("video_duration", video_duration_);
    s.store_field("video_width", video_width_);
    s.store_field("video_height", video_height_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultArticle::inputInlineQueryResultArticle()
  : id_()
  , url_()
  , title_()
  , description_()
  , thumbnail_url_()
  , thumbnail_width_()
  , thumbnail_height_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultArticle::inputInlineQueryResultArticle(string const &id_, string const &url_, string const &title_, string const &description_, string const &thumbnail_url_, int32 thumbnail_width_, int32 thumbnail_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , url_(url_)
  , title_(title_)
  , description_(description_)
  , thumbnail_url_(thumbnail_url_)
  , thumbnail_width_(thumbnail_width_)
  , thumbnail_height_(thumbnail_height_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultArticle::ID;

void inputInlineQueryResultArticle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultArticle");
    s.store_field("id", id_);
    s.store_field("url", url_);
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_field("thumbnail_url", thumbnail_url_);
    s.store_field("thumbnail_width", thumbnail_width_);
    s.store_field("thumbnail_height", thumbnail_height_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultAudio::inputInlineQueryResultAudio()
  : id_()
  , title_()
  , performer_()
  , audio_url_()
  , audio_duration_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultAudio::inputInlineQueryResultAudio(string const &id_, string const &title_, string const &performer_, string const &audio_url_, int32 audio_duration_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , title_(title_)
  , performer_(performer_)
  , audio_url_(audio_url_)
  , audio_duration_(audio_duration_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultAudio::ID;

void inputInlineQueryResultAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultAudio");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_field("performer", performer_);
    s.store_field("audio_url", audio_url_);
    s.store_field("audio_duration", audio_duration_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultContact::inputInlineQueryResultContact()
  : id_()
  , contact_()
  , thumbnail_url_()
  , thumbnail_width_()
  , thumbnail_height_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultContact::inputInlineQueryResultContact(string const &id_, object_ptr<contact> &&contact_, string const &thumbnail_url_, int32 thumbnail_width_, int32 thumbnail_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , contact_(std::move(contact_))
  , thumbnail_url_(thumbnail_url_)
  , thumbnail_width_(thumbnail_width_)
  , thumbnail_height_(thumbnail_height_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultContact::ID;

void inputInlineQueryResultContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultContact");
    s.store_field("id", id_);
    s.store_object_field("contact", static_cast<const BaseObject *>(contact_.get()));
    s.store_field("thumbnail_url", thumbnail_url_);
    s.store_field("thumbnail_width", thumbnail_width_);
    s.store_field("thumbnail_height", thumbnail_height_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultDocument::inputInlineQueryResultDocument()
  : id_()
  , title_()
  , description_()
  , document_url_()
  , mime_type_()
  , thumbnail_url_()
  , thumbnail_width_()
  , thumbnail_height_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultDocument::inputInlineQueryResultDocument(string const &id_, string const &title_, string const &description_, string const &document_url_, string const &mime_type_, string const &thumbnail_url_, int32 thumbnail_width_, int32 thumbnail_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , title_(title_)
  , description_(description_)
  , document_url_(document_url_)
  , mime_type_(mime_type_)
  , thumbnail_url_(thumbnail_url_)
  , thumbnail_width_(thumbnail_width_)
  , thumbnail_height_(thumbnail_height_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultDocument::ID;

void inputInlineQueryResultDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultDocument");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_field("document_url", document_url_);
    s.store_field("mime_type", mime_type_);
    s.store_field("thumbnail_url", thumbnail_url_);
    s.store_field("thumbnail_width", thumbnail_width_);
    s.store_field("thumbnail_height", thumbnail_height_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultGame::inputInlineQueryResultGame()
  : id_()
  , game_short_name_()
  , reply_markup_()
{}

inputInlineQueryResultGame::inputInlineQueryResultGame(string const &id_, string const &game_short_name_, object_ptr<ReplyMarkup> &&reply_markup_)
  : id_(id_)
  , game_short_name_(game_short_name_)
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t inputInlineQueryResultGame::ID;

void inputInlineQueryResultGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultGame");
    s.store_field("id", id_);
    s.store_field("game_short_name", game_short_name_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultLocation::inputInlineQueryResultLocation()
  : id_()
  , location_()
  , live_period_()
  , title_()
  , thumbnail_url_()
  , thumbnail_width_()
  , thumbnail_height_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultLocation::inputInlineQueryResultLocation(string const &id_, object_ptr<location> &&location_, int32 live_period_, string const &title_, string const &thumbnail_url_, int32 thumbnail_width_, int32 thumbnail_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , location_(std::move(location_))
  , live_period_(live_period_)
  , title_(title_)
  , thumbnail_url_(thumbnail_url_)
  , thumbnail_width_(thumbnail_width_)
  , thumbnail_height_(thumbnail_height_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultLocation::ID;

void inputInlineQueryResultLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultLocation");
    s.store_field("id", id_);
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_field("live_period", live_period_);
    s.store_field("title", title_);
    s.store_field("thumbnail_url", thumbnail_url_);
    s.store_field("thumbnail_width", thumbnail_width_);
    s.store_field("thumbnail_height", thumbnail_height_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultPhoto::inputInlineQueryResultPhoto()
  : id_()
  , title_()
  , description_()
  , thumbnail_url_()
  , photo_url_()
  , photo_width_()
  , photo_height_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultPhoto::inputInlineQueryResultPhoto(string const &id_, string const &title_, string const &description_, string const &thumbnail_url_, string const &photo_url_, int32 photo_width_, int32 photo_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , title_(title_)
  , description_(description_)
  , thumbnail_url_(thumbnail_url_)
  , photo_url_(photo_url_)
  , photo_width_(photo_width_)
  , photo_height_(photo_height_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultPhoto::ID;

void inputInlineQueryResultPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultPhoto");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_field("thumbnail_url", thumbnail_url_);
    s.store_field("photo_url", photo_url_);
    s.store_field("photo_width", photo_width_);
    s.store_field("photo_height", photo_height_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultSticker::inputInlineQueryResultSticker()
  : id_()
  , thumbnail_url_()
  , sticker_url_()
  , sticker_width_()
  , sticker_height_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultSticker::inputInlineQueryResultSticker(string const &id_, string const &thumbnail_url_, string const &sticker_url_, int32 sticker_width_, int32 sticker_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , thumbnail_url_(thumbnail_url_)
  , sticker_url_(sticker_url_)
  , sticker_width_(sticker_width_)
  , sticker_height_(sticker_height_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultSticker::ID;

void inputInlineQueryResultSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultSticker");
    s.store_field("id", id_);
    s.store_field("thumbnail_url", thumbnail_url_);
    s.store_field("sticker_url", sticker_url_);
    s.store_field("sticker_width", sticker_width_);
    s.store_field("sticker_height", sticker_height_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultVenue::inputInlineQueryResultVenue()
  : id_()
  , venue_()
  , thumbnail_url_()
  , thumbnail_width_()
  , thumbnail_height_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultVenue::inputInlineQueryResultVenue(string const &id_, object_ptr<venue> &&venue_, string const &thumbnail_url_, int32 thumbnail_width_, int32 thumbnail_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , venue_(std::move(venue_))
  , thumbnail_url_(thumbnail_url_)
  , thumbnail_width_(thumbnail_width_)
  , thumbnail_height_(thumbnail_height_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultVenue::ID;

void inputInlineQueryResultVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultVenue");
    s.store_field("id", id_);
    s.store_object_field("venue", static_cast<const BaseObject *>(venue_.get()));
    s.store_field("thumbnail_url", thumbnail_url_);
    s.store_field("thumbnail_width", thumbnail_width_);
    s.store_field("thumbnail_height", thumbnail_height_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultVideo::inputInlineQueryResultVideo()
  : id_()
  , title_()
  , description_()
  , thumbnail_url_()
  , video_url_()
  , mime_type_()
  , video_width_()
  , video_height_()
  , video_duration_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultVideo::inputInlineQueryResultVideo(string const &id_, string const &title_, string const &description_, string const &thumbnail_url_, string const &video_url_, string const &mime_type_, int32 video_width_, int32 video_height_, int32 video_duration_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , title_(title_)
  , description_(description_)
  , thumbnail_url_(thumbnail_url_)
  , video_url_(video_url_)
  , mime_type_(mime_type_)
  , video_width_(video_width_)
  , video_height_(video_height_)
  , video_duration_(video_duration_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultVideo::ID;

void inputInlineQueryResultVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultVideo");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_field("thumbnail_url", thumbnail_url_);
    s.store_field("video_url", video_url_);
    s.store_field("mime_type", mime_type_);
    s.store_field("video_width", video_width_);
    s.store_field("video_height", video_height_);
    s.store_field("video_duration", video_duration_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInlineQueryResultVoiceNote::inputInlineQueryResultVoiceNote()
  : id_()
  , title_()
  , voice_note_url_()
  , voice_note_duration_()
  , reply_markup_()
  , input_message_content_()
{}

inputInlineQueryResultVoiceNote::inputInlineQueryResultVoiceNote(string const &id_, string const &title_, string const &voice_note_url_, int32 voice_note_duration_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_)
  : id_(id_)
  , title_(title_)
  , voice_note_url_(voice_note_url_)
  , voice_note_duration_(voice_note_duration_)
  , reply_markup_(std::move(reply_markup_))
  , input_message_content_(std::move(input_message_content_))
{}

const std::int32_t inputInlineQueryResultVoiceNote::ID;

void inputInlineQueryResultVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInlineQueryResultVoiceNote");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_field("voice_note_url", voice_note_url_);
    s.store_field("voice_note_duration", voice_note_duration_);
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_object_field("input_message_content", static_cast<const BaseObject *>(input_message_content_.get()));
    s.store_class_end();
  }
}

inputInvoiceMessage::inputInvoiceMessage()
  : chat_id_()
  , message_id_()
{}

inputInvoiceMessage::inputInvoiceMessage(int53 chat_id_, int53 message_id_)
  : chat_id_(chat_id_)
  , message_id_(message_id_)
{}

const std::int32_t inputInvoiceMessage::ID;

void inputInvoiceMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceMessage");
    s.store_field("chat_id", chat_id_);
    s.store_field("message_id", message_id_);
    s.store_class_end();
  }
}

inputInvoiceName::inputInvoiceName()
  : name_()
{}

inputInvoiceName::inputInvoiceName(string const &name_)
  : name_(name_)
{}

const std::int32_t inputInvoiceName::ID;

void inputInvoiceName::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceName");
    s.store_field("name", name_);
    s.store_class_end();
  }
}

inputInvoiceTelegram::inputInvoiceTelegram()
  : purpose_()
{}

inputInvoiceTelegram::inputInvoiceTelegram(object_ptr<TelegramPaymentPurpose> &&purpose_)
  : purpose_(std::move(purpose_))
{}

const std::int32_t inputInvoiceTelegram::ID;

void inputInvoiceTelegram::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputInvoiceTelegram");
    s.store_object_field("purpose", static_cast<const BaseObject *>(purpose_.get()));
    s.store_class_end();
  }
}

inputMessageText::inputMessageText()
  : text_()
  , link_preview_options_()
  , clear_draft_()
{}

inputMessageText::inputMessageText(object_ptr<formattedText> &&text_, object_ptr<linkPreviewOptions> &&link_preview_options_, bool clear_draft_)
  : text_(std::move(text_))
  , link_preview_options_(std::move(link_preview_options_))
  , clear_draft_(clear_draft_)
{}

const std::int32_t inputMessageText::ID;

void inputMessageText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageText");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_object_field("link_preview_options", static_cast<const BaseObject *>(link_preview_options_.get()));
    s.store_field("clear_draft", clear_draft_);
    s.store_class_end();
  }
}

inputMessageAnimation::inputMessageAnimation()
  : animation_()
  , thumbnail_()
  , added_sticker_file_ids_()
  , duration_()
  , width_()
  , height_()
  , caption_()
  , show_caption_above_media_()
  , has_spoiler_()
{}

inputMessageAnimation::inputMessageAnimation(object_ptr<InputFile> &&animation_, object_ptr<inputThumbnail> &&thumbnail_, array<int32> &&added_sticker_file_ids_, int32 duration_, int32 width_, int32 height_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, bool has_spoiler_)
  : animation_(std::move(animation_))
  , thumbnail_(std::move(thumbnail_))
  , added_sticker_file_ids_(std::move(added_sticker_file_ids_))
  , duration_(duration_)
  , width_(width_)
  , height_(height_)
  , caption_(std::move(caption_))
  , show_caption_above_media_(show_caption_above_media_)
  , has_spoiler_(has_spoiler_)
{}

const std::int32_t inputMessageAnimation::ID;

void inputMessageAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageAnimation");
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    { s.store_vector_begin("added_sticker_file_ids", added_sticker_file_ids_.size()); for (const auto &_value : added_sticker_file_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("duration", duration_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("show_caption_above_media", show_caption_above_media_);
    s.store_field("has_spoiler", has_spoiler_);
    s.store_class_end();
  }
}

inputMessageAudio::inputMessageAudio()
  : audio_()
  , album_cover_thumbnail_()
  , duration_()
  , title_()
  , performer_()
  , caption_()
{}

inputMessageAudio::inputMessageAudio(object_ptr<InputFile> &&audio_, object_ptr<inputThumbnail> &&album_cover_thumbnail_, int32 duration_, string const &title_, string const &performer_, object_ptr<formattedText> &&caption_)
  : audio_(std::move(audio_))
  , album_cover_thumbnail_(std::move(album_cover_thumbnail_))
  , duration_(duration_)
  , title_(title_)
  , performer_(performer_)
  , caption_(std::move(caption_))
{}

const std::int32_t inputMessageAudio::ID;

void inputMessageAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageAudio");
    s.store_object_field("audio", static_cast<const BaseObject *>(audio_.get()));
    s.store_object_field("album_cover_thumbnail", static_cast<const BaseObject *>(album_cover_thumbnail_.get()));
    s.store_field("duration", duration_);
    s.store_field("title", title_);
    s.store_field("performer", performer_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

inputMessageDocument::inputMessageDocument()
  : document_()
  , thumbnail_()
  , disable_content_type_detection_()
  , caption_()
{}

inputMessageDocument::inputMessageDocument(object_ptr<InputFile> &&document_, object_ptr<inputThumbnail> &&thumbnail_, bool disable_content_type_detection_, object_ptr<formattedText> &&caption_)
  : document_(std::move(document_))
  , thumbnail_(std::move(thumbnail_))
  , disable_content_type_detection_(disable_content_type_detection_)
  , caption_(std::move(caption_))
{}

const std::int32_t inputMessageDocument::ID;

void inputMessageDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageDocument");
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_field("disable_content_type_detection", disable_content_type_detection_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

inputMessagePaidMedia::inputMessagePaidMedia()
  : star_count_()
  , paid_media_()
  , caption_()
  , show_caption_above_media_()
  , payload_()
{}

inputMessagePaidMedia::inputMessagePaidMedia(int53 star_count_, array<object_ptr<inputPaidMedia>> &&paid_media_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, string const &payload_)
  : star_count_(star_count_)
  , paid_media_(std::move(paid_media_))
  , caption_(std::move(caption_))
  , show_caption_above_media_(show_caption_above_media_)
  , payload_(payload_)
{}

const std::int32_t inputMessagePaidMedia::ID;

void inputMessagePaidMedia::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagePaidMedia");
    s.store_field("star_count", star_count_);
    { s.store_vector_begin("paid_media", paid_media_.size()); for (const auto &_value : paid_media_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("show_caption_above_media", show_caption_above_media_);
    s.store_field("payload", payload_);
    s.store_class_end();
  }
}

inputMessagePhoto::inputMessagePhoto()
  : photo_()
  , thumbnail_()
  , added_sticker_file_ids_()
  , width_()
  , height_()
  , caption_()
  , show_caption_above_media_()
  , self_destruct_type_()
  , has_spoiler_()
{}

inputMessagePhoto::inputMessagePhoto(object_ptr<InputFile> &&photo_, object_ptr<inputThumbnail> &&thumbnail_, array<int32> &&added_sticker_file_ids_, int32 width_, int32 height_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, object_ptr<MessageSelfDestructType> &&self_destruct_type_, bool has_spoiler_)
  : photo_(std::move(photo_))
  , thumbnail_(std::move(thumbnail_))
  , added_sticker_file_ids_(std::move(added_sticker_file_ids_))
  , width_(width_)
  , height_(height_)
  , caption_(std::move(caption_))
  , show_caption_above_media_(show_caption_above_media_)
  , self_destruct_type_(std::move(self_destruct_type_))
  , has_spoiler_(has_spoiler_)
{}

const std::int32_t inputMessagePhoto::ID;

void inputMessagePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagePhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    { s.store_vector_begin("added_sticker_file_ids", added_sticker_file_ids_.size()); for (const auto &_value : added_sticker_file_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("show_caption_above_media", show_caption_above_media_);
    s.store_object_field("self_destruct_type", static_cast<const BaseObject *>(self_destruct_type_.get()));
    s.store_field("has_spoiler", has_spoiler_);
    s.store_class_end();
  }
}

inputMessageSticker::inputMessageSticker()
  : sticker_()
  , thumbnail_()
  , width_()
  , height_()
  , emoji_()
{}

inputMessageSticker::inputMessageSticker(object_ptr<InputFile> &&sticker_, object_ptr<inputThumbnail> &&thumbnail_, int32 width_, int32 height_, string const &emoji_)
  : sticker_(std::move(sticker_))
  , thumbnail_(std::move(thumbnail_))
  , width_(width_)
  , height_(height_)
  , emoji_(emoji_)
{}

const std::int32_t inputMessageSticker::ID;

void inputMessageSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageSticker");
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_field("emoji", emoji_);
    s.store_class_end();
  }
}

inputMessageVideo::inputMessageVideo()
  : video_()
  , thumbnail_()
  , cover_()
  , start_timestamp_()
  , added_sticker_file_ids_()
  , duration_()
  , width_()
  , height_()
  , supports_streaming_()
  , caption_()
  , show_caption_above_media_()
  , self_destruct_type_()
  , has_spoiler_()
{}

inputMessageVideo::inputMessageVideo(object_ptr<InputFile> &&video_, object_ptr<inputThumbnail> &&thumbnail_, object_ptr<InputFile> &&cover_, int32 start_timestamp_, array<int32> &&added_sticker_file_ids_, int32 duration_, int32 width_, int32 height_, bool supports_streaming_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, object_ptr<MessageSelfDestructType> &&self_destruct_type_, bool has_spoiler_)
  : video_(std::move(video_))
  , thumbnail_(std::move(thumbnail_))
  , cover_(std::move(cover_))
  , start_timestamp_(start_timestamp_)
  , added_sticker_file_ids_(std::move(added_sticker_file_ids_))
  , duration_(duration_)
  , width_(width_)
  , height_(height_)
  , supports_streaming_(supports_streaming_)
  , caption_(std::move(caption_))
  , show_caption_above_media_(show_caption_above_media_)
  , self_destruct_type_(std::move(self_destruct_type_))
  , has_spoiler_(has_spoiler_)
{}

const std::int32_t inputMessageVideo::ID;

void inputMessageVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageVideo");
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_object_field("cover", static_cast<const BaseObject *>(cover_.get()));
    s.store_field("start_timestamp", start_timestamp_);
    { s.store_vector_begin("added_sticker_file_ids", added_sticker_file_ids_.size()); for (const auto &_value : added_sticker_file_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("duration", duration_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_field("supports_streaming", supports_streaming_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("show_caption_above_media", show_caption_above_media_);
    s.store_object_field("self_destruct_type", static_cast<const BaseObject *>(self_destruct_type_.get()));
    s.store_field("has_spoiler", has_spoiler_);
    s.store_class_end();
  }
}

inputMessageVideoNote::inputMessageVideoNote()
  : video_note_()
  , thumbnail_()
  , duration_()
  , length_()
  , self_destruct_type_()
{}

inputMessageVideoNote::inputMessageVideoNote(object_ptr<InputFile> &&video_note_, object_ptr<inputThumbnail> &&thumbnail_, int32 duration_, int32 length_, object_ptr<MessageSelfDestructType> &&self_destruct_type_)
  : video_note_(std::move(video_note_))
  , thumbnail_(std::move(thumbnail_))
  , duration_(duration_)
  , length_(length_)
  , self_destruct_type_(std::move(self_destruct_type_))
{}

const std::int32_t inputMessageVideoNote::ID;

void inputMessageVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageVideoNote");
    s.store_object_field("video_note", static_cast<const BaseObject *>(video_note_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_field("duration", duration_);
    s.store_field("length", length_);
    s.store_object_field("self_destruct_type", static_cast<const BaseObject *>(self_destruct_type_.get()));
    s.store_class_end();
  }
}

inputMessageVoiceNote::inputMessageVoiceNote()
  : voice_note_()
  , duration_()
  , waveform_()
  , caption_()
  , self_destruct_type_()
{}

inputMessageVoiceNote::inputMessageVoiceNote(object_ptr<InputFile> &&voice_note_, int32 duration_, bytes const &waveform_, object_ptr<formattedText> &&caption_, object_ptr<MessageSelfDestructType> &&self_destruct_type_)
  : voice_note_(std::move(voice_note_))
  , duration_(duration_)
  , waveform_(std::move(waveform_))
  , caption_(std::move(caption_))
  , self_destruct_type_(std::move(self_destruct_type_))
{}

const std::int32_t inputMessageVoiceNote::ID;

void inputMessageVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageVoiceNote");
    s.store_object_field("voice_note", static_cast<const BaseObject *>(voice_note_.get()));
    s.store_field("duration", duration_);
    s.store_bytes_field("waveform", waveform_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_object_field("self_destruct_type", static_cast<const BaseObject *>(self_destruct_type_.get()));
    s.store_class_end();
  }
}

inputMessageLocation::inputMessageLocation()
  : location_()
  , live_period_()
  , heading_()
  , proximity_alert_radius_()
{}

inputMessageLocation::inputMessageLocation(object_ptr<location> &&location_, int32 live_period_, int32 heading_, int32 proximity_alert_radius_)
  : location_(std::move(location_))
  , live_period_(live_period_)
  , heading_(heading_)
  , proximity_alert_radius_(proximity_alert_radius_)
{}

const std::int32_t inputMessageLocation::ID;

void inputMessageLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageLocation");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_field("live_period", live_period_);
    s.store_field("heading", heading_);
    s.store_field("proximity_alert_radius", proximity_alert_radius_);
    s.store_class_end();
  }
}

inputMessageVenue::inputMessageVenue()
  : venue_()
{}

inputMessageVenue::inputMessageVenue(object_ptr<venue> &&venue_)
  : venue_(std::move(venue_))
{}

const std::int32_t inputMessageVenue::ID;

void inputMessageVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageVenue");
    s.store_object_field("venue", static_cast<const BaseObject *>(venue_.get()));
    s.store_class_end();
  }
}

inputMessageContact::inputMessageContact()
  : contact_()
{}

inputMessageContact::inputMessageContact(object_ptr<contact> &&contact_)
  : contact_(std::move(contact_))
{}

const std::int32_t inputMessageContact::ID;

void inputMessageContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageContact");
    s.store_object_field("contact", static_cast<const BaseObject *>(contact_.get()));
    s.store_class_end();
  }
}

inputMessageDice::inputMessageDice()
  : emoji_()
  , clear_draft_()
{}

inputMessageDice::inputMessageDice(string const &emoji_, bool clear_draft_)
  : emoji_(emoji_)
  , clear_draft_(clear_draft_)
{}

const std::int32_t inputMessageDice::ID;

void inputMessageDice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageDice");
    s.store_field("emoji", emoji_);
    s.store_field("clear_draft", clear_draft_);
    s.store_class_end();
  }
}

inputMessageGame::inputMessageGame()
  : bot_user_id_()
  , game_short_name_()
{}

inputMessageGame::inputMessageGame(int53 bot_user_id_, string const &game_short_name_)
  : bot_user_id_(bot_user_id_)
  , game_short_name_(game_short_name_)
{}

const std::int32_t inputMessageGame::ID;

void inputMessageGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageGame");
    s.store_field("bot_user_id", bot_user_id_);
    s.store_field("game_short_name", game_short_name_);
    s.store_class_end();
  }
}

inputMessageInvoice::inputMessageInvoice()
  : invoice_()
  , title_()
  , description_()
  , photo_url_()
  , photo_size_()
  , photo_width_()
  , photo_height_()
  , payload_()
  , provider_token_()
  , provider_data_()
  , start_parameter_()
  , paid_media_()
  , paid_media_caption_()
{}

inputMessageInvoice::inputMessageInvoice(object_ptr<invoice> &&invoice_, string const &title_, string const &description_, string const &photo_url_, int32 photo_size_, int32 photo_width_, int32 photo_height_, bytes const &payload_, string const &provider_token_, string const &provider_data_, string const &start_parameter_, object_ptr<inputPaidMedia> &&paid_media_, object_ptr<formattedText> &&paid_media_caption_)
  : invoice_(std::move(invoice_))
  , title_(title_)
  , description_(description_)
  , photo_url_(photo_url_)
  , photo_size_(photo_size_)
  , photo_width_(photo_width_)
  , photo_height_(photo_height_)
  , payload_(std::move(payload_))
  , provider_token_(provider_token_)
  , provider_data_(provider_data_)
  , start_parameter_(start_parameter_)
  , paid_media_(std::move(paid_media_))
  , paid_media_caption_(std::move(paid_media_caption_))
{}

const std::int32_t inputMessageInvoice::ID;

void inputMessageInvoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageInvoice");
    s.store_object_field("invoice", static_cast<const BaseObject *>(invoice_.get()));
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_field("photo_url", photo_url_);
    s.store_field("photo_size", photo_size_);
    s.store_field("photo_width", photo_width_);
    s.store_field("photo_height", photo_height_);
    s.store_bytes_field("payload", payload_);
    s.store_field("provider_token", provider_token_);
    s.store_field("provider_data", provider_data_);
    s.store_field("start_parameter", start_parameter_);
    s.store_object_field("paid_media", static_cast<const BaseObject *>(paid_media_.get()));
    s.store_object_field("paid_media_caption", static_cast<const BaseObject *>(paid_media_caption_.get()));
    s.store_class_end();
  }
}

inputMessagePoll::inputMessagePoll()
  : question_()
  , options_()
  , is_anonymous_()
  , type_()
  , open_period_()
  , close_date_()
  , is_closed_()
{}

inputMessagePoll::inputMessagePoll(object_ptr<formattedText> &&question_, array<object_ptr<formattedText>> &&options_, bool is_anonymous_, object_ptr<PollType> &&type_, int32 open_period_, int32 close_date_, bool is_closed_)
  : question_(std::move(question_))
  , options_(std::move(options_))
  , is_anonymous_(is_anonymous_)
  , type_(std::move(type_))
  , open_period_(open_period_)
  , close_date_(close_date_)
  , is_closed_(is_closed_)
{}

const std::int32_t inputMessagePoll::ID;

void inputMessagePoll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessagePoll");
    s.store_object_field("question", static_cast<const BaseObject *>(question_.get()));
    { s.store_vector_begin("options", options_.size()); for (const auto &_value : options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("is_anonymous", is_anonymous_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("open_period", open_period_);
    s.store_field("close_date", close_date_);
    s.store_field("is_closed", is_closed_);
    s.store_class_end();
  }
}

inputMessageStory::inputMessageStory()
  : story_sender_chat_id_()
  , story_id_()
{}

inputMessageStory::inputMessageStory(int53 story_sender_chat_id_, int32 story_id_)
  : story_sender_chat_id_(story_sender_chat_id_)
  , story_id_(story_id_)
{}

const std::int32_t inputMessageStory::ID;

void inputMessageStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageStory");
    s.store_field("story_sender_chat_id", story_sender_chat_id_);
    s.store_field("story_id", story_id_);
    s.store_class_end();
  }
}

inputMessageForwarded::inputMessageForwarded()
  : from_chat_id_()
  , message_id_()
  , in_game_share_()
  , replace_video_start_timestamp_()
  , new_video_start_timestamp_()
  , copy_options_()
{}

inputMessageForwarded::inputMessageForwarded(int53 from_chat_id_, int53 message_id_, bool in_game_share_, bool replace_video_start_timestamp_, int32 new_video_start_timestamp_, object_ptr<messageCopyOptions> &&copy_options_)
  : from_chat_id_(from_chat_id_)
  , message_id_(message_id_)
  , in_game_share_(in_game_share_)
  , replace_video_start_timestamp_(replace_video_start_timestamp_)
  , new_video_start_timestamp_(new_video_start_timestamp_)
  , copy_options_(std::move(copy_options_))
{}

const std::int32_t inputMessageForwarded::ID;

void inputMessageForwarded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageForwarded");
    s.store_field("from_chat_id", from_chat_id_);
    s.store_field("message_id", message_id_);
    s.store_field("in_game_share", in_game_share_);
    s.store_field("replace_video_start_timestamp", replace_video_start_timestamp_);
    s.store_field("new_video_start_timestamp", new_video_start_timestamp_);
    s.store_object_field("copy_options", static_cast<const BaseObject *>(copy_options_.get()));
    s.store_class_end();
  }
}

inputMessageReplyToMessage::inputMessageReplyToMessage()
  : message_id_()
  , quote_()
{}

inputMessageReplyToMessage::inputMessageReplyToMessage(int53 message_id_, object_ptr<inputTextQuote> &&quote_)
  : message_id_(message_id_)
  , quote_(std::move(quote_))
{}

const std::int32_t inputMessageReplyToMessage::ID;

void inputMessageReplyToMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageReplyToMessage");
    s.store_field("message_id", message_id_);
    s.store_object_field("quote", static_cast<const BaseObject *>(quote_.get()));
    s.store_class_end();
  }
}

inputMessageReplyToExternalMessage::inputMessageReplyToExternalMessage()
  : chat_id_()
  , message_id_()
  , quote_()
{}

inputMessageReplyToExternalMessage::inputMessageReplyToExternalMessage(int53 chat_id_, int53 message_id_, object_ptr<inputTextQuote> &&quote_)
  : chat_id_(chat_id_)
  , message_id_(message_id_)
  , quote_(std::move(quote_))
{}

const std::int32_t inputMessageReplyToExternalMessage::ID;

void inputMessageReplyToExternalMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageReplyToExternalMessage");
    s.store_field("chat_id", chat_id_);
    s.store_field("message_id", message_id_);
    s.store_object_field("quote", static_cast<const BaseObject *>(quote_.get()));
    s.store_class_end();
  }
}

inputMessageReplyToStory::inputMessageReplyToStory()
  : story_sender_chat_id_()
  , story_id_()
{}

inputMessageReplyToStory::inputMessageReplyToStory(int53 story_sender_chat_id_, int32 story_id_)
  : story_sender_chat_id_(story_sender_chat_id_)
  , story_id_(story_id_)
{}

const std::int32_t inputMessageReplyToStory::ID;

void inputMessageReplyToStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputMessageReplyToStory");
    s.store_field("story_sender_chat_id", story_sender_chat_id_);
    s.store_field("story_id", story_id_);
    s.store_class_end();
  }
}

inputPaidMedia::inputPaidMedia()
  : type_()
  , media_()
  , thumbnail_()
  , added_sticker_file_ids_()
  , width_()
  , height_()
{}

inputPaidMedia::inputPaidMedia(object_ptr<InputPaidMediaType> &&type_, object_ptr<InputFile> &&media_, object_ptr<inputThumbnail> &&thumbnail_, array<int32> &&added_sticker_file_ids_, int32 width_, int32 height_)
  : type_(std::move(type_))
  , media_(std::move(media_))
  , thumbnail_(std::move(thumbnail_))
  , added_sticker_file_ids_(std::move(added_sticker_file_ids_))
  , width_(width_)
  , height_(height_)
{}

const std::int32_t inputPaidMedia::ID;

void inputPaidMedia::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPaidMedia");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_object_field("media", static_cast<const BaseObject *>(media_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    { s.store_vector_begin("added_sticker_file_ids", added_sticker_file_ids_.size()); for (const auto &_value : added_sticker_file_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_class_end();
  }
}

inputPaidMediaTypePhoto::inputPaidMediaTypePhoto() {
}

const std::int32_t inputPaidMediaTypePhoto::ID;

void inputPaidMediaTypePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPaidMediaTypePhoto");
    s.store_class_end();
  }
}

inputPaidMediaTypeVideo::inputPaidMediaTypeVideo()
  : cover_()
  , start_timestamp_()
  , duration_()
  , supports_streaming_()
{}

inputPaidMediaTypeVideo::inputPaidMediaTypeVideo(object_ptr<InputFile> &&cover_, int32 start_timestamp_, int32 duration_, bool supports_streaming_)
  : cover_(std::move(cover_))
  , start_timestamp_(start_timestamp_)
  , duration_(duration_)
  , supports_streaming_(supports_streaming_)
{}

const std::int32_t inputPaidMediaTypeVideo::ID;

void inputPaidMediaTypeVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPaidMediaTypeVideo");
    s.store_object_field("cover", static_cast<const BaseObject *>(cover_.get()));
    s.store_field("start_timestamp", start_timestamp_);
    s.store_field("duration", duration_);
    s.store_field("supports_streaming", supports_streaming_);
    s.store_class_end();
  }
}

inputPassportElementPersonalDetails::inputPassportElementPersonalDetails()
  : personal_details_()
{}

inputPassportElementPersonalDetails::inputPassportElementPersonalDetails(object_ptr<personalDetails> &&personal_details_)
  : personal_details_(std::move(personal_details_))
{}

const std::int32_t inputPassportElementPersonalDetails::ID;

void inputPassportElementPersonalDetails::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementPersonalDetails");
    s.store_object_field("personal_details", static_cast<const BaseObject *>(personal_details_.get()));
    s.store_class_end();
  }
}

inputPassportElementPassport::inputPassportElementPassport()
  : passport_()
{}

inputPassportElementPassport::inputPassportElementPassport(object_ptr<inputIdentityDocument> &&passport_)
  : passport_(std::move(passport_))
{}

const std::int32_t inputPassportElementPassport::ID;

void inputPassportElementPassport::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementPassport");
    s.store_object_field("passport", static_cast<const BaseObject *>(passport_.get()));
    s.store_class_end();
  }
}

inputPassportElementDriverLicense::inputPassportElementDriverLicense()
  : driver_license_()
{}

inputPassportElementDriverLicense::inputPassportElementDriverLicense(object_ptr<inputIdentityDocument> &&driver_license_)
  : driver_license_(std::move(driver_license_))
{}

const std::int32_t inputPassportElementDriverLicense::ID;

void inputPassportElementDriverLicense::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementDriverLicense");
    s.store_object_field("driver_license", static_cast<const BaseObject *>(driver_license_.get()));
    s.store_class_end();
  }
}

inputPassportElementIdentityCard::inputPassportElementIdentityCard()
  : identity_card_()
{}

inputPassportElementIdentityCard::inputPassportElementIdentityCard(object_ptr<inputIdentityDocument> &&identity_card_)
  : identity_card_(std::move(identity_card_))
{}

const std::int32_t inputPassportElementIdentityCard::ID;

void inputPassportElementIdentityCard::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementIdentityCard");
    s.store_object_field("identity_card", static_cast<const BaseObject *>(identity_card_.get()));
    s.store_class_end();
  }
}

inputPassportElementInternalPassport::inputPassportElementInternalPassport()
  : internal_passport_()
{}

inputPassportElementInternalPassport::inputPassportElementInternalPassport(object_ptr<inputIdentityDocument> &&internal_passport_)
  : internal_passport_(std::move(internal_passport_))
{}

const std::int32_t inputPassportElementInternalPassport::ID;

void inputPassportElementInternalPassport::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementInternalPassport");
    s.store_object_field("internal_passport", static_cast<const BaseObject *>(internal_passport_.get()));
    s.store_class_end();
  }
}

inputPassportElementAddress::inputPassportElementAddress()
  : address_()
{}

inputPassportElementAddress::inputPassportElementAddress(object_ptr<address> &&address_)
  : address_(std::move(address_))
{}

const std::int32_t inputPassportElementAddress::ID;

void inputPassportElementAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementAddress");
    s.store_object_field("address", static_cast<const BaseObject *>(address_.get()));
    s.store_class_end();
  }
}

inputPassportElementUtilityBill::inputPassportElementUtilityBill()
  : utility_bill_()
{}

inputPassportElementUtilityBill::inputPassportElementUtilityBill(object_ptr<inputPersonalDocument> &&utility_bill_)
  : utility_bill_(std::move(utility_bill_))
{}

const std::int32_t inputPassportElementUtilityBill::ID;

void inputPassportElementUtilityBill::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementUtilityBill");
    s.store_object_field("utility_bill", static_cast<const BaseObject *>(utility_bill_.get()));
    s.store_class_end();
  }
}

inputPassportElementBankStatement::inputPassportElementBankStatement()
  : bank_statement_()
{}

inputPassportElementBankStatement::inputPassportElementBankStatement(object_ptr<inputPersonalDocument> &&bank_statement_)
  : bank_statement_(std::move(bank_statement_))
{}

const std::int32_t inputPassportElementBankStatement::ID;

void inputPassportElementBankStatement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementBankStatement");
    s.store_object_field("bank_statement", static_cast<const BaseObject *>(bank_statement_.get()));
    s.store_class_end();
  }
}

inputPassportElementRentalAgreement::inputPassportElementRentalAgreement()
  : rental_agreement_()
{}

inputPassportElementRentalAgreement::inputPassportElementRentalAgreement(object_ptr<inputPersonalDocument> &&rental_agreement_)
  : rental_agreement_(std::move(rental_agreement_))
{}

const std::int32_t inputPassportElementRentalAgreement::ID;

void inputPassportElementRentalAgreement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementRentalAgreement");
    s.store_object_field("rental_agreement", static_cast<const BaseObject *>(rental_agreement_.get()));
    s.store_class_end();
  }
}

inputPassportElementPassportRegistration::inputPassportElementPassportRegistration()
  : passport_registration_()
{}

inputPassportElementPassportRegistration::inputPassportElementPassportRegistration(object_ptr<inputPersonalDocument> &&passport_registration_)
  : passport_registration_(std::move(passport_registration_))
{}

const std::int32_t inputPassportElementPassportRegistration::ID;

void inputPassportElementPassportRegistration::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementPassportRegistration");
    s.store_object_field("passport_registration", static_cast<const BaseObject *>(passport_registration_.get()));
    s.store_class_end();
  }
}

inputPassportElementTemporaryRegistration::inputPassportElementTemporaryRegistration()
  : temporary_registration_()
{}

inputPassportElementTemporaryRegistration::inputPassportElementTemporaryRegistration(object_ptr<inputPersonalDocument> &&temporary_registration_)
  : temporary_registration_(std::move(temporary_registration_))
{}

const std::int32_t inputPassportElementTemporaryRegistration::ID;

void inputPassportElementTemporaryRegistration::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementTemporaryRegistration");
    s.store_object_field("temporary_registration", static_cast<const BaseObject *>(temporary_registration_.get()));
    s.store_class_end();
  }
}

inputPassportElementPhoneNumber::inputPassportElementPhoneNumber()
  : phone_number_()
{}

inputPassportElementPhoneNumber::inputPassportElementPhoneNumber(string const &phone_number_)
  : phone_number_(phone_number_)
{}

const std::int32_t inputPassportElementPhoneNumber::ID;

void inputPassportElementPhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementPhoneNumber");
    s.store_field("phone_number", phone_number_);
    s.store_class_end();
  }
}

inputPassportElementEmailAddress::inputPassportElementEmailAddress()
  : email_address_()
{}

inputPassportElementEmailAddress::inputPassportElementEmailAddress(string const &email_address_)
  : email_address_(email_address_)
{}

const std::int32_t inputPassportElementEmailAddress::ID;

void inputPassportElementEmailAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementEmailAddress");
    s.store_field("email_address", email_address_);
    s.store_class_end();
  }
}

inputPassportElementError::inputPassportElementError()
  : type_()
  , message_()
  , source_()
{}

inputPassportElementError::inputPassportElementError(object_ptr<PassportElementType> &&type_, string const &message_, object_ptr<InputPassportElementErrorSource> &&source_)
  : type_(std::move(type_))
  , message_(message_)
  , source_(std::move(source_))
{}

const std::int32_t inputPassportElementError::ID;

void inputPassportElementError::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementError");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("message", message_);
    s.store_object_field("source", static_cast<const BaseObject *>(source_.get()));
    s.store_class_end();
  }
}

inputPassportElementErrorSourceUnspecified::inputPassportElementErrorSourceUnspecified()
  : element_hash_()
{}

inputPassportElementErrorSourceUnspecified::inputPassportElementErrorSourceUnspecified(bytes const &element_hash_)
  : element_hash_(std::move(element_hash_))
{}

const std::int32_t inputPassportElementErrorSourceUnspecified::ID;

void inputPassportElementErrorSourceUnspecified::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementErrorSourceUnspecified");
    s.store_bytes_field("element_hash", element_hash_);
    s.store_class_end();
  }
}

inputPassportElementErrorSourceDataField::inputPassportElementErrorSourceDataField()
  : field_name_()
  , data_hash_()
{}

inputPassportElementErrorSourceDataField::inputPassportElementErrorSourceDataField(string const &field_name_, bytes const &data_hash_)
  : field_name_(field_name_)
  , data_hash_(std::move(data_hash_))
{}

const std::int32_t inputPassportElementErrorSourceDataField::ID;

void inputPassportElementErrorSourceDataField::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementErrorSourceDataField");
    s.store_field("field_name", field_name_);
    s.store_bytes_field("data_hash", data_hash_);
    s.store_class_end();
  }
}

inputPassportElementErrorSourceFrontSide::inputPassportElementErrorSourceFrontSide()
  : file_hash_()
{}

inputPassportElementErrorSourceFrontSide::inputPassportElementErrorSourceFrontSide(bytes const &file_hash_)
  : file_hash_(std::move(file_hash_))
{}

const std::int32_t inputPassportElementErrorSourceFrontSide::ID;

void inputPassportElementErrorSourceFrontSide::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementErrorSourceFrontSide");
    s.store_bytes_field("file_hash", file_hash_);
    s.store_class_end();
  }
}

inputPassportElementErrorSourceReverseSide::inputPassportElementErrorSourceReverseSide()
  : file_hash_()
{}

inputPassportElementErrorSourceReverseSide::inputPassportElementErrorSourceReverseSide(bytes const &file_hash_)
  : file_hash_(std::move(file_hash_))
{}

const std::int32_t inputPassportElementErrorSourceReverseSide::ID;

void inputPassportElementErrorSourceReverseSide::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementErrorSourceReverseSide");
    s.store_bytes_field("file_hash", file_hash_);
    s.store_class_end();
  }
}

inputPassportElementErrorSourceSelfie::inputPassportElementErrorSourceSelfie()
  : file_hash_()
{}

inputPassportElementErrorSourceSelfie::inputPassportElementErrorSourceSelfie(bytes const &file_hash_)
  : file_hash_(std::move(file_hash_))
{}

const std::int32_t inputPassportElementErrorSourceSelfie::ID;

void inputPassportElementErrorSourceSelfie::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementErrorSourceSelfie");
    s.store_bytes_field("file_hash", file_hash_);
    s.store_class_end();
  }
}

inputPassportElementErrorSourceTranslationFile::inputPassportElementErrorSourceTranslationFile()
  : file_hash_()
{}

inputPassportElementErrorSourceTranslationFile::inputPassportElementErrorSourceTranslationFile(bytes const &file_hash_)
  : file_hash_(std::move(file_hash_))
{}

const std::int32_t inputPassportElementErrorSourceTranslationFile::ID;

void inputPassportElementErrorSourceTranslationFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementErrorSourceTranslationFile");
    s.store_bytes_field("file_hash", file_hash_);
    s.store_class_end();
  }
}

inputPassportElementErrorSourceTranslationFiles::inputPassportElementErrorSourceTranslationFiles()
  : file_hashes_()
{}

inputPassportElementErrorSourceTranslationFiles::inputPassportElementErrorSourceTranslationFiles(array<bytes> &&file_hashes_)
  : file_hashes_(std::move(file_hashes_))
{}

const std::int32_t inputPassportElementErrorSourceTranslationFiles::ID;

void inputPassportElementErrorSourceTranslationFiles::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementErrorSourceTranslationFiles");
    { s.store_vector_begin("file_hashes", file_hashes_.size()); for (const auto &_value : file_hashes_) { s.store_bytes_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

inputPassportElementErrorSourceFile::inputPassportElementErrorSourceFile()
  : file_hash_()
{}

inputPassportElementErrorSourceFile::inputPassportElementErrorSourceFile(bytes const &file_hash_)
  : file_hash_(std::move(file_hash_))
{}

const std::int32_t inputPassportElementErrorSourceFile::ID;

void inputPassportElementErrorSourceFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementErrorSourceFile");
    s.store_bytes_field("file_hash", file_hash_);
    s.store_class_end();
  }
}

inputPassportElementErrorSourceFiles::inputPassportElementErrorSourceFiles()
  : file_hashes_()
{}

inputPassportElementErrorSourceFiles::inputPassportElementErrorSourceFiles(array<bytes> &&file_hashes_)
  : file_hashes_(std::move(file_hashes_))
{}

const std::int32_t inputPassportElementErrorSourceFiles::ID;

void inputPassportElementErrorSourceFiles::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPassportElementErrorSourceFiles");
    { s.store_vector_begin("file_hashes", file_hashes_.size()); for (const auto &_value : file_hashes_) { s.store_bytes_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

inputPersonalDocument::inputPersonalDocument()
  : files_()
  , translation_()
{}

inputPersonalDocument::inputPersonalDocument(array<object_ptr<InputFile>> &&files_, array<object_ptr<InputFile>> &&translation_)
  : files_(std::move(files_))
  , translation_(std::move(translation_))
{}

const std::int32_t inputPersonalDocument::ID;

void inputPersonalDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputPersonalDocument");
    { s.store_vector_begin("files", files_.size()); for (const auto &_value : files_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("translation", translation_.size()); for (const auto &_value : translation_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

inputSticker::inputSticker()
  : sticker_()
  , format_()
  , emojis_()
  , mask_position_()
  , keywords_()
{}

inputSticker::inputSticker(object_ptr<InputFile> &&sticker_, object_ptr<StickerFormat> &&format_, string const &emojis_, object_ptr<maskPosition> &&mask_position_, array<string> &&keywords_)
  : sticker_(std::move(sticker_))
  , format_(std::move(format_))
  , emojis_(emojis_)
  , mask_position_(std::move(mask_position_))
  , keywords_(std::move(keywords_))
{}

const std::int32_t inputSticker::ID;

void inputSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputSticker");
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_object_field("format", static_cast<const BaseObject *>(format_.get()));
    s.store_field("emojis", emojis_);
    s.store_object_field("mask_position", static_cast<const BaseObject *>(mask_position_.get()));
    { s.store_vector_begin("keywords", keywords_.size()); for (const auto &_value : keywords_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

inputStoryArea::inputStoryArea()
  : position_()
  , type_()
{}

inputStoryArea::inputStoryArea(object_ptr<storyAreaPosition> &&position_, object_ptr<InputStoryAreaType> &&type_)
  : position_(std::move(position_))
  , type_(std::move(type_))
{}

const std::int32_t inputStoryArea::ID;

void inputStoryArea::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryArea");
    s.store_object_field("position", static_cast<const BaseObject *>(position_.get()));
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

inputStoryAreaTypeLocation::inputStoryAreaTypeLocation()
  : location_()
  , address_()
{}

inputStoryAreaTypeLocation::inputStoryAreaTypeLocation(object_ptr<location> &&location_, object_ptr<locationAddress> &&address_)
  : location_(std::move(location_))
  , address_(std::move(address_))
{}

const std::int32_t inputStoryAreaTypeLocation::ID;

void inputStoryAreaTypeLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryAreaTypeLocation");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_object_field("address", static_cast<const BaseObject *>(address_.get()));
    s.store_class_end();
  }
}

inputStoryAreaTypeFoundVenue::inputStoryAreaTypeFoundVenue()
  : query_id_()
  , result_id_()
{}

inputStoryAreaTypeFoundVenue::inputStoryAreaTypeFoundVenue(int64 query_id_, string const &result_id_)
  : query_id_(query_id_)
  , result_id_(result_id_)
{}

const std::int32_t inputStoryAreaTypeFoundVenue::ID;

void inputStoryAreaTypeFoundVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryAreaTypeFoundVenue");
    s.store_field("query_id", query_id_);
    s.store_field("result_id", result_id_);
    s.store_class_end();
  }
}

inputStoryAreaTypePreviousVenue::inputStoryAreaTypePreviousVenue()
  : venue_provider_()
  , venue_id_()
{}

inputStoryAreaTypePreviousVenue::inputStoryAreaTypePreviousVenue(string const &venue_provider_, string const &venue_id_)
  : venue_provider_(venue_provider_)
  , venue_id_(venue_id_)
{}

const std::int32_t inputStoryAreaTypePreviousVenue::ID;

void inputStoryAreaTypePreviousVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryAreaTypePreviousVenue");
    s.store_field("venue_provider", venue_provider_);
    s.store_field("venue_id", venue_id_);
    s.store_class_end();
  }
}

inputStoryAreaTypeSuggestedReaction::inputStoryAreaTypeSuggestedReaction()
  : reaction_type_()
  , is_dark_()
  , is_flipped_()
{}

inputStoryAreaTypeSuggestedReaction::inputStoryAreaTypeSuggestedReaction(object_ptr<ReactionType> &&reaction_type_, bool is_dark_, bool is_flipped_)
  : reaction_type_(std::move(reaction_type_))
  , is_dark_(is_dark_)
  , is_flipped_(is_flipped_)
{}

const std::int32_t inputStoryAreaTypeSuggestedReaction::ID;

void inputStoryAreaTypeSuggestedReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryAreaTypeSuggestedReaction");
    s.store_object_field("reaction_type", static_cast<const BaseObject *>(reaction_type_.get()));
    s.store_field("is_dark", is_dark_);
    s.store_field("is_flipped", is_flipped_);
    s.store_class_end();
  }
}

inputStoryAreaTypeMessage::inputStoryAreaTypeMessage()
  : chat_id_()
  , message_id_()
{}

inputStoryAreaTypeMessage::inputStoryAreaTypeMessage(int53 chat_id_, int53 message_id_)
  : chat_id_(chat_id_)
  , message_id_(message_id_)
{}

const std::int32_t inputStoryAreaTypeMessage::ID;

void inputStoryAreaTypeMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryAreaTypeMessage");
    s.store_field("chat_id", chat_id_);
    s.store_field("message_id", message_id_);
    s.store_class_end();
  }
}

inputStoryAreaTypeLink::inputStoryAreaTypeLink()
  : url_()
{}

inputStoryAreaTypeLink::inputStoryAreaTypeLink(string const &url_)
  : url_(url_)
{}

const std::int32_t inputStoryAreaTypeLink::ID;

void inputStoryAreaTypeLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryAreaTypeLink");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

inputStoryAreaTypeWeather::inputStoryAreaTypeWeather()
  : temperature_()
  , emoji_()
  , background_color_()
{}

inputStoryAreaTypeWeather::inputStoryAreaTypeWeather(double temperature_, string const &emoji_, int32 background_color_)
  : temperature_(temperature_)
  , emoji_(emoji_)
  , background_color_(background_color_)
{}

const std::int32_t inputStoryAreaTypeWeather::ID;

void inputStoryAreaTypeWeather::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryAreaTypeWeather");
    s.store_field("temperature", temperature_);
    s.store_field("emoji", emoji_);
    s.store_field("background_color", background_color_);
    s.store_class_end();
  }
}

inputStoryAreaTypeUpgradedGift::inputStoryAreaTypeUpgradedGift()
  : gift_name_()
{}

inputStoryAreaTypeUpgradedGift::inputStoryAreaTypeUpgradedGift(string const &gift_name_)
  : gift_name_(gift_name_)
{}

const std::int32_t inputStoryAreaTypeUpgradedGift::ID;

void inputStoryAreaTypeUpgradedGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryAreaTypeUpgradedGift");
    s.store_field("gift_name", gift_name_);
    s.store_class_end();
  }
}

inputStoryAreas::inputStoryAreas()
  : areas_()
{}

inputStoryAreas::inputStoryAreas(array<object_ptr<inputStoryArea>> &&areas_)
  : areas_(std::move(areas_))
{}

const std::int32_t inputStoryAreas::ID;

void inputStoryAreas::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryAreas");
    { s.store_vector_begin("areas", areas_.size()); for (const auto &_value : areas_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

inputStoryContentPhoto::inputStoryContentPhoto()
  : photo_()
  , added_sticker_file_ids_()
{}

inputStoryContentPhoto::inputStoryContentPhoto(object_ptr<InputFile> &&photo_, array<int32> &&added_sticker_file_ids_)
  : photo_(std::move(photo_))
  , added_sticker_file_ids_(std::move(added_sticker_file_ids_))
{}

const std::int32_t inputStoryContentPhoto::ID;

void inputStoryContentPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryContentPhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    { s.store_vector_begin("added_sticker_file_ids", added_sticker_file_ids_.size()); for (const auto &_value : added_sticker_file_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

inputStoryContentVideo::inputStoryContentVideo()
  : video_()
  , added_sticker_file_ids_()
  , duration_()
  , cover_frame_timestamp_()
  , is_animation_()
{}

inputStoryContentVideo::inputStoryContentVideo(object_ptr<InputFile> &&video_, array<int32> &&added_sticker_file_ids_, double duration_, double cover_frame_timestamp_, bool is_animation_)
  : video_(std::move(video_))
  , added_sticker_file_ids_(std::move(added_sticker_file_ids_))
  , duration_(duration_)
  , cover_frame_timestamp_(cover_frame_timestamp_)
  , is_animation_(is_animation_)
{}

const std::int32_t inputStoryContentVideo::ID;

void inputStoryContentVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputStoryContentVideo");
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    { s.store_vector_begin("added_sticker_file_ids", added_sticker_file_ids_.size()); for (const auto &_value : added_sticker_file_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("duration", duration_);
    s.store_field("cover_frame_timestamp", cover_frame_timestamp_);
    s.store_field("is_animation", is_animation_);
    s.store_class_end();
  }
}

inputTextQuote::inputTextQuote()
  : text_()
  , position_()
{}

inputTextQuote::inputTextQuote(object_ptr<formattedText> &&text_, int32 position_)
  : text_(std::move(text_))
  , position_(position_)
{}

const std::int32_t inputTextQuote::ID;

void inputTextQuote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputTextQuote");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("position", position_);
    s.store_class_end();
  }
}

inputThumbnail::inputThumbnail()
  : thumbnail_()
  , width_()
  , height_()
{}

inputThumbnail::inputThumbnail(object_ptr<InputFile> &&thumbnail_, int32 width_, int32 height_)
  : thumbnail_(std::move(thumbnail_))
  , width_(width_)
  , height_(height_)
{}

const std::int32_t inputThumbnail::ID;

void inputThumbnail::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inputThumbnail");
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_class_end();
  }
}

internalLinkTypeActiveSessions::internalLinkTypeActiveSessions() {
}

const std::int32_t internalLinkTypeActiveSessions::ID;

void internalLinkTypeActiveSessions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeActiveSessions");
    s.store_class_end();
  }
}

internalLinkTypeAttachmentMenuBot::internalLinkTypeAttachmentMenuBot()
  : target_chat_()
  , bot_username_()
  , url_()
{}

internalLinkTypeAttachmentMenuBot::internalLinkTypeAttachmentMenuBot(object_ptr<TargetChat> &&target_chat_, string const &bot_username_, string const &url_)
  : target_chat_(std::move(target_chat_))
  , bot_username_(bot_username_)
  , url_(url_)
{}

const std::int32_t internalLinkTypeAttachmentMenuBot::ID;

void internalLinkTypeAttachmentMenuBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeAttachmentMenuBot");
    s.store_object_field("target_chat", static_cast<const BaseObject *>(target_chat_.get()));
    s.store_field("bot_username", bot_username_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

internalLinkTypeAuthenticationCode::internalLinkTypeAuthenticationCode()
  : code_()
{}

internalLinkTypeAuthenticationCode::internalLinkTypeAuthenticationCode(string const &code_)
  : code_(code_)
{}

const std::int32_t internalLinkTypeAuthenticationCode::ID;

void internalLinkTypeAuthenticationCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeAuthenticationCode");
    s.store_field("code", code_);
    s.store_class_end();
  }
}

internalLinkTypeBackground::internalLinkTypeBackground()
  : background_name_()
{}

internalLinkTypeBackground::internalLinkTypeBackground(string const &background_name_)
  : background_name_(background_name_)
{}

const std::int32_t internalLinkTypeBackground::ID;

void internalLinkTypeBackground::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeBackground");
    s.store_field("background_name", background_name_);
    s.store_class_end();
  }
}

internalLinkTypeBotAddToChannel::internalLinkTypeBotAddToChannel()
  : bot_username_()
  , administrator_rights_()
{}

internalLinkTypeBotAddToChannel::internalLinkTypeBotAddToChannel(string const &bot_username_, object_ptr<chatAdministratorRights> &&administrator_rights_)
  : bot_username_(bot_username_)
  , administrator_rights_(std::move(administrator_rights_))
{}

const std::int32_t internalLinkTypeBotAddToChannel::ID;

void internalLinkTypeBotAddToChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeBotAddToChannel");
    s.store_field("bot_username", bot_username_);
    s.store_object_field("administrator_rights", static_cast<const BaseObject *>(administrator_rights_.get()));
    s.store_class_end();
  }
}

internalLinkTypeBotStart::internalLinkTypeBotStart()
  : bot_username_()
  , start_parameter_()
  , autostart_()
{}

internalLinkTypeBotStart::internalLinkTypeBotStart(string const &bot_username_, string const &start_parameter_, bool autostart_)
  : bot_username_(bot_username_)
  , start_parameter_(start_parameter_)
  , autostart_(autostart_)
{}

const std::int32_t internalLinkTypeBotStart::ID;

void internalLinkTypeBotStart::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeBotStart");
    s.store_field("bot_username", bot_username_);
    s.store_field("start_parameter", start_parameter_);
    s.store_field("autostart", autostart_);
    s.store_class_end();
  }
}

internalLinkTypeBotStartInGroup::internalLinkTypeBotStartInGroup()
  : bot_username_()
  , start_parameter_()
  , administrator_rights_()
{}

internalLinkTypeBotStartInGroup::internalLinkTypeBotStartInGroup(string const &bot_username_, string const &start_parameter_, object_ptr<chatAdministratorRights> &&administrator_rights_)
  : bot_username_(bot_username_)
  , start_parameter_(start_parameter_)
  , administrator_rights_(std::move(administrator_rights_))
{}

const std::int32_t internalLinkTypeBotStartInGroup::ID;

void internalLinkTypeBotStartInGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeBotStartInGroup");
    s.store_field("bot_username", bot_username_);
    s.store_field("start_parameter", start_parameter_);
    s.store_object_field("administrator_rights", static_cast<const BaseObject *>(administrator_rights_.get()));
    s.store_class_end();
  }
}

internalLinkTypeBusinessChat::internalLinkTypeBusinessChat()
  : link_name_()
{}

internalLinkTypeBusinessChat::internalLinkTypeBusinessChat(string const &link_name_)
  : link_name_(link_name_)
{}

const std::int32_t internalLinkTypeBusinessChat::ID;

void internalLinkTypeBusinessChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeBusinessChat");
    s.store_field("link_name", link_name_);
    s.store_class_end();
  }
}

internalLinkTypeBuyStars::internalLinkTypeBuyStars()
  : star_count_()
  , purpose_()
{}

internalLinkTypeBuyStars::internalLinkTypeBuyStars(int53 star_count_, string const &purpose_)
  : star_count_(star_count_)
  , purpose_(purpose_)
{}

const std::int32_t internalLinkTypeBuyStars::ID;

void internalLinkTypeBuyStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeBuyStars");
    s.store_field("star_count", star_count_);
    s.store_field("purpose", purpose_);
    s.store_class_end();
  }
}

internalLinkTypeChangePhoneNumber::internalLinkTypeChangePhoneNumber() {
}

const std::int32_t internalLinkTypeChangePhoneNumber::ID;

void internalLinkTypeChangePhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeChangePhoneNumber");
    s.store_class_end();
  }
}

internalLinkTypeChatAffiliateProgram::internalLinkTypeChatAffiliateProgram()
  : username_()
  , referrer_()
{}

internalLinkTypeChatAffiliateProgram::internalLinkTypeChatAffiliateProgram(string const &username_, string const &referrer_)
  : username_(username_)
  , referrer_(referrer_)
{}

const std::int32_t internalLinkTypeChatAffiliateProgram::ID;

void internalLinkTypeChatAffiliateProgram::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeChatAffiliateProgram");
    s.store_field("username", username_);
    s.store_field("referrer", referrer_);
    s.store_class_end();
  }
}

internalLinkTypeChatBoost::internalLinkTypeChatBoost()
  : url_()
{}

internalLinkTypeChatBoost::internalLinkTypeChatBoost(string const &url_)
  : url_(url_)
{}

const std::int32_t internalLinkTypeChatBoost::ID;

void internalLinkTypeChatBoost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeChatBoost");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

internalLinkTypeChatFolderInvite::internalLinkTypeChatFolderInvite()
  : invite_link_()
{}

internalLinkTypeChatFolderInvite::internalLinkTypeChatFolderInvite(string const &invite_link_)
  : invite_link_(invite_link_)
{}

const std::int32_t internalLinkTypeChatFolderInvite::ID;

void internalLinkTypeChatFolderInvite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeChatFolderInvite");
    s.store_field("invite_link", invite_link_);
    s.store_class_end();
  }
}

internalLinkTypeChatFolderSettings::internalLinkTypeChatFolderSettings() {
}

const std::int32_t internalLinkTypeChatFolderSettings::ID;

void internalLinkTypeChatFolderSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeChatFolderSettings");
    s.store_class_end();
  }
}

internalLinkTypeChatInvite::internalLinkTypeChatInvite()
  : invite_link_()
{}

internalLinkTypeChatInvite::internalLinkTypeChatInvite(string const &invite_link_)
  : invite_link_(invite_link_)
{}

const std::int32_t internalLinkTypeChatInvite::ID;

void internalLinkTypeChatInvite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeChatInvite");
    s.store_field("invite_link", invite_link_);
    s.store_class_end();
  }
}

internalLinkTypeDefaultMessageAutoDeleteTimerSettings::internalLinkTypeDefaultMessageAutoDeleteTimerSettings() {
}

const std::int32_t internalLinkTypeDefaultMessageAutoDeleteTimerSettings::ID;

void internalLinkTypeDefaultMessageAutoDeleteTimerSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeDefaultMessageAutoDeleteTimerSettings");
    s.store_class_end();
  }
}

internalLinkTypeEditProfileSettings::internalLinkTypeEditProfileSettings() {
}

const std::int32_t internalLinkTypeEditProfileSettings::ID;

void internalLinkTypeEditProfileSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeEditProfileSettings");
    s.store_class_end();
  }
}

internalLinkTypeGame::internalLinkTypeGame()
  : bot_username_()
  , game_short_name_()
{}

internalLinkTypeGame::internalLinkTypeGame(string const &bot_username_, string const &game_short_name_)
  : bot_username_(bot_username_)
  , game_short_name_(game_short_name_)
{}

const std::int32_t internalLinkTypeGame::ID;

void internalLinkTypeGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeGame");
    s.store_field("bot_username", bot_username_);
    s.store_field("game_short_name", game_short_name_);
    s.store_class_end();
  }
}

internalLinkTypeInstantView::internalLinkTypeInstantView()
  : url_()
  , fallback_url_()
{}

internalLinkTypeInstantView::internalLinkTypeInstantView(string const &url_, string const &fallback_url_)
  : url_(url_)
  , fallback_url_(fallback_url_)
{}

const std::int32_t internalLinkTypeInstantView::ID;

void internalLinkTypeInstantView::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeInstantView");
    s.store_field("url", url_);
    s.store_field("fallback_url", fallback_url_);
    s.store_class_end();
  }
}

internalLinkTypeInvoice::internalLinkTypeInvoice()
  : invoice_name_()
{}

internalLinkTypeInvoice::internalLinkTypeInvoice(string const &invoice_name_)
  : invoice_name_(invoice_name_)
{}

const std::int32_t internalLinkTypeInvoice::ID;

void internalLinkTypeInvoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeInvoice");
    s.store_field("invoice_name", invoice_name_);
    s.store_class_end();
  }
}

internalLinkTypeLanguagePack::internalLinkTypeLanguagePack()
  : language_pack_id_()
{}

internalLinkTypeLanguagePack::internalLinkTypeLanguagePack(string const &language_pack_id_)
  : language_pack_id_(language_pack_id_)
{}

const std::int32_t internalLinkTypeLanguagePack::ID;

void internalLinkTypeLanguagePack::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeLanguagePack");
    s.store_field("language_pack_id", language_pack_id_);
    s.store_class_end();
  }
}

internalLinkTypeLanguageSettings::internalLinkTypeLanguageSettings() {
}

const std::int32_t internalLinkTypeLanguageSettings::ID;

void internalLinkTypeLanguageSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeLanguageSettings");
    s.store_class_end();
  }
}

internalLinkTypeMainWebApp::internalLinkTypeMainWebApp()
  : bot_username_()
  , start_parameter_()
  , mode_()
{}

internalLinkTypeMainWebApp::internalLinkTypeMainWebApp(string const &bot_username_, string const &start_parameter_, object_ptr<WebAppOpenMode> &&mode_)
  : bot_username_(bot_username_)
  , start_parameter_(start_parameter_)
  , mode_(std::move(mode_))
{}

const std::int32_t internalLinkTypeMainWebApp::ID;

void internalLinkTypeMainWebApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeMainWebApp");
    s.store_field("bot_username", bot_username_);
    s.store_field("start_parameter", start_parameter_);
    s.store_object_field("mode", static_cast<const BaseObject *>(mode_.get()));
    s.store_class_end();
  }
}

internalLinkTypeMessage::internalLinkTypeMessage()
  : url_()
{}

internalLinkTypeMessage::internalLinkTypeMessage(string const &url_)
  : url_(url_)
{}

const std::int32_t internalLinkTypeMessage::ID;

void internalLinkTypeMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeMessage");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

internalLinkTypeMessageDraft::internalLinkTypeMessageDraft()
  : text_()
  , contains_link_()
{}

internalLinkTypeMessageDraft::internalLinkTypeMessageDraft(object_ptr<formattedText> &&text_, bool contains_link_)
  : text_(std::move(text_))
  , contains_link_(contains_link_)
{}

const std::int32_t internalLinkTypeMessageDraft::ID;

void internalLinkTypeMessageDraft::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeMessageDraft");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("contains_link", contains_link_);
    s.store_class_end();
  }
}

internalLinkTypePassportDataRequest::internalLinkTypePassportDataRequest()
  : bot_user_id_()
  , scope_()
  , public_key_()
  , nonce_()
  , callback_url_()
{}

internalLinkTypePassportDataRequest::internalLinkTypePassportDataRequest(int53 bot_user_id_, string const &scope_, string const &public_key_, string const &nonce_, string const &callback_url_)
  : bot_user_id_(bot_user_id_)
  , scope_(scope_)
  , public_key_(public_key_)
  , nonce_(nonce_)
  , callback_url_(callback_url_)
{}

const std::int32_t internalLinkTypePassportDataRequest::ID;

void internalLinkTypePassportDataRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypePassportDataRequest");
    s.store_field("bot_user_id", bot_user_id_);
    s.store_field("scope", scope_);
    s.store_field("public_key", public_key_);
    s.store_field("nonce", nonce_);
    s.store_field("callback_url", callback_url_);
    s.store_class_end();
  }
}

internalLinkTypePhoneNumberConfirmation::internalLinkTypePhoneNumberConfirmation()
  : hash_()
  , phone_number_()
{}

internalLinkTypePhoneNumberConfirmation::internalLinkTypePhoneNumberConfirmation(string const &hash_, string const &phone_number_)
  : hash_(hash_)
  , phone_number_(phone_number_)
{}

const std::int32_t internalLinkTypePhoneNumberConfirmation::ID;

void internalLinkTypePhoneNumberConfirmation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypePhoneNumberConfirmation");
    s.store_field("hash", hash_);
    s.store_field("phone_number", phone_number_);
    s.store_class_end();
  }
}

internalLinkTypePremiumFeatures::internalLinkTypePremiumFeatures()
  : referrer_()
{}

internalLinkTypePremiumFeatures::internalLinkTypePremiumFeatures(string const &referrer_)
  : referrer_(referrer_)
{}

const std::int32_t internalLinkTypePremiumFeatures::ID;

void internalLinkTypePremiumFeatures::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypePremiumFeatures");
    s.store_field("referrer", referrer_);
    s.store_class_end();
  }
}

internalLinkTypePremiumGift::internalLinkTypePremiumGift()
  : referrer_()
{}

internalLinkTypePremiumGift::internalLinkTypePremiumGift(string const &referrer_)
  : referrer_(referrer_)
{}

const std::int32_t internalLinkTypePremiumGift::ID;

void internalLinkTypePremiumGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypePremiumGift");
    s.store_field("referrer", referrer_);
    s.store_class_end();
  }
}

internalLinkTypePremiumGiftCode::internalLinkTypePremiumGiftCode()
  : code_()
{}

internalLinkTypePremiumGiftCode::internalLinkTypePremiumGiftCode(string const &code_)
  : code_(code_)
{}

const std::int32_t internalLinkTypePremiumGiftCode::ID;

void internalLinkTypePremiumGiftCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypePremiumGiftCode");
    s.store_field("code", code_);
    s.store_class_end();
  }
}

internalLinkTypePrivacyAndSecuritySettings::internalLinkTypePrivacyAndSecuritySettings() {
}

const std::int32_t internalLinkTypePrivacyAndSecuritySettings::ID;

void internalLinkTypePrivacyAndSecuritySettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypePrivacyAndSecuritySettings");
    s.store_class_end();
  }
}

internalLinkTypeProxy::internalLinkTypeProxy()
  : server_()
  , port_()
  , type_()
{}

internalLinkTypeProxy::internalLinkTypeProxy(string const &server_, int32 port_, object_ptr<ProxyType> &&type_)
  : server_(server_)
  , port_(port_)
  , type_(std::move(type_))
{}

const std::int32_t internalLinkTypeProxy::ID;

void internalLinkTypeProxy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeProxy");
    s.store_field("server", server_);
    s.store_field("port", port_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

internalLinkTypePublicChat::internalLinkTypePublicChat()
  : chat_username_()
  , draft_text_()
  , open_profile_()
{}

internalLinkTypePublicChat::internalLinkTypePublicChat(string const &chat_username_, string const &draft_text_, bool open_profile_)
  : chat_username_(chat_username_)
  , draft_text_(draft_text_)
  , open_profile_(open_profile_)
{}

const std::int32_t internalLinkTypePublicChat::ID;

void internalLinkTypePublicChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypePublicChat");
    s.store_field("chat_username", chat_username_);
    s.store_field("draft_text", draft_text_);
    s.store_field("open_profile", open_profile_);
    s.store_class_end();
  }
}

internalLinkTypeQrCodeAuthentication::internalLinkTypeQrCodeAuthentication() {
}

const std::int32_t internalLinkTypeQrCodeAuthentication::ID;

void internalLinkTypeQrCodeAuthentication::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeQrCodeAuthentication");
    s.store_class_end();
  }
}

internalLinkTypeRestorePurchases::internalLinkTypeRestorePurchases() {
}

const std::int32_t internalLinkTypeRestorePurchases::ID;

void internalLinkTypeRestorePurchases::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeRestorePurchases");
    s.store_class_end();
  }
}

internalLinkTypeSettings::internalLinkTypeSettings() {
}

const std::int32_t internalLinkTypeSettings::ID;

void internalLinkTypeSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeSettings");
    s.store_class_end();
  }
}

internalLinkTypeStickerSet::internalLinkTypeStickerSet()
  : sticker_set_name_()
  , expect_custom_emoji_()
{}

internalLinkTypeStickerSet::internalLinkTypeStickerSet(string const &sticker_set_name_, bool expect_custom_emoji_)
  : sticker_set_name_(sticker_set_name_)
  , expect_custom_emoji_(expect_custom_emoji_)
{}

const std::int32_t internalLinkTypeStickerSet::ID;

void internalLinkTypeStickerSet::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeStickerSet");
    s.store_field("sticker_set_name", sticker_set_name_);
    s.store_field("expect_custom_emoji", expect_custom_emoji_);
    s.store_class_end();
  }
}

internalLinkTypeStory::internalLinkTypeStory()
  : story_sender_username_()
  , story_id_()
{}

internalLinkTypeStory::internalLinkTypeStory(string const &story_sender_username_, int32 story_id_)
  : story_sender_username_(story_sender_username_)
  , story_id_(story_id_)
{}

const std::int32_t internalLinkTypeStory::ID;

void internalLinkTypeStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeStory");
    s.store_field("story_sender_username", story_sender_username_);
    s.store_field("story_id", story_id_);
    s.store_class_end();
  }
}

internalLinkTypeTheme::internalLinkTypeTheme()
  : theme_name_()
{}

internalLinkTypeTheme::internalLinkTypeTheme(string const &theme_name_)
  : theme_name_(theme_name_)
{}

const std::int32_t internalLinkTypeTheme::ID;

void internalLinkTypeTheme::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeTheme");
    s.store_field("theme_name", theme_name_);
    s.store_class_end();
  }
}

internalLinkTypeThemeSettings::internalLinkTypeThemeSettings() {
}

const std::int32_t internalLinkTypeThemeSettings::ID;

void internalLinkTypeThemeSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeThemeSettings");
    s.store_class_end();
  }
}

internalLinkTypeUnknownDeepLink::internalLinkTypeUnknownDeepLink()
  : link_()
{}

internalLinkTypeUnknownDeepLink::internalLinkTypeUnknownDeepLink(string const &link_)
  : link_(link_)
{}

const std::int32_t internalLinkTypeUnknownDeepLink::ID;

void internalLinkTypeUnknownDeepLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeUnknownDeepLink");
    s.store_field("link", link_);
    s.store_class_end();
  }
}

internalLinkTypeUnsupportedProxy::internalLinkTypeUnsupportedProxy() {
}

const std::int32_t internalLinkTypeUnsupportedProxy::ID;

void internalLinkTypeUnsupportedProxy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeUnsupportedProxy");
    s.store_class_end();
  }
}

internalLinkTypeUpgradedGift::internalLinkTypeUpgradedGift()
  : name_()
{}

internalLinkTypeUpgradedGift::internalLinkTypeUpgradedGift(string const &name_)
  : name_(name_)
{}

const std::int32_t internalLinkTypeUpgradedGift::ID;

void internalLinkTypeUpgradedGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeUpgradedGift");
    s.store_field("name", name_);
    s.store_class_end();
  }
}

internalLinkTypeUserPhoneNumber::internalLinkTypeUserPhoneNumber()
  : phone_number_()
  , draft_text_()
  , open_profile_()
{}

internalLinkTypeUserPhoneNumber::internalLinkTypeUserPhoneNumber(string const &phone_number_, string const &draft_text_, bool open_profile_)
  : phone_number_(phone_number_)
  , draft_text_(draft_text_)
  , open_profile_(open_profile_)
{}

const std::int32_t internalLinkTypeUserPhoneNumber::ID;

void internalLinkTypeUserPhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeUserPhoneNumber");
    s.store_field("phone_number", phone_number_);
    s.store_field("draft_text", draft_text_);
    s.store_field("open_profile", open_profile_);
    s.store_class_end();
  }
}

internalLinkTypeUserToken::internalLinkTypeUserToken()
  : token_()
{}

internalLinkTypeUserToken::internalLinkTypeUserToken(string const &token_)
  : token_(token_)
{}

const std::int32_t internalLinkTypeUserToken::ID;

void internalLinkTypeUserToken::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeUserToken");
    s.store_field("token", token_);
    s.store_class_end();
  }
}

internalLinkTypeVideoChat::internalLinkTypeVideoChat()
  : chat_username_()
  , invite_hash_()
  , is_live_stream_()
{}

internalLinkTypeVideoChat::internalLinkTypeVideoChat(string const &chat_username_, string const &invite_hash_, bool is_live_stream_)
  : chat_username_(chat_username_)
  , invite_hash_(invite_hash_)
  , is_live_stream_(is_live_stream_)
{}

const std::int32_t internalLinkTypeVideoChat::ID;

void internalLinkTypeVideoChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeVideoChat");
    s.store_field("chat_username", chat_username_);
    s.store_field("invite_hash", invite_hash_);
    s.store_field("is_live_stream", is_live_stream_);
    s.store_class_end();
  }
}

internalLinkTypeWebApp::internalLinkTypeWebApp()
  : bot_username_()
  , web_app_short_name_()
  , start_parameter_()
  , mode_()
{}

internalLinkTypeWebApp::internalLinkTypeWebApp(string const &bot_username_, string const &web_app_short_name_, string const &start_parameter_, object_ptr<WebAppOpenMode> &&mode_)
  : bot_username_(bot_username_)
  , web_app_short_name_(web_app_short_name_)
  , start_parameter_(start_parameter_)
  , mode_(std::move(mode_))
{}

const std::int32_t internalLinkTypeWebApp::ID;

void internalLinkTypeWebApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "internalLinkTypeWebApp");
    s.store_field("bot_username", bot_username_);
    s.store_field("web_app_short_name", web_app_short_name_);
    s.store_field("start_parameter", start_parameter_);
    s.store_object_field("mode", static_cast<const BaseObject *>(mode_.get()));
    s.store_class_end();
  }
}

inviteLinkChatTypeBasicGroup::inviteLinkChatTypeBasicGroup() {
}

const std::int32_t inviteLinkChatTypeBasicGroup::ID;

void inviteLinkChatTypeBasicGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inviteLinkChatTypeBasicGroup");
    s.store_class_end();
  }
}

inviteLinkChatTypeSupergroup::inviteLinkChatTypeSupergroup() {
}

const std::int32_t inviteLinkChatTypeSupergroup::ID;

void inviteLinkChatTypeSupergroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inviteLinkChatTypeSupergroup");
    s.store_class_end();
  }
}

inviteLinkChatTypeChannel::inviteLinkChatTypeChannel() {
}

const std::int32_t inviteLinkChatTypeChannel::ID;

void inviteLinkChatTypeChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "inviteLinkChatTypeChannel");
    s.store_class_end();
  }
}

invoice::invoice()
  : currency_()
  , price_parts_()
  , subscription_period_()
  , max_tip_amount_()
  , suggested_tip_amounts_()
  , recurring_payment_terms_of_service_url_()
  , terms_of_service_url_()
  , is_test_()
  , need_name_()
  , need_phone_number_()
  , need_email_address_()
  , need_shipping_address_()
  , send_phone_number_to_provider_()
  , send_email_address_to_provider_()
  , is_flexible_()
{}

invoice::invoice(string const &currency_, array<object_ptr<labeledPricePart>> &&price_parts_, int32 subscription_period_, int53 max_tip_amount_, array<int53> &&suggested_tip_amounts_, string const &recurring_payment_terms_of_service_url_, string const &terms_of_service_url_, bool is_test_, bool need_name_, bool need_phone_number_, bool need_email_address_, bool need_shipping_address_, bool send_phone_number_to_provider_, bool send_email_address_to_provider_, bool is_flexible_)
  : currency_(currency_)
  , price_parts_(std::move(price_parts_))
  , subscription_period_(subscription_period_)
  , max_tip_amount_(max_tip_amount_)
  , suggested_tip_amounts_(std::move(suggested_tip_amounts_))
  , recurring_payment_terms_of_service_url_(recurring_payment_terms_of_service_url_)
  , terms_of_service_url_(terms_of_service_url_)
  , is_test_(is_test_)
  , need_name_(need_name_)
  , need_phone_number_(need_phone_number_)
  , need_email_address_(need_email_address_)
  , need_shipping_address_(need_shipping_address_)
  , send_phone_number_to_provider_(send_phone_number_to_provider_)
  , send_email_address_to_provider_(send_email_address_to_provider_)
  , is_flexible_(is_flexible_)
{}

const std::int32_t invoice::ID;

void invoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "invoice");
    s.store_field("currency", currency_);
    { s.store_vector_begin("price_parts", price_parts_.size()); for (const auto &_value : price_parts_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("subscription_period", subscription_period_);
    s.store_field("max_tip_amount", max_tip_amount_);
    { s.store_vector_begin("suggested_tip_amounts", suggested_tip_amounts_.size()); for (const auto &_value : suggested_tip_amounts_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("recurring_payment_terms_of_service_url", recurring_payment_terms_of_service_url_);
    s.store_field("terms_of_service_url", terms_of_service_url_);
    s.store_field("is_test", is_test_);
    s.store_field("need_name", need_name_);
    s.store_field("need_phone_number", need_phone_number_);
    s.store_field("need_email_address", need_email_address_);
    s.store_field("need_shipping_address", need_shipping_address_);
    s.store_field("send_phone_number_to_provider", send_phone_number_to_provider_);
    s.store_field("send_email_address_to_provider", send_email_address_to_provider_);
    s.store_field("is_flexible", is_flexible_);
    s.store_class_end();
  }
}

jsonObjectMember::jsonObjectMember()
  : key_()
  , value_()
{}

jsonObjectMember::jsonObjectMember(string const &key_, object_ptr<JsonValue> &&value_)
  : key_(key_)
  , value_(std::move(value_))
{}

const std::int32_t jsonObjectMember::ID;

void jsonObjectMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonObjectMember");
    s.store_field("key", key_);
    s.store_object_field("value", static_cast<const BaseObject *>(value_.get()));
    s.store_class_end();
  }
}

jsonValueNull::jsonValueNull() {
}

const std::int32_t jsonValueNull::ID;

void jsonValueNull::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonValueNull");
    s.store_class_end();
  }
}

jsonValueBoolean::jsonValueBoolean()
  : value_()
{}

jsonValueBoolean::jsonValueBoolean(bool value_)
  : value_(value_)
{}

const std::int32_t jsonValueBoolean::ID;

void jsonValueBoolean::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonValueBoolean");
    s.store_field("value", value_);
    s.store_class_end();
  }
}

jsonValueNumber::jsonValueNumber()
  : value_()
{}

jsonValueNumber::jsonValueNumber(double value_)
  : value_(value_)
{}

const std::int32_t jsonValueNumber::ID;

void jsonValueNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonValueNumber");
    s.store_field("value", value_);
    s.store_class_end();
  }
}

jsonValueString::jsonValueString()
  : value_()
{}

jsonValueString::jsonValueString(string const &value_)
  : value_(value_)
{}

const std::int32_t jsonValueString::ID;

void jsonValueString::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonValueString");
    s.store_field("value", value_);
    s.store_class_end();
  }
}

jsonValueArray::jsonValueArray()
  : values_()
{}

jsonValueArray::jsonValueArray(array<object_ptr<JsonValue>> &&values_)
  : values_(std::move(values_))
{}

const std::int32_t jsonValueArray::ID;

void jsonValueArray::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonValueArray");
    { s.store_vector_begin("values", values_.size()); for (const auto &_value : values_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

jsonValueObject::jsonValueObject()
  : members_()
{}

jsonValueObject::jsonValueObject(array<object_ptr<jsonObjectMember>> &&members_)
  : members_(std::move(members_))
{}

const std::int32_t jsonValueObject::ID;

void jsonValueObject::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "jsonValueObject");
    { s.store_vector_begin("members", members_.size()); for (const auto &_value : members_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

keyboardButton::keyboardButton()
  : text_()
  , type_()
{}

keyboardButton::keyboardButton(string const &text_, object_ptr<KeyboardButtonType> &&type_)
  : text_(text_)
  , type_(std::move(type_))
{}

const std::int32_t keyboardButton::ID;

void keyboardButton::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButton");
    s.store_field("text", text_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

keyboardButtonTypeText::keyboardButtonTypeText() {
}

const std::int32_t keyboardButtonTypeText::ID;

void keyboardButtonTypeText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonTypeText");
    s.store_class_end();
  }
}

keyboardButtonTypeRequestPhoneNumber::keyboardButtonTypeRequestPhoneNumber() {
}

const std::int32_t keyboardButtonTypeRequestPhoneNumber::ID;

void keyboardButtonTypeRequestPhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonTypeRequestPhoneNumber");
    s.store_class_end();
  }
}

keyboardButtonTypeRequestLocation::keyboardButtonTypeRequestLocation() {
}

const std::int32_t keyboardButtonTypeRequestLocation::ID;

void keyboardButtonTypeRequestLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonTypeRequestLocation");
    s.store_class_end();
  }
}

keyboardButtonTypeRequestPoll::keyboardButtonTypeRequestPoll()
  : force_regular_()
  , force_quiz_()
{}

keyboardButtonTypeRequestPoll::keyboardButtonTypeRequestPoll(bool force_regular_, bool force_quiz_)
  : force_regular_(force_regular_)
  , force_quiz_(force_quiz_)
{}

const std::int32_t keyboardButtonTypeRequestPoll::ID;

void keyboardButtonTypeRequestPoll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonTypeRequestPoll");
    s.store_field("force_regular", force_regular_);
    s.store_field("force_quiz", force_quiz_);
    s.store_class_end();
  }
}

keyboardButtonTypeRequestUsers::keyboardButtonTypeRequestUsers()
  : id_()
  , restrict_user_is_bot_()
  , user_is_bot_()
  , restrict_user_is_premium_()
  , user_is_premium_()
  , max_quantity_()
  , request_name_()
  , request_username_()
  , request_photo_()
{}

keyboardButtonTypeRequestUsers::keyboardButtonTypeRequestUsers(int32 id_, bool restrict_user_is_bot_, bool user_is_bot_, bool restrict_user_is_premium_, bool user_is_premium_, int32 max_quantity_, bool request_name_, bool request_username_, bool request_photo_)
  : id_(id_)
  , restrict_user_is_bot_(restrict_user_is_bot_)
  , user_is_bot_(user_is_bot_)
  , restrict_user_is_premium_(restrict_user_is_premium_)
  , user_is_premium_(user_is_premium_)
  , max_quantity_(max_quantity_)
  , request_name_(request_name_)
  , request_username_(request_username_)
  , request_photo_(request_photo_)
{}

const std::int32_t keyboardButtonTypeRequestUsers::ID;

void keyboardButtonTypeRequestUsers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonTypeRequestUsers");
    s.store_field("id", id_);
    s.store_field("restrict_user_is_bot", restrict_user_is_bot_);
    s.store_field("user_is_bot", user_is_bot_);
    s.store_field("restrict_user_is_premium", restrict_user_is_premium_);
    s.store_field("user_is_premium", user_is_premium_);
    s.store_field("max_quantity", max_quantity_);
    s.store_field("request_name", request_name_);
    s.store_field("request_username", request_username_);
    s.store_field("request_photo", request_photo_);
    s.store_class_end();
  }
}

keyboardButtonTypeRequestChat::keyboardButtonTypeRequestChat()
  : id_()
  , chat_is_channel_()
  , restrict_chat_is_forum_()
  , chat_is_forum_()
  , restrict_chat_has_username_()
  , chat_has_username_()
  , chat_is_created_()
  , user_administrator_rights_()
  , bot_administrator_rights_()
  , bot_is_member_()
  , request_title_()
  , request_username_()
  , request_photo_()
{}

keyboardButtonTypeRequestChat::keyboardButtonTypeRequestChat(int32 id_, bool chat_is_channel_, bool restrict_chat_is_forum_, bool chat_is_forum_, bool restrict_chat_has_username_, bool chat_has_username_, bool chat_is_created_, object_ptr<chatAdministratorRights> &&user_administrator_rights_, object_ptr<chatAdministratorRights> &&bot_administrator_rights_, bool bot_is_member_, bool request_title_, bool request_username_, bool request_photo_)
  : id_(id_)
  , chat_is_channel_(chat_is_channel_)
  , restrict_chat_is_forum_(restrict_chat_is_forum_)
  , chat_is_forum_(chat_is_forum_)
  , restrict_chat_has_username_(restrict_chat_has_username_)
  , chat_has_username_(chat_has_username_)
  , chat_is_created_(chat_is_created_)
  , user_administrator_rights_(std::move(user_administrator_rights_))
  , bot_administrator_rights_(std::move(bot_administrator_rights_))
  , bot_is_member_(bot_is_member_)
  , request_title_(request_title_)
  , request_username_(request_username_)
  , request_photo_(request_photo_)
{}

const std::int32_t keyboardButtonTypeRequestChat::ID;

void keyboardButtonTypeRequestChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonTypeRequestChat");
    s.store_field("id", id_);
    s.store_field("chat_is_channel", chat_is_channel_);
    s.store_field("restrict_chat_is_forum", restrict_chat_is_forum_);
    s.store_field("chat_is_forum", chat_is_forum_);
    s.store_field("restrict_chat_has_username", restrict_chat_has_username_);
    s.store_field("chat_has_username", chat_has_username_);
    s.store_field("chat_is_created", chat_is_created_);
    s.store_object_field("user_administrator_rights", static_cast<const BaseObject *>(user_administrator_rights_.get()));
    s.store_object_field("bot_administrator_rights", static_cast<const BaseObject *>(bot_administrator_rights_.get()));
    s.store_field("bot_is_member", bot_is_member_);
    s.store_field("request_title", request_title_);
    s.store_field("request_username", request_username_);
    s.store_field("request_photo", request_photo_);
    s.store_class_end();
  }
}

keyboardButtonTypeWebApp::keyboardButtonTypeWebApp()
  : url_()
{}

keyboardButtonTypeWebApp::keyboardButtonTypeWebApp(string const &url_)
  : url_(url_)
{}

const std::int32_t keyboardButtonTypeWebApp::ID;

void keyboardButtonTypeWebApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "keyboardButtonTypeWebApp");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

labeledPricePart::labeledPricePart()
  : label_()
  , amount_()
{}

labeledPricePart::labeledPricePart(string const &label_, int53 amount_)
  : label_(label_)
  , amount_(amount_)
{}

const std::int32_t labeledPricePart::ID;

void labeledPricePart::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "labeledPricePart");
    s.store_field("label", label_);
    s.store_field("amount", amount_);
    s.store_class_end();
  }
}

languagePackInfo::languagePackInfo()
  : id_()
  , base_language_pack_id_()
  , name_()
  , native_name_()
  , plural_code_()
  , is_official_()
  , is_rtl_()
  , is_beta_()
  , is_installed_()
  , total_string_count_()
  , translated_string_count_()
  , local_string_count_()
  , translation_url_()
{}

languagePackInfo::languagePackInfo(string const &id_, string const &base_language_pack_id_, string const &name_, string const &native_name_, string const &plural_code_, bool is_official_, bool is_rtl_, bool is_beta_, bool is_installed_, int32 total_string_count_, int32 translated_string_count_, int32 local_string_count_, string const &translation_url_)
  : id_(id_)
  , base_language_pack_id_(base_language_pack_id_)
  , name_(name_)
  , native_name_(native_name_)
  , plural_code_(plural_code_)
  , is_official_(is_official_)
  , is_rtl_(is_rtl_)
  , is_beta_(is_beta_)
  , is_installed_(is_installed_)
  , total_string_count_(total_string_count_)
  , translated_string_count_(translated_string_count_)
  , local_string_count_(local_string_count_)
  , translation_url_(translation_url_)
{}

const std::int32_t languagePackInfo::ID;

void languagePackInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "languagePackInfo");
    s.store_field("id", id_);
    s.store_field("base_language_pack_id", base_language_pack_id_);
    s.store_field("name", name_);
    s.store_field("native_name", native_name_);
    s.store_field("plural_code", plural_code_);
    s.store_field("is_official", is_official_);
    s.store_field("is_rtl", is_rtl_);
    s.store_field("is_beta", is_beta_);
    s.store_field("is_installed", is_installed_);
    s.store_field("total_string_count", total_string_count_);
    s.store_field("translated_string_count", translated_string_count_);
    s.store_field("local_string_count", local_string_count_);
    s.store_field("translation_url", translation_url_);
    s.store_class_end();
  }
}

languagePackString::languagePackString()
  : key_()
  , value_()
{}

languagePackString::languagePackString(string const &key_, object_ptr<LanguagePackStringValue> &&value_)
  : key_(key_)
  , value_(std::move(value_))
{}

const std::int32_t languagePackString::ID;

void languagePackString::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "languagePackString");
    s.store_field("key", key_);
    s.store_object_field("value", static_cast<const BaseObject *>(value_.get()));
    s.store_class_end();
  }
}

languagePackStringValueOrdinary::languagePackStringValueOrdinary()
  : value_()
{}

languagePackStringValueOrdinary::languagePackStringValueOrdinary(string const &value_)
  : value_(value_)
{}

const std::int32_t languagePackStringValueOrdinary::ID;

void languagePackStringValueOrdinary::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "languagePackStringValueOrdinary");
    s.store_field("value", value_);
    s.store_class_end();
  }
}

languagePackStringValuePluralized::languagePackStringValuePluralized()
  : zero_value_()
  , one_value_()
  , two_value_()
  , few_value_()
  , many_value_()
  , other_value_()
{}

languagePackStringValuePluralized::languagePackStringValuePluralized(string const &zero_value_, string const &one_value_, string const &two_value_, string const &few_value_, string const &many_value_, string const &other_value_)
  : zero_value_(zero_value_)
  , one_value_(one_value_)
  , two_value_(two_value_)
  , few_value_(few_value_)
  , many_value_(many_value_)
  , other_value_(other_value_)
{}

const std::int32_t languagePackStringValuePluralized::ID;

void languagePackStringValuePluralized::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "languagePackStringValuePluralized");
    s.store_field("zero_value", zero_value_);
    s.store_field("one_value", one_value_);
    s.store_field("two_value", two_value_);
    s.store_field("few_value", few_value_);
    s.store_field("many_value", many_value_);
    s.store_field("other_value", other_value_);
    s.store_class_end();
  }
}

languagePackStringValueDeleted::languagePackStringValueDeleted() {
}

const std::int32_t languagePackStringValueDeleted::ID;

void languagePackStringValueDeleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "languagePackStringValueDeleted");
    s.store_class_end();
  }
}

languagePackStrings::languagePackStrings()
  : strings_()
{}

languagePackStrings::languagePackStrings(array<object_ptr<languagePackString>> &&strings_)
  : strings_(std::move(strings_))
{}

const std::int32_t languagePackStrings::ID;

void languagePackStrings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "languagePackStrings");
    { s.store_vector_begin("strings", strings_.size()); for (const auto &_value : strings_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

linkPreview::linkPreview()
  : url_()
  , display_url_()
  , site_name_()
  , title_()
  , description_()
  , author_()
  , type_()
  , has_large_media_()
  , show_large_media_()
  , show_media_above_description_()
  , skip_confirmation_()
  , show_above_text_()
  , instant_view_version_()
{}

linkPreview::linkPreview(string const &url_, string const &display_url_, string const &site_name_, string const &title_, object_ptr<formattedText> &&description_, string const &author_, object_ptr<LinkPreviewType> &&type_, bool has_large_media_, bool show_large_media_, bool show_media_above_description_, bool skip_confirmation_, bool show_above_text_, int32 instant_view_version_)
  : url_(url_)
  , display_url_(display_url_)
  , site_name_(site_name_)
  , title_(title_)
  , description_(std::move(description_))
  , author_(author_)
  , type_(std::move(type_))
  , has_large_media_(has_large_media_)
  , show_large_media_(show_large_media_)
  , show_media_above_description_(show_media_above_description_)
  , skip_confirmation_(skip_confirmation_)
  , show_above_text_(show_above_text_)
  , instant_view_version_(instant_view_version_)
{}

const std::int32_t linkPreview::ID;

void linkPreview::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreview");
    s.store_field("url", url_);
    s.store_field("display_url", display_url_);
    s.store_field("site_name", site_name_);
    s.store_field("title", title_);
    s.store_object_field("description", static_cast<const BaseObject *>(description_.get()));
    s.store_field("author", author_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("has_large_media", has_large_media_);
    s.store_field("show_large_media", show_large_media_);
    s.store_field("show_media_above_description", show_media_above_description_);
    s.store_field("skip_confirmation", skip_confirmation_);
    s.store_field("show_above_text", show_above_text_);
    s.store_field("instant_view_version", instant_view_version_);
    s.store_class_end();
  }
}

linkPreviewAlbumMediaPhoto::linkPreviewAlbumMediaPhoto()
  : photo_()
{}

linkPreviewAlbumMediaPhoto::linkPreviewAlbumMediaPhoto(object_ptr<photo> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t linkPreviewAlbumMediaPhoto::ID;

void linkPreviewAlbumMediaPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewAlbumMediaPhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

linkPreviewAlbumMediaVideo::linkPreviewAlbumMediaVideo()
  : video_()
{}

linkPreviewAlbumMediaVideo::linkPreviewAlbumMediaVideo(object_ptr<video> &&video_)
  : video_(std::move(video_))
{}

const std::int32_t linkPreviewAlbumMediaVideo::ID;

void linkPreviewAlbumMediaVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewAlbumMediaVideo");
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_class_end();
  }
}

linkPreviewOptions::linkPreviewOptions()
  : is_disabled_()
  , url_()
  , force_small_media_()
  , force_large_media_()
  , show_above_text_()
{}

linkPreviewOptions::linkPreviewOptions(bool is_disabled_, string const &url_, bool force_small_media_, bool force_large_media_, bool show_above_text_)
  : is_disabled_(is_disabled_)
  , url_(url_)
  , force_small_media_(force_small_media_)
  , force_large_media_(force_large_media_)
  , show_above_text_(show_above_text_)
{}

const std::int32_t linkPreviewOptions::ID;

void linkPreviewOptions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewOptions");
    s.store_field("is_disabled", is_disabled_);
    s.store_field("url", url_);
    s.store_field("force_small_media", force_small_media_);
    s.store_field("force_large_media", force_large_media_);
    s.store_field("show_above_text", show_above_text_);
    s.store_class_end();
  }
}

linkPreviewTypeAlbum::linkPreviewTypeAlbum()
  : media_()
  , caption_()
{}

linkPreviewTypeAlbum::linkPreviewTypeAlbum(array<object_ptr<LinkPreviewAlbumMedia>> &&media_, string const &caption_)
  : media_(std::move(media_))
  , caption_(caption_)
{}

const std::int32_t linkPreviewTypeAlbum::ID;

void linkPreviewTypeAlbum::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeAlbum");
    { s.store_vector_begin("media", media_.size()); for (const auto &_value : media_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("caption", caption_);
    s.store_class_end();
  }
}

linkPreviewTypeAnimation::linkPreviewTypeAnimation()
  : animation_()
{}

linkPreviewTypeAnimation::linkPreviewTypeAnimation(object_ptr<animation> &&animation_)
  : animation_(std::move(animation_))
{}

const std::int32_t linkPreviewTypeAnimation::ID;

void linkPreviewTypeAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeAnimation");
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeApp::linkPreviewTypeApp()
  : photo_()
{}

linkPreviewTypeApp::linkPreviewTypeApp(object_ptr<photo> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t linkPreviewTypeApp::ID;

void linkPreviewTypeApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeApp");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeArticle::linkPreviewTypeArticle()
  : photo_()
{}

linkPreviewTypeArticle::linkPreviewTypeArticle(object_ptr<photo> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t linkPreviewTypeArticle::ID;

void linkPreviewTypeArticle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeArticle");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeAudio::linkPreviewTypeAudio()
  : audio_()
{}

linkPreviewTypeAudio::linkPreviewTypeAudio(object_ptr<audio> &&audio_)
  : audio_(std::move(audio_))
{}

const std::int32_t linkPreviewTypeAudio::ID;

void linkPreviewTypeAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeAudio");
    s.store_object_field("audio", static_cast<const BaseObject *>(audio_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeBackground::linkPreviewTypeBackground()
  : document_()
  , background_type_()
{}

linkPreviewTypeBackground::linkPreviewTypeBackground(object_ptr<document> &&document_, object_ptr<BackgroundType> &&background_type_)
  : document_(std::move(document_))
  , background_type_(std::move(background_type_))
{}

const std::int32_t linkPreviewTypeBackground::ID;

void linkPreviewTypeBackground::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeBackground");
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_object_field("background_type", static_cast<const BaseObject *>(background_type_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeChannelBoost::linkPreviewTypeChannelBoost()
  : photo_()
{}

linkPreviewTypeChannelBoost::linkPreviewTypeChannelBoost(object_ptr<chatPhoto> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t linkPreviewTypeChannelBoost::ID;

void linkPreviewTypeChannelBoost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeChannelBoost");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeChat::linkPreviewTypeChat()
  : type_()
  , photo_()
  , creates_join_request_()
{}

linkPreviewTypeChat::linkPreviewTypeChat(object_ptr<InviteLinkChatType> &&type_, object_ptr<chatPhoto> &&photo_, bool creates_join_request_)
  : type_(std::move(type_))
  , photo_(std::move(photo_))
  , creates_join_request_(creates_join_request_)
{}

const std::int32_t linkPreviewTypeChat::ID;

void linkPreviewTypeChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeChat");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("creates_join_request", creates_join_request_);
    s.store_class_end();
  }
}

linkPreviewTypeDocument::linkPreviewTypeDocument()
  : document_()
{}

linkPreviewTypeDocument::linkPreviewTypeDocument(object_ptr<document> &&document_)
  : document_(std::move(document_))
{}

const std::int32_t linkPreviewTypeDocument::ID;

void linkPreviewTypeDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeDocument");
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeEmbeddedAnimationPlayer::linkPreviewTypeEmbeddedAnimationPlayer()
  : url_()
  , thumbnail_()
  , duration_()
  , width_()
  , height_()
{}

linkPreviewTypeEmbeddedAnimationPlayer::linkPreviewTypeEmbeddedAnimationPlayer(string const &url_, object_ptr<photo> &&thumbnail_, int32 duration_, int32 width_, int32 height_)
  : url_(url_)
  , thumbnail_(std::move(thumbnail_))
  , duration_(duration_)
  , width_(width_)
  , height_(height_)
{}

const std::int32_t linkPreviewTypeEmbeddedAnimationPlayer::ID;

void linkPreviewTypeEmbeddedAnimationPlayer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeEmbeddedAnimationPlayer");
    s.store_field("url", url_);
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_field("duration", duration_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_class_end();
  }
}

linkPreviewTypeEmbeddedAudioPlayer::linkPreviewTypeEmbeddedAudioPlayer()
  : url_()
  , thumbnail_()
  , duration_()
  , width_()
  , height_()
{}

linkPreviewTypeEmbeddedAudioPlayer::linkPreviewTypeEmbeddedAudioPlayer(string const &url_, object_ptr<photo> &&thumbnail_, int32 duration_, int32 width_, int32 height_)
  : url_(url_)
  , thumbnail_(std::move(thumbnail_))
  , duration_(duration_)
  , width_(width_)
  , height_(height_)
{}

const std::int32_t linkPreviewTypeEmbeddedAudioPlayer::ID;

void linkPreviewTypeEmbeddedAudioPlayer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeEmbeddedAudioPlayer");
    s.store_field("url", url_);
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_field("duration", duration_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_class_end();
  }
}

linkPreviewTypeEmbeddedVideoPlayer::linkPreviewTypeEmbeddedVideoPlayer()
  : url_()
  , thumbnail_()
  , duration_()
  , width_()
  , height_()
{}

linkPreviewTypeEmbeddedVideoPlayer::linkPreviewTypeEmbeddedVideoPlayer(string const &url_, object_ptr<photo> &&thumbnail_, int32 duration_, int32 width_, int32 height_)
  : url_(url_)
  , thumbnail_(std::move(thumbnail_))
  , duration_(duration_)
  , width_(width_)
  , height_(height_)
{}

const std::int32_t linkPreviewTypeEmbeddedVideoPlayer::ID;

void linkPreviewTypeEmbeddedVideoPlayer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeEmbeddedVideoPlayer");
    s.store_field("url", url_);
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_field("duration", duration_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_class_end();
  }
}

linkPreviewTypeExternalAudio::linkPreviewTypeExternalAudio()
  : url_()
  , mime_type_()
  , duration_()
{}

linkPreviewTypeExternalAudio::linkPreviewTypeExternalAudio(string const &url_, string const &mime_type_, int32 duration_)
  : url_(url_)
  , mime_type_(mime_type_)
  , duration_(duration_)
{}

const std::int32_t linkPreviewTypeExternalAudio::ID;

void linkPreviewTypeExternalAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeExternalAudio");
    s.store_field("url", url_);
    s.store_field("mime_type", mime_type_);
    s.store_field("duration", duration_);
    s.store_class_end();
  }
}

linkPreviewTypeExternalVideo::linkPreviewTypeExternalVideo()
  : url_()
  , mime_type_()
  , width_()
  , height_()
  , duration_()
{}

linkPreviewTypeExternalVideo::linkPreviewTypeExternalVideo(string const &url_, string const &mime_type_, int32 width_, int32 height_, int32 duration_)
  : url_(url_)
  , mime_type_(mime_type_)
  , width_(width_)
  , height_(height_)
  , duration_(duration_)
{}

const std::int32_t linkPreviewTypeExternalVideo::ID;

void linkPreviewTypeExternalVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeExternalVideo");
    s.store_field("url", url_);
    s.store_field("mime_type", mime_type_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_field("duration", duration_);
    s.store_class_end();
  }
}

linkPreviewTypeInvoice::linkPreviewTypeInvoice() {
}

const std::int32_t linkPreviewTypeInvoice::ID;

void linkPreviewTypeInvoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeInvoice");
    s.store_class_end();
  }
}

linkPreviewTypeMessage::linkPreviewTypeMessage() {
}

const std::int32_t linkPreviewTypeMessage::ID;

void linkPreviewTypeMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeMessage");
    s.store_class_end();
  }
}

linkPreviewTypePhoto::linkPreviewTypePhoto()
  : photo_()
{}

linkPreviewTypePhoto::linkPreviewTypePhoto(object_ptr<photo> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t linkPreviewTypePhoto::ID;

void linkPreviewTypePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypePhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

linkPreviewTypePremiumGiftCode::linkPreviewTypePremiumGiftCode() {
}

const std::int32_t linkPreviewTypePremiumGiftCode::ID;

void linkPreviewTypePremiumGiftCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypePremiumGiftCode");
    s.store_class_end();
  }
}

linkPreviewTypeShareableChatFolder::linkPreviewTypeShareableChatFolder() {
}

const std::int32_t linkPreviewTypeShareableChatFolder::ID;

void linkPreviewTypeShareableChatFolder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeShareableChatFolder");
    s.store_class_end();
  }
}

linkPreviewTypeSticker::linkPreviewTypeSticker()
  : sticker_()
{}

linkPreviewTypeSticker::linkPreviewTypeSticker(object_ptr<sticker> &&sticker_)
  : sticker_(std::move(sticker_))
{}

const std::int32_t linkPreviewTypeSticker::ID;

void linkPreviewTypeSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeSticker");
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeStickerSet::linkPreviewTypeStickerSet()
  : stickers_()
{}

linkPreviewTypeStickerSet::linkPreviewTypeStickerSet(array<object_ptr<sticker>> &&stickers_)
  : stickers_(std::move(stickers_))
{}

const std::int32_t linkPreviewTypeStickerSet::ID;

void linkPreviewTypeStickerSet::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeStickerSet");
    { s.store_vector_begin("stickers", stickers_.size()); for (const auto &_value : stickers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

linkPreviewTypeStory::linkPreviewTypeStory()
  : story_sender_chat_id_()
  , story_id_()
{}

linkPreviewTypeStory::linkPreviewTypeStory(int53 story_sender_chat_id_, int32 story_id_)
  : story_sender_chat_id_(story_sender_chat_id_)
  , story_id_(story_id_)
{}

const std::int32_t linkPreviewTypeStory::ID;

void linkPreviewTypeStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeStory");
    s.store_field("story_sender_chat_id", story_sender_chat_id_);
    s.store_field("story_id", story_id_);
    s.store_class_end();
  }
}

linkPreviewTypeSupergroupBoost::linkPreviewTypeSupergroupBoost()
  : photo_()
{}

linkPreviewTypeSupergroupBoost::linkPreviewTypeSupergroupBoost(object_ptr<chatPhoto> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t linkPreviewTypeSupergroupBoost::ID;

void linkPreviewTypeSupergroupBoost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeSupergroupBoost");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeTheme::linkPreviewTypeTheme()
  : documents_()
  , settings_()
{}

linkPreviewTypeTheme::linkPreviewTypeTheme(array<object_ptr<document>> &&documents_, object_ptr<themeSettings> &&settings_)
  : documents_(std::move(documents_))
  , settings_(std::move(settings_))
{}

const std::int32_t linkPreviewTypeTheme::ID;

void linkPreviewTypeTheme::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeTheme");
    { s.store_vector_begin("documents", documents_.size()); for (const auto &_value : documents_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("settings", static_cast<const BaseObject *>(settings_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeUnsupported::linkPreviewTypeUnsupported() {
}

const std::int32_t linkPreviewTypeUnsupported::ID;

void linkPreviewTypeUnsupported::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeUnsupported");
    s.store_class_end();
  }
}

linkPreviewTypeUpgradedGift::linkPreviewTypeUpgradedGift()
  : gift_()
{}

linkPreviewTypeUpgradedGift::linkPreviewTypeUpgradedGift(object_ptr<upgradedGift> &&gift_)
  : gift_(std::move(gift_))
{}

const std::int32_t linkPreviewTypeUpgradedGift::ID;

void linkPreviewTypeUpgradedGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeUpgradedGift");
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeUser::linkPreviewTypeUser()
  : photo_()
  , is_bot_()
{}

linkPreviewTypeUser::linkPreviewTypeUser(object_ptr<chatPhoto> &&photo_, bool is_bot_)
  : photo_(std::move(photo_))
  , is_bot_(is_bot_)
{}

const std::int32_t linkPreviewTypeUser::ID;

void linkPreviewTypeUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeUser");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("is_bot", is_bot_);
    s.store_class_end();
  }
}

linkPreviewTypeVideo::linkPreviewTypeVideo()
  : video_()
  , cover_()
  , start_timestamp_()
{}

linkPreviewTypeVideo::linkPreviewTypeVideo(object_ptr<video> &&video_, object_ptr<photo> &&cover_, int32 start_timestamp_)
  : video_(std::move(video_))
  , cover_(std::move(cover_))
  , start_timestamp_(start_timestamp_)
{}

const std::int32_t linkPreviewTypeVideo::ID;

void linkPreviewTypeVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeVideo");
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_object_field("cover", static_cast<const BaseObject *>(cover_.get()));
    s.store_field("start_timestamp", start_timestamp_);
    s.store_class_end();
  }
}

linkPreviewTypeVideoChat::linkPreviewTypeVideoChat()
  : photo_()
  , is_live_stream_()
{}

linkPreviewTypeVideoChat::linkPreviewTypeVideoChat(object_ptr<chatPhoto> &&photo_, bool is_live_stream_)
  : photo_(std::move(photo_))
  , is_live_stream_(is_live_stream_)
{}

const std::int32_t linkPreviewTypeVideoChat::ID;

void linkPreviewTypeVideoChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeVideoChat");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("is_live_stream", is_live_stream_);
    s.store_class_end();
  }
}

linkPreviewTypeVideoNote::linkPreviewTypeVideoNote()
  : video_note_()
{}

linkPreviewTypeVideoNote::linkPreviewTypeVideoNote(object_ptr<videoNote> &&video_note_)
  : video_note_(std::move(video_note_))
{}

const std::int32_t linkPreviewTypeVideoNote::ID;

void linkPreviewTypeVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeVideoNote");
    s.store_object_field("video_note", static_cast<const BaseObject *>(video_note_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeVoiceNote::linkPreviewTypeVoiceNote()
  : voice_note_()
{}

linkPreviewTypeVoiceNote::linkPreviewTypeVoiceNote(object_ptr<voiceNote> &&voice_note_)
  : voice_note_(std::move(voice_note_))
{}

const std::int32_t linkPreviewTypeVoiceNote::ID;

void linkPreviewTypeVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeVoiceNote");
    s.store_object_field("voice_note", static_cast<const BaseObject *>(voice_note_.get()));
    s.store_class_end();
  }
}

linkPreviewTypeWebApp::linkPreviewTypeWebApp()
  : photo_()
{}

linkPreviewTypeWebApp::linkPreviewTypeWebApp(object_ptr<photo> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t linkPreviewTypeWebApp::ID;

void linkPreviewTypeWebApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "linkPreviewTypeWebApp");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

localFile::localFile()
  : path_()
  , can_be_downloaded_()
  , can_be_deleted_()
  , is_downloading_active_()
  , is_downloading_completed_()
  , download_offset_()
  , downloaded_prefix_size_()
  , downloaded_size_()
{}

localFile::localFile(string const &path_, bool can_be_downloaded_, bool can_be_deleted_, bool is_downloading_active_, bool is_downloading_completed_, int53 download_offset_, int53 downloaded_prefix_size_, int53 downloaded_size_)
  : path_(path_)
  , can_be_downloaded_(can_be_downloaded_)
  , can_be_deleted_(can_be_deleted_)
  , is_downloading_active_(is_downloading_active_)
  , is_downloading_completed_(is_downloading_completed_)
  , download_offset_(download_offset_)
  , downloaded_prefix_size_(downloaded_prefix_size_)
  , downloaded_size_(downloaded_size_)
{}

const std::int32_t localFile::ID;

void localFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "localFile");
    s.store_field("path", path_);
    s.store_field("can_be_downloaded", can_be_downloaded_);
    s.store_field("can_be_deleted", can_be_deleted_);
    s.store_field("is_downloading_active", is_downloading_active_);
    s.store_field("is_downloading_completed", is_downloading_completed_);
    s.store_field("download_offset", download_offset_);
    s.store_field("downloaded_prefix_size", downloaded_prefix_size_);
    s.store_field("downloaded_size", downloaded_size_);
    s.store_class_end();
  }
}

localizationTargetInfo::localizationTargetInfo()
  : language_packs_()
{}

localizationTargetInfo::localizationTargetInfo(array<object_ptr<languagePackInfo>> &&language_packs_)
  : language_packs_(std::move(language_packs_))
{}

const std::int32_t localizationTargetInfo::ID;

void localizationTargetInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "localizationTargetInfo");
    { s.store_vector_begin("language_packs", language_packs_.size()); for (const auto &_value : language_packs_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

location::location()
  : latitude_()
  , longitude_()
  , horizontal_accuracy_()
{}

location::location(double latitude_, double longitude_, double horizontal_accuracy_)
  : latitude_(latitude_)
  , longitude_(longitude_)
  , horizontal_accuracy_(horizontal_accuracy_)
{}

const std::int32_t location::ID;

void location::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "location");
    s.store_field("latitude", latitude_);
    s.store_field("longitude", longitude_);
    s.store_field("horizontal_accuracy", horizontal_accuracy_);
    s.store_class_end();
  }
}

locationAddress::locationAddress()
  : country_code_()
  , state_()
  , city_()
  , street_()
{}

locationAddress::locationAddress(string const &country_code_, string const &state_, string const &city_, string const &street_)
  : country_code_(country_code_)
  , state_(state_)
  , city_(city_)
  , street_(street_)
{}

const std::int32_t locationAddress::ID;

void locationAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "locationAddress");
    s.store_field("country_code", country_code_);
    s.store_field("state", state_);
    s.store_field("city", city_);
    s.store_field("street", street_);
    s.store_class_end();
  }
}

logStreamDefault::logStreamDefault() {
}

const std::int32_t logStreamDefault::ID;

void logStreamDefault::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "logStreamDefault");
    s.store_class_end();
  }
}

logStreamFile::logStreamFile()
  : path_()
  , max_file_size_()
  , redirect_stderr_()
{}

logStreamFile::logStreamFile(string const &path_, int53 max_file_size_, bool redirect_stderr_)
  : path_(path_)
  , max_file_size_(max_file_size_)
  , redirect_stderr_(redirect_stderr_)
{}

const std::int32_t logStreamFile::ID;

void logStreamFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "logStreamFile");
    s.store_field("path", path_);
    s.store_field("max_file_size", max_file_size_);
    s.store_field("redirect_stderr", redirect_stderr_);
    s.store_class_end();
  }
}

logStreamEmpty::logStreamEmpty() {
}

const std::int32_t logStreamEmpty::ID;

void logStreamEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "logStreamEmpty");
    s.store_class_end();
  }
}

logTags::logTags()
  : tags_()
{}

logTags::logTags(array<string> &&tags_)
  : tags_(std::move(tags_))
{}

const std::int32_t logTags::ID;

void logTags::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "logTags");
    { s.store_vector_begin("tags", tags_.size()); for (const auto &_value : tags_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

logVerbosityLevel::logVerbosityLevel()
  : verbosity_level_()
{}

logVerbosityLevel::logVerbosityLevel(int32 verbosity_level_)
  : verbosity_level_(verbosity_level_)
{}

const std::int32_t logVerbosityLevel::ID;

void logVerbosityLevel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "logVerbosityLevel");
    s.store_field("verbosity_level", verbosity_level_);
    s.store_class_end();
  }
}

loginUrlInfoOpen::loginUrlInfoOpen()
  : url_()
  , skip_confirmation_()
{}

loginUrlInfoOpen::loginUrlInfoOpen(string const &url_, bool skip_confirmation_)
  : url_(url_)
  , skip_confirmation_(skip_confirmation_)
{}

const std::int32_t loginUrlInfoOpen::ID;

void loginUrlInfoOpen::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "loginUrlInfoOpen");
    s.store_field("url", url_);
    s.store_field("skip_confirmation", skip_confirmation_);
    s.store_class_end();
  }
}

loginUrlInfoRequestConfirmation::loginUrlInfoRequestConfirmation()
  : url_()
  , domain_()
  , bot_user_id_()
  , request_write_access_()
{}

loginUrlInfoRequestConfirmation::loginUrlInfoRequestConfirmation(string const &url_, string const &domain_, int53 bot_user_id_, bool request_write_access_)
  : url_(url_)
  , domain_(domain_)
  , bot_user_id_(bot_user_id_)
  , request_write_access_(request_write_access_)
{}

const std::int32_t loginUrlInfoRequestConfirmation::ID;

void loginUrlInfoRequestConfirmation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "loginUrlInfoRequestConfirmation");
    s.store_field("url", url_);
    s.store_field("domain", domain_);
    s.store_field("bot_user_id", bot_user_id_);
    s.store_field("request_write_access", request_write_access_);
    s.store_class_end();
  }
}

mainWebApp::mainWebApp()
  : url_()
  , mode_()
{}

mainWebApp::mainWebApp(string const &url_, object_ptr<WebAppOpenMode> &&mode_)
  : url_(url_)
  , mode_(std::move(mode_))
{}

const std::int32_t mainWebApp::ID;

void mainWebApp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "mainWebApp");
    s.store_field("url", url_);
    s.store_object_field("mode", static_cast<const BaseObject *>(mode_.get()));
    s.store_class_end();
  }
}

maskPointForehead::maskPointForehead() {
}

const std::int32_t maskPointForehead::ID;

void maskPointForehead::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "maskPointForehead");
    s.store_class_end();
  }
}

maskPointEyes::maskPointEyes() {
}

const std::int32_t maskPointEyes::ID;

void maskPointEyes::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "maskPointEyes");
    s.store_class_end();
  }
}

maskPointMouth::maskPointMouth() {
}

const std::int32_t maskPointMouth::ID;

void maskPointMouth::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "maskPointMouth");
    s.store_class_end();
  }
}

maskPointChin::maskPointChin() {
}

const std::int32_t maskPointChin::ID;

void maskPointChin::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "maskPointChin");
    s.store_class_end();
  }
}

maskPosition::maskPosition()
  : point_()
  , x_shift_()
  , y_shift_()
  , scale_()
{}

maskPosition::maskPosition(object_ptr<MaskPoint> &&point_, double x_shift_, double y_shift_, double scale_)
  : point_(std::move(point_))
  , x_shift_(x_shift_)
  , y_shift_(y_shift_)
  , scale_(scale_)
{}

const std::int32_t maskPosition::ID;

void maskPosition::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "maskPosition");
    s.store_object_field("point", static_cast<const BaseObject *>(point_.get()));
    s.store_field("x_shift", x_shift_);
    s.store_field("y_shift", y_shift_);
    s.store_field("scale", scale_);
    s.store_class_end();
  }
}

message::message()
  : id_()
  , sender_id_()
  , chat_id_()
  , sending_state_()
  , scheduling_state_()
  , is_outgoing_()
  , is_pinned_()
  , is_from_offline_()
  , can_be_saved_()
  , has_timestamped_media_()
  , is_channel_post_()
  , is_topic_message_()
  , contains_unread_mention_()
  , date_()
  , edit_date_()
  , forward_info_()
  , import_info_()
  , interaction_info_()
  , unread_reactions_()
  , fact_check_()
  , reply_to_()
  , message_thread_id_()
  , saved_messages_topic_id_()
  , self_destruct_type_()
  , self_destruct_in_()
  , auto_delete_in_()
  , via_bot_user_id_()
  , sender_business_bot_user_id_()
  , sender_boost_count_()
  , author_signature_()
  , media_album_id_()
  , effect_id_()
  , has_sensitive_content_()
  , restriction_reason_()
  , content_()
  , reply_markup_()
{}

message::message(int53 id_, object_ptr<MessageSender> &&sender_id_, int53 chat_id_, object_ptr<MessageSendingState> &&sending_state_, object_ptr<MessageSchedulingState> &&scheduling_state_, bool is_outgoing_, bool is_pinned_, bool is_from_offline_, bool can_be_saved_, bool has_timestamped_media_, bool is_channel_post_, bool is_topic_message_, bool contains_unread_mention_, int32 date_, int32 edit_date_, object_ptr<messageForwardInfo> &&forward_info_, object_ptr<messageImportInfo> &&import_info_, object_ptr<messageInteractionInfo> &&interaction_info_, array<object_ptr<unreadReaction>> &&unread_reactions_, object_ptr<factCheck> &&fact_check_, object_ptr<MessageReplyTo> &&reply_to_, int53 message_thread_id_, int53 saved_messages_topic_id_, object_ptr<MessageSelfDestructType> &&self_destruct_type_, double self_destruct_in_, double auto_delete_in_, int53 via_bot_user_id_, int53 sender_business_bot_user_id_, int32 sender_boost_count_, string const &author_signature_, int64 media_album_id_, int64 effect_id_, bool has_sensitive_content_, string const &restriction_reason_, object_ptr<MessageContent> &&content_, object_ptr<ReplyMarkup> &&reply_markup_)
  : id_(id_)
  , sender_id_(std::move(sender_id_))
  , chat_id_(chat_id_)
  , sending_state_(std::move(sending_state_))
  , scheduling_state_(std::move(scheduling_state_))
  , is_outgoing_(is_outgoing_)
  , is_pinned_(is_pinned_)
  , is_from_offline_(is_from_offline_)
  , can_be_saved_(can_be_saved_)
  , has_timestamped_media_(has_timestamped_media_)
  , is_channel_post_(is_channel_post_)
  , is_topic_message_(is_topic_message_)
  , contains_unread_mention_(contains_unread_mention_)
  , date_(date_)
  , edit_date_(edit_date_)
  , forward_info_(std::move(forward_info_))
  , import_info_(std::move(import_info_))
  , interaction_info_(std::move(interaction_info_))
  , unread_reactions_(std::move(unread_reactions_))
  , fact_check_(std::move(fact_check_))
  , reply_to_(std::move(reply_to_))
  , message_thread_id_(message_thread_id_)
  , saved_messages_topic_id_(saved_messages_topic_id_)
  , self_destruct_type_(std::move(self_destruct_type_))
  , self_destruct_in_(self_destruct_in_)
  , auto_delete_in_(auto_delete_in_)
  , via_bot_user_id_(via_bot_user_id_)
  , sender_business_bot_user_id_(sender_business_bot_user_id_)
  , sender_boost_count_(sender_boost_count_)
  , author_signature_(author_signature_)
  , media_album_id_(media_album_id_)
  , effect_id_(effect_id_)
  , has_sensitive_content_(has_sensitive_content_)
  , restriction_reason_(restriction_reason_)
  , content_(std::move(content_))
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t message::ID;

void message::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "message");
    s.store_field("id", id_);
    s.store_object_field("sender_id", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_field("chat_id", chat_id_);
    s.store_object_field("sending_state", static_cast<const BaseObject *>(sending_state_.get()));
    s.store_object_field("scheduling_state", static_cast<const BaseObject *>(scheduling_state_.get()));
    s.store_field("is_outgoing", is_outgoing_);
    s.store_field("is_pinned", is_pinned_);
    s.store_field("is_from_offline", is_from_offline_);
    s.store_field("can_be_saved", can_be_saved_);
    s.store_field("has_timestamped_media", has_timestamped_media_);
    s.store_field("is_channel_post", is_channel_post_);
    s.store_field("is_topic_message", is_topic_message_);
    s.store_field("contains_unread_mention", contains_unread_mention_);
    s.store_field("date", date_);
    s.store_field("edit_date", edit_date_);
    s.store_object_field("forward_info", static_cast<const BaseObject *>(forward_info_.get()));
    s.store_object_field("import_info", static_cast<const BaseObject *>(import_info_.get()));
    s.store_object_field("interaction_info", static_cast<const BaseObject *>(interaction_info_.get()));
    { s.store_vector_begin("unread_reactions", unread_reactions_.size()); for (const auto &_value : unread_reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("fact_check", static_cast<const BaseObject *>(fact_check_.get()));
    s.store_object_field("reply_to", static_cast<const BaseObject *>(reply_to_.get()));
    s.store_field("message_thread_id", message_thread_id_);
    s.store_field("saved_messages_topic_id", saved_messages_topic_id_);
    s.store_object_field("self_destruct_type", static_cast<const BaseObject *>(self_destruct_type_.get()));
    s.store_field("self_destruct_in", self_destruct_in_);
    s.store_field("auto_delete_in", auto_delete_in_);
    s.store_field("via_bot_user_id", via_bot_user_id_);
    s.store_field("sender_business_bot_user_id", sender_business_bot_user_id_);
    s.store_field("sender_boost_count", sender_boost_count_);
    s.store_field("author_signature", author_signature_);
    s.store_field("media_album_id", media_album_id_);
    s.store_field("effect_id", effect_id_);
    s.store_field("has_sensitive_content", has_sensitive_content_);
    s.store_field("restriction_reason", restriction_reason_);
    s.store_object_field("content", static_cast<const BaseObject *>(content_.get()));
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_class_end();
  }
}

messageAutoDeleteTime::messageAutoDeleteTime()
  : time_()
{}

messageAutoDeleteTime::messageAutoDeleteTime(int32 time_)
  : time_(time_)
{}

const std::int32_t messageAutoDeleteTime::ID;

void messageAutoDeleteTime::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageAutoDeleteTime");
    s.store_field("time", time_);
    s.store_class_end();
  }
}

messageCalendar::messageCalendar()
  : total_count_()
  , days_()
{}

messageCalendar::messageCalendar(int32 total_count_, array<object_ptr<messageCalendarDay>> &&days_)
  : total_count_(total_count_)
  , days_(std::move(days_))
{}

const std::int32_t messageCalendar::ID;

void messageCalendar::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageCalendar");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("days", days_.size()); for (const auto &_value : days_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageCalendarDay::messageCalendarDay()
  : total_count_()
  , message_()
{}

messageCalendarDay::messageCalendarDay(int32 total_count_, object_ptr<message> &&message_)
  : total_count_(total_count_)
  , message_(std::move(message_))
{}

const std::int32_t messageCalendarDay::ID;

void messageCalendarDay::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageCalendarDay");
    s.store_field("total_count", total_count_);
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

messageText::messageText()
  : text_()
  , link_preview_()
  , link_preview_options_()
{}

messageText::messageText(object_ptr<formattedText> &&text_, object_ptr<linkPreview> &&link_preview_, object_ptr<linkPreviewOptions> &&link_preview_options_)
  : text_(std::move(text_))
  , link_preview_(std::move(link_preview_))
  , link_preview_options_(std::move(link_preview_options_))
{}

const std::int32_t messageText::ID;

void messageText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageText");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_object_field("link_preview", static_cast<const BaseObject *>(link_preview_.get()));
    s.store_object_field("link_preview_options", static_cast<const BaseObject *>(link_preview_options_.get()));
    s.store_class_end();
  }
}

messageAnimation::messageAnimation()
  : animation_()
  , caption_()
  , show_caption_above_media_()
  , has_spoiler_()
  , is_secret_()
{}

messageAnimation::messageAnimation(object_ptr<animation> &&animation_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, bool has_spoiler_, bool is_secret_)
  : animation_(std::move(animation_))
  , caption_(std::move(caption_))
  , show_caption_above_media_(show_caption_above_media_)
  , has_spoiler_(has_spoiler_)
  , is_secret_(is_secret_)
{}

const std::int32_t messageAnimation::ID;

void messageAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageAnimation");
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("show_caption_above_media", show_caption_above_media_);
    s.store_field("has_spoiler", has_spoiler_);
    s.store_field("is_secret", is_secret_);
    s.store_class_end();
  }
}

messageAudio::messageAudio()
  : audio_()
  , caption_()
{}

messageAudio::messageAudio(object_ptr<audio> &&audio_, object_ptr<formattedText> &&caption_)
  : audio_(std::move(audio_))
  , caption_(std::move(caption_))
{}

const std::int32_t messageAudio::ID;

void messageAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageAudio");
    s.store_object_field("audio", static_cast<const BaseObject *>(audio_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

messageDocument::messageDocument()
  : document_()
  , caption_()
{}

messageDocument::messageDocument(object_ptr<document> &&document_, object_ptr<formattedText> &&caption_)
  : document_(std::move(document_))
  , caption_(std::move(caption_))
{}

const std::int32_t messageDocument::ID;

void messageDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageDocument");
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

messagePaidMedia::messagePaidMedia()
  : star_count_()
  , media_()
  , caption_()
  , show_caption_above_media_()
{}

messagePaidMedia::messagePaidMedia(int53 star_count_, array<object_ptr<PaidMedia>> &&media_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_)
  : star_count_(star_count_)
  , media_(std::move(media_))
  , caption_(std::move(caption_))
  , show_caption_above_media_(show_caption_above_media_)
{}

const std::int32_t messagePaidMedia::ID;

void messagePaidMedia::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePaidMedia");
    s.store_field("star_count", star_count_);
    { s.store_vector_begin("media", media_.size()); for (const auto &_value : media_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("show_caption_above_media", show_caption_above_media_);
    s.store_class_end();
  }
}

messagePhoto::messagePhoto()
  : photo_()
  , caption_()
  , show_caption_above_media_()
  , has_spoiler_()
  , is_secret_()
{}

messagePhoto::messagePhoto(object_ptr<photo> &&photo_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, bool has_spoiler_, bool is_secret_)
  : photo_(std::move(photo_))
  , caption_(std::move(caption_))
  , show_caption_above_media_(show_caption_above_media_)
  , has_spoiler_(has_spoiler_)
  , is_secret_(is_secret_)
{}

const std::int32_t messagePhoto::ID;

void messagePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("show_caption_above_media", show_caption_above_media_);
    s.store_field("has_spoiler", has_spoiler_);
    s.store_field("is_secret", is_secret_);
    s.store_class_end();
  }
}

messageSticker::messageSticker()
  : sticker_()
  , is_premium_()
{}

messageSticker::messageSticker(object_ptr<sticker> &&sticker_, bool is_premium_)
  : sticker_(std::move(sticker_))
  , is_premium_(is_premium_)
{}

const std::int32_t messageSticker::ID;

void messageSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSticker");
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_field("is_premium", is_premium_);
    s.store_class_end();
  }
}

messageVideo::messageVideo()
  : video_()
  , alternative_videos_()
  , cover_()
  , start_timestamp_()
  , caption_()
  , show_caption_above_media_()
  , has_spoiler_()
  , is_secret_()
{}

messageVideo::messageVideo(object_ptr<video> &&video_, array<object_ptr<alternativeVideo>> &&alternative_videos_, object_ptr<photo> &&cover_, int32 start_timestamp_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, bool has_spoiler_, bool is_secret_)
  : video_(std::move(video_))
  , alternative_videos_(std::move(alternative_videos_))
  , cover_(std::move(cover_))
  , start_timestamp_(start_timestamp_)
  , caption_(std::move(caption_))
  , show_caption_above_media_(show_caption_above_media_)
  , has_spoiler_(has_spoiler_)
  , is_secret_(is_secret_)
{}

const std::int32_t messageVideo::ID;

void messageVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageVideo");
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    { s.store_vector_begin("alternative_videos", alternative_videos_.size()); for (const auto &_value : alternative_videos_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("cover", static_cast<const BaseObject *>(cover_.get()));
    s.store_field("start_timestamp", start_timestamp_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("show_caption_above_media", show_caption_above_media_);
    s.store_field("has_spoiler", has_spoiler_);
    s.store_field("is_secret", is_secret_);
    s.store_class_end();
  }
}

messageVideoNote::messageVideoNote()
  : video_note_()
  , is_viewed_()
  , is_secret_()
{}

messageVideoNote::messageVideoNote(object_ptr<videoNote> &&video_note_, bool is_viewed_, bool is_secret_)
  : video_note_(std::move(video_note_))
  , is_viewed_(is_viewed_)
  , is_secret_(is_secret_)
{}

const std::int32_t messageVideoNote::ID;

void messageVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageVideoNote");
    s.store_object_field("video_note", static_cast<const BaseObject *>(video_note_.get()));
    s.store_field("is_viewed", is_viewed_);
    s.store_field("is_secret", is_secret_);
    s.store_class_end();
  }
}

messageVoiceNote::messageVoiceNote()
  : voice_note_()
  , caption_()
  , is_listened_()
{}

messageVoiceNote::messageVoiceNote(object_ptr<voiceNote> &&voice_note_, object_ptr<formattedText> &&caption_, bool is_listened_)
  : voice_note_(std::move(voice_note_))
  , caption_(std::move(caption_))
  , is_listened_(is_listened_)
{}

const std::int32_t messageVoiceNote::ID;

void messageVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageVoiceNote");
    s.store_object_field("voice_note", static_cast<const BaseObject *>(voice_note_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("is_listened", is_listened_);
    s.store_class_end();
  }
}

messageExpiredPhoto::messageExpiredPhoto() {
}

const std::int32_t messageExpiredPhoto::ID;

void messageExpiredPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageExpiredPhoto");
    s.store_class_end();
  }
}

messageExpiredVideo::messageExpiredVideo() {
}

const std::int32_t messageExpiredVideo::ID;

void messageExpiredVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageExpiredVideo");
    s.store_class_end();
  }
}

messageExpiredVideoNote::messageExpiredVideoNote() {
}

const std::int32_t messageExpiredVideoNote::ID;

void messageExpiredVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageExpiredVideoNote");
    s.store_class_end();
  }
}

messageExpiredVoiceNote::messageExpiredVoiceNote() {
}

const std::int32_t messageExpiredVoiceNote::ID;

void messageExpiredVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageExpiredVoiceNote");
    s.store_class_end();
  }
}

messageLocation::messageLocation()
  : location_()
  , live_period_()
  , expires_in_()
  , heading_()
  , proximity_alert_radius_()
{}

messageLocation::messageLocation(object_ptr<location> &&location_, int32 live_period_, int32 expires_in_, int32 heading_, int32 proximity_alert_radius_)
  : location_(std::move(location_))
  , live_period_(live_period_)
  , expires_in_(expires_in_)
  , heading_(heading_)
  , proximity_alert_radius_(proximity_alert_radius_)
{}

const std::int32_t messageLocation::ID;

void messageLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageLocation");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_field("live_period", live_period_);
    s.store_field("expires_in", expires_in_);
    s.store_field("heading", heading_);
    s.store_field("proximity_alert_radius", proximity_alert_radius_);
    s.store_class_end();
  }
}

messageVenue::messageVenue()
  : venue_()
{}

messageVenue::messageVenue(object_ptr<venue> &&venue_)
  : venue_(std::move(venue_))
{}

const std::int32_t messageVenue::ID;

void messageVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageVenue");
    s.store_object_field("venue", static_cast<const BaseObject *>(venue_.get()));
    s.store_class_end();
  }
}

messageContact::messageContact()
  : contact_()
{}

messageContact::messageContact(object_ptr<contact> &&contact_)
  : contact_(std::move(contact_))
{}

const std::int32_t messageContact::ID;

void messageContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageContact");
    s.store_object_field("contact", static_cast<const BaseObject *>(contact_.get()));
    s.store_class_end();
  }
}

messageAnimatedEmoji::messageAnimatedEmoji()
  : animated_emoji_()
  , emoji_()
{}

messageAnimatedEmoji::messageAnimatedEmoji(object_ptr<animatedEmoji> &&animated_emoji_, string const &emoji_)
  : animated_emoji_(std::move(animated_emoji_))
  , emoji_(emoji_)
{}

const std::int32_t messageAnimatedEmoji::ID;

void messageAnimatedEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageAnimatedEmoji");
    s.store_object_field("animated_emoji", static_cast<const BaseObject *>(animated_emoji_.get()));
    s.store_field("emoji", emoji_);
    s.store_class_end();
  }
}

messageDice::messageDice()
  : initial_state_()
  , final_state_()
  , emoji_()
  , value_()
  , success_animation_frame_number_()
{}

messageDice::messageDice(object_ptr<DiceStickers> &&initial_state_, object_ptr<DiceStickers> &&final_state_, string const &emoji_, int32 value_, int32 success_animation_frame_number_)
  : initial_state_(std::move(initial_state_))
  , final_state_(std::move(final_state_))
  , emoji_(emoji_)
  , value_(value_)
  , success_animation_frame_number_(success_animation_frame_number_)
{}

const std::int32_t messageDice::ID;

void messageDice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageDice");
    s.store_object_field("initial_state", static_cast<const BaseObject *>(initial_state_.get()));
    s.store_object_field("final_state", static_cast<const BaseObject *>(final_state_.get()));
    s.store_field("emoji", emoji_);
    s.store_field("value", value_);
    s.store_field("success_animation_frame_number", success_animation_frame_number_);
    s.store_class_end();
  }
}

messageGame::messageGame()
  : game_()
{}

messageGame::messageGame(object_ptr<game> &&game_)
  : game_(std::move(game_))
{}

const std::int32_t messageGame::ID;

void messageGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageGame");
    s.store_object_field("game", static_cast<const BaseObject *>(game_.get()));
    s.store_class_end();
  }
}

messagePoll::messagePoll()
  : poll_()
{}

messagePoll::messagePoll(object_ptr<poll> &&poll_)
  : poll_(std::move(poll_))
{}

const std::int32_t messagePoll::ID;

void messagePoll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePoll");
    s.store_object_field("poll", static_cast<const BaseObject *>(poll_.get()));
    s.store_class_end();
  }
}

messageStory::messageStory()
  : story_sender_chat_id_()
  , story_id_()
  , via_mention_()
{}

messageStory::messageStory(int53 story_sender_chat_id_, int32 story_id_, bool via_mention_)
  : story_sender_chat_id_(story_sender_chat_id_)
  , story_id_(story_id_)
  , via_mention_(via_mention_)
{}

const std::int32_t messageStory::ID;

void messageStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageStory");
    s.store_field("story_sender_chat_id", story_sender_chat_id_);
    s.store_field("story_id", story_id_);
    s.store_field("via_mention", via_mention_);
    s.store_class_end();
  }
}

messageInvoice::messageInvoice()
  : product_info_()
  , currency_()
  , total_amount_()
  , start_parameter_()
  , is_test_()
  , need_shipping_address_()
  , receipt_message_id_()
  , paid_media_()
  , paid_media_caption_()
{}

messageInvoice::messageInvoice(object_ptr<productInfo> &&product_info_, string const &currency_, int53 total_amount_, string const &start_parameter_, bool is_test_, bool need_shipping_address_, int53 receipt_message_id_, object_ptr<PaidMedia> &&paid_media_, object_ptr<formattedText> &&paid_media_caption_)
  : product_info_(std::move(product_info_))
  , currency_(currency_)
  , total_amount_(total_amount_)
  , start_parameter_(start_parameter_)
  , is_test_(is_test_)
  , need_shipping_address_(need_shipping_address_)
  , receipt_message_id_(receipt_message_id_)
  , paid_media_(std::move(paid_media_))
  , paid_media_caption_(std::move(paid_media_caption_))
{}

const std::int32_t messageInvoice::ID;

void messageInvoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageInvoice");
    s.store_object_field("product_info", static_cast<const BaseObject *>(product_info_.get()));
    s.store_field("currency", currency_);
    s.store_field("total_amount", total_amount_);
    s.store_field("start_parameter", start_parameter_);
    s.store_field("is_test", is_test_);
    s.store_field("need_shipping_address", need_shipping_address_);
    s.store_field("receipt_message_id", receipt_message_id_);
    s.store_object_field("paid_media", static_cast<const BaseObject *>(paid_media_.get()));
    s.store_object_field("paid_media_caption", static_cast<const BaseObject *>(paid_media_caption_.get()));
    s.store_class_end();
  }
}

messageCall::messageCall()
  : is_video_()
  , discard_reason_()
  , duration_()
{}

messageCall::messageCall(bool is_video_, object_ptr<CallDiscardReason> &&discard_reason_, int32 duration_)
  : is_video_(is_video_)
  , discard_reason_(std::move(discard_reason_))
  , duration_(duration_)
{}

const std::int32_t messageCall::ID;

void messageCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageCall");
    s.store_field("is_video", is_video_);
    s.store_object_field("discard_reason", static_cast<const BaseObject *>(discard_reason_.get()));
    s.store_field("duration", duration_);
    s.store_class_end();
  }
}

messageVideoChatScheduled::messageVideoChatScheduled()
  : group_call_id_()
  , start_date_()
{}

messageVideoChatScheduled::messageVideoChatScheduled(int32 group_call_id_, int32 start_date_)
  : group_call_id_(group_call_id_)
  , start_date_(start_date_)
{}

const std::int32_t messageVideoChatScheduled::ID;

void messageVideoChatScheduled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageVideoChatScheduled");
    s.store_field("group_call_id", group_call_id_);
    s.store_field("start_date", start_date_);
    s.store_class_end();
  }
}

messageVideoChatStarted::messageVideoChatStarted()
  : group_call_id_()
{}

messageVideoChatStarted::messageVideoChatStarted(int32 group_call_id_)
  : group_call_id_(group_call_id_)
{}

const std::int32_t messageVideoChatStarted::ID;

void messageVideoChatStarted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageVideoChatStarted");
    s.store_field("group_call_id", group_call_id_);
    s.store_class_end();
  }
}

messageVideoChatEnded::messageVideoChatEnded()
  : duration_()
{}

messageVideoChatEnded::messageVideoChatEnded(int32 duration_)
  : duration_(duration_)
{}

const std::int32_t messageVideoChatEnded::ID;

void messageVideoChatEnded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageVideoChatEnded");
    s.store_field("duration", duration_);
    s.store_class_end();
  }
}

messageInviteVideoChatParticipants::messageInviteVideoChatParticipants()
  : group_call_id_()
  , user_ids_()
{}

messageInviteVideoChatParticipants::messageInviteVideoChatParticipants(int32 group_call_id_, array<int53> &&user_ids_)
  : group_call_id_(group_call_id_)
  , user_ids_(std::move(user_ids_))
{}

const std::int32_t messageInviteVideoChatParticipants::ID;

void messageInviteVideoChatParticipants::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageInviteVideoChatParticipants");
    s.store_field("group_call_id", group_call_id_);
    { s.store_vector_begin("user_ids", user_ids_.size()); for (const auto &_value : user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageBasicGroupChatCreate::messageBasicGroupChatCreate()
  : title_()
  , member_user_ids_()
{}

messageBasicGroupChatCreate::messageBasicGroupChatCreate(string const &title_, array<int53> &&member_user_ids_)
  : title_(title_)
  , member_user_ids_(std::move(member_user_ids_))
{}

const std::int32_t messageBasicGroupChatCreate::ID;

void messageBasicGroupChatCreate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageBasicGroupChatCreate");
    s.store_field("title", title_);
    { s.store_vector_begin("member_user_ids", member_user_ids_.size()); for (const auto &_value : member_user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageSupergroupChatCreate::messageSupergroupChatCreate()
  : title_()
{}

messageSupergroupChatCreate::messageSupergroupChatCreate(string const &title_)
  : title_(title_)
{}

const std::int32_t messageSupergroupChatCreate::ID;

void messageSupergroupChatCreate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSupergroupChatCreate");
    s.store_field("title", title_);
    s.store_class_end();
  }
}

messageChatChangeTitle::messageChatChangeTitle()
  : title_()
{}

messageChatChangeTitle::messageChatChangeTitle(string const &title_)
  : title_(title_)
{}

const std::int32_t messageChatChangeTitle::ID;

void messageChatChangeTitle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatChangeTitle");
    s.store_field("title", title_);
    s.store_class_end();
  }
}

messageChatChangePhoto::messageChatChangePhoto()
  : photo_()
{}

messageChatChangePhoto::messageChatChangePhoto(object_ptr<chatPhoto> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t messageChatChangePhoto::ID;

void messageChatChangePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatChangePhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

messageChatDeletePhoto::messageChatDeletePhoto() {
}

const std::int32_t messageChatDeletePhoto::ID;

void messageChatDeletePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatDeletePhoto");
    s.store_class_end();
  }
}

messageChatAddMembers::messageChatAddMembers()
  : member_user_ids_()
{}

messageChatAddMembers::messageChatAddMembers(array<int53> &&member_user_ids_)
  : member_user_ids_(std::move(member_user_ids_))
{}

const std::int32_t messageChatAddMembers::ID;

void messageChatAddMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatAddMembers");
    { s.store_vector_begin("member_user_ids", member_user_ids_.size()); for (const auto &_value : member_user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageChatJoinByLink::messageChatJoinByLink() {
}

const std::int32_t messageChatJoinByLink::ID;

void messageChatJoinByLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatJoinByLink");
    s.store_class_end();
  }
}

messageChatJoinByRequest::messageChatJoinByRequest() {
}

const std::int32_t messageChatJoinByRequest::ID;

void messageChatJoinByRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatJoinByRequest");
    s.store_class_end();
  }
}

messageChatDeleteMember::messageChatDeleteMember()
  : user_id_()
{}

messageChatDeleteMember::messageChatDeleteMember(int53 user_id_)
  : user_id_(user_id_)
{}

const std::int32_t messageChatDeleteMember::ID;

void messageChatDeleteMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatDeleteMember");
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

messageChatUpgradeTo::messageChatUpgradeTo()
  : supergroup_id_()
{}

messageChatUpgradeTo::messageChatUpgradeTo(int53 supergroup_id_)
  : supergroup_id_(supergroup_id_)
{}

const std::int32_t messageChatUpgradeTo::ID;

void messageChatUpgradeTo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatUpgradeTo");
    s.store_field("supergroup_id", supergroup_id_);
    s.store_class_end();
  }
}

messageChatUpgradeFrom::messageChatUpgradeFrom()
  : title_()
  , basic_group_id_()
{}

messageChatUpgradeFrom::messageChatUpgradeFrom(string const &title_, int53 basic_group_id_)
  : title_(title_)
  , basic_group_id_(basic_group_id_)
{}

const std::int32_t messageChatUpgradeFrom::ID;

void messageChatUpgradeFrom::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatUpgradeFrom");
    s.store_field("title", title_);
    s.store_field("basic_group_id", basic_group_id_);
    s.store_class_end();
  }
}

messagePinMessage::messagePinMessage()
  : message_id_()
{}

messagePinMessage::messagePinMessage(int53 message_id_)
  : message_id_(message_id_)
{}

const std::int32_t messagePinMessage::ID;

void messagePinMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePinMessage");
    s.store_field("message_id", message_id_);
    s.store_class_end();
  }
}

messageScreenshotTaken::messageScreenshotTaken() {
}

const std::int32_t messageScreenshotTaken::ID;

void messageScreenshotTaken::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageScreenshotTaken");
    s.store_class_end();
  }
}

messageChatSetBackground::messageChatSetBackground()
  : old_background_message_id_()
  , background_()
  , only_for_self_()
{}

messageChatSetBackground::messageChatSetBackground(int53 old_background_message_id_, object_ptr<chatBackground> &&background_, bool only_for_self_)
  : old_background_message_id_(old_background_message_id_)
  , background_(std::move(background_))
  , only_for_self_(only_for_self_)
{}

const std::int32_t messageChatSetBackground::ID;

void messageChatSetBackground::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatSetBackground");
    s.store_field("old_background_message_id", old_background_message_id_);
    s.store_object_field("background", static_cast<const BaseObject *>(background_.get()));
    s.store_field("only_for_self", only_for_self_);
    s.store_class_end();
  }
}

messageChatSetTheme::messageChatSetTheme()
  : theme_name_()
{}

messageChatSetTheme::messageChatSetTheme(string const &theme_name_)
  : theme_name_(theme_name_)
{}

const std::int32_t messageChatSetTheme::ID;

void messageChatSetTheme::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatSetTheme");
    s.store_field("theme_name", theme_name_);
    s.store_class_end();
  }
}

messageChatSetMessageAutoDeleteTime::messageChatSetMessageAutoDeleteTime()
  : message_auto_delete_time_()
  , from_user_id_()
{}

messageChatSetMessageAutoDeleteTime::messageChatSetMessageAutoDeleteTime(int32 message_auto_delete_time_, int53 from_user_id_)
  : message_auto_delete_time_(message_auto_delete_time_)
  , from_user_id_(from_user_id_)
{}

const std::int32_t messageChatSetMessageAutoDeleteTime::ID;

void messageChatSetMessageAutoDeleteTime::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatSetMessageAutoDeleteTime");
    s.store_field("message_auto_delete_time", message_auto_delete_time_);
    s.store_field("from_user_id", from_user_id_);
    s.store_class_end();
  }
}

messageChatBoost::messageChatBoost()
  : boost_count_()
{}

messageChatBoost::messageChatBoost(int32 boost_count_)
  : boost_count_(boost_count_)
{}

const std::int32_t messageChatBoost::ID;

void messageChatBoost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatBoost");
    s.store_field("boost_count", boost_count_);
    s.store_class_end();
  }
}

messageForumTopicCreated::messageForumTopicCreated()
  : name_()
  , icon_()
{}

messageForumTopicCreated::messageForumTopicCreated(string const &name_, object_ptr<forumTopicIcon> &&icon_)
  : name_(name_)
  , icon_(std::move(icon_))
{}

const std::int32_t messageForumTopicCreated::ID;

void messageForumTopicCreated::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageForumTopicCreated");
    s.store_field("name", name_);
    s.store_object_field("icon", static_cast<const BaseObject *>(icon_.get()));
    s.store_class_end();
  }
}

messageForumTopicEdited::messageForumTopicEdited()
  : name_()
  , edit_icon_custom_emoji_id_()
  , icon_custom_emoji_id_()
{}

messageForumTopicEdited::messageForumTopicEdited(string const &name_, bool edit_icon_custom_emoji_id_, int64 icon_custom_emoji_id_)
  : name_(name_)
  , edit_icon_custom_emoji_id_(edit_icon_custom_emoji_id_)
  , icon_custom_emoji_id_(icon_custom_emoji_id_)
{}

const std::int32_t messageForumTopicEdited::ID;

void messageForumTopicEdited::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageForumTopicEdited");
    s.store_field("name", name_);
    s.store_field("edit_icon_custom_emoji_id", edit_icon_custom_emoji_id_);
    s.store_field("icon_custom_emoji_id", icon_custom_emoji_id_);
    s.store_class_end();
  }
}

messageForumTopicIsClosedToggled::messageForumTopicIsClosedToggled()
  : is_closed_()
{}

messageForumTopicIsClosedToggled::messageForumTopicIsClosedToggled(bool is_closed_)
  : is_closed_(is_closed_)
{}

const std::int32_t messageForumTopicIsClosedToggled::ID;

void messageForumTopicIsClosedToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageForumTopicIsClosedToggled");
    s.store_field("is_closed", is_closed_);
    s.store_class_end();
  }
}

messageForumTopicIsHiddenToggled::messageForumTopicIsHiddenToggled()
  : is_hidden_()
{}

messageForumTopicIsHiddenToggled::messageForumTopicIsHiddenToggled(bool is_hidden_)
  : is_hidden_(is_hidden_)
{}

const std::int32_t messageForumTopicIsHiddenToggled::ID;

void messageForumTopicIsHiddenToggled::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageForumTopicIsHiddenToggled");
    s.store_field("is_hidden", is_hidden_);
    s.store_class_end();
  }
}

messageSuggestProfilePhoto::messageSuggestProfilePhoto()
  : photo_()
{}

messageSuggestProfilePhoto::messageSuggestProfilePhoto(object_ptr<chatPhoto> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t messageSuggestProfilePhoto::ID;

void messageSuggestProfilePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSuggestProfilePhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

messageCustomServiceAction::messageCustomServiceAction()
  : text_()
{}

messageCustomServiceAction::messageCustomServiceAction(string const &text_)
  : text_(text_)
{}

const std::int32_t messageCustomServiceAction::ID;

void messageCustomServiceAction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageCustomServiceAction");
    s.store_field("text", text_);
    s.store_class_end();
  }
}

messageGameScore::messageGameScore()
  : game_message_id_()
  , game_id_()
  , score_()
{}

messageGameScore::messageGameScore(int53 game_message_id_, int64 game_id_, int32 score_)
  : game_message_id_(game_message_id_)
  , game_id_(game_id_)
  , score_(score_)
{}

const std::int32_t messageGameScore::ID;

void messageGameScore::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageGameScore");
    s.store_field("game_message_id", game_message_id_);
    s.store_field("game_id", game_id_);
    s.store_field("score", score_);
    s.store_class_end();
  }
}

messagePaymentSuccessful::messagePaymentSuccessful()
  : invoice_chat_id_()
  , invoice_message_id_()
  , currency_()
  , total_amount_()
  , subscription_until_date_()
  , is_recurring_()
  , is_first_recurring_()
  , invoice_name_()
{}

messagePaymentSuccessful::messagePaymentSuccessful(int53 invoice_chat_id_, int53 invoice_message_id_, string const &currency_, int53 total_amount_, int32 subscription_until_date_, bool is_recurring_, bool is_first_recurring_, string const &invoice_name_)
  : invoice_chat_id_(invoice_chat_id_)
  , invoice_message_id_(invoice_message_id_)
  , currency_(currency_)
  , total_amount_(total_amount_)
  , subscription_until_date_(subscription_until_date_)
  , is_recurring_(is_recurring_)
  , is_first_recurring_(is_first_recurring_)
  , invoice_name_(invoice_name_)
{}

const std::int32_t messagePaymentSuccessful::ID;

void messagePaymentSuccessful::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePaymentSuccessful");
    s.store_field("invoice_chat_id", invoice_chat_id_);
    s.store_field("invoice_message_id", invoice_message_id_);
    s.store_field("currency", currency_);
    s.store_field("total_amount", total_amount_);
    s.store_field("subscription_until_date", subscription_until_date_);
    s.store_field("is_recurring", is_recurring_);
    s.store_field("is_first_recurring", is_first_recurring_);
    s.store_field("invoice_name", invoice_name_);
    s.store_class_end();
  }
}

messagePaymentSuccessfulBot::messagePaymentSuccessfulBot()
  : currency_()
  , total_amount_()
  , subscription_until_date_()
  , is_recurring_()
  , is_first_recurring_()
  , invoice_payload_()
  , shipping_option_id_()
  , order_info_()
  , telegram_payment_charge_id_()
  , provider_payment_charge_id_()
{}

messagePaymentSuccessfulBot::messagePaymentSuccessfulBot(string const &currency_, int53 total_amount_, int32 subscription_until_date_, bool is_recurring_, bool is_first_recurring_, bytes const &invoice_payload_, string const &shipping_option_id_, object_ptr<orderInfo> &&order_info_, string const &telegram_payment_charge_id_, string const &provider_payment_charge_id_)
  : currency_(currency_)
  , total_amount_(total_amount_)
  , subscription_until_date_(subscription_until_date_)
  , is_recurring_(is_recurring_)
  , is_first_recurring_(is_first_recurring_)
  , invoice_payload_(std::move(invoice_payload_))
  , shipping_option_id_(shipping_option_id_)
  , order_info_(std::move(order_info_))
  , telegram_payment_charge_id_(telegram_payment_charge_id_)
  , provider_payment_charge_id_(provider_payment_charge_id_)
{}

const std::int32_t messagePaymentSuccessfulBot::ID;

void messagePaymentSuccessfulBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePaymentSuccessfulBot");
    s.store_field("currency", currency_);
    s.store_field("total_amount", total_amount_);
    s.store_field("subscription_until_date", subscription_until_date_);
    s.store_field("is_recurring", is_recurring_);
    s.store_field("is_first_recurring", is_first_recurring_);
    s.store_bytes_field("invoice_payload", invoice_payload_);
    s.store_field("shipping_option_id", shipping_option_id_);
    s.store_object_field("order_info", static_cast<const BaseObject *>(order_info_.get()));
    s.store_field("telegram_payment_charge_id", telegram_payment_charge_id_);
    s.store_field("provider_payment_charge_id", provider_payment_charge_id_);
    s.store_class_end();
  }
}

messagePaymentRefunded::messagePaymentRefunded()
  : owner_id_()
  , currency_()
  , total_amount_()
  , invoice_payload_()
  , telegram_payment_charge_id_()
  , provider_payment_charge_id_()
{}

messagePaymentRefunded::messagePaymentRefunded(object_ptr<MessageSender> &&owner_id_, string const &currency_, int53 total_amount_, bytes const &invoice_payload_, string const &telegram_payment_charge_id_, string const &provider_payment_charge_id_)
  : owner_id_(std::move(owner_id_))
  , currency_(currency_)
  , total_amount_(total_amount_)
  , invoice_payload_(std::move(invoice_payload_))
  , telegram_payment_charge_id_(telegram_payment_charge_id_)
  , provider_payment_charge_id_(provider_payment_charge_id_)
{}

const std::int32_t messagePaymentRefunded::ID;

void messagePaymentRefunded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePaymentRefunded");
    s.store_object_field("owner_id", static_cast<const BaseObject *>(owner_id_.get()));
    s.store_field("currency", currency_);
    s.store_field("total_amount", total_amount_);
    s.store_bytes_field("invoice_payload", invoice_payload_);
    s.store_field("telegram_payment_charge_id", telegram_payment_charge_id_);
    s.store_field("provider_payment_charge_id", provider_payment_charge_id_);
    s.store_class_end();
  }
}

messageGiftedPremium::messageGiftedPremium()
  : gifter_user_id_()
  , receiver_user_id_()
  , text_()
  , currency_()
  , amount_()
  , cryptocurrency_()
  , cryptocurrency_amount_()
  , month_count_()
  , sticker_()
{}

messageGiftedPremium::messageGiftedPremium(int53 gifter_user_id_, int53 receiver_user_id_, object_ptr<formattedText> &&text_, string const &currency_, int53 amount_, string const &cryptocurrency_, int64 cryptocurrency_amount_, int32 month_count_, object_ptr<sticker> &&sticker_)
  : gifter_user_id_(gifter_user_id_)
  , receiver_user_id_(receiver_user_id_)
  , text_(std::move(text_))
  , currency_(currency_)
  , amount_(amount_)
  , cryptocurrency_(cryptocurrency_)
  , cryptocurrency_amount_(cryptocurrency_amount_)
  , month_count_(month_count_)
  , sticker_(std::move(sticker_))
{}

const std::int32_t messageGiftedPremium::ID;

void messageGiftedPremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageGiftedPremium");
    s.store_field("gifter_user_id", gifter_user_id_);
    s.store_field("receiver_user_id", receiver_user_id_);
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("cryptocurrency", cryptocurrency_);
    s.store_field("cryptocurrency_amount", cryptocurrency_amount_);
    s.store_field("month_count", month_count_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

messagePremiumGiftCode::messagePremiumGiftCode()
  : creator_id_()
  , text_()
  , is_from_giveaway_()
  , is_unclaimed_()
  , currency_()
  , amount_()
  , cryptocurrency_()
  , cryptocurrency_amount_()
  , month_count_()
  , sticker_()
  , code_()
{}

messagePremiumGiftCode::messagePremiumGiftCode(object_ptr<MessageSender> &&creator_id_, object_ptr<formattedText> &&text_, bool is_from_giveaway_, bool is_unclaimed_, string const &currency_, int53 amount_, string const &cryptocurrency_, int64 cryptocurrency_amount_, int32 month_count_, object_ptr<sticker> &&sticker_, string const &code_)
  : creator_id_(std::move(creator_id_))
  , text_(std::move(text_))
  , is_from_giveaway_(is_from_giveaway_)
  , is_unclaimed_(is_unclaimed_)
  , currency_(currency_)
  , amount_(amount_)
  , cryptocurrency_(cryptocurrency_)
  , cryptocurrency_amount_(cryptocurrency_amount_)
  , month_count_(month_count_)
  , sticker_(std::move(sticker_))
  , code_(code_)
{}

const std::int32_t messagePremiumGiftCode::ID;

void messagePremiumGiftCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePremiumGiftCode");
    s.store_object_field("creator_id", static_cast<const BaseObject *>(creator_id_.get()));
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("is_from_giveaway", is_from_giveaway_);
    s.store_field("is_unclaimed", is_unclaimed_);
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("cryptocurrency", cryptocurrency_);
    s.store_field("cryptocurrency_amount", cryptocurrency_amount_);
    s.store_field("month_count", month_count_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_field("code", code_);
    s.store_class_end();
  }
}

messageGiveawayCreated::messageGiveawayCreated()
  : star_count_()
{}

messageGiveawayCreated::messageGiveawayCreated(int53 star_count_)
  : star_count_(star_count_)
{}

const std::int32_t messageGiveawayCreated::ID;

void messageGiveawayCreated::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageGiveawayCreated");
    s.store_field("star_count", star_count_);
    s.store_class_end();
  }
}

messageGiveaway::messageGiveaway()
  : parameters_()
  , winner_count_()
  , prize_()
  , sticker_()
{}

messageGiveaway::messageGiveaway(object_ptr<giveawayParameters> &&parameters_, int32 winner_count_, object_ptr<GiveawayPrize> &&prize_, object_ptr<sticker> &&sticker_)
  : parameters_(std::move(parameters_))
  , winner_count_(winner_count_)
  , prize_(std::move(prize_))
  , sticker_(std::move(sticker_))
{}

const std::int32_t messageGiveaway::ID;

void messageGiveaway::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageGiveaway");
    s.store_object_field("parameters", static_cast<const BaseObject *>(parameters_.get()));
    s.store_field("winner_count", winner_count_);
    s.store_object_field("prize", static_cast<const BaseObject *>(prize_.get()));
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

messageGiveawayCompleted::messageGiveawayCompleted()
  : giveaway_message_id_()
  , winner_count_()
  , is_star_giveaway_()
  , unclaimed_prize_count_()
{}

messageGiveawayCompleted::messageGiveawayCompleted(int53 giveaway_message_id_, int32 winner_count_, bool is_star_giveaway_, int32 unclaimed_prize_count_)
  : giveaway_message_id_(giveaway_message_id_)
  , winner_count_(winner_count_)
  , is_star_giveaway_(is_star_giveaway_)
  , unclaimed_prize_count_(unclaimed_prize_count_)
{}

const std::int32_t messageGiveawayCompleted::ID;

void messageGiveawayCompleted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageGiveawayCompleted");
    s.store_field("giveaway_message_id", giveaway_message_id_);
    s.store_field("winner_count", winner_count_);
    s.store_field("is_star_giveaway", is_star_giveaway_);
    s.store_field("unclaimed_prize_count", unclaimed_prize_count_);
    s.store_class_end();
  }
}

messageGiveawayWinners::messageGiveawayWinners()
  : boosted_chat_id_()
  , giveaway_message_id_()
  , additional_chat_count_()
  , actual_winners_selection_date_()
  , only_new_members_()
  , was_refunded_()
  , prize_()
  , prize_description_()
  , winner_count_()
  , winner_user_ids_()
  , unclaimed_prize_count_()
{}

messageGiveawayWinners::messageGiveawayWinners(int53 boosted_chat_id_, int53 giveaway_message_id_, int32 additional_chat_count_, int32 actual_winners_selection_date_, bool only_new_members_, bool was_refunded_, object_ptr<GiveawayPrize> &&prize_, string const &prize_description_, int32 winner_count_, array<int53> &&winner_user_ids_, int32 unclaimed_prize_count_)
  : boosted_chat_id_(boosted_chat_id_)
  , giveaway_message_id_(giveaway_message_id_)
  , additional_chat_count_(additional_chat_count_)
  , actual_winners_selection_date_(actual_winners_selection_date_)
  , only_new_members_(only_new_members_)
  , was_refunded_(was_refunded_)
  , prize_(std::move(prize_))
  , prize_description_(prize_description_)
  , winner_count_(winner_count_)
  , winner_user_ids_(std::move(winner_user_ids_))
  , unclaimed_prize_count_(unclaimed_prize_count_)
{}

const std::int32_t messageGiveawayWinners::ID;

void messageGiveawayWinners::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageGiveawayWinners");
    s.store_field("boosted_chat_id", boosted_chat_id_);
    s.store_field("giveaway_message_id", giveaway_message_id_);
    s.store_field("additional_chat_count", additional_chat_count_);
    s.store_field("actual_winners_selection_date", actual_winners_selection_date_);
    s.store_field("only_new_members", only_new_members_);
    s.store_field("was_refunded", was_refunded_);
    s.store_object_field("prize", static_cast<const BaseObject *>(prize_.get()));
    s.store_field("prize_description", prize_description_);
    s.store_field("winner_count", winner_count_);
    { s.store_vector_begin("winner_user_ids", winner_user_ids_.size()); for (const auto &_value : winner_user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_field("unclaimed_prize_count", unclaimed_prize_count_);
    s.store_class_end();
  }
}

messageGiftedStars::messageGiftedStars()
  : gifter_user_id_()
  , receiver_user_id_()
  , currency_()
  , amount_()
  , cryptocurrency_()
  , cryptocurrency_amount_()
  , star_count_()
  , transaction_id_()
  , sticker_()
{}

messageGiftedStars::messageGiftedStars(int53 gifter_user_id_, int53 receiver_user_id_, string const &currency_, int53 amount_, string const &cryptocurrency_, int64 cryptocurrency_amount_, int53 star_count_, string const &transaction_id_, object_ptr<sticker> &&sticker_)
  : gifter_user_id_(gifter_user_id_)
  , receiver_user_id_(receiver_user_id_)
  , currency_(currency_)
  , amount_(amount_)
  , cryptocurrency_(cryptocurrency_)
  , cryptocurrency_amount_(cryptocurrency_amount_)
  , star_count_(star_count_)
  , transaction_id_(transaction_id_)
  , sticker_(std::move(sticker_))
{}

const std::int32_t messageGiftedStars::ID;

void messageGiftedStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageGiftedStars");
    s.store_field("gifter_user_id", gifter_user_id_);
    s.store_field("receiver_user_id", receiver_user_id_);
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("cryptocurrency", cryptocurrency_);
    s.store_field("cryptocurrency_amount", cryptocurrency_amount_);
    s.store_field("star_count", star_count_);
    s.store_field("transaction_id", transaction_id_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

messageGiveawayPrizeStars::messageGiveawayPrizeStars()
  : star_count_()
  , transaction_id_()
  , boosted_chat_id_()
  , giveaway_message_id_()
  , is_unclaimed_()
  , sticker_()
{}

messageGiveawayPrizeStars::messageGiveawayPrizeStars(int53 star_count_, string const &transaction_id_, int53 boosted_chat_id_, int53 giveaway_message_id_, bool is_unclaimed_, object_ptr<sticker> &&sticker_)
  : star_count_(star_count_)
  , transaction_id_(transaction_id_)
  , boosted_chat_id_(boosted_chat_id_)
  , giveaway_message_id_(giveaway_message_id_)
  , is_unclaimed_(is_unclaimed_)
  , sticker_(std::move(sticker_))
{}

const std::int32_t messageGiveawayPrizeStars::ID;

void messageGiveawayPrizeStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageGiveawayPrizeStars");
    s.store_field("star_count", star_count_);
    s.store_field("transaction_id", transaction_id_);
    s.store_field("boosted_chat_id", boosted_chat_id_);
    s.store_field("giveaway_message_id", giveaway_message_id_);
    s.store_field("is_unclaimed", is_unclaimed_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

messageGift::messageGift()
  : gift_()
  , sender_id_()
  , received_gift_id_()
  , text_()
  , sell_star_count_()
  , prepaid_upgrade_star_count_()
  , is_private_()
  , is_saved_()
  , can_be_upgraded_()
  , was_converted_()
  , was_upgraded_()
  , was_refunded_()
  , upgraded_received_gift_id_()
{}

messageGift::messageGift(object_ptr<gift> &&gift_, object_ptr<MessageSender> &&sender_id_, string const &received_gift_id_, object_ptr<formattedText> &&text_, int53 sell_star_count_, int53 prepaid_upgrade_star_count_, bool is_private_, bool is_saved_, bool can_be_upgraded_, bool was_converted_, bool was_upgraded_, bool was_refunded_, string const &upgraded_received_gift_id_)
  : gift_(std::move(gift_))
  , sender_id_(std::move(sender_id_))
  , received_gift_id_(received_gift_id_)
  , text_(std::move(text_))
  , sell_star_count_(sell_star_count_)
  , prepaid_upgrade_star_count_(prepaid_upgrade_star_count_)
  , is_private_(is_private_)
  , is_saved_(is_saved_)
  , can_be_upgraded_(can_be_upgraded_)
  , was_converted_(was_converted_)
  , was_upgraded_(was_upgraded_)
  , was_refunded_(was_refunded_)
  , upgraded_received_gift_id_(upgraded_received_gift_id_)
{}

const std::int32_t messageGift::ID;

void messageGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageGift");
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_object_field("sender_id", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_field("received_gift_id", received_gift_id_);
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("sell_star_count", sell_star_count_);
    s.store_field("prepaid_upgrade_star_count", prepaid_upgrade_star_count_);
    s.store_field("is_private", is_private_);
    s.store_field("is_saved", is_saved_);
    s.store_field("can_be_upgraded", can_be_upgraded_);
    s.store_field("was_converted", was_converted_);
    s.store_field("was_upgraded", was_upgraded_);
    s.store_field("was_refunded", was_refunded_);
    s.store_field("upgraded_received_gift_id", upgraded_received_gift_id_);
    s.store_class_end();
  }
}

messageUpgradedGift::messageUpgradedGift()
  : gift_()
  , sender_id_()
  , received_gift_id_()
  , is_upgrade_()
  , is_saved_()
  , can_be_transferred_()
  , was_transferred_()
  , transfer_star_count_()
  , export_date_()
{}

messageUpgradedGift::messageUpgradedGift(object_ptr<upgradedGift> &&gift_, object_ptr<MessageSender> &&sender_id_, string const &received_gift_id_, bool is_upgrade_, bool is_saved_, bool can_be_transferred_, bool was_transferred_, int53 transfer_star_count_, int32 export_date_)
  : gift_(std::move(gift_))
  , sender_id_(std::move(sender_id_))
  , received_gift_id_(received_gift_id_)
  , is_upgrade_(is_upgrade_)
  , is_saved_(is_saved_)
  , can_be_transferred_(can_be_transferred_)
  , was_transferred_(was_transferred_)
  , transfer_star_count_(transfer_star_count_)
  , export_date_(export_date_)
{}

const std::int32_t messageUpgradedGift::ID;

void messageUpgradedGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageUpgradedGift");
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_object_field("sender_id", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_field("received_gift_id", received_gift_id_);
    s.store_field("is_upgrade", is_upgrade_);
    s.store_field("is_saved", is_saved_);
    s.store_field("can_be_transferred", can_be_transferred_);
    s.store_field("was_transferred", was_transferred_);
    s.store_field("transfer_star_count", transfer_star_count_);
    s.store_field("export_date", export_date_);
    s.store_class_end();
  }
}

messageRefundedUpgradedGift::messageRefundedUpgradedGift()
  : gift_()
  , sender_id_()
  , is_upgrade_()
{}

messageRefundedUpgradedGift::messageRefundedUpgradedGift(object_ptr<gift> &&gift_, object_ptr<MessageSender> &&sender_id_, bool is_upgrade_)
  : gift_(std::move(gift_))
  , sender_id_(std::move(sender_id_))
  , is_upgrade_(is_upgrade_)
{}

const std::int32_t messageRefundedUpgradedGift::ID;

void messageRefundedUpgradedGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageRefundedUpgradedGift");
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_object_field("sender_id", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_field("is_upgrade", is_upgrade_);
    s.store_class_end();
  }
}

messageContactRegistered::messageContactRegistered() {
}

const std::int32_t messageContactRegistered::ID;

void messageContactRegistered::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageContactRegistered");
    s.store_class_end();
  }
}

messageUsersShared::messageUsersShared()
  : users_()
  , button_id_()
{}

messageUsersShared::messageUsersShared(array<object_ptr<sharedUser>> &&users_, int32 button_id_)
  : users_(std::move(users_))
  , button_id_(button_id_)
{}

const std::int32_t messageUsersShared::ID;

void messageUsersShared::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageUsersShared");
    { s.store_vector_begin("users", users_.size()); for (const auto &_value : users_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("button_id", button_id_);
    s.store_class_end();
  }
}

messageChatShared::messageChatShared()
  : chat_()
  , button_id_()
{}

messageChatShared::messageChatShared(object_ptr<sharedChat> &&chat_, int32 button_id_)
  : chat_(std::move(chat_))
  , button_id_(button_id_)
{}

const std::int32_t messageChatShared::ID;

void messageChatShared::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageChatShared");
    s.store_object_field("chat", static_cast<const BaseObject *>(chat_.get()));
    s.store_field("button_id", button_id_);
    s.store_class_end();
  }
}

messageBotWriteAccessAllowed::messageBotWriteAccessAllowed()
  : reason_()
{}

messageBotWriteAccessAllowed::messageBotWriteAccessAllowed(object_ptr<BotWriteAccessAllowReason> &&reason_)
  : reason_(std::move(reason_))
{}

const std::int32_t messageBotWriteAccessAllowed::ID;

void messageBotWriteAccessAllowed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageBotWriteAccessAllowed");
    s.store_object_field("reason", static_cast<const BaseObject *>(reason_.get()));
    s.store_class_end();
  }
}

messageWebAppDataSent::messageWebAppDataSent()
  : button_text_()
{}

messageWebAppDataSent::messageWebAppDataSent(string const &button_text_)
  : button_text_(button_text_)
{}

const std::int32_t messageWebAppDataSent::ID;

void messageWebAppDataSent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageWebAppDataSent");
    s.store_field("button_text", button_text_);
    s.store_class_end();
  }
}

messageWebAppDataReceived::messageWebAppDataReceived()
  : button_text_()
  , data_()
{}

messageWebAppDataReceived::messageWebAppDataReceived(string const &button_text_, string const &data_)
  : button_text_(button_text_)
  , data_(data_)
{}

const std::int32_t messageWebAppDataReceived::ID;

void messageWebAppDataReceived::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageWebAppDataReceived");
    s.store_field("button_text", button_text_);
    s.store_field("data", data_);
    s.store_class_end();
  }
}

messagePassportDataSent::messagePassportDataSent()
  : types_()
{}

messagePassportDataSent::messagePassportDataSent(array<object_ptr<PassportElementType>> &&types_)
  : types_(std::move(types_))
{}

const std::int32_t messagePassportDataSent::ID;

void messagePassportDataSent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePassportDataSent");
    { s.store_vector_begin("types", types_.size()); for (const auto &_value : types_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

messagePassportDataReceived::messagePassportDataReceived()
  : elements_()
  , credentials_()
{}

messagePassportDataReceived::messagePassportDataReceived(array<object_ptr<encryptedPassportElement>> &&elements_, object_ptr<encryptedCredentials> &&credentials_)
  : elements_(std::move(elements_))
  , credentials_(std::move(credentials_))
{}

const std::int32_t messagePassportDataReceived::ID;

void messagePassportDataReceived::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePassportDataReceived");
    { s.store_vector_begin("elements", elements_.size()); for (const auto &_value : elements_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("credentials", static_cast<const BaseObject *>(credentials_.get()));
    s.store_class_end();
  }
}

messageProximityAlertTriggered::messageProximityAlertTriggered()
  : traveler_id_()
  , watcher_id_()
  , distance_()
{}

messageProximityAlertTriggered::messageProximityAlertTriggered(object_ptr<MessageSender> &&traveler_id_, object_ptr<MessageSender> &&watcher_id_, int32 distance_)
  : traveler_id_(std::move(traveler_id_))
  , watcher_id_(std::move(watcher_id_))
  , distance_(distance_)
{}

const std::int32_t messageProximityAlertTriggered::ID;

void messageProximityAlertTriggered::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageProximityAlertTriggered");
    s.store_object_field("traveler_id", static_cast<const BaseObject *>(traveler_id_.get()));
    s.store_object_field("watcher_id", static_cast<const BaseObject *>(watcher_id_.get()));
    s.store_field("distance", distance_);
    s.store_class_end();
  }
}

messageUnsupported::messageUnsupported() {
}

const std::int32_t messageUnsupported::ID;

void messageUnsupported::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageUnsupported");
    s.store_class_end();
  }
}

messageCopyOptions::messageCopyOptions()
  : send_copy_()
  , replace_caption_()
  , new_caption_()
  , new_show_caption_above_media_()
{}

messageCopyOptions::messageCopyOptions(bool send_copy_, bool replace_caption_, object_ptr<formattedText> &&new_caption_, bool new_show_caption_above_media_)
  : send_copy_(send_copy_)
  , replace_caption_(replace_caption_)
  , new_caption_(std::move(new_caption_))
  , new_show_caption_above_media_(new_show_caption_above_media_)
{}

const std::int32_t messageCopyOptions::ID;

void messageCopyOptions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageCopyOptions");
    s.store_field("send_copy", send_copy_);
    s.store_field("replace_caption", replace_caption_);
    s.store_object_field("new_caption", static_cast<const BaseObject *>(new_caption_.get()));
    s.store_field("new_show_caption_above_media", new_show_caption_above_media_);
    s.store_class_end();
  }
}

messageEffect::messageEffect()
  : id_()
  , static_icon_()
  , emoji_()
  , is_premium_()
  , type_()
{}

messageEffect::messageEffect(int64 id_, object_ptr<sticker> &&static_icon_, string const &emoji_, bool is_premium_, object_ptr<MessageEffectType> &&type_)
  : id_(id_)
  , static_icon_(std::move(static_icon_))
  , emoji_(emoji_)
  , is_premium_(is_premium_)
  , type_(std::move(type_))
{}

const std::int32_t messageEffect::ID;

void messageEffect::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEffect");
    s.store_field("id", id_);
    s.store_object_field("static_icon", static_cast<const BaseObject *>(static_icon_.get()));
    s.store_field("emoji", emoji_);
    s.store_field("is_premium", is_premium_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

messageEffectTypeEmojiReaction::messageEffectTypeEmojiReaction()
  : select_animation_()
  , effect_animation_()
{}

messageEffectTypeEmojiReaction::messageEffectTypeEmojiReaction(object_ptr<sticker> &&select_animation_, object_ptr<sticker> &&effect_animation_)
  : select_animation_(std::move(select_animation_))
  , effect_animation_(std::move(effect_animation_))
{}

const std::int32_t messageEffectTypeEmojiReaction::ID;

void messageEffectTypeEmojiReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEffectTypeEmojiReaction");
    s.store_object_field("select_animation", static_cast<const BaseObject *>(select_animation_.get()));
    s.store_object_field("effect_animation", static_cast<const BaseObject *>(effect_animation_.get()));
    s.store_class_end();
  }
}

messageEffectTypePremiumSticker::messageEffectTypePremiumSticker()
  : sticker_()
{}

messageEffectTypePremiumSticker::messageEffectTypePremiumSticker(object_ptr<sticker> &&sticker_)
  : sticker_(std::move(sticker_))
{}

const std::int32_t messageEffectTypePremiumSticker::ID;

void messageEffectTypePremiumSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageEffectTypePremiumSticker");
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

messageFileTypePrivate::messageFileTypePrivate()
  : name_()
{}

messageFileTypePrivate::messageFileTypePrivate(string const &name_)
  : name_(name_)
{}

const std::int32_t messageFileTypePrivate::ID;

void messageFileTypePrivate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageFileTypePrivate");
    s.store_field("name", name_);
    s.store_class_end();
  }
}

messageFileTypeGroup::messageFileTypeGroup()
  : title_()
{}

messageFileTypeGroup::messageFileTypeGroup(string const &title_)
  : title_(title_)
{}

const std::int32_t messageFileTypeGroup::ID;

void messageFileTypeGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageFileTypeGroup");
    s.store_field("title", title_);
    s.store_class_end();
  }
}

messageFileTypeUnknown::messageFileTypeUnknown() {
}

const std::int32_t messageFileTypeUnknown::ID;

void messageFileTypeUnknown::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageFileTypeUnknown");
    s.store_class_end();
  }
}

messageForwardInfo::messageForwardInfo()
  : origin_()
  , date_()
  , source_()
  , public_service_announcement_type_()
{}

messageForwardInfo::messageForwardInfo(object_ptr<MessageOrigin> &&origin_, int32 date_, object_ptr<forwardSource> &&source_, string const &public_service_announcement_type_)
  : origin_(std::move(origin_))
  , date_(date_)
  , source_(std::move(source_))
  , public_service_announcement_type_(public_service_announcement_type_)
{}

const std::int32_t messageForwardInfo::ID;

void messageForwardInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageForwardInfo");
    s.store_object_field("origin", static_cast<const BaseObject *>(origin_.get()));
    s.store_field("date", date_);
    s.store_object_field("source", static_cast<const BaseObject *>(source_.get()));
    s.store_field("public_service_announcement_type", public_service_announcement_type_);
    s.store_class_end();
  }
}

messageImportInfo::messageImportInfo()
  : sender_name_()
  , date_()
{}

messageImportInfo::messageImportInfo(string const &sender_name_, int32 date_)
  : sender_name_(sender_name_)
  , date_(date_)
{}

const std::int32_t messageImportInfo::ID;

void messageImportInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageImportInfo");
    s.store_field("sender_name", sender_name_);
    s.store_field("date", date_);
    s.store_class_end();
  }
}

messageInteractionInfo::messageInteractionInfo()
  : view_count_()
  , forward_count_()
  , reply_info_()
  , reactions_()
{}

messageInteractionInfo::messageInteractionInfo(int32 view_count_, int32 forward_count_, object_ptr<messageReplyInfo> &&reply_info_, object_ptr<messageReactions> &&reactions_)
  : view_count_(view_count_)
  , forward_count_(forward_count_)
  , reply_info_(std::move(reply_info_))
  , reactions_(std::move(reactions_))
{}

const std::int32_t messageInteractionInfo::ID;

void messageInteractionInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageInteractionInfo");
    s.store_field("view_count", view_count_);
    s.store_field("forward_count", forward_count_);
    s.store_object_field("reply_info", static_cast<const BaseObject *>(reply_info_.get()));
    s.store_object_field("reactions", static_cast<const BaseObject *>(reactions_.get()));
    s.store_class_end();
  }
}

messageLink::messageLink()
  : link_()
  , is_public_()
{}

messageLink::messageLink(string const &link_, bool is_public_)
  : link_(link_)
  , is_public_(is_public_)
{}

const std::int32_t messageLink::ID;

void messageLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageLink");
    s.store_field("link", link_);
    s.store_field("is_public", is_public_);
    s.store_class_end();
  }
}

messageLinkInfo::messageLinkInfo()
  : is_public_()
  , chat_id_()
  , message_thread_id_()
  , message_()
  , media_timestamp_()
  , for_album_()
{}

messageLinkInfo::messageLinkInfo(bool is_public_, int53 chat_id_, int53 message_thread_id_, object_ptr<message> &&message_, int32 media_timestamp_, bool for_album_)
  : is_public_(is_public_)
  , chat_id_(chat_id_)
  , message_thread_id_(message_thread_id_)
  , message_(std::move(message_))
  , media_timestamp_(media_timestamp_)
  , for_album_(for_album_)
{}

const std::int32_t messageLinkInfo::ID;

void messageLinkInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageLinkInfo");
    s.store_field("is_public", is_public_);
    s.store_field("chat_id", chat_id_);
    s.store_field("message_thread_id", message_thread_id_);
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_field("media_timestamp", media_timestamp_);
    s.store_field("for_album", for_album_);
    s.store_class_end();
  }
}

messageOriginUser::messageOriginUser()
  : sender_user_id_()
{}

messageOriginUser::messageOriginUser(int53 sender_user_id_)
  : sender_user_id_(sender_user_id_)
{}

const std::int32_t messageOriginUser::ID;

void messageOriginUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageOriginUser");
    s.store_field("sender_user_id", sender_user_id_);
    s.store_class_end();
  }
}

messageOriginHiddenUser::messageOriginHiddenUser()
  : sender_name_()
{}

messageOriginHiddenUser::messageOriginHiddenUser(string const &sender_name_)
  : sender_name_(sender_name_)
{}

const std::int32_t messageOriginHiddenUser::ID;

void messageOriginHiddenUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageOriginHiddenUser");
    s.store_field("sender_name", sender_name_);
    s.store_class_end();
  }
}

messageOriginChat::messageOriginChat()
  : sender_chat_id_()
  , author_signature_()
{}

messageOriginChat::messageOriginChat(int53 sender_chat_id_, string const &author_signature_)
  : sender_chat_id_(sender_chat_id_)
  , author_signature_(author_signature_)
{}

const std::int32_t messageOriginChat::ID;

void messageOriginChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageOriginChat");
    s.store_field("sender_chat_id", sender_chat_id_);
    s.store_field("author_signature", author_signature_);
    s.store_class_end();
  }
}

messageOriginChannel::messageOriginChannel()
  : chat_id_()
  , message_id_()
  , author_signature_()
{}

messageOriginChannel::messageOriginChannel(int53 chat_id_, int53 message_id_, string const &author_signature_)
  : chat_id_(chat_id_)
  , message_id_(message_id_)
  , author_signature_(author_signature_)
{}

const std::int32_t messageOriginChannel::ID;

void messageOriginChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageOriginChannel");
    s.store_field("chat_id", chat_id_);
    s.store_field("message_id", message_id_);
    s.store_field("author_signature", author_signature_);
    s.store_class_end();
  }
}

messagePosition::messagePosition()
  : position_()
  , message_id_()
  , date_()
{}

messagePosition::messagePosition(int32 position_, int53 message_id_, int32 date_)
  : position_(position_)
  , message_id_(message_id_)
  , date_(date_)
{}

const std::int32_t messagePosition::ID;

void messagePosition::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePosition");
    s.store_field("position", position_);
    s.store_field("message_id", message_id_);
    s.store_field("date", date_);
    s.store_class_end();
  }
}

messagePositions::messagePositions()
  : total_count_()
  , positions_()
{}

messagePositions::messagePositions(int32 total_count_, array<object_ptr<messagePosition>> &&positions_)
  : total_count_(total_count_)
  , positions_(std::move(positions_))
{}

const std::int32_t messagePositions::ID;

void messagePositions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messagePositions");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("positions", positions_.size()); for (const auto &_value : positions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageProperties::messageProperties()
  : can_be_copied_to_secret_chat_()
  , can_be_deleted_only_for_self_()
  , can_be_deleted_for_all_users_()
  , can_be_edited_()
  , can_be_forwarded_()
  , can_be_paid_()
  , can_be_pinned_()
  , can_be_replied_()
  , can_be_replied_in_another_chat_()
  , can_be_saved_()
  , can_be_shared_in_story_()
  , can_edit_media_()
  , can_edit_scheduling_state_()
  , can_get_embedding_code_()
  , can_get_link_()
  , can_get_media_timestamp_links_()
  , can_get_message_thread_()
  , can_get_read_date_()
  , can_get_statistics_()
  , can_get_viewers_()
  , can_recognize_speech_()
  , can_report_chat_()
  , can_report_reactions_()
  , can_report_supergroup_spam_()
  , can_set_fact_check_()
  , need_show_statistics_()
{}

messageProperties::messageProperties(bool can_be_copied_to_secret_chat_, bool can_be_deleted_only_for_self_, bool can_be_deleted_for_all_users_, bool can_be_edited_, bool can_be_forwarded_, bool can_be_paid_, bool can_be_pinned_, bool can_be_replied_, bool can_be_replied_in_another_chat_, bool can_be_saved_, bool can_be_shared_in_story_, bool can_edit_media_, bool can_edit_scheduling_state_, bool can_get_embedding_code_, bool can_get_link_, bool can_get_media_timestamp_links_, bool can_get_message_thread_, bool can_get_read_date_, bool can_get_statistics_, bool can_get_viewers_, bool can_recognize_speech_, bool can_report_chat_, bool can_report_reactions_, bool can_report_supergroup_spam_, bool can_set_fact_check_, bool need_show_statistics_)
  : can_be_copied_to_secret_chat_(can_be_copied_to_secret_chat_)
  , can_be_deleted_only_for_self_(can_be_deleted_only_for_self_)
  , can_be_deleted_for_all_users_(can_be_deleted_for_all_users_)
  , can_be_edited_(can_be_edited_)
  , can_be_forwarded_(can_be_forwarded_)
  , can_be_paid_(can_be_paid_)
  , can_be_pinned_(can_be_pinned_)
  , can_be_replied_(can_be_replied_)
  , can_be_replied_in_another_chat_(can_be_replied_in_another_chat_)
  , can_be_saved_(can_be_saved_)
  , can_be_shared_in_story_(can_be_shared_in_story_)
  , can_edit_media_(can_edit_media_)
  , can_edit_scheduling_state_(can_edit_scheduling_state_)
  , can_get_embedding_code_(can_get_embedding_code_)
  , can_get_link_(can_get_link_)
  , can_get_media_timestamp_links_(can_get_media_timestamp_links_)
  , can_get_message_thread_(can_get_message_thread_)
  , can_get_read_date_(can_get_read_date_)
  , can_get_statistics_(can_get_statistics_)
  , can_get_viewers_(can_get_viewers_)
  , can_recognize_speech_(can_recognize_speech_)
  , can_report_chat_(can_report_chat_)
  , can_report_reactions_(can_report_reactions_)
  , can_report_supergroup_spam_(can_report_supergroup_spam_)
  , can_set_fact_check_(can_set_fact_check_)
  , need_show_statistics_(need_show_statistics_)
{}

const std::int32_t messageProperties::ID;

void messageProperties::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageProperties");
    s.store_field("can_be_copied_to_secret_chat", can_be_copied_to_secret_chat_);
    s.store_field("can_be_deleted_only_for_self", can_be_deleted_only_for_self_);
    s.store_field("can_be_deleted_for_all_users", can_be_deleted_for_all_users_);
    s.store_field("can_be_edited", can_be_edited_);
    s.store_field("can_be_forwarded", can_be_forwarded_);
    s.store_field("can_be_paid", can_be_paid_);
    s.store_field("can_be_pinned", can_be_pinned_);
    s.store_field("can_be_replied", can_be_replied_);
    s.store_field("can_be_replied_in_another_chat", can_be_replied_in_another_chat_);
    s.store_field("can_be_saved", can_be_saved_);
    s.store_field("can_be_shared_in_story", can_be_shared_in_story_);
    s.store_field("can_edit_media", can_edit_media_);
    s.store_field("can_edit_scheduling_state", can_edit_scheduling_state_);
    s.store_field("can_get_embedding_code", can_get_embedding_code_);
    s.store_field("can_get_link", can_get_link_);
    s.store_field("can_get_media_timestamp_links", can_get_media_timestamp_links_);
    s.store_field("can_get_message_thread", can_get_message_thread_);
    s.store_field("can_get_read_date", can_get_read_date_);
    s.store_field("can_get_statistics", can_get_statistics_);
    s.store_field("can_get_viewers", can_get_viewers_);
    s.store_field("can_recognize_speech", can_recognize_speech_);
    s.store_field("can_report_chat", can_report_chat_);
    s.store_field("can_report_reactions", can_report_reactions_);
    s.store_field("can_report_supergroup_spam", can_report_supergroup_spam_);
    s.store_field("can_set_fact_check", can_set_fact_check_);
    s.store_field("need_show_statistics", need_show_statistics_);
    s.store_class_end();
  }
}

messageReaction::messageReaction()
  : type_()
  , total_count_()
  , is_chosen_()
  , used_sender_id_()
  , recent_sender_ids_()
{}

messageReaction::messageReaction(object_ptr<ReactionType> &&type_, int32 total_count_, bool is_chosen_, object_ptr<MessageSender> &&used_sender_id_, array<object_ptr<MessageSender>> &&recent_sender_ids_)
  : type_(std::move(type_))
  , total_count_(total_count_)
  , is_chosen_(is_chosen_)
  , used_sender_id_(std::move(used_sender_id_))
  , recent_sender_ids_(std::move(recent_sender_ids_))
{}

const std::int32_t messageReaction::ID;

void messageReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReaction");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("total_count", total_count_);
    s.store_field("is_chosen", is_chosen_);
    s.store_object_field("used_sender_id", static_cast<const BaseObject *>(used_sender_id_.get()));
    { s.store_vector_begin("recent_sender_ids", recent_sender_ids_.size()); for (const auto &_value : recent_sender_ids_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageReactions::messageReactions()
  : reactions_()
  , are_tags_()
  , paid_reactors_()
  , can_get_added_reactions_()
{}

messageReactions::messageReactions(array<object_ptr<messageReaction>> &&reactions_, bool are_tags_, array<object_ptr<paidReactor>> &&paid_reactors_, bool can_get_added_reactions_)
  : reactions_(std::move(reactions_))
  , are_tags_(are_tags_)
  , paid_reactors_(std::move(paid_reactors_))
  , can_get_added_reactions_(can_get_added_reactions_)
{}

const std::int32_t messageReactions::ID;

void messageReactions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReactions");
    { s.store_vector_begin("reactions", reactions_.size()); for (const auto &_value : reactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("are_tags", are_tags_);
    { s.store_vector_begin("paid_reactors", paid_reactors_.size()); for (const auto &_value : paid_reactors_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("can_get_added_reactions", can_get_added_reactions_);
    s.store_class_end();
  }
}

messageReadDateRead::messageReadDateRead()
  : read_date_()
{}

messageReadDateRead::messageReadDateRead(int32 read_date_)
  : read_date_(read_date_)
{}

const std::int32_t messageReadDateRead::ID;

void messageReadDateRead::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReadDateRead");
    s.store_field("read_date", read_date_);
    s.store_class_end();
  }
}

messageReadDateUnread::messageReadDateUnread() {
}

const std::int32_t messageReadDateUnread::ID;

void messageReadDateUnread::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReadDateUnread");
    s.store_class_end();
  }
}

messageReadDateTooOld::messageReadDateTooOld() {
}

const std::int32_t messageReadDateTooOld::ID;

void messageReadDateTooOld::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReadDateTooOld");
    s.store_class_end();
  }
}

messageReadDateUserPrivacyRestricted::messageReadDateUserPrivacyRestricted() {
}

const std::int32_t messageReadDateUserPrivacyRestricted::ID;

void messageReadDateUserPrivacyRestricted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReadDateUserPrivacyRestricted");
    s.store_class_end();
  }
}

messageReadDateMyPrivacyRestricted::messageReadDateMyPrivacyRestricted() {
}

const std::int32_t messageReadDateMyPrivacyRestricted::ID;

void messageReadDateMyPrivacyRestricted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReadDateMyPrivacyRestricted");
    s.store_class_end();
  }
}

messageReplyInfo::messageReplyInfo()
  : reply_count_()
  , recent_replier_ids_()
  , last_read_inbox_message_id_()
  , last_read_outbox_message_id_()
  , last_message_id_()
{}

messageReplyInfo::messageReplyInfo(int32 reply_count_, array<object_ptr<MessageSender>> &&recent_replier_ids_, int53 last_read_inbox_message_id_, int53 last_read_outbox_message_id_, int53 last_message_id_)
  : reply_count_(reply_count_)
  , recent_replier_ids_(std::move(recent_replier_ids_))
  , last_read_inbox_message_id_(last_read_inbox_message_id_)
  , last_read_outbox_message_id_(last_read_outbox_message_id_)
  , last_message_id_(last_message_id_)
{}

const std::int32_t messageReplyInfo::ID;

void messageReplyInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReplyInfo");
    s.store_field("reply_count", reply_count_);
    { s.store_vector_begin("recent_replier_ids", recent_replier_ids_.size()); for (const auto &_value : recent_replier_ids_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("last_read_inbox_message_id", last_read_inbox_message_id_);
    s.store_field("last_read_outbox_message_id", last_read_outbox_message_id_);
    s.store_field("last_message_id", last_message_id_);
    s.store_class_end();
  }
}

messageReplyToMessage::messageReplyToMessage()
  : chat_id_()
  , message_id_()
  , quote_()
  , origin_()
  , origin_send_date_()
  , content_()
{}

messageReplyToMessage::messageReplyToMessage(int53 chat_id_, int53 message_id_, object_ptr<textQuote> &&quote_, object_ptr<MessageOrigin> &&origin_, int32 origin_send_date_, object_ptr<MessageContent> &&content_)
  : chat_id_(chat_id_)
  , message_id_(message_id_)
  , quote_(std::move(quote_))
  , origin_(std::move(origin_))
  , origin_send_date_(origin_send_date_)
  , content_(std::move(content_))
{}

const std::int32_t messageReplyToMessage::ID;

void messageReplyToMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReplyToMessage");
    s.store_field("chat_id", chat_id_);
    s.store_field("message_id", message_id_);
    s.store_object_field("quote", static_cast<const BaseObject *>(quote_.get()));
    s.store_object_field("origin", static_cast<const BaseObject *>(origin_.get()));
    s.store_field("origin_send_date", origin_send_date_);
    s.store_object_field("content", static_cast<const BaseObject *>(content_.get()));
    s.store_class_end();
  }
}

messageReplyToStory::messageReplyToStory()
  : story_sender_chat_id_()
  , story_id_()
{}

messageReplyToStory::messageReplyToStory(int53 story_sender_chat_id_, int32 story_id_)
  : story_sender_chat_id_(story_sender_chat_id_)
  , story_id_(story_id_)
{}

const std::int32_t messageReplyToStory::ID;

void messageReplyToStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageReplyToStory");
    s.store_field("story_sender_chat_id", story_sender_chat_id_);
    s.store_field("story_id", story_id_);
    s.store_class_end();
  }
}

messageSchedulingStateSendAtDate::messageSchedulingStateSendAtDate()
  : send_date_()
{}

messageSchedulingStateSendAtDate::messageSchedulingStateSendAtDate(int32 send_date_)
  : send_date_(send_date_)
{}

const std::int32_t messageSchedulingStateSendAtDate::ID;

void messageSchedulingStateSendAtDate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSchedulingStateSendAtDate");
    s.store_field("send_date", send_date_);
    s.store_class_end();
  }
}

messageSchedulingStateSendWhenOnline::messageSchedulingStateSendWhenOnline() {
}

const std::int32_t messageSchedulingStateSendWhenOnline::ID;

void messageSchedulingStateSendWhenOnline::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSchedulingStateSendWhenOnline");
    s.store_class_end();
  }
}

messageSchedulingStateSendWhenVideoProcessed::messageSchedulingStateSendWhenVideoProcessed()
  : send_date_()
{}

messageSchedulingStateSendWhenVideoProcessed::messageSchedulingStateSendWhenVideoProcessed(int32 send_date_)
  : send_date_(send_date_)
{}

const std::int32_t messageSchedulingStateSendWhenVideoProcessed::ID;

void messageSchedulingStateSendWhenVideoProcessed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSchedulingStateSendWhenVideoProcessed");
    s.store_field("send_date", send_date_);
    s.store_class_end();
  }
}

messageSelfDestructTypeTimer::messageSelfDestructTypeTimer()
  : self_destruct_time_()
{}

messageSelfDestructTypeTimer::messageSelfDestructTypeTimer(int32 self_destruct_time_)
  : self_destruct_time_(self_destruct_time_)
{}

const std::int32_t messageSelfDestructTypeTimer::ID;

void messageSelfDestructTypeTimer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSelfDestructTypeTimer");
    s.store_field("self_destruct_time", self_destruct_time_);
    s.store_class_end();
  }
}

messageSelfDestructTypeImmediately::messageSelfDestructTypeImmediately() {
}

const std::int32_t messageSelfDestructTypeImmediately::ID;

void messageSelfDestructTypeImmediately::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSelfDestructTypeImmediately");
    s.store_class_end();
  }
}

messageSendOptions::messageSendOptions()
  : disable_notification_()
  , from_background_()
  , protect_content_()
  , allow_paid_broadcast_()
  , update_order_of_installed_sticker_sets_()
  , scheduling_state_()
  , effect_id_()
  , sending_id_()
  , only_preview_()
{}

messageSendOptions::messageSendOptions(bool disable_notification_, bool from_background_, bool protect_content_, bool allow_paid_broadcast_, bool update_order_of_installed_sticker_sets_, object_ptr<MessageSchedulingState> &&scheduling_state_, int64 effect_id_, int32 sending_id_, bool only_preview_)
  : disable_notification_(disable_notification_)
  , from_background_(from_background_)
  , protect_content_(protect_content_)
  , allow_paid_broadcast_(allow_paid_broadcast_)
  , update_order_of_installed_sticker_sets_(update_order_of_installed_sticker_sets_)
  , scheduling_state_(std::move(scheduling_state_))
  , effect_id_(effect_id_)
  , sending_id_(sending_id_)
  , only_preview_(only_preview_)
{}

const std::int32_t messageSendOptions::ID;

void messageSendOptions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSendOptions");
    s.store_field("disable_notification", disable_notification_);
    s.store_field("from_background", from_background_);
    s.store_field("protect_content", protect_content_);
    s.store_field("allow_paid_broadcast", allow_paid_broadcast_);
    s.store_field("update_order_of_installed_sticker_sets", update_order_of_installed_sticker_sets_);
    s.store_object_field("scheduling_state", static_cast<const BaseObject *>(scheduling_state_.get()));
    s.store_field("effect_id", effect_id_);
    s.store_field("sending_id", sending_id_);
    s.store_field("only_preview", only_preview_);
    s.store_class_end();
  }
}

messageSenderUser::messageSenderUser()
  : user_id_()
{}

messageSenderUser::messageSenderUser(int53 user_id_)
  : user_id_(user_id_)
{}

const std::int32_t messageSenderUser::ID;

void messageSenderUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSenderUser");
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

messageSenderChat::messageSenderChat()
  : chat_id_()
{}

messageSenderChat::messageSenderChat(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t messageSenderChat::ID;

void messageSenderChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSenderChat");
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

messageSenders::messageSenders()
  : total_count_()
  , senders_()
{}

messageSenders::messageSenders(int32 total_count_, array<object_ptr<MessageSender>> &&senders_)
  : total_count_(total_count_)
  , senders_(std::move(senders_))
{}

const std::int32_t messageSenders::ID;

void messageSenders::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSenders");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("senders", senders_.size()); for (const auto &_value : senders_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

messageSendingStatePending::messageSendingStatePending()
  : sending_id_()
{}

messageSendingStatePending::messageSendingStatePending(int32 sending_id_)
  : sending_id_(sending_id_)
{}

const std::int32_t messageSendingStatePending::ID;

void messageSendingStatePending::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSendingStatePending");
    s.store_field("sending_id", sending_id_);
    s.store_class_end();
  }
}

messageSendingStateFailed::messageSendingStateFailed()
  : error_()
  , can_retry_()
  , need_another_sender_()
  , need_another_reply_quote_()
  , need_drop_reply_()
  , retry_after_()
{}

messageSendingStateFailed::messageSendingStateFailed(object_ptr<error> &&error_, bool can_retry_, bool need_another_sender_, bool need_another_reply_quote_, bool need_drop_reply_, double retry_after_)
  : error_(std::move(error_))
  , can_retry_(can_retry_)
  , need_another_sender_(need_another_sender_)
  , need_another_reply_quote_(need_another_reply_quote_)
  , need_drop_reply_(need_drop_reply_)
  , retry_after_(retry_after_)
{}

const std::int32_t messageSendingStateFailed::ID;

void messageSendingStateFailed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSendingStateFailed");
    s.store_object_field("error", static_cast<const BaseObject *>(error_.get()));
    s.store_field("can_retry", can_retry_);
    s.store_field("need_another_sender", need_another_sender_);
    s.store_field("need_another_reply_quote", need_another_reply_quote_);
    s.store_field("need_drop_reply", need_drop_reply_);
    s.store_field("retry_after", retry_after_);
    s.store_class_end();
  }
}

messageSourceChatHistory::messageSourceChatHistory() {
}

const std::int32_t messageSourceChatHistory::ID;

void messageSourceChatHistory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSourceChatHistory");
    s.store_class_end();
  }
}

messageSourceMessageThreadHistory::messageSourceMessageThreadHistory() {
}

const std::int32_t messageSourceMessageThreadHistory::ID;

void messageSourceMessageThreadHistory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSourceMessageThreadHistory");
    s.store_class_end();
  }
}

messageSourceForumTopicHistory::messageSourceForumTopicHistory() {
}

const std::int32_t messageSourceForumTopicHistory::ID;

void messageSourceForumTopicHistory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSourceForumTopicHistory");
    s.store_class_end();
  }
}

messageSourceHistoryPreview::messageSourceHistoryPreview() {
}

const std::int32_t messageSourceHistoryPreview::ID;

void messageSourceHistoryPreview::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSourceHistoryPreview");
    s.store_class_end();
  }
}

messageSourceChatList::messageSourceChatList() {
}

const std::int32_t messageSourceChatList::ID;

void messageSourceChatList::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSourceChatList");
    s.store_class_end();
  }
}

messageSourceSearch::messageSourceSearch() {
}

const std::int32_t messageSourceSearch::ID;

void messageSourceSearch::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSourceSearch");
    s.store_class_end();
  }
}

messageSourceChatEventLog::messageSourceChatEventLog() {
}

const std::int32_t messageSourceChatEventLog::ID;

void messageSourceChatEventLog::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSourceChatEventLog");
    s.store_class_end();
  }
}

messageSourceNotification::messageSourceNotification() {
}

const std::int32_t messageSourceNotification::ID;

void messageSourceNotification::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSourceNotification");
    s.store_class_end();
  }
}

messageSourceScreenshot::messageSourceScreenshot() {
}

const std::int32_t messageSourceScreenshot::ID;

void messageSourceScreenshot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSourceScreenshot");
    s.store_class_end();
  }
}

messageSourceOther::messageSourceOther() {
}

const std::int32_t messageSourceOther::ID;

void messageSourceOther::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSourceOther");
    s.store_class_end();
  }
}

messageSponsor::messageSponsor()
  : url_()
  , photo_()
  , info_()
{}

messageSponsor::messageSponsor(string const &url_, object_ptr<photo> &&photo_, string const &info_)
  : url_(url_)
  , photo_(std::move(photo_))
  , info_(info_)
{}

const std::int32_t messageSponsor::ID;

void messageSponsor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageSponsor");
    s.store_field("url", url_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("info", info_);
    s.store_class_end();
  }
}

messageStatistics::messageStatistics()
  : message_interaction_graph_()
  , message_reaction_graph_()
{}

messageStatistics::messageStatistics(object_ptr<StatisticalGraph> &&message_interaction_graph_, object_ptr<StatisticalGraph> &&message_reaction_graph_)
  : message_interaction_graph_(std::move(message_interaction_graph_))
  , message_reaction_graph_(std::move(message_reaction_graph_))
{}

const std::int32_t messageStatistics::ID;

void messageStatistics::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageStatistics");
    s.store_object_field("message_interaction_graph", static_cast<const BaseObject *>(message_interaction_graph_.get()));
    s.store_object_field("message_reaction_graph", static_cast<const BaseObject *>(message_reaction_graph_.get()));
    s.store_class_end();
  }
}

messageThreadInfo::messageThreadInfo()
  : chat_id_()
  , message_thread_id_()
  , reply_info_()
  , unread_message_count_()
  , messages_()
  , draft_message_()
{}

messageThreadInfo::messageThreadInfo(int53 chat_id_, int53 message_thread_id_, object_ptr<messageReplyInfo> &&reply_info_, int32 unread_message_count_, array<object_ptr<message>> &&messages_, object_ptr<draftMessage> &&draft_message_)
  : chat_id_(chat_id_)
  , message_thread_id_(message_thread_id_)
  , reply_info_(std::move(reply_info_))
  , unread_message_count_(unread_message_count_)
  , messages_(std::move(messages_))
  , draft_message_(std::move(draft_message_))
{}

const std::int32_t messageThreadInfo::ID;

void messageThreadInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageThreadInfo");
    s.store_field("chat_id", chat_id_);
    s.store_field("message_thread_id", message_thread_id_);
    s.store_object_field("reply_info", static_cast<const BaseObject *>(reply_info_.get()));
    s.store_field("unread_message_count", unread_message_count_);
    { s.store_vector_begin("messages", messages_.size()); for (const auto &_value : messages_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("draft_message", static_cast<const BaseObject *>(draft_message_.get()));
    s.store_class_end();
  }
}

messageViewer::messageViewer()
  : user_id_()
  , view_date_()
{}

messageViewer::messageViewer(int53 user_id_, int32 view_date_)
  : user_id_(user_id_)
  , view_date_(view_date_)
{}

const std::int32_t messageViewer::ID;

void messageViewer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageViewer");
    s.store_field("user_id", user_id_);
    s.store_field("view_date", view_date_);
    s.store_class_end();
  }
}

messageViewers::messageViewers()
  : viewers_()
{}

messageViewers::messageViewers(array<object_ptr<messageViewer>> &&viewers_)
  : viewers_(std::move(viewers_))
{}

const std::int32_t messageViewers::ID;

void messageViewers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messageViewers");
    { s.store_vector_begin("viewers", viewers_.size()); for (const auto &_value : viewers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

messages::messages()
  : total_count_()
  , messages_()
{}

messages::messages(int32 total_count_, array<object_ptr<message>> &&messages_)
  : total_count_(total_count_)
  , messages_(std::move(messages_))
{}

const std::int32_t messages::ID;

void messages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "messages");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("messages", messages_.size()); for (const auto &_value : messages_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

minithumbnail::minithumbnail()
  : width_()
  , height_()
  , data_()
{}

minithumbnail::minithumbnail(int32 width_, int32 height_, bytes const &data_)
  : width_(width_)
  , height_(height_)
  , data_(std::move(data_))
{}

const std::int32_t minithumbnail::ID;

void minithumbnail::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "minithumbnail");
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_bytes_field("data", data_);
    s.store_class_end();
  }
}

networkStatistics::networkStatistics()
  : since_date_()
  , entries_()
{}

networkStatistics::networkStatistics(int32 since_date_, array<object_ptr<NetworkStatisticsEntry>> &&entries_)
  : since_date_(since_date_)
  , entries_(std::move(entries_))
{}

const std::int32_t networkStatistics::ID;

void networkStatistics::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "networkStatistics");
    s.store_field("since_date", since_date_);
    { s.store_vector_begin("entries", entries_.size()); for (const auto &_value : entries_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

networkStatisticsEntryFile::networkStatisticsEntryFile()
  : file_type_()
  , network_type_()
  , sent_bytes_()
  , received_bytes_()
{}

networkStatisticsEntryFile::networkStatisticsEntryFile(object_ptr<FileType> &&file_type_, object_ptr<NetworkType> &&network_type_, int53 sent_bytes_, int53 received_bytes_)
  : file_type_(std::move(file_type_))
  , network_type_(std::move(network_type_))
  , sent_bytes_(sent_bytes_)
  , received_bytes_(received_bytes_)
{}

const std::int32_t networkStatisticsEntryFile::ID;

void networkStatisticsEntryFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "networkStatisticsEntryFile");
    s.store_object_field("file_type", static_cast<const BaseObject *>(file_type_.get()));
    s.store_object_field("network_type", static_cast<const BaseObject *>(network_type_.get()));
    s.store_field("sent_bytes", sent_bytes_);
    s.store_field("received_bytes", received_bytes_);
    s.store_class_end();
  }
}

networkStatisticsEntryCall::networkStatisticsEntryCall()
  : network_type_()
  , sent_bytes_()
  , received_bytes_()
  , duration_()
{}

networkStatisticsEntryCall::networkStatisticsEntryCall(object_ptr<NetworkType> &&network_type_, int53 sent_bytes_, int53 received_bytes_, double duration_)
  : network_type_(std::move(network_type_))
  , sent_bytes_(sent_bytes_)
  , received_bytes_(received_bytes_)
  , duration_(duration_)
{}

const std::int32_t networkStatisticsEntryCall::ID;

void networkStatisticsEntryCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "networkStatisticsEntryCall");
    s.store_object_field("network_type", static_cast<const BaseObject *>(network_type_.get()));
    s.store_field("sent_bytes", sent_bytes_);
    s.store_field("received_bytes", received_bytes_);
    s.store_field("duration", duration_);
    s.store_class_end();
  }
}

networkTypeNone::networkTypeNone() {
}

const std::int32_t networkTypeNone::ID;

void networkTypeNone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "networkTypeNone");
    s.store_class_end();
  }
}

networkTypeMobile::networkTypeMobile() {
}

const std::int32_t networkTypeMobile::ID;

void networkTypeMobile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "networkTypeMobile");
    s.store_class_end();
  }
}

networkTypeMobileRoaming::networkTypeMobileRoaming() {
}

const std::int32_t networkTypeMobileRoaming::ID;

void networkTypeMobileRoaming::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "networkTypeMobileRoaming");
    s.store_class_end();
  }
}

networkTypeWiFi::networkTypeWiFi() {
}

const std::int32_t networkTypeWiFi::ID;

void networkTypeWiFi::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "networkTypeWiFi");
    s.store_class_end();
  }
}

networkTypeOther::networkTypeOther() {
}

const std::int32_t networkTypeOther::ID;

void networkTypeOther::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "networkTypeOther");
    s.store_class_end();
  }
}

newChatPrivacySettings::newChatPrivacySettings()
  : allow_new_chats_from_unknown_users_()
{}

newChatPrivacySettings::newChatPrivacySettings(bool allow_new_chats_from_unknown_users_)
  : allow_new_chats_from_unknown_users_(allow_new_chats_from_unknown_users_)
{}

const std::int32_t newChatPrivacySettings::ID;

void newChatPrivacySettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "newChatPrivacySettings");
    s.store_field("allow_new_chats_from_unknown_users", allow_new_chats_from_unknown_users_);
    s.store_class_end();
  }
}

notification::notification()
  : id_()
  , date_()
  , is_silent_()
  , type_()
{}

notification::notification(int32 id_, int32 date_, bool is_silent_, object_ptr<NotificationType> &&type_)
  : id_(id_)
  , date_(date_)
  , is_silent_(is_silent_)
  , type_(std::move(type_))
{}

const std::int32_t notification::ID;

void notification::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notification");
    s.store_field("id", id_);
    s.store_field("date", date_);
    s.store_field("is_silent", is_silent_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

notificationGroup::notificationGroup()
  : id_()
  , type_()
  , chat_id_()
  , total_count_()
  , notifications_()
{}

notificationGroup::notificationGroup(int32 id_, object_ptr<NotificationGroupType> &&type_, int53 chat_id_, int32 total_count_, array<object_ptr<notification>> &&notifications_)
  : id_(id_)
  , type_(std::move(type_))
  , chat_id_(chat_id_)
  , total_count_(total_count_)
  , notifications_(std::move(notifications_))
{}

const std::int32_t notificationGroup::ID;

void notificationGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationGroup");
    s.store_field("id", id_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("chat_id", chat_id_);
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("notifications", notifications_.size()); for (const auto &_value : notifications_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

notificationGroupTypeMessages::notificationGroupTypeMessages() {
}

const std::int32_t notificationGroupTypeMessages::ID;

void notificationGroupTypeMessages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationGroupTypeMessages");
    s.store_class_end();
  }
}

notificationGroupTypeMentions::notificationGroupTypeMentions() {
}

const std::int32_t notificationGroupTypeMentions::ID;

void notificationGroupTypeMentions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationGroupTypeMentions");
    s.store_class_end();
  }
}

notificationGroupTypeSecretChat::notificationGroupTypeSecretChat() {
}

const std::int32_t notificationGroupTypeSecretChat::ID;

void notificationGroupTypeSecretChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationGroupTypeSecretChat");
    s.store_class_end();
  }
}

notificationGroupTypeCalls::notificationGroupTypeCalls() {
}

const std::int32_t notificationGroupTypeCalls::ID;

void notificationGroupTypeCalls::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationGroupTypeCalls");
    s.store_class_end();
  }
}

notificationSettingsScopePrivateChats::notificationSettingsScopePrivateChats() {
}

const std::int32_t notificationSettingsScopePrivateChats::ID;

void notificationSettingsScopePrivateChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationSettingsScopePrivateChats");
    s.store_class_end();
  }
}

notificationSettingsScopeGroupChats::notificationSettingsScopeGroupChats() {
}

const std::int32_t notificationSettingsScopeGroupChats::ID;

void notificationSettingsScopeGroupChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationSettingsScopeGroupChats");
    s.store_class_end();
  }
}

notificationSettingsScopeChannelChats::notificationSettingsScopeChannelChats() {
}

const std::int32_t notificationSettingsScopeChannelChats::ID;

void notificationSettingsScopeChannelChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationSettingsScopeChannelChats");
    s.store_class_end();
  }
}

notificationSound::notificationSound()
  : id_()
  , duration_()
  , date_()
  , title_()
  , data_()
  , sound_()
{}

notificationSound::notificationSound(int64 id_, int32 duration_, int32 date_, string const &title_, string const &data_, object_ptr<file> &&sound_)
  : id_(id_)
  , duration_(duration_)
  , date_(date_)
  , title_(title_)
  , data_(data_)
  , sound_(std::move(sound_))
{}

const std::int32_t notificationSound::ID;

void notificationSound::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationSound");
    s.store_field("id", id_);
    s.store_field("duration", duration_);
    s.store_field("date", date_);
    s.store_field("title", title_);
    s.store_field("data", data_);
    s.store_object_field("sound", static_cast<const BaseObject *>(sound_.get()));
    s.store_class_end();
  }
}

notificationSounds::notificationSounds()
  : notification_sounds_()
{}

notificationSounds::notificationSounds(array<object_ptr<notificationSound>> &&notification_sounds_)
  : notification_sounds_(std::move(notification_sounds_))
{}

const std::int32_t notificationSounds::ID;

void notificationSounds::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationSounds");
    { s.store_vector_begin("notification_sounds", notification_sounds_.size()); for (const auto &_value : notification_sounds_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

notificationTypeNewMessage::notificationTypeNewMessage()
  : message_()
  , show_preview_()
{}

notificationTypeNewMessage::notificationTypeNewMessage(object_ptr<message> &&message_, bool show_preview_)
  : message_(std::move(message_))
  , show_preview_(show_preview_)
{}

const std::int32_t notificationTypeNewMessage::ID;

void notificationTypeNewMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationTypeNewMessage");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_field("show_preview", show_preview_);
    s.store_class_end();
  }
}

notificationTypeNewSecretChat::notificationTypeNewSecretChat() {
}

const std::int32_t notificationTypeNewSecretChat::ID;

void notificationTypeNewSecretChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationTypeNewSecretChat");
    s.store_class_end();
  }
}

notificationTypeNewCall::notificationTypeNewCall()
  : call_id_()
{}

notificationTypeNewCall::notificationTypeNewCall(int32 call_id_)
  : call_id_(call_id_)
{}

const std::int32_t notificationTypeNewCall::ID;

void notificationTypeNewCall::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationTypeNewCall");
    s.store_field("call_id", call_id_);
    s.store_class_end();
  }
}

notificationTypeNewPushMessage::notificationTypeNewPushMessage()
  : message_id_()
  , sender_id_()
  , sender_name_()
  , is_outgoing_()
  , content_()
{}

notificationTypeNewPushMessage::notificationTypeNewPushMessage(int53 message_id_, object_ptr<MessageSender> &&sender_id_, string const &sender_name_, bool is_outgoing_, object_ptr<PushMessageContent> &&content_)
  : message_id_(message_id_)
  , sender_id_(std::move(sender_id_))
  , sender_name_(sender_name_)
  , is_outgoing_(is_outgoing_)
  , content_(std::move(content_))
{}

const std::int32_t notificationTypeNewPushMessage::ID;

void notificationTypeNewPushMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "notificationTypeNewPushMessage");
    s.store_field("message_id", message_id_);
    s.store_object_field("sender_id", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_field("sender_name", sender_name_);
    s.store_field("is_outgoing", is_outgoing_);
    s.store_object_field("content", static_cast<const BaseObject *>(content_.get()));
    s.store_class_end();
  }
}

ok::ok() {
}

const std::int32_t ok::ID;

void ok::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "ok");
    s.store_class_end();
  }
}

optionValueBoolean::optionValueBoolean()
  : value_()
{}

optionValueBoolean::optionValueBoolean(bool value_)
  : value_(value_)
{}

const std::int32_t optionValueBoolean::ID;

void optionValueBoolean::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "optionValueBoolean");
    s.store_field("value", value_);
    s.store_class_end();
  }
}

optionValueEmpty::optionValueEmpty() {
}

const std::int32_t optionValueEmpty::ID;

void optionValueEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "optionValueEmpty");
    s.store_class_end();
  }
}

optionValueInteger::optionValueInteger()
  : value_()
{}

optionValueInteger::optionValueInteger(int64 value_)
  : value_(value_)
{}

const std::int32_t optionValueInteger::ID;

void optionValueInteger::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "optionValueInteger");
    s.store_field("value", value_);
    s.store_class_end();
  }
}

optionValueString::optionValueString()
  : value_()
{}

optionValueString::optionValueString(string const &value_)
  : value_(value_)
{}

const std::int32_t optionValueString::ID;

void optionValueString::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "optionValueString");
    s.store_field("value", value_);
    s.store_class_end();
  }
}

orderInfo::orderInfo()
  : name_()
  , phone_number_()
  , email_address_()
  , shipping_address_()
{}

orderInfo::orderInfo(string const &name_, string const &phone_number_, string const &email_address_, object_ptr<address> &&shipping_address_)
  : name_(name_)
  , phone_number_(phone_number_)
  , email_address_(email_address_)
  , shipping_address_(std::move(shipping_address_))
{}

const std::int32_t orderInfo::ID;

void orderInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "orderInfo");
    s.store_field("name", name_);
    s.store_field("phone_number", phone_number_);
    s.store_field("email_address", email_address_);
    s.store_object_field("shipping_address", static_cast<const BaseObject *>(shipping_address_.get()));
    s.store_class_end();
  }
}

outline::outline()
  : paths_()
{}

outline::outline(array<object_ptr<closedVectorPath>> &&paths_)
  : paths_(std::move(paths_))
{}

const std::int32_t outline::ID;

void outline::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "outline");
    { s.store_vector_begin("paths", paths_.size()); for (const auto &_value : paths_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

pageBlockTitle::pageBlockTitle()
  : title_()
{}

pageBlockTitle::pageBlockTitle(object_ptr<RichText> &&title_)
  : title_(std::move(title_))
{}

const std::int32_t pageBlockTitle::ID;

void pageBlockTitle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockTitle");
    s.store_object_field("title", static_cast<const BaseObject *>(title_.get()));
    s.store_class_end();
  }
}

pageBlockSubtitle::pageBlockSubtitle()
  : subtitle_()
{}

pageBlockSubtitle::pageBlockSubtitle(object_ptr<RichText> &&subtitle_)
  : subtitle_(std::move(subtitle_))
{}

const std::int32_t pageBlockSubtitle::ID;

void pageBlockSubtitle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockSubtitle");
    s.store_object_field("subtitle", static_cast<const BaseObject *>(subtitle_.get()));
    s.store_class_end();
  }
}

pageBlockAuthorDate::pageBlockAuthorDate()
  : author_()
  , publish_date_()
{}

pageBlockAuthorDate::pageBlockAuthorDate(object_ptr<RichText> &&author_, int32 publish_date_)
  : author_(std::move(author_))
  , publish_date_(publish_date_)
{}

const std::int32_t pageBlockAuthorDate::ID;

void pageBlockAuthorDate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockAuthorDate");
    s.store_object_field("author", static_cast<const BaseObject *>(author_.get()));
    s.store_field("publish_date", publish_date_);
    s.store_class_end();
  }
}

pageBlockHeader::pageBlockHeader()
  : header_()
{}

pageBlockHeader::pageBlockHeader(object_ptr<RichText> &&header_)
  : header_(std::move(header_))
{}

const std::int32_t pageBlockHeader::ID;

void pageBlockHeader::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockHeader");
    s.store_object_field("header", static_cast<const BaseObject *>(header_.get()));
    s.store_class_end();
  }
}

pageBlockSubheader::pageBlockSubheader()
  : subheader_()
{}

pageBlockSubheader::pageBlockSubheader(object_ptr<RichText> &&subheader_)
  : subheader_(std::move(subheader_))
{}

const std::int32_t pageBlockSubheader::ID;

void pageBlockSubheader::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockSubheader");
    s.store_object_field("subheader", static_cast<const BaseObject *>(subheader_.get()));
    s.store_class_end();
  }
}

pageBlockKicker::pageBlockKicker()
  : kicker_()
{}

pageBlockKicker::pageBlockKicker(object_ptr<RichText> &&kicker_)
  : kicker_(std::move(kicker_))
{}

const std::int32_t pageBlockKicker::ID;

void pageBlockKicker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockKicker");
    s.store_object_field("kicker", static_cast<const BaseObject *>(kicker_.get()));
    s.store_class_end();
  }
}

pageBlockParagraph::pageBlockParagraph()
  : text_()
{}

pageBlockParagraph::pageBlockParagraph(object_ptr<RichText> &&text_)
  : text_(std::move(text_))
{}

const std::int32_t pageBlockParagraph::ID;

void pageBlockParagraph::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockParagraph");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

pageBlockPreformatted::pageBlockPreformatted()
  : text_()
  , language_()
{}

pageBlockPreformatted::pageBlockPreformatted(object_ptr<RichText> &&text_, string const &language_)
  : text_(std::move(text_))
  , language_(language_)
{}

const std::int32_t pageBlockPreformatted::ID;

void pageBlockPreformatted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockPreformatted");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("language", language_);
    s.store_class_end();
  }
}

pageBlockFooter::pageBlockFooter()
  : footer_()
{}

pageBlockFooter::pageBlockFooter(object_ptr<RichText> &&footer_)
  : footer_(std::move(footer_))
{}

const std::int32_t pageBlockFooter::ID;

void pageBlockFooter::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockFooter");
    s.store_object_field("footer", static_cast<const BaseObject *>(footer_.get()));
    s.store_class_end();
  }
}

pageBlockDivider::pageBlockDivider() {
}

const std::int32_t pageBlockDivider::ID;

void pageBlockDivider::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockDivider");
    s.store_class_end();
  }
}

pageBlockAnchor::pageBlockAnchor()
  : name_()
{}

pageBlockAnchor::pageBlockAnchor(string const &name_)
  : name_(name_)
{}

const std::int32_t pageBlockAnchor::ID;

void pageBlockAnchor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockAnchor");
    s.store_field("name", name_);
    s.store_class_end();
  }
}

pageBlockList::pageBlockList()
  : items_()
{}

pageBlockList::pageBlockList(array<object_ptr<pageBlockListItem>> &&items_)
  : items_(std::move(items_))
{}

const std::int32_t pageBlockList::ID;

void pageBlockList::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockList");
    { s.store_vector_begin("items", items_.size()); for (const auto &_value : items_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

pageBlockBlockQuote::pageBlockBlockQuote()
  : text_()
  , credit_()
{}

pageBlockBlockQuote::pageBlockBlockQuote(object_ptr<RichText> &&text_, object_ptr<RichText> &&credit_)
  : text_(std::move(text_))
  , credit_(std::move(credit_))
{}

const std::int32_t pageBlockBlockQuote::ID;

void pageBlockBlockQuote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockBlockQuote");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_object_field("credit", static_cast<const BaseObject *>(credit_.get()));
    s.store_class_end();
  }
}

pageBlockPullQuote::pageBlockPullQuote()
  : text_()
  , credit_()
{}

pageBlockPullQuote::pageBlockPullQuote(object_ptr<RichText> &&text_, object_ptr<RichText> &&credit_)
  : text_(std::move(text_))
  , credit_(std::move(credit_))
{}

const std::int32_t pageBlockPullQuote::ID;

void pageBlockPullQuote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockPullQuote");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_object_field("credit", static_cast<const BaseObject *>(credit_.get()));
    s.store_class_end();
  }
}

pageBlockAnimation::pageBlockAnimation()
  : animation_()
  , caption_()
  , need_autoplay_()
{}

pageBlockAnimation::pageBlockAnimation(object_ptr<animation> &&animation_, object_ptr<pageBlockCaption> &&caption_, bool need_autoplay_)
  : animation_(std::move(animation_))
  , caption_(std::move(caption_))
  , need_autoplay_(need_autoplay_)
{}

const std::int32_t pageBlockAnimation::ID;

void pageBlockAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockAnimation");
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("need_autoplay", need_autoplay_);
    s.store_class_end();
  }
}

pageBlockAudio::pageBlockAudio()
  : audio_()
  , caption_()
{}

pageBlockAudio::pageBlockAudio(object_ptr<audio> &&audio_, object_ptr<pageBlockCaption> &&caption_)
  : audio_(std::move(audio_))
  , caption_(std::move(caption_))
{}

const std::int32_t pageBlockAudio::ID;

void pageBlockAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockAudio");
    s.store_object_field("audio", static_cast<const BaseObject *>(audio_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

pageBlockPhoto::pageBlockPhoto()
  : photo_()
  , caption_()
  , url_()
{}

pageBlockPhoto::pageBlockPhoto(object_ptr<photo> &&photo_, object_ptr<pageBlockCaption> &&caption_, string const &url_)
  : photo_(std::move(photo_))
  , caption_(std::move(caption_))
  , url_(url_)
{}

const std::int32_t pageBlockPhoto::ID;

void pageBlockPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockPhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("url", url_);
    s.store_class_end();
  }
}

pageBlockVideo::pageBlockVideo()
  : video_()
  , caption_()
  , need_autoplay_()
  , is_looped_()
{}

pageBlockVideo::pageBlockVideo(object_ptr<video> &&video_, object_ptr<pageBlockCaption> &&caption_, bool need_autoplay_, bool is_looped_)
  : video_(std::move(video_))
  , caption_(std::move(caption_))
  , need_autoplay_(need_autoplay_)
  , is_looped_(is_looped_)
{}

const std::int32_t pageBlockVideo::ID;

void pageBlockVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockVideo");
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("need_autoplay", need_autoplay_);
    s.store_field("is_looped", is_looped_);
    s.store_class_end();
  }
}

pageBlockVoiceNote::pageBlockVoiceNote()
  : voice_note_()
  , caption_()
{}

pageBlockVoiceNote::pageBlockVoiceNote(object_ptr<voiceNote> &&voice_note_, object_ptr<pageBlockCaption> &&caption_)
  : voice_note_(std::move(voice_note_))
  , caption_(std::move(caption_))
{}

const std::int32_t pageBlockVoiceNote::ID;

void pageBlockVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockVoiceNote");
    s.store_object_field("voice_note", static_cast<const BaseObject *>(voice_note_.get()));
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

pageBlockCover::pageBlockCover()
  : cover_()
{}

pageBlockCover::pageBlockCover(object_ptr<PageBlock> &&cover_)
  : cover_(std::move(cover_))
{}

const std::int32_t pageBlockCover::ID;

void pageBlockCover::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockCover");
    s.store_object_field("cover", static_cast<const BaseObject *>(cover_.get()));
    s.store_class_end();
  }
}

pageBlockEmbedded::pageBlockEmbedded()
  : url_()
  , html_()
  , poster_photo_()
  , width_()
  , height_()
  , caption_()
  , is_full_width_()
  , allow_scrolling_()
{}

pageBlockEmbedded::pageBlockEmbedded(string const &url_, string const &html_, object_ptr<photo> &&poster_photo_, int32 width_, int32 height_, object_ptr<pageBlockCaption> &&caption_, bool is_full_width_, bool allow_scrolling_)
  : url_(url_)
  , html_(html_)
  , poster_photo_(std::move(poster_photo_))
  , width_(width_)
  , height_(height_)
  , caption_(std::move(caption_))
  , is_full_width_(is_full_width_)
  , allow_scrolling_(allow_scrolling_)
{}

const std::int32_t pageBlockEmbedded::ID;

void pageBlockEmbedded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockEmbedded");
    s.store_field("url", url_);
    s.store_field("html", html_);
    s.store_object_field("poster_photo", static_cast<const BaseObject *>(poster_photo_.get()));
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_field("is_full_width", is_full_width_);
    s.store_field("allow_scrolling", allow_scrolling_);
    s.store_class_end();
  }
}

pageBlockEmbeddedPost::pageBlockEmbeddedPost()
  : url_()
  , author_()
  , author_photo_()
  , date_()
  , page_blocks_()
  , caption_()
{}

pageBlockEmbeddedPost::pageBlockEmbeddedPost(string const &url_, string const &author_, object_ptr<photo> &&author_photo_, int32 date_, array<object_ptr<PageBlock>> &&page_blocks_, object_ptr<pageBlockCaption> &&caption_)
  : url_(url_)
  , author_(author_)
  , author_photo_(std::move(author_photo_))
  , date_(date_)
  , page_blocks_(std::move(page_blocks_))
  , caption_(std::move(caption_))
{}

const std::int32_t pageBlockEmbeddedPost::ID;

void pageBlockEmbeddedPost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockEmbeddedPost");
    s.store_field("url", url_);
    s.store_field("author", author_);
    s.store_object_field("author_photo", static_cast<const BaseObject *>(author_photo_.get()));
    s.store_field("date", date_);
    { s.store_vector_begin("page_blocks", page_blocks_.size()); for (const auto &_value : page_blocks_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

pageBlockCollage::pageBlockCollage()
  : page_blocks_()
  , caption_()
{}

pageBlockCollage::pageBlockCollage(array<object_ptr<PageBlock>> &&page_blocks_, object_ptr<pageBlockCaption> &&caption_)
  : page_blocks_(std::move(page_blocks_))
  , caption_(std::move(caption_))
{}

const std::int32_t pageBlockCollage::ID;

void pageBlockCollage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockCollage");
    { s.store_vector_begin("page_blocks", page_blocks_.size()); for (const auto &_value : page_blocks_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

pageBlockSlideshow::pageBlockSlideshow()
  : page_blocks_()
  , caption_()
{}

pageBlockSlideshow::pageBlockSlideshow(array<object_ptr<PageBlock>> &&page_blocks_, object_ptr<pageBlockCaption> &&caption_)
  : page_blocks_(std::move(page_blocks_))
  , caption_(std::move(caption_))
{}

const std::int32_t pageBlockSlideshow::ID;

void pageBlockSlideshow::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockSlideshow");
    { s.store_vector_begin("page_blocks", page_blocks_.size()); for (const auto &_value : page_blocks_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

pageBlockChatLink::pageBlockChatLink()
  : title_()
  , photo_()
  , accent_color_id_()
  , username_()
{}

pageBlockChatLink::pageBlockChatLink(string const &title_, object_ptr<chatPhotoInfo> &&photo_, int32 accent_color_id_, string const &username_)
  : title_(title_)
  , photo_(std::move(photo_))
  , accent_color_id_(accent_color_id_)
  , username_(username_)
{}

const std::int32_t pageBlockChatLink::ID;

void pageBlockChatLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockChatLink");
    s.store_field("title", title_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("accent_color_id", accent_color_id_);
    s.store_field("username", username_);
    s.store_class_end();
  }
}

pageBlockTable::pageBlockTable()
  : caption_()
  , cells_()
  , is_bordered_()
  , is_striped_()
{}

pageBlockTable::pageBlockTable(object_ptr<RichText> &&caption_, array<array<object_ptr<pageBlockTableCell>>> &&cells_, bool is_bordered_, bool is_striped_)
  : caption_(std::move(caption_))
  , cells_(std::move(cells_))
  , is_bordered_(is_bordered_)
  , is_striped_(is_striped_)
{}

const std::int32_t pageBlockTable::ID;

void pageBlockTable::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockTable");
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    { s.store_vector_begin("cells", cells_.size()); for (const auto &_value : cells_) { { s.store_vector_begin("", _value.size()); for (const auto &_value2 : _value) { s.store_object_field("", static_cast<const BaseObject *>(_value2.get())); } s.store_class_end(); } } s.store_class_end(); }
    s.store_field("is_bordered", is_bordered_);
    s.store_field("is_striped", is_striped_);
    s.store_class_end();
  }
}

pageBlockDetails::pageBlockDetails()
  : header_()
  , page_blocks_()
  , is_open_()
{}

pageBlockDetails::pageBlockDetails(object_ptr<RichText> &&header_, array<object_ptr<PageBlock>> &&page_blocks_, bool is_open_)
  : header_(std::move(header_))
  , page_blocks_(std::move(page_blocks_))
  , is_open_(is_open_)
{}

const std::int32_t pageBlockDetails::ID;

void pageBlockDetails::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockDetails");
    s.store_object_field("header", static_cast<const BaseObject *>(header_.get()));
    { s.store_vector_begin("page_blocks", page_blocks_.size()); for (const auto &_value : page_blocks_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("is_open", is_open_);
    s.store_class_end();
  }
}

pageBlockRelatedArticles::pageBlockRelatedArticles()
  : header_()
  , articles_()
{}

pageBlockRelatedArticles::pageBlockRelatedArticles(object_ptr<RichText> &&header_, array<object_ptr<pageBlockRelatedArticle>> &&articles_)
  : header_(std::move(header_))
  , articles_(std::move(articles_))
{}

const std::int32_t pageBlockRelatedArticles::ID;

void pageBlockRelatedArticles::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockRelatedArticles");
    s.store_object_field("header", static_cast<const BaseObject *>(header_.get()));
    { s.store_vector_begin("articles", articles_.size()); for (const auto &_value : articles_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

pageBlockMap::pageBlockMap()
  : location_()
  , zoom_()
  , width_()
  , height_()
  , caption_()
{}

pageBlockMap::pageBlockMap(object_ptr<location> &&location_, int32 zoom_, int32 width_, int32 height_, object_ptr<pageBlockCaption> &&caption_)
  : location_(std::move(location_))
  , zoom_(zoom_)
  , width_(width_)
  , height_(height_)
  , caption_(std::move(caption_))
{}

const std::int32_t pageBlockMap::ID;

void pageBlockMap::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockMap");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_field("zoom", zoom_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

pageBlockCaption::pageBlockCaption()
  : text_()
  , credit_()
{}

pageBlockCaption::pageBlockCaption(object_ptr<RichText> &&text_, object_ptr<RichText> &&credit_)
  : text_(std::move(text_))
  , credit_(std::move(credit_))
{}

const std::int32_t pageBlockCaption::ID;

void pageBlockCaption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockCaption");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_object_field("credit", static_cast<const BaseObject *>(credit_.get()));
    s.store_class_end();
  }
}

pageBlockHorizontalAlignmentLeft::pageBlockHorizontalAlignmentLeft() {
}

const std::int32_t pageBlockHorizontalAlignmentLeft::ID;

void pageBlockHorizontalAlignmentLeft::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockHorizontalAlignmentLeft");
    s.store_class_end();
  }
}

pageBlockHorizontalAlignmentCenter::pageBlockHorizontalAlignmentCenter() {
}

const std::int32_t pageBlockHorizontalAlignmentCenter::ID;

void pageBlockHorizontalAlignmentCenter::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockHorizontalAlignmentCenter");
    s.store_class_end();
  }
}

pageBlockHorizontalAlignmentRight::pageBlockHorizontalAlignmentRight() {
}

const std::int32_t pageBlockHorizontalAlignmentRight::ID;

void pageBlockHorizontalAlignmentRight::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockHorizontalAlignmentRight");
    s.store_class_end();
  }
}

pageBlockListItem::pageBlockListItem()
  : label_()
  , page_blocks_()
{}

pageBlockListItem::pageBlockListItem(string const &label_, array<object_ptr<PageBlock>> &&page_blocks_)
  : label_(label_)
  , page_blocks_(std::move(page_blocks_))
{}

const std::int32_t pageBlockListItem::ID;

void pageBlockListItem::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockListItem");
    s.store_field("label", label_);
    { s.store_vector_begin("page_blocks", page_blocks_.size()); for (const auto &_value : page_blocks_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

pageBlockRelatedArticle::pageBlockRelatedArticle()
  : url_()
  , title_()
  , description_()
  , photo_()
  , author_()
  , publish_date_()
{}

pageBlockRelatedArticle::pageBlockRelatedArticle(string const &url_, string const &title_, string const &description_, object_ptr<photo> &&photo_, string const &author_, int32 publish_date_)
  : url_(url_)
  , title_(title_)
  , description_(description_)
  , photo_(std::move(photo_))
  , author_(author_)
  , publish_date_(publish_date_)
{}

const std::int32_t pageBlockRelatedArticle::ID;

void pageBlockRelatedArticle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockRelatedArticle");
    s.store_field("url", url_);
    s.store_field("title", title_);
    s.store_field("description", description_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("author", author_);
    s.store_field("publish_date", publish_date_);
    s.store_class_end();
  }
}

pageBlockTableCell::pageBlockTableCell()
  : text_()
  , is_header_()
  , colspan_()
  , rowspan_()
  , align_()
  , valign_()
{}

pageBlockTableCell::pageBlockTableCell(object_ptr<RichText> &&text_, bool is_header_, int32 colspan_, int32 rowspan_, object_ptr<PageBlockHorizontalAlignment> &&align_, object_ptr<PageBlockVerticalAlignment> &&valign_)
  : text_(std::move(text_))
  , is_header_(is_header_)
  , colspan_(colspan_)
  , rowspan_(rowspan_)
  , align_(std::move(align_))
  , valign_(std::move(valign_))
{}

const std::int32_t pageBlockTableCell::ID;

void pageBlockTableCell::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockTableCell");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("is_header", is_header_);
    s.store_field("colspan", colspan_);
    s.store_field("rowspan", rowspan_);
    s.store_object_field("align", static_cast<const BaseObject *>(align_.get()));
    s.store_object_field("valign", static_cast<const BaseObject *>(valign_.get()));
    s.store_class_end();
  }
}

pageBlockVerticalAlignmentTop::pageBlockVerticalAlignmentTop() {
}

const std::int32_t pageBlockVerticalAlignmentTop::ID;

void pageBlockVerticalAlignmentTop::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockVerticalAlignmentTop");
    s.store_class_end();
  }
}

pageBlockVerticalAlignmentMiddle::pageBlockVerticalAlignmentMiddle() {
}

const std::int32_t pageBlockVerticalAlignmentMiddle::ID;

void pageBlockVerticalAlignmentMiddle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockVerticalAlignmentMiddle");
    s.store_class_end();
  }
}

pageBlockVerticalAlignmentBottom::pageBlockVerticalAlignmentBottom() {
}

const std::int32_t pageBlockVerticalAlignmentBottom::ID;

void pageBlockVerticalAlignmentBottom::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pageBlockVerticalAlignmentBottom");
    s.store_class_end();
  }
}

paidMediaPreview::paidMediaPreview()
  : width_()
  , height_()
  , duration_()
  , minithumbnail_()
{}

paidMediaPreview::paidMediaPreview(int32 width_, int32 height_, int32 duration_, object_ptr<minithumbnail> &&minithumbnail_)
  : width_(width_)
  , height_(height_)
  , duration_(duration_)
  , minithumbnail_(std::move(minithumbnail_))
{}

const std::int32_t paidMediaPreview::ID;

void paidMediaPreview::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidMediaPreview");
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_field("duration", duration_);
    s.store_object_field("minithumbnail", static_cast<const BaseObject *>(minithumbnail_.get()));
    s.store_class_end();
  }
}

paidMediaPhoto::paidMediaPhoto()
  : photo_()
{}

paidMediaPhoto::paidMediaPhoto(object_ptr<photo> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t paidMediaPhoto::ID;

void paidMediaPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidMediaPhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

paidMediaVideo::paidMediaVideo()
  : video_()
  , cover_()
  , start_timestamp_()
{}

paidMediaVideo::paidMediaVideo(object_ptr<video> &&video_, object_ptr<photo> &&cover_, int32 start_timestamp_)
  : video_(std::move(video_))
  , cover_(std::move(cover_))
  , start_timestamp_(start_timestamp_)
{}

const std::int32_t paidMediaVideo::ID;

void paidMediaVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidMediaVideo");
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_object_field("cover", static_cast<const BaseObject *>(cover_.get()));
    s.store_field("start_timestamp", start_timestamp_);
    s.store_class_end();
  }
}

paidMediaUnsupported::paidMediaUnsupported() {
}

const std::int32_t paidMediaUnsupported::ID;

void paidMediaUnsupported::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidMediaUnsupported");
    s.store_class_end();
  }
}

paidReactionTypeRegular::paidReactionTypeRegular() {
}

const std::int32_t paidReactionTypeRegular::ID;

void paidReactionTypeRegular::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidReactionTypeRegular");
    s.store_class_end();
  }
}

paidReactionTypeAnonymous::paidReactionTypeAnonymous() {
}

const std::int32_t paidReactionTypeAnonymous::ID;

void paidReactionTypeAnonymous::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidReactionTypeAnonymous");
    s.store_class_end();
  }
}

paidReactionTypeChat::paidReactionTypeChat()
  : chat_id_()
{}

paidReactionTypeChat::paidReactionTypeChat(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t paidReactionTypeChat::ID;

void paidReactionTypeChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidReactionTypeChat");
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

paidReactor::paidReactor()
  : sender_id_()
  , star_count_()
  , is_top_()
  , is_me_()
  , is_anonymous_()
{}

paidReactor::paidReactor(object_ptr<MessageSender> &&sender_id_, int32 star_count_, bool is_top_, bool is_me_, bool is_anonymous_)
  : sender_id_(std::move(sender_id_))
  , star_count_(star_count_)
  , is_top_(is_top_)
  , is_me_(is_me_)
  , is_anonymous_(is_anonymous_)
{}

const std::int32_t paidReactor::ID;

void paidReactor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paidReactor");
    s.store_object_field("sender_id", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_field("star_count", star_count_);
    s.store_field("is_top", is_top_);
    s.store_field("is_me", is_me_);
    s.store_field("is_anonymous", is_anonymous_);
    s.store_class_end();
  }
}

passportAuthorizationForm::passportAuthorizationForm()
  : id_()
  , required_elements_()
  , privacy_policy_url_()
{}

passportAuthorizationForm::passportAuthorizationForm(int32 id_, array<object_ptr<passportRequiredElement>> &&required_elements_, string const &privacy_policy_url_)
  : id_(id_)
  , required_elements_(std::move(required_elements_))
  , privacy_policy_url_(privacy_policy_url_)
{}

const std::int32_t passportAuthorizationForm::ID;

void passportAuthorizationForm::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportAuthorizationForm");
    s.store_field("id", id_);
    { s.store_vector_begin("required_elements", required_elements_.size()); for (const auto &_value : required_elements_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("privacy_policy_url", privacy_policy_url_);
    s.store_class_end();
  }
}

passportElementPersonalDetails::passportElementPersonalDetails()
  : personal_details_()
{}

passportElementPersonalDetails::passportElementPersonalDetails(object_ptr<personalDetails> &&personal_details_)
  : personal_details_(std::move(personal_details_))
{}

const std::int32_t passportElementPersonalDetails::ID;

void passportElementPersonalDetails::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementPersonalDetails");
    s.store_object_field("personal_details", static_cast<const BaseObject *>(personal_details_.get()));
    s.store_class_end();
  }
}

passportElementPassport::passportElementPassport()
  : passport_()
{}

passportElementPassport::passportElementPassport(object_ptr<identityDocument> &&passport_)
  : passport_(std::move(passport_))
{}

const std::int32_t passportElementPassport::ID;

void passportElementPassport::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementPassport");
    s.store_object_field("passport", static_cast<const BaseObject *>(passport_.get()));
    s.store_class_end();
  }
}

passportElementDriverLicense::passportElementDriverLicense()
  : driver_license_()
{}

passportElementDriverLicense::passportElementDriverLicense(object_ptr<identityDocument> &&driver_license_)
  : driver_license_(std::move(driver_license_))
{}

const std::int32_t passportElementDriverLicense::ID;

void passportElementDriverLicense::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementDriverLicense");
    s.store_object_field("driver_license", static_cast<const BaseObject *>(driver_license_.get()));
    s.store_class_end();
  }
}

passportElementIdentityCard::passportElementIdentityCard()
  : identity_card_()
{}

passportElementIdentityCard::passportElementIdentityCard(object_ptr<identityDocument> &&identity_card_)
  : identity_card_(std::move(identity_card_))
{}

const std::int32_t passportElementIdentityCard::ID;

void passportElementIdentityCard::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementIdentityCard");
    s.store_object_field("identity_card", static_cast<const BaseObject *>(identity_card_.get()));
    s.store_class_end();
  }
}

passportElementInternalPassport::passportElementInternalPassport()
  : internal_passport_()
{}

passportElementInternalPassport::passportElementInternalPassport(object_ptr<identityDocument> &&internal_passport_)
  : internal_passport_(std::move(internal_passport_))
{}

const std::int32_t passportElementInternalPassport::ID;

void passportElementInternalPassport::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementInternalPassport");
    s.store_object_field("internal_passport", static_cast<const BaseObject *>(internal_passport_.get()));
    s.store_class_end();
  }
}

passportElementAddress::passportElementAddress()
  : address_()
{}

passportElementAddress::passportElementAddress(object_ptr<address> &&address_)
  : address_(std::move(address_))
{}

const std::int32_t passportElementAddress::ID;

void passportElementAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementAddress");
    s.store_object_field("address", static_cast<const BaseObject *>(address_.get()));
    s.store_class_end();
  }
}

passportElementUtilityBill::passportElementUtilityBill()
  : utility_bill_()
{}

passportElementUtilityBill::passportElementUtilityBill(object_ptr<personalDocument> &&utility_bill_)
  : utility_bill_(std::move(utility_bill_))
{}

const std::int32_t passportElementUtilityBill::ID;

void passportElementUtilityBill::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementUtilityBill");
    s.store_object_field("utility_bill", static_cast<const BaseObject *>(utility_bill_.get()));
    s.store_class_end();
  }
}

passportElementBankStatement::passportElementBankStatement()
  : bank_statement_()
{}

passportElementBankStatement::passportElementBankStatement(object_ptr<personalDocument> &&bank_statement_)
  : bank_statement_(std::move(bank_statement_))
{}

const std::int32_t passportElementBankStatement::ID;

void passportElementBankStatement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementBankStatement");
    s.store_object_field("bank_statement", static_cast<const BaseObject *>(bank_statement_.get()));
    s.store_class_end();
  }
}

passportElementRentalAgreement::passportElementRentalAgreement()
  : rental_agreement_()
{}

passportElementRentalAgreement::passportElementRentalAgreement(object_ptr<personalDocument> &&rental_agreement_)
  : rental_agreement_(std::move(rental_agreement_))
{}

const std::int32_t passportElementRentalAgreement::ID;

void passportElementRentalAgreement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementRentalAgreement");
    s.store_object_field("rental_agreement", static_cast<const BaseObject *>(rental_agreement_.get()));
    s.store_class_end();
  }
}

passportElementPassportRegistration::passportElementPassportRegistration()
  : passport_registration_()
{}

passportElementPassportRegistration::passportElementPassportRegistration(object_ptr<personalDocument> &&passport_registration_)
  : passport_registration_(std::move(passport_registration_))
{}

const std::int32_t passportElementPassportRegistration::ID;

void passportElementPassportRegistration::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementPassportRegistration");
    s.store_object_field("passport_registration", static_cast<const BaseObject *>(passport_registration_.get()));
    s.store_class_end();
  }
}

passportElementTemporaryRegistration::passportElementTemporaryRegistration()
  : temporary_registration_()
{}

passportElementTemporaryRegistration::passportElementTemporaryRegistration(object_ptr<personalDocument> &&temporary_registration_)
  : temporary_registration_(std::move(temporary_registration_))
{}

const std::int32_t passportElementTemporaryRegistration::ID;

void passportElementTemporaryRegistration::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTemporaryRegistration");
    s.store_object_field("temporary_registration", static_cast<const BaseObject *>(temporary_registration_.get()));
    s.store_class_end();
  }
}

passportElementPhoneNumber::passportElementPhoneNumber()
  : phone_number_()
{}

passportElementPhoneNumber::passportElementPhoneNumber(string const &phone_number_)
  : phone_number_(phone_number_)
{}

const std::int32_t passportElementPhoneNumber::ID;

void passportElementPhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementPhoneNumber");
    s.store_field("phone_number", phone_number_);
    s.store_class_end();
  }
}

passportElementEmailAddress::passportElementEmailAddress()
  : email_address_()
{}

passportElementEmailAddress::passportElementEmailAddress(string const &email_address_)
  : email_address_(email_address_)
{}

const std::int32_t passportElementEmailAddress::ID;

void passportElementEmailAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementEmailAddress");
    s.store_field("email_address", email_address_);
    s.store_class_end();
  }
}

passportElementError::passportElementError()
  : type_()
  , message_()
  , source_()
{}

passportElementError::passportElementError(object_ptr<PassportElementType> &&type_, string const &message_, object_ptr<PassportElementErrorSource> &&source_)
  : type_(std::move(type_))
  , message_(message_)
  , source_(std::move(source_))
{}

const std::int32_t passportElementError::ID;

void passportElementError::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementError");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("message", message_);
    s.store_object_field("source", static_cast<const BaseObject *>(source_.get()));
    s.store_class_end();
  }
}

passportElementErrorSourceUnspecified::passportElementErrorSourceUnspecified() {
}

const std::int32_t passportElementErrorSourceUnspecified::ID;

void passportElementErrorSourceUnspecified::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementErrorSourceUnspecified");
    s.store_class_end();
  }
}

passportElementErrorSourceDataField::passportElementErrorSourceDataField()
  : field_name_()
{}

passportElementErrorSourceDataField::passportElementErrorSourceDataField(string const &field_name_)
  : field_name_(field_name_)
{}

const std::int32_t passportElementErrorSourceDataField::ID;

void passportElementErrorSourceDataField::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementErrorSourceDataField");
    s.store_field("field_name", field_name_);
    s.store_class_end();
  }
}

passportElementErrorSourceFrontSide::passportElementErrorSourceFrontSide() {
}

const std::int32_t passportElementErrorSourceFrontSide::ID;

void passportElementErrorSourceFrontSide::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementErrorSourceFrontSide");
    s.store_class_end();
  }
}

passportElementErrorSourceReverseSide::passportElementErrorSourceReverseSide() {
}

const std::int32_t passportElementErrorSourceReverseSide::ID;

void passportElementErrorSourceReverseSide::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementErrorSourceReverseSide");
    s.store_class_end();
  }
}

passportElementErrorSourceSelfie::passportElementErrorSourceSelfie() {
}

const std::int32_t passportElementErrorSourceSelfie::ID;

void passportElementErrorSourceSelfie::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementErrorSourceSelfie");
    s.store_class_end();
  }
}

passportElementErrorSourceTranslationFile::passportElementErrorSourceTranslationFile()
  : file_index_()
{}

passportElementErrorSourceTranslationFile::passportElementErrorSourceTranslationFile(int32 file_index_)
  : file_index_(file_index_)
{}

const std::int32_t passportElementErrorSourceTranslationFile::ID;

void passportElementErrorSourceTranslationFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementErrorSourceTranslationFile");
    s.store_field("file_index", file_index_);
    s.store_class_end();
  }
}

passportElementErrorSourceTranslationFiles::passportElementErrorSourceTranslationFiles() {
}

const std::int32_t passportElementErrorSourceTranslationFiles::ID;

void passportElementErrorSourceTranslationFiles::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementErrorSourceTranslationFiles");
    s.store_class_end();
  }
}

passportElementErrorSourceFile::passportElementErrorSourceFile()
  : file_index_()
{}

passportElementErrorSourceFile::passportElementErrorSourceFile(int32 file_index_)
  : file_index_(file_index_)
{}

const std::int32_t passportElementErrorSourceFile::ID;

void passportElementErrorSourceFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementErrorSourceFile");
    s.store_field("file_index", file_index_);
    s.store_class_end();
  }
}

passportElementErrorSourceFiles::passportElementErrorSourceFiles() {
}

const std::int32_t passportElementErrorSourceFiles::ID;

void passportElementErrorSourceFiles::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementErrorSourceFiles");
    s.store_class_end();
  }
}

passportElementTypePersonalDetails::passportElementTypePersonalDetails() {
}

const std::int32_t passportElementTypePersonalDetails::ID;

void passportElementTypePersonalDetails::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypePersonalDetails");
    s.store_class_end();
  }
}

passportElementTypePassport::passportElementTypePassport() {
}

const std::int32_t passportElementTypePassport::ID;

void passportElementTypePassport::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypePassport");
    s.store_class_end();
  }
}

passportElementTypeDriverLicense::passportElementTypeDriverLicense() {
}

const std::int32_t passportElementTypeDriverLicense::ID;

void passportElementTypeDriverLicense::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypeDriverLicense");
    s.store_class_end();
  }
}

passportElementTypeIdentityCard::passportElementTypeIdentityCard() {
}

const std::int32_t passportElementTypeIdentityCard::ID;

void passportElementTypeIdentityCard::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypeIdentityCard");
    s.store_class_end();
  }
}

passportElementTypeInternalPassport::passportElementTypeInternalPassport() {
}

const std::int32_t passportElementTypeInternalPassport::ID;

void passportElementTypeInternalPassport::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypeInternalPassport");
    s.store_class_end();
  }
}

passportElementTypeAddress::passportElementTypeAddress() {
}

const std::int32_t passportElementTypeAddress::ID;

void passportElementTypeAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypeAddress");
    s.store_class_end();
  }
}

passportElementTypeUtilityBill::passportElementTypeUtilityBill() {
}

const std::int32_t passportElementTypeUtilityBill::ID;

void passportElementTypeUtilityBill::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypeUtilityBill");
    s.store_class_end();
  }
}

passportElementTypeBankStatement::passportElementTypeBankStatement() {
}

const std::int32_t passportElementTypeBankStatement::ID;

void passportElementTypeBankStatement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypeBankStatement");
    s.store_class_end();
  }
}

passportElementTypeRentalAgreement::passportElementTypeRentalAgreement() {
}

const std::int32_t passportElementTypeRentalAgreement::ID;

void passportElementTypeRentalAgreement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypeRentalAgreement");
    s.store_class_end();
  }
}

passportElementTypePassportRegistration::passportElementTypePassportRegistration() {
}

const std::int32_t passportElementTypePassportRegistration::ID;

void passportElementTypePassportRegistration::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypePassportRegistration");
    s.store_class_end();
  }
}

passportElementTypeTemporaryRegistration::passportElementTypeTemporaryRegistration() {
}

const std::int32_t passportElementTypeTemporaryRegistration::ID;

void passportElementTypeTemporaryRegistration::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypeTemporaryRegistration");
    s.store_class_end();
  }
}

passportElementTypePhoneNumber::passportElementTypePhoneNumber() {
}

const std::int32_t passportElementTypePhoneNumber::ID;

void passportElementTypePhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypePhoneNumber");
    s.store_class_end();
  }
}

passportElementTypeEmailAddress::passportElementTypeEmailAddress() {
}

const std::int32_t passportElementTypeEmailAddress::ID;

void passportElementTypeEmailAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementTypeEmailAddress");
    s.store_class_end();
  }
}

passportElements::passportElements()
  : elements_()
{}

passportElements::passportElements(array<object_ptr<PassportElement>> &&elements_)
  : elements_(std::move(elements_))
{}

const std::int32_t passportElements::ID;

void passportElements::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElements");
    { s.store_vector_begin("elements", elements_.size()); for (const auto &_value : elements_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

passportElementsWithErrors::passportElementsWithErrors()
  : elements_()
  , errors_()
{}

passportElementsWithErrors::passportElementsWithErrors(array<object_ptr<PassportElement>> &&elements_, array<object_ptr<passportElementError>> &&errors_)
  : elements_(std::move(elements_))
  , errors_(std::move(errors_))
{}

const std::int32_t passportElementsWithErrors::ID;

void passportElementsWithErrors::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportElementsWithErrors");
    { s.store_vector_begin("elements", elements_.size()); for (const auto &_value : elements_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("errors", errors_.size()); for (const auto &_value : errors_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

passportRequiredElement::passportRequiredElement()
  : suitable_elements_()
{}

passportRequiredElement::passportRequiredElement(array<object_ptr<passportSuitableElement>> &&suitable_elements_)
  : suitable_elements_(std::move(suitable_elements_))
{}

const std::int32_t passportRequiredElement::ID;

void passportRequiredElement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportRequiredElement");
    { s.store_vector_begin("suitable_elements", suitable_elements_.size()); for (const auto &_value : suitable_elements_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

passportSuitableElement::passportSuitableElement()
  : type_()
  , is_selfie_required_()
  , is_translation_required_()
  , is_native_name_required_()
{}

passportSuitableElement::passportSuitableElement(object_ptr<PassportElementType> &&type_, bool is_selfie_required_, bool is_translation_required_, bool is_native_name_required_)
  : type_(std::move(type_))
  , is_selfie_required_(is_selfie_required_)
  , is_translation_required_(is_translation_required_)
  , is_native_name_required_(is_native_name_required_)
{}

const std::int32_t passportSuitableElement::ID;

void passportSuitableElement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passportSuitableElement");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("is_selfie_required", is_selfie_required_);
    s.store_field("is_translation_required", is_translation_required_);
    s.store_field("is_native_name_required", is_native_name_required_);
    s.store_class_end();
  }
}

passwordState::passwordState()
  : has_password_()
  , password_hint_()
  , has_recovery_email_address_()
  , has_passport_data_()
  , recovery_email_address_code_info_()
  , login_email_address_pattern_()
  , pending_reset_date_()
{}

passwordState::passwordState(bool has_password_, string const &password_hint_, bool has_recovery_email_address_, bool has_passport_data_, object_ptr<emailAddressAuthenticationCodeInfo> &&recovery_email_address_code_info_, string const &login_email_address_pattern_, int32 pending_reset_date_)
  : has_password_(has_password_)
  , password_hint_(password_hint_)
  , has_recovery_email_address_(has_recovery_email_address_)
  , has_passport_data_(has_passport_data_)
  , recovery_email_address_code_info_(std::move(recovery_email_address_code_info_))
  , login_email_address_pattern_(login_email_address_pattern_)
  , pending_reset_date_(pending_reset_date_)
{}

const std::int32_t passwordState::ID;

void passwordState::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "passwordState");
    s.store_field("has_password", has_password_);
    s.store_field("password_hint", password_hint_);
    s.store_field("has_recovery_email_address", has_recovery_email_address_);
    s.store_field("has_passport_data", has_passport_data_);
    s.store_object_field("recovery_email_address_code_info", static_cast<const BaseObject *>(recovery_email_address_code_info_.get()));
    s.store_field("login_email_address_pattern", login_email_address_pattern_);
    s.store_field("pending_reset_date", pending_reset_date_);
    s.store_class_end();
  }
}

paymentForm::paymentForm()
  : id_()
  , type_()
  , seller_bot_user_id_()
  , product_info_()
{}

paymentForm::paymentForm(int64 id_, object_ptr<PaymentFormType> &&type_, int53 seller_bot_user_id_, object_ptr<productInfo> &&product_info_)
  : id_(id_)
  , type_(std::move(type_))
  , seller_bot_user_id_(seller_bot_user_id_)
  , product_info_(std::move(product_info_))
{}

const std::int32_t paymentForm::ID;

void paymentForm::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentForm");
    s.store_field("id", id_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("seller_bot_user_id", seller_bot_user_id_);
    s.store_object_field("product_info", static_cast<const BaseObject *>(product_info_.get()));
    s.store_class_end();
  }
}

paymentFormTypeRegular::paymentFormTypeRegular()
  : invoice_()
  , payment_provider_user_id_()
  , payment_provider_()
  , additional_payment_options_()
  , saved_order_info_()
  , saved_credentials_()
  , can_save_credentials_()
  , need_password_()
{}

paymentFormTypeRegular::paymentFormTypeRegular(object_ptr<invoice> &&invoice_, int53 payment_provider_user_id_, object_ptr<PaymentProvider> &&payment_provider_, array<object_ptr<paymentOption>> &&additional_payment_options_, object_ptr<orderInfo> &&saved_order_info_, array<object_ptr<savedCredentials>> &&saved_credentials_, bool can_save_credentials_, bool need_password_)
  : invoice_(std::move(invoice_))
  , payment_provider_user_id_(payment_provider_user_id_)
  , payment_provider_(std::move(payment_provider_))
  , additional_payment_options_(std::move(additional_payment_options_))
  , saved_order_info_(std::move(saved_order_info_))
  , saved_credentials_(std::move(saved_credentials_))
  , can_save_credentials_(can_save_credentials_)
  , need_password_(need_password_)
{}

const std::int32_t paymentFormTypeRegular::ID;

void paymentFormTypeRegular::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentFormTypeRegular");
    s.store_object_field("invoice", static_cast<const BaseObject *>(invoice_.get()));
    s.store_field("payment_provider_user_id", payment_provider_user_id_);
    s.store_object_field("payment_provider", static_cast<const BaseObject *>(payment_provider_.get()));
    { s.store_vector_begin("additional_payment_options", additional_payment_options_.size()); for (const auto &_value : additional_payment_options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("saved_order_info", static_cast<const BaseObject *>(saved_order_info_.get()));
    { s.store_vector_begin("saved_credentials", saved_credentials_.size()); for (const auto &_value : saved_credentials_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("can_save_credentials", can_save_credentials_);
    s.store_field("need_password", need_password_);
    s.store_class_end();
  }
}

paymentFormTypeStars::paymentFormTypeStars()
  : star_count_()
{}

paymentFormTypeStars::paymentFormTypeStars(int53 star_count_)
  : star_count_(star_count_)
{}

const std::int32_t paymentFormTypeStars::ID;

void paymentFormTypeStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentFormTypeStars");
    s.store_field("star_count", star_count_);
    s.store_class_end();
  }
}

paymentFormTypeStarSubscription::paymentFormTypeStarSubscription()
  : pricing_()
{}

paymentFormTypeStarSubscription::paymentFormTypeStarSubscription(object_ptr<starSubscriptionPricing> &&pricing_)
  : pricing_(std::move(pricing_))
{}

const std::int32_t paymentFormTypeStarSubscription::ID;

void paymentFormTypeStarSubscription::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentFormTypeStarSubscription");
    s.store_object_field("pricing", static_cast<const BaseObject *>(pricing_.get()));
    s.store_class_end();
  }
}

paymentOption::paymentOption()
  : title_()
  , url_()
{}

paymentOption::paymentOption(string const &title_, string const &url_)
  : title_(title_)
  , url_(url_)
{}

const std::int32_t paymentOption::ID;

void paymentOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentOption");
    s.store_field("title", title_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

paymentProviderSmartGlocal::paymentProviderSmartGlocal()
  : public_token_()
  , tokenize_url_()
{}

paymentProviderSmartGlocal::paymentProviderSmartGlocal(string const &public_token_, string const &tokenize_url_)
  : public_token_(public_token_)
  , tokenize_url_(tokenize_url_)
{}

const std::int32_t paymentProviderSmartGlocal::ID;

void paymentProviderSmartGlocal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentProviderSmartGlocal");
    s.store_field("public_token", public_token_);
    s.store_field("tokenize_url", tokenize_url_);
    s.store_class_end();
  }
}

paymentProviderStripe::paymentProviderStripe()
  : publishable_key_()
  , need_country_()
  , need_postal_code_()
  , need_cardholder_name_()
{}

paymentProviderStripe::paymentProviderStripe(string const &publishable_key_, bool need_country_, bool need_postal_code_, bool need_cardholder_name_)
  : publishable_key_(publishable_key_)
  , need_country_(need_country_)
  , need_postal_code_(need_postal_code_)
  , need_cardholder_name_(need_cardholder_name_)
{}

const std::int32_t paymentProviderStripe::ID;

void paymentProviderStripe::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentProviderStripe");
    s.store_field("publishable_key", publishable_key_);
    s.store_field("need_country", need_country_);
    s.store_field("need_postal_code", need_postal_code_);
    s.store_field("need_cardholder_name", need_cardholder_name_);
    s.store_class_end();
  }
}

paymentProviderOther::paymentProviderOther()
  : url_()
{}

paymentProviderOther::paymentProviderOther(string const &url_)
  : url_(url_)
{}

const std::int32_t paymentProviderOther::ID;

void paymentProviderOther::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentProviderOther");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

paymentReceipt::paymentReceipt()
  : product_info_()
  , date_()
  , seller_bot_user_id_()
  , type_()
{}

paymentReceipt::paymentReceipt(object_ptr<productInfo> &&product_info_, int32 date_, int53 seller_bot_user_id_, object_ptr<PaymentReceiptType> &&type_)
  : product_info_(std::move(product_info_))
  , date_(date_)
  , seller_bot_user_id_(seller_bot_user_id_)
  , type_(std::move(type_))
{}

const std::int32_t paymentReceipt::ID;

void paymentReceipt::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentReceipt");
    s.store_object_field("product_info", static_cast<const BaseObject *>(product_info_.get()));
    s.store_field("date", date_);
    s.store_field("seller_bot_user_id", seller_bot_user_id_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

paymentReceiptTypeRegular::paymentReceiptTypeRegular()
  : payment_provider_user_id_()
  , invoice_()
  , order_info_()
  , shipping_option_()
  , credentials_title_()
  , tip_amount_()
{}

paymentReceiptTypeRegular::paymentReceiptTypeRegular(int53 payment_provider_user_id_, object_ptr<invoice> &&invoice_, object_ptr<orderInfo> &&order_info_, object_ptr<shippingOption> &&shipping_option_, string const &credentials_title_, int53 tip_amount_)
  : payment_provider_user_id_(payment_provider_user_id_)
  , invoice_(std::move(invoice_))
  , order_info_(std::move(order_info_))
  , shipping_option_(std::move(shipping_option_))
  , credentials_title_(credentials_title_)
  , tip_amount_(tip_amount_)
{}

const std::int32_t paymentReceiptTypeRegular::ID;

void paymentReceiptTypeRegular::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentReceiptTypeRegular");
    s.store_field("payment_provider_user_id", payment_provider_user_id_);
    s.store_object_field("invoice", static_cast<const BaseObject *>(invoice_.get()));
    s.store_object_field("order_info", static_cast<const BaseObject *>(order_info_.get()));
    s.store_object_field("shipping_option", static_cast<const BaseObject *>(shipping_option_.get()));
    s.store_field("credentials_title", credentials_title_);
    s.store_field("tip_amount", tip_amount_);
    s.store_class_end();
  }
}

paymentReceiptTypeStars::paymentReceiptTypeStars()
  : star_count_()
  , transaction_id_()
{}

paymentReceiptTypeStars::paymentReceiptTypeStars(int53 star_count_, string const &transaction_id_)
  : star_count_(star_count_)
  , transaction_id_(transaction_id_)
{}

const std::int32_t paymentReceiptTypeStars::ID;

void paymentReceiptTypeStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentReceiptTypeStars");
    s.store_field("star_count", star_count_);
    s.store_field("transaction_id", transaction_id_);
    s.store_class_end();
  }
}

paymentResult::paymentResult()
  : success_()
  , verification_url_()
{}

paymentResult::paymentResult(bool success_, string const &verification_url_)
  : success_(success_)
  , verification_url_(verification_url_)
{}

const std::int32_t paymentResult::ID;

void paymentResult::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "paymentResult");
    s.store_field("success", success_);
    s.store_field("verification_url", verification_url_);
    s.store_class_end();
  }
}

personalDetails::personalDetails()
  : first_name_()
  , middle_name_()
  , last_name_()
  , native_first_name_()
  , native_middle_name_()
  , native_last_name_()
  , birthdate_()
  , gender_()
  , country_code_()
  , residence_country_code_()
{}

personalDetails::personalDetails(string const &first_name_, string const &middle_name_, string const &last_name_, string const &native_first_name_, string const &native_middle_name_, string const &native_last_name_, object_ptr<date> &&birthdate_, string const &gender_, string const &country_code_, string const &residence_country_code_)
  : first_name_(first_name_)
  , middle_name_(middle_name_)
  , last_name_(last_name_)
  , native_first_name_(native_first_name_)
  , native_middle_name_(native_middle_name_)
  , native_last_name_(native_last_name_)
  , birthdate_(std::move(birthdate_))
  , gender_(gender_)
  , country_code_(country_code_)
  , residence_country_code_(residence_country_code_)
{}

const std::int32_t personalDetails::ID;

void personalDetails::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "personalDetails");
    s.store_field("first_name", first_name_);
    s.store_field("middle_name", middle_name_);
    s.store_field("last_name", last_name_);
    s.store_field("native_first_name", native_first_name_);
    s.store_field("native_middle_name", native_middle_name_);
    s.store_field("native_last_name", native_last_name_);
    s.store_object_field("birthdate", static_cast<const BaseObject *>(birthdate_.get()));
    s.store_field("gender", gender_);
    s.store_field("country_code", country_code_);
    s.store_field("residence_country_code", residence_country_code_);
    s.store_class_end();
  }
}

personalDocument::personalDocument()
  : files_()
  , translation_()
{}

personalDocument::personalDocument(array<object_ptr<datedFile>> &&files_, array<object_ptr<datedFile>> &&translation_)
  : files_(std::move(files_))
  , translation_(std::move(translation_))
{}

const std::int32_t personalDocument::ID;

void personalDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "personalDocument");
    { s.store_vector_begin("files", files_.size()); for (const auto &_value : files_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("translation", translation_.size()); for (const auto &_value : translation_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

phoneNumberAuthenticationSettings::phoneNumberAuthenticationSettings()
  : allow_flash_call_()
  , allow_missed_call_()
  , is_current_phone_number_()
  , has_unknown_phone_number_()
  , allow_sms_retriever_api_()
  , firebase_authentication_settings_()
  , authentication_tokens_()
{}

phoneNumberAuthenticationSettings::phoneNumberAuthenticationSettings(bool allow_flash_call_, bool allow_missed_call_, bool is_current_phone_number_, bool has_unknown_phone_number_, bool allow_sms_retriever_api_, object_ptr<FirebaseAuthenticationSettings> &&firebase_authentication_settings_, array<string> &&authentication_tokens_)
  : allow_flash_call_(allow_flash_call_)
  , allow_missed_call_(allow_missed_call_)
  , is_current_phone_number_(is_current_phone_number_)
  , has_unknown_phone_number_(has_unknown_phone_number_)
  , allow_sms_retriever_api_(allow_sms_retriever_api_)
  , firebase_authentication_settings_(std::move(firebase_authentication_settings_))
  , authentication_tokens_(std::move(authentication_tokens_))
{}

const std::int32_t phoneNumberAuthenticationSettings::ID;

void phoneNumberAuthenticationSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "phoneNumberAuthenticationSettings");
    s.store_field("allow_flash_call", allow_flash_call_);
    s.store_field("allow_missed_call", allow_missed_call_);
    s.store_field("is_current_phone_number", is_current_phone_number_);
    s.store_field("has_unknown_phone_number", has_unknown_phone_number_);
    s.store_field("allow_sms_retriever_api", allow_sms_retriever_api_);
    s.store_object_field("firebase_authentication_settings", static_cast<const BaseObject *>(firebase_authentication_settings_.get()));
    { s.store_vector_begin("authentication_tokens", authentication_tokens_.size()); for (const auto &_value : authentication_tokens_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

phoneNumberCodeTypeChange::phoneNumberCodeTypeChange() {
}

const std::int32_t phoneNumberCodeTypeChange::ID;

void phoneNumberCodeTypeChange::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "phoneNumberCodeTypeChange");
    s.store_class_end();
  }
}

phoneNumberCodeTypeVerify::phoneNumberCodeTypeVerify() {
}

const std::int32_t phoneNumberCodeTypeVerify::ID;

void phoneNumberCodeTypeVerify::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "phoneNumberCodeTypeVerify");
    s.store_class_end();
  }
}

phoneNumberCodeTypeConfirmOwnership::phoneNumberCodeTypeConfirmOwnership()
  : hash_()
{}

phoneNumberCodeTypeConfirmOwnership::phoneNumberCodeTypeConfirmOwnership(string const &hash_)
  : hash_(hash_)
{}

const std::int32_t phoneNumberCodeTypeConfirmOwnership::ID;

void phoneNumberCodeTypeConfirmOwnership::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "phoneNumberCodeTypeConfirmOwnership");
    s.store_field("hash", hash_);
    s.store_class_end();
  }
}

phoneNumberInfo::phoneNumberInfo()
  : country_()
  , country_calling_code_()
  , formatted_phone_number_()
  , is_anonymous_()
{}

phoneNumberInfo::phoneNumberInfo(object_ptr<countryInfo> &&country_, string const &country_calling_code_, string const &formatted_phone_number_, bool is_anonymous_)
  : country_(std::move(country_))
  , country_calling_code_(country_calling_code_)
  , formatted_phone_number_(formatted_phone_number_)
  , is_anonymous_(is_anonymous_)
{}

const std::int32_t phoneNumberInfo::ID;

void phoneNumberInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "phoneNumberInfo");
    s.store_object_field("country", static_cast<const BaseObject *>(country_.get()));
    s.store_field("country_calling_code", country_calling_code_);
    s.store_field("formatted_phone_number", formatted_phone_number_);
    s.store_field("is_anonymous", is_anonymous_);
    s.store_class_end();
  }
}

photo::photo()
  : has_stickers_()
  , minithumbnail_()
  , sizes_()
{}

photo::photo(bool has_stickers_, object_ptr<minithumbnail> &&minithumbnail_, array<object_ptr<photoSize>> &&sizes_)
  : has_stickers_(has_stickers_)
  , minithumbnail_(std::move(minithumbnail_))
  , sizes_(std::move(sizes_))
{}

const std::int32_t photo::ID;

void photo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "photo");
    s.store_field("has_stickers", has_stickers_);
    s.store_object_field("minithumbnail", static_cast<const BaseObject *>(minithumbnail_.get()));
    { s.store_vector_begin("sizes", sizes_.size()); for (const auto &_value : sizes_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

photoSize::photoSize()
  : type_()
  , photo_()
  , width_()
  , height_()
  , progressive_sizes_()
{}

photoSize::photoSize(string const &type_, object_ptr<file> &&photo_, int32 width_, int32 height_, array<int32> &&progressive_sizes_)
  : type_(type_)
  , photo_(std::move(photo_))
  , width_(width_)
  , height_(height_)
  , progressive_sizes_(std::move(progressive_sizes_))
{}

const std::int32_t photoSize::ID;

void photoSize::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "photoSize");
    s.store_field("type", type_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("width", width_);
    s.store_field("height", height_);
    { s.store_vector_begin("progressive_sizes", progressive_sizes_.size()); for (const auto &_value : progressive_sizes_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

point::point()
  : x_()
  , y_()
{}

point::point(double x_, double y_)
  : x_(x_)
  , y_(y_)
{}

const std::int32_t point::ID;

void point::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "point");
    s.store_field("x", x_);
    s.store_field("y", y_);
    s.store_class_end();
  }
}

poll::poll()
  : id_()
  , question_()
  , options_()
  , total_voter_count_()
  , recent_voter_ids_()
  , is_anonymous_()
  , type_()
  , open_period_()
  , close_date_()
  , is_closed_()
{}

poll::poll(int64 id_, object_ptr<formattedText> &&question_, array<object_ptr<pollOption>> &&options_, int32 total_voter_count_, array<object_ptr<MessageSender>> &&recent_voter_ids_, bool is_anonymous_, object_ptr<PollType> &&type_, int32 open_period_, int32 close_date_, bool is_closed_)
  : id_(id_)
  , question_(std::move(question_))
  , options_(std::move(options_))
  , total_voter_count_(total_voter_count_)
  , recent_voter_ids_(std::move(recent_voter_ids_))
  , is_anonymous_(is_anonymous_)
  , type_(std::move(type_))
  , open_period_(open_period_)
  , close_date_(close_date_)
  , is_closed_(is_closed_)
{}

const std::int32_t poll::ID;

void poll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "poll");
    s.store_field("id", id_);
    s.store_object_field("question", static_cast<const BaseObject *>(question_.get()));
    { s.store_vector_begin("options", options_.size()); for (const auto &_value : options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("total_voter_count", total_voter_count_);
    { s.store_vector_begin("recent_voter_ids", recent_voter_ids_.size()); for (const auto &_value : recent_voter_ids_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("is_anonymous", is_anonymous_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("open_period", open_period_);
    s.store_field("close_date", close_date_);
    s.store_field("is_closed", is_closed_);
    s.store_class_end();
  }
}

pollOption::pollOption()
  : text_()
  , voter_count_()
  , vote_percentage_()
  , is_chosen_()
  , is_being_chosen_()
{}

pollOption::pollOption(object_ptr<formattedText> &&text_, int32 voter_count_, int32 vote_percentage_, bool is_chosen_, bool is_being_chosen_)
  : text_(std::move(text_))
  , voter_count_(voter_count_)
  , vote_percentage_(vote_percentage_)
  , is_chosen_(is_chosen_)
  , is_being_chosen_(is_being_chosen_)
{}

const std::int32_t pollOption::ID;

void pollOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pollOption");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("voter_count", voter_count_);
    s.store_field("vote_percentage", vote_percentage_);
    s.store_field("is_chosen", is_chosen_);
    s.store_field("is_being_chosen", is_being_chosen_);
    s.store_class_end();
  }
}

pollTypeRegular::pollTypeRegular()
  : allow_multiple_answers_()
{}

pollTypeRegular::pollTypeRegular(bool allow_multiple_answers_)
  : allow_multiple_answers_(allow_multiple_answers_)
{}

const std::int32_t pollTypeRegular::ID;

void pollTypeRegular::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pollTypeRegular");
    s.store_field("allow_multiple_answers", allow_multiple_answers_);
    s.store_class_end();
  }
}

pollTypeQuiz::pollTypeQuiz()
  : correct_option_id_()
  , explanation_()
{}

pollTypeQuiz::pollTypeQuiz(int32 correct_option_id_, object_ptr<formattedText> &&explanation_)
  : correct_option_id_(correct_option_id_)
  , explanation_(std::move(explanation_))
{}

const std::int32_t pollTypeQuiz::ID;

void pollTypeQuiz::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pollTypeQuiz");
    s.store_field("correct_option_id", correct_option_id_);
    s.store_object_field("explanation", static_cast<const BaseObject *>(explanation_.get()));
    s.store_class_end();
  }
}

premiumFeatureIncreasedLimits::premiumFeatureIncreasedLimits() {
}

const std::int32_t premiumFeatureIncreasedLimits::ID;

void premiumFeatureIncreasedLimits::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureIncreasedLimits");
    s.store_class_end();
  }
}

premiumFeatureIncreasedUploadFileSize::premiumFeatureIncreasedUploadFileSize() {
}

const std::int32_t premiumFeatureIncreasedUploadFileSize::ID;

void premiumFeatureIncreasedUploadFileSize::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureIncreasedUploadFileSize");
    s.store_class_end();
  }
}

premiumFeatureImprovedDownloadSpeed::premiumFeatureImprovedDownloadSpeed() {
}

const std::int32_t premiumFeatureImprovedDownloadSpeed::ID;

void premiumFeatureImprovedDownloadSpeed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureImprovedDownloadSpeed");
    s.store_class_end();
  }
}

premiumFeatureVoiceRecognition::premiumFeatureVoiceRecognition() {
}

const std::int32_t premiumFeatureVoiceRecognition::ID;

void premiumFeatureVoiceRecognition::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureVoiceRecognition");
    s.store_class_end();
  }
}

premiumFeatureDisabledAds::premiumFeatureDisabledAds() {
}

const std::int32_t premiumFeatureDisabledAds::ID;

void premiumFeatureDisabledAds::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureDisabledAds");
    s.store_class_end();
  }
}

premiumFeatureUniqueReactions::premiumFeatureUniqueReactions() {
}

const std::int32_t premiumFeatureUniqueReactions::ID;

void premiumFeatureUniqueReactions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureUniqueReactions");
    s.store_class_end();
  }
}

premiumFeatureUniqueStickers::premiumFeatureUniqueStickers() {
}

const std::int32_t premiumFeatureUniqueStickers::ID;

void premiumFeatureUniqueStickers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureUniqueStickers");
    s.store_class_end();
  }
}

premiumFeatureCustomEmoji::premiumFeatureCustomEmoji() {
}

const std::int32_t premiumFeatureCustomEmoji::ID;

void premiumFeatureCustomEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureCustomEmoji");
    s.store_class_end();
  }
}

premiumFeatureAdvancedChatManagement::premiumFeatureAdvancedChatManagement() {
}

const std::int32_t premiumFeatureAdvancedChatManagement::ID;

void premiumFeatureAdvancedChatManagement::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureAdvancedChatManagement");
    s.store_class_end();
  }
}

premiumFeatureProfileBadge::premiumFeatureProfileBadge() {
}

const std::int32_t premiumFeatureProfileBadge::ID;

void premiumFeatureProfileBadge::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureProfileBadge");
    s.store_class_end();
  }
}

premiumFeatureEmojiStatus::premiumFeatureEmojiStatus() {
}

const std::int32_t premiumFeatureEmojiStatus::ID;

void premiumFeatureEmojiStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureEmojiStatus");
    s.store_class_end();
  }
}

premiumFeatureAnimatedProfilePhoto::premiumFeatureAnimatedProfilePhoto() {
}

const std::int32_t premiumFeatureAnimatedProfilePhoto::ID;

void premiumFeatureAnimatedProfilePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureAnimatedProfilePhoto");
    s.store_class_end();
  }
}

premiumFeatureForumTopicIcon::premiumFeatureForumTopicIcon() {
}

const std::int32_t premiumFeatureForumTopicIcon::ID;

void premiumFeatureForumTopicIcon::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureForumTopicIcon");
    s.store_class_end();
  }
}

premiumFeatureAppIcons::premiumFeatureAppIcons() {
}

const std::int32_t premiumFeatureAppIcons::ID;

void premiumFeatureAppIcons::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureAppIcons");
    s.store_class_end();
  }
}

premiumFeatureRealTimeChatTranslation::premiumFeatureRealTimeChatTranslation() {
}

const std::int32_t premiumFeatureRealTimeChatTranslation::ID;

void premiumFeatureRealTimeChatTranslation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureRealTimeChatTranslation");
    s.store_class_end();
  }
}

premiumFeatureUpgradedStories::premiumFeatureUpgradedStories() {
}

const std::int32_t premiumFeatureUpgradedStories::ID;

void premiumFeatureUpgradedStories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureUpgradedStories");
    s.store_class_end();
  }
}

premiumFeatureChatBoost::premiumFeatureChatBoost() {
}

const std::int32_t premiumFeatureChatBoost::ID;

void premiumFeatureChatBoost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureChatBoost");
    s.store_class_end();
  }
}

premiumFeatureAccentColor::premiumFeatureAccentColor() {
}

const std::int32_t premiumFeatureAccentColor::ID;

void premiumFeatureAccentColor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureAccentColor");
    s.store_class_end();
  }
}

premiumFeatureBackgroundForBoth::premiumFeatureBackgroundForBoth() {
}

const std::int32_t premiumFeatureBackgroundForBoth::ID;

void premiumFeatureBackgroundForBoth::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureBackgroundForBoth");
    s.store_class_end();
  }
}

premiumFeatureSavedMessagesTags::premiumFeatureSavedMessagesTags() {
}

const std::int32_t premiumFeatureSavedMessagesTags::ID;

void premiumFeatureSavedMessagesTags::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureSavedMessagesTags");
    s.store_class_end();
  }
}

premiumFeatureMessagePrivacy::premiumFeatureMessagePrivacy() {
}

const std::int32_t premiumFeatureMessagePrivacy::ID;

void premiumFeatureMessagePrivacy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureMessagePrivacy");
    s.store_class_end();
  }
}

premiumFeatureLastSeenTimes::premiumFeatureLastSeenTimes() {
}

const std::int32_t premiumFeatureLastSeenTimes::ID;

void premiumFeatureLastSeenTimes::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureLastSeenTimes");
    s.store_class_end();
  }
}

premiumFeatureBusiness::premiumFeatureBusiness() {
}

const std::int32_t premiumFeatureBusiness::ID;

void premiumFeatureBusiness::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureBusiness");
    s.store_class_end();
  }
}

premiumFeatureMessageEffects::premiumFeatureMessageEffects() {
}

const std::int32_t premiumFeatureMessageEffects::ID;

void premiumFeatureMessageEffects::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatureMessageEffects");
    s.store_class_end();
  }
}

premiumFeaturePromotionAnimation::premiumFeaturePromotionAnimation()
  : feature_()
  , animation_()
{}

premiumFeaturePromotionAnimation::premiumFeaturePromotionAnimation(object_ptr<PremiumFeature> &&feature_, object_ptr<animation> &&animation_)
  : feature_(std::move(feature_))
  , animation_(std::move(animation_))
{}

const std::int32_t premiumFeaturePromotionAnimation::ID;

void premiumFeaturePromotionAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeaturePromotionAnimation");
    s.store_object_field("feature", static_cast<const BaseObject *>(feature_.get()));
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_class_end();
  }
}

premiumFeatures::premiumFeatures()
  : features_()
  , limits_()
  , payment_link_()
{}

premiumFeatures::premiumFeatures(array<object_ptr<PremiumFeature>> &&features_, array<object_ptr<premiumLimit>> &&limits_, object_ptr<InternalLinkType> &&payment_link_)
  : features_(std::move(features_))
  , limits_(std::move(limits_))
  , payment_link_(std::move(payment_link_))
{}

const std::int32_t premiumFeatures::ID;

void premiumFeatures::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumFeatures");
    { s.store_vector_begin("features", features_.size()); for (const auto &_value : features_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("limits", limits_.size()); for (const auto &_value : limits_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("payment_link", static_cast<const BaseObject *>(payment_link_.get()));
    s.store_class_end();
  }
}

premiumGiftCodeInfo::premiumGiftCodeInfo()
  : creator_id_()
  , creation_date_()
  , is_from_giveaway_()
  , giveaway_message_id_()
  , month_count_()
  , user_id_()
  , use_date_()
{}

premiumGiftCodeInfo::premiumGiftCodeInfo(object_ptr<MessageSender> &&creator_id_, int32 creation_date_, bool is_from_giveaway_, int53 giveaway_message_id_, int32 month_count_, int53 user_id_, int32 use_date_)
  : creator_id_(std::move(creator_id_))
  , creation_date_(creation_date_)
  , is_from_giveaway_(is_from_giveaway_)
  , giveaway_message_id_(giveaway_message_id_)
  , month_count_(month_count_)
  , user_id_(user_id_)
  , use_date_(use_date_)
{}

const std::int32_t premiumGiftCodeInfo::ID;

void premiumGiftCodeInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumGiftCodeInfo");
    s.store_object_field("creator_id", static_cast<const BaseObject *>(creator_id_.get()));
    s.store_field("creation_date", creation_date_);
    s.store_field("is_from_giveaway", is_from_giveaway_);
    s.store_field("giveaway_message_id", giveaway_message_id_);
    s.store_field("month_count", month_count_);
    s.store_field("user_id", user_id_);
    s.store_field("use_date", use_date_);
    s.store_class_end();
  }
}

premiumGiftCodePaymentOption::premiumGiftCodePaymentOption()
  : currency_()
  , amount_()
  , discount_percentage_()
  , winner_count_()
  , month_count_()
  , store_product_id_()
  , store_product_quantity_()
  , sticker_()
{}

premiumGiftCodePaymentOption::premiumGiftCodePaymentOption(string const &currency_, int53 amount_, int32 discount_percentage_, int32 winner_count_, int32 month_count_, string const &store_product_id_, int32 store_product_quantity_, object_ptr<sticker> &&sticker_)
  : currency_(currency_)
  , amount_(amount_)
  , discount_percentage_(discount_percentage_)
  , winner_count_(winner_count_)
  , month_count_(month_count_)
  , store_product_id_(store_product_id_)
  , store_product_quantity_(store_product_quantity_)
  , sticker_(std::move(sticker_))
{}

const std::int32_t premiumGiftCodePaymentOption::ID;

void premiumGiftCodePaymentOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumGiftCodePaymentOption");
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("discount_percentage", discount_percentage_);
    s.store_field("winner_count", winner_count_);
    s.store_field("month_count", month_count_);
    s.store_field("store_product_id", store_product_id_);
    s.store_field("store_product_quantity", store_product_quantity_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

premiumGiftCodePaymentOptions::premiumGiftCodePaymentOptions()
  : options_()
{}

premiumGiftCodePaymentOptions::premiumGiftCodePaymentOptions(array<object_ptr<premiumGiftCodePaymentOption>> &&options_)
  : options_(std::move(options_))
{}

const std::int32_t premiumGiftCodePaymentOptions::ID;

void premiumGiftCodePaymentOptions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumGiftCodePaymentOptions");
    { s.store_vector_begin("options", options_.size()); for (const auto &_value : options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

premiumLimit::premiumLimit()
  : type_()
  , default_value_()
  , premium_value_()
{}

premiumLimit::premiumLimit(object_ptr<PremiumLimitType> &&type_, int32 default_value_, int32 premium_value_)
  : type_(std::move(type_))
  , default_value_(default_value_)
  , premium_value_(premium_value_)
{}

const std::int32_t premiumLimit::ID;

void premiumLimit::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimit");
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("default_value", default_value_);
    s.store_field("premium_value", premium_value_);
    s.store_class_end();
  }
}

premiumLimitTypeSupergroupCount::premiumLimitTypeSupergroupCount() {
}

const std::int32_t premiumLimitTypeSupergroupCount::ID;

void premiumLimitTypeSupergroupCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeSupergroupCount");
    s.store_class_end();
  }
}

premiumLimitTypePinnedChatCount::premiumLimitTypePinnedChatCount() {
}

const std::int32_t premiumLimitTypePinnedChatCount::ID;

void premiumLimitTypePinnedChatCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypePinnedChatCount");
    s.store_class_end();
  }
}

premiumLimitTypeCreatedPublicChatCount::premiumLimitTypeCreatedPublicChatCount() {
}

const std::int32_t premiumLimitTypeCreatedPublicChatCount::ID;

void premiumLimitTypeCreatedPublicChatCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeCreatedPublicChatCount");
    s.store_class_end();
  }
}

premiumLimitTypeSavedAnimationCount::premiumLimitTypeSavedAnimationCount() {
}

const std::int32_t premiumLimitTypeSavedAnimationCount::ID;

void premiumLimitTypeSavedAnimationCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeSavedAnimationCount");
    s.store_class_end();
  }
}

premiumLimitTypeFavoriteStickerCount::premiumLimitTypeFavoriteStickerCount() {
}

const std::int32_t premiumLimitTypeFavoriteStickerCount::ID;

void premiumLimitTypeFavoriteStickerCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeFavoriteStickerCount");
    s.store_class_end();
  }
}

premiumLimitTypeChatFolderCount::premiumLimitTypeChatFolderCount() {
}

const std::int32_t premiumLimitTypeChatFolderCount::ID;

void premiumLimitTypeChatFolderCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeChatFolderCount");
    s.store_class_end();
  }
}

premiumLimitTypeChatFolderChosenChatCount::premiumLimitTypeChatFolderChosenChatCount() {
}

const std::int32_t premiumLimitTypeChatFolderChosenChatCount::ID;

void premiumLimitTypeChatFolderChosenChatCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeChatFolderChosenChatCount");
    s.store_class_end();
  }
}

premiumLimitTypePinnedArchivedChatCount::premiumLimitTypePinnedArchivedChatCount() {
}

const std::int32_t premiumLimitTypePinnedArchivedChatCount::ID;

void premiumLimitTypePinnedArchivedChatCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypePinnedArchivedChatCount");
    s.store_class_end();
  }
}

premiumLimitTypePinnedSavedMessagesTopicCount::premiumLimitTypePinnedSavedMessagesTopicCount() {
}

const std::int32_t premiumLimitTypePinnedSavedMessagesTopicCount::ID;

void premiumLimitTypePinnedSavedMessagesTopicCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypePinnedSavedMessagesTopicCount");
    s.store_class_end();
  }
}

premiumLimitTypeCaptionLength::premiumLimitTypeCaptionLength() {
}

const std::int32_t premiumLimitTypeCaptionLength::ID;

void premiumLimitTypeCaptionLength::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeCaptionLength");
    s.store_class_end();
  }
}

premiumLimitTypeBioLength::premiumLimitTypeBioLength() {
}

const std::int32_t premiumLimitTypeBioLength::ID;

void premiumLimitTypeBioLength::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeBioLength");
    s.store_class_end();
  }
}

premiumLimitTypeChatFolderInviteLinkCount::premiumLimitTypeChatFolderInviteLinkCount() {
}

const std::int32_t premiumLimitTypeChatFolderInviteLinkCount::ID;

void premiumLimitTypeChatFolderInviteLinkCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeChatFolderInviteLinkCount");
    s.store_class_end();
  }
}

premiumLimitTypeShareableChatFolderCount::premiumLimitTypeShareableChatFolderCount() {
}

const std::int32_t premiumLimitTypeShareableChatFolderCount::ID;

void premiumLimitTypeShareableChatFolderCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeShareableChatFolderCount");
    s.store_class_end();
  }
}

premiumLimitTypeActiveStoryCount::premiumLimitTypeActiveStoryCount() {
}

const std::int32_t premiumLimitTypeActiveStoryCount::ID;

void premiumLimitTypeActiveStoryCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeActiveStoryCount");
    s.store_class_end();
  }
}

premiumLimitTypeWeeklySentStoryCount::premiumLimitTypeWeeklySentStoryCount() {
}

const std::int32_t premiumLimitTypeWeeklySentStoryCount::ID;

void premiumLimitTypeWeeklySentStoryCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeWeeklySentStoryCount");
    s.store_class_end();
  }
}

premiumLimitTypeMonthlySentStoryCount::premiumLimitTypeMonthlySentStoryCount() {
}

const std::int32_t premiumLimitTypeMonthlySentStoryCount::ID;

void premiumLimitTypeMonthlySentStoryCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeMonthlySentStoryCount");
    s.store_class_end();
  }
}

premiumLimitTypeStoryCaptionLength::premiumLimitTypeStoryCaptionLength() {
}

const std::int32_t premiumLimitTypeStoryCaptionLength::ID;

void premiumLimitTypeStoryCaptionLength::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeStoryCaptionLength");
    s.store_class_end();
  }
}

premiumLimitTypeStorySuggestedReactionAreaCount::premiumLimitTypeStorySuggestedReactionAreaCount() {
}

const std::int32_t premiumLimitTypeStorySuggestedReactionAreaCount::ID;

void premiumLimitTypeStorySuggestedReactionAreaCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeStorySuggestedReactionAreaCount");
    s.store_class_end();
  }
}

premiumLimitTypeSimilarChatCount::premiumLimitTypeSimilarChatCount() {
}

const std::int32_t premiumLimitTypeSimilarChatCount::ID;

void premiumLimitTypeSimilarChatCount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumLimitTypeSimilarChatCount");
    s.store_class_end();
  }
}

premiumPaymentOption::premiumPaymentOption()
  : currency_()
  , amount_()
  , discount_percentage_()
  , month_count_()
  , store_product_id_()
  , payment_link_()
{}

premiumPaymentOption::premiumPaymentOption(string const &currency_, int53 amount_, int32 discount_percentage_, int32 month_count_, string const &store_product_id_, object_ptr<InternalLinkType> &&payment_link_)
  : currency_(currency_)
  , amount_(amount_)
  , discount_percentage_(discount_percentage_)
  , month_count_(month_count_)
  , store_product_id_(store_product_id_)
  , payment_link_(std::move(payment_link_))
{}

const std::int32_t premiumPaymentOption::ID;

void premiumPaymentOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumPaymentOption");
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("discount_percentage", discount_percentage_);
    s.store_field("month_count", month_count_);
    s.store_field("store_product_id", store_product_id_);
    s.store_object_field("payment_link", static_cast<const BaseObject *>(payment_link_.get()));
    s.store_class_end();
  }
}

premiumSourceLimitExceeded::premiumSourceLimitExceeded()
  : limit_type_()
{}

premiumSourceLimitExceeded::premiumSourceLimitExceeded(object_ptr<PremiumLimitType> &&limit_type_)
  : limit_type_(std::move(limit_type_))
{}

const std::int32_t premiumSourceLimitExceeded::ID;

void premiumSourceLimitExceeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumSourceLimitExceeded");
    s.store_object_field("limit_type", static_cast<const BaseObject *>(limit_type_.get()));
    s.store_class_end();
  }
}

premiumSourceFeature::premiumSourceFeature()
  : feature_()
{}

premiumSourceFeature::premiumSourceFeature(object_ptr<PremiumFeature> &&feature_)
  : feature_(std::move(feature_))
{}

const std::int32_t premiumSourceFeature::ID;

void premiumSourceFeature::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumSourceFeature");
    s.store_object_field("feature", static_cast<const BaseObject *>(feature_.get()));
    s.store_class_end();
  }
}

premiumSourceBusinessFeature::premiumSourceBusinessFeature()
  : feature_()
{}

premiumSourceBusinessFeature::premiumSourceBusinessFeature(object_ptr<BusinessFeature> &&feature_)
  : feature_(std::move(feature_))
{}

const std::int32_t premiumSourceBusinessFeature::ID;

void premiumSourceBusinessFeature::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumSourceBusinessFeature");
    s.store_object_field("feature", static_cast<const BaseObject *>(feature_.get()));
    s.store_class_end();
  }
}

premiumSourceStoryFeature::premiumSourceStoryFeature()
  : feature_()
{}

premiumSourceStoryFeature::premiumSourceStoryFeature(object_ptr<PremiumStoryFeature> &&feature_)
  : feature_(std::move(feature_))
{}

const std::int32_t premiumSourceStoryFeature::ID;

void premiumSourceStoryFeature::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumSourceStoryFeature");
    s.store_object_field("feature", static_cast<const BaseObject *>(feature_.get()));
    s.store_class_end();
  }
}

premiumSourceLink::premiumSourceLink()
  : referrer_()
{}

premiumSourceLink::premiumSourceLink(string const &referrer_)
  : referrer_(referrer_)
{}

const std::int32_t premiumSourceLink::ID;

void premiumSourceLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumSourceLink");
    s.store_field("referrer", referrer_);
    s.store_class_end();
  }
}

premiumSourceSettings::premiumSourceSettings() {
}

const std::int32_t premiumSourceSettings::ID;

void premiumSourceSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumSourceSettings");
    s.store_class_end();
  }
}

premiumState::premiumState()
  : state_()
  , payment_options_()
  , animations_()
  , business_animations_()
{}

premiumState::premiumState(object_ptr<formattedText> &&state_, array<object_ptr<premiumStatePaymentOption>> &&payment_options_, array<object_ptr<premiumFeaturePromotionAnimation>> &&animations_, array<object_ptr<businessFeaturePromotionAnimation>> &&business_animations_)
  : state_(std::move(state_))
  , payment_options_(std::move(payment_options_))
  , animations_(std::move(animations_))
  , business_animations_(std::move(business_animations_))
{}

const std::int32_t premiumState::ID;

void premiumState::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumState");
    s.store_object_field("state", static_cast<const BaseObject *>(state_.get()));
    { s.store_vector_begin("payment_options", payment_options_.size()); for (const auto &_value : payment_options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("animations", animations_.size()); for (const auto &_value : animations_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("business_animations", business_animations_.size()); for (const auto &_value : business_animations_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

premiumStatePaymentOption::premiumStatePaymentOption()
  : payment_option_()
  , is_current_()
  , is_upgrade_()
  , last_transaction_id_()
{}

premiumStatePaymentOption::premiumStatePaymentOption(object_ptr<premiumPaymentOption> &&payment_option_, bool is_current_, bool is_upgrade_, string const &last_transaction_id_)
  : payment_option_(std::move(payment_option_))
  , is_current_(is_current_)
  , is_upgrade_(is_upgrade_)
  , last_transaction_id_(last_transaction_id_)
{}

const std::int32_t premiumStatePaymentOption::ID;

void premiumStatePaymentOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumStatePaymentOption");
    s.store_object_field("payment_option", static_cast<const BaseObject *>(payment_option_.get()));
    s.store_field("is_current", is_current_);
    s.store_field("is_upgrade", is_upgrade_);
    s.store_field("last_transaction_id", last_transaction_id_);
    s.store_class_end();
  }
}

premiumStoryFeaturePriorityOrder::premiumStoryFeaturePriorityOrder() {
}

const std::int32_t premiumStoryFeaturePriorityOrder::ID;

void premiumStoryFeaturePriorityOrder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumStoryFeaturePriorityOrder");
    s.store_class_end();
  }
}

premiumStoryFeatureStealthMode::premiumStoryFeatureStealthMode() {
}

const std::int32_t premiumStoryFeatureStealthMode::ID;

void premiumStoryFeatureStealthMode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumStoryFeatureStealthMode");
    s.store_class_end();
  }
}

premiumStoryFeaturePermanentViewsHistory::premiumStoryFeaturePermanentViewsHistory() {
}

const std::int32_t premiumStoryFeaturePermanentViewsHistory::ID;

void premiumStoryFeaturePermanentViewsHistory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumStoryFeaturePermanentViewsHistory");
    s.store_class_end();
  }
}

premiumStoryFeatureCustomExpirationDuration::premiumStoryFeatureCustomExpirationDuration() {
}

const std::int32_t premiumStoryFeatureCustomExpirationDuration::ID;

void premiumStoryFeatureCustomExpirationDuration::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumStoryFeatureCustomExpirationDuration");
    s.store_class_end();
  }
}

premiumStoryFeatureSaveStories::premiumStoryFeatureSaveStories() {
}

const std::int32_t premiumStoryFeatureSaveStories::ID;

void premiumStoryFeatureSaveStories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumStoryFeatureSaveStories");
    s.store_class_end();
  }
}

premiumStoryFeatureLinksAndFormatting::premiumStoryFeatureLinksAndFormatting() {
}

const std::int32_t premiumStoryFeatureLinksAndFormatting::ID;

void premiumStoryFeatureLinksAndFormatting::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumStoryFeatureLinksAndFormatting");
    s.store_class_end();
  }
}

premiumStoryFeatureVideoQuality::premiumStoryFeatureVideoQuality() {
}

const std::int32_t premiumStoryFeatureVideoQuality::ID;

void premiumStoryFeatureVideoQuality::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "premiumStoryFeatureVideoQuality");
    s.store_class_end();
  }
}

prepaidGiveaway::prepaidGiveaway()
  : id_()
  , winner_count_()
  , prize_()
  , boost_count_()
  , payment_date_()
{}

prepaidGiveaway::prepaidGiveaway(int64 id_, int32 winner_count_, object_ptr<GiveawayPrize> &&prize_, int32 boost_count_, int32 payment_date_)
  : id_(id_)
  , winner_count_(winner_count_)
  , prize_(std::move(prize_))
  , boost_count_(boost_count_)
  , payment_date_(payment_date_)
{}

const std::int32_t prepaidGiveaway::ID;

void prepaidGiveaway::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "prepaidGiveaway");
    s.store_field("id", id_);
    s.store_field("winner_count", winner_count_);
    s.store_object_field("prize", static_cast<const BaseObject *>(prize_.get()));
    s.store_field("boost_count", boost_count_);
    s.store_field("payment_date", payment_date_);
    s.store_class_end();
  }
}

preparedInlineMessage::preparedInlineMessage()
  : inline_query_id_()
  , result_()
  , chat_types_()
{}

preparedInlineMessage::preparedInlineMessage(int64 inline_query_id_, object_ptr<InlineQueryResult> &&result_, object_ptr<targetChatTypes> &&chat_types_)
  : inline_query_id_(inline_query_id_)
  , result_(std::move(result_))
  , chat_types_(std::move(chat_types_))
{}

const std::int32_t preparedInlineMessage::ID;

void preparedInlineMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "preparedInlineMessage");
    s.store_field("inline_query_id", inline_query_id_);
    s.store_object_field("result", static_cast<const BaseObject *>(result_.get()));
    s.store_object_field("chat_types", static_cast<const BaseObject *>(chat_types_.get()));
    s.store_class_end();
  }
}

preparedInlineMessageId::preparedInlineMessageId()
  : id_()
  , expiration_date_()
{}

preparedInlineMessageId::preparedInlineMessageId(string const &id_, int32 expiration_date_)
  : id_(id_)
  , expiration_date_(expiration_date_)
{}

const std::int32_t preparedInlineMessageId::ID;

void preparedInlineMessageId::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "preparedInlineMessageId");
    s.store_field("id", id_);
    s.store_field("expiration_date", expiration_date_);
    s.store_class_end();
  }
}

productInfo::productInfo()
  : title_()
  , description_()
  , photo_()
{}

productInfo::productInfo(string const &title_, object_ptr<formattedText> &&description_, object_ptr<photo> &&photo_)
  : title_(title_)
  , description_(std::move(description_))
  , photo_(std::move(photo_))
{}

const std::int32_t productInfo::ID;

void productInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "productInfo");
    s.store_field("title", title_);
    s.store_object_field("description", static_cast<const BaseObject *>(description_.get()));
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

profileAccentColor::profileAccentColor()
  : id_()
  , light_theme_colors_()
  , dark_theme_colors_()
  , min_supergroup_chat_boost_level_()
  , min_channel_chat_boost_level_()
{}

profileAccentColor::profileAccentColor(int32 id_, object_ptr<profileAccentColors> &&light_theme_colors_, object_ptr<profileAccentColors> &&dark_theme_colors_, int32 min_supergroup_chat_boost_level_, int32 min_channel_chat_boost_level_)
  : id_(id_)
  , light_theme_colors_(std::move(light_theme_colors_))
  , dark_theme_colors_(std::move(dark_theme_colors_))
  , min_supergroup_chat_boost_level_(min_supergroup_chat_boost_level_)
  , min_channel_chat_boost_level_(min_channel_chat_boost_level_)
{}

const std::int32_t profileAccentColor::ID;

void profileAccentColor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "profileAccentColor");
    s.store_field("id", id_);
    s.store_object_field("light_theme_colors", static_cast<const BaseObject *>(light_theme_colors_.get()));
    s.store_object_field("dark_theme_colors", static_cast<const BaseObject *>(dark_theme_colors_.get()));
    s.store_field("min_supergroup_chat_boost_level", min_supergroup_chat_boost_level_);
    s.store_field("min_channel_chat_boost_level", min_channel_chat_boost_level_);
    s.store_class_end();
  }
}

profileAccentColors::profileAccentColors()
  : palette_colors_()
  , background_colors_()
  , story_colors_()
{}

profileAccentColors::profileAccentColors(array<int32> &&palette_colors_, array<int32> &&background_colors_, array<int32> &&story_colors_)
  : palette_colors_(std::move(palette_colors_))
  , background_colors_(std::move(background_colors_))
  , story_colors_(std::move(story_colors_))
{}

const std::int32_t profileAccentColors::ID;

void profileAccentColors::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "profileAccentColors");
    { s.store_vector_begin("palette_colors", palette_colors_.size()); for (const auto &_value : palette_colors_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("background_colors", background_colors_.size()); for (const auto &_value : background_colors_) { s.store_field("", _value); } s.store_class_end(); }
    { s.store_vector_begin("story_colors", story_colors_.size()); for (const auto &_value : story_colors_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

profilePhoto::profilePhoto()
  : id_()
  , small_()
  , big_()
  , minithumbnail_()
  , has_animation_()
  , is_personal_()
{}

profilePhoto::profilePhoto(int64 id_, object_ptr<file> &&small_, object_ptr<file> &&big_, object_ptr<minithumbnail> &&minithumbnail_, bool has_animation_, bool is_personal_)
  : id_(id_)
  , small_(std::move(small_))
  , big_(std::move(big_))
  , minithumbnail_(std::move(minithumbnail_))
  , has_animation_(has_animation_)
  , is_personal_(is_personal_)
{}

const std::int32_t profilePhoto::ID;

void profilePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "profilePhoto");
    s.store_field("id", id_);
    s.store_object_field("small", static_cast<const BaseObject *>(small_.get()));
    s.store_object_field("big", static_cast<const BaseObject *>(big_.get()));
    s.store_object_field("minithumbnail", static_cast<const BaseObject *>(minithumbnail_.get()));
    s.store_field("has_animation", has_animation_);
    s.store_field("is_personal", is_personal_);
    s.store_class_end();
  }
}

proxies::proxies()
  : proxies_()
{}

proxies::proxies(array<object_ptr<proxy>> &&proxies_)
  : proxies_(std::move(proxies_))
{}

const std::int32_t proxies::ID;

void proxies::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "proxies");
    { s.store_vector_begin("proxies", proxies_.size()); for (const auto &_value : proxies_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

proxy::proxy()
  : id_()
  , server_()
  , port_()
  , last_used_date_()
  , is_enabled_()
  , type_()
{}

proxy::proxy(int32 id_, string const &server_, int32 port_, int32 last_used_date_, bool is_enabled_, object_ptr<ProxyType> &&type_)
  : id_(id_)
  , server_(server_)
  , port_(port_)
  , last_used_date_(last_used_date_)
  , is_enabled_(is_enabled_)
  , type_(std::move(type_))
{}

const std::int32_t proxy::ID;

void proxy::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "proxy");
    s.store_field("id", id_);
    s.store_field("server", server_);
    s.store_field("port", port_);
    s.store_field("last_used_date", last_used_date_);
    s.store_field("is_enabled", is_enabled_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

proxyTypeSocks5::proxyTypeSocks5()
  : username_()
  , password_()
{}

proxyTypeSocks5::proxyTypeSocks5(string const &username_, string const &password_)
  : username_(username_)
  , password_(password_)
{}

const std::int32_t proxyTypeSocks5::ID;

void proxyTypeSocks5::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "proxyTypeSocks5");
    s.store_field("username", username_);
    s.store_field("password", password_);
    s.store_class_end();
  }
}

proxyTypeHttp::proxyTypeHttp()
  : username_()
  , password_()
  , http_only_()
{}

proxyTypeHttp::proxyTypeHttp(string const &username_, string const &password_, bool http_only_)
  : username_(username_)
  , password_(password_)
  , http_only_(http_only_)
{}

const std::int32_t proxyTypeHttp::ID;

void proxyTypeHttp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "proxyTypeHttp");
    s.store_field("username", username_);
    s.store_field("password", password_);
    s.store_field("http_only", http_only_);
    s.store_class_end();
  }
}

proxyTypeMtproto::proxyTypeMtproto()
  : secret_()
{}

proxyTypeMtproto::proxyTypeMtproto(string const &secret_)
  : secret_(secret_)
{}

const std::int32_t proxyTypeMtproto::ID;

void proxyTypeMtproto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "proxyTypeMtproto");
    s.store_field("secret", secret_);
    s.store_class_end();
  }
}

publicChatTypeHasUsername::publicChatTypeHasUsername() {
}

const std::int32_t publicChatTypeHasUsername::ID;

void publicChatTypeHasUsername::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "publicChatTypeHasUsername");
    s.store_class_end();
  }
}

publicChatTypeIsLocationBased::publicChatTypeIsLocationBased() {
}

const std::int32_t publicChatTypeIsLocationBased::ID;

void publicChatTypeIsLocationBased::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "publicChatTypeIsLocationBased");
    s.store_class_end();
  }
}

publicForwardMessage::publicForwardMessage()
  : message_()
{}

publicForwardMessage::publicForwardMessage(object_ptr<message> &&message_)
  : message_(std::move(message_))
{}

const std::int32_t publicForwardMessage::ID;

void publicForwardMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "publicForwardMessage");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

publicForwardStory::publicForwardStory()
  : story_()
{}

publicForwardStory::publicForwardStory(object_ptr<story> &&story_)
  : story_(std::move(story_))
{}

const std::int32_t publicForwardStory::ID;

void publicForwardStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "publicForwardStory");
    s.store_object_field("story", static_cast<const BaseObject *>(story_.get()));
    s.store_class_end();
  }
}

publicForwards::publicForwards()
  : total_count_()
  , forwards_()
  , next_offset_()
{}

publicForwards::publicForwards(int32 total_count_, array<object_ptr<PublicForward>> &&forwards_, string const &next_offset_)
  : total_count_(total_count_)
  , forwards_(std::move(forwards_))
  , next_offset_(next_offset_)
{}

const std::int32_t publicForwards::ID;

void publicForwards::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "publicForwards");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("forwards", forwards_.size()); for (const auto &_value : forwards_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

pushMessageContentHidden::pushMessageContentHidden()
  : is_pinned_()
{}

pushMessageContentHidden::pushMessageContentHidden(bool is_pinned_)
  : is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentHidden::ID;

void pushMessageContentHidden::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentHidden");
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentAnimation::pushMessageContentAnimation()
  : animation_()
  , caption_()
  , is_pinned_()
{}

pushMessageContentAnimation::pushMessageContentAnimation(object_ptr<animation> &&animation_, string const &caption_, bool is_pinned_)
  : animation_(std::move(animation_))
  , caption_(caption_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentAnimation::ID;

void pushMessageContentAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentAnimation");
    s.store_object_field("animation", static_cast<const BaseObject *>(animation_.get()));
    s.store_field("caption", caption_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentAudio::pushMessageContentAudio()
  : audio_()
  , is_pinned_()
{}

pushMessageContentAudio::pushMessageContentAudio(object_ptr<audio> &&audio_, bool is_pinned_)
  : audio_(std::move(audio_))
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentAudio::ID;

void pushMessageContentAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentAudio");
    s.store_object_field("audio", static_cast<const BaseObject *>(audio_.get()));
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentContact::pushMessageContentContact()
  : name_()
  , is_pinned_()
{}

pushMessageContentContact::pushMessageContentContact(string const &name_, bool is_pinned_)
  : name_(name_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentContact::ID;

void pushMessageContentContact::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentContact");
    s.store_field("name", name_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentContactRegistered::pushMessageContentContactRegistered() {
}

const std::int32_t pushMessageContentContactRegistered::ID;

void pushMessageContentContactRegistered::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentContactRegistered");
    s.store_class_end();
  }
}

pushMessageContentDocument::pushMessageContentDocument()
  : document_()
  , is_pinned_()
{}

pushMessageContentDocument::pushMessageContentDocument(object_ptr<document> &&document_, bool is_pinned_)
  : document_(std::move(document_))
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentDocument::ID;

void pushMessageContentDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentDocument");
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentGame::pushMessageContentGame()
  : title_()
  , is_pinned_()
{}

pushMessageContentGame::pushMessageContentGame(string const &title_, bool is_pinned_)
  : title_(title_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentGame::ID;

void pushMessageContentGame::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentGame");
    s.store_field("title", title_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentGameScore::pushMessageContentGameScore()
  : title_()
  , score_()
  , is_pinned_()
{}

pushMessageContentGameScore::pushMessageContentGameScore(string const &title_, int32 score_, bool is_pinned_)
  : title_(title_)
  , score_(score_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentGameScore::ID;

void pushMessageContentGameScore::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentGameScore");
    s.store_field("title", title_);
    s.store_field("score", score_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentInvoice::pushMessageContentInvoice()
  : price_()
  , is_pinned_()
{}

pushMessageContentInvoice::pushMessageContentInvoice(string const &price_, bool is_pinned_)
  : price_(price_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentInvoice::ID;

void pushMessageContentInvoice::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentInvoice");
    s.store_field("price", price_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentLocation::pushMessageContentLocation()
  : is_live_()
  , is_pinned_()
{}

pushMessageContentLocation::pushMessageContentLocation(bool is_live_, bool is_pinned_)
  : is_live_(is_live_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentLocation::ID;

void pushMessageContentLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentLocation");
    s.store_field("is_live", is_live_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentPaidMedia::pushMessageContentPaidMedia()
  : star_count_()
  , is_pinned_()
{}

pushMessageContentPaidMedia::pushMessageContentPaidMedia(int53 star_count_, bool is_pinned_)
  : star_count_(star_count_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentPaidMedia::ID;

void pushMessageContentPaidMedia::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentPaidMedia");
    s.store_field("star_count", star_count_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentPhoto::pushMessageContentPhoto()
  : photo_()
  , caption_()
  , is_secret_()
  , is_pinned_()
{}

pushMessageContentPhoto::pushMessageContentPhoto(object_ptr<photo> &&photo_, string const &caption_, bool is_secret_, bool is_pinned_)
  : photo_(std::move(photo_))
  , caption_(caption_)
  , is_secret_(is_secret_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentPhoto::ID;

void pushMessageContentPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentPhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("caption", caption_);
    s.store_field("is_secret", is_secret_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentPoll::pushMessageContentPoll()
  : question_()
  , is_regular_()
  , is_pinned_()
{}

pushMessageContentPoll::pushMessageContentPoll(string const &question_, bool is_regular_, bool is_pinned_)
  : question_(question_)
  , is_regular_(is_regular_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentPoll::ID;

void pushMessageContentPoll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentPoll");
    s.store_field("question", question_);
    s.store_field("is_regular", is_regular_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentPremiumGiftCode::pushMessageContentPremiumGiftCode()
  : month_count_()
{}

pushMessageContentPremiumGiftCode::pushMessageContentPremiumGiftCode(int32 month_count_)
  : month_count_(month_count_)
{}

const std::int32_t pushMessageContentPremiumGiftCode::ID;

void pushMessageContentPremiumGiftCode::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentPremiumGiftCode");
    s.store_field("month_count", month_count_);
    s.store_class_end();
  }
}

pushMessageContentGiveaway::pushMessageContentGiveaway()
  : winner_count_()
  , prize_()
  , is_pinned_()
{}

pushMessageContentGiveaway::pushMessageContentGiveaway(int32 winner_count_, object_ptr<GiveawayPrize> &&prize_, bool is_pinned_)
  : winner_count_(winner_count_)
  , prize_(std::move(prize_))
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentGiveaway::ID;

void pushMessageContentGiveaway::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentGiveaway");
    s.store_field("winner_count", winner_count_);
    s.store_object_field("prize", static_cast<const BaseObject *>(prize_.get()));
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentGift::pushMessageContentGift()
  : star_count_()
{}

pushMessageContentGift::pushMessageContentGift(int53 star_count_)
  : star_count_(star_count_)
{}

const std::int32_t pushMessageContentGift::ID;

void pushMessageContentGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentGift");
    s.store_field("star_count", star_count_);
    s.store_class_end();
  }
}

pushMessageContentUpgradedGift::pushMessageContentUpgradedGift()
  : is_upgrade_()
{}

pushMessageContentUpgradedGift::pushMessageContentUpgradedGift(bool is_upgrade_)
  : is_upgrade_(is_upgrade_)
{}

const std::int32_t pushMessageContentUpgradedGift::ID;

void pushMessageContentUpgradedGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentUpgradedGift");
    s.store_field("is_upgrade", is_upgrade_);
    s.store_class_end();
  }
}

pushMessageContentScreenshotTaken::pushMessageContentScreenshotTaken() {
}

const std::int32_t pushMessageContentScreenshotTaken::ID;

void pushMessageContentScreenshotTaken::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentScreenshotTaken");
    s.store_class_end();
  }
}

pushMessageContentSticker::pushMessageContentSticker()
  : sticker_()
  , emoji_()
  , is_pinned_()
{}

pushMessageContentSticker::pushMessageContentSticker(object_ptr<sticker> &&sticker_, string const &emoji_, bool is_pinned_)
  : sticker_(std::move(sticker_))
  , emoji_(emoji_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentSticker::ID;

void pushMessageContentSticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentSticker");
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_field("emoji", emoji_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentStory::pushMessageContentStory()
  : is_pinned_()
{}

pushMessageContentStory::pushMessageContentStory(bool is_pinned_)
  : is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentStory::ID;

void pushMessageContentStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentStory");
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentText::pushMessageContentText()
  : text_()
  , is_pinned_()
{}

pushMessageContentText::pushMessageContentText(string const &text_, bool is_pinned_)
  : text_(text_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentText::ID;

void pushMessageContentText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentText");
    s.store_field("text", text_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentVideo::pushMessageContentVideo()
  : video_()
  , caption_()
  , is_secret_()
  , is_pinned_()
{}

pushMessageContentVideo::pushMessageContentVideo(object_ptr<video> &&video_, string const &caption_, bool is_secret_, bool is_pinned_)
  : video_(std::move(video_))
  , caption_(caption_)
  , is_secret_(is_secret_)
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentVideo::ID;

void pushMessageContentVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentVideo");
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_field("caption", caption_);
    s.store_field("is_secret", is_secret_);
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentVideoNote::pushMessageContentVideoNote()
  : video_note_()
  , is_pinned_()
{}

pushMessageContentVideoNote::pushMessageContentVideoNote(object_ptr<videoNote> &&video_note_, bool is_pinned_)
  : video_note_(std::move(video_note_))
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentVideoNote::ID;

void pushMessageContentVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentVideoNote");
    s.store_object_field("video_note", static_cast<const BaseObject *>(video_note_.get()));
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentVoiceNote::pushMessageContentVoiceNote()
  : voice_note_()
  , is_pinned_()
{}

pushMessageContentVoiceNote::pushMessageContentVoiceNote(object_ptr<voiceNote> &&voice_note_, bool is_pinned_)
  : voice_note_(std::move(voice_note_))
  , is_pinned_(is_pinned_)
{}

const std::int32_t pushMessageContentVoiceNote::ID;

void pushMessageContentVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentVoiceNote");
    s.store_object_field("voice_note", static_cast<const BaseObject *>(voice_note_.get()));
    s.store_field("is_pinned", is_pinned_);
    s.store_class_end();
  }
}

pushMessageContentBasicGroupChatCreate::pushMessageContentBasicGroupChatCreate() {
}

const std::int32_t pushMessageContentBasicGroupChatCreate::ID;

void pushMessageContentBasicGroupChatCreate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentBasicGroupChatCreate");
    s.store_class_end();
  }
}

pushMessageContentChatAddMembers::pushMessageContentChatAddMembers()
  : member_name_()
  , is_current_user_()
  , is_returned_()
{}

pushMessageContentChatAddMembers::pushMessageContentChatAddMembers(string const &member_name_, bool is_current_user_, bool is_returned_)
  : member_name_(member_name_)
  , is_current_user_(is_current_user_)
  , is_returned_(is_returned_)
{}

const std::int32_t pushMessageContentChatAddMembers::ID;

void pushMessageContentChatAddMembers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentChatAddMembers");
    s.store_field("member_name", member_name_);
    s.store_field("is_current_user", is_current_user_);
    s.store_field("is_returned", is_returned_);
    s.store_class_end();
  }
}

pushMessageContentChatChangePhoto::pushMessageContentChatChangePhoto() {
}

const std::int32_t pushMessageContentChatChangePhoto::ID;

void pushMessageContentChatChangePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentChatChangePhoto");
    s.store_class_end();
  }
}

pushMessageContentChatChangeTitle::pushMessageContentChatChangeTitle()
  : title_()
{}

pushMessageContentChatChangeTitle::pushMessageContentChatChangeTitle(string const &title_)
  : title_(title_)
{}

const std::int32_t pushMessageContentChatChangeTitle::ID;

void pushMessageContentChatChangeTitle::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentChatChangeTitle");
    s.store_field("title", title_);
    s.store_class_end();
  }
}

pushMessageContentChatSetBackground::pushMessageContentChatSetBackground()
  : is_same_()
{}

pushMessageContentChatSetBackground::pushMessageContentChatSetBackground(bool is_same_)
  : is_same_(is_same_)
{}

const std::int32_t pushMessageContentChatSetBackground::ID;

void pushMessageContentChatSetBackground::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentChatSetBackground");
    s.store_field("is_same", is_same_);
    s.store_class_end();
  }
}

pushMessageContentChatSetTheme::pushMessageContentChatSetTheme()
  : theme_name_()
{}

pushMessageContentChatSetTheme::pushMessageContentChatSetTheme(string const &theme_name_)
  : theme_name_(theme_name_)
{}

const std::int32_t pushMessageContentChatSetTheme::ID;

void pushMessageContentChatSetTheme::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentChatSetTheme");
    s.store_field("theme_name", theme_name_);
    s.store_class_end();
  }
}

pushMessageContentChatDeleteMember::pushMessageContentChatDeleteMember()
  : member_name_()
  , is_current_user_()
  , is_left_()
{}

pushMessageContentChatDeleteMember::pushMessageContentChatDeleteMember(string const &member_name_, bool is_current_user_, bool is_left_)
  : member_name_(member_name_)
  , is_current_user_(is_current_user_)
  , is_left_(is_left_)
{}

const std::int32_t pushMessageContentChatDeleteMember::ID;

void pushMessageContentChatDeleteMember::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentChatDeleteMember");
    s.store_field("member_name", member_name_);
    s.store_field("is_current_user", is_current_user_);
    s.store_field("is_left", is_left_);
    s.store_class_end();
  }
}

pushMessageContentChatJoinByLink::pushMessageContentChatJoinByLink() {
}

const std::int32_t pushMessageContentChatJoinByLink::ID;

void pushMessageContentChatJoinByLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentChatJoinByLink");
    s.store_class_end();
  }
}

pushMessageContentChatJoinByRequest::pushMessageContentChatJoinByRequest() {
}

const std::int32_t pushMessageContentChatJoinByRequest::ID;

void pushMessageContentChatJoinByRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentChatJoinByRequest");
    s.store_class_end();
  }
}

pushMessageContentRecurringPayment::pushMessageContentRecurringPayment()
  : amount_()
{}

pushMessageContentRecurringPayment::pushMessageContentRecurringPayment(string const &amount_)
  : amount_(amount_)
{}

const std::int32_t pushMessageContentRecurringPayment::ID;

void pushMessageContentRecurringPayment::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentRecurringPayment");
    s.store_field("amount", amount_);
    s.store_class_end();
  }
}

pushMessageContentSuggestProfilePhoto::pushMessageContentSuggestProfilePhoto() {
}

const std::int32_t pushMessageContentSuggestProfilePhoto::ID;

void pushMessageContentSuggestProfilePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentSuggestProfilePhoto");
    s.store_class_end();
  }
}

pushMessageContentMessageForwards::pushMessageContentMessageForwards()
  : total_count_()
{}

pushMessageContentMessageForwards::pushMessageContentMessageForwards(int32 total_count_)
  : total_count_(total_count_)
{}

const std::int32_t pushMessageContentMessageForwards::ID;

void pushMessageContentMessageForwards::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentMessageForwards");
    s.store_field("total_count", total_count_);
    s.store_class_end();
  }
}

pushMessageContentMediaAlbum::pushMessageContentMediaAlbum()
  : total_count_()
  , has_photos_()
  , has_videos_()
  , has_audios_()
  , has_documents_()
{}

pushMessageContentMediaAlbum::pushMessageContentMediaAlbum(int32 total_count_, bool has_photos_, bool has_videos_, bool has_audios_, bool has_documents_)
  : total_count_(total_count_)
  , has_photos_(has_photos_)
  , has_videos_(has_videos_)
  , has_audios_(has_audios_)
  , has_documents_(has_documents_)
{}

const std::int32_t pushMessageContentMediaAlbum::ID;

void pushMessageContentMediaAlbum::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushMessageContentMediaAlbum");
    s.store_field("total_count", total_count_);
    s.store_field("has_photos", has_photos_);
    s.store_field("has_videos", has_videos_);
    s.store_field("has_audios", has_audios_);
    s.store_field("has_documents", has_documents_);
    s.store_class_end();
  }
}

pushReceiverId::pushReceiverId()
  : id_()
{}

pushReceiverId::pushReceiverId(int64 id_)
  : id_(id_)
{}

const std::int32_t pushReceiverId::ID;

void pushReceiverId::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "pushReceiverId");
    s.store_field("id", id_);
    s.store_class_end();
  }
}

quickReplyMessage::quickReplyMessage()
  : id_()
  , sending_state_()
  , can_be_edited_()
  , reply_to_message_id_()
  , via_bot_user_id_()
  , media_album_id_()
  , content_()
  , reply_markup_()
{}

quickReplyMessage::quickReplyMessage(int53 id_, object_ptr<MessageSendingState> &&sending_state_, bool can_be_edited_, int53 reply_to_message_id_, int53 via_bot_user_id_, int64 media_album_id_, object_ptr<MessageContent> &&content_, object_ptr<ReplyMarkup> &&reply_markup_)
  : id_(id_)
  , sending_state_(std::move(sending_state_))
  , can_be_edited_(can_be_edited_)
  , reply_to_message_id_(reply_to_message_id_)
  , via_bot_user_id_(via_bot_user_id_)
  , media_album_id_(media_album_id_)
  , content_(std::move(content_))
  , reply_markup_(std::move(reply_markup_))
{}

const std::int32_t quickReplyMessage::ID;

void quickReplyMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "quickReplyMessage");
    s.store_field("id", id_);
    s.store_object_field("sending_state", static_cast<const BaseObject *>(sending_state_.get()));
    s.store_field("can_be_edited", can_be_edited_);
    s.store_field("reply_to_message_id", reply_to_message_id_);
    s.store_field("via_bot_user_id", via_bot_user_id_);
    s.store_field("media_album_id", media_album_id_);
    s.store_object_field("content", static_cast<const BaseObject *>(content_.get()));
    s.store_object_field("reply_markup", static_cast<const BaseObject *>(reply_markup_.get()));
    s.store_class_end();
  }
}

quickReplyMessages::quickReplyMessages()
  : messages_()
{}

quickReplyMessages::quickReplyMessages(array<object_ptr<quickReplyMessage>> &&messages_)
  : messages_(std::move(messages_))
{}

const std::int32_t quickReplyMessages::ID;

void quickReplyMessages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "quickReplyMessages");
    { s.store_vector_begin("messages", messages_.size()); for (const auto &_value : messages_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

quickReplyShortcut::quickReplyShortcut()
  : id_()
  , name_()
  , first_message_()
  , message_count_()
{}

quickReplyShortcut::quickReplyShortcut(int32 id_, string const &name_, object_ptr<quickReplyMessage> &&first_message_, int32 message_count_)
  : id_(id_)
  , name_(name_)
  , first_message_(std::move(first_message_))
  , message_count_(message_count_)
{}

const std::int32_t quickReplyShortcut::ID;

void quickReplyShortcut::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "quickReplyShortcut");
    s.store_field("id", id_);
    s.store_field("name", name_);
    s.store_object_field("first_message", static_cast<const BaseObject *>(first_message_.get()));
    s.store_field("message_count", message_count_);
    s.store_class_end();
  }
}

reactionNotificationSettings::reactionNotificationSettings()
  : message_reaction_source_()
  , story_reaction_source_()
  , sound_id_()
  , show_preview_()
{}

reactionNotificationSettings::reactionNotificationSettings(object_ptr<ReactionNotificationSource> &&message_reaction_source_, object_ptr<ReactionNotificationSource> &&story_reaction_source_, int64 sound_id_, bool show_preview_)
  : message_reaction_source_(std::move(message_reaction_source_))
  , story_reaction_source_(std::move(story_reaction_source_))
  , sound_id_(sound_id_)
  , show_preview_(show_preview_)
{}

const std::int32_t reactionNotificationSettings::ID;

void reactionNotificationSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reactionNotificationSettings");
    s.store_object_field("message_reaction_source", static_cast<const BaseObject *>(message_reaction_source_.get()));
    s.store_object_field("story_reaction_source", static_cast<const BaseObject *>(story_reaction_source_.get()));
    s.store_field("sound_id", sound_id_);
    s.store_field("show_preview", show_preview_);
    s.store_class_end();
  }
}

reactionNotificationSourceNone::reactionNotificationSourceNone() {
}

const std::int32_t reactionNotificationSourceNone::ID;

void reactionNotificationSourceNone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reactionNotificationSourceNone");
    s.store_class_end();
  }
}

reactionNotificationSourceContacts::reactionNotificationSourceContacts() {
}

const std::int32_t reactionNotificationSourceContacts::ID;

void reactionNotificationSourceContacts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reactionNotificationSourceContacts");
    s.store_class_end();
  }
}

reactionNotificationSourceAll::reactionNotificationSourceAll() {
}

const std::int32_t reactionNotificationSourceAll::ID;

void reactionNotificationSourceAll::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reactionNotificationSourceAll");
    s.store_class_end();
  }
}

reactionTypeEmoji::reactionTypeEmoji()
  : emoji_()
{}

reactionTypeEmoji::reactionTypeEmoji(string const &emoji_)
  : emoji_(emoji_)
{}

const std::int32_t reactionTypeEmoji::ID;

void reactionTypeEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reactionTypeEmoji");
    s.store_field("emoji", emoji_);
    s.store_class_end();
  }
}

reactionTypeCustomEmoji::reactionTypeCustomEmoji()
  : custom_emoji_id_()
{}

reactionTypeCustomEmoji::reactionTypeCustomEmoji(int64 custom_emoji_id_)
  : custom_emoji_id_(custom_emoji_id_)
{}

const std::int32_t reactionTypeCustomEmoji::ID;

void reactionTypeCustomEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reactionTypeCustomEmoji");
    s.store_field("custom_emoji_id", custom_emoji_id_);
    s.store_class_end();
  }
}

reactionTypePaid::reactionTypePaid() {
}

const std::int32_t reactionTypePaid::ID;

void reactionTypePaid::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reactionTypePaid");
    s.store_class_end();
  }
}

reactionUnavailabilityReasonAnonymousAdministrator::reactionUnavailabilityReasonAnonymousAdministrator() {
}

const std::int32_t reactionUnavailabilityReasonAnonymousAdministrator::ID;

void reactionUnavailabilityReasonAnonymousAdministrator::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reactionUnavailabilityReasonAnonymousAdministrator");
    s.store_class_end();
  }
}

reactionUnavailabilityReasonGuest::reactionUnavailabilityReasonGuest() {
}

const std::int32_t reactionUnavailabilityReasonGuest::ID;

void reactionUnavailabilityReasonGuest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reactionUnavailabilityReasonGuest");
    s.store_class_end();
  }
}

readDatePrivacySettings::readDatePrivacySettings()
  : show_read_date_()
{}

readDatePrivacySettings::readDatePrivacySettings(bool show_read_date_)
  : show_read_date_(show_read_date_)
{}

const std::int32_t readDatePrivacySettings::ID;

void readDatePrivacySettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "readDatePrivacySettings");
    s.store_field("show_read_date", show_read_date_);
    s.store_class_end();
  }
}

receivedGift::receivedGift()
  : received_gift_id_()
  , sender_id_()
  , text_()
  , is_private_()
  , is_saved_()
  , can_be_upgraded_()
  , can_be_transferred_()
  , was_refunded_()
  , date_()
  , gift_()
  , sell_star_count_()
  , prepaid_upgrade_star_count_()
  , transfer_star_count_()
  , export_date_()
{}

receivedGift::receivedGift(string const &received_gift_id_, object_ptr<MessageSender> &&sender_id_, object_ptr<formattedText> &&text_, bool is_private_, bool is_saved_, bool can_be_upgraded_, bool can_be_transferred_, bool was_refunded_, int32 date_, object_ptr<SentGift> &&gift_, int53 sell_star_count_, int53 prepaid_upgrade_star_count_, int53 transfer_star_count_, int32 export_date_)
  : received_gift_id_(received_gift_id_)
  , sender_id_(std::move(sender_id_))
  , text_(std::move(text_))
  , is_private_(is_private_)
  , is_saved_(is_saved_)
  , can_be_upgraded_(can_be_upgraded_)
  , can_be_transferred_(can_be_transferred_)
  , was_refunded_(was_refunded_)
  , date_(date_)
  , gift_(std::move(gift_))
  , sell_star_count_(sell_star_count_)
  , prepaid_upgrade_star_count_(prepaid_upgrade_star_count_)
  , transfer_star_count_(transfer_star_count_)
  , export_date_(export_date_)
{}

const std::int32_t receivedGift::ID;

void receivedGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "receivedGift");
    s.store_field("received_gift_id", received_gift_id_);
    s.store_object_field("sender_id", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("is_private", is_private_);
    s.store_field("is_saved", is_saved_);
    s.store_field("can_be_upgraded", can_be_upgraded_);
    s.store_field("can_be_transferred", can_be_transferred_);
    s.store_field("was_refunded", was_refunded_);
    s.store_field("date", date_);
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_field("sell_star_count", sell_star_count_);
    s.store_field("prepaid_upgrade_star_count", prepaid_upgrade_star_count_);
    s.store_field("transfer_star_count", transfer_star_count_);
    s.store_field("export_date", export_date_);
    s.store_class_end();
  }
}

receivedGifts::receivedGifts()
  : total_count_()
  , gifts_()
  , are_notifications_enabled_()
  , next_offset_()
{}

receivedGifts::receivedGifts(int32 total_count_, array<object_ptr<receivedGift>> &&gifts_, bool are_notifications_enabled_, string const &next_offset_)
  : total_count_(total_count_)
  , gifts_(std::move(gifts_))
  , are_notifications_enabled_(are_notifications_enabled_)
  , next_offset_(next_offset_)
{}

const std::int32_t receivedGifts::ID;

void receivedGifts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "receivedGifts");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("gifts", gifts_.size()); for (const auto &_value : gifts_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("are_notifications_enabled", are_notifications_enabled_);
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

recommendedChatFolder::recommendedChatFolder()
  : folder_()
  , description_()
{}

recommendedChatFolder::recommendedChatFolder(object_ptr<chatFolder> &&folder_, string const &description_)
  : folder_(std::move(folder_))
  , description_(description_)
{}

const std::int32_t recommendedChatFolder::ID;

void recommendedChatFolder::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "recommendedChatFolder");
    s.store_object_field("folder", static_cast<const BaseObject *>(folder_.get()));
    s.store_field("description", description_);
    s.store_class_end();
  }
}

recommendedChatFolders::recommendedChatFolders()
  : chat_folders_()
{}

recommendedChatFolders::recommendedChatFolders(array<object_ptr<recommendedChatFolder>> &&chat_folders_)
  : chat_folders_(std::move(chat_folders_))
{}

const std::int32_t recommendedChatFolders::ID;

void recommendedChatFolders::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "recommendedChatFolders");
    { s.store_vector_begin("chat_folders", chat_folders_.size()); for (const auto &_value : chat_folders_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

recoveryEmailAddress::recoveryEmailAddress()
  : recovery_email_address_()
{}

recoveryEmailAddress::recoveryEmailAddress(string const &recovery_email_address_)
  : recovery_email_address_(recovery_email_address_)
{}

const std::int32_t recoveryEmailAddress::ID;

void recoveryEmailAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "recoveryEmailAddress");
    s.store_field("recovery_email_address", recovery_email_address_);
    s.store_class_end();
  }
}

remoteFile::remoteFile()
  : id_()
  , unique_id_()
  , is_uploading_active_()
  , is_uploading_completed_()
  , uploaded_size_()
{}

remoteFile::remoteFile(string const &id_, string const &unique_id_, bool is_uploading_active_, bool is_uploading_completed_, int53 uploaded_size_)
  : id_(id_)
  , unique_id_(unique_id_)
  , is_uploading_active_(is_uploading_active_)
  , is_uploading_completed_(is_uploading_completed_)
  , uploaded_size_(uploaded_size_)
{}

const std::int32_t remoteFile::ID;

void remoteFile::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "remoteFile");
    s.store_field("id", id_);
    s.store_field("unique_id", unique_id_);
    s.store_field("is_uploading_active", is_uploading_active_);
    s.store_field("is_uploading_completed", is_uploading_completed_);
    s.store_field("uploaded_size", uploaded_size_);
    s.store_class_end();
  }
}

replyMarkupRemoveKeyboard::replyMarkupRemoveKeyboard()
  : is_personal_()
{}

replyMarkupRemoveKeyboard::replyMarkupRemoveKeyboard(bool is_personal_)
  : is_personal_(is_personal_)
{}

const std::int32_t replyMarkupRemoveKeyboard::ID;

void replyMarkupRemoveKeyboard::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "replyMarkupRemoveKeyboard");
    s.store_field("is_personal", is_personal_);
    s.store_class_end();
  }
}

replyMarkupForceReply::replyMarkupForceReply()
  : is_personal_()
  , input_field_placeholder_()
{}

replyMarkupForceReply::replyMarkupForceReply(bool is_personal_, string const &input_field_placeholder_)
  : is_personal_(is_personal_)
  , input_field_placeholder_(input_field_placeholder_)
{}

const std::int32_t replyMarkupForceReply::ID;

void replyMarkupForceReply::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "replyMarkupForceReply");
    s.store_field("is_personal", is_personal_);
    s.store_field("input_field_placeholder", input_field_placeholder_);
    s.store_class_end();
  }
}

replyMarkupShowKeyboard::replyMarkupShowKeyboard()
  : rows_()
  , is_persistent_()
  , resize_keyboard_()
  , one_time_()
  , is_personal_()
  , input_field_placeholder_()
{}

replyMarkupShowKeyboard::replyMarkupShowKeyboard(array<array<object_ptr<keyboardButton>>> &&rows_, bool is_persistent_, bool resize_keyboard_, bool one_time_, bool is_personal_, string const &input_field_placeholder_)
  : rows_(std::move(rows_))
  , is_persistent_(is_persistent_)
  , resize_keyboard_(resize_keyboard_)
  , one_time_(one_time_)
  , is_personal_(is_personal_)
  , input_field_placeholder_(input_field_placeholder_)
{}

const std::int32_t replyMarkupShowKeyboard::ID;

void replyMarkupShowKeyboard::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "replyMarkupShowKeyboard");
    { s.store_vector_begin("rows", rows_.size()); for (const auto &_value : rows_) { { s.store_vector_begin("", _value.size()); for (const auto &_value2 : _value) { s.store_object_field("", static_cast<const BaseObject *>(_value2.get())); } s.store_class_end(); } } s.store_class_end(); }
    s.store_field("is_persistent", is_persistent_);
    s.store_field("resize_keyboard", resize_keyboard_);
    s.store_field("one_time", one_time_);
    s.store_field("is_personal", is_personal_);
    s.store_field("input_field_placeholder", input_field_placeholder_);
    s.store_class_end();
  }
}

replyMarkupInlineKeyboard::replyMarkupInlineKeyboard()
  : rows_()
{}

replyMarkupInlineKeyboard::replyMarkupInlineKeyboard(array<array<object_ptr<inlineKeyboardButton>>> &&rows_)
  : rows_(std::move(rows_))
{}

const std::int32_t replyMarkupInlineKeyboard::ID;

void replyMarkupInlineKeyboard::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "replyMarkupInlineKeyboard");
    { s.store_vector_begin("rows", rows_.size()); for (const auto &_value : rows_) { { s.store_vector_begin("", _value.size()); for (const auto &_value2 : _value) { s.store_object_field("", static_cast<const BaseObject *>(_value2.get())); } s.store_class_end(); } } s.store_class_end(); }
    s.store_class_end();
  }
}

reportChatResultOk::reportChatResultOk() {
}

const std::int32_t reportChatResultOk::ID;

void reportChatResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportChatResultOk");
    s.store_class_end();
  }
}

reportChatResultOptionRequired::reportChatResultOptionRequired()
  : title_()
  , options_()
{}

reportChatResultOptionRequired::reportChatResultOptionRequired(string const &title_, array<object_ptr<reportOption>> &&options_)
  : title_(title_)
  , options_(std::move(options_))
{}

const std::int32_t reportChatResultOptionRequired::ID;

void reportChatResultOptionRequired::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportChatResultOptionRequired");
    s.store_field("title", title_);
    { s.store_vector_begin("options", options_.size()); for (const auto &_value : options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

reportChatResultTextRequired::reportChatResultTextRequired()
  : option_id_()
  , is_optional_()
{}

reportChatResultTextRequired::reportChatResultTextRequired(bytes const &option_id_, bool is_optional_)
  : option_id_(std::move(option_id_))
  , is_optional_(is_optional_)
{}

const std::int32_t reportChatResultTextRequired::ID;

void reportChatResultTextRequired::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportChatResultTextRequired");
    s.store_bytes_field("option_id", option_id_);
    s.store_field("is_optional", is_optional_);
    s.store_class_end();
  }
}

reportChatResultMessagesRequired::reportChatResultMessagesRequired() {
}

const std::int32_t reportChatResultMessagesRequired::ID;

void reportChatResultMessagesRequired::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportChatResultMessagesRequired");
    s.store_class_end();
  }
}

reportChatSponsoredMessageResultOk::reportChatSponsoredMessageResultOk() {
}

const std::int32_t reportChatSponsoredMessageResultOk::ID;

void reportChatSponsoredMessageResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportChatSponsoredMessageResultOk");
    s.store_class_end();
  }
}

reportChatSponsoredMessageResultFailed::reportChatSponsoredMessageResultFailed() {
}

const std::int32_t reportChatSponsoredMessageResultFailed::ID;

void reportChatSponsoredMessageResultFailed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportChatSponsoredMessageResultFailed");
    s.store_class_end();
  }
}

reportChatSponsoredMessageResultOptionRequired::reportChatSponsoredMessageResultOptionRequired()
  : title_()
  , options_()
{}

reportChatSponsoredMessageResultOptionRequired::reportChatSponsoredMessageResultOptionRequired(string const &title_, array<object_ptr<reportOption>> &&options_)
  : title_(title_)
  , options_(std::move(options_))
{}

const std::int32_t reportChatSponsoredMessageResultOptionRequired::ID;

void reportChatSponsoredMessageResultOptionRequired::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportChatSponsoredMessageResultOptionRequired");
    s.store_field("title", title_);
    { s.store_vector_begin("options", options_.size()); for (const auto &_value : options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

reportChatSponsoredMessageResultAdsHidden::reportChatSponsoredMessageResultAdsHidden() {
}

const std::int32_t reportChatSponsoredMessageResultAdsHidden::ID;

void reportChatSponsoredMessageResultAdsHidden::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportChatSponsoredMessageResultAdsHidden");
    s.store_class_end();
  }
}

reportChatSponsoredMessageResultPremiumRequired::reportChatSponsoredMessageResultPremiumRequired() {
}

const std::int32_t reportChatSponsoredMessageResultPremiumRequired::ID;

void reportChatSponsoredMessageResultPremiumRequired::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportChatSponsoredMessageResultPremiumRequired");
    s.store_class_end();
  }
}

reportOption::reportOption()
  : id_()
  , text_()
{}

reportOption::reportOption(bytes const &id_, string const &text_)
  : id_(std::move(id_))
  , text_(text_)
{}

const std::int32_t reportOption::ID;

void reportOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportOption");
    s.store_bytes_field("id", id_);
    s.store_field("text", text_);
    s.store_class_end();
  }
}

reportReasonSpam::reportReasonSpam() {
}

const std::int32_t reportReasonSpam::ID;

void reportReasonSpam::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportReasonSpam");
    s.store_class_end();
  }
}

reportReasonViolence::reportReasonViolence() {
}

const std::int32_t reportReasonViolence::ID;

void reportReasonViolence::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportReasonViolence");
    s.store_class_end();
  }
}

reportReasonPornography::reportReasonPornography() {
}

const std::int32_t reportReasonPornography::ID;

void reportReasonPornography::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportReasonPornography");
    s.store_class_end();
  }
}

reportReasonChildAbuse::reportReasonChildAbuse() {
}

const std::int32_t reportReasonChildAbuse::ID;

void reportReasonChildAbuse::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportReasonChildAbuse");
    s.store_class_end();
  }
}

reportReasonCopyright::reportReasonCopyright() {
}

const std::int32_t reportReasonCopyright::ID;

void reportReasonCopyright::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportReasonCopyright");
    s.store_class_end();
  }
}

reportReasonUnrelatedLocation::reportReasonUnrelatedLocation() {
}

const std::int32_t reportReasonUnrelatedLocation::ID;

void reportReasonUnrelatedLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportReasonUnrelatedLocation");
    s.store_class_end();
  }
}

reportReasonFake::reportReasonFake() {
}

const std::int32_t reportReasonFake::ID;

void reportReasonFake::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportReasonFake");
    s.store_class_end();
  }
}

reportReasonIllegalDrugs::reportReasonIllegalDrugs() {
}

const std::int32_t reportReasonIllegalDrugs::ID;

void reportReasonIllegalDrugs::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportReasonIllegalDrugs");
    s.store_class_end();
  }
}

reportReasonPersonalDetails::reportReasonPersonalDetails() {
}

const std::int32_t reportReasonPersonalDetails::ID;

void reportReasonPersonalDetails::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportReasonPersonalDetails");
    s.store_class_end();
  }
}

reportReasonCustom::reportReasonCustom() {
}

const std::int32_t reportReasonCustom::ID;

void reportReasonCustom::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportReasonCustom");
    s.store_class_end();
  }
}

reportStoryResultOk::reportStoryResultOk() {
}

const std::int32_t reportStoryResultOk::ID;

void reportStoryResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportStoryResultOk");
    s.store_class_end();
  }
}

reportStoryResultOptionRequired::reportStoryResultOptionRequired()
  : title_()
  , options_()
{}

reportStoryResultOptionRequired::reportStoryResultOptionRequired(string const &title_, array<object_ptr<reportOption>> &&options_)
  : title_(title_)
  , options_(std::move(options_))
{}

const std::int32_t reportStoryResultOptionRequired::ID;

void reportStoryResultOptionRequired::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportStoryResultOptionRequired");
    s.store_field("title", title_);
    { s.store_vector_begin("options", options_.size()); for (const auto &_value : options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

reportStoryResultTextRequired::reportStoryResultTextRequired()
  : option_id_()
  , is_optional_()
{}

reportStoryResultTextRequired::reportStoryResultTextRequired(bytes const &option_id_, bool is_optional_)
  : option_id_(std::move(option_id_))
  , is_optional_(is_optional_)
{}

const std::int32_t reportStoryResultTextRequired::ID;

void reportStoryResultTextRequired::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "reportStoryResultTextRequired");
    s.store_bytes_field("option_id", option_id_);
    s.store_field("is_optional", is_optional_);
    s.store_class_end();
  }
}

resendCodeReasonUserRequest::resendCodeReasonUserRequest() {
}

const std::int32_t resendCodeReasonUserRequest::ID;

void resendCodeReasonUserRequest::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "resendCodeReasonUserRequest");
    s.store_class_end();
  }
}

resendCodeReasonVerificationFailed::resendCodeReasonVerificationFailed()
  : error_message_()
{}

resendCodeReasonVerificationFailed::resendCodeReasonVerificationFailed(string const &error_message_)
  : error_message_(error_message_)
{}

const std::int32_t resendCodeReasonVerificationFailed::ID;

void resendCodeReasonVerificationFailed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "resendCodeReasonVerificationFailed");
    s.store_field("error_message", error_message_);
    s.store_class_end();
  }
}

resetPasswordResultOk::resetPasswordResultOk() {
}

const std::int32_t resetPasswordResultOk::ID;

void resetPasswordResultOk::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "resetPasswordResultOk");
    s.store_class_end();
  }
}

resetPasswordResultPending::resetPasswordResultPending()
  : pending_reset_date_()
{}

resetPasswordResultPending::resetPasswordResultPending(int32 pending_reset_date_)
  : pending_reset_date_(pending_reset_date_)
{}

const std::int32_t resetPasswordResultPending::ID;

void resetPasswordResultPending::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "resetPasswordResultPending");
    s.store_field("pending_reset_date", pending_reset_date_);
    s.store_class_end();
  }
}

resetPasswordResultDeclined::resetPasswordResultDeclined()
  : retry_date_()
{}

resetPasswordResultDeclined::resetPasswordResultDeclined(int32 retry_date_)
  : retry_date_(retry_date_)
{}

const std::int32_t resetPasswordResultDeclined::ID;

void resetPasswordResultDeclined::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "resetPasswordResultDeclined");
    s.store_field("retry_date", retry_date_);
    s.store_class_end();
  }
}

revenueWithdrawalStatePending::revenueWithdrawalStatePending() {
}

const std::int32_t revenueWithdrawalStatePending::ID;

void revenueWithdrawalStatePending::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "revenueWithdrawalStatePending");
    s.store_class_end();
  }
}

revenueWithdrawalStateSucceeded::revenueWithdrawalStateSucceeded()
  : date_()
  , url_()
{}

revenueWithdrawalStateSucceeded::revenueWithdrawalStateSucceeded(int32 date_, string const &url_)
  : date_(date_)
  , url_(url_)
{}

const std::int32_t revenueWithdrawalStateSucceeded::ID;

void revenueWithdrawalStateSucceeded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "revenueWithdrawalStateSucceeded");
    s.store_field("date", date_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

revenueWithdrawalStateFailed::revenueWithdrawalStateFailed() {
}

const std::int32_t revenueWithdrawalStateFailed::ID;

void revenueWithdrawalStateFailed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "revenueWithdrawalStateFailed");
    s.store_class_end();
  }
}

richTextPlain::richTextPlain()
  : text_()
{}

richTextPlain::richTextPlain(string const &text_)
  : text_(text_)
{}

const std::int32_t richTextPlain::ID;

void richTextPlain::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextPlain");
    s.store_field("text", text_);
    s.store_class_end();
  }
}

richTextBold::richTextBold()
  : text_()
{}

richTextBold::richTextBold(object_ptr<RichText> &&text_)
  : text_(std::move(text_))
{}

const std::int32_t richTextBold::ID;

void richTextBold::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextBold");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

richTextItalic::richTextItalic()
  : text_()
{}

richTextItalic::richTextItalic(object_ptr<RichText> &&text_)
  : text_(std::move(text_))
{}

const std::int32_t richTextItalic::ID;

void richTextItalic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextItalic");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

richTextUnderline::richTextUnderline()
  : text_()
{}

richTextUnderline::richTextUnderline(object_ptr<RichText> &&text_)
  : text_(std::move(text_))
{}

const std::int32_t richTextUnderline::ID;

void richTextUnderline::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextUnderline");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

richTextStrikethrough::richTextStrikethrough()
  : text_()
{}

richTextStrikethrough::richTextStrikethrough(object_ptr<RichText> &&text_)
  : text_(std::move(text_))
{}

const std::int32_t richTextStrikethrough::ID;

void richTextStrikethrough::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextStrikethrough");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

richTextFixed::richTextFixed()
  : text_()
{}

richTextFixed::richTextFixed(object_ptr<RichText> &&text_)
  : text_(std::move(text_))
{}

const std::int32_t richTextFixed::ID;

void richTextFixed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextFixed");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

richTextUrl::richTextUrl()
  : text_()
  , url_()
  , is_cached_()
{}

richTextUrl::richTextUrl(object_ptr<RichText> &&text_, string const &url_, bool is_cached_)
  : text_(std::move(text_))
  , url_(url_)
  , is_cached_(is_cached_)
{}

const std::int32_t richTextUrl::ID;

void richTextUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextUrl");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("url", url_);
    s.store_field("is_cached", is_cached_);
    s.store_class_end();
  }
}

richTextEmailAddress::richTextEmailAddress()
  : text_()
  , email_address_()
{}

richTextEmailAddress::richTextEmailAddress(object_ptr<RichText> &&text_, string const &email_address_)
  : text_(std::move(text_))
  , email_address_(email_address_)
{}

const std::int32_t richTextEmailAddress::ID;

void richTextEmailAddress::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextEmailAddress");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("email_address", email_address_);
    s.store_class_end();
  }
}

richTextSubscript::richTextSubscript()
  : text_()
{}

richTextSubscript::richTextSubscript(object_ptr<RichText> &&text_)
  : text_(std::move(text_))
{}

const std::int32_t richTextSubscript::ID;

void richTextSubscript::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextSubscript");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

richTextSuperscript::richTextSuperscript()
  : text_()
{}

richTextSuperscript::richTextSuperscript(object_ptr<RichText> &&text_)
  : text_(std::move(text_))
{}

const std::int32_t richTextSuperscript::ID;

void richTextSuperscript::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextSuperscript");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

richTextMarked::richTextMarked()
  : text_()
{}

richTextMarked::richTextMarked(object_ptr<RichText> &&text_)
  : text_(std::move(text_))
{}

const std::int32_t richTextMarked::ID;

void richTextMarked::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextMarked");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

richTextPhoneNumber::richTextPhoneNumber()
  : text_()
  , phone_number_()
{}

richTextPhoneNumber::richTextPhoneNumber(object_ptr<RichText> &&text_, string const &phone_number_)
  : text_(std::move(text_))
  , phone_number_(phone_number_)
{}

const std::int32_t richTextPhoneNumber::ID;

void richTextPhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextPhoneNumber");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("phone_number", phone_number_);
    s.store_class_end();
  }
}

richTextIcon::richTextIcon()
  : document_()
  , width_()
  , height_()
{}

richTextIcon::richTextIcon(object_ptr<document> &&document_, int32 width_, int32 height_)
  : document_(std::move(document_))
  , width_(width_)
  , height_(height_)
{}

const std::int32_t richTextIcon::ID;

void richTextIcon::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextIcon");
    s.store_object_field("document", static_cast<const BaseObject *>(document_.get()));
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_class_end();
  }
}

richTextReference::richTextReference()
  : text_()
  , anchor_name_()
  , url_()
{}

richTextReference::richTextReference(object_ptr<RichText> &&text_, string const &anchor_name_, string const &url_)
  : text_(std::move(text_))
  , anchor_name_(anchor_name_)
  , url_(url_)
{}

const std::int32_t richTextReference::ID;

void richTextReference::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextReference");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("anchor_name", anchor_name_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

richTextAnchor::richTextAnchor()
  : name_()
{}

richTextAnchor::richTextAnchor(string const &name_)
  : name_(name_)
{}

const std::int32_t richTextAnchor::ID;

void richTextAnchor::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextAnchor");
    s.store_field("name", name_);
    s.store_class_end();
  }
}

richTextAnchorLink::richTextAnchorLink()
  : text_()
  , anchor_name_()
  , url_()
{}

richTextAnchorLink::richTextAnchorLink(object_ptr<RichText> &&text_, string const &anchor_name_, string const &url_)
  : text_(std::move(text_))
  , anchor_name_(anchor_name_)
  , url_(url_)
{}

const std::int32_t richTextAnchorLink::ID;

void richTextAnchorLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTextAnchorLink");
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_field("anchor_name", anchor_name_);
    s.store_field("url", url_);
    s.store_class_end();
  }
}

richTexts::richTexts()
  : texts_()
{}

richTexts::richTexts(array<object_ptr<RichText>> &&texts_)
  : texts_(std::move(texts_))
{}

const std::int32_t richTexts::ID;

void richTexts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "richTexts");
    { s.store_vector_begin("texts", texts_.size()); for (const auto &_value : texts_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

rtmpUrl::rtmpUrl()
  : url_()
  , stream_key_()
{}

rtmpUrl::rtmpUrl(string const &url_, string const &stream_key_)
  : url_(url_)
  , stream_key_(stream_key_)
{}

const std::int32_t rtmpUrl::ID;

void rtmpUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "rtmpUrl");
    s.store_field("url", url_);
    s.store_field("stream_key", stream_key_);
    s.store_class_end();
  }
}

savedCredentials::savedCredentials()
  : id_()
  , title_()
{}

savedCredentials::savedCredentials(string const &id_, string const &title_)
  : id_(id_)
  , title_(title_)
{}

const std::int32_t savedCredentials::ID;

void savedCredentials::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "savedCredentials");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_class_end();
  }
}

savedMessagesTag::savedMessagesTag()
  : tag_()
  , label_()
  , count_()
{}

savedMessagesTag::savedMessagesTag(object_ptr<ReactionType> &&tag_, string const &label_, int32 count_)
  : tag_(std::move(tag_))
  , label_(label_)
  , count_(count_)
{}

const std::int32_t savedMessagesTag::ID;

void savedMessagesTag::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "savedMessagesTag");
    s.store_object_field("tag", static_cast<const BaseObject *>(tag_.get()));
    s.store_field("label", label_);
    s.store_field("count", count_);
    s.store_class_end();
  }
}

savedMessagesTags::savedMessagesTags()
  : tags_()
{}

savedMessagesTags::savedMessagesTags(array<object_ptr<savedMessagesTag>> &&tags_)
  : tags_(std::move(tags_))
{}

const std::int32_t savedMessagesTags::ID;

void savedMessagesTags::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "savedMessagesTags");
    { s.store_vector_begin("tags", tags_.size()); for (const auto &_value : tags_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

savedMessagesTopic::savedMessagesTopic()
  : id_()
  , type_()
  , is_pinned_()
  , order_()
  , last_message_()
  , draft_message_()
{}

savedMessagesTopic::savedMessagesTopic(int53 id_, object_ptr<SavedMessagesTopicType> &&type_, bool is_pinned_, int64 order_, object_ptr<message> &&last_message_, object_ptr<draftMessage> &&draft_message_)
  : id_(id_)
  , type_(std::move(type_))
  , is_pinned_(is_pinned_)
  , order_(order_)
  , last_message_(std::move(last_message_))
  , draft_message_(std::move(draft_message_))
{}

const std::int32_t savedMessagesTopic::ID;

void savedMessagesTopic::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "savedMessagesTopic");
    s.store_field("id", id_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("is_pinned", is_pinned_);
    s.store_field("order", order_);
    s.store_object_field("last_message", static_cast<const BaseObject *>(last_message_.get()));
    s.store_object_field("draft_message", static_cast<const BaseObject *>(draft_message_.get()));
    s.store_class_end();
  }
}

savedMessagesTopicTypeMyNotes::savedMessagesTopicTypeMyNotes() {
}

const std::int32_t savedMessagesTopicTypeMyNotes::ID;

void savedMessagesTopicTypeMyNotes::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "savedMessagesTopicTypeMyNotes");
    s.store_class_end();
  }
}

savedMessagesTopicTypeAuthorHidden::savedMessagesTopicTypeAuthorHidden() {
}

const std::int32_t savedMessagesTopicTypeAuthorHidden::ID;

void savedMessagesTopicTypeAuthorHidden::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "savedMessagesTopicTypeAuthorHidden");
    s.store_class_end();
  }
}

savedMessagesTopicTypeSavedFromChat::savedMessagesTopicTypeSavedFromChat()
  : chat_id_()
{}

savedMessagesTopicTypeSavedFromChat::savedMessagesTopicTypeSavedFromChat(int53 chat_id_)
  : chat_id_(chat_id_)
{}

const std::int32_t savedMessagesTopicTypeSavedFromChat::ID;

void savedMessagesTopicTypeSavedFromChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "savedMessagesTopicTypeSavedFromChat");
    s.store_field("chat_id", chat_id_);
    s.store_class_end();
  }
}

scopeAutosaveSettings::scopeAutosaveSettings()
  : autosave_photos_()
  , autosave_videos_()
  , max_video_file_size_()
{}

scopeAutosaveSettings::scopeAutosaveSettings(bool autosave_photos_, bool autosave_videos_, int53 max_video_file_size_)
  : autosave_photos_(autosave_photos_)
  , autosave_videos_(autosave_videos_)
  , max_video_file_size_(max_video_file_size_)
{}

const std::int32_t scopeAutosaveSettings::ID;

void scopeAutosaveSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "scopeAutosaveSettings");
    s.store_field("autosave_photos", autosave_photos_);
    s.store_field("autosave_videos", autosave_videos_);
    s.store_field("max_video_file_size", max_video_file_size_);
    s.store_class_end();
  }
}

scopeNotificationSettings::scopeNotificationSettings()
  : mute_for_()
  , sound_id_()
  , show_preview_()
  , use_default_mute_stories_()
  , mute_stories_()
  , story_sound_id_()
  , show_story_sender_()
  , disable_pinned_message_notifications_()
  , disable_mention_notifications_()
{}

scopeNotificationSettings::scopeNotificationSettings(int32 mute_for_, int64 sound_id_, bool show_preview_, bool use_default_mute_stories_, bool mute_stories_, int64 story_sound_id_, bool show_story_sender_, bool disable_pinned_message_notifications_, bool disable_mention_notifications_)
  : mute_for_(mute_for_)
  , sound_id_(sound_id_)
  , show_preview_(show_preview_)
  , use_default_mute_stories_(use_default_mute_stories_)
  , mute_stories_(mute_stories_)
  , story_sound_id_(story_sound_id_)
  , show_story_sender_(show_story_sender_)
  , disable_pinned_message_notifications_(disable_pinned_message_notifications_)
  , disable_mention_notifications_(disable_mention_notifications_)
{}

const std::int32_t scopeNotificationSettings::ID;

void scopeNotificationSettings::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "scopeNotificationSettings");
    s.store_field("mute_for", mute_for_);
    s.store_field("sound_id", sound_id_);
    s.store_field("show_preview", show_preview_);
    s.store_field("use_default_mute_stories", use_default_mute_stories_);
    s.store_field("mute_stories", mute_stories_);
    s.store_field("story_sound_id", story_sound_id_);
    s.store_field("show_story_sender", show_story_sender_);
    s.store_field("disable_pinned_message_notifications", disable_pinned_message_notifications_);
    s.store_field("disable_mention_notifications", disable_mention_notifications_);
    s.store_class_end();
  }
}

searchMessagesChatTypeFilterPrivate::searchMessagesChatTypeFilterPrivate() {
}

const std::int32_t searchMessagesChatTypeFilterPrivate::ID;

void searchMessagesChatTypeFilterPrivate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesChatTypeFilterPrivate");
    s.store_class_end();
  }
}

searchMessagesChatTypeFilterGroup::searchMessagesChatTypeFilterGroup() {
}

const std::int32_t searchMessagesChatTypeFilterGroup::ID;

void searchMessagesChatTypeFilterGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesChatTypeFilterGroup");
    s.store_class_end();
  }
}

searchMessagesChatTypeFilterChannel::searchMessagesChatTypeFilterChannel() {
}

const std::int32_t searchMessagesChatTypeFilterChannel::ID;

void searchMessagesChatTypeFilterChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesChatTypeFilterChannel");
    s.store_class_end();
  }
}

searchMessagesFilterEmpty::searchMessagesFilterEmpty() {
}

const std::int32_t searchMessagesFilterEmpty::ID;

void searchMessagesFilterEmpty::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterEmpty");
    s.store_class_end();
  }
}

searchMessagesFilterAnimation::searchMessagesFilterAnimation() {
}

const std::int32_t searchMessagesFilterAnimation::ID;

void searchMessagesFilterAnimation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterAnimation");
    s.store_class_end();
  }
}

searchMessagesFilterAudio::searchMessagesFilterAudio() {
}

const std::int32_t searchMessagesFilterAudio::ID;

void searchMessagesFilterAudio::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterAudio");
    s.store_class_end();
  }
}

searchMessagesFilterDocument::searchMessagesFilterDocument() {
}

const std::int32_t searchMessagesFilterDocument::ID;

void searchMessagesFilterDocument::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterDocument");
    s.store_class_end();
  }
}

searchMessagesFilterPhoto::searchMessagesFilterPhoto() {
}

const std::int32_t searchMessagesFilterPhoto::ID;

void searchMessagesFilterPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterPhoto");
    s.store_class_end();
  }
}

searchMessagesFilterVideo::searchMessagesFilterVideo() {
}

const std::int32_t searchMessagesFilterVideo::ID;

void searchMessagesFilterVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterVideo");
    s.store_class_end();
  }
}

searchMessagesFilterVoiceNote::searchMessagesFilterVoiceNote() {
}

const std::int32_t searchMessagesFilterVoiceNote::ID;

void searchMessagesFilterVoiceNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterVoiceNote");
    s.store_class_end();
  }
}

searchMessagesFilterPhotoAndVideo::searchMessagesFilterPhotoAndVideo() {
}

const std::int32_t searchMessagesFilterPhotoAndVideo::ID;

void searchMessagesFilterPhotoAndVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterPhotoAndVideo");
    s.store_class_end();
  }
}

searchMessagesFilterUrl::searchMessagesFilterUrl() {
}

const std::int32_t searchMessagesFilterUrl::ID;

void searchMessagesFilterUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterUrl");
    s.store_class_end();
  }
}

searchMessagesFilterChatPhoto::searchMessagesFilterChatPhoto() {
}

const std::int32_t searchMessagesFilterChatPhoto::ID;

void searchMessagesFilterChatPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterChatPhoto");
    s.store_class_end();
  }
}

searchMessagesFilterVideoNote::searchMessagesFilterVideoNote() {
}

const std::int32_t searchMessagesFilterVideoNote::ID;

void searchMessagesFilterVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterVideoNote");
    s.store_class_end();
  }
}

searchMessagesFilterVoiceAndVideoNote::searchMessagesFilterVoiceAndVideoNote() {
}

const std::int32_t searchMessagesFilterVoiceAndVideoNote::ID;

void searchMessagesFilterVoiceAndVideoNote::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterVoiceAndVideoNote");
    s.store_class_end();
  }
}

searchMessagesFilterMention::searchMessagesFilterMention() {
}

const std::int32_t searchMessagesFilterMention::ID;

void searchMessagesFilterMention::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterMention");
    s.store_class_end();
  }
}

searchMessagesFilterUnreadMention::searchMessagesFilterUnreadMention() {
}

const std::int32_t searchMessagesFilterUnreadMention::ID;

void searchMessagesFilterUnreadMention::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterUnreadMention");
    s.store_class_end();
  }
}

searchMessagesFilterUnreadReaction::searchMessagesFilterUnreadReaction() {
}

const std::int32_t searchMessagesFilterUnreadReaction::ID;

void searchMessagesFilterUnreadReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterUnreadReaction");
    s.store_class_end();
  }
}

searchMessagesFilterFailedToSend::searchMessagesFilterFailedToSend() {
}

const std::int32_t searchMessagesFilterFailedToSend::ID;

void searchMessagesFilterFailedToSend::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterFailedToSend");
    s.store_class_end();
  }
}

searchMessagesFilterPinned::searchMessagesFilterPinned() {
}

const std::int32_t searchMessagesFilterPinned::ID;

void searchMessagesFilterPinned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "searchMessagesFilterPinned");
    s.store_class_end();
  }
}

seconds::seconds()
  : seconds_()
{}

seconds::seconds(double seconds_)
  : seconds_(seconds_)
{}

const std::int32_t seconds::ID;

void seconds::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "seconds");
    s.store_field("seconds", seconds_);
    s.store_class_end();
  }
}

secretChat::secretChat()
  : id_()
  , user_id_()
  , state_()
  , is_outbound_()
  , key_hash_()
  , layer_()
{}

secretChat::secretChat(int32 id_, int53 user_id_, object_ptr<SecretChatState> &&state_, bool is_outbound_, bytes const &key_hash_, int32 layer_)
  : id_(id_)
  , user_id_(user_id_)
  , state_(std::move(state_))
  , is_outbound_(is_outbound_)
  , key_hash_(std::move(key_hash_))
  , layer_(layer_)
{}

const std::int32_t secretChat::ID;

void secretChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "secretChat");
    s.store_field("id", id_);
    s.store_field("user_id", user_id_);
    s.store_object_field("state", static_cast<const BaseObject *>(state_.get()));
    s.store_field("is_outbound", is_outbound_);
    s.store_bytes_field("key_hash", key_hash_);
    s.store_field("layer", layer_);
    s.store_class_end();
  }
}

secretChatStatePending::secretChatStatePending() {
}

const std::int32_t secretChatStatePending::ID;

void secretChatStatePending::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "secretChatStatePending");
    s.store_class_end();
  }
}

secretChatStateReady::secretChatStateReady() {
}

const std::int32_t secretChatStateReady::ID;

void secretChatStateReady::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "secretChatStateReady");
    s.store_class_end();
  }
}

secretChatStateClosed::secretChatStateClosed() {
}

const std::int32_t secretChatStateClosed::ID;

void secretChatStateClosed::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "secretChatStateClosed");
    s.store_class_end();
  }
}

sentGiftRegular::sentGiftRegular()
  : gift_()
{}

sentGiftRegular::sentGiftRegular(object_ptr<gift> &&gift_)
  : gift_(std::move(gift_))
{}

const std::int32_t sentGiftRegular::ID;

void sentGiftRegular::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sentGiftRegular");
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_class_end();
  }
}

sentGiftUpgraded::sentGiftUpgraded()
  : gift_()
{}

sentGiftUpgraded::sentGiftUpgraded(object_ptr<upgradedGift> &&gift_)
  : gift_(std::move(gift_))
{}

const std::int32_t sentGiftUpgraded::ID;

void sentGiftUpgraded::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sentGiftUpgraded");
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_class_end();
  }
}

sentWebAppMessage::sentWebAppMessage()
  : inline_message_id_()
{}

sentWebAppMessage::sentWebAppMessage(string const &inline_message_id_)
  : inline_message_id_(inline_message_id_)
{}

const std::int32_t sentWebAppMessage::ID;

void sentWebAppMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sentWebAppMessage");
    s.store_field("inline_message_id", inline_message_id_);
    s.store_class_end();
  }
}

session::session()
  : id_()
  , is_current_()
  , is_password_pending_()
  , is_unconfirmed_()
  , can_accept_secret_chats_()
  , can_accept_calls_()
  , type_()
  , api_id_()
  , application_name_()
  , application_version_()
  , is_official_application_()
  , device_model_()
  , platform_()
  , system_version_()
  , log_in_date_()
  , last_active_date_()
  , ip_address_()
  , location_()
{}

session::session(int64 id_, bool is_current_, bool is_password_pending_, bool is_unconfirmed_, bool can_accept_secret_chats_, bool can_accept_calls_, object_ptr<SessionType> &&type_, int32 api_id_, string const &application_name_, string const &application_version_, bool is_official_application_, string const &device_model_, string const &platform_, string const &system_version_, int32 log_in_date_, int32 last_active_date_, string const &ip_address_, string const &location_)
  : id_(id_)
  , is_current_(is_current_)
  , is_password_pending_(is_password_pending_)
  , is_unconfirmed_(is_unconfirmed_)
  , can_accept_secret_chats_(can_accept_secret_chats_)
  , can_accept_calls_(can_accept_calls_)
  , type_(std::move(type_))
  , api_id_(api_id_)
  , application_name_(application_name_)
  , application_version_(application_version_)
  , is_official_application_(is_official_application_)
  , device_model_(device_model_)
  , platform_(platform_)
  , system_version_(system_version_)
  , log_in_date_(log_in_date_)
  , last_active_date_(last_active_date_)
  , ip_address_(ip_address_)
  , location_(location_)
{}

const std::int32_t session::ID;

void session::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "session");
    s.store_field("id", id_);
    s.store_field("is_current", is_current_);
    s.store_field("is_password_pending", is_password_pending_);
    s.store_field("is_unconfirmed", is_unconfirmed_);
    s.store_field("can_accept_secret_chats", can_accept_secret_chats_);
    s.store_field("can_accept_calls", can_accept_calls_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_field("api_id", api_id_);
    s.store_field("application_name", application_name_);
    s.store_field("application_version", application_version_);
    s.store_field("is_official_application", is_official_application_);
    s.store_field("device_model", device_model_);
    s.store_field("platform", platform_);
    s.store_field("system_version", system_version_);
    s.store_field("log_in_date", log_in_date_);
    s.store_field("last_active_date", last_active_date_);
    s.store_field("ip_address", ip_address_);
    s.store_field("location", location_);
    s.store_class_end();
  }
}

sessionTypeAndroid::sessionTypeAndroid() {
}

const std::int32_t sessionTypeAndroid::ID;

void sessionTypeAndroid::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeAndroid");
    s.store_class_end();
  }
}

sessionTypeApple::sessionTypeApple() {
}

const std::int32_t sessionTypeApple::ID;

void sessionTypeApple::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeApple");
    s.store_class_end();
  }
}

sessionTypeBrave::sessionTypeBrave() {
}

const std::int32_t sessionTypeBrave::ID;

void sessionTypeBrave::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeBrave");
    s.store_class_end();
  }
}

sessionTypeChrome::sessionTypeChrome() {
}

const std::int32_t sessionTypeChrome::ID;

void sessionTypeChrome::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeChrome");
    s.store_class_end();
  }
}

sessionTypeEdge::sessionTypeEdge() {
}

const std::int32_t sessionTypeEdge::ID;

void sessionTypeEdge::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeEdge");
    s.store_class_end();
  }
}

sessionTypeFirefox::sessionTypeFirefox() {
}

const std::int32_t sessionTypeFirefox::ID;

void sessionTypeFirefox::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeFirefox");
    s.store_class_end();
  }
}

sessionTypeIpad::sessionTypeIpad() {
}

const std::int32_t sessionTypeIpad::ID;

void sessionTypeIpad::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeIpad");
    s.store_class_end();
  }
}

sessionTypeIphone::sessionTypeIphone() {
}

const std::int32_t sessionTypeIphone::ID;

void sessionTypeIphone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeIphone");
    s.store_class_end();
  }
}

sessionTypeLinux::sessionTypeLinux() {
}

const std::int32_t sessionTypeLinux::ID;

void sessionTypeLinux::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeLinux");
    s.store_class_end();
  }
}

sessionTypeMac::sessionTypeMac() {
}

const std::int32_t sessionTypeMac::ID;

void sessionTypeMac::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeMac");
    s.store_class_end();
  }
}

sessionTypeOpera::sessionTypeOpera() {
}

const std::int32_t sessionTypeOpera::ID;

void sessionTypeOpera::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeOpera");
    s.store_class_end();
  }
}

sessionTypeSafari::sessionTypeSafari() {
}

const std::int32_t sessionTypeSafari::ID;

void sessionTypeSafari::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeSafari");
    s.store_class_end();
  }
}

sessionTypeUbuntu::sessionTypeUbuntu() {
}

const std::int32_t sessionTypeUbuntu::ID;

void sessionTypeUbuntu::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeUbuntu");
    s.store_class_end();
  }
}

sessionTypeUnknown::sessionTypeUnknown() {
}

const std::int32_t sessionTypeUnknown::ID;

void sessionTypeUnknown::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeUnknown");
    s.store_class_end();
  }
}

sessionTypeVivaldi::sessionTypeVivaldi() {
}

const std::int32_t sessionTypeVivaldi::ID;

void sessionTypeVivaldi::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeVivaldi");
    s.store_class_end();
  }
}

sessionTypeWindows::sessionTypeWindows() {
}

const std::int32_t sessionTypeWindows::ID;

void sessionTypeWindows::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeWindows");
    s.store_class_end();
  }
}

sessionTypeXbox::sessionTypeXbox() {
}

const std::int32_t sessionTypeXbox::ID;

void sessionTypeXbox::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessionTypeXbox");
    s.store_class_end();
  }
}

sessions::sessions()
  : sessions_()
  , inactive_session_ttl_days_()
{}

sessions::sessions(array<object_ptr<session>> &&sessions_, int32 inactive_session_ttl_days_)
  : sessions_(std::move(sessions_))
  , inactive_session_ttl_days_(inactive_session_ttl_days_)
{}

const std::int32_t sessions::ID;

void sessions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sessions");
    { s.store_vector_begin("sessions", sessions_.size()); for (const auto &_value : sessions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("inactive_session_ttl_days", inactive_session_ttl_days_);
    s.store_class_end();
  }
}

sharedChat::sharedChat()
  : chat_id_()
  , title_()
  , username_()
  , photo_()
{}

sharedChat::sharedChat(int53 chat_id_, string const &title_, string const &username_, object_ptr<photo> &&photo_)
  : chat_id_(chat_id_)
  , title_(title_)
  , username_(username_)
  , photo_(std::move(photo_))
{}

const std::int32_t sharedChat::ID;

void sharedChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sharedChat");
    s.store_field("chat_id", chat_id_);
    s.store_field("title", title_);
    s.store_field("username", username_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

sharedUser::sharedUser()
  : user_id_()
  , first_name_()
  , last_name_()
  , username_()
  , photo_()
{}

sharedUser::sharedUser(int53 user_id_, string const &first_name_, string const &last_name_, string const &username_, object_ptr<photo> &&photo_)
  : user_id_(user_id_)
  , first_name_(first_name_)
  , last_name_(last_name_)
  , username_(username_)
  , photo_(std::move(photo_))
{}

const std::int32_t sharedUser::ID;

void sharedUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sharedUser");
    s.store_field("user_id", user_id_);
    s.store_field("first_name", first_name_);
    s.store_field("last_name", last_name_);
    s.store_field("username", username_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

shippingOption::shippingOption()
  : id_()
  , title_()
  , price_parts_()
{}

shippingOption::shippingOption(string const &id_, string const &title_, array<object_ptr<labeledPricePart>> &&price_parts_)
  : id_(id_)
  , title_(title_)
  , price_parts_(std::move(price_parts_))
{}

const std::int32_t shippingOption::ID;

void shippingOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "shippingOption");
    s.store_field("id", id_);
    s.store_field("title", title_);
    { s.store_vector_begin("price_parts", price_parts_.size()); for (const auto &_value : price_parts_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

speechRecognitionResultPending::speechRecognitionResultPending()
  : partial_text_()
{}

speechRecognitionResultPending::speechRecognitionResultPending(string const &partial_text_)
  : partial_text_(partial_text_)
{}

const std::int32_t speechRecognitionResultPending::ID;

void speechRecognitionResultPending::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "speechRecognitionResultPending");
    s.store_field("partial_text", partial_text_);
    s.store_class_end();
  }
}

speechRecognitionResultText::speechRecognitionResultText()
  : text_()
{}

speechRecognitionResultText::speechRecognitionResultText(string const &text_)
  : text_(text_)
{}

const std::int32_t speechRecognitionResultText::ID;

void speechRecognitionResultText::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "speechRecognitionResultText");
    s.store_field("text", text_);
    s.store_class_end();
  }
}

speechRecognitionResultError::speechRecognitionResultError()
  : error_()
{}

speechRecognitionResultError::speechRecognitionResultError(object_ptr<error> &&error_)
  : error_(std::move(error_))
{}

const std::int32_t speechRecognitionResultError::ID;

void speechRecognitionResultError::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "speechRecognitionResultError");
    s.store_object_field("error", static_cast<const BaseObject *>(error_.get()));
    s.store_class_end();
  }
}

sponsoredMessage::sponsoredMessage()
  : message_id_()
  , is_recommended_()
  , can_be_reported_()
  , content_()
  , sponsor_()
  , title_()
  , button_text_()
  , accent_color_id_()
  , background_custom_emoji_id_()
  , additional_info_()
{}

sponsoredMessage::sponsoredMessage(int53 message_id_, bool is_recommended_, bool can_be_reported_, object_ptr<MessageContent> &&content_, object_ptr<messageSponsor> &&sponsor_, string const &title_, string const &button_text_, int32 accent_color_id_, int64 background_custom_emoji_id_, string const &additional_info_)
  : message_id_(message_id_)
  , is_recommended_(is_recommended_)
  , can_be_reported_(can_be_reported_)
  , content_(std::move(content_))
  , sponsor_(std::move(sponsor_))
  , title_(title_)
  , button_text_(button_text_)
  , accent_color_id_(accent_color_id_)
  , background_custom_emoji_id_(background_custom_emoji_id_)
  , additional_info_(additional_info_)
{}

const std::int32_t sponsoredMessage::ID;

void sponsoredMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sponsoredMessage");
    s.store_field("message_id", message_id_);
    s.store_field("is_recommended", is_recommended_);
    s.store_field("can_be_reported", can_be_reported_);
    s.store_object_field("content", static_cast<const BaseObject *>(content_.get()));
    s.store_object_field("sponsor", static_cast<const BaseObject *>(sponsor_.get()));
    s.store_field("title", title_);
    s.store_field("button_text", button_text_);
    s.store_field("accent_color_id", accent_color_id_);
    s.store_field("background_custom_emoji_id", background_custom_emoji_id_);
    s.store_field("additional_info", additional_info_);
    s.store_class_end();
  }
}

sponsoredMessages::sponsoredMessages()
  : messages_()
  , messages_between_()
{}

sponsoredMessages::sponsoredMessages(array<object_ptr<sponsoredMessage>> &&messages_, int32 messages_between_)
  : messages_(std::move(messages_))
  , messages_between_(messages_between_)
{}

const std::int32_t sponsoredMessages::ID;

void sponsoredMessages::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sponsoredMessages");
    { s.store_vector_begin("messages", messages_.size()); for (const auto &_value : messages_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("messages_between", messages_between_);
    s.store_class_end();
  }
}

starAmount::starAmount()
  : star_count_()
  , nanostar_count_()
{}

starAmount::starAmount(int53 star_count_, int32 nanostar_count_)
  : star_count_(star_count_)
  , nanostar_count_(nanostar_count_)
{}

const std::int32_t starAmount::ID;

void starAmount::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starAmount");
    s.store_field("star_count", star_count_);
    s.store_field("nanostar_count", nanostar_count_);
    s.store_class_end();
  }
}

starGiveawayPaymentOption::starGiveawayPaymentOption()
  : currency_()
  , amount_()
  , star_count_()
  , store_product_id_()
  , yearly_boost_count_()
  , winner_options_()
  , is_default_()
  , is_additional_()
{}

starGiveawayPaymentOption::starGiveawayPaymentOption(string const &currency_, int53 amount_, int53 star_count_, string const &store_product_id_, int32 yearly_boost_count_, array<object_ptr<starGiveawayWinnerOption>> &&winner_options_, bool is_default_, bool is_additional_)
  : currency_(currency_)
  , amount_(amount_)
  , star_count_(star_count_)
  , store_product_id_(store_product_id_)
  , yearly_boost_count_(yearly_boost_count_)
  , winner_options_(std::move(winner_options_))
  , is_default_(is_default_)
  , is_additional_(is_additional_)
{}

const std::int32_t starGiveawayPaymentOption::ID;

void starGiveawayPaymentOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starGiveawayPaymentOption");
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("star_count", star_count_);
    s.store_field("store_product_id", store_product_id_);
    s.store_field("yearly_boost_count", yearly_boost_count_);
    { s.store_vector_begin("winner_options", winner_options_.size()); for (const auto &_value : winner_options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("is_default", is_default_);
    s.store_field("is_additional", is_additional_);
    s.store_class_end();
  }
}

starGiveawayPaymentOptions::starGiveawayPaymentOptions()
  : options_()
{}

starGiveawayPaymentOptions::starGiveawayPaymentOptions(array<object_ptr<starGiveawayPaymentOption>> &&options_)
  : options_(std::move(options_))
{}

const std::int32_t starGiveawayPaymentOptions::ID;

void starGiveawayPaymentOptions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starGiveawayPaymentOptions");
    { s.store_vector_begin("options", options_.size()); for (const auto &_value : options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

starGiveawayWinnerOption::starGiveawayWinnerOption()
  : winner_count_()
  , won_star_count_()
  , is_default_()
{}

starGiveawayWinnerOption::starGiveawayWinnerOption(int32 winner_count_, int53 won_star_count_, bool is_default_)
  : winner_count_(winner_count_)
  , won_star_count_(won_star_count_)
  , is_default_(is_default_)
{}

const std::int32_t starGiveawayWinnerOption::ID;

void starGiveawayWinnerOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starGiveawayWinnerOption");
    s.store_field("winner_count", winner_count_);
    s.store_field("won_star_count", won_star_count_);
    s.store_field("is_default", is_default_);
    s.store_class_end();
  }
}

starPaymentOption::starPaymentOption()
  : currency_()
  , amount_()
  , star_count_()
  , store_product_id_()
  , is_additional_()
{}

starPaymentOption::starPaymentOption(string const &currency_, int53 amount_, int53 star_count_, string const &store_product_id_, bool is_additional_)
  : currency_(currency_)
  , amount_(amount_)
  , star_count_(star_count_)
  , store_product_id_(store_product_id_)
  , is_additional_(is_additional_)
{}

const std::int32_t starPaymentOption::ID;

void starPaymentOption::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starPaymentOption");
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("star_count", star_count_);
    s.store_field("store_product_id", store_product_id_);
    s.store_field("is_additional", is_additional_);
    s.store_class_end();
  }
}

starPaymentOptions::starPaymentOptions()
  : options_()
{}

starPaymentOptions::starPaymentOptions(array<object_ptr<starPaymentOption>> &&options_)
  : options_(std::move(options_))
{}

const std::int32_t starPaymentOptions::ID;

void starPaymentOptions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starPaymentOptions");
    { s.store_vector_begin("options", options_.size()); for (const auto &_value : options_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

starRevenueStatistics::starRevenueStatistics()
  : revenue_by_day_graph_()
  , status_()
  , usd_rate_()
{}

starRevenueStatistics::starRevenueStatistics(object_ptr<StatisticalGraph> &&revenue_by_day_graph_, object_ptr<starRevenueStatus> &&status_, double usd_rate_)
  : revenue_by_day_graph_(std::move(revenue_by_day_graph_))
  , status_(std::move(status_))
  , usd_rate_(usd_rate_)
{}

const std::int32_t starRevenueStatistics::ID;

void starRevenueStatistics::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starRevenueStatistics");
    s.store_object_field("revenue_by_day_graph", static_cast<const BaseObject *>(revenue_by_day_graph_.get()));
    s.store_object_field("status", static_cast<const BaseObject *>(status_.get()));
    s.store_field("usd_rate", usd_rate_);
    s.store_class_end();
  }
}

starRevenueStatus::starRevenueStatus()
  : total_amount_()
  , current_amount_()
  , available_amount_()
  , withdrawal_enabled_()
  , next_withdrawal_in_()
{}

starRevenueStatus::starRevenueStatus(object_ptr<starAmount> &&total_amount_, object_ptr<starAmount> &&current_amount_, object_ptr<starAmount> &&available_amount_, bool withdrawal_enabled_, int32 next_withdrawal_in_)
  : total_amount_(std::move(total_amount_))
  , current_amount_(std::move(current_amount_))
  , available_amount_(std::move(available_amount_))
  , withdrawal_enabled_(withdrawal_enabled_)
  , next_withdrawal_in_(next_withdrawal_in_)
{}

const std::int32_t starRevenueStatus::ID;

void starRevenueStatus::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starRevenueStatus");
    s.store_object_field("total_amount", static_cast<const BaseObject *>(total_amount_.get()));
    s.store_object_field("current_amount", static_cast<const BaseObject *>(current_amount_.get()));
    s.store_object_field("available_amount", static_cast<const BaseObject *>(available_amount_.get()));
    s.store_field("withdrawal_enabled", withdrawal_enabled_);
    s.store_field("next_withdrawal_in", next_withdrawal_in_);
    s.store_class_end();
  }
}

starSubscription::starSubscription()
  : id_()
  , chat_id_()
  , expiration_date_()
  , is_canceled_()
  , is_expiring_()
  , pricing_()
  , type_()
{}

starSubscription::starSubscription(string const &id_, int53 chat_id_, int32 expiration_date_, bool is_canceled_, bool is_expiring_, object_ptr<starSubscriptionPricing> &&pricing_, object_ptr<StarSubscriptionType> &&type_)
  : id_(id_)
  , chat_id_(chat_id_)
  , expiration_date_(expiration_date_)
  , is_canceled_(is_canceled_)
  , is_expiring_(is_expiring_)
  , pricing_(std::move(pricing_))
  , type_(std::move(type_))
{}

const std::int32_t starSubscription::ID;

void starSubscription::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starSubscription");
    s.store_field("id", id_);
    s.store_field("chat_id", chat_id_);
    s.store_field("expiration_date", expiration_date_);
    s.store_field("is_canceled", is_canceled_);
    s.store_field("is_expiring", is_expiring_);
    s.store_object_field("pricing", static_cast<const BaseObject *>(pricing_.get()));
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

starSubscriptionPricing::starSubscriptionPricing()
  : period_()
  , star_count_()
{}

starSubscriptionPricing::starSubscriptionPricing(int32 period_, int53 star_count_)
  : period_(period_)
  , star_count_(star_count_)
{}

const std::int32_t starSubscriptionPricing::ID;

void starSubscriptionPricing::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starSubscriptionPricing");
    s.store_field("period", period_);
    s.store_field("star_count", star_count_);
    s.store_class_end();
  }
}

starSubscriptionTypeChannel::starSubscriptionTypeChannel()
  : can_reuse_()
  , invite_link_()
{}

starSubscriptionTypeChannel::starSubscriptionTypeChannel(bool can_reuse_, string const &invite_link_)
  : can_reuse_(can_reuse_)
  , invite_link_(invite_link_)
{}

const std::int32_t starSubscriptionTypeChannel::ID;

void starSubscriptionTypeChannel::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starSubscriptionTypeChannel");
    s.store_field("can_reuse", can_reuse_);
    s.store_field("invite_link", invite_link_);
    s.store_class_end();
  }
}

starSubscriptionTypeBot::starSubscriptionTypeBot()
  : is_canceled_by_bot_()
  , title_()
  , photo_()
  , invoice_link_()
{}

starSubscriptionTypeBot::starSubscriptionTypeBot(bool is_canceled_by_bot_, string const &title_, object_ptr<photo> &&photo_, string const &invoice_link_)
  : is_canceled_by_bot_(is_canceled_by_bot_)
  , title_(title_)
  , photo_(std::move(photo_))
  , invoice_link_(invoice_link_)
{}

const std::int32_t starSubscriptionTypeBot::ID;

void starSubscriptionTypeBot::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starSubscriptionTypeBot");
    s.store_field("is_canceled_by_bot", is_canceled_by_bot_);
    s.store_field("title", title_);
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("invoice_link", invoice_link_);
    s.store_class_end();
  }
}

starSubscriptions::starSubscriptions()
  : star_amount_()
  , subscriptions_()
  , required_star_count_()
  , next_offset_()
{}

starSubscriptions::starSubscriptions(object_ptr<starAmount> &&star_amount_, array<object_ptr<starSubscription>> &&subscriptions_, int53 required_star_count_, string const &next_offset_)
  : star_amount_(std::move(star_amount_))
  , subscriptions_(std::move(subscriptions_))
  , required_star_count_(required_star_count_)
  , next_offset_(next_offset_)
{}

const std::int32_t starSubscriptions::ID;

void starSubscriptions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starSubscriptions");
    s.store_object_field("star_amount", static_cast<const BaseObject *>(star_amount_.get()));
    { s.store_vector_begin("subscriptions", subscriptions_.size()); for (const auto &_value : subscriptions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("required_star_count", required_star_count_);
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

starTransaction::starTransaction()
  : id_()
  , star_amount_()
  , is_refund_()
  , date_()
  , type_()
{}

starTransaction::starTransaction(string const &id_, object_ptr<starAmount> &&star_amount_, bool is_refund_, int32 date_, object_ptr<StarTransactionType> &&type_)
  : id_(id_)
  , star_amount_(std::move(star_amount_))
  , is_refund_(is_refund_)
  , date_(date_)
  , type_(std::move(type_))
{}

const std::int32_t starTransaction::ID;

void starTransaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransaction");
    s.store_field("id", id_);
    s.store_object_field("star_amount", static_cast<const BaseObject *>(star_amount_.get()));
    s.store_field("is_refund", is_refund_);
    s.store_field("date", date_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

starTransactionDirectionIncoming::starTransactionDirectionIncoming() {
}

const std::int32_t starTransactionDirectionIncoming::ID;

void starTransactionDirectionIncoming::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionDirectionIncoming");
    s.store_class_end();
  }
}

starTransactionDirectionOutgoing::starTransactionDirectionOutgoing() {
}

const std::int32_t starTransactionDirectionOutgoing::ID;

void starTransactionDirectionOutgoing::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionDirectionOutgoing");
    s.store_class_end();
  }
}

starTransactionTypePremiumBotDeposit::starTransactionTypePremiumBotDeposit() {
}

const std::int32_t starTransactionTypePremiumBotDeposit::ID;

void starTransactionTypePremiumBotDeposit::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypePremiumBotDeposit");
    s.store_class_end();
  }
}

starTransactionTypeAppStoreDeposit::starTransactionTypeAppStoreDeposit() {
}

const std::int32_t starTransactionTypeAppStoreDeposit::ID;

void starTransactionTypeAppStoreDeposit::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeAppStoreDeposit");
    s.store_class_end();
  }
}

starTransactionTypeGooglePlayDeposit::starTransactionTypeGooglePlayDeposit() {
}

const std::int32_t starTransactionTypeGooglePlayDeposit::ID;

void starTransactionTypeGooglePlayDeposit::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeGooglePlayDeposit");
    s.store_class_end();
  }
}

starTransactionTypeFragmentDeposit::starTransactionTypeFragmentDeposit() {
}

const std::int32_t starTransactionTypeFragmentDeposit::ID;

void starTransactionTypeFragmentDeposit::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeFragmentDeposit");
    s.store_class_end();
  }
}

starTransactionTypeUserDeposit::starTransactionTypeUserDeposit()
  : user_id_()
  , sticker_()
{}

starTransactionTypeUserDeposit::starTransactionTypeUserDeposit(int53 user_id_, object_ptr<sticker> &&sticker_)
  : user_id_(user_id_)
  , sticker_(std::move(sticker_))
{}

const std::int32_t starTransactionTypeUserDeposit::ID;

void starTransactionTypeUserDeposit::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeUserDeposit");
    s.store_field("user_id", user_id_);
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

starTransactionTypeGiveawayDeposit::starTransactionTypeGiveawayDeposit()
  : chat_id_()
  , giveaway_message_id_()
{}

starTransactionTypeGiveawayDeposit::starTransactionTypeGiveawayDeposit(int53 chat_id_, int53 giveaway_message_id_)
  : chat_id_(chat_id_)
  , giveaway_message_id_(giveaway_message_id_)
{}

const std::int32_t starTransactionTypeGiveawayDeposit::ID;

void starTransactionTypeGiveawayDeposit::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeGiveawayDeposit");
    s.store_field("chat_id", chat_id_);
    s.store_field("giveaway_message_id", giveaway_message_id_);
    s.store_class_end();
  }
}

starTransactionTypeFragmentWithdrawal::starTransactionTypeFragmentWithdrawal()
  : withdrawal_state_()
{}

starTransactionTypeFragmentWithdrawal::starTransactionTypeFragmentWithdrawal(object_ptr<RevenueWithdrawalState> &&withdrawal_state_)
  : withdrawal_state_(std::move(withdrawal_state_))
{}

const std::int32_t starTransactionTypeFragmentWithdrawal::ID;

void starTransactionTypeFragmentWithdrawal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeFragmentWithdrawal");
    s.store_object_field("withdrawal_state", static_cast<const BaseObject *>(withdrawal_state_.get()));
    s.store_class_end();
  }
}

starTransactionTypeTelegramAdsWithdrawal::starTransactionTypeTelegramAdsWithdrawal() {
}

const std::int32_t starTransactionTypeTelegramAdsWithdrawal::ID;

void starTransactionTypeTelegramAdsWithdrawal::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeTelegramAdsWithdrawal");
    s.store_class_end();
  }
}

starTransactionTypeTelegramApiUsage::starTransactionTypeTelegramApiUsage()
  : request_count_()
{}

starTransactionTypeTelegramApiUsage::starTransactionTypeTelegramApiUsage(int32 request_count_)
  : request_count_(request_count_)
{}

const std::int32_t starTransactionTypeTelegramApiUsage::ID;

void starTransactionTypeTelegramApiUsage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeTelegramApiUsage");
    s.store_field("request_count", request_count_);
    s.store_class_end();
  }
}

starTransactionTypeBotPaidMediaPurchase::starTransactionTypeBotPaidMediaPurchase()
  : user_id_()
  , media_()
{}

starTransactionTypeBotPaidMediaPurchase::starTransactionTypeBotPaidMediaPurchase(int53 user_id_, array<object_ptr<PaidMedia>> &&media_)
  : user_id_(user_id_)
  , media_(std::move(media_))
{}

const std::int32_t starTransactionTypeBotPaidMediaPurchase::ID;

void starTransactionTypeBotPaidMediaPurchase::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeBotPaidMediaPurchase");
    s.store_field("user_id", user_id_);
    { s.store_vector_begin("media", media_.size()); for (const auto &_value : media_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

starTransactionTypeBotPaidMediaSale::starTransactionTypeBotPaidMediaSale()
  : user_id_()
  , media_()
  , payload_()
  , affiliate_()
{}

starTransactionTypeBotPaidMediaSale::starTransactionTypeBotPaidMediaSale(int53 user_id_, array<object_ptr<PaidMedia>> &&media_, string const &payload_, object_ptr<affiliateInfo> &&affiliate_)
  : user_id_(user_id_)
  , media_(std::move(media_))
  , payload_(payload_)
  , affiliate_(std::move(affiliate_))
{}

const std::int32_t starTransactionTypeBotPaidMediaSale::ID;

void starTransactionTypeBotPaidMediaSale::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeBotPaidMediaSale");
    s.store_field("user_id", user_id_);
    { s.store_vector_begin("media", media_.size()); for (const auto &_value : media_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("payload", payload_);
    s.store_object_field("affiliate", static_cast<const BaseObject *>(affiliate_.get()));
    s.store_class_end();
  }
}

starTransactionTypeChannelPaidMediaPurchase::starTransactionTypeChannelPaidMediaPurchase()
  : chat_id_()
  , message_id_()
  , media_()
{}

starTransactionTypeChannelPaidMediaPurchase::starTransactionTypeChannelPaidMediaPurchase(int53 chat_id_, int53 message_id_, array<object_ptr<PaidMedia>> &&media_)
  : chat_id_(chat_id_)
  , message_id_(message_id_)
  , media_(std::move(media_))
{}

const std::int32_t starTransactionTypeChannelPaidMediaPurchase::ID;

void starTransactionTypeChannelPaidMediaPurchase::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeChannelPaidMediaPurchase");
    s.store_field("chat_id", chat_id_);
    s.store_field("message_id", message_id_);
    { s.store_vector_begin("media", media_.size()); for (const auto &_value : media_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

starTransactionTypeChannelPaidMediaSale::starTransactionTypeChannelPaidMediaSale()
  : user_id_()
  , message_id_()
  , media_()
{}

starTransactionTypeChannelPaidMediaSale::starTransactionTypeChannelPaidMediaSale(int53 user_id_, int53 message_id_, array<object_ptr<PaidMedia>> &&media_)
  : user_id_(user_id_)
  , message_id_(message_id_)
  , media_(std::move(media_))
{}

const std::int32_t starTransactionTypeChannelPaidMediaSale::ID;

void starTransactionTypeChannelPaidMediaSale::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeChannelPaidMediaSale");
    s.store_field("user_id", user_id_);
    s.store_field("message_id", message_id_);
    { s.store_vector_begin("media", media_.size()); for (const auto &_value : media_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

starTransactionTypeBotInvoicePurchase::starTransactionTypeBotInvoicePurchase()
  : user_id_()
  , product_info_()
{}

starTransactionTypeBotInvoicePurchase::starTransactionTypeBotInvoicePurchase(int53 user_id_, object_ptr<productInfo> &&product_info_)
  : user_id_(user_id_)
  , product_info_(std::move(product_info_))
{}

const std::int32_t starTransactionTypeBotInvoicePurchase::ID;

void starTransactionTypeBotInvoicePurchase::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeBotInvoicePurchase");
    s.store_field("user_id", user_id_);
    s.store_object_field("product_info", static_cast<const BaseObject *>(product_info_.get()));
    s.store_class_end();
  }
}

starTransactionTypeBotInvoiceSale::starTransactionTypeBotInvoiceSale()
  : user_id_()
  , product_info_()
  , invoice_payload_()
  , affiliate_()
{}

starTransactionTypeBotInvoiceSale::starTransactionTypeBotInvoiceSale(int53 user_id_, object_ptr<productInfo> &&product_info_, bytes const &invoice_payload_, object_ptr<affiliateInfo> &&affiliate_)
  : user_id_(user_id_)
  , product_info_(std::move(product_info_))
  , invoice_payload_(std::move(invoice_payload_))
  , affiliate_(std::move(affiliate_))
{}

const std::int32_t starTransactionTypeBotInvoiceSale::ID;

void starTransactionTypeBotInvoiceSale::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeBotInvoiceSale");
    s.store_field("user_id", user_id_);
    s.store_object_field("product_info", static_cast<const BaseObject *>(product_info_.get()));
    s.store_bytes_field("invoice_payload", invoice_payload_);
    s.store_object_field("affiliate", static_cast<const BaseObject *>(affiliate_.get()));
    s.store_class_end();
  }
}

starTransactionTypeBotSubscriptionPurchase::starTransactionTypeBotSubscriptionPurchase()
  : user_id_()
  , subscription_period_()
  , product_info_()
{}

starTransactionTypeBotSubscriptionPurchase::starTransactionTypeBotSubscriptionPurchase(int53 user_id_, int32 subscription_period_, object_ptr<productInfo> &&product_info_)
  : user_id_(user_id_)
  , subscription_period_(subscription_period_)
  , product_info_(std::move(product_info_))
{}

const std::int32_t starTransactionTypeBotSubscriptionPurchase::ID;

void starTransactionTypeBotSubscriptionPurchase::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeBotSubscriptionPurchase");
    s.store_field("user_id", user_id_);
    s.store_field("subscription_period", subscription_period_);
    s.store_object_field("product_info", static_cast<const BaseObject *>(product_info_.get()));
    s.store_class_end();
  }
}

starTransactionTypeBotSubscriptionSale::starTransactionTypeBotSubscriptionSale()
  : user_id_()
  , subscription_period_()
  , product_info_()
  , invoice_payload_()
  , affiliate_()
{}

starTransactionTypeBotSubscriptionSale::starTransactionTypeBotSubscriptionSale(int53 user_id_, int32 subscription_period_, object_ptr<productInfo> &&product_info_, bytes const &invoice_payload_, object_ptr<affiliateInfo> &&affiliate_)
  : user_id_(user_id_)
  , subscription_period_(subscription_period_)
  , product_info_(std::move(product_info_))
  , invoice_payload_(std::move(invoice_payload_))
  , affiliate_(std::move(affiliate_))
{}

const std::int32_t starTransactionTypeBotSubscriptionSale::ID;

void starTransactionTypeBotSubscriptionSale::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeBotSubscriptionSale");
    s.store_field("user_id", user_id_);
    s.store_field("subscription_period", subscription_period_);
    s.store_object_field("product_info", static_cast<const BaseObject *>(product_info_.get()));
    s.store_bytes_field("invoice_payload", invoice_payload_);
    s.store_object_field("affiliate", static_cast<const BaseObject *>(affiliate_.get()));
    s.store_class_end();
  }
}

starTransactionTypeChannelSubscriptionPurchase::starTransactionTypeChannelSubscriptionPurchase()
  : chat_id_()
  , subscription_period_()
{}

starTransactionTypeChannelSubscriptionPurchase::starTransactionTypeChannelSubscriptionPurchase(int53 chat_id_, int32 subscription_period_)
  : chat_id_(chat_id_)
  , subscription_period_(subscription_period_)
{}

const std::int32_t starTransactionTypeChannelSubscriptionPurchase::ID;

void starTransactionTypeChannelSubscriptionPurchase::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeChannelSubscriptionPurchase");
    s.store_field("chat_id", chat_id_);
    s.store_field("subscription_period", subscription_period_);
    s.store_class_end();
  }
}

starTransactionTypeChannelSubscriptionSale::starTransactionTypeChannelSubscriptionSale()
  : user_id_()
  , subscription_period_()
{}

starTransactionTypeChannelSubscriptionSale::starTransactionTypeChannelSubscriptionSale(int53 user_id_, int32 subscription_period_)
  : user_id_(user_id_)
  , subscription_period_(subscription_period_)
{}

const std::int32_t starTransactionTypeChannelSubscriptionSale::ID;

void starTransactionTypeChannelSubscriptionSale::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeChannelSubscriptionSale");
    s.store_field("user_id", user_id_);
    s.store_field("subscription_period", subscription_period_);
    s.store_class_end();
  }
}

starTransactionTypeGiftPurchase::starTransactionTypeGiftPurchase()
  : owner_id_()
  , gift_()
{}

starTransactionTypeGiftPurchase::starTransactionTypeGiftPurchase(object_ptr<MessageSender> &&owner_id_, object_ptr<gift> &&gift_)
  : owner_id_(std::move(owner_id_))
  , gift_(std::move(gift_))
{}

const std::int32_t starTransactionTypeGiftPurchase::ID;

void starTransactionTypeGiftPurchase::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeGiftPurchase");
    s.store_object_field("owner_id", static_cast<const BaseObject *>(owner_id_.get()));
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_class_end();
  }
}

starTransactionTypeGiftTransfer::starTransactionTypeGiftTransfer()
  : owner_id_()
  , gift_()
{}

starTransactionTypeGiftTransfer::starTransactionTypeGiftTransfer(object_ptr<MessageSender> &&owner_id_, object_ptr<upgradedGift> &&gift_)
  : owner_id_(std::move(owner_id_))
  , gift_(std::move(gift_))
{}

const std::int32_t starTransactionTypeGiftTransfer::ID;

void starTransactionTypeGiftTransfer::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeGiftTransfer");
    s.store_object_field("owner_id", static_cast<const BaseObject *>(owner_id_.get()));
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_class_end();
  }
}

starTransactionTypeGiftSale::starTransactionTypeGiftSale()
  : user_id_()
  , gift_()
{}

starTransactionTypeGiftSale::starTransactionTypeGiftSale(int53 user_id_, object_ptr<gift> &&gift_)
  : user_id_(user_id_)
  , gift_(std::move(gift_))
{}

const std::int32_t starTransactionTypeGiftSale::ID;

void starTransactionTypeGiftSale::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeGiftSale");
    s.store_field("user_id", user_id_);
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_class_end();
  }
}

starTransactionTypeGiftUpgrade::starTransactionTypeGiftUpgrade()
  : gift_()
{}

starTransactionTypeGiftUpgrade::starTransactionTypeGiftUpgrade(object_ptr<upgradedGift> &&gift_)
  : gift_(std::move(gift_))
{}

const std::int32_t starTransactionTypeGiftUpgrade::ID;

void starTransactionTypeGiftUpgrade::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeGiftUpgrade");
    s.store_object_field("gift", static_cast<const BaseObject *>(gift_.get()));
    s.store_class_end();
  }
}

starTransactionTypeChannelPaidReactionSend::starTransactionTypeChannelPaidReactionSend()
  : chat_id_()
  , message_id_()
{}

starTransactionTypeChannelPaidReactionSend::starTransactionTypeChannelPaidReactionSend(int53 chat_id_, int53 message_id_)
  : chat_id_(chat_id_)
  , message_id_(message_id_)
{}

const std::int32_t starTransactionTypeChannelPaidReactionSend::ID;

void starTransactionTypeChannelPaidReactionSend::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeChannelPaidReactionSend");
    s.store_field("chat_id", chat_id_);
    s.store_field("message_id", message_id_);
    s.store_class_end();
  }
}

starTransactionTypeChannelPaidReactionReceive::starTransactionTypeChannelPaidReactionReceive()
  : user_id_()
  , message_id_()
{}

starTransactionTypeChannelPaidReactionReceive::starTransactionTypeChannelPaidReactionReceive(int53 user_id_, int53 message_id_)
  : user_id_(user_id_)
  , message_id_(message_id_)
{}

const std::int32_t starTransactionTypeChannelPaidReactionReceive::ID;

void starTransactionTypeChannelPaidReactionReceive::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeChannelPaidReactionReceive");
    s.store_field("user_id", user_id_);
    s.store_field("message_id", message_id_);
    s.store_class_end();
  }
}

starTransactionTypeAffiliateProgramCommission::starTransactionTypeAffiliateProgramCommission()
  : chat_id_()
  , commission_per_mille_()
{}

starTransactionTypeAffiliateProgramCommission::starTransactionTypeAffiliateProgramCommission(int53 chat_id_, int32 commission_per_mille_)
  : chat_id_(chat_id_)
  , commission_per_mille_(commission_per_mille_)
{}

const std::int32_t starTransactionTypeAffiliateProgramCommission::ID;

void starTransactionTypeAffiliateProgramCommission::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeAffiliateProgramCommission");
    s.store_field("chat_id", chat_id_);
    s.store_field("commission_per_mille", commission_per_mille_);
    s.store_class_end();
  }
}

starTransactionTypeUnsupported::starTransactionTypeUnsupported() {
}

const std::int32_t starTransactionTypeUnsupported::ID;

void starTransactionTypeUnsupported::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactionTypeUnsupported");
    s.store_class_end();
  }
}

starTransactions::starTransactions()
  : star_amount_()
  , transactions_()
  , next_offset_()
{}

starTransactions::starTransactions(object_ptr<starAmount> &&star_amount_, array<object_ptr<starTransaction>> &&transactions_, string const &next_offset_)
  : star_amount_(std::move(star_amount_))
  , transactions_(std::move(transactions_))
  , next_offset_(next_offset_)
{}

const std::int32_t starTransactions::ID;

void starTransactions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "starTransactions");
    s.store_object_field("star_amount", static_cast<const BaseObject *>(star_amount_.get()));
    { s.store_vector_begin("transactions", transactions_.size()); for (const auto &_value : transactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

statisticalGraphData::statisticalGraphData()
  : json_data_()
  , zoom_token_()
{}

statisticalGraphData::statisticalGraphData(string const &json_data_, string const &zoom_token_)
  : json_data_(json_data_)
  , zoom_token_(zoom_token_)
{}

const std::int32_t statisticalGraphData::ID;

void statisticalGraphData::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "statisticalGraphData");
    s.store_field("json_data", json_data_);
    s.store_field("zoom_token", zoom_token_);
    s.store_class_end();
  }
}

statisticalGraphAsync::statisticalGraphAsync()
  : token_()
{}

statisticalGraphAsync::statisticalGraphAsync(string const &token_)
  : token_(token_)
{}

const std::int32_t statisticalGraphAsync::ID;

void statisticalGraphAsync::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "statisticalGraphAsync");
    s.store_field("token", token_);
    s.store_class_end();
  }
}

statisticalGraphError::statisticalGraphError()
  : error_message_()
{}

statisticalGraphError::statisticalGraphError(string const &error_message_)
  : error_message_(error_message_)
{}

const std::int32_t statisticalGraphError::ID;

void statisticalGraphError::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "statisticalGraphError");
    s.store_field("error_message", error_message_);
    s.store_class_end();
  }
}

statisticalValue::statisticalValue()
  : value_()
  , previous_value_()
  , growth_rate_percentage_()
{}

statisticalValue::statisticalValue(double value_, double previous_value_, double growth_rate_percentage_)
  : value_(value_)
  , previous_value_(previous_value_)
  , growth_rate_percentage_(growth_rate_percentage_)
{}

const std::int32_t statisticalValue::ID;

void statisticalValue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "statisticalValue");
    s.store_field("value", value_);
    s.store_field("previous_value", previous_value_);
    s.store_field("growth_rate_percentage", growth_rate_percentage_);
    s.store_class_end();
  }
}

sticker::sticker()
  : id_()
  , set_id_()
  , width_()
  , height_()
  , emoji_()
  , format_()
  , full_type_()
  , thumbnail_()
  , sticker_()
{}

sticker::sticker(int64 id_, int64 set_id_, int32 width_, int32 height_, string const &emoji_, object_ptr<StickerFormat> &&format_, object_ptr<StickerFullType> &&full_type_, object_ptr<thumbnail> &&thumbnail_, object_ptr<file> &&sticker_)
  : id_(id_)
  , set_id_(set_id_)
  , width_(width_)
  , height_(height_)
  , emoji_(emoji_)
  , format_(std::move(format_))
  , full_type_(std::move(full_type_))
  , thumbnail_(std::move(thumbnail_))
  , sticker_(std::move(sticker_))
{}

const std::int32_t sticker::ID;

void sticker::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "sticker");
    s.store_field("id", id_);
    s.store_field("set_id", set_id_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_field("emoji", emoji_);
    s.store_object_field("format", static_cast<const BaseObject *>(format_.get()));
    s.store_object_field("full_type", static_cast<const BaseObject *>(full_type_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_object_field("sticker", static_cast<const BaseObject *>(sticker_.get()));
    s.store_class_end();
  }
}

stickerFormatWebp::stickerFormatWebp() {
}

const std::int32_t stickerFormatWebp::ID;

void stickerFormatWebp::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerFormatWebp");
    s.store_class_end();
  }
}

stickerFormatTgs::stickerFormatTgs() {
}

const std::int32_t stickerFormatTgs::ID;

void stickerFormatTgs::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerFormatTgs");
    s.store_class_end();
  }
}

stickerFormatWebm::stickerFormatWebm() {
}

const std::int32_t stickerFormatWebm::ID;

void stickerFormatWebm::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerFormatWebm");
    s.store_class_end();
  }
}

stickerFullTypeRegular::stickerFullTypeRegular()
  : premium_animation_()
{}

stickerFullTypeRegular::stickerFullTypeRegular(object_ptr<file> &&premium_animation_)
  : premium_animation_(std::move(premium_animation_))
{}

const std::int32_t stickerFullTypeRegular::ID;

void stickerFullTypeRegular::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerFullTypeRegular");
    s.store_object_field("premium_animation", static_cast<const BaseObject *>(premium_animation_.get()));
    s.store_class_end();
  }
}

stickerFullTypeMask::stickerFullTypeMask()
  : mask_position_()
{}

stickerFullTypeMask::stickerFullTypeMask(object_ptr<maskPosition> &&mask_position_)
  : mask_position_(std::move(mask_position_))
{}

const std::int32_t stickerFullTypeMask::ID;

void stickerFullTypeMask::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerFullTypeMask");
    s.store_object_field("mask_position", static_cast<const BaseObject *>(mask_position_.get()));
    s.store_class_end();
  }
}

stickerFullTypeCustomEmoji::stickerFullTypeCustomEmoji()
  : custom_emoji_id_()
  , needs_repainting_()
{}

stickerFullTypeCustomEmoji::stickerFullTypeCustomEmoji(int64 custom_emoji_id_, bool needs_repainting_)
  : custom_emoji_id_(custom_emoji_id_)
  , needs_repainting_(needs_repainting_)
{}

const std::int32_t stickerFullTypeCustomEmoji::ID;

void stickerFullTypeCustomEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerFullTypeCustomEmoji");
    s.store_field("custom_emoji_id", custom_emoji_id_);
    s.store_field("needs_repainting", needs_repainting_);
    s.store_class_end();
  }
}

stickerSet::stickerSet()
  : id_()
  , title_()
  , name_()
  , thumbnail_()
  , thumbnail_outline_()
  , is_owned_()
  , is_installed_()
  , is_archived_()
  , is_official_()
  , sticker_type_()
  , needs_repainting_()
  , is_allowed_as_chat_emoji_status_()
  , is_viewed_()
  , stickers_()
  , emojis_()
{}

stickerSet::stickerSet(int64 id_, string const &title_, string const &name_, object_ptr<thumbnail> &&thumbnail_, object_ptr<outline> &&thumbnail_outline_, bool is_owned_, bool is_installed_, bool is_archived_, bool is_official_, object_ptr<StickerType> &&sticker_type_, bool needs_repainting_, bool is_allowed_as_chat_emoji_status_, bool is_viewed_, array<object_ptr<sticker>> &&stickers_, array<object_ptr<emojis>> &&emojis_)
  : id_(id_)
  , title_(title_)
  , name_(name_)
  , thumbnail_(std::move(thumbnail_))
  , thumbnail_outline_(std::move(thumbnail_outline_))
  , is_owned_(is_owned_)
  , is_installed_(is_installed_)
  , is_archived_(is_archived_)
  , is_official_(is_official_)
  , sticker_type_(std::move(sticker_type_))
  , needs_repainting_(needs_repainting_)
  , is_allowed_as_chat_emoji_status_(is_allowed_as_chat_emoji_status_)
  , is_viewed_(is_viewed_)
  , stickers_(std::move(stickers_))
  , emojis_(std::move(emojis_))
{}

const std::int32_t stickerSet::ID;

void stickerSet::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerSet");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_field("name", name_);
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_object_field("thumbnail_outline", static_cast<const BaseObject *>(thumbnail_outline_.get()));
    s.store_field("is_owned", is_owned_);
    s.store_field("is_installed", is_installed_);
    s.store_field("is_archived", is_archived_);
    s.store_field("is_official", is_official_);
    s.store_object_field("sticker_type", static_cast<const BaseObject *>(sticker_type_.get()));
    s.store_field("needs_repainting", needs_repainting_);
    s.store_field("is_allowed_as_chat_emoji_status", is_allowed_as_chat_emoji_status_);
    s.store_field("is_viewed", is_viewed_);
    { s.store_vector_begin("stickers", stickers_.size()); for (const auto &_value : stickers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("emojis", emojis_.size()); for (const auto &_value : emojis_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

stickerSetInfo::stickerSetInfo()
  : id_()
  , title_()
  , name_()
  , thumbnail_()
  , thumbnail_outline_()
  , is_owned_()
  , is_installed_()
  , is_archived_()
  , is_official_()
  , sticker_type_()
  , needs_repainting_()
  , is_allowed_as_chat_emoji_status_()
  , is_viewed_()
  , size_()
  , covers_()
{}

stickerSetInfo::stickerSetInfo(int64 id_, string const &title_, string const &name_, object_ptr<thumbnail> &&thumbnail_, object_ptr<outline> &&thumbnail_outline_, bool is_owned_, bool is_installed_, bool is_archived_, bool is_official_, object_ptr<StickerType> &&sticker_type_, bool needs_repainting_, bool is_allowed_as_chat_emoji_status_, bool is_viewed_, int32 size_, array<object_ptr<sticker>> &&covers_)
  : id_(id_)
  , title_(title_)
  , name_(name_)
  , thumbnail_(std::move(thumbnail_))
  , thumbnail_outline_(std::move(thumbnail_outline_))
  , is_owned_(is_owned_)
  , is_installed_(is_installed_)
  , is_archived_(is_archived_)
  , is_official_(is_official_)
  , sticker_type_(std::move(sticker_type_))
  , needs_repainting_(needs_repainting_)
  , is_allowed_as_chat_emoji_status_(is_allowed_as_chat_emoji_status_)
  , is_viewed_(is_viewed_)
  , size_(size_)
  , covers_(std::move(covers_))
{}

const std::int32_t stickerSetInfo::ID;

void stickerSetInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerSetInfo");
    s.store_field("id", id_);
    s.store_field("title", title_);
    s.store_field("name", name_);
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_object_field("thumbnail_outline", static_cast<const BaseObject *>(thumbnail_outline_.get()));
    s.store_field("is_owned", is_owned_);
    s.store_field("is_installed", is_installed_);
    s.store_field("is_archived", is_archived_);
    s.store_field("is_official", is_official_);
    s.store_object_field("sticker_type", static_cast<const BaseObject *>(sticker_type_.get()));
    s.store_field("needs_repainting", needs_repainting_);
    s.store_field("is_allowed_as_chat_emoji_status", is_allowed_as_chat_emoji_status_);
    s.store_field("is_viewed", is_viewed_);
    s.store_field("size", size_);
    { s.store_vector_begin("covers", covers_.size()); for (const auto &_value : covers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

stickerSets::stickerSets()
  : total_count_()
  , sets_()
{}

stickerSets::stickerSets(int32 total_count_, array<object_ptr<stickerSetInfo>> &&sets_)
  : total_count_(total_count_)
  , sets_(std::move(sets_))
{}

const std::int32_t stickerSets::ID;

void stickerSets::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerSets");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("sets", sets_.size()); for (const auto &_value : sets_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

stickerTypeRegular::stickerTypeRegular() {
}

const std::int32_t stickerTypeRegular::ID;

void stickerTypeRegular::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerTypeRegular");
    s.store_class_end();
  }
}

stickerTypeMask::stickerTypeMask() {
}

const std::int32_t stickerTypeMask::ID;

void stickerTypeMask::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerTypeMask");
    s.store_class_end();
  }
}

stickerTypeCustomEmoji::stickerTypeCustomEmoji() {
}

const std::int32_t stickerTypeCustomEmoji::ID;

void stickerTypeCustomEmoji::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickerTypeCustomEmoji");
    s.store_class_end();
  }
}

stickers::stickers()
  : stickers_()
{}

stickers::stickers(array<object_ptr<sticker>> &&stickers_)
  : stickers_(std::move(stickers_))
{}

const std::int32_t stickers::ID;

void stickers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stickers");
    { s.store_vector_begin("stickers", stickers_.size()); for (const auto &_value : stickers_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

storageStatistics::storageStatistics()
  : size_()
  , count_()
  , by_chat_()
{}

storageStatistics::storageStatistics(int53 size_, int32 count_, array<object_ptr<storageStatisticsByChat>> &&by_chat_)
  : size_(size_)
  , count_(count_)
  , by_chat_(std::move(by_chat_))
{}

const std::int32_t storageStatistics::ID;

void storageStatistics::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storageStatistics");
    s.store_field("size", size_);
    s.store_field("count", count_);
    { s.store_vector_begin("by_chat", by_chat_.size()); for (const auto &_value : by_chat_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

storageStatisticsByChat::storageStatisticsByChat()
  : chat_id_()
  , size_()
  , count_()
  , by_file_type_()
{}

storageStatisticsByChat::storageStatisticsByChat(int53 chat_id_, int53 size_, int32 count_, array<object_ptr<storageStatisticsByFileType>> &&by_file_type_)
  : chat_id_(chat_id_)
  , size_(size_)
  , count_(count_)
  , by_file_type_(std::move(by_file_type_))
{}

const std::int32_t storageStatisticsByChat::ID;

void storageStatisticsByChat::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storageStatisticsByChat");
    s.store_field("chat_id", chat_id_);
    s.store_field("size", size_);
    s.store_field("count", count_);
    { s.store_vector_begin("by_file_type", by_file_type_.size()); for (const auto &_value : by_file_type_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_class_end();
  }
}

storageStatisticsByFileType::storageStatisticsByFileType()
  : file_type_()
  , size_()
  , count_()
{}

storageStatisticsByFileType::storageStatisticsByFileType(object_ptr<FileType> &&file_type_, int53 size_, int32 count_)
  : file_type_(std::move(file_type_))
  , size_(size_)
  , count_(count_)
{}

const std::int32_t storageStatisticsByFileType::ID;

void storageStatisticsByFileType::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storageStatisticsByFileType");
    s.store_object_field("file_type", static_cast<const BaseObject *>(file_type_.get()));
    s.store_field("size", size_);
    s.store_field("count", count_);
    s.store_class_end();
  }
}

storageStatisticsFast::storageStatisticsFast()
  : files_size_()
  , file_count_()
  , database_size_()
  , language_pack_database_size_()
  , log_size_()
{}

storageStatisticsFast::storageStatisticsFast(int53 files_size_, int32 file_count_, int53 database_size_, int53 language_pack_database_size_, int53 log_size_)
  : files_size_(files_size_)
  , file_count_(file_count_)
  , database_size_(database_size_)
  , language_pack_database_size_(language_pack_database_size_)
  , log_size_(log_size_)
{}

const std::int32_t storageStatisticsFast::ID;

void storageStatisticsFast::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storageStatisticsFast");
    s.store_field("files_size", files_size_);
    s.store_field("file_count", file_count_);
    s.store_field("database_size", database_size_);
    s.store_field("language_pack_database_size", language_pack_database_size_);
    s.store_field("log_size", log_size_);
    s.store_class_end();
  }
}

storePaymentPurposePremiumSubscription::storePaymentPurposePremiumSubscription()
  : is_restore_()
  , is_upgrade_()
{}

storePaymentPurposePremiumSubscription::storePaymentPurposePremiumSubscription(bool is_restore_, bool is_upgrade_)
  : is_restore_(is_restore_)
  , is_upgrade_(is_upgrade_)
{}

const std::int32_t storePaymentPurposePremiumSubscription::ID;

void storePaymentPurposePremiumSubscription::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storePaymentPurposePremiumSubscription");
    s.store_field("is_restore", is_restore_);
    s.store_field("is_upgrade", is_upgrade_);
    s.store_class_end();
  }
}

storePaymentPurposePremiumGiftCodes::storePaymentPurposePremiumGiftCodes()
  : boosted_chat_id_()
  , currency_()
  , amount_()
  , user_ids_()
  , text_()
{}

storePaymentPurposePremiumGiftCodes::storePaymentPurposePremiumGiftCodes(int53 boosted_chat_id_, string const &currency_, int53 amount_, array<int53> &&user_ids_, object_ptr<formattedText> &&text_)
  : boosted_chat_id_(boosted_chat_id_)
  , currency_(currency_)
  , amount_(amount_)
  , user_ids_(std::move(user_ids_))
  , text_(std::move(text_))
{}

const std::int32_t storePaymentPurposePremiumGiftCodes::ID;

void storePaymentPurposePremiumGiftCodes::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storePaymentPurposePremiumGiftCodes");
    s.store_field("boosted_chat_id", boosted_chat_id_);
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    { s.store_vector_begin("user_ids", user_ids_.size()); for (const auto &_value : user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_object_field("text", static_cast<const BaseObject *>(text_.get()));
    s.store_class_end();
  }
}

storePaymentPurposePremiumGiveaway::storePaymentPurposePremiumGiveaway()
  : parameters_()
  , currency_()
  , amount_()
{}

storePaymentPurposePremiumGiveaway::storePaymentPurposePremiumGiveaway(object_ptr<giveawayParameters> &&parameters_, string const &currency_, int53 amount_)
  : parameters_(std::move(parameters_))
  , currency_(currency_)
  , amount_(amount_)
{}

const std::int32_t storePaymentPurposePremiumGiveaway::ID;

void storePaymentPurposePremiumGiveaway::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storePaymentPurposePremiumGiveaway");
    s.store_object_field("parameters", static_cast<const BaseObject *>(parameters_.get()));
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_class_end();
  }
}

storePaymentPurposeStarGiveaway::storePaymentPurposeStarGiveaway()
  : parameters_()
  , currency_()
  , amount_()
  , winner_count_()
  , star_count_()
{}

storePaymentPurposeStarGiveaway::storePaymentPurposeStarGiveaway(object_ptr<giveawayParameters> &&parameters_, string const &currency_, int53 amount_, int32 winner_count_, int53 star_count_)
  : parameters_(std::move(parameters_))
  , currency_(currency_)
  , amount_(amount_)
  , winner_count_(winner_count_)
  , star_count_(star_count_)
{}

const std::int32_t storePaymentPurposeStarGiveaway::ID;

void storePaymentPurposeStarGiveaway::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storePaymentPurposeStarGiveaway");
    s.store_object_field("parameters", static_cast<const BaseObject *>(parameters_.get()));
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("winner_count", winner_count_);
    s.store_field("star_count", star_count_);
    s.store_class_end();
  }
}

storePaymentPurposeStars::storePaymentPurposeStars()
  : currency_()
  , amount_()
  , star_count_()
{}

storePaymentPurposeStars::storePaymentPurposeStars(string const &currency_, int53 amount_, int53 star_count_)
  : currency_(currency_)
  , amount_(amount_)
  , star_count_(star_count_)
{}

const std::int32_t storePaymentPurposeStars::ID;

void storePaymentPurposeStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storePaymentPurposeStars");
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("star_count", star_count_);
    s.store_class_end();
  }
}

storePaymentPurposeGiftedStars::storePaymentPurposeGiftedStars()
  : user_id_()
  , currency_()
  , amount_()
  , star_count_()
{}

storePaymentPurposeGiftedStars::storePaymentPurposeGiftedStars(int53 user_id_, string const &currency_, int53 amount_, int53 star_count_)
  : user_id_(user_id_)
  , currency_(currency_)
  , amount_(amount_)
  , star_count_(star_count_)
{}

const std::int32_t storePaymentPurposeGiftedStars::ID;

void storePaymentPurposeGiftedStars::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storePaymentPurposeGiftedStars");
    s.store_field("user_id", user_id_);
    s.store_field("currency", currency_);
    s.store_field("amount", amount_);
    s.store_field("star_count", star_count_);
    s.store_class_end();
  }
}

stories::stories()
  : total_count_()
  , stories_()
  , pinned_story_ids_()
{}

stories::stories(int32 total_count_, array<object_ptr<story>> &&stories_, array<int32> &&pinned_story_ids_)
  : total_count_(total_count_)
  , stories_(std::move(stories_))
  , pinned_story_ids_(std::move(pinned_story_ids_))
{}

const std::int32_t stories::ID;

void stories::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "stories");
    s.store_field("total_count", total_count_);
    { s.store_vector_begin("stories", stories_.size()); for (const auto &_value : stories_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    { s.store_vector_begin("pinned_story_ids", pinned_story_ids_.size()); for (const auto &_value : pinned_story_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

story::story()
  : id_()
  , sender_chat_id_()
  , sender_id_()
  , date_()
  , is_being_sent_()
  , is_being_edited_()
  , is_edited_()
  , is_posted_to_chat_page_()
  , is_visible_only_for_self_()
  , can_be_deleted_()
  , can_be_edited_()
  , can_be_forwarded_()
  , can_be_replied_()
  , can_toggle_is_posted_to_chat_page_()
  , can_get_statistics_()
  , can_get_interactions_()
  , has_expired_viewers_()
  , repost_info_()
  , interaction_info_()
  , chosen_reaction_type_()
  , privacy_settings_()
  , content_()
  , areas_()
  , caption_()
{}

story::story(int32 id_, int53 sender_chat_id_, object_ptr<MessageSender> &&sender_id_, int32 date_, bool is_being_sent_, bool is_being_edited_, bool is_edited_, bool is_posted_to_chat_page_, bool is_visible_only_for_self_, bool can_be_deleted_, bool can_be_edited_, bool can_be_forwarded_, bool can_be_replied_, bool can_toggle_is_posted_to_chat_page_, bool can_get_statistics_, bool can_get_interactions_, bool has_expired_viewers_, object_ptr<storyRepostInfo> &&repost_info_, object_ptr<storyInteractionInfo> &&interaction_info_, object_ptr<ReactionType> &&chosen_reaction_type_, object_ptr<StoryPrivacySettings> &&privacy_settings_, object_ptr<StoryContent> &&content_, array<object_ptr<storyArea>> &&areas_, object_ptr<formattedText> &&caption_)
  : id_(id_)
  , sender_chat_id_(sender_chat_id_)
  , sender_id_(std::move(sender_id_))
  , date_(date_)
  , is_being_sent_(is_being_sent_)
  , is_being_edited_(is_being_edited_)
  , is_edited_(is_edited_)
  , is_posted_to_chat_page_(is_posted_to_chat_page_)
  , is_visible_only_for_self_(is_visible_only_for_self_)
  , can_be_deleted_(can_be_deleted_)
  , can_be_edited_(can_be_edited_)
  , can_be_forwarded_(can_be_forwarded_)
  , can_be_replied_(can_be_replied_)
  , can_toggle_is_posted_to_chat_page_(can_toggle_is_posted_to_chat_page_)
  , can_get_statistics_(can_get_statistics_)
  , can_get_interactions_(can_get_interactions_)
  , has_expired_viewers_(has_expired_viewers_)
  , repost_info_(std::move(repost_info_))
  , interaction_info_(std::move(interaction_info_))
  , chosen_reaction_type_(std::move(chosen_reaction_type_))
  , privacy_settings_(std::move(privacy_settings_))
  , content_(std::move(content_))
  , areas_(std::move(areas_))
  , caption_(std::move(caption_))
{}

const std::int32_t story::ID;

void story::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "story");
    s.store_field("id", id_);
    s.store_field("sender_chat_id", sender_chat_id_);
    s.store_object_field("sender_id", static_cast<const BaseObject *>(sender_id_.get()));
    s.store_field("date", date_);
    s.store_field("is_being_sent", is_being_sent_);
    s.store_field("is_being_edited", is_being_edited_);
    s.store_field("is_edited", is_edited_);
    s.store_field("is_posted_to_chat_page", is_posted_to_chat_page_);
    s.store_field("is_visible_only_for_self", is_visible_only_for_self_);
    s.store_field("can_be_deleted", can_be_deleted_);
    s.store_field("can_be_edited", can_be_edited_);
    s.store_field("can_be_forwarded", can_be_forwarded_);
    s.store_field("can_be_replied", can_be_replied_);
    s.store_field("can_toggle_is_posted_to_chat_page", can_toggle_is_posted_to_chat_page_);
    s.store_field("can_get_statistics", can_get_statistics_);
    s.store_field("can_get_interactions", can_get_interactions_);
    s.store_field("has_expired_viewers", has_expired_viewers_);
    s.store_object_field("repost_info", static_cast<const BaseObject *>(repost_info_.get()));
    s.store_object_field("interaction_info", static_cast<const BaseObject *>(interaction_info_.get()));
    s.store_object_field("chosen_reaction_type", static_cast<const BaseObject *>(chosen_reaction_type_.get()));
    s.store_object_field("privacy_settings", static_cast<const BaseObject *>(privacy_settings_.get()));
    s.store_object_field("content", static_cast<const BaseObject *>(content_.get()));
    { s.store_vector_begin("areas", areas_.size()); for (const auto &_value : areas_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("caption", static_cast<const BaseObject *>(caption_.get()));
    s.store_class_end();
  }
}

storyArea::storyArea()
  : position_()
  , type_()
{}

storyArea::storyArea(object_ptr<storyAreaPosition> &&position_, object_ptr<StoryAreaType> &&type_)
  : position_(std::move(position_))
  , type_(std::move(type_))
{}

const std::int32_t storyArea::ID;

void storyArea::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyArea");
    s.store_object_field("position", static_cast<const BaseObject *>(position_.get()));
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

storyAreaPosition::storyAreaPosition()
  : x_percentage_()
  , y_percentage_()
  , width_percentage_()
  , height_percentage_()
  , rotation_angle_()
  , corner_radius_percentage_()
{}

storyAreaPosition::storyAreaPosition(double x_percentage_, double y_percentage_, double width_percentage_, double height_percentage_, double rotation_angle_, double corner_radius_percentage_)
  : x_percentage_(x_percentage_)
  , y_percentage_(y_percentage_)
  , width_percentage_(width_percentage_)
  , height_percentage_(height_percentage_)
  , rotation_angle_(rotation_angle_)
  , corner_radius_percentage_(corner_radius_percentage_)
{}

const std::int32_t storyAreaPosition::ID;

void storyAreaPosition::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyAreaPosition");
    s.store_field("x_percentage", x_percentage_);
    s.store_field("y_percentage", y_percentage_);
    s.store_field("width_percentage", width_percentage_);
    s.store_field("height_percentage", height_percentage_);
    s.store_field("rotation_angle", rotation_angle_);
    s.store_field("corner_radius_percentage", corner_radius_percentage_);
    s.store_class_end();
  }
}

storyAreaTypeLocation::storyAreaTypeLocation()
  : location_()
  , address_()
{}

storyAreaTypeLocation::storyAreaTypeLocation(object_ptr<location> &&location_, object_ptr<locationAddress> &&address_)
  : location_(std::move(location_))
  , address_(std::move(address_))
{}

const std::int32_t storyAreaTypeLocation::ID;

void storyAreaTypeLocation::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyAreaTypeLocation");
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_object_field("address", static_cast<const BaseObject *>(address_.get()));
    s.store_class_end();
  }
}

storyAreaTypeVenue::storyAreaTypeVenue()
  : venue_()
{}

storyAreaTypeVenue::storyAreaTypeVenue(object_ptr<venue> &&venue_)
  : venue_(std::move(venue_))
{}

const std::int32_t storyAreaTypeVenue::ID;

void storyAreaTypeVenue::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyAreaTypeVenue");
    s.store_object_field("venue", static_cast<const BaseObject *>(venue_.get()));
    s.store_class_end();
  }
}

storyAreaTypeSuggestedReaction::storyAreaTypeSuggestedReaction()
  : reaction_type_()
  , total_count_()
  , is_dark_()
  , is_flipped_()
{}

storyAreaTypeSuggestedReaction::storyAreaTypeSuggestedReaction(object_ptr<ReactionType> &&reaction_type_, int32 total_count_, bool is_dark_, bool is_flipped_)
  : reaction_type_(std::move(reaction_type_))
  , total_count_(total_count_)
  , is_dark_(is_dark_)
  , is_flipped_(is_flipped_)
{}

const std::int32_t storyAreaTypeSuggestedReaction::ID;

void storyAreaTypeSuggestedReaction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyAreaTypeSuggestedReaction");
    s.store_object_field("reaction_type", static_cast<const BaseObject *>(reaction_type_.get()));
    s.store_field("total_count", total_count_);
    s.store_field("is_dark", is_dark_);
    s.store_field("is_flipped", is_flipped_);
    s.store_class_end();
  }
}

storyAreaTypeMessage::storyAreaTypeMessage()
  : chat_id_()
  , message_id_()
{}

storyAreaTypeMessage::storyAreaTypeMessage(int53 chat_id_, int53 message_id_)
  : chat_id_(chat_id_)
  , message_id_(message_id_)
{}

const std::int32_t storyAreaTypeMessage::ID;

void storyAreaTypeMessage::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyAreaTypeMessage");
    s.store_field("chat_id", chat_id_);
    s.store_field("message_id", message_id_);
    s.store_class_end();
  }
}

storyAreaTypeLink::storyAreaTypeLink()
  : url_()
{}

storyAreaTypeLink::storyAreaTypeLink(string const &url_)
  : url_(url_)
{}

const std::int32_t storyAreaTypeLink::ID;

void storyAreaTypeLink::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyAreaTypeLink");
    s.store_field("url", url_);
    s.store_class_end();
  }
}

storyAreaTypeWeather::storyAreaTypeWeather()
  : temperature_()
  , emoji_()
  , background_color_()
{}

storyAreaTypeWeather::storyAreaTypeWeather(double temperature_, string const &emoji_, int32 background_color_)
  : temperature_(temperature_)
  , emoji_(emoji_)
  , background_color_(background_color_)
{}

const std::int32_t storyAreaTypeWeather::ID;

void storyAreaTypeWeather::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyAreaTypeWeather");
    s.store_field("temperature", temperature_);
    s.store_field("emoji", emoji_);
    s.store_field("background_color", background_color_);
    s.store_class_end();
  }
}

storyAreaTypeUpgradedGift::storyAreaTypeUpgradedGift()
  : gift_name_()
{}

storyAreaTypeUpgradedGift::storyAreaTypeUpgradedGift(string const &gift_name_)
  : gift_name_(gift_name_)
{}

const std::int32_t storyAreaTypeUpgradedGift::ID;

void storyAreaTypeUpgradedGift::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyAreaTypeUpgradedGift");
    s.store_field("gift_name", gift_name_);
    s.store_class_end();
  }
}

storyContentPhoto::storyContentPhoto()
  : photo_()
{}

storyContentPhoto::storyContentPhoto(object_ptr<photo> &&photo_)
  : photo_(std::move(photo_))
{}

const std::int32_t storyContentPhoto::ID;

void storyContentPhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyContentPhoto");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_class_end();
  }
}

storyContentVideo::storyContentVideo()
  : video_()
  , alternative_video_()
{}

storyContentVideo::storyContentVideo(object_ptr<storyVideo> &&video_, object_ptr<storyVideo> &&alternative_video_)
  : video_(std::move(video_))
  , alternative_video_(std::move(alternative_video_))
{}

const std::int32_t storyContentVideo::ID;

void storyContentVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyContentVideo");
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_object_field("alternative_video", static_cast<const BaseObject *>(alternative_video_.get()));
    s.store_class_end();
  }
}

storyContentUnsupported::storyContentUnsupported() {
}

const std::int32_t storyContentUnsupported::ID;

void storyContentUnsupported::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyContentUnsupported");
    s.store_class_end();
  }
}

storyFullId::storyFullId()
  : sender_chat_id_()
  , story_id_()
{}

storyFullId::storyFullId(int53 sender_chat_id_, int32 story_id_)
  : sender_chat_id_(sender_chat_id_)
  , story_id_(story_id_)
{}

const std::int32_t storyFullId::ID;

void storyFullId::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyFullId");
    s.store_field("sender_chat_id", sender_chat_id_);
    s.store_field("story_id", story_id_);
    s.store_class_end();
  }
}

storyInfo::storyInfo()
  : story_id_()
  , date_()
  , is_for_close_friends_()
{}

storyInfo::storyInfo(int32 story_id_, int32 date_, bool is_for_close_friends_)
  : story_id_(story_id_)
  , date_(date_)
  , is_for_close_friends_(is_for_close_friends_)
{}

const std::int32_t storyInfo::ID;

void storyInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyInfo");
    s.store_field("story_id", story_id_);
    s.store_field("date", date_);
    s.store_field("is_for_close_friends", is_for_close_friends_);
    s.store_class_end();
  }
}

storyInteraction::storyInteraction()
  : actor_id_()
  , interaction_date_()
  , block_list_()
  , type_()
{}

storyInteraction::storyInteraction(object_ptr<MessageSender> &&actor_id_, int32 interaction_date_, object_ptr<BlockList> &&block_list_, object_ptr<StoryInteractionType> &&type_)
  : actor_id_(std::move(actor_id_))
  , interaction_date_(interaction_date_)
  , block_list_(std::move(block_list_))
  , type_(std::move(type_))
{}

const std::int32_t storyInteraction::ID;

void storyInteraction::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyInteraction");
    s.store_object_field("actor_id", static_cast<const BaseObject *>(actor_id_.get()));
    s.store_field("interaction_date", interaction_date_);
    s.store_object_field("block_list", static_cast<const BaseObject *>(block_list_.get()));
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

storyInteractionInfo::storyInteractionInfo()
  : view_count_()
  , forward_count_()
  , reaction_count_()
  , recent_viewer_user_ids_()
{}

storyInteractionInfo::storyInteractionInfo(int32 view_count_, int32 forward_count_, int32 reaction_count_, array<int53> &&recent_viewer_user_ids_)
  : view_count_(view_count_)
  , forward_count_(forward_count_)
  , reaction_count_(reaction_count_)
  , recent_viewer_user_ids_(std::move(recent_viewer_user_ids_))
{}

const std::int32_t storyInteractionInfo::ID;

void storyInteractionInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyInteractionInfo");
    s.store_field("view_count", view_count_);
    s.store_field("forward_count", forward_count_);
    s.store_field("reaction_count", reaction_count_);
    { s.store_vector_begin("recent_viewer_user_ids", recent_viewer_user_ids_.size()); for (const auto &_value : recent_viewer_user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

storyInteractionTypeView::storyInteractionTypeView()
  : chosen_reaction_type_()
{}

storyInteractionTypeView::storyInteractionTypeView(object_ptr<ReactionType> &&chosen_reaction_type_)
  : chosen_reaction_type_(std::move(chosen_reaction_type_))
{}

const std::int32_t storyInteractionTypeView::ID;

void storyInteractionTypeView::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyInteractionTypeView");
    s.store_object_field("chosen_reaction_type", static_cast<const BaseObject *>(chosen_reaction_type_.get()));
    s.store_class_end();
  }
}

storyInteractionTypeForward::storyInteractionTypeForward()
  : message_()
{}

storyInteractionTypeForward::storyInteractionTypeForward(object_ptr<message> &&message_)
  : message_(std::move(message_))
{}

const std::int32_t storyInteractionTypeForward::ID;

void storyInteractionTypeForward::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyInteractionTypeForward");
    s.store_object_field("message", static_cast<const BaseObject *>(message_.get()));
    s.store_class_end();
  }
}

storyInteractionTypeRepost::storyInteractionTypeRepost()
  : story_()
{}

storyInteractionTypeRepost::storyInteractionTypeRepost(object_ptr<story> &&story_)
  : story_(std::move(story_))
{}

const std::int32_t storyInteractionTypeRepost::ID;

void storyInteractionTypeRepost::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyInteractionTypeRepost");
    s.store_object_field("story", static_cast<const BaseObject *>(story_.get()));
    s.store_class_end();
  }
}

storyInteractions::storyInteractions()
  : total_count_()
  , total_forward_count_()
  , total_reaction_count_()
  , interactions_()
  , next_offset_()
{}

storyInteractions::storyInteractions(int32 total_count_, int32 total_forward_count_, int32 total_reaction_count_, array<object_ptr<storyInteraction>> &&interactions_, string const &next_offset_)
  : total_count_(total_count_)
  , total_forward_count_(total_forward_count_)
  , total_reaction_count_(total_reaction_count_)
  , interactions_(std::move(interactions_))
  , next_offset_(next_offset_)
{}

const std::int32_t storyInteractions::ID;

void storyInteractions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyInteractions");
    s.store_field("total_count", total_count_);
    s.store_field("total_forward_count", total_forward_count_);
    s.store_field("total_reaction_count", total_reaction_count_);
    { s.store_vector_begin("interactions", interactions_.size()); for (const auto &_value : interactions_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_field("next_offset", next_offset_);
    s.store_class_end();
  }
}

storyListMain::storyListMain() {
}

const std::int32_t storyListMain::ID;

void storyListMain::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyListMain");
    s.store_class_end();
  }
}

storyListArchive::storyListArchive() {
}

const std::int32_t storyListArchive::ID;

void storyListArchive::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyListArchive");
    s.store_class_end();
  }
}

storyOriginPublicStory::storyOriginPublicStory()
  : chat_id_()
  , story_id_()
{}

storyOriginPublicStory::storyOriginPublicStory(int53 chat_id_, int32 story_id_)
  : chat_id_(chat_id_)
  , story_id_(story_id_)
{}

const std::int32_t storyOriginPublicStory::ID;

void storyOriginPublicStory::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyOriginPublicStory");
    s.store_field("chat_id", chat_id_);
    s.store_field("story_id", story_id_);
    s.store_class_end();
  }
}

storyOriginHiddenUser::storyOriginHiddenUser()
  : sender_name_()
{}

storyOriginHiddenUser::storyOriginHiddenUser(string const &sender_name_)
  : sender_name_(sender_name_)
{}

const std::int32_t storyOriginHiddenUser::ID;

void storyOriginHiddenUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyOriginHiddenUser");
    s.store_field("sender_name", sender_name_);
    s.store_class_end();
  }
}

storyPrivacySettingsEveryone::storyPrivacySettingsEveryone()
  : except_user_ids_()
{}

storyPrivacySettingsEveryone::storyPrivacySettingsEveryone(array<int53> &&except_user_ids_)
  : except_user_ids_(std::move(except_user_ids_))
{}

const std::int32_t storyPrivacySettingsEveryone::ID;

void storyPrivacySettingsEveryone::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyPrivacySettingsEveryone");
    { s.store_vector_begin("except_user_ids", except_user_ids_.size()); for (const auto &_value : except_user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

storyPrivacySettingsContacts::storyPrivacySettingsContacts()
  : except_user_ids_()
{}

storyPrivacySettingsContacts::storyPrivacySettingsContacts(array<int53> &&except_user_ids_)
  : except_user_ids_(std::move(except_user_ids_))
{}

const std::int32_t storyPrivacySettingsContacts::ID;

void storyPrivacySettingsContacts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyPrivacySettingsContacts");
    { s.store_vector_begin("except_user_ids", except_user_ids_.size()); for (const auto &_value : except_user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

storyPrivacySettingsCloseFriends::storyPrivacySettingsCloseFriends() {
}

const std::int32_t storyPrivacySettingsCloseFriends::ID;

void storyPrivacySettingsCloseFriends::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyPrivacySettingsCloseFriends");
    s.store_class_end();
  }
}

storyPrivacySettingsSelectedUsers::storyPrivacySettingsSelectedUsers()
  : user_ids_()
{}

storyPrivacySettingsSelectedUsers::storyPrivacySettingsSelectedUsers(array<int53> &&user_ids_)
  : user_ids_(std::move(user_ids_))
{}

const std::int32_t storyPrivacySettingsSelectedUsers::ID;

void storyPrivacySettingsSelectedUsers::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyPrivacySettingsSelectedUsers");
    { s.store_vector_begin("user_ids", user_ids_.size()); for (const auto &_value : user_ids_) { s.store_field("", _value); } s.store_class_end(); }
    s.store_class_end();
  }
}

storyRepostInfo::storyRepostInfo()
  : origin_()
  , is_content_modified_()
{}

storyRepostInfo::storyRepostInfo(object_ptr<StoryOrigin> &&origin_, bool is_content_modified_)
  : origin_(std::move(origin_))
  , is_content_modified_(is_content_modified_)
{}

const std::int32_t storyRepostInfo::ID;

void storyRepostInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyRepostInfo");
    s.store_object_field("origin", static_cast<const BaseObject *>(origin_.get()));
    s.store_field("is_content_modified", is_content_modified_);
    s.store_class_end();
  }
}

storyStatistics::storyStatistics()
  : story_interaction_graph_()
  , story_reaction_graph_()
{}

storyStatistics::storyStatistics(object_ptr<StatisticalGraph> &&story_interaction_graph_, object_ptr<StatisticalGraph> &&story_reaction_graph_)
  : story_interaction_graph_(std::move(story_interaction_graph_))
  , story_reaction_graph_(std::move(story_reaction_graph_))
{}

const std::int32_t storyStatistics::ID;

void storyStatistics::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyStatistics");
    s.store_object_field("story_interaction_graph", static_cast<const BaseObject *>(story_interaction_graph_.get()));
    s.store_object_field("story_reaction_graph", static_cast<const BaseObject *>(story_reaction_graph_.get()));
    s.store_class_end();
  }
}

storyVideo::storyVideo()
  : duration_()
  , width_()
  , height_()
  , has_stickers_()
  , is_animation_()
  , minithumbnail_()
  , thumbnail_()
  , preload_prefix_size_()
  , cover_frame_timestamp_()
  , video_()
{}

storyVideo::storyVideo(double duration_, int32 width_, int32 height_, bool has_stickers_, bool is_animation_, object_ptr<minithumbnail> &&minithumbnail_, object_ptr<thumbnail> &&thumbnail_, int32 preload_prefix_size_, double cover_frame_timestamp_, object_ptr<file> &&video_)
  : duration_(duration_)
  , width_(width_)
  , height_(height_)
  , has_stickers_(has_stickers_)
  , is_animation_(is_animation_)
  , minithumbnail_(std::move(minithumbnail_))
  , thumbnail_(std::move(thumbnail_))
  , preload_prefix_size_(preload_prefix_size_)
  , cover_frame_timestamp_(cover_frame_timestamp_)
  , video_(std::move(video_))
{}

const std::int32_t storyVideo::ID;

void storyVideo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "storyVideo");
    s.store_field("duration", duration_);
    s.store_field("width", width_);
    s.store_field("height", height_);
    s.store_field("has_stickers", has_stickers_);
    s.store_field("is_animation", is_animation_);
    s.store_object_field("minithumbnail", static_cast<const BaseObject *>(minithumbnail_.get()));
    s.store_object_field("thumbnail", static_cast<const BaseObject *>(thumbnail_.get()));
    s.store_field("preload_prefix_size", preload_prefix_size_);
    s.store_field("cover_frame_timestamp", cover_frame_timestamp_);
    s.store_object_field("video", static_cast<const BaseObject *>(video_.get()));
    s.store_class_end();
  }
}

suggestedActionEnableArchiveAndMuteNewChats::suggestedActionEnableArchiveAndMuteNewChats() {
}

const std::int32_t suggestedActionEnableArchiveAndMuteNewChats::ID;

void suggestedActionEnableArchiveAndMuteNewChats::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionEnableArchiveAndMuteNewChats");
    s.store_class_end();
  }
}

suggestedActionCheckPassword::suggestedActionCheckPassword() {
}

const std::int32_t suggestedActionCheckPassword::ID;

void suggestedActionCheckPassword::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionCheckPassword");
    s.store_class_end();
  }
}

suggestedActionCheckPhoneNumber::suggestedActionCheckPhoneNumber() {
}

const std::int32_t suggestedActionCheckPhoneNumber::ID;

void suggestedActionCheckPhoneNumber::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionCheckPhoneNumber");
    s.store_class_end();
  }
}

suggestedActionViewChecksHint::suggestedActionViewChecksHint() {
}

const std::int32_t suggestedActionViewChecksHint::ID;

void suggestedActionViewChecksHint::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionViewChecksHint");
    s.store_class_end();
  }
}

suggestedActionConvertToBroadcastGroup::suggestedActionConvertToBroadcastGroup()
  : supergroup_id_()
{}

suggestedActionConvertToBroadcastGroup::suggestedActionConvertToBroadcastGroup(int53 supergroup_id_)
  : supergroup_id_(supergroup_id_)
{}

const std::int32_t suggestedActionConvertToBroadcastGroup::ID;

void suggestedActionConvertToBroadcastGroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionConvertToBroadcastGroup");
    s.store_field("supergroup_id", supergroup_id_);
    s.store_class_end();
  }
}

suggestedActionSetPassword::suggestedActionSetPassword()
  : authorization_delay_()
{}

suggestedActionSetPassword::suggestedActionSetPassword(int32 authorization_delay_)
  : authorization_delay_(authorization_delay_)
{}

const std::int32_t suggestedActionSetPassword::ID;

void suggestedActionSetPassword::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionSetPassword");
    s.store_field("authorization_delay", authorization_delay_);
    s.store_class_end();
  }
}

suggestedActionUpgradePremium::suggestedActionUpgradePremium() {
}

const std::int32_t suggestedActionUpgradePremium::ID;

void suggestedActionUpgradePremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionUpgradePremium");
    s.store_class_end();
  }
}

suggestedActionRestorePremium::suggestedActionRestorePremium() {
}

const std::int32_t suggestedActionRestorePremium::ID;

void suggestedActionRestorePremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionRestorePremium");
    s.store_class_end();
  }
}

suggestedActionSubscribeToAnnualPremium::suggestedActionSubscribeToAnnualPremium() {
}

const std::int32_t suggestedActionSubscribeToAnnualPremium::ID;

void suggestedActionSubscribeToAnnualPremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionSubscribeToAnnualPremium");
    s.store_class_end();
  }
}

suggestedActionGiftPremiumForChristmas::suggestedActionGiftPremiumForChristmas() {
}

const std::int32_t suggestedActionGiftPremiumForChristmas::ID;

void suggestedActionGiftPremiumForChristmas::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionGiftPremiumForChristmas");
    s.store_class_end();
  }
}

suggestedActionSetBirthdate::suggestedActionSetBirthdate() {
}

const std::int32_t suggestedActionSetBirthdate::ID;

void suggestedActionSetBirthdate::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionSetBirthdate");
    s.store_class_end();
  }
}

suggestedActionSetProfilePhoto::suggestedActionSetProfilePhoto() {
}

const std::int32_t suggestedActionSetProfilePhoto::ID;

void suggestedActionSetProfilePhoto::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionSetProfilePhoto");
    s.store_class_end();
  }
}

suggestedActionExtendPremium::suggestedActionExtendPremium()
  : manage_premium_subscription_url_()
{}

suggestedActionExtendPremium::suggestedActionExtendPremium(string const &manage_premium_subscription_url_)
  : manage_premium_subscription_url_(manage_premium_subscription_url_)
{}

const std::int32_t suggestedActionExtendPremium::ID;

void suggestedActionExtendPremium::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionExtendPremium");
    s.store_field("manage_premium_subscription_url", manage_premium_subscription_url_);
    s.store_class_end();
  }
}

suggestedActionExtendStarSubscriptions::suggestedActionExtendStarSubscriptions() {
}

const std::int32_t suggestedActionExtendStarSubscriptions::ID;

void suggestedActionExtendStarSubscriptions::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "suggestedActionExtendStarSubscriptions");
    s.store_class_end();
  }
}

supergroup::supergroup()
  : id_()
  , usernames_()
  , date_()
  , status_()
  , member_count_()
  , boost_level_()
  , has_linked_chat_()
  , has_location_()
  , sign_messages_()
  , show_message_sender_()
  , join_to_send_messages_()
  , join_by_request_()
  , is_slow_mode_enabled_()
  , is_channel_()
  , is_broadcast_group_()
  , is_forum_()
  , verification_status_()
  , has_sensitive_content_()
  , restriction_reason_()
  , has_active_stories_()
  , has_unread_active_stories_()
{}

supergroup::supergroup(int53 id_, object_ptr<usernames> &&usernames_, int32 date_, object_ptr<ChatMemberStatus> &&status_, int32 member_count_, int32 boost_level_, bool has_linked_chat_, bool has_location_, bool sign_messages_, bool show_message_sender_, bool join_to_send_messages_, bool join_by_request_, bool is_slow_mode_enabled_, bool is_channel_, bool is_broadcast_group_, bool is_forum_, object_ptr<verificationStatus> &&verification_status_, bool has_sensitive_content_, string const &restriction_reason_, bool has_active_stories_, bool has_unread_active_stories_)
  : id_(id_)
  , usernames_(std::move(usernames_))
  , date_(date_)
  , status_(std::move(status_))
  , member_count_(member_count_)
  , boost_level_(boost_level_)
  , has_linked_chat_(has_linked_chat_)
  , has_location_(has_location_)
  , sign_messages_(sign_messages_)
  , show_message_sender_(show_message_sender_)
  , join_to_send_messages_(join_to_send_messages_)
  , join_by_request_(join_by_request_)
  , is_slow_mode_enabled_(is_slow_mode_enabled_)
  , is_channel_(is_channel_)
  , is_broadcast_group_(is_broadcast_group_)
  , is_forum_(is_forum_)
  , verification_status_(std::move(verification_status_))
  , has_sensitive_content_(has_sensitive_content_)
  , restriction_reason_(restriction_reason_)
  , has_active_stories_(has_active_stories_)
  , has_unread_active_stories_(has_unread_active_stories_)
{}

const std::int32_t supergroup::ID;

void supergroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "supergroup");
    s.store_field("id", id_);
    s.store_object_field("usernames", static_cast<const BaseObject *>(usernames_.get()));
    s.store_field("date", date_);
    s.store_object_field("status", static_cast<const BaseObject *>(status_.get()));
    s.store_field("member_count", member_count_);
    s.store_field("boost_level", boost_level_);
    s.store_field("has_linked_chat", has_linked_chat_);
    s.store_field("has_location", has_location_);
    s.store_field("sign_messages", sign_messages_);
    s.store_field("show_message_sender", show_message_sender_);
    s.store_field("join_to_send_messages", join_to_send_messages_);
    s.store_field("join_by_request", join_by_request_);
    s.store_field("is_slow_mode_enabled", is_slow_mode_enabled_);
    s.store_field("is_channel", is_channel_);
    s.store_field("is_broadcast_group", is_broadcast_group_);
    s.store_field("is_forum", is_forum_);
    s.store_object_field("verification_status", static_cast<const BaseObject *>(verification_status_.get()));
    s.store_field("has_sensitive_content", has_sensitive_content_);
    s.store_field("restriction_reason", restriction_reason_);
    s.store_field("has_active_stories", has_active_stories_);
    s.store_field("has_unread_active_stories", has_unread_active_stories_);
    s.store_class_end();
  }
}

supergroupFullInfo::supergroupFullInfo()
  : photo_()
  , description_()
  , member_count_()
  , administrator_count_()
  , restricted_count_()
  , banned_count_()
  , linked_chat_id_()
  , slow_mode_delay_()
  , slow_mode_delay_expires_in_()
  , can_enable_paid_reaction_()
  , can_get_members_()
  , has_hidden_members_()
  , can_hide_members_()
  , can_set_sticker_set_()
  , can_set_location_()
  , can_get_statistics_()
  , can_get_revenue_statistics_()
  , can_get_star_revenue_statistics_()
  , can_send_gift_()
  , can_toggle_aggressive_anti_spam_()
  , is_all_history_available_()
  , can_have_sponsored_messages_()
  , has_aggressive_anti_spam_enabled_()
  , has_paid_media_allowed_()
  , has_pinned_stories_()
  , gift_count_()
  , my_boost_count_()
  , unrestrict_boost_count_()
  , sticker_set_id_()
  , custom_emoji_sticker_set_id_()
  , location_()
  , invite_link_()
  , bot_commands_()
  , bot_verification_()
  , upgraded_from_basic_group_id_()
  , upgraded_from_max_message_id_()
{}

supergroupFullInfo::supergroupFullInfo(object_ptr<chatPhoto> &&photo_, string const &description_, int32 member_count_, int32 administrator_count_, int32 restricted_count_, int32 banned_count_, int53 linked_chat_id_, int32 slow_mode_delay_, double slow_mode_delay_expires_in_, bool can_enable_paid_reaction_, bool can_get_members_, bool has_hidden_members_, bool can_hide_members_, bool can_set_sticker_set_, bool can_set_location_, bool can_get_statistics_, bool can_get_revenue_statistics_, bool can_get_star_revenue_statistics_, bool can_send_gift_, bool can_toggle_aggressive_anti_spam_, bool is_all_history_available_, bool can_have_sponsored_messages_, bool has_aggressive_anti_spam_enabled_, bool has_paid_media_allowed_, bool has_pinned_stories_, int32 gift_count_, int32 my_boost_count_, int32 unrestrict_boost_count_, int64 sticker_set_id_, int64 custom_emoji_sticker_set_id_, object_ptr<chatLocation> &&location_, object_ptr<chatInviteLink> &&invite_link_, array<object_ptr<botCommands>> &&bot_commands_, object_ptr<botVerification> &&bot_verification_, int53 upgraded_from_basic_group_id_, int53 upgraded_from_max_message_id_)
  : photo_(std::move(photo_))
  , description_(description_)
  , member_count_(member_count_)
  , administrator_count_(administrator_count_)
  , restricted_count_(restricted_count_)
  , banned_count_(banned_count_)
  , linked_chat_id_(linked_chat_id_)
  , slow_mode_delay_(slow_mode_delay_)
  , slow_mode_delay_expires_in_(slow_mode_delay_expires_in_)
  , can_enable_paid_reaction_(can_enable_paid_reaction_)
  , can_get_members_(can_get_members_)
  , has_hidden_members_(has_hidden_members_)
  , can_hide_members_(can_hide_members_)
  , can_set_sticker_set_(can_set_sticker_set_)
  , can_set_location_(can_set_location_)
  , can_get_statistics_(can_get_statistics_)
  , can_get_revenue_statistics_(can_get_revenue_statistics_)
  , can_get_star_revenue_statistics_(can_get_star_revenue_statistics_)
  , can_send_gift_(can_send_gift_)
  , can_toggle_aggressive_anti_spam_(can_toggle_aggressive_anti_spam_)
  , is_all_history_available_(is_all_history_available_)
  , can_have_sponsored_messages_(can_have_sponsored_messages_)
  , has_aggressive_anti_spam_enabled_(has_aggressive_anti_spam_enabled_)
  , has_paid_media_allowed_(has_paid_media_allowed_)
  , has_pinned_stories_(has_pinned_stories_)
  , gift_count_(gift_count_)
  , my_boost_count_(my_boost_count_)
  , unrestrict_boost_count_(unrestrict_boost_count_)
  , sticker_set_id_(sticker_set_id_)
  , custom_emoji_sticker_set_id_(custom_emoji_sticker_set_id_)
  , location_(std::move(location_))
  , invite_link_(std::move(invite_link_))
  , bot_commands_(std::move(bot_commands_))
  , bot_verification_(std::move(bot_verification_))
  , upgraded_from_basic_group_id_(upgraded_from_basic_group_id_)
  , upgraded_from_max_message_id_(upgraded_from_max_message_id_)
{}

const std::int32_t supergroupFullInfo::ID;

void supergroupFullInfo::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "supergroupFullInfo");
    s.store_object_field("photo", static_cast<const BaseObject *>(photo_.get()));
    s.store_field("description", description_);
    s.store_field("member_count", member_count_);
    s.store_field("administrator_count", administrator_count_);
    s.store_field("restricted_count", restricted_count_);
    s.store_field("banned_count", banned_count_);
    s.store_field("linked_chat_id", linked_chat_id_);
    s.store_field("slow_mode_delay", slow_mode_delay_);
    s.store_field("slow_mode_delay_expires_in", slow_mode_delay_expires_in_);
    s.store_field("can_enable_paid_reaction", can_enable_paid_reaction_);
    s.store_field("can_get_members", can_get_members_);
    s.store_field("has_hidden_members", has_hidden_members_);
    s.store_field("can_hide_members", can_hide_members_);
    s.store_field("can_set_sticker_set", can_set_sticker_set_);
    s.store_field("can_set_location", can_set_location_);
    s.store_field("can_get_statistics", can_get_statistics_);
    s.store_field("can_get_revenue_statistics", can_get_revenue_statistics_);
    s.store_field("can_get_star_revenue_statistics", can_get_star_revenue_statistics_);
    s.store_field("can_send_gift", can_send_gift_);
    s.store_field("can_toggle_aggressive_anti_spam", can_toggle_aggressive_anti_spam_);
    s.store_field("is_all_history_available", is_all_history_available_);
    s.store_field("can_have_sponsored_messages", can_have_sponsored_messages_);
    s.store_field("has_aggressive_anti_spam_enabled", has_aggressive_anti_spam_enabled_);
    s.store_field("has_paid_media_allowed", has_paid_media_allowed_);
    s.store_field("has_pinned_stories", has_pinned_stories_);
    s.store_field("gift_count", gift_count_);
    s.store_field("my_boost_count", my_boost_count_);
    s.store_field("unrestrict_boost_count", unrestrict_boost_count_);
    s.store_field("sticker_set_id", sticker_set_id_);
    s.store_field("custom_emoji_sticker_set_id", custom_emoji_sticker_set_id_);
    s.store_object_field("location", static_cast<const BaseObject *>(location_.get()));
    s.store_object_field("invite_link", static_cast<const BaseObject *>(invite_link_.get()));
    { s.store_vector_begin("bot_commands", bot_commands_.size()); for (const auto &_value : bot_commands_) { s.store_object_field("", static_cast<const BaseObject *>(_value.get())); } s.store_class_end(); }
    s.store_object_field("bot_verification", static_cast<const BaseObject *>(bot_verification_.get()));
    s.store_field("upgraded_from_basic_group_id", upgraded_from_basic_group_id_);
    s.store_field("upgraded_from_max_message_id", upgraded_from_max_message_id_);
    s.store_class_end();
  }
}

supergroupMembersFilterRecent::supergroupMembersFilterRecent() {
}

const std::int32_t supergroupMembersFilterRecent::ID;

void supergroupMembersFilterRecent::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "supergroupMembersFilterRecent");
    s.store_class_end();
  }
}

supergroupMembersFilterContacts::supergroupMembersFilterContacts()
  : query_()
{}

supergroupMembersFilterContacts::supergroupMembersFilterContacts(string const &query_)
  : query_(query_)
{}

const std::int32_t supergroupMembersFilterContacts::ID;

void supergroupMembersFilterContacts::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "supergroupMembersFilterContacts");
    s.store_field("query", query_);
    s.store_class_end();
  }
}

supergroupMembersFilterAdministrators::supergroupMembersFilterAdministrators() {
}

const std::int32_t supergroupMembersFilterAdministrators::ID;

void supergroupMembersFilterAdministrators::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "supergroupMembersFilterAdministrators");
    s.store_class_end();
  }
}

supergroupMembersFilterSearch::supergroupMembersFilterSearch()
  : query_()
{}

supergroupMembersFilterSearch::supergroupMembersFilterSearch(string const &query_)
  : query_(query_)
{}

const std::int32_t supergroupMembersFilterSearch::ID;

void supergroupMembersFilterSearch::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "supergroupMembersFilterSearch");
    s.store_field("query", query_);
    s.store_class_end();
  }
}

supergroupMembersFilterRestricted::supergroupMembersFilterRestricted()
  : query_()
{}

supergroupMembersFilterRestricted::supergroupMembersFilterRestricted(string const &query_)
  : query_(query_)
{}

const std::int32_t supergroupMembersFilterRestricted::ID;

void supergroupMembersFilterRestricted::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "supergroupMembersFilterRestricted");
    s.store_field("query", query_);
    s.store_class_end();
  }
}

supergroupMembersFilterBanned::supergroupMembersFilterBanned()
  : query_()
{}

supergroupMembersFilterBanned::supergroupMembersFilterBanned(string const &query_)
  : query_(query_)
{}

const std::int32_t supergroupMembersFilterBanned::ID;

void supergroupMembersFilterBanned::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "supergroupMembersFilterBanned");
    s.store_field("query", query_);
    s.store_class_end();
  }
}

supergroupMembersFilterMention::supergroupMembersFilterMention()
  : query_()
  , message_thread_id_()
{}

supergroupMembersFilterMention::supergroupMembersFilterMention(string const &query_, int53 message_thread_id_)
  : query_(query_)
  , message_thread_id_(message_thread_id_)
{}

const std::int32_t supergroupMembersFilterMention::ID;

void supergroupMembersFilterMention::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "supergroupMembersFilterMention");
    s.store_field("query", query_);
    s.store_field("message_thread_id", message_thread_id_);
    s.store_class_end();
  }
}

supergroupMembersFilterBots::supergroupMembersFilterBots() {
}

const std::int32_t supergroupMembersFilterBots::ID;

void supergroupMembersFilterBots::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "supergroupMembersFilterBots");
    s.store_class_end();
  }
}

tMeUrl::tMeUrl()
  : url_()
  , type_()
{}

tMeUrl::tMeUrl(string const &url_, object_ptr<TMeUrlType> &&type_)
  : url_(url_)
  , type_(std::move(type_))
{}

const std::int32_t tMeUrl::ID;

void tMeUrl::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "tMeUrl");
    s.store_field("url", url_);
    s.store_object_field("type", static_cast<const BaseObject *>(type_.get()));
    s.store_class_end();
  }
}

tMeUrlTypeUser::tMeUrlTypeUser()
  : user_id_()
{}

tMeUrlTypeUser::tMeUrlTypeUser(int53 user_id_)
  : user_id_(user_id_)
{}

const std::int32_t tMeUrlTypeUser::ID;

void tMeUrlTypeUser::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "tMeUrlTypeUser");
    s.store_field("user_id", user_id_);
    s.store_class_end();
  }
}

tMeUrlTypeSupergroup::tMeUrlTypeSupergroup()
  : supergroup_id_()
{}

tMeUrlTypeSupergroup::tMeUrlTypeSupergroup(int53 supergroup_id_)
  : supergroup_id_(supergroup_id_)
{}

const std::int32_t tMeUrlTypeSupergroup::ID;

void tMeUrlTypeSupergroup::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "tMeUrlTypeSupergroup");
    s.store_field("supergroup_id", supergroup_id_);
    s.store_class_end();
  }
}

tMeUrlTypeChatInvite::tMeUrlTypeChatInvite()
  : info_()
{}

tMeUrlTypeChatInvite::tMeUrlTypeChatInvite(object_ptr<chatInviteLinkInfo> &&info_)
  : info_(std::move(info_))
{}

const std::int32_t tMeUrlTypeChatInvite::ID;

void tMeUrlTypeChatInvite::store(TlStorerToString &s, const char *field_name) const {
  if (!LOG_IS_STRIPPED(ERROR)) {
    s.store_class_begin(field_name, "tMeUrlTypeChatInvite");
    s.store_object_field("info", static_cast<const BaseObject *>(info_.get()));
    s.store_class_end();
  }
}

tMeUrlTypeStickerSet::tMeUrlTypeStickerSet()
  : sticker_set_id_()
{}

tMeUrlTypeStickerSet::tMeUrlTypeStickerSet(int64 sticker_set_id_)
  : sticker_set_id_(sticker_set_id_)
{}

const std::int32_t tMe